import _isNil from "lodash/isNil";
import _assign from "lodash/assign";
import { Helpers, LabelHelpers, Data, Domain, Scale } from "victory-core";

var getCalculatedValues = function (props) {
  var data = Data.getData(props);

  if (data.length < 2) {
    data = [];
  }

  var range = {
    x: Helpers.getRange(props, "x"),
    y: Helpers.getRange(props, "y")
  };
  var domain = {
    x: Domain.getDomain(props, "x"),
    y: Domain.getDomain(props, "y")
  };
  var scale = {
    x: Scale.getBaseScale(props, "x").domain(domain.x).range(props.horizontal ? range.y : range.x),
    y: Scale.getBaseScale(props, "y").domain(domain.y).range(props.horizontal ? range.x : range.y)
  };
  var origin = props.polar ? props.origin || Helpers.getPolarOrigin(props) : undefined;
  var defaultStyles = Helpers.getDefaultStyles(props, "line");
  var style = Helpers.getStyles(props.style, defaultStyles);
  return {
    domain: domain,
    data: data,
    scale: scale,
    style: style,
    origin: origin
  };
};

var getBaseProps = function (props, fallbackProps) {
  var modifiedProps = Helpers.modifyProps(props, fallbackProps, "line");
  props = _assign({}, modifiedProps, getCalculatedValues(modifiedProps));
  var _props = props,
      data = _props.data,
      domain = _props.domain,
      events = _props.events,
      groupComponent = _props.groupComponent,
      height = _props.height,
      horizontal = _props.horizontal,
      interpolation = _props.interpolation,
      origin = _props.origin,
      padding = _props.padding,
      polar = _props.polar,
      scale = _props.scale,
      sharedEvents = _props.sharedEvents,
      standalone = _props.standalone,
      style = _props.style,
      theme = _props.theme,
      width = _props.width,
      labels = _props.labels,
      name = _props.name;
  var initialChildProps = {
    parent: {
      style: style.parent,
      scale: scale,
      data: data,
      height: height,
      width: width,
      name: name,
      domain: domain,
      standalone: standalone,
      polar: polar,
      origin: origin,
      padding: padding,
      horizontal: horizontal
    },
    all: {
      data: {
        horizontal: horizontal,
        polar: polar,
        origin: origin,
        scale: scale,
        data: data,
        interpolation: interpolation,
        groupComponent: groupComponent,
        style: style.data,
        theme: theme
      }
    }
  };
  return data.reduce(function (childProps, datum, index) {
    var text = LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      var eventKey = !_isNil(datum.eventKey) ? datum.eventKey : index;
      childProps[eventKey] = {
        labels: LabelHelpers.getProps(props, index)
      };
    }

    return childProps;
  }, initialChildProps);
};

export { getBaseProps };