import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import defaults from 'lodash/defaults';
import { VictoryLabel } from 'victory-core';
import { ChartCommonStyles } from '../ChartTheme';
export var ChartLabelDirection;
(function (ChartLabelDirection) {
    ChartLabelDirection["rtl"] = "rtl";
    ChartLabelDirection["ltr"] = "ltr";
    ChartLabelDirection["inherit"] = "inherit";
})(ChartLabelDirection || (ChartLabelDirection = {}));
export var ChartLabelPlacement;
(function (ChartLabelPlacement) {
    ChartLabelPlacement["parallel"] = "parallel";
    ChartLabelPlacement["perpendicular"] = "perpendicular";
    ChartLabelPlacement["vertical"] = "vertical";
})(ChartLabelPlacement || (ChartLabelPlacement = {}));
export const ChartLabel = (_a) => {
    var { style, textAnchor } = _a, rest = __rest(_a, ["style", "textAnchor"]);
    const applyDefaultStyle = (customStyle) => defaults(Object.assign(Object.assign({}, customStyle), { textAnchor // textAnchor prop must override given theme styles
     }), {
        fontFamily: ChartCommonStyles.label.fontFamily,
        fontSize: ChartCommonStyles.label.fontSize,
        letterSpacing: ChartCommonStyles.label.letterSpacing
    });
    const newStyle = Array.isArray(style) ? style.map(applyDefaultStyle) : applyDefaultStyle(style);
    return React.createElement(VictoryLabel, Object.assign({ style: newStyle, textAnchor: textAnchor }, rest));
};
ChartLabel.displayName = 'ChartLabel';
// Note: VictoryLabel.role must be hoisted
hoistNonReactStatics(ChartLabel, VictoryLabel);
//# sourceMappingURL=ChartLabel.js.map