"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmIcon = exports.AcmIconVariant = void 0;
var react_1 = __importDefault(require("react"));
var Icons_1 = require("./Icons");
var AcmIconVariant;
(function (AcmIconVariant) {
    AcmIconVariant["template"] = "template";
    AcmIconVariant["visibilityon"] = "visibilityon";
    AcmIconVariant["visibilityoff"] = "visibilityoff";
    AcmIconVariant["brokenlink"] = "brokenlink";
    AcmIconVariant["redhat"] = "redhat";
    AcmIconVariant["aws"] = "aws";
    AcmIconVariant["gcp"] = "gcp";
    AcmIconVariant["azure"] = "azure";
    AcmIconVariant["ibm"] = "ibm";
    AcmIconVariant["baremetal"] = "baremetal";
    AcmIconVariant["vmware"] = "vmware";
    AcmIconVariant["cloud"] = "cloud";
})(AcmIconVariant = exports.AcmIconVariant || (exports.AcmIconVariant = {}));
// https://www.patternfly.org/v4/guidelines/icons
function AcmIcon(props) {
    switch (props.icon) {
        case AcmIconVariant.template:
            return react_1.default.createElement(Icons_1.AcmTemplateIcon, null);
        case AcmIconVariant.visibilityoff:
            return react_1.default.createElement(Icons_1.AcmVisibilityOffIcon, null);
        case AcmIconVariant.visibilityon:
            return react_1.default.createElement(Icons_1.AcmVisibilityOnIcon, null);
        case AcmIconVariant.brokenlink:
            return react_1.default.createElement(Icons_1.BrokenLinkIcon, null);
        case AcmIconVariant.redhat:
            return react_1.default.createElement(Icons_1.RedHatIcon, null);
        case AcmIconVariant.aws:
            return react_1.default.createElement(Icons_1.AWSIcon, null);
        case AcmIconVariant.gcp:
            return react_1.default.createElement(Icons_1.GCPIcon, null);
        case AcmIconVariant.azure:
            return react_1.default.createElement(Icons_1.AzureIcon, null);
        case AcmIconVariant.ibm:
            return react_1.default.createElement(Icons_1.IBMCloudIcon, null);
        case AcmIconVariant.baremetal:
            return react_1.default.createElement(Icons_1.BareMetalIcon, null);
        case AcmIconVariant.vmware:
            return react_1.default.createElement(Icons_1.VMWareIcon, null);
        case AcmIconVariant.cloud:
            return react_1.default.createElement(Icons_1.CloudIcon, null);
    }
}
exports.AcmIcon = AcmIcon;
//# sourceMappingURL=AcmIcons.js.map