import request = require('request');
import { KubeConfig } from './config';
export interface WatchUpdate {
    type: string;
    object: object;
}
export interface Response {
    statusCode: number;
    statusMessage: string;
}
export interface RequestInterface {
    webRequest(opts: request.Options, callback: (err: object | null, response: Response | null, body: object | null) => void): any;
}
export declare class DefaultRequest implements RequestInterface {
    webRequest(opts: request.Options, callback: (err: object | null, response: Response | null, body: object | null) => void): any;
}
export declare class Watch {
    static SERVER_SIDE_CLOSE: object;
    config: KubeConfig;
    private readonly requestImpl;
    constructor(config: KubeConfig, requestImpl?: RequestInterface);
    watch(path: string, queryParams: any, callback: (phase: string, apiObj: any, watchObj?: any) => void, done: () => void, error: (err: any) => void): Promise<any>;
}
