"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmMultiSelect = void 0;
var react_core_1 = require("@patternfly/react-core");
var help_icon_1 = __importDefault(require("@patternfly/react-icons/dist/js/icons/help-icon"));
var react_1 = __importStar(require("react"));
var AcmForm_1 = require("../AcmForm/AcmForm");
function AcmMultiSelect(props) {
    var _a = react_1.useState(false), open = _a[0], setOpen = _a[1];
    var formContext = AcmForm_1.useFormContext();
    var _b = react_1.useState(), validated = _b[0], setValidated = _b[1];
    var _c = react_1.useState(), error = _c[0], setError = _c[1];
    var validation = props.validation, labelHelp = props.labelHelp, labelHelpTitle = props.labelHelpTitle, helperText = props.helperText, isRequired = props.isRequired, onChange = props.onChange, value = props.value, placeholder = props.placeholder, selectProps = __rest(props, ["validation", "labelHelp", "labelHelpTitle", "helperText", "isRequired", "onChange", "value", "placeholder"]);
    var _d = react_1.useState(props.placeholder), placeholderText = _d[0], setPlaceholderText = _d[1];
    react_1.useLayoutEffect(function () {
        var error = undefined;
        /* istanbul ignore else */
        if (props.hidden !== true) {
            if (isRequired) {
                if (props.value === undefined) {
                    error = 'Required';
                }
                else if (props.value.length === 0) {
                    error = 'Required';
                }
            }
            if (!error && validation) {
                error = validation(props.value);
            }
        }
        setError(error);
        if (formContext.validate) {
            setValidated(error ? 'error' : undefined);
        }
        formContext.setError(props.id, error);
    }, [props.value, props.hidden]);
    react_1.useLayoutEffect(function () {
        setValidated(error ? 'error' : undefined);
    }, [formContext.validate]);
    react_1.useLayoutEffect(function () {
        if (value === undefined || value.length === 0) {
            setPlaceholderText(react_1.default.createElement("span", { style: { color: '#666' } }, placeholder));
        }
        else {
            var selectedItems = react_1.default.Children.map(props.children, function (child) {
                var option = child;
                if (value.includes(option.props.value))
                    return option.props.children;
                return undefined;
            });
            /* istanbul ignore if */
            if (selectedItems === undefined) {
                setPlaceholderText(react_1.default.createElement("span", { style: { color: '#666' } }, placeholder));
            }
            else {
                setPlaceholderText(selectedItems
                    .filter(function (item) { return item !== undefined; })
                    .map(function (node, index) {
                    if (index === 0) {
                        return react_1.default.createElement(react_1.Fragment, { key: "" + index }, node);
                    }
                    else {
                        return (react_1.default.createElement(react_1.Fragment, { key: "" + index },
                            react_1.default.createElement("span", null, ", "),
                            node));
                    }
                }));
            }
        }
    }, [value]);
    return (react_1.default.createElement(react_core_1.FormGroup, { id: props.id + "-label", label: props.label, isRequired: isRequired, fieldId: props.id, hidden: props.hidden, helperTextInvalid: error, validated: validated, helperText: helperText, labelIcon: 
        /* istanbul ignore next */
        props.labelHelp ? (react_1.default.createElement(react_core_1.Popover, { id: props.id + "-label-help-popover", headerContent: labelHelpTitle, bodyContent: labelHelp },
            react_1.default.createElement("button", { id: props.id + "-label-help-button", "aria-label": "More info", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" },
                react_1.default.createElement(help_icon_1.default, { noVerticalAlign: true })))) : (react_1.default.createElement(react_1.Fragment, null)) },
        react_1.default.createElement(react_core_1.Select, __assign({ variant: react_core_1.SelectVariant.checkbox, "aria-labelledby": props.id + "-label" }, selectProps, { isOpen: open, onToggle: function () {
                setOpen(!open);
            }, selections: value, onSelect: function (_event, selection) {
                if (value === undefined) {
                    onChange([selection]);
                }
                else {
                    if (value.includes(selection)) {
                        onChange(value.filter(function (item) { return item !== selection; }));
                    }
                    else {
                        onChange(__spreadArrays(value, [selection]));
                    }
                }
            }, onClear: !props.isRequired
                ? function () {
                    onChange(undefined);
                }
                : undefined, placeholderText: placeholderText, isDisabled: props.isDisabled || formContext.isReadOnly })),
        validated === 'error' ? (react_1.default.createElement("div", { style: { borderTop: '1.75px solid red', paddingBottom: '6px' } })) : (react_1.default.createElement(react_1.Fragment, null))));
}
exports.AcmMultiSelect = AcmMultiSelect;
//# sourceMappingURL=AcmMultiSelect.js.map