"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmBreadcrumb = exports.AcmPageCard = exports.AcmPageHeader = exports.AcmPage = void 0;
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var react_1 = __importDefault(require("react"));
var react_router_dom_1 = require("react-router-dom");
var AcmDrawer_1 = require("../AcmDrawer/AcmDrawer");
function AcmPage(props) {
    /* istanbul ignore if */
    if (props.hasDrawer) {
        return (react_1.default.createElement(AcmDrawer_1.AcmDrawerProvider, null,
            react_1.default.createElement(AcmDrawer_1.AcmDrawer, null,
                react_1.default.createElement(react_core_1.Page, null, props.children))));
    }
    else {
        return react_1.default.createElement(react_core_1.Page, null, props.children);
    }
}
exports.AcmPage = AcmPage;
function AcmPageHeader(props) {
    return (react_1.default.createElement(react_core_1.PageSection, { variant: react_core_1.PageSectionVariants.light, padding: { default: 'noPadding' } },
        react_1.default.createElement("div", { style: { display: 'flex', paddingTop: '16px', paddingRight: '24px' } },
            react_1.default.createElement("div", { style: { display: 'flex', flexDirection: 'column', flexGrow: 1 } },
                props.breadcrumb && (react_1.default.createElement("div", { style: { paddingLeft: '24px' } },
                    react_1.default.createElement(AcmBreadcrumb, { breadcrumb: props.breadcrumb }))),
                react_1.default.createElement("div", { style: {
                        paddingLeft: '24px',
                        flexGrow: 1,
                        paddingTop: '8px',
                        paddingBottom: '8px',
                        display: 'flex',
                        alignItems: 'center',
                    } },
                    react_1.default.createElement(react_core_1.Title, { headingLevel: "h1" }, props.title),
                    props.titleTooltip && (react_1.default.createElement(react_core_1.Popover, { hasAutoWidth: true, bodyContent: props.titleTooltip },
                        react_1.default.createElement(react_core_1.Button, { variant: "link", style: { padding: 0, marginLeft: '8px' } },
                            react_1.default.createElement(react_icons_1.OutlinedQuestionCircleIcon, { style: { verticalAlign: 'middle' } })))),
                    props.switches && react_1.default.createElement("div", { style: { paddingLeft: '8px' } }, props.switches)),
                props.navigation ? (react_1.default.createElement("div", { style: { paddingLeft: '8px' } }, props.navigation)) : (react_1.default.createElement("div", { style: { paddingBottom: '16px' } }))),
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    flexDirection: 'column',
                    paddingBottom: '16px',
                    alignItems: 'flex-end',
                } },
                react_1.default.createElement("div", { style: { flexGrow: 1 } }, props.controls),
                props.actions && react_1.default.createElement("div", { style: { paddingTop: '12px' } }, props.actions)))));
}
exports.AcmPageHeader = AcmPageHeader;
function AcmPageCard(props) {
    return (react_1.default.createElement(react_core_1.PageSection, null,
        react_1.default.createElement(react_core_1.Card, null,
            react_1.default.createElement(react_core_1.CardBody, null, props.children))));
}
exports.AcmPageCard = AcmPageCard;
function AcmBreadcrumb(props) {
    var breadcrumb = props.breadcrumb;
    if (breadcrumb === null || breadcrumb === void 0 ? void 0 : breadcrumb.length) {
        return (react_1.default.createElement(react_core_1.Breadcrumb, null, breadcrumb.map(function (crumb, i) { return (react_1.default.createElement(react_core_1.BreadcrumbItem, { key: crumb.to }, breadcrumb.length > 1 && i === breadcrumb.length - 1 ? (react_1.default.createElement("a", { "aria-current": "page", className: "pf-c-breadcrumb__link pf-m-current" }, crumb.text)) : (react_1.default.createElement(react_router_dom_1.Link, { to: crumb.to, className: "pf-c-breadcrumb__link" }, crumb.text)))); })));
    }
    return null;
}
exports.AcmBreadcrumb = AcmBreadcrumb;
//# sourceMappingURL=AcmPage.js.map