import _isNil from "lodash/isNil";
import _assign from "lodash/assign";
import { Helpers, LabelHelpers, Data, Domain, Scale, Collection } from "victory-core";

var getDataWithBaseline = function (props, scale) {
  var data = Data.getData(props);

  if (data.length < 2) {
    data = [];
  }

  var getDefaultMin = function (axis) {
    var defaultZero = Scale.getType(scale[axis]) === "log" ? 1 / Number.MAX_SAFE_INTEGER : 0;
    var domain = scale[axis].domain();
    var minY = Collection.getMinValue(domain);
    var maxY = Collection.getMaxValue(domain);
    var defaultMin = defaultZero;

    if (minY < 0 && maxY <= 0) {
      defaultMin = maxY;
    } else if (minY >= 0 && maxY > 0) {
      defaultMin = minY;
    }

    return Collection.containsDates(domain) ? new Date(defaultMin) : defaultMin;
  };

  return data.map(function (datum) {
    var _y1 = datum._y1 !== undefined ? datum._y1 : datum._y;

    var _y0 = datum._y0 !== undefined ? datum._y0 : getDefaultMin("y");

    var _x1 = datum._x1 !== undefined ? datum._x1 : datum._x;

    var _x0 = datum._x0 !== undefined ? datum._x0 : getDefaultMin("x");

    return _assign({}, datum, {
      _y0: _y0,
      _y1: _y1,
      _x0: _x0,
      _x1: _x1
    });
  });
};

var getCalculatedValues = function (props) {
  var polar = props.polar;
  var defaultStyles = Helpers.getDefaultStyles(props, "area");
  var style = Helpers.getStyles(props.style, defaultStyles);
  var range = {
    x: Helpers.getRange(props, "x"),
    y: Helpers.getRange(props, "y")
  };
  var domain = {
    x: Domain.getDomainWithZero(props, "x"),
    y: Domain.getDomainWithZero(props, "y")
  };
  var scale = {
    x: Scale.getBaseScale(props, "x").domain(domain.x).range(props.horizontal ? range.y : range.x),
    y: Scale.getBaseScale(props, "y").domain(domain.y).range(props.horizontal ? range.x : range.y)
  };
  var origin = polar ? props.origin || Helpers.getPolarOrigin(props) : undefined;
  var data = getDataWithBaseline(props, scale);
  return {
    style: style,
    data: data,
    scale: scale,
    domain: domain,
    origin: origin
  };
};

var getBaseProps = function (props, fallbackProps) {
  var modifiedProps = Helpers.modifyProps(props, fallbackProps, "area");
  props = _assign({}, modifiedProps, getCalculatedValues(modifiedProps));
  var _props = props,
      data = _props.data,
      domain = _props.domain,
      events = _props.events,
      groupComponent = _props.groupComponent,
      height = _props.height,
      horizontal = _props.horizontal,
      interpolation = _props.interpolation,
      origin = _props.origin,
      padding = _props.padding,
      polar = _props.polar,
      scale = _props.scale,
      sharedEvents = _props.sharedEvents,
      standalone = _props.standalone,
      style = _props.style,
      theme = _props.theme,
      width = _props.width,
      labels = _props.labels,
      name = _props.name;
  var initialChildProps = {
    parent: {
      style: style.parent,
      width: width,
      height: height,
      scale: scale,
      data: data,
      domain: domain,
      standalone: standalone,
      theme: theme,
      polar: polar,
      origin: origin,
      padding: padding,
      name: name,
      horizontal: horizontal
    },
    all: {
      data: {
        horizontal: horizontal,
        polar: polar,
        origin: origin,
        scale: scale,
        data: data,
        interpolation: interpolation,
        groupComponent: groupComponent,
        style: style.data
      }
    }
  };
  return data.reduce(function (childProps, datum, index) {
    var text = LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      var eventKey = !_isNil(datum.eventKey) ? datum.eventKey : index;
      childProps[eventKey] = {
        labels: LabelHelpers.getProps(props, index)
      };
    }

    return childProps;
  }, initialChildProps);
};

export { getBaseProps, getDataWithBaseline };