import { Helpers, TextSize } from 'victory-core';
import { getPieOrigin } from './chart-origin';
import { ChartCommonStyles } from '../ChartTheme';
// Returns x coordinate for bullet labels
export const getBulletLabelX = ({ chartWidth, dx = 0, labelPosition }) => labelPosition === 'top' && chartWidth ? Math.round(chartWidth / 2) : dx;
// Returns y coordinate for bullet labels
export const getBulletLabelY = ({ chartHeight, dy = 0, labelPosition }) => {
    switch (labelPosition) {
        case 'bottom':
            return chartHeight + ChartCommonStyles.label.margin + dy;
        case 'left':
            return chartHeight ? Math.round(chartHeight / 2) + dy : dy;
        default:
            return dy;
    }
};
// Returns x coordinate for pie labels
export const getPieLabelX = ({ dx = 0, height, labelPosition, legendPosition, padding, width }) => {
    const origin = getPieOrigin({ height, padding, width });
    const radius = Helpers.getRadius({ height, width, padding });
    switch (labelPosition) {
        case 'bottom':
        case 'center':
            return origin.x + dx;
        case 'right':
            switch (legendPosition) {
                case 'bottom':
                    return origin.x + ChartCommonStyles.label.margin + dx + radius;
                case 'right':
                    return origin.x + ChartCommonStyles.label.margin + dx;
                default:
                    return dx;
            }
        default:
            return dx;
    }
};
// Returns x coordinate for pie labels
export const getPieLabelY = ({ dy = 0, height, labelPosition, padding, width }) => {
    const origin = getPieOrigin({ height, padding, width });
    const radius = Helpers.getRadius({ height, width, padding });
    switch (labelPosition) {
        case 'center':
        case 'right':
            return origin.y + dy;
        case 'bottom':
            return origin.y + radius + ChartCommonStyles.label.margin * 2 + dy;
        default:
            return dy;
    }
};
// Returns an approximate size for the give text
export const getLabelTextSize = ({ text, theme }) => {
    const style = theme.legend.style.labels;
    // The approximateTextSize function returns height and width, but Victory incorrectly typed it as number
    return TextSize.approximateTextSize(text, Object.assign({}, style));
};
//# sourceMappingURL=chart-label.js.map