"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareNumbers = exports.compareStrings = exports.compareUnknowns = exports.compareItems = exports.AcmTable = exports.AcmTablePaginationContextProvider = void 0;
var styles_1 = require("@material-ui/styles");
var react_core_1 = require("@patternfly/react-core");
var react_table_1 = require("@patternfly/react-table");
var resize_observer_1 = __importDefault(require("@react-hook/resize-observer"));
var fuse_js_1 = __importDefault(require("fuse.js"));
var get_value_1 = __importDefault(require("get-value"));
var react_1 = __importStar(require("react"));
var AcmButton_1 = require("../AcmButton/AcmButton");
var AcmEmptyState_1 = require("../AcmEmptyState/AcmEmptyState");
var useStyles = styles_1.makeStyles({
    tableDiv: {
        display: 'table',
        width: '100%',
    },
    outerDiv: {
        display: 'block',
    },
});
function OuiaIdRowWrapper(props) {
    return react_1.default.createElement(react_table_1.RowWrapper, __assign({}, props, { ouiaId: get_value_1.default(props, 'row.props.key') }));
}
var DEFAULT_ITEMS_PER_PAGE = 10;
var BREAKPOINT_SIZES = [
    { name: react_table_1.TableGridBreakpoint.none, size: 0 },
    { name: react_table_1.TableGridBreakpoint.gridMd, size: 768 },
    { name: react_table_1.TableGridBreakpoint.gridLg, size: 992 },
    { name: react_table_1.TableGridBreakpoint.gridXl, size: 1200 },
    { name: react_table_1.TableGridBreakpoint.grid2xl, size: 1450 },
    { name: react_table_1.TableGridBreakpoint.grid, size: Infinity },
];
var AcmTablePaginationContext = react_1.createContext({});
function AcmTablePaginationContextProvider(props) {
    var children = props.children, localStorageKey = props.localStorageKey;
    var _a = react_1.useState(parseInt(localStorage.getItem(localStorageKey) || '0', 10) || DEFAULT_ITEMS_PER_PAGE), perPage = _a[0], setPerPage = _a[1];
    var paginationContext = {
        perPage: perPage,
        setPerPage: function (perPage) {
            localStorage.setItem(localStorageKey, String(perPage));
            setPerPage(perPage);
        },
    };
    return react_1.default.createElement(AcmTablePaginationContext.Provider, { value: paginationContext }, children);
}
exports.AcmTablePaginationContextProvider = AcmTablePaginationContextProvider;
function AcmTable(props) {
    var _a;
    var items = props.items, columns = props.columns, keyFn = props.keyFn, bulkActions = props.bulkActions;
    var sortIndexOffset = bulkActions && bulkActions.length ? 1 : 0;
    var _b = react_1.useState({}), selected = _b[0], setSelected = _b[1];
    var defaultSort = {
        index: sortIndexOffset,
        direction: react_table_1.SortByDirection.asc,
    };
    // State that can come from context or component state (perPage)
    var _c = react_1.useState(DEFAULT_ITEMS_PER_PAGE), statePerPage = _c[0], stateSetPerPage = _c[1];
    var _d = react_1.useContext(AcmTablePaginationContext), contextPerPage = _d.perPage, contextSetPerPage = _d.setPerPage;
    var perPage = contextPerPage || statePerPage;
    var setPerPage = contextSetPerPage || stateSetPerPage;
    // State that can come from component props or from component state (page, search, sort)
    var _e = react_1.useState(1), statePage = _e[0], stateSetPage = _e[1];
    var page = props.page || statePage;
    var setPage = props.setPage || stateSetPage;
    var _f = react_1.useState(''), stateSearch = _f[0], stateSetSearch = _f[1];
    var search = props.search || stateSearch;
    var setSearch = props.setSearch || stateSetSearch;
    var _g = react_1.useState(defaultSort), stateSort = _g[0], stateSetSort = _g[1];
    var sort = props.sort || stateSort;
    var setSort = props.setSort || stateSetSort;
    // Nice to have, but disposable state (preFilterSort)
    var _h = react_1.useState(defaultSort), preFilterSort = _h[0], setPreFilterSort = _h[1];
    var hasSearch = react_1.useMemo(function () { return columns.some(function (column) { return column.search; }); }, [columns]);
    // Dynamic gridBreakPoint
    var _j = react_1.useState(react_table_1.TableGridBreakpoint.none), breakpoint = _j[0], setBreakpoint = _j[1];
    var _k = react_1.useState(), exactBreakpoint = _k[0], setExactBreakpoint = _k[1];
    var _l = react_1.useState(null), outerDiv = _l[0], setOuterDiv = _l[1];
    var _m = react_1.useState(null), tableDiv = _m[0], setTableDiv = _m[1];
    var outerDivRef = react_1.useCallback(function (elem) { return setOuterDiv(elem); }, []);
    var tableDivRef = react_1.useCallback(function (elem) { return setTableDiv(elem); }, []);
    /* istanbul ignore next */
    var updateBreakpoint = function (width, tableWidth) {
        var _a, _b;
        var viewportWidth = window.innerWidth;
        if (tableWidth > width) {
            // table needs to switch to grid; make the change and record viewport size when this happened
            var newBreakpoint = ((_a = BREAKPOINT_SIZES.find(function (b) { return viewportWidth <= b.size; })) === null || _a === void 0 ? void 0 : _a.name) || react_table_1.TableGridBreakpoint.none;
            setBreakpoint(newBreakpoint);
            setExactBreakpoint(viewportWidth);
        }
        else if (exactBreakpoint && viewportWidth > exactBreakpoint) {
            // viewport is now bigger than when we last switched to grid; try bigger breakpoint, which will
            // be reverted in the layout effect if the table is still too wide
            var newBreakpoint = ((_b = __spreadArrays(BREAKPOINT_SIZES).reverse().find(function (b) { return viewportWidth > b.size; })) === null || _b === void 0 ? void 0 : _b.name) || react_table_1.TableGridBreakpoint.grid;
            setBreakpoint(newBreakpoint);
        }
    };
    react_1.useLayoutEffect(function () {
        if (outerDiv && tableDiv) {
            updateBreakpoint(outerDiv.clientWidth, tableDiv.clientWidth);
        }
    }, 
    // Check breakpoints as soon as ref callbacks are set, in case initial viewport is too small for table
    // Need to check on every update to breakpoint as well for the same case, to that display
    // doesn't thrash between table/grid on intial expansion of viewport
    [breakpoint, outerDiv, tableDiv]);
    /* istanbul ignore next */
    resize_observer_1.default(outerDiv, function (entry) {
        if (entry.contentRect && tableDiv) {
            var width = Math.floor(entry.contentRect.width);
            var tableWidth = tableDiv.clientWidth;
            updateBreakpoint(width, tableWidth);
        }
    });
    var classes = useStyles();
    react_1.useLayoutEffect(function () {
        var newSelected = {};
        /* istanbul ignore next */
        Object.keys(selected)
            .filter(function (key) { var _a; return (_a = props.items) === null || _a === void 0 ? void 0 : _a.find(function (item) { return keyFn(item) === key; }); })
            .forEach(function (key) {
            newSelected[key] = selected[key];
        });
        setSelected(newSelected);
    }, [items]);
    var searchItems = react_1.useMemo(function () {
        /* istanbul ignore if */
        if (!items)
            return [];
        return items.map(function (item) {
            var searchItem = { item: item };
            for (var i = 0; i < columns.length; i++) {
                var column = columns[i];
                if (column.search) {
                    if (typeof column.search === 'string') {
                        searchItem["column-" + i] = get_value_1.default(item, column.search);
                    }
                    else {
                        searchItem["column-" + i] = column.search(item);
                    }
                }
            }
            return searchItem;
        });
    }, [items, columns]);
    var filtered = react_1.useMemo(function () {
        if (search && search !== '' && searchItems) {
            var fuse = new fuse_js_1.default(searchItems, {
                includeScore: true,
                threshold: 0.3,
                keys: columns
                    .map(function (column, i) { return (column.search ? "column-" + i : undefined); })
                    .filter(function (value) { return value !== undefined; }),
            });
            return fuse.search(search).map(function (result) { return result.item.item; });
        }
        else {
            return items || [];
        }
    }, [search, items, searchItems, columns]);
    // Compensate for off-by-one error in sort column when all items are filtered out
    var adjustedSort = sort && sort.index && sort.direction && filtered.length === 0
        ? {
            index: sort.index - sortIndexOffset,
            direction: sort.direction,
        }
        : sort;
    var sorted = react_1.useMemo(function () {
        if (sort) {
            var compare = columns[(sort && sort.index ? sort.index : 0) - sortIndexOffset].sort;
            var sorted_1 = __spreadArrays(filtered);
            /* istanbul ignore else */
            if (compare) {
                if (typeof compare === 'string') {
                    sorted_1.sort(compareItems(compare));
                }
                else {
                    sorted_1.sort(compare);
                }
            }
            if (sort.direction === react_table_1.SortByDirection.desc) {
                sorted_1.reverse();
            }
            return sorted_1;
        }
        else {
            return filtered;
        }
    }, [filtered, sort, columns]);
    var paged = react_1.useMemo(function () {
        var start = (page - 1) * perPage;
        var actualPage = page;
        if (start > sorted.length) {
            actualPage = Math.floor(sorted.length / perPage) + 1;
            start = (actualPage - 1) * perPage;
            setPage(actualPage);
        }
        return sorted.slice(start, start + perPage);
    }, [sorted, page, perPage]);
    var rows = react_1.useMemo(function () {
        var newRows = paged.map(function (item) {
            var key = keyFn(item);
            return {
                selected: selected[key] === true,
                props: { key: key },
                cells: columns.map(function (column) {
                    return typeof column.cell === 'string' ? (get_value_1.default(item, column.cell)) : (react_1.default.createElement(react_1.Fragment, { key: key }, column.cell(item)));
                }),
            };
        });
        return newRows;
    }, [selected, paged, keyFn, columns]);
    var updateSearch = react_1.useCallback(function (newSearch) {
        setSearch(newSearch);
        setPage(1);
        if (!newSearch) {
            // clearing filtered state; restore previous sorting if applicable
            if (preFilterSort) {
                setSort(preFilterSort);
            }
        }
        else if (!search) {
            // entering a filtered state; save sort setting use fuzzy match sort
            setPreFilterSort(sort);
            setSort(undefined);
        }
    }, 
    // setSort/setSearch/setPage can come from props, but setPreFilterSort is only from state and therefore
    // guaranteed stable - not needed in dependency list
    [search, sort, preFilterSort, setSort, setSearch, setPage]);
    var updateSort = react_1.useCallback(function (newSort) {
        if (filtered.length === 0) {
            /* istanbul ignore next */
            setSort({
                index: (newSort && newSort.index ? newSort.index : 0) + sortIndexOffset,
                direction: newSort && newSort.direction,
            });
        }
        else {
            setSort(newSort);
        }
        if (search) {
            // sort changed while filtering; forget previous setting
            setPreFilterSort(undefined);
        }
    }, [search, filtered]);
    var updatePerPage = react_1.useCallback(function (newPerPage) {
        // keep the first item in view on pagination size change
        var newPage = Math.floor(((page - 1) * perPage) / newPerPage) + 1;
        setPage(newPage);
        setPerPage(newPerPage);
    }, [page, perPage, setPage, setPerPage]);
    var onSelect = react_1.useCallback(function (_event, isSelected, rowId) {
        /* istanbul ignore next */
        if (!paged)
            return;
        /* istanbul ignore next */
        if (!filtered)
            return;
        /* istanbul ignore next */
        if (!rows)
            return;
        if (rowId === -1) {
            var allSelected = true;
            for (var _i = 0, rows_1 = rows; _i < rows_1.length; _i++) {
                var row = rows_1[_i];
                if (!row.selected) {
                    allSelected = false;
                    break;
                }
            }
            var newSelected_1 = {};
            /* istanbul ignore else */
            if (!allSelected) {
                for (var _a = 0, filtered_1 = filtered; _a < filtered_1.length; _a++) {
                    var item = filtered_1[_a];
                    newSelected_1[keyFn(item)] = true;
                }
            }
            setSelected(newSelected_1);
            /* istanbul ignore next */
            if (props.onSelect && items) {
                props.onSelect(items.filter(function (item) { return newSelected_1[keyFn(item)]; }));
            }
        }
        else {
            var newSelected_2 = __assign({}, selected);
            if (isSelected) {
                newSelected_2[keyFn(paged[rowId])] = true;
            }
            else {
                delete newSelected_2[keyFn(paged[rowId])];
            }
            setSelected(newSelected_2);
            /* istanbul ignore next */
            if (props.onSelect && items) {
                props.onSelect(items.filter(function (item) { return newSelected_2[keyFn(item)]; }));
            }
        }
    }, [paged, filtered, rows, keyFn]);
    var actions = props.rowActions.map(function (rowAction) {
        return {
            title: rowAction.title,
            onClick: function (_event, rowId) {
                /* istanbul ignore else */
                if (paged) {
                    rowAction.click(paged[rowId]);
                }
            },
        };
    });
    var showActions = items && items.length;
    var showSearch = hasSearch && showActions;
    var showToolbar = showSearch || showActions || props.extraToolbarControls;
    return (react_1.default.createElement(react_1.Fragment, null,
        showToolbar && (react_1.default.createElement(react_core_1.Toolbar, null,
            react_1.default.createElement(react_core_1.ToolbarContent, null,
                hasSearch && items && items.length > 0 && filtered && (react_1.default.createElement(react_core_1.ToolbarItem, null,
                    react_1.default.createElement(react_core_1.SearchInput, { style: { minWidth: '350px' }, placeholder: "Search", value: search, onChange: function (value) {
                            updateSearch(value);
                        }, onClear: function () {
                            updateSearch('');
                        }, resultsCount: filtered.length + " / " + items.length }))),
                react_1.default.createElement(react_core_1.ToolbarItem, { alignment: { default: 'alignRight' } }),
                items && items.length ? (Object.keys(selected).length ? (react_1.default.createElement(react_1.Fragment, null,
                    react_1.default.createElement(react_core_1.ToolbarItem, null, Object.keys(selected).length + "/" + items.length + " " + props.plural + " selected"),
                    react_1.default.createElement(react_core_1.ToolbarItem, { variant: "separator" }),
                    props.bulkActions.map(function (action) { return (react_1.default.createElement(react_core_1.ToolbarItem, { key: action.id },
                        react_1.default.createElement(AcmButton_1.AcmButton, { onClick: function () {
                                action.click(items.filter(function (item) { return selected[keyFn(item)]; }));
                            }, isDisabled: action.isDisabled, tooltip: action.tooltip }, action.title))); }))) : (react_1.default.createElement(react_1.Fragment, null, props.tableActions.map(function (action) { return (react_1.default.createElement(react_core_1.ToolbarItem, { key: action.id },
                    react_1.default.createElement(AcmButton_1.AcmButton, { onClick: function () {
                            action.click();
                        }, isDisabled: action.isDisabled, tooltip: action.tooltip }, action.title))); })))) : (react_1.default.createElement(react_1.Fragment, null)),
                props.extraToolbarControls))),
        !items || !rows || !filtered || !paged ? (react_1.default.createElement(react_core_1.EmptyState, null,
            react_1.default.createElement(react_core_1.EmptyStateIcon, { variant: "container", component: react_core_1.Spinner }),
            react_1.default.createElement(react_core_1.Title, { size: "lg", headingLevel: "h4" }, "Loading"))) : items.length === 0 ? (props.emptyState ? (props.emptyState) : (react_1.default.createElement(AcmEmptyState_1.AcmEmptyState, { title: "No " + props.plural + " found", message: "You do not have any " + props.plural + " yet." }))) : (react_1.default.createElement(react_1.Fragment, null,
            react_1.default.createElement("div", { ref: outerDivRef, className: classes.outerDiv },
                react_1.default.createElement("div", { ref: tableDivRef, className: classes.tableDiv },
                    react_1.default.createElement(react_table_1.Table, { cells: columns.map(function (column) {
                            return {
                                title: column.header,
                                header: column.tooltip
                                    ? {
                                        info: {
                                            tooltip: column.tooltip,
                                            tooltipProps: { isContentLeftAligned: true },
                                        },
                                    }
                                    : {},
                                transforms: __spreadArrays([
                                    react_table_1.nowrap
                                ], (column.transforms || []), (column.sort ? [react_table_1.sortable] : [])),
                                cellTransforms: column.cellTransforms || [],
                            };
                        }), rows: rows, rowWrapper: OuiaIdRowWrapper, actions: actions, canSelectAll: true, "aria-label": "Simple Table", sortBy: adjustedSort, onSort: function (_event, index, direction) {
                            updateSort({ index: index, direction: direction });
                        }, onSelect: 
                        /* istanbul ignore next */
                        rows.length && ((_a = props.bulkActions) === null || _a === void 0 ? void 0 : _a.length) ? onSelect : undefined, variant: react_table_1.TableVariant.compact, gridBreakPoint: breakpoint },
                        react_1.default.createElement(react_table_1.TableHeader, null),
                        react_1.default.createElement(react_table_1.TableBody, null)))),
            filtered.length !== 0 && (!props.autoHidePagination || filtered.length > perPage) && (react_1.default.createElement(react_core_1.Pagination, { itemCount: filtered.length, perPage: perPage, page: page, variant: react_core_1.PaginationVariant.bottom, onSetPage: function (_event, page) {
                    setPage(page);
                }, onPerPageSelect: function (_event, perPage) {
                    updatePerPage(perPage);
                }, perPageOptions: props.perPageOptions })),
            !filtered.length && (react_1.default.createElement(AcmEmptyState_1.AcmEmptyState, { title: "No results found", message: "No results match the filter criteria. Clear filters to show results.", showIcon: false, action: react_1.default.createElement(AcmButton_1.AcmButton, { variant: "link", onClick: function () {
                        updateSearch('');
                    } }, "Clear all filters") }))))));
}
exports.AcmTable = AcmTable;
function compareItems(path) {
    return function (a, b) {
        return compareUnknowns(get_value_1.default(a, path), get_value_1.default(b, path));
    };
}
exports.compareItems = compareItems;
function compareUnknowns(a, b) {
    /* istanbul ignore next */
    if (a == undefined && b == undefined)
        return 0;
    /* istanbul ignore next */
    if (a == undefined)
        return 1;
    /* istanbul ignore next */
    if (b == undefined)
        return -1;
    /* istanbul ignore else */
    if (typeof a === 'string') {
        /* istanbul ignore else */
        if (typeof b === 'string') {
            return compareStrings(a, b);
        }
        else if (typeof b === 'number') {
            return compareStrings(a, b.toString());
        }
    }
    else if (typeof a === 'number') {
        /* istanbul ignore else */
        if (typeof b === 'number') {
            return compareNumbers(a, b);
        }
        else if (typeof b === 'string') {
            return compareStrings(a.toString(), b);
        }
    }
    /* istanbul ignore next */
    return 0;
}
exports.compareUnknowns = compareUnknowns;
/* istanbul ignore next */
function compareStrings(a, b) {
    if (a == undefined && b == undefined)
        return 0;
    if (a == undefined)
        return 1;
    if (b == undefined)
        return -1;
    return a < b ? -1 : a > b ? 1 : 0;
}
exports.compareStrings = compareStrings;
/* istanbul ignore next */
function compareNumbers(a, b) {
    if (a == undefined && b == undefined)
        return 0;
    if (a == undefined)
        return 1;
    if (b == undefined)
        return -1;
    return a < b ? -1 : a > b ? 1 : 0;
}
exports.compareNumbers = compareNumbers;
//# sourceMappingURL=AcmTable.js.map