"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _Dropdown = require("@patternfly/react-core/dist/js/components/Dropdown/Dropdown.js");

var _DropdownToggle = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownToggle.js");

var _Level = require("@patternfly/react-core/dist/js/layouts/Level/Level.js");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _FilterInput = _interopRequireDefault(require("./FilterInput.js"));

require("./filter-dropdown.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var FilterDropdown = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(FilterDropdown, _Component);

  var _super = _createSuper(FilterDropdown);

  function FilterDropdown() {
    var _this;

    (0, _classCallCheck2["default"])(this, FilterDropdown);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      isOpen: false
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "addRemoveFilters", function (selectedValue, filterName, type, isChecked) {
      switch (type) {
        case 'checkbox':
          isChecked ? _this.props.addFilter(filterName, selectedValue, type) : _this.props.removeFilter(filterName, selectedValue);
          break;

        case 'radio':
          _this.props.addFilter(filterName, selectedValue, type);

          break;
      }
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(FilterDropdown, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          hideCategories = _this$props.hideCategories,
          filters = _this$props.filters,
          filterCategories = _this$props.filterCategories,
          label = _this$props.label;
      var isOpen = this.state.isOpen;
      return /*#__PURE__*/_react["default"].createElement(_Dropdown.Dropdown, {
        className: "ins-c-filter__dropdown",
        onSelect: this.onSelect,
        toggle: /*#__PURE__*/_react["default"].createElement(_DropdownToggle.DropdownToggle, {
          onToggle: this.onToggle
        }, label),
        isOpen: isOpen
      }, /*#__PURE__*/_react["default"].createElement("div", {
        className: "pf-c-dropdown__menu-item"
      }, filterCategories.map(function (data, index) {
        return !hideCategories.includes(data.urlParam) && /*#__PURE__*/_react["default"].createElement(_Level.Level, {
          key: "".concat(data.urlParam).concat(index)
        }, data.title, data.values.map(function (item, key) {
          return /*#__PURE__*/_react["default"].createElement(_FilterInput["default"], {
            key: "check".concat(index).concat(key),
            "aria-label": item.label,
            id: "".concat(data.urlParam).concat(key),
            label: item.label,
            addRemoveFilters: _this2.addRemoveFilters,
            param: data.urlParam,
            type: data.type,
            value: item.value,
            filters: filters
          });
        }), index !== filterCategories.length - 1 && /*#__PURE__*/_react["default"].createElement("br", null));
      })));
    }
  }]);
  return FilterDropdown;
}(_react.Component);

FilterDropdown.propTypes = {
  addFilter: _propTypes["default"].func,
  removeFilter: _propTypes["default"].func,
  hideCategories: _propTypes["default"].array,
  filters: _propTypes["default"].object,
  filterCategories: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    title: _propTypes["default"].string,
    type: _propTypes["default"].type,
    urlParam: _propTypes["default"].string,
    values: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      label: _propTypes["default"].node,
      value: _propTypes["default"].any
    }))
  })),
  label: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].node])
};
FilterDropdown.defaultProps = {
  addFilter: Function.prototype,
  removeFilter: Function.prototype,
  hideCategories: [],
  filters: {},
  label: 'Filters'
};
var _default = FilterDropdown;
exports["default"] = _default;