"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Tooltip = require("@patternfly/react-core/dist/js/components/Tooltip/Tooltip.js");

var _questionIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/question-icon"));

var _securityIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/security-icon"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _consts = require("./consts");

var Shield = function Shield(_ref) {
  var impact = _ref.impact,
      hasLabel = _ref.hasLabel,
      hasTooltip = _ref.hasTooltip,
      size = _ref.size;
  var unknownLabel = 'Unknown';
  var attributes = _consts.impactList[impact] || {
    title: unknownLabel,
    color: _consts.colorList["default"]
  };
  var badge = _consts.impactList[impact] ? /*#__PURE__*/_react["default"].createElement(_securityIcon["default"], {
    "aria-hidden": "false",
    "aria-label": attributes.title,
    size: size,
    color: attributes.color
  }) : /*#__PURE__*/_react["default"].createElement(_questionIcon["default"], {
    "aria-hidden": "false",
    "aria-label": unknownLabel,
    size: size,
    color: _consts.colorList["default"]
  });

  var body = /*#__PURE__*/_react["default"].createElement("span", null, badge, " ", hasLabel && attributes.title);

  return /*#__PURE__*/_react["default"].createElement("span", null, hasTooltip ? /*#__PURE__*/_react["default"].createElement(_Tooltip.Tooltip, {
    content: /*#__PURE__*/_react["default"].createElement("div", null, attributes.message),
    position: 'bottom'
  }, body) : body);
};

Shield.defaultProps = {
  impact: 'N/A',
  hasLabel: false,
  size: 'sm',
  hasTooltip: true
};
Shield.propTypes = {
  impact: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number]),
  hasLabel: _propTypes["default"].bool,
  size: _propTypes["default"].string,
  // sm, md, lg and xl,
  label: _propTypes["default"].bool,
  hasTooltip: _propTypes["default"].bool
};
var _default = Shield;
exports["default"] = _default;