import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component, Fragment } from 'react';
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";
import { SplitItem } from "@patternfly/react-core/dist/esm/layouts/Split/SplitItem.js";
import { Split } from "@patternfly/react-core/dist/esm/layouts/Split/Split.js";
import FilterIcon from "@patternfly/react-icons/dist/esm/icons/filter-icon";
import Text from './TextFilter';
import { conditionalFilterType, typeMapper } from './conditionalFilterConstants';
import PropTypes from 'prop-types';
import "../../ConditionalFilter/./conditional-filter.css";

var ConditionalFilter = /*#__PURE__*/function (_Component) {
  _inherits(ConditionalFilter, _Component);

  var _super = _createSuper(ConditionalFilter);

  function ConditionalFilter() {
    var _this;

    _classCallCheck(this, ConditionalFilter);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false,
      stateValue: undefined
    });

    _defineProperty(_assertThisInitialized(_this), "dropdownToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (_e, value) {
      _this.setState({
        stateValue: value
      });
    });

    return _this;
  }

  _createClass(ConditionalFilter, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          items = _this$props.items,
          value = _this$props.value,
          onChange = _this$props.onChange,
          placeholder = _this$props.placeholder,
          hideLabel = _this$props.hideLabel,
          isDisabled = _this$props.isDisabled,
          props = _objectWithoutProperties(_this$props, ["items", "value", "onChange", "placeholder", "hideLabel", "isDisabled"]);

      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          stateValue = _this$state.stateValue;
      var currentValue = onChange ? value : stateValue;
      var activeItem = items && items.length && (items.find(function (item, key) {
        return item.value === currentValue || key === currentValue;
      }) || items[0]);
      var onChangeCallback = onChange || this.onChange;
      var ActiveComponent = activeItem && (typeMapper[activeItem.type] || typeMapper.text);

      var capitalize = function capitalize(string) {
        return string[0].toUpperCase() + string.substring(1);
      };

      return /*#__PURE__*/React.createElement(Fragment, null, !items || items && items.length <= 0 ? /*#__PURE__*/React.createElement("div", {
        className: "ins-c-conditional-filter"
      }, /*#__PURE__*/React.createElement(Text, _extends({}, props, {
        value: currentValue,
        onChange: function onChange(e) {
          return onChangeCallback(e, e.target.value);
        },
        placeholder: placeholder,
        "widget-type": "InsightsInput"
      }))) : /*#__PURE__*/React.createElement(Split, {
        className: "ins-c-conditional-filter"
      }, items.length > 1 && /*#__PURE__*/React.createElement(SplitItem, null, /*#__PURE__*/React.createElement(Dropdown, {
        className: "ins-c-conditional-filter__group",
        onSelect: function onSelect() {
          return _this2.dropdownToggle(false);
        },
        isOpen: isOpen,
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, {
          onToggle: this.dropdownToggle,
          isDisabled: isDisabled,
          className: hideLabel ? 'ins-c-conditional-filter__no-label' : ''
        }, /*#__PURE__*/React.createElement(FilterIcon, {
          size: "sm"
        }), !hideLabel && /*#__PURE__*/React.createElement("span", {
          className: "ins-c-conditional-filter__value-selector"
        }, activeItem && capitalize(activeItem.label))),
        dropdownItems: items.map(function (item, key) {
          return /*#__PURE__*/React.createElement(DropdownItem, {
            key: item.id ? "".concat(item.id, "-dropdown") : key,
            component: "button",
            onClick: function onClick(e) {
              return onChangeCallback(e, item.value || key, item);
            },
            isHovered: activeItem.label === item.label
          }, capitalize(item.label));
        })
      })), ActiveComponent && /*#__PURE__*/React.createElement(SplitItem, {
        isFilled: true
      }, /*#__PURE__*/React.createElement(ActiveComponent, _extends({}, activeItem.type !== conditionalFilterType.custom && {
        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
        id: activeItem.filterValues && activeItem.filterValues.id || currentValue
      }, activeItem.filterValues)))));
    }
  }]);

  return ConditionalFilter;
}(Component);

var TextInputProps = {
  value: PropTypes.string,
  placeholder: PropTypes.string,
  onChange: PropTypes.func
};
ConditionalFilter.propTypes = _objectSpread(_objectSpread({
  hideLabel: PropTypes.bool,
  items: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string,
    label: PropTypes.node,
    value: PropTypes.string,
    type: PropTypes.oneOf(['text', 'checkbox', 'radio', 'custom', 'group']),
    filterValues: PropTypes.oneOfType([PropTypes.shape(TextInputProps), PropTypes.shape(_objectSpread(_objectSpread({}, TextInputProps), {}, {
      value: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
        label: PropTypes.node,
        value: PropTypes.string
      })])), PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any))]),
      items: PropTypes.arrayOf(PropTypes.shape({
        label: PropTypes.node,
        value: PropTypes.string
      }))
    }))])
  }))
}, TextInputProps), {}, {
  id: PropTypes.string,
  isDisabled: PropTypes.bool
});
ConditionalFilter.defaultProps = {
  value: '',
  items: [],
  hideLabel: false,
  isDisabled: false,
  id: 'default-input'
};
export default ConditionalFilter;