import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _toArray from "@babel/runtime/helpers/toArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { Component, Fragment } from 'react';
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { KebabToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/KebabToggle.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { DropdownSeparator } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownSeparator.js";
import { ToolbarItem } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarItem.js";
import PropTypes from 'prop-types';
import { DownloadButton } from '../DownloadButton';
export var overflowActionsMapper = function overflowActionsMapper(action, key) {
  return /*#__PURE__*/React.createElement(DropdownItem, _extends({}, action.props, {
    className: "ins-c-primary-toolbar__overflow-actions",
    key: action.value || action.key || "".concat(key, "-overflow"),
    component: action.props && action.props.component || /*#__PURE__*/React.isValidElement(action.label || action) ? 'div' : 'button',
    onClick: function onClick(e) {
      return action.onClick && action.onClick(e, action, key);
    }
  }), action.label || action);
};
export var actionPropsGenerator = function actionPropsGenerator(action, key) {
  return _objectSpread(_objectSpread({}, action.props), {}, {
    component: action.props && action.props.component || ( /*#__PURE__*/React.isValidElement(action.label || action) ? 'div' : 'button'),
    onClick: function onClick(e) {
      return action.onClick && action.onClick(e, action, key);
    },
    children: action.label || action
  });
};

var Actions = /*#__PURE__*/function (_Component) {
  _inherits(Actions, _Component);

  var _super = _createSuper(Actions);

  function Actions() {
    var _this;

    _classCallCheck(this, Actions);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "toggleOpen", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    return _this;
  }

  _createClass(Actions, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var isOpen = this.state.isOpen;
      var _this$props = this.props,
          actions = _this$props.actions,
          overflowActions = _this$props.overflowActions,
          _onSelect = _this$props.onSelect,
          dropdownProps = _this$props.dropdownProps,
          kebabToggleProps = _this$props.kebabToggleProps,
          exportConfig = _this$props.exportConfig;

      var _actions = _toArray(actions),
          firstAction = _actions[0],
          restActions = _actions.slice(1);

      return /*#__PURE__*/React.createElement(Fragment, null, firstAction && /*#__PURE__*/React.createElement(ToolbarItem, {
        className: "ins-c-primary-toolbar__first-action pf-m-spacer-sm"
      }, firstAction.label ? /*#__PURE__*/React.createElement(Button, _extends({}, firstAction.props, {
        onClick: firstAction.onClick || firstAction.props && firstAction.props.onClick || undefined
      }), firstAction.label) : firstAction), exportConfig && (exportConfig.extraItems || exportConfig.onSelect) && /*#__PURE__*/React.createElement(ToolbarItem, {
        className: "pf-m-spacer-sm"
      }, /*#__PURE__*/React.createElement(DownloadButton, exportConfig)), (actions && actions.length > 0 || overflowActions.length > 0) && /*#__PURE__*/React.createElement(ToolbarItem, {
        className: "".concat(actions.length <= 1 ? 'ins-m-actions--empty' : '', " ins-c-primary-toolbar__actions pf-m-spacer-sm")
      }, /*#__PURE__*/React.createElement(Dropdown, _extends({}, dropdownProps, {
        isOpen: isOpen,
        isPlain: true,
        onSelect: function onSelect() {
          _onSelect && _onSelect.apply(void 0, arguments);

          _this2.toggleOpen(false);
        },
        toggle: /*#__PURE__*/React.createElement(KebabToggle, _extends({}, kebabToggleProps, {
          onToggle: function onToggle(isOpen) {
            return _this2.toggleOpen(isOpen);
          }
        })),
        dropdownItems: [].concat(_toConsumableArray(firstAction ? [/*#__PURE__*/React.createElement(DropdownItem, _extends({
          key: "first-action"
        }, actionPropsGenerator(firstAction, 'first-action'), {
          className: "ins-c-primary-toolbar__first-action ".concat(firstAction.props && firstAction.props.className || '')
        }))] : []), _toConsumableArray(restActions.map(function (action, key) {
          return /*#__PURE__*/React.createElement(DropdownItem, _extends({
            key: action.key || action && action.props && action.props.key || key
          }, actionPropsGenerator(action, key)));
        })), _toConsumableArray(actions.length > 0 && overflowActions.length > 0 ? [/*#__PURE__*/React.createElement(DropdownSeparator, {
          key: "separator",
          className: "ins-c-primary-toolbar__overflow-actions-separator"
        })] : []), _toConsumableArray(overflowActions.map(overflowActionsMapper)))
      }))));
    }
  }]);

  return Actions;
}(Component);

var actionsType = PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.node, PropTypes.shape({
  label: PropTypes.node,
  value: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
  onClick: PropTypes.func,
  props: PropTypes.any
}), PropTypes.string]));
Actions.propTypes = {
  actions: actionsType,
  onSelect: PropTypes.func,
  overflowActions: actionsType,
  dropdownProps: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any)),
  kebabToggleProps: PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any)),
  exportConfig: PropTypes.shape(DownloadButton.propTypes)
};
Actions.defaultProps = {
  actions: [],
  overflowActions: [],
  dropdownProps: {},
  exportConfig: {},
  onSelect: function onSelect() {
    return undefined;
  }
};
export default Actions;