"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "style", {
  enumerable: true,
  get: function get() {
    return _index["default"];
  }
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactTable = require("@patternfly/react-table");

var _Bullseye = require("@patternfly/react-core/dist/js/layouts/Bullseye/Bullseye.js");

var _EmptyState = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyState.js");

var _EmptyStateIcon = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateIcon.js");

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _EmptyStateBody = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateBody.js");

var _searchIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/search-icon"));

var _Skeleton = require("@redhat-cloud-services/frontend-components/Skeleton");

var _TableToolbar = require("@redhat-cloud-services/frontend-components/TableToolbar");

var _PrimaryToolbar = require("@redhat-cloud-services/frontend-components/PrimaryToolbar");

var _Pagination = require("@patternfly/react-core/dist/js/components/Pagination/Pagination.js");

var _flatten = _interopRequireDefault(require("lodash/flatten"));

var _debounce = _interopRequireDefault(require("lodash/debounce"));

var _isEqual = _interopRequireDefault(require("lodash/isEqual"));

var _helpers = require("./helpers");

var _index = _interopRequireDefault(require("./index.scss"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var RuleTable = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(RuleTable, _Component);

  var _super = _createSuper(RuleTable);

  function RuleTable() {
    var _this;

    (0, _classCallCheck2["default"])(this, RuleTable);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      filterValues: {},
      expanded: []
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "debounceFetchData", (0, _debounce["default"])(function (options) {
      var fetchData = _this.props.fetchData;
      fetchData(options);
    }, 500));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onUpdate", function () {
      var isDebounce = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var _this$props = _this.props,
          fetchData = _this$props.fetchData,
          rules = _this$props.rules,
          columns = _this$props.columns,
          sortBy = _this$props.sortBy,
          detail = _this$props.detail;
      var filterValues = _this.state.filterValues;
      var method = isDebounce ? _this.debounceFetchData : fetchData;
      method({
        meta: (0, _helpers.calculateMeta)(rules.meta),
        filterValues: filterValues,
        sortBy: _objectSpread(_objectSpread({}, sortBy), {}, {
          column: columns[sortBy.index - Boolean(detail)]
        })
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onFilterDelete", function (_e, _ref, isAll) {
      var _ref2 = (0, _slicedToArray2["default"])(_ref, 1),
          deleteItem = _ref2[0];

      var filterValues = _this.state.filterValues;

      if (isAll) {
        _this.setState({
          filterValues: {}
        }, function () {
          return _this.onUpdate();
        });
      } else {
        if (Array.isArray(filterValues[deleteItem.type])) {
          var activefilter = filterValues[deleteItem.type];

          var _deleteItem$chips = (0, _slicedToArray2["default"])(deleteItem.chips, 1),
              chipToDelete = _deleteItem$chips[0];

          _this.setState({
            filterValues: _objectSpread(_objectSpread({}, filterValues), {}, (0, _defineProperty2["default"])({}, deleteItem.type, activefilter.filter(function (item) {
              return item !== chipToDelete.value;
            })))
          }, function () {
            return _this.onUpdate();
          });
        } else {
          delete filterValues[deleteItem.type];

          _this.setState({
            filterValues: filterValues
          }, function () {
            return _this.onUpdate();
          });
        }
      }
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onCollapse", function (_e, key, isOpen, _ref3) {
      var ruleId = _ref3.ruleId;
      var expanded = _this.state.expanded;
      var collapseKey = ruleId || key / 2;

      if (isOpen) {
        _this.setState({
          expanded: [].concat((0, _toConsumableArray2["default"])(expanded), [collapseKey])
        });
      } else {
        var currIndex = expanded.findIndex(function (id) {
          return id === collapseKey;
        });
        expanded.splice(currIndex, 1);

        _this.setState({
          expanded: expanded
        });
      }
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onFilterChange", function (type, _e, value) {
      _this.setState({
        filterValues: _objectSpread(_objectSpread({}, _this.state.filterValues), {}, (0, _defineProperty2["default"])({}, type, value))
      }, function () {
        return _this.onUpdate(true);
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onSort", function (_e, index, direction) {
      var _this$props2 = _this.props,
          fetchData = _this$props2.fetchData,
          rules = _this$props2.rules,
          columns = _this$props2.columns,
          detail = _this$props2.detail;
      var filterValues = _this.state.filterValues;
      fetchData({
        meta: (0, _helpers.calculateMeta)(rules.meta),
        filterValues: filterValues,
        sortBy: {
          index: index,
          direction: direction,
          column: columns[index - Boolean(detail)]
        }
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onPaginate", function (perPage, page) {
      var _this$props3 = _this.props,
          fetchData = _this$props3.fetchData,
          rules = _this$props3.rules,
          columns = _this$props3.columns,
          detail = _this$props3.detail,
          sortBy = _this$props3.sortBy;
      var filterValues = _this.state.filterValues;
      fetchData({
        meta: _objectSpread(_objectSpread({}, (0, _helpers.calculateMeta)(rules.meta)), {}, {
          perPage: perPage,
          page: page
        }),
        filterValues: filterValues,
        sortBy: _objectSpread(_objectSpread({}, sortBy), {}, {
          column: columns[sortBy.index - Boolean(detail)]
        })
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(RuleTable, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!(0, _isEqual["default"])(prevProps.filterValues, this.props.filterValues)) {
        this.setState({
          filterValues: this.props.filterValues
        });
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setState({
        filterValues: this.props.filterValues
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props4 = this.props,
          rules = _this$props4.rules,
          filters = _this$props4.filters,
          columns = _this$props4.columns,
          detail = _this$props4.detail,
          actions = _this$props4.actions,
          ariaLabel = _this$props4.ariaLabel,
          fetchData = _this$props4.fetchData,
          isLoading = _this$props4.isLoading,
          sortBy = _this$props4.sortBy,
          toolbarProps = _this$props4.toolbarProps,
          _filterValues = _this$props4.filterValues,
          loadingBars = _this$props4.loadingBars,
          emptyStateTitle = _this$props4.emptyStateTitle,
          emptyStateDescription = _this$props4.emptyStateDescription,
          emptyStateIcon = _this$props4.emptyStateIcon,
          props = (0, _objectWithoutProperties2["default"])(_this$props4, ["rules", "filters", "columns", "detail", "actions", "ariaLabel", "fetchData", "isLoading", "sortBy", "toolbarProps", "filterValues", "loadingBars", "emptyStateTitle", "emptyStateDescription", "emptyStateIcon"]);
      var _this$state = this.state,
          expanded = _this$state.expanded,
          filterValues = _this$state.filterValues;
      var meta = rules.meta,
          data = rules.data;
      var defaultMeta = (0, _helpers.calculateMeta)(meta);

      var pagination = _objectSpread(_objectSpread({}, defaultMeta), {}, {
        onPerPageSelect: function onPerPageSelect(_e, perPage) {
          return _this2.onPaginate(perPage, 1);
        },
        onSetPage: function onSetPage(_e, page) {
          return _this2.onPaginate(defaultMeta.perPage, page);
        }
      });

      var filterItems = Object.entries(filters).map(function (_ref4) {
        var _ref5 = (0, _slicedToArray2["default"])(_ref4, 2),
            key = _ref5[0],
            filter = _ref5[1];

        return _objectSpread({}, filter({
          onChange: function onChange() {
            for (var _len2 = arguments.length, props = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
              props[_key2] = arguments[_key2];
            }

            return _this2.onFilterChange.apply(_this2, [key].concat(props));
          },
          value: filterValues[key],
          filterKey: key
        }));
      });
      return /*#__PURE__*/_react["default"].createElement("section", {
        className: "rhcs-c-rules-table"
      }, /*#__PURE__*/_react["default"].createElement(_PrimaryToolbar.PrimaryToolbar, (0, _extends2["default"])({}, filterItems && filterItems.length > 0 && {
        filterConfig: {
          items: filterItems
        }
      }, {
        activeFiltersConfig: {
          filters: Object.entries(filterValues).map(function (_ref6) {
            var _ref7 = (0, _slicedToArray2["default"])(_ref6, 2),
                key = _ref7[0],
                value = _ref7[1];

            return (0, _helpers.calculateActiveFilters)(filterItems.find(function (_ref8) {
              var filterKey = _ref8.filterKey;
              return filterKey === key;
            }), value, key);
          }).filter(Boolean),
          onDelete: this.onFilterDelete
        },
        pagination: pagination
      }, toolbarProps)), /*#__PURE__*/_react["default"].createElement(_reactTable.Table, (0, _extends2["default"])({}, props, sortBy && {
        sortBy: sortBy,
        onSort: this.onSort
      }, {
        actions: !isLoading && actions,
        "aria-label": ariaLabel,
        cells: columns.map(function (_ref9) {
          var transforms = _ref9.transforms,
              column = (0, _objectWithoutProperties2["default"])(_ref9, ["transforms"]);
          return _objectSpread(_objectSpread({}, column), {}, {
            transforms: [].concat((0, _toConsumableArray2["default"])(transforms || []), (0, _toConsumableArray2["default"])(!isLoading && sortBy && !column.disableSort ? [_reactTable.sortable] : []))
          });
        }),
        rows: isLoading ? (0, _toConsumableArray2["default"])(new Array(loadingBars)).map(function () {
          return {
            cells: [{
              title: /*#__PURE__*/_react["default"].createElement(_Skeleton.Skeleton, {
                size: "lg"
              }),
              props: {
                colSpan: columns.length + Boolean(actions)
              }
            }]
          };
        }) : data.length > 0 ? (0, _flatten["default"])((0, _helpers.createRows)(data, columns, expanded, detail)).filter(Boolean) : [{
          heightAuto: true,
          cells: [{
            props: {
              colSpan: columns.length + Boolean(actions)
            },
            title: /*#__PURE__*/_react["default"].createElement(_Bullseye.Bullseye, null, /*#__PURE__*/_react["default"].createElement(_EmptyState.EmptyState, {
              variant: _EmptyState.EmptyStateVariant.small
            }, /*#__PURE__*/_react["default"].createElement(_EmptyStateIcon.EmptyStateIcon, {
              icon: emptyStateIcon
            }), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
              headingLevel: "h2",
              size: "lg"
            }, emptyStateTitle), /*#__PURE__*/_react["default"].createElement(_EmptyStateBody.EmptyStateBody, null, emptyStateDescription)))
          }]
        }]
      }, !isLoading && detail && data.length > 0 && {
        onCollapse: this.onCollapse
      }), /*#__PURE__*/_react["default"].createElement(_reactTable.TableHeader, null), /*#__PURE__*/_react["default"].createElement(_reactTable.TableBody, null)), /*#__PURE__*/_react["default"].createElement(_TableToolbar.TableToolbar, {
        isFooter: true
      }, /*#__PURE__*/_react["default"].createElement(_Pagination.Pagination, (0, _extends2["default"])({}, pagination, {
        widgetId: "pagination-options-menu-bottom",
        variant: _Pagination.PaginationVariant.bottom,
        dropDirection: "up"
      }))));
    }
  }]);
  return RuleTable;
}(_react.Component);

RuleTable.propTypes = {
  ariaLabel: _propTypes["default"].string,
  rules: _propTypes["default"].shape({
    meta: _propTypes["default"].shape({
      count: _propTypes["default"].number,
      offset: _propTypes["default"].number,
      limit: _propTypes["default"].offset
    }),
    data: _propTypes["default"].arrayOf(_propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any)))
  }),
  isLoading: _propTypes["default"].bool,
  columns: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    title: _propTypes["default"].node,
    selector: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].arrayOf(_propTypes["default"].string), _propTypes["default"].func]),
    disableSort: _propTypes["default"].bool
  })),
  sort: _propTypes["default"].string,
  emptyStateTitle: _propTypes["default"].string,
  emptyStateDescription: _propTypes["default"].node,
  emptyStateIcon: _propTypes["default"].node,
  defaultFilters: _propTypes["default"].arrayOf(_propTypes["default"].shape({})),
  fetchData: _propTypes["default"].func,
  detail: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].node]),
  actions: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    title: _propTypes["default"].node,
    onClick: _propTypes["default"].func
  })),
  sortBy: _propTypes["default"].shape({
    index: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number]),
    direction: _propTypes["default"].string
  }),
  filterValues: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].oneOfType([_propTypes["default"].arrayOf(_propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number])), _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number])]))),
  toolbarProps: _propTypes["default"].any,
  loadingBars: _propTypes["default"].number,
  filters: _propTypes["default"].object
};
RuleTable.defaultProps = {
  rules: {
    data: []
  },
  columns: [],
  ariaLabel: 'Rules table',
  isLoading: false,
  sortBy: {},
  filters: {},
  filterValues: {},
  fetchData: function fetchData() {
    return undefined;
  },
  loadingBars: 5,
  emptyStateTitle: 'No results found',
  emptyStateDescription: 'No results match the filter criteria. Remove all filters or clear all filters to show results.',
  emptyStateIcon: _searchIcon["default"]
};
var _default = RuleTable;
exports["default"] = _default;