var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import { Select, SelectOption, SelectVariant, Radio as InputRadio } from '@patternfly/react-core';
import Text from './TextFilter';
var Radio = (function (_super) {
    __extends(Radio, _super);
    function Radio() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isExpanded: false,
            checked: undefined,
        };
        _this.onToggle = function (isExpanded) {
            _this.setState({
                isExpanded: isExpanded,
            });
        };
        _this.calculateSelected = function () {
            var checked = _this.state.checked;
            var selectedValue = _this.props.value;
            return (selectedValue && (selectedValue.value || selectedValue)) || (checked && (checked.value || checked));
        };
        _this.onSelect = function (event, selection) {
            var onChange = _this.props.onChange;
            onChange(event, selection);
            _this.setState({ checked: selection });
        };
        return _this;
    }
    Radio.prototype.render = function () {
        var isExpanded = this.state.isExpanded;
        var _a = this.props, items = _a.items, placeholder = _a.placeholder, isDisabled = _a.isDisabled, className = _a.className;
        var checkedValue = this.calculateSelected();
        return (React.createElement(Fragment, null, !items || (items && items.length <= 0) ? (React.createElement(Text, __assign({}, this.props, { value: "".concat(this.calculateSelected()) }))) : (React.createElement(Select, { className: className, variant: SelectVariant.single, "aria-label": "Select Input", isDisabled: isDisabled, onToggle: this.onToggle, onSelect: this.onSelect, isOpen: isExpanded, placeholderText: placeholder, ouiaId: placeholder }, items.map(function (_a, key) {
            var value = _a.value, isChecked = _a.isChecked, onChange = _a.onChange, label = _a.label, id = _a.id, item = __rest(_a, ["value", "isChecked", "onChange", "label", "id"]);
            return (React.createElement(SelectOption, __assign({}, item, { key: id || key, value: value || '' + key }),
                React.createElement(InputRadio, __assign({}, item, { name: id || "".concat(key, "-radio"), label: label, value: value || key, isChecked: isChecked ||
                        (checkedValue !== undefined && checkedValue === value) ||
                        (checkedValue !== undefined && checkedValue === '' + key) ||
                        false, onChange: function (_value, e) { return onChange && onChange(e, __assign({ id: id, label: label, value: value, isChecked: isChecked }, item), key); }, id: id || "".concat(value, "-").concat(key) }))));
        })))));
    };
    return Radio;
}(Component));
Radio.propTypes = {
    onChange: PropTypes.func,
    value: PropTypes.oneOfType([
        PropTypes.string,
        PropTypes.shape({
            label: PropTypes.node,
            value: PropTypes.string,
        }),
    ]),
    placeholder: PropTypes.string,
    items: PropTypes.arrayOf(PropTypes.shape({
        value: PropTypes.string,
        label: PropTypes.node,
        id: PropTypes.string,
        isChecked: PropTypes.bool,
        onChange: PropTypes.func,
    })),
    isDisabled: PropTypes.bool,
    className: PropTypes.string,
};
Radio.defaultProps = {
    items: [],
    onChange: function () { return undefined; },
    isDisabled: false,
};
export default Radio;
//# sourceMappingURL=RadioFilter.js.map