"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.groupType = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Select = require("@patternfly/react-core/dist/js/components/Select/Select.js");

var _SelectOption = require("@patternfly/react-core/dist/js/components/Select/SelectOption.js");

var _selectConstants = require("@patternfly/react-core/dist/js/components/Select/selectConstants.js");

var _SelectGroup = require("@patternfly/react-core/dist/js/components/Select/SelectGroup.js");

var _Radio = require("@patternfly/react-core/dist/js/components/Radio/Radio.js");

var _Checkbox = require("@patternfly/react-core/dist/js/components/Checkbox/Checkbox.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _TextFilter = _interopRequireDefault(require("./TextFilter"));

var _isEqual = _interopRequireDefault(require("lodash/isEqual"));

var _PropTypes$shape4;

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var groupType = {
  checkbox: 'checkbox',
  radio: 'radio',
  button: 'button',
  plain: 'plain'
};
exports.groupType = groupType;

var Group = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Group, _Component);

  var _super = _createSuper(Group);

  function Group() {
    var _this;

    (0, _classCallCheck2["default"])(this, Group);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      isExpanded: false,
      selected: {},
      filterBy: ''
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onToggle", function (isExpanded) {
      _this.setState({
        isExpanded: isExpanded
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "mapItems", function (_ref, groupKey) {
      var groupValue = _ref.groupValue,
          onSelect = _ref.onSelect,
          groupLabel = _ref.groupLabel,
          groupId = _ref.groupId,
          type = _ref.type,
          variant = _ref.variant,
          items = _ref.items,
          group = (0, _objectWithoutProperties2["default"])(_ref, ["groupValue", "onSelect", "groupLabel", "groupId", "type", "variant", "items"]);
      var onFilter = _this.props.onFilter;
      var filterBy = _this.state.filterBy;
      var input;

      try {
        input = new RegExp(filterBy, 'i');
      } catch (err) {
        input = new RegExp(filterBy.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'i');
      }

      return items.filter(function (item) {
        return onFilter || groupValue && input.test(groupValue) || groupLabel && input.test(groupLabel) || item.value && input.test(item.value) || item.label && input.test(item.label);
      }).map(function (_ref2, key) {
        var value = _ref2.value,
            isChecked = _ref2.isChecked,
            _onClick = _ref2.onClick,
            label = _ref2.label,
            itemProps = _ref2.props,
            id = _ref2.id,
            item = (0, _objectWithoutProperties2["default"])(_ref2, ["value", "isChecked", "onClick", "label", "props", "id"]);
        return /*#__PURE__*/_react["default"].createElement(_SelectOption.SelectOption, (0, _extends2["default"])({}, item, {
          label: groupLabel || '',
          key: id || key,
          value: String(value || id || key || ''),
          onClick: function onClick(e) {
            var _this2;

            if (e.target.tagName !== 'INPUT') {
              e.preventDefault();
              e.stopPropagation();
            }

            var clickedGroup = _objectSpread({
              value: groupValue,
              label: groupLabel,
              id: groupId,
              type: type,
              items: items
            }, group);

            var clickedItem = _objectSpread({
              value: value,
              label: label,
              id: id,
              type: type
            }, item);

            var props = [e, clickedGroup, clickedItem, groupValue || groupKey, value || key];

            (_this2 = _this).onSelect.apply(_this2, props);

            onSelect && onSelect.apply(void 0, props);
            _onClick && _onClick.apply(void 0, props);
          }
        }), type === groupType.checkbox ? /*#__PURE__*/_react["default"].createElement(_Checkbox.Checkbox, (0, _extends2["default"])({}, itemProps, {
          label: label,
          isChecked: isChecked || _this.isChecked(groupValue || groupKey, value || key, id, item === null || item === void 0 ? void 0 : item.tagValue) || false,
          onChange: function onChange(value, event) {
            item.onChange && item.onChange(value, event);
          },
          name: item.name || value || "".concat(groupKey, "-").concat(key),
          id: id || value || "".concat(groupKey, "-").concat(key)
        })) : type === groupType.radio ? /*#__PURE__*/_react["default"].createElement(_Radio.Radio, {
          isChecked: isChecked || _this.isChecked(groupValue || groupKey, value || key, id, item === null || item === void 0 ? void 0 : item.tagValue) || false,
          onChange: function onChange(value, event) {
            item.onChange && item.onChange(value, event);
          },
          value: value || key,
          name: item.name || value || "".concat(groupKey, "-").concat(key),
          label: label,
          id: id || value || "".concat(groupKey, "-").concat(key)
        }) : type === groupType.button ? /*#__PURE__*/_react["default"].createElement(_Button.Button, (0, _extends2["default"])({}, itemProps, {
          className: "pf-c-select__option-button ".concat((itemProps === null || itemProps === void 0 ? void 0 : itemProps.className) || ''),
          variant: variant,
          onClick: item.onClick
        }), label) : [// we have to wrap it in array, otherwise PF will complain
        type !== groupType.checkbox && type !== groupType.radio ? label : '']);
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "calculateSelected", function (_ref3, groupKey, itemKey) {
      var type = _ref3.type;
      var selected = _this.state.selected;
      var propSelected = _this.props.selected;
      var activeGroup = selected[groupKey] || propSelected[groupKey];

      if (activeGroup) {
        if (type !== groupType.radio && (activeGroup[itemKey] instanceof Object ? activeGroup[itemKey].isSelected : Boolean(activeGroup[itemKey]))) {
          return _objectSpread(_objectSpread(_objectSpread({}, propSelected), selected), {}, (0, _defineProperty2["default"])({}, groupKey, _objectSpread(_objectSpread({}, activeGroup || {}), {}, (0, _defineProperty2["default"])({}, itemKey, false))));
        }

        return _objectSpread(_objectSpread(_objectSpread({}, propSelected), selected), {}, (0, _defineProperty2["default"])({}, groupKey, _objectSpread(_objectSpread({}, type !== groupType.radio ? activeGroup || {} : {}), {}, (0, _defineProperty2["default"])({}, itemKey, true))));
      }

      return _objectSpread(_objectSpread(_objectSpread({}, propSelected), selected), {}, (0, _defineProperty2["default"])({}, groupKey, (0, _defineProperty2["default"])({}, itemKey, true)));
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "setNewSelection", function (onChange, event, newSelection, group, item, groupKey, itemKey) {
      if (onChange) {
        if (group) {
          onChange(event, newSelection, group, item, groupKey, itemKey);
        } else {
          onChange(event, newSelection);
        }

        _this.setState({
          selected: {}
        });
      }

      _this.setState({
        selected: newSelection
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onSelect", function (event, group, item, groupKey, itemKey) {
      var newSelection = _this.calculateSelected(group, groupKey, itemKey);

      var onChange = _this.props.onChange;

      _this.setNewSelection(onChange, event, newSelection, group, item, groupKey, itemKey);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onGroupSelect", function (event, groupValue, items) {
      var onChange = _this.props.onChange;
      var currentSelection = _this.state.selected;
      var allSelected = Object.values(currentSelection[groupValue] || {}).filter(function (value) {
        return value === true;
      }).length === items.length;
      var newSelection = allSelected ? {} : _objectSpread(_objectSpread({}, currentSelection), {}, (0, _defineProperty2["default"])({}, groupValue, items.reduce(function (selection, currentItem) {
        return _objectSpread(_objectSpread({}, selection), {}, (0, _defineProperty2["default"])({}, currentItem.value, true));
      }, {})));

      _this.setNewSelection(onChange, event, newSelection);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "isGroupChecked", function (groupValue, items) {
      var stateSelected = _this.state.selected;
      var propSelected = _this.props.selected;

      var selected = _objectSpread(_objectSpread({}, propSelected), stateSelected);

      var selectedGroupValues = Object.values(selected[groupValue] || {}).filter(function (value) {
        return value === true;
      });
      var groupSelected = selectedGroupValues.length > 0 ? selectedGroupValues.length === items.length ? true : null : false;
      return groupSelected;
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "isChecked", function (groupValue, itemValue, id, tagValue) {
      var stateSelected = _this.state.selected;
      var propSelected = _this.props.selected;

      var selected = _objectSpread(_objectSpread({}, propSelected), stateSelected);

      if (typeof selected[groupValue] === 'undefined') {
        return false;
      }

      if (selected[groupValue][itemValue] instanceof Object) {
        if (selected[groupValue][itemValue].isSelected) {
          var _selected$groupValue$, _selected$groupValue$2, _selected$groupValue$5, _selected$groupValue$6;

          if ((_selected$groupValue$ = selected[groupValue][itemValue]) !== null && _selected$groupValue$ !== void 0 && (_selected$groupValue$2 = _selected$groupValue$.item) !== null && _selected$groupValue$2 !== void 0 && _selected$groupValue$2.id) {
            var _selected$groupValue$3, _selected$groupValue$4;

            return id === ((_selected$groupValue$3 = selected[groupValue][itemValue]) === null || _selected$groupValue$3 === void 0 ? void 0 : (_selected$groupValue$4 = _selected$groupValue$3.item) === null || _selected$groupValue$4 === void 0 ? void 0 : _selected$groupValue$4.id);
          } else if ((_selected$groupValue$5 = selected[groupValue][itemValue]) !== null && _selected$groupValue$5 !== void 0 && (_selected$groupValue$6 = _selected$groupValue$5.item) !== null && _selected$groupValue$6 !== void 0 && _selected$groupValue$6.tagValue) {
            var _selected$groupValue$7, _selected$groupValue$8;

            return tagValue === ((_selected$groupValue$7 = selected[groupValue][itemValue]) === null || _selected$groupValue$7 === void 0 ? void 0 : (_selected$groupValue$8 = _selected$groupValue$7.item) === null || _selected$groupValue$8 === void 0 ? void 0 : _selected$groupValue$8.tagValue);
          }
        }

        return selected[groupValue][itemValue].isSelected;
      }

      return Boolean(selected[groupValue][itemValue]);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "customFilter", function (e) {
      var onFilter = _this.props.onFilter;
      var value = e.target.value;

      _this.setState({
        filterBy: value
      }, function () {
        onFilter && onFilter(value);
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "clearSelection", function () {
      var onFilter = _this.props.onFilter;
      onFilter && onFilter('');

      _this.setState({
        filterBy: '',
        isExpanded: false
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(Group, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(_ref4) {
      var prevSelected = _ref4.selected,
          prevFilterBy = _ref4.filterBy;
      var _this$props = this.props,
          selected = _this$props.selected,
          filterBy = _this$props.filterBy;

      if (!(0, _isEqual["default"])(prevSelected, selected)) {
        this.setState({
          selected: selected
        });
      }

      if (filterBy !== undefined && prevFilterBy !== filterBy) {
        this.setState({
          filterBy: filterBy
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$state = this.state,
          isExpanded = _this$state.isExpanded,
          filterBy = _this$state.filterBy;
      var _this$props2 = this.props,
          groups = _this$props2.groups,
          items = _this$props2.items,
          placeholder = _this$props2.placeholder,
          className = _this$props2.className,
          selected = _this$props2.selected,
          isFilterable = _this$props2.isFilterable,
          isDisabled = _this$props2.isDisabled,
          onFilter = _this$props2.onFilter,
          onShowMore = _this$props2.onShowMore,
          showMoreTitle = _this$props2.showMoreTitle,
          showMoreOptions = _this$props2.showMoreOptions;
      var filterItems = items || groups;
      var showMore = {
        type: groupType.button,
        variant: (showMoreOptions === null || showMoreOptions === void 0 ? void 0 : showMoreOptions.variant) || 'link',
        items: [_objectSpread(_objectSpread({}, showMoreOptions), {}, {
          label: showMoreTitle,
          type: groupType.button,
          onClick: function onClick(e) {
            return onShowMore(e, function () {
              return _this3.setState({
                isExpanded: false
              });
            });
          }
        })]
      };
      return /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, !filterItems || filterItems && filterItems.length <= 0 ? /*#__PURE__*/_react["default"].createElement(_TextFilter["default"], (0, _extends2["default"])({}, this.props, {
        value: "".concat(selected)
      })) : /*#__PURE__*/_react["default"].createElement(_Select.Select, (0, _extends2["default"])({
        className: className,
        variant: isFilterable || onFilter ? _selectConstants.SelectVariant.typeahead : _selectConstants.SelectVariant.single,
        "aria-label": "Select Input",
        onToggle: this.onToggle,
        isOpen: isExpanded,
        isDisabled: isDisabled,
        onSelect: function onSelect() {
          return undefined;
        },
        placeholderText: placeholder,
        onClear: this.clearSelection,
        selections: filterBy === '' ? null : filterBy
      }, (isFilterable || onFilter) && {
        onFilter: function onFilter(e) {
          return e && _this3.customFilter(e);
        }
      }, groups && groups.length > 0 && {
        isGrouped: true
      }), /*#__PURE__*/_react["default"].createElement("div", {
        className: "ins-c-select__scrollable-section",
        value: ""
      }, groups && groups.length > 0 ? groups.map(function (_ref5, groupKey) {
        var groupValue = _ref5.value,
            onSelect = _ref5.onSelect,
            groupSelectable = _ref5.groupSelectable,
            groupLabel = _ref5.label,
            groupId = _ref5.id,
            type = _ref5.type,
            items = _ref5.items,
            group = (0, _objectWithoutProperties2["default"])(_ref5, ["value", "onSelect", "groupSelectable", "label", "id", "type", "items"]);

        var filteredItems = _this3.mapItems(_objectSpread({
          groupValue: groupValue,
          onSelect: onSelect,
          groupLabel: groupLabel,
          groupId: groupId,
          groupSelectable: groupSelectable,
          type: type,
          items: items
        }, group), groupKey).filter(Boolean);

        return (
          /*#__PURE__*/

          /**
           * DO NOT DELET THE EMPTY VALUE ON THE DIV ELEMENT
           * If we delete it, it breaks the select filtering
           * Here is the code that creates the runtime crash:
           * https://github.com/patternfly/patternfly-react/blob/master/packages/react-core/src/components/Select/Select.tsx#L615
           */
          _react["default"].createElement("div", {
            key: groupId || groupValue || groupKey,
            value: ""
          }, groupSelectable && /*#__PURE__*/_react["default"].createElement(_SelectOption.SelectOption, {
            onClick: function onClick(event) {
              _this3.onGroupSelect(event, groupValue || groupKey, items);
            }
          }, /*#__PURE__*/_react["default"].createElement(_Checkbox.Checkbox, {
            isChecked: _this3.isGroupChecked(groupValue || groupKey, items),
            label: groupLabel
          })), /*#__PURE__*/_react["default"].createElement(_SelectGroup.SelectGroup, (0, _extends2["default"])({}, group, {
            className: "pf-u-pl-sm",
            label: !groupSelectable && groupLabel,
            value: groupId || groupValue || groupKey,
            id: groupId || "group-".concat(groupValue || groupKey)
          }), filteredItems))
        );
      }) : this.mapItems({
        items: items
      })), onShowMore ? /*#__PURE__*/_react["default"].createElement(_SelectGroup.SelectGroup, {
        value: ""
      }, /*#__PURE__*/_react["default"].createElement(_Button.Button, (0, _extends2["default"])({}, showMore.items[0], {
        className: "pf-c-select__menu-item",
        variant: showMore.variant,
        onClick: showMore.items[0].onClick,
        value: "Show more"
      }), showMore.items[0].label)) : /*#__PURE__*/_react["default"].createElement("span", {
        hidden: true,
        value: ""
      })));
    }
  }]);
  return Group;
}(_react.Component);

var itemsProps = _propTypes["default"].arrayOf(_propTypes["default"].shape({
  value: _propTypes["default"].string,
  label: _propTypes["default"].node,
  id: _propTypes["default"].string,
  isChecked: _propTypes["default"].bool,
  onClick: _propTypes["default"].func,
  props: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any))
}));

Group.propTypes = {
  selected: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].oneOfType([_propTypes["default"].bool, _propTypes["default"].shape({
    isSelected: _propTypes["default"].bool
  })]))))),
  onChange: _propTypes["default"].func,
  groups: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    label: _propTypes["default"].node,
    value: _propTypes["default"].string,
    onSelect: _propTypes["default"].func,
    type: _propTypes["default"].oneOf(Object.values(groupType)),
    items: itemsProps
  })),
  filterBy: _propTypes["default"].string,
  items: itemsProps,
  isFilterable: _propTypes["default"].bool,
  onFilter: _propTypes["default"].func,
  onShowMore: _propTypes["default"].func,
  showMoreTitle: _propTypes["default"].string,
  isDisabled: _propTypes["default"].bool,
  showMoreOptions: _propTypes["default"].shape((_PropTypes$shape4 = {
    variant: _propTypes["default"].string
  }, (0, _defineProperty2["default"])(_PropTypes$shape4, _propTypes["default"].string, _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number])), (0, _defineProperty2["default"])(_PropTypes$shape4, "props", (0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number]))), _PropTypes$shape4)),
  placeholder: _propTypes["default"].node,
  className: _propTypes["default"].string
};
Group.defaultProps = {
  selected: {},
  filterBy: '',
  onChange: function onChange() {
    return undefined;
  },
  showMoreTitle: 'Show more',
  groups: [],
  isFilterable: false,
  isDisabled: false
};
var _default = Group;
exports["default"] = _default;