"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactTable = require("@patternfly/react-table");

var _classnames = _interopRequireDefault(require("classnames"));

var TreeRowWrapper = function TreeRowWrapper(props) {
  var className = props.className;

  var _ref = props.row || {},
      level = _ref.level,
      isTreeOpen = _ref.isTreeOpen,
      point = _ref.point,
      posinset = _ref.posinset;

  return /*#__PURE__*/_react["default"].createElement(_reactTable.RowWrapper, (0, _extends2["default"])({}, props, {
    "aria-level": level === undefined ? 1 : level + 1,
    "aria-posinset": posinset,
    "aria-setsize": point ? point.size : 0,
    className: (0, _classnames["default"])({
      className: className,
      'pf-m-expandable': isTreeOpen === true || isTreeOpen === false,
      'pf-m-expanded': isTreeOpen === true
    })
  }));
};

TreeRowWrapper.propTypes = {
  rows: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    level: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number]),
    isTreeOpen: _propTypes["default"].bool,
    point: _propTypes["default"].shape({
      size: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number])
    }),
    posinset: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number])
  })),
  className: _propTypes["default"].string,
  row: _propTypes["default"].object
};
var _default = TreeRowWrapper;
exports["default"] = _default;