import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import Icon404 from './icon-404';
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import "../../InvalidObject/./invalidObject.css"; // Don't use chrome here because the 404 page on landing does not use chrome

var isBeta = function isBeta() {
  return window.location.pathname.split('/')[1] === 'beta' ? '/beta' : '';
};

var InvalidObject = function InvalidObject(_ref) {
  var props = _extends({}, _ref);

  return /*#__PURE__*/React.createElement("section", _extends({}, props, {
    className: "pf-l-page__main-section pf-c-page__main-section ins-c-component_invalid-componet"
  }), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h1",
    size: "3xl"
  }, "We lost that page"), /*#__PURE__*/React.createElement(Icon404, null), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h1",
    size: "xl",
    className: "ins-c-text__sorry"
  }, "Let's find you a new one. Try a new search or return home."), /*#__PURE__*/React.createElement(Button, {
    variant: "link",
    component: "a",
    href: "".concat(window.location.origin).concat(isBeta())
  }, "Return to homepage"));
};

export default InvalidObject;