"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBulletComparativeMeasure = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_bar_1 = require("victory-bar");
const utils_1 = require("./utils");
const ChartBar_1 = require("../ChartBar");
const ChartContainer_1 = require("../ChartContainer");
const ChartTheme_1 = require("../ChartTheme");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
const ChartBulletComparativeMeasure = ({ allowTooltip = true, ariaDesc, ariaTitle, barWidth = ChartTheme_1.ChartBulletStyles.comparativeMeasureWidth, constrainToVisibleArea = false, data, domain, horizontal = true, labels, measureComponent = React.createElement(ChartBar_1.ChartBar, null), // Using bar instead of line for tooltip functionality
padding, standalone = true, themeColor, themeVariant, y, 
// destructure last
theme = ChartUtils_1.getBulletComparativeMeasureTheme(themeColor, themeVariant), height = theme.bar.height, width = theme.bar.width, labelComponent = React.createElement(ChartTooltip_1.ChartTooltip, null) }) => {
    const computedData = utils_1.getComparativeMeasureData({
        data,
        theme,
        y
    });
    // Label component
    //
    // Note: SVG height and width are provided by ChartBullet as a workaround to support constrainToVisibleArea
    const tooltip = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea, dx: () => {
            if (horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return result / 2;
        }, dy: () => {
            if (!horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return -(result / 2);
        }, orientation: 'top' }, labelComponent.props));
    const measure = computedData.map((dataPoint, index) => React.cloneElement(measureComponent, Object.assign({ barWidth, data: [Object.assign({}, dataPoint)], domain,
        height,
        horizontal, labelComponent: allowTooltip ? tooltip : undefined, labels, key: `pf-chart-bullet-comparative-measure-${index}`, padding, standalone: false, theme,
        width }, measureComponent.props)));
    return standalone ? (React.createElement(ChartContainer_1.ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
exports.ChartBulletComparativeMeasure = ChartBulletComparativeMeasure;
exports.ChartBulletComparativeMeasure.displayName = 'ChartBulletComparativeMeasure';
// Note: VictoryBar.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartBulletComparativeMeasure, victory_bar_1.VictoryBar);
//# sourceMappingURL=ChartBulletComparativeMeasure.js.map