"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseProps = exports.getDataWithBaseline = void 0;

var _isNil2 = _interopRequireDefault(require("lodash/isNil"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getDataWithBaseline = function (props, scale) {
  var data = _victoryCore.Data.getData(props);

  if (data.length < 2) {
    data = [];
  }

  var getDefaultMin = function (axis) {
    var defaultZero = _victoryCore.Scale.getType(scale[axis]) === "log" ? 1 / Number.MAX_SAFE_INTEGER : 0;
    var domain = scale[axis].domain();

    var minY = _victoryCore.Collection.getMinValue(domain);

    var maxY = _victoryCore.Collection.getMaxValue(domain);

    var defaultMin = defaultZero;

    if (minY < 0 && maxY <= 0) {
      defaultMin = maxY;
    } else if (minY >= 0 && maxY > 0) {
      defaultMin = minY;
    }

    return _victoryCore.Collection.containsDates(domain) ? new Date(defaultMin) : defaultMin;
  };

  return data.map(function (datum) {
    var _y1 = datum._y1 !== undefined ? datum._y1 : datum._y;

    var _y0 = datum._y0 !== undefined ? datum._y0 : getDefaultMin("y");

    var _x1 = datum._x1 !== undefined ? datum._x1 : datum._x;

    var _x0 = datum._x0 !== undefined ? datum._x0 : getDefaultMin("x");

    return (0, _assign2.default)({}, datum, {
      _y0: _y0,
      _y1: _y1,
      _x0: _x0,
      _x1: _x1
    });
  });
};

exports.getDataWithBaseline = getDataWithBaseline;

var getCalculatedValues = function (props) {
  var polar = props.polar;

  var defaultStyles = _victoryCore.Helpers.getDefaultStyles(props, "area");

  var style = _victoryCore.Helpers.getStyles(props.style, defaultStyles);

  var range = {
    x: _victoryCore.Helpers.getRange(props, "x"),
    y: _victoryCore.Helpers.getRange(props, "y")
  };
  var domain = {
    x: _victoryCore.Domain.getDomainWithZero(props, "x"),
    y: _victoryCore.Domain.getDomainWithZero(props, "y")
  };
  var scale = {
    x: _victoryCore.Scale.getBaseScale(props, "x").domain(domain.x).range(props.horizontal ? range.y : range.x),
    y: _victoryCore.Scale.getBaseScale(props, "y").domain(domain.y).range(props.horizontal ? range.x : range.y)
  };
  var origin = polar ? props.origin || _victoryCore.Helpers.getPolarOrigin(props) : undefined;
  var data = getDataWithBaseline(props, scale);
  return {
    style: style,
    data: data,
    scale: scale,
    domain: domain,
    origin: origin
  };
};

var getBaseProps = function (props, fallbackProps) {
  var modifiedProps = _victoryCore.Helpers.modifyProps(props, fallbackProps, "area");

  props = (0, _assign2.default)({}, modifiedProps, getCalculatedValues(modifiedProps));
  var _props = props,
      data = _props.data,
      domain = _props.domain,
      events = _props.events,
      groupComponent = _props.groupComponent,
      height = _props.height,
      horizontal = _props.horizontal,
      interpolation = _props.interpolation,
      origin = _props.origin,
      padding = _props.padding,
      polar = _props.polar,
      scale = _props.scale,
      sharedEvents = _props.sharedEvents,
      standalone = _props.standalone,
      style = _props.style,
      theme = _props.theme,
      width = _props.width,
      labels = _props.labels,
      name = _props.name,
      disableInlineStyles = _props.disableInlineStyles;
  var initialChildProps = {
    parent: {
      style: style.parent,
      width: width,
      height: height,
      scale: scale,
      data: data,
      domain: domain,
      standalone: standalone,
      theme: theme,
      polar: polar,
      origin: origin,
      padding: padding,
      name: name,
      horizontal: horizontal
    },
    all: {
      data: {
        horizontal: horizontal,
        polar: polar,
        origin: origin,
        scale: scale,
        data: data,
        interpolation: interpolation,
        groupComponent: groupComponent,
        style: disableInlineStyles ? {} : style.data,
        disableInlineStyles: disableInlineStyles
      }
    }
  };
  return data.reduce(function (childProps, datum, index) {
    var text = _victoryCore.LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      var eventKey = !(0, _isNil2.default)(datum.eventKey) ? datum.eventKey : index;
      childProps[eventKey] = {
        labels: _victoryCore.LabelHelpers.getProps(props, index)
      };
    }

    return childProps;
  }, initialChildProps);
};

exports.getBaseProps = getBaseProps;