import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";
import { SplitItem } from "@patternfly/react-core/dist/esm/layouts/Split/SplitItem.js";
import { Split } from "@patternfly/react-core/dist/esm/layouts/Split/Split.js";
import { ToolbarItem } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarItem.js";
import { ToolbarGroup } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarGroup.js";
import { ToolbarToggleGroup } from "@patternfly/react-core/dist/esm/components/Toolbar/ToolbarToggleGroup.js";
import FilterIcon from "@patternfly/react-icons/dist/esm/icons/filter-icon";
import globalBreakpointMd from '@patternfly/react-tokens/dist/js/global_breakpoint_md';
import Text from './TextFilter';
import { conditionalFilterType, typeMapper } from './conditionalFilterConstants';
import PropTypes from 'prop-types';
import "../../ConditionalFilter/./conditional-filter.css";
import { Fragment } from 'react';
import classNames from 'classnames';

var ConditionalFilter = /*#__PURE__*/function (_Component) {
  _inherits(ConditionalFilter, _Component);

  var _super = _createSuper(ConditionalFilter);

  function ConditionalFilter(_props) {
    var _this;

    _classCallCheck(this, ConditionalFilter);

    if (!_props.useMobileLayout) {
      console.warn("The prop \"useMobileLayout\" is set to false. You are using an outdated mobile layout of conditional filter.\n            Please switch to new layout by adding \"useMobileLayout={true}\" prop to the PrimaryToolbar or ConditionalFilter directly.\n            The new mobile layout will become the default in next minor release.");
    }

    _this = _super.call(this, _props);

    _defineProperty(_assertThisInitialized(_this), "dropdownToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (_e, value) {
      _this.setState({
        stateValue: value
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getWrapper", function () {
      return _this.props.useMobileLayout && _this.state.isMobile ? function (props) {
        return /*#__PURE__*/React.createElement(ToolbarToggleGroup, _extends({}, props, {
          breakpoint: "md",
          toggleIcon: /*#__PURE__*/React.createElement(FilterIcon, null)
        }));
      } : Fragment;
    });

    _defineProperty(_assertThisInitialized(_this), "updateFilterViewport", function (width) {
      return width <= _this.breakpointConstant;
    });

    _this.breakpointConstant = parseInt(globalBreakpointMd.value.replace('px', ''));
    _this.state = {
      isOpen: false,
      stateValue: undefined,
      isMobile: _this.updateFilterViewport(window.innerWidth)
    };
    return _this;
  }

  _createClass(ConditionalFilter, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.resizeListener = window.addEventListener('resize', function (event) {
        _this2.setState(function (prev) {
          return _objectSpread(_objectSpread({}, prev), {}, {
            isMobile: _this2.updateFilterViewport(event.target.innerWidth)
          });
        });
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.resizeListener) {
        window.removeEventListener(this.resizeListener);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          items = _this$props.items,
          value = _this$props.value,
          onChange = _this$props.onChange,
          placeholder = _this$props.placeholder,
          hideLabel = _this$props.hideLabel,
          isDisabled = _this$props.isDisabled,
          props = _objectWithoutProperties(_this$props, ["items", "value", "onChange", "placeholder", "hideLabel", "isDisabled"]);

      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          stateValue = _this$state.stateValue,
          isMobile = _this$state.isMobile;
      var currentValue = onChange ? value : stateValue;
      var activeItem = items && items.length && (items.find(function (item, key) {
        return item.value === currentValue || key === currentValue;
      }) || items[0]);
      var onChangeCallback = onChange || this.onChange;
      var ActiveComponent = activeItem && (typeMapper[activeItem.type] || typeMapper.text);

      var capitalize = function capitalize(string) {
        return string[0].toUpperCase() + string.substring(1);
      };

      var shouldRenderNewLayout = this.props.useMobileLayout && isMobile;
      var Wrapper = this.getWrapper();
      return /*#__PURE__*/React.createElement(Wrapper, null, this.props.useMobileLayout && isMobile && /*#__PURE__*/React.createElement(ToolbarGroup, {
        className: "ins-c-conditional-filter mobile"
      }, items.map(function (activeItem, key) {
        var ActiveComponent = activeItem && (typeMapper[activeItem.type] || typeMapper.text);
        return /*#__PURE__*/React.createElement(ToolbarItem, {
          key: key
        }, /*#__PURE__*/React.createElement(ActiveComponent, _extends({}, activeItem.type !== conditionalFilterType.custom && {
          placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
          id: activeItem.filterValues && activeItem.filterValues.id || currentValue
        }, activeItem.filterValues)));
      })), !shouldRenderNewLayout && /*#__PURE__*/React.createElement(Fragment, null, !items || items && items.length <= 0 ? /*#__PURE__*/React.createElement("div", {
        className: classNames('ins-c-conditional-filter', {
          desktop: this.props.useMobileLayout
        })
      }, /*#__PURE__*/React.createElement(Text, _extends({}, props, {
        value: currentValue,
        onChange: function onChange(e) {
          return onChangeCallback(e, e.target.value);
        },
        placeholder: placeholder,
        "widget-type": "InsightsInput"
      }))) : /*#__PURE__*/React.createElement(Split, {
        className: classNames('ins-c-conditional-filter', {
          desktop: this.props.useMobileLayout
        })
      }, items.length > 1 && /*#__PURE__*/React.createElement(SplitItem, null, /*#__PURE__*/React.createElement(Dropdown, {
        className: "ins-c-conditional-filter__group",
        onSelect: function onSelect() {
          return _this3.dropdownToggle(false);
        },
        isOpen: isOpen,
        ouiaId: "ConditionalFilter",
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, {
          onToggle: this.dropdownToggle,
          isDisabled: isDisabled,
          className: hideLabel ? 'ins-c-conditional-filter__no-label' : '',
          ouiaId: "ConditionalFilter"
        }, /*#__PURE__*/React.createElement(FilterIcon, {
          size: "sm"
        }), !hideLabel && /*#__PURE__*/React.createElement("span", {
          className: "ins-c-conditional-filter__value-selector"
        }, activeItem && capitalize(activeItem.label))),
        dropdownItems: items.map(function (item, key) {
          return /*#__PURE__*/React.createElement(DropdownItem, {
            key: item.id ? "".concat(item.id, "-dropdown") : key,
            component: "button",
            ouiaId: item.label,
            onClick: function onClick(e) {
              return onChangeCallback(e, item.value || key, item);
            },
            isHovered: activeItem.label === item.label
          }, capitalize(item.label));
        })
      })), ActiveComponent && /*#__PURE__*/React.createElement(SplitItem, {
        isFilled: true
      }, /*#__PURE__*/React.createElement(ActiveComponent, _extends({}, activeItem.type !== conditionalFilterType.custom && {
        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
        id: activeItem.filterValues && activeItem.filterValues.id || currentValue
      }, activeItem.filterValues))))));
    }
  }]);

  return ConditionalFilter;
}(Component);

var TextInputProps = {
  value: PropTypes.string,
  placeholder: PropTypes.string,
  onChange: PropTypes.func
};
ConditionalFilter.propTypes = _objectSpread(_objectSpread({
  hideLabel: PropTypes.bool,
  items: PropTypes.arrayOf(PropTypes.shape({
    id: PropTypes.string,
    label: PropTypes.node,
    value: PropTypes.string,
    type: PropTypes.oneOf(['text', 'checkbox', 'radio', 'custom', 'group']),
    filterValues: PropTypes.oneOfType([PropTypes.shape(TextInputProps), PropTypes.shape(_objectSpread(_objectSpread({}, TextInputProps), {}, {
      value: PropTypes.oneOfType([PropTypes.string, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
        label: PropTypes.node,
        value: PropTypes.string
      })])), PropTypes.shape(_defineProperty({}, PropTypes.string, PropTypes.any))]),
      items: PropTypes.arrayOf(PropTypes.shape({
        label: PropTypes.node,
        value: PropTypes.string
      }))
    }))])
  }))
}, TextInputProps), {}, {
  id: PropTypes.string,
  isDisabled: PropTypes.bool,
  useMobileLayout: PropTypes.bool
});
ConditionalFilter.defaultProps = {
  value: '',
  items: [],
  hideLabel: false,
  isDisabled: false,
  id: 'default-input',
  useMobileLayout: false
};
export default ConditionalFilter;