"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartDonut = exports.ChartDonutSubTitlePosition = exports.ChartDonutSortOrder = exports.ChartDonutLabelPosition = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_core_1 = require("victory-core");
const victory_pie_1 = require("victory-pie");
const chart_theme_1 = require("../ChartUtils/chart-theme");
const ChartContainer_1 = require("../ChartContainer");
const ChartLabel_1 = require("../ChartLabel");
const ChartPie_1 = require("../ChartPie");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
var ChartDonutLabelPosition;
(function (ChartDonutLabelPosition) {
    ChartDonutLabelPosition["centroid"] = "centroid";
    ChartDonutLabelPosition["endAngle"] = "endAngle";
    ChartDonutLabelPosition["startAngle"] = "startAngle";
})(ChartDonutLabelPosition = exports.ChartDonutLabelPosition || (exports.ChartDonutLabelPosition = {}));
var ChartDonutSortOrder;
(function (ChartDonutSortOrder) {
    ChartDonutSortOrder["ascending"] = "ascending";
    ChartDonutSortOrder["descending"] = "descending";
})(ChartDonutSortOrder = exports.ChartDonutSortOrder || (exports.ChartDonutSortOrder = {}));
var ChartDonutSubTitlePosition;
(function (ChartDonutSubTitlePosition) {
    ChartDonutSubTitlePosition["bottom"] = "bottom";
    ChartDonutSubTitlePosition["center"] = "center";
    ChartDonutSubTitlePosition["right"] = "right";
})(ChartDonutSubTitlePosition = exports.ChartDonutSubTitlePosition || (exports.ChartDonutSubTitlePosition = {}));
const ChartDonut = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, capHeight = 1.1, containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), innerRadius, legendAllowWrap, legendPosition = ChartTheme_1.ChartCommonStyles.legend.position, padAngle, padding, radius, standalone = true, subTitle, subTitleComponent, subTitlePosition = ChartTheme_1.ChartDonutStyles.label.subTitlePosition, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel_1.ChartLabel, null), 
    // destructure last
    theme = chart_theme_1.getDonutTheme(themeColor, themeVariant), height = theme.pie.height, width = theme.pie.width } = _a, rest = tslib_1.__rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "capHeight", "containerComponent", "innerRadius", "legendAllowWrap", "legendPosition", "padAngle", "padding", "radius", "standalone", "subTitle", "subTitleComponent", "subTitlePosition", "themeColor", "themeVariant", "title", "titleComponent", "theme", "height", "width"]);
    const defaultPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, theme.pie.padding),
        left: ChartUtils_1.getPaddingForSide('left', padding, theme.pie.padding),
        right: ChartUtils_1.getPaddingForSide('right', padding, theme.pie.padding),
        top: ChartUtils_1.getPaddingForSide('top', padding, theme.pie.padding)
    };
    const chartRadius = radius
        ? radius
        : victory_core_1.Helpers.getRadius({
            height,
            width,
            padding: defaultPadding
        });
    const chartInnerRadius = innerRadius ? innerRadius : chartRadius - 9; // Todo: Add pf-core variable
    const centerSubTitle = subTitle && subTitlePosition === ChartDonutSubTitlePosition.center;
    // Returns title and subtitle
    const getAllTitles = () => {
        if (!subTitleComponent && centerSubTitle) {
            return getTitle({
                styles: [ChartTheme_1.ChartDonutStyles.label.title, ChartTheme_1.ChartDonutStyles.label.subTitle],
                titles: [title, subTitle]
            });
        }
        return (React.createElement(React.Fragment, { key: "pf-chart-donut-titles" },
            getTitle({ titles: title, dy: centerSubTitle ? -8 : 0 }),
            getSubTitle({ textComponent: subTitleComponent, dy: centerSubTitle ? 15 : 0 })));
    };
    // This function will be evaluated for each slice with the props that correspond to that slice.
    const getPadAngle = ({ datum }) => (datum._y > 0 ? theme.pie.padAngle : 0);
    // Returns subtitle
    const getSubTitle = ({ dy = 0, textComponent = React.createElement(ChartLabel_1.ChartLabel, null) }) => {
        if (!subTitle) {
            return null;
        }
        const subTitleProps = textComponent.props ? textComponent.props : {};
        return React.cloneElement(textComponent, Object.assign({ key: 'pf-chart-donut-subtitle', style: ChartTheme_1.ChartDonutStyles.label.subTitle, text: subTitle, textAnchor: subTitlePosition === 'right' ? 'start' : 'middle', verticalAnchor: 'middle', x: ChartUtils_1.getPieLabelX({
                height,
                labelPosition: subTitlePosition,
                legendPosition,
                padding: defaultPadding,
                width
            }), y: ChartUtils_1.getPieLabelY({
                dy,
                height,
                labelPosition: subTitlePosition,
                padding: defaultPadding,
                width
            }) }, subTitleProps));
    };
    // Returns title
    const getTitle = ({ dy = 0, styles = ChartTheme_1.ChartDonutStyles.label.title, titles = title }) => {
        if (!titles) {
            return null;
        }
        const titleProps = titleComponent ? titleComponent.props : {};
        return React.cloneElement(titleComponent, Object.assign(Object.assign(Object.assign({}, (Array.isArray(titles) && { capHeight })), { key: 'pf-chart-donut-title', style: styles, text: titles, textAnchor: 'middle', verticalAnchor: 'middle', x: ChartUtils_1.getPieLabelX({
                height,
                labelPosition: 'center',
                legendPosition,
                padding: defaultPadding,
                width
            }), y: ChartUtils_1.getPieLabelY({
                dy,
                height,
                labelPosition: 'center',
                padding: defaultPadding,
                width
            }) }), titleProps));
    };
    const chart = (React.createElement(ChartPie_1.ChartPie, Object.assign({ allowTooltip: allowTooltip, height: height, innerRadius: chartInnerRadius > 0 ? chartInnerRadius : 0, key: "pf-chart-donut-pie", legendAllowWrap: legendAllowWrap, legendPosition: legendPosition, padAngle: padAngle !== undefined ? padAngle : getPadAngle, padding: padding, radius: chartRadius > 0 ? chartRadius : 0, standalone: false, theme: theme, width: width }, rest)));
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart, getAllTitles()]);
    return standalone ? (React.createElement(React.Fragment, null, container)) : (React.createElement(React.Fragment, null,
        chart,
        getAllTitles()));
};
exports.ChartDonut = ChartDonut;
exports.ChartDonut.displayName = 'ChartDonut';
// Note: VictoryPie.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartDonut, victory_pie_1.VictoryPie);
//# sourceMappingURL=ChartDonut.js.map