"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.routerParams = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRouterDom = require("react-router-dom");

var _reactRedux = require("react-redux");

var _isEqual = _interopRequireDefault(require("lodash/isEqual"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var routerParams = function routerParams(Component) {
  var RouterParams = /*#__PURE__*/function (_React$Component) {
    (0, _inherits2["default"])(RouterParams, _React$Component);

    var _super = _createSuper(RouterParams);

    function RouterParams() {
      (0, _classCallCheck2["default"])(this, RouterParams);
      return _super.apply(this, arguments);
    }

    (0, _createClass2["default"])(RouterParams, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        var _this$props = this.props,
            _this$props$match = _this$props.match,
            params = _this$props$match.params,
            path = _this$props$match.path,
            url = _this$props$match.url,
            onPathChange = _this$props.onPathChange,
            location = _this$props.location;

        if ((0, _reactRouterDom.matchPath)(location.pathname, {
          path: url,
          exact: true
        })) {
          onPathChange && onPathChange({
            params: params,
            path: path
          });
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        var _this$props2 = this.props,
            _this$props2$match = _this$props2.match,
            params = _this$props2$match.params,
            path = _this$props2$match.path,
            url = _this$props2$match.url,
            onPathChange = _this$props2.onPathChange,
            location = _this$props2.location,
            routerData = _this$props2.routerData;

        if (routerData && (!(0, _isEqual["default"])(params, routerData.params) || path !== routerData.path)) {
          if ((0, _reactRouterDom.matchPath)(location.pathname, {
            path: url,
            exact: true
          })) {
            onPathChange && onPathChange({
              params: params,
              path: path
            });
          }
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props3 = this.props,
            onPathChange = _this$props3.onPathChange,
            routerData = _this$props3.routerData,
            staticContext = _this$props3.staticContext,
            props = (0, _objectWithoutProperties2["default"])(_this$props3, ["onPathChange", "routerData", "staticContext"]);
        return /*#__PURE__*/_react["default"].createElement(Component, props);
      }
    }]);
    return RouterParams;
  }(_react["default"].Component);

  ;
  RouterParams.propTypes = {
    match: _propTypes["default"].shape({
      params: _propTypes["default"].object,
      path: _propTypes["default"].string,
      url: _propTypes["default"].string
    }).isRequired,
    onPathChange: _propTypes["default"].func,
    location: _propTypes["default"].shape({
      pathname: _propTypes["default"].string.isRequired
    }).isRequired,
    routerData: _propTypes["default"].shape({
      params: _propTypes["default"].object,
      path: _propTypes["default"].string
    }).isRequired,
    staticContext: _propTypes["default"].any
  };
  return (0, _reactRouterDom.withRouter)((0, _reactRedux.connect)(function (_ref) {
    var routerData = _ref.routerData;
    return {
      routerData: routerData
    };
  }, function (dispatch) {
    return {
      onPathChange: function onPathChange(data) {
        return dispatch({
          type: '@@INSIGHTS-CORE/NAVIGATION',
          payload: data
        });
      }
    };
  })(RouterParams));
};

exports.routerParams = routerParams;
var _default = routerParams;
exports["default"] = _default;