"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTagsFilter = exports.tagsFilterReducer = exports.TAGS_FILTER = exports.tagsFilterState = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _constants = require("./constants");

var _Spinner = require("@patternfly/react-core/dist/js/components/Spinner/Spinner.js");

require("./tagFilterHook.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var tagsFilterState = {
  tagsFilter: {}
};
exports.tagsFilterState = tagsFilterState;
var TAGS_FILTER = 'TAGS_FILTER';
exports.TAGS_FILTER = TAGS_FILTER;

var tagsFilterReducer = function tagsFilterReducer(_state, _ref) {
  var type = _ref.type,
      payload = _ref.payload;
  return _objectSpread({}, type === TAGS_FILTER && {
    tagsFilter: payload
  });
};

exports.tagsFilterReducer = tagsFilterReducer;

var useTagsFilter = function useTagsFilter() {
  var allTags = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var loaded = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var additionalTagsCount = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  var onShowMoreClick = arguments.length > 3 ? arguments[3] : undefined;

  var _ref2 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [tagsFilterState],
      _ref3 = (0, _slicedToArray2["default"])(_ref2, 2),
      globalState = _ref3[0],
      dispatch = _ref3[1];

  var itemText = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'item';
  var showMoreTitle = arguments.length > 6 ? arguments[6] : undefined;

  var _useState = (0, _react.useState)({
    allTags: [],
    loaded: false,
    additionalTagsCount: 0
  }),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  (0, _react.useEffect)(function () {
    setState(function () {
      return {
        allTags: allTags,
        loaded: loaded,
        additionalTagsCount: additionalTagsCount
      };
    });
  }, [loaded]);

  var _useState3 = (0, _react.useState)({}),
      _useState4 = (0, _slicedToArray2["default"])(_useState3, 2),
      selectedStateTags = _useState4[0],
      setStateValue = _useState4[1];

  var selectedTags = dispatch ? globalState.tagsFilter : selectedStateTags;
  var setValue = dispatch ? function (newValue) {
    return dispatch({
      type: TAGS_FILTER,
      payload: newValue
    });
  } : setStateValue;

  var _useState5 = (0, _react.useState)(''),
      _useState6 = (0, _slicedToArray2["default"])(_useState5, 2),
      filterTagsBy = _useState6[0],
      seFilterTagsBy = _useState6[1];

  var filter = _objectSpread(_objectSpread({
    className: 'ins-c-tagfilter',
    onFilter: function onFilter(value) {
      return seFilterTagsBy(value);
    },
    filterBy: filterTagsBy,
    onChange: function onChange(_e, newSelection, group, item, groupKey, itemKey) {
      if (item.meta) {
        var isSelected = newSelection[groupKey][itemKey];
        newSelection[groupKey][itemKey] = {
          isSelected: isSelected,
          group: group,
          item: item
        };
        setValue(newSelection);
      }
    },
    selected: selectedTags
  }, additionalTagsCount && {
    onShowMore: function onShowMore() {
      return onShowMoreClick && onShowMoreClick.apply(void 0, arguments);
    },
    showMoreTitle: showMoreTitle || "".concat(state.additionalTagsCount, " more tags available")
  }), loaded && allTags.length > 0 ? {
    groups: (0, _toConsumableArray2["default"])((0, _constants.constructGroups)(allTags, itemText))
  } : {
    value: '',
    items: [{
      value: '',
      label: !state.loaded ? /*#__PURE__*/_react["default"].createElement("span", {
        key: "no-tags-tooltip"
      }, " ", /*#__PURE__*/_react["default"].createElement(_Spinner.Spinner, {
        size: "md"
      }), " ") : /*#__PURE__*/_react["default"].createElement("div", {
        className: "ins-c-tagfilter__no-tags"
      }, " No tags available "),
      isDisabled: true,
      className: 'ins-c-tagfilter__tail'
    }]
  });

  return {
    filter: filter,
    chips: (0, _constants.mapGroups)(selectedTags, 'chips'),
    selectedTags: selectedTags,
    setValue: setValue,
    filterTagsBy: filterTagsBy,
    seFilterTagsBy: seFilterTagsBy
  };
};

exports.useTagsFilter = useTagsFilter;