"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactCore = require("@patternfly/react-core/");

var checkTypes = ['checkbox', 'radio'];

var Input = function Input(_ref) {
  var _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      _ref$ariaLabel = _ref.ariaLabel,
      ariaLabel = _ref$ariaLabel === void 0 ? type : _ref$ariaLabel,
      className = _ref.className,
      ouiaId = _ref.ouiaId,
      ouiaSafe = _ref.ouiaSafe,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["type", "ariaLabel", "className", "ouiaId", "ouiaSafe"]);
  var classes = checkTypes.indexOf(type) !== -1 ? 'pf-c-check' : 'pf-c-form-control';
  var ouiaComponentType = 'RHI/Input';
  var ouiaFinalId = (0, _reactCore.useOUIAId)(ouiaComponentType, ouiaId, ouiaSafe);
  return /*#__PURE__*/_react["default"].createElement("input", (0, _extends2["default"])({}, props, {
    "data-ouia-component-type": ouiaComponentType,
    "data-ouia-component-id": ouiaFinalId,
    "data-ouia-safe": ouiaSafe,
    type: type,
    "aria-label": ariaLabel,
    className: (0, _classnames["default"])(classes, className)
  }));
};

Input.propTypes = {
  type: _propTypes["default"].string,
  className: _propTypes["default"].string,
  ariaLabel: _propTypes["default"].string,
  ouiaId: _propTypes["default"].string,
  ouiaSafe: _propTypes["default"].bool
};
Input.defaultProps = {
  ouiaSafe: true
};
var _default = Input;
exports["default"] = _default;