"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _icon = _interopRequireDefault(require("./icon-404"));

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

require("./invalidObject.css");

// Don't use chrome here because the 404 page on landing does not use chrome
var isBeta = function isBeta() {
  return window.location.pathname.split('/')[1] === 'beta' ? '/beta' : '';
};

var InvalidObject = function InvalidObject(_ref) {
  var props = (0, _extends2["default"])({}, _ref);
  return /*#__PURE__*/_react["default"].createElement("section", (0, _extends2["default"])({}, props, {
    className: "pf-l-page__main-section pf-c-page__main-section ins-c-component_invalid-componet"
  }), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h1",
    size: "3xl"
  }, "We lost that page"), /*#__PURE__*/_react["default"].createElement(_icon["default"], null), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h1",
    size: "xl",
    className: "ins-c-text__sorry"
  }, "Let's find you a new one. Try a new search or return home."), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "link",
    component: "a",
    href: "".concat(window.location.origin).concat(isBeta())
  }, "Return to homepage"));
};

var _default = InvalidObject;
exports["default"] = _default;