"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _configContext = _interopRequireDefault(require("../Dark/configContext"));

require("./page-header.css");

/**
 * This is a page header that mimics the patternfly layout for a header section
 */
var PageHeader = function PageHeader(_ref) {
  var className = _ref.className,
      children = _ref.children,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["className", "children"]);
  var pageHeaderClasses = (0, _classnames["default"])(className, 'pf-l-page-header', 'pf-c-page-header', 'pf-l-page__main-section', 'pf-c-page__main-section');
  return /*#__PURE__*/_react["default"].createElement(_configContext["default"].Consumer, null, function () {
    var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    var themeClasses = (0, _classnames["default"])((0, _defineProperty2["default"])({}, "pf-m-".concat(theme, "-200"), theme === 'dark'), (0, _defineProperty2["default"])({}, "pf-m-light", theme === 'light'));
    return /*#__PURE__*/_react["default"].createElement("section", (0, _extends2["default"])({}, props, {
      className: "".concat(pageHeaderClasses, " ").concat(themeClasses),
      "widget-type": "InsightsPageHeader"
    }), children);
  });
};

var _default = PageHeader;
exports["default"] = _default;
PageHeader.propTypes = {
  children: _propTypes["default"].any.isRequired,
  className: _propTypes["default"].string
};