"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flipDirection = flipDirection;
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactTable = require("@patternfly/react-table");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _sortAmountDownIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/sort-amount-down-icon"));

var _sortAmountUpIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/sort-amount-up-icon"));

function flipDirection(direction) {
  return direction === _reactTable.SortByDirection.asc ? _reactTable.SortByDirection.desc : _reactTable.SortByDirection.asc;
}

var SortBy = function SortBy(_ref) {
  var direction = _ref.direction,
      onSortChange = _ref.onSortChange;
  return /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "plain",
    onClick: function onClick(e) {
      return onSortChange(e, flipDirection(direction));
    }
  }, direction === _reactTable.SortByDirection.asc ? /*#__PURE__*/_react["default"].createElement(_sortAmountUpIcon["default"], {
    size: "sm"
  }) : /*#__PURE__*/_react["default"].createElement(_sortAmountDownIcon["default"], {
    size: "sm"
  }));
};

SortBy.propTypes = {
  direction: _propTypes["default"].oneOf(Object.values(_reactTable.SortByDirection)),
  onSortChange: _propTypes["default"].func
};
SortBy.defaultProps = {
  direction: _reactTable.SortByDirection.asc,
  onSortChange: function onSortChange() {
    return undefined;
  }
};
var _default = SortBy;
exports["default"] = _default;