import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

/* eslint-disable react/prop-types */
import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Breadcrumb } from "@patternfly/react-core/dist/esm/components/Breadcrumb/Breadcrumb.js";
import { BreadcrumbItem } from "@patternfly/react-core/dist/esm/components/Breadcrumb/BreadcrumbItem.js";
/**
 * @deprecated
 *
 * Breadcrumbs from FE component shouldn't be used anymore.
 *
 * Use <a href="https://www.patternfly.org/v4/components/breadcrumb" target="_blank">Breadcrumbs</a> from PF repository.
 */

var Breadcrumbs = function Breadcrumbs(_ref) {
  var items = _ref.items,
      current = _ref.current,
      className = _ref.className,
      onNavigate = _ref.onNavigate,
      props = _objectWithoutProperties(_ref, ["items", "current", "className", "onNavigate"]);

  console.warn('Breadcrumbs from FE component shouldn\'t be used anymore. \
Instead use https://patternfly-react.surge.sh/documentation/react/components/breadcrumb from PF repository.');
  return /*#__PURE__*/React.createElement(Breadcrumb, _extends({
    className: classnames('ins-c-breadcrumbs', className)
  }, props), items.map(function (oneLink, key) {
    return /*#__PURE__*/React.createElement(BreadcrumbItem, {
      key: key,
      "data-key": key
    }, /*#__PURE__*/React.createElement("a", {
      onClick: function onClick(event) {
        return onNavigate(event, oneLink.navigate, key);
      },
      "aria-label": oneLink.navigate
    }, oneLink.title));
  }), current && /*#__PURE__*/React.createElement(BreadcrumbItem, {
    isActive: true
  }, " ", current, " "));
};

Breadcrumbs.propTypes = {
  items: PropTypes.arrayOf(PropTypes.shape({
    navigate: PropTypes.any,
    title: PropTypes.node
  })),
  current: PropTypes.node,
  onNavigate: PropTypes.func
};
Breadcrumbs.defaultProps = {
  items: [],
  current: null,
  onNavigate: Function.prototype,
  className: ''
};
export default Breadcrumbs;