import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import { Select } from "@patternfly/react-core/dist/esm/components/Select/Select.js";
import { SelectOption } from "@patternfly/react-core/dist/esm/components/Select/SelectOption.js";
import { SelectVariant } from "@patternfly/react-core/dist/esm/components/Select/selectConstants.js";
import { Radio as InputRadio } from "@patternfly/react-core/dist/esm/components/Radio/Radio.js";
import Text from './TextFilter';

var Radio = /*#__PURE__*/function (_Component) {
  _inherits(Radio, _Component);

  var _super = _createSuper(Radio);

  function Radio() {
    var _this;

    _classCallCheck(this, Radio);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isExpanded: false,
      checked: undefined
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isExpanded) {
      _this.setState({
        isExpanded: isExpanded
      });
    });

    _defineProperty(_assertThisInitialized(_this), "calculateSelected", function () {
      var checked = _this.state.checked;
      var selectedValue = _this.props.value;
      return selectedValue && (selectedValue.value || selectedValue) || checked && (checked.value || checked);
    });

    _defineProperty(_assertThisInitialized(_this), "onSelect", function (event, selection) {
      var onChange = _this.props.onChange;
      onChange(event, selection);

      _this.setState({
        checked: selection
      });
    });

    return _this;
  }

  _createClass(Radio, [{
    key: "render",
    value: function render() {
      var isExpanded = this.state.isExpanded;
      var _this$props = this.props,
          items = _this$props.items,
          placeholder = _this$props.placeholder,
          isDisabled = _this$props.isDisabled,
          className = _this$props.className;
      var checkedValue = this.calculateSelected();
      return /*#__PURE__*/React.createElement(Fragment, null, !items || items && items.length <= 0 ? /*#__PURE__*/React.createElement(Text, _extends({}, this.props, {
        value: "".concat(this.calculateSelected())
      })) : /*#__PURE__*/React.createElement(Select, {
        className: className,
        variant: SelectVariant.single,
        "aria-label": "Select Input",
        isDisabled: isDisabled,
        onToggle: this.onToggle,
        onSelect: this.onSelect,
        isOpen: isExpanded,
        placeholderText: placeholder,
        ouiaId: placeholder
      }, items.map(function (_ref, key) {
        var value = _ref.value,
            isChecked = _ref.isChecked,
            _onChange = _ref.onChange,
            label = _ref.label,
            id = _ref.id,
            item = _objectWithoutProperties(_ref, ["value", "isChecked", "onChange", "label", "id"]);

        return /*#__PURE__*/React.createElement(SelectOption, _extends({}, item, {
          key: id || key,
          value: value || '' + key
        }), /*#__PURE__*/React.createElement(InputRadio, _extends({}, item, {
          name: id || "".concat(key, "-radio"),
          label: label,
          value: value || key,
          isChecked: isChecked || checkedValue !== undefined && checkedValue === value || checkedValue !== undefined && checkedValue === '' + key || false,
          onChange: function onChange(_value, e) {
            return _onChange && _onChange(e, _objectSpread({
              id: id,
              label: label,
              value: value,
              isChecked: isChecked
            }, item), key);
          },
          id: id || "".concat(value, "-").concat(key)
        })));
      })));
    }
  }]);

  return Radio;
}(Component);

Radio.propTypes = {
  onChange: PropTypes.func,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.shape({
    label: PropTypes.node,
    value: PropTypes.string
  })]),
  placeholder: PropTypes.string,
  items: PropTypes.arrayOf(PropTypes.shape({
    value: PropTypes.string,
    label: PropTypes.node,
    id: PropTypes.string,
    isChecked: PropTypes.bool,
    onChange: PropTypes.func
  })),
  isDisabled: PropTypes.bool,
  className: PropTypes.string
};
Radio.defaultProps = {
  items: [],
  onChange: function onChange() {
    return undefined;
  },
  isDisabled: false
};
export default Radio;