import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import ExclamationCircleIcon from "@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon";
import ExclamationTriangleIcon from "@patternfly/react-icons/dist/esm/icons/exclamation-triangle-icon";
import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";
import classnames from 'classnames';
import "../../CullingInfo/./CullingInformation.css";
var seconds = 1000;
var minutes = seconds * 60;
var hours = minutes * 60;
var days = hours * 24;

var exact = function exact(value) {
  return "".concat(value.toUTCString().split(',')[1].slice(0, -4).trim(), " UTC");
};

var calculateTooltip = function calculateTooltip(culled, warning, currDate) {
  var culledDate = new Date(culled);
  var warningDate = new Date(warning);
  var diffTime = currDate - warningDate;
  var removeIn = Math.ceil((culledDate - currDate) / days);
  var msg = "System scheduled for inventory removal in ".concat(removeIn, " days");

  if (diffTime >= 0) {
    return {
      isError: true,
      msg: msg
    };
  }

  return {
    isWarn: true,
    msg: msg
  };
};

var CullingInformation = function CullingInformation(_ref) {
  var culled = _ref.culled,
      className = _ref.className,
      staleWarning = _ref.staleWarning,
      stale = _ref.stale,
      currDate = _ref.currDate,
      children = _ref.children,
      render = _ref.render,
      props = _objectWithoutProperties(_ref, ["culled", "className", "staleWarning", "stale", "currDate", "children", "render"]);

  // TODO: remove comments once culling is fine
  if (new Date(currDate) - new Date(stale) < 0) {
    return render ? render({
      msg: ''
    }) : children;
  }

  var _calculateTooltip = calculateTooltip(culled, staleWarning, currDate),
      isWarn = _calculateTooltip.isWarn,
      isError = _calculateTooltip.isError,
      msg = _calculateTooltip.msg;

  if (render) {
    return /*#__PURE__*/React.createElement("span", {
      className: classnames({
        'ins-c-inventory__culling-warning': isWarn,
        'ins-c-inventory__culling-danger': isError
      })
    }, isWarn && /*#__PURE__*/React.createElement(ExclamationTriangleIcon, null), isError && /*#__PURE__*/React.createElement(ExclamationCircleIcon, null), render({
      msg: msg
    }));
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tooltip, _extends({}, props, {
    content: msg,
    position: "bottom"
  }), /*#__PURE__*/React.createElement("span", {
    className: classnames({
      'ins-c-inventory__culling-warning': isWarn,
      'ins-c-inventory__culling-danger': isError
    })
  }, isError && /*#__PURE__*/React.createElement(ExclamationCircleIcon, null), isWarn && /*#__PURE__*/React.createElement(ExclamationTriangleIcon, null), children)));
};

CullingInformation.propTypes = {
  culled: PropTypes.oneOfType([PropTypes.string, PropTypes.number, PropTypes.instanceOf(Date)]),
  staleWarning: PropTypes.oneOfType([PropTypes.string, PropTypes.number, PropTypes.instanceOf(Date)]),
  stale: PropTypes.oneOfType([PropTypes.string, PropTypes.number, PropTypes.instanceOf(Date)]),
  currDate: PropTypes.oneOfType([PropTypes.string, PropTypes.number, PropTypes.instanceOf(Date)]),
  render: PropTypes.func,
  className: PropTypes.string,
  children: PropTypes.node
};
CullingInformation.defaultProps = {
  culled: new Date(0),
  staleWarning: new Date(0),
  currDate: new Date()
};
export default CullingInformation;