import _extends from "@babel/runtime/helpers/extends";
import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
import { ScalprumComponent } from '@scalprum/react-core';
import { useHistory } from 'react-router-dom';
import { useStore } from 'react-redux';
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner/Spinner.js";
import InventoryLoadError from './InventoryLoadError';

var BaseInventoryDetailHead = function BaseInventoryDetailHead(props) {
  var history = useHistory();
  var store = useStore();
  return /*#__PURE__*/React.createElement(Suspense, {
    fallback: props.fallback
  }, /*#__PURE__*/React.createElement(ScalprumComponent, _extends({
    history: history,
    store: store,
    appName: "inventory",
    module: "./InventoryDetailHead",
    scope: "inventory",
    ErrorComponent: /*#__PURE__*/React.createElement(InventoryLoadError, _extends({
      component: "InventoryDetailHead",
      history: history,
      store: store
    }, props)),
    ref: props.innerRef
  }, props)));
};

BaseInventoryDetailHead.propTypes = {
  fallback: PropTypes.node,
  innerRef: PropTypes.object
};
/**
 * Inventory sub component.
 *
 * This component shows system information (tags, facts and basic operations).
 */

var InventoryDetailHead = /*#__PURE__*/React.forwardRef(function (props, ref) {
  return /*#__PURE__*/React.createElement(BaseInventoryDetailHead, _extends({
    innerProps: ref
  }, props));
});
InventoryDetailHead.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: PropTypes.node
};
InventoryDetailHead.defaultProps = {
  fallback: /*#__PURE__*/React.createElement(Bullseye, {
    className: "pf-u-p-lg"
  }, /*#__PURE__*/React.createElement(Spinner, {
    size: "xl"
  }))
};
export default InventoryDetailHead;