import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { Stack } from "@patternfly/react-core/dist/esm/layouts/Stack/Stack.js";
import { StackItem } from "@patternfly/react-core/dist/esm/layouts/Stack/StackItem.js";
import { EmptyStateIcon } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js";
import HourglassHalfIcon from "@patternfly/react-icons/dist/esm/icons/hourglass-half-icon";
import "../../Maintenance/./maintenance.css";

var Maintenance = function Maintenance(_ref) {
  var title = _ref.title,
      utcStartTime = _ref.utcStartTime,
      utcEndTime = _ref.utcEndTime,
      startTime = _ref.startTime,
      endTime = _ref.endTime,
      timeZone = _ref.timeZone,
      description = _ref.description,
      redirectLink = _ref.redirectLink,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["title", "utcStartTime", "utcEndTime", "startTime", "endTime", "timeZone", "description", "redirectLink", "className"]);

  var emptyStateClassName = classNames(className, 'ins-c-empty-state__maintenance');
  return /*#__PURE__*/React.createElement(EmptyState, _extends({
    className: emptyStateClassName
  }, props), /*#__PURE__*/React.createElement(EmptyStateIcon, {
    icon: HourglassHalfIcon
  }), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h4",
    size: "lg"
  }, "Maintenance in progress"), /*#__PURE__*/React.createElement(EmptyStateBody, null, description ? description : /*#__PURE__*/React.createElement(Stack, null, /*#__PURE__*/React.createElement(StackItem, null, "We are currently undergoing scheduled maintenance and will be"), /*#__PURE__*/React.createElement(StackItem, null, "unavailable from ", utcStartTime, " to ", utcEndTime, " UTC (", startTime, "-", endTime, " ", timeZone, ")."), /*#__PURE__*/React.createElement(StackItem, null, "For more information please visit ", /*#__PURE__*/React.createElement("a", {
    href: redirectLink
  }, "status.redhat.com"), "."))));
};

Maintenance.propTypes = {
  utcStartTime: PropTypes.string,
  utcEndTime: PropTypes.string,
  startTime: PropTypes.string,
  endTime: PropTypes.string,
  timeZone: PropTypes.string,
  description: PropTypes.node,
  redirectLink: PropTypes.string,
  title: PropTypes.node,
  className: PropTypes.string
};
Maintenance.defaultProps = {
  utcStartTime: '10am',
  utcEndTime: '12am',
  startTime: '6am',
  endTime: '8am',
  timeZone: 'EST',
  redirectLink: 'https://status.redhat.com/incidents',
  title: 'Maintenance in progress'
};
export default Maintenance;