import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React from 'react';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import AngleRightIcon from "@patternfly/react-icons/dist/esm/icons/angle-right-icon";
import "../../TreeTable/./styles.css";
export default (function (onCollapse) {
  return function () {
    var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      rowData: {}
    };

    var rowData = _ref.rowData,
        props = _objectWithoutProperties(_ref, ["rowData"]);

    return {
      value: value,
      children: rowData.level !== undefined ? /*#__PURE__*/React.createElement("div", {
        className: "pf-c-treeview__control"
      }, rowData.isTreeOpen !== undefined && /*#__PURE__*/React.createElement("div", {
        className: "pf-c-treeview__toggle"
      }, /*#__PURE__*/React.createElement(Button, {
        variant: "plain",
        onClick: function onClick(event) {
          return onCollapse && onCollapse(event, value, _objectSpread({
            rowData: rowData
          }, props));
        }
      }, /*#__PURE__*/React.createElement(AngleRightIcon, {
        className: "pf-c-treeview__toggle-icon",
        "aria-hidden": "true"
      }))), /*#__PURE__*/React.createElement("div", {
        className: "pf-c-treeview__control-text"
      }, value.title || value)) : value.title || value,
      className: rowData.level !== undefined ? 'pf-c-treeview__title-cell' : ''
    };
  };
});