import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import PropTypes from 'prop-types';
import { RowWrapper } from '@patternfly/react-table';
import classnames from 'classnames';

var TreeRowWrapper = function TreeRowWrapper(props) {
  var className = props.className;

  var _ref = props.row || {},
      level = _ref.level,
      isTreeOpen = _ref.isTreeOpen,
      point = _ref.point,
      posinset = _ref.posinset;

  return /*#__PURE__*/React.createElement(RowWrapper, _extends({}, props, {
    "aria-level": level === undefined ? 1 : level + 1,
    "aria-posinset": posinset,
    "aria-setsize": point ? point.size : 0,
    className: classnames({
      className: className,
      'pf-m-expandable': isTreeOpen === true || isTreeOpen === false,
      'pf-m-expanded': isTreeOpen === true
    })
  }));
};

TreeRowWrapper.propTypes = {
  rows: PropTypes.arrayOf(PropTypes.shape({
    level: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    isTreeOpen: PropTypes.bool,
    point: PropTypes.shape({
      size: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
    }),
    posinset: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
  })),
  className: PropTypes.string,
  row: PropTypes.object
};
export default TreeRowWrapper;