import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { useState } from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import { Stack } from "@patternfly/react-core/dist/esm/layouts/Stack/Stack.js";
import { StackItem } from "@patternfly/react-core/dist/esm/layouts/Stack/StackItem.js";
import sanitizeHtml from 'sanitize-html';
import "../../Truncate/./truncate.css";

var dangerousHtml = function dangerousHtml(html) {
  return {
    __html: sanitizeHtml(html)
  };
};

var Truncate = function Truncate(_ref) {
  var _ref$text = _ref.text,
      text = _ref$text === void 0 ? '' : _ref$text,
      _ref$length = _ref.length,
      length = _ref$length === void 0 ? 150 : _ref$length,
      _ref$expandText = _ref.expandText,
      expandText = _ref$expandText === void 0 ? 'Read more' : _ref$expandText,
      _ref$hideExpandText = _ref.hideExpandText,
      hideExpandText = _ref$hideExpandText === void 0 ? false : _ref$hideExpandText,
      _ref$expandOnMouseOve = _ref.expandOnMouseOver,
      expandOnMouseOver = _ref$expandOnMouseOve === void 0 ? false : _ref$expandOnMouseOve,
      _ref$collapseText = _ref.collapseText,
      collapseText = _ref$collapseText === void 0 ? 'Collapse' : _ref$collapseText,
      className = _ref.className,
      inline = _ref.inline,
      spaceBetween = _ref.spaceBetween;
  var truncateClasses = classNames('ins-c-truncate', className, _defineProperty({}, "is-inline", inline), _defineProperty({}, "is-block", !inline));
  var trimmedText = text.substring(0, length);
  var textOverflow = text.length > length;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      showText = _useState2[0],
      setShowText = _useState2[1];

  var toggleText = function toggleText(event) {
    event && event.preventDefault();
    setShowText(!showText);
  };

  var expandButton = /*#__PURE__*/React.createElement(Button, {
    className: "ins-c-expand-button",
    variant: "link",
    onClick: toggleText
  }, expandText);
  var collapseButton = /*#__PURE__*/React.createElement(Button, {
    className: "ins-c-collapse-button",
    variant: "link",
    onClick: toggleText
  }, collapseText);
  var textWithOverflow = showText === false ? "".concat(trimmedText).concat(textOverflow ? '...' : '') : text;
  var html = dangerousHtml(textWithOverflow);
  var mouseOverHandler = expandOnMouseOver && {
    onMouseEnter: function onMouseEnter() {
      return setShowText(true);
    },
    onMouseLeave: function onMouseLeave() {
      return setShowText(false);
    }
  };
  return inline ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("span", _extends({
    className: truncateClasses,
    "widget-type": "InsightsTruncateInline",
    dangerouslySetInnerHTML: html
  }, mouseOverHandler)), !hideExpandText && textOverflow && (showText === false ? expandButton : collapseButton)) : /*#__PURE__*/React.createElement(Stack, {
    className: truncateClasses
  }, /*#__PURE__*/React.createElement(StackItem, mouseOverHandler, /*#__PURE__*/React.createElement("span", {
    "widget-type": "InsightsTruncateBlock",
    dangerouslySetInnerHTML: html
  })), !hideExpandText && textOverflow && /*#__PURE__*/React.createElement(StackItem, {
    className: spaceBetween && 'pf-u-mt-sm'
  }, showText === false ? expandButton : collapseButton));
};

Truncate.propTypes = {
  className: propTypes.string,
  text: propTypes.string,
  length: propTypes.number,
  expandText: propTypes.string,
  collapseText: propTypes.string,
  inline: propTypes.bool,
  spaceBetween: propTypes.bool,
  hideExpandText: propTypes.bool,
  expandOnMouseOver: propTypes.bool
};
export default Truncate;