"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.riskOfChangeMeta = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _securityIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/security-icon"));

/**
 * This was created to fix following circular dependency issue
 * src/ReportDetails/constants.js -> src/ReportDetails/RiskOfChangeIcon.js -> src/ReportDetails/constants.js
 * Please do net merge this constant back to constants.js unless the circular dependency will be removed
 */
var riskOfChangeMeta = [{
  label: 'Very Low',
  description: 'Very Low severity desc for risk of change',
  IconComponent: RiskOfChangeIcon
}, {
  label: 'Low',
  description: 'Low severity desc for risk of change',
  IconComponent: RiskOfChangeIcon
}, {
  label: 'Moderate',
  description: 'Moderate severity desc for risk of change',
  IconComponent: RiskOfChangeIcon
}, {
  label: 'High',
  description: 'High severity desc for risk of change',
  IconComponent: RiskOfChangeIcon
}];
/**
 * This is the RiskOfChangeIcon component
 * it accepts severity
 * which corresponds to a level 1-4
 * 1 - low - best case scenario
 * 2 - medium
 * 3 - high
 * 4 - critical - worst case scenario
 * Also accepts a label which can be made invisible
 */

exports.riskOfChangeMeta = riskOfChangeMeta;

function RiskOfChangeIcon(_ref) {
  var value = _ref.value,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["value"]);
  var label = riskOfChangeMeta[value - 1] && riskOfChangeMeta[value - 1].label;
  return /*#__PURE__*/_react["default"].createElement("div", {
    className: "ins-c-rule__battery battery ins-c-rule__severity-level-".concat(value)
  }, /*#__PURE__*/_react["default"].createElement("i", (0, _extends2["default"])({
    "widget-type": "InsightsBattery",
    "widget-id": label
  }, props), /*#__PURE__*/_react["default"].createElement(_securityIcon["default"], {
    className: "ins-c-risk-of-change__icon"
  })), label && label.length > 0 && /*#__PURE__*/_react["default"].createElement("span", {
    className: "ins-c-risk-of-change__label"
  }, label));
}

RiskOfChangeIcon.propTypes = {
  value: _propTypes["default"].number.isRequired
};
RiskOfChangeIcon.defaultProps = {
  severity: 0
};
var _default = RiskOfChangeIcon;
exports["default"] = _default;