"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var classnames_1 = __importDefault(require("classnames"));
var CriticalBattery_1 = __importDefault(require("./CriticalBattery"));
var HighBattery_1 = __importDefault(require("./HighBattery"));
var MediumBattery_1 = __importDefault(require("./MediumBattery"));
var LowBattery_1 = __importDefault(require("./LowBattery"));
var NullBattery_1 = __importDefault(require("./NullBattery"));
require("./battery.css");
var Battery = function (_a) {
    var _b, _c;
    var severity = _a.severity, label = _a.label, labelHidden = _a.labelHidden, className = _a.className, props = __rest(_a, ["severity", "label", "labelHidden", "className"]);
    var batteryClasses = (0, classnames_1.default)(className, 'ins-battery', (_b = {}, _b["ins-battery-".concat(severity)] = severity !== undefined, _b));
    var ariaLabels = {};
    if (labelHidden) {
        ariaLabels = (_c = {}, _c['aria-label'] = severity + ' ' + label, _c);
    }
    var batteryLevels = function (severity) {
        switch (severity) {
            case 'critical':
            case 4:
                return react_1.default.createElement(CriticalBattery_1.default, null);
            case 'high':
            case 'error':
            case 3:
                return react_1.default.createElement(HighBattery_1.default, null);
            case 'medium':
            case 'warn':
            case 2:
                return react_1.default.createElement(MediumBattery_1.default, null);
            case 'low':
            case 'info':
            case 1:
                return react_1.default.createElement(LowBattery_1.default, null);
            default:
                console.error('Warning: Unsupported value presented to battery component');
                return react_1.default.createElement(NullBattery_1.default, null);
        }
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("i", __assign({ className: batteryClasses }, ariaLabels, props, { "widget-type": "InsightsBattery", "widget-id": label }),
            react_1.default.createElement("svg", { version: "1.1", id: "battery_svg", x: "0px", y: "0px", viewBox: "0 0 448 512", style: { enableBackground: 'new 0 0 448 512' }, shapeRendering: "geometricpresision" },
                react_1.default.createElement("path", { style: {
                        fill: 'none',
                        fillOpacity: 1,
                        stroke: '#969696',
                        strokeWidth: 41.96378708,
                        strokeLinejoin: 'round',
                        strokeMiterlimit: 4,
                        strokeDasharray: 'none',
                        strokeDashoffset: 0,
                        strokeOpacity: 1,
                    }, d: "m 144.16452,21.032222 h 159.67454 q 123.1748,0 123.1748,128.667868 v 212.64759 q 0,128.66788 -123.1748,128.66788 H 144.16452 q -123.174811,0 -123.174811,-128.66788 V 149.70009 q 0,-128.667868 123.174811,-128.667868 z" }),
                batteryLevels(severity))),
        !labelHidden && react_1.default.createElement("span", { className: "label" },
            " ",
            label,
            " ")));
};
exports.default = Battery;
//# sourceMappingURL=Battery.js.map