"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@patternfly/react-core");
var TextFilter_1 = __importDefault(require("./TextFilter"));
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var CheckboxFilter = (function (_super) {
    __extends(CheckboxFilter, _super);
    function CheckboxFilter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isExpanded: false,
            selected: [],
        };
        _this.onToggle = function (isExpanded) {
            _this.setState({
                isExpanded: isExpanded,
            });
        };
        _this.calculateSelected = function () {
            var selected = _this.state.selected;
            var value = _this.props.value;
            return Array.from(new Set(__spreadArray(__spreadArray([], (value && value.length > 0 && value.constructor === Array ? value.map(function (item) { return item.value || item; }) : []), true), selected, true)));
        };
        _this.onSelect = function (event, selection) {
            var onChange = _this.props.onChange;
            var newSelection = _this.calculateSelected();
            if (newSelection.includes(selection)) {
                newSelection = newSelection.filter(function (item) { return item !== selection; });
            }
            else {
                newSelection = __spreadArray(__spreadArray([], newSelection, true), [selection], false);
            }
            onChange(event, newSelection, selection);
            _this.setState({ selected: newSelection });
        };
        return _this;
    }
    CheckboxFilter.prototype.componentDidUpdate = function (_a) {
        var prevSelected = _a.value;
        var value = this.props.value;
        if (!(0, isEqual_1.default)(prevSelected, value)) {
            this.setState({
                selected: value,
            });
        }
    };
    CheckboxFilter.prototype.render = function () {
        var isExpanded = this.state.isExpanded;
        var _a = this.props, items = _a.items, placeholder = _a.placeholder, isDisabled = _a.isDisabled, className = _a.className;
        return (react_1.default.createElement(react_1.Fragment, null, !items || (items && items.length <= 0) ? (react_1.default.createElement(TextFilter_1.default, __assign({}, this.props, { value: "".concat(this.calculateSelected()) }))) : (react_1.default.createElement(react_core_1.Select, { className: className, variant: react_core_1.SelectVariant.checkbox, "aria-label": "Select Input", onToggle: this.onToggle, isDisabled: isDisabled, onSelect: this.onSelect, selections: this.calculateSelected(), isOpen: isExpanded, placeholderText: placeholder, ouiaId: placeholder }, items.map(function (_a, key) {
            var value = _a.value, onClick = _a.onClick, label = _a.label, id = _a.id, item = __rest(_a, ["value", "onClick", "label", "id"]);
            return (react_1.default.createElement(react_core_1.SelectOption, __assign({}, item, { key: id || key, value: String(value || id || key), onClick: function (e) { return onClick && onClick(e, __assign({ value: value, label: label, id: id }, item), key); } }), label));
        })))));
    };
    return CheckboxFilter;
}(react_1.Component));
CheckboxFilter.propTypes = {
    onChange: prop_types_1.default.func,
    value: prop_types_1.default.arrayOf(prop_types_1.default.oneOfType([
        prop_types_1.default.string,
        prop_types_1.default.shape({
            label: prop_types_1.default.node,
            value: prop_types_1.default.string,
        }),
    ])),
    placeholder: prop_types_1.default.string,
    items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        value: prop_types_1.default.string,
        label: prop_types_1.default.node,
        id: prop_types_1.default.string,
        onClick: prop_types_1.default.func,
    })),
    isDisabled: prop_types_1.default.bool,
    className: prop_types_1.default.string,
};
CheckboxFilter.defaultProps = {
    items: [],
    value: [],
    onChange: function () { return undefined; },
    isDisabled: false,
};
exports.default = CheckboxFilter;
//# sourceMappingURL=CheckboxFilter.js.map