var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
export var sizeCalculator = function (rows) {
    var points = {};
    for (var key = 0; key < rows.length; key++) {
        if (!rows[key].cells) {
            rows[key] = {
                cells: rows[key],
            };
        }
        var currRow = rows[key];
        currRow.level = rows[currRow.treeParent] ? rows[currRow.treeParent].level + 1 : 0;
        var pointKey = typeof currRow.treeParent === 'undefined' ? 0 : currRow.treeParent + 1;
        if (!points[pointKey]) {
            points[pointKey] = { size: 0 };
        }
        var currPoint = points[pointKey];
        currPoint.size = currPoint.size + 1;
        currRow.point = currPoint;
        currRow.posinset = currPoint.size;
    }
    return rows;
};
export var collapseBuilder = function (parentKey) {
    if (parentKey === void 0) { parentKey = 'treeParent'; }
    return function (rows, _e, _val, _a) {
        var rowData = _a.rowData;
        var currRow = rows[rowData.id];
        var isTreeOpen = !currRow.isTreeOpen;
        var rowsToChange = __spreadArray([rows[rowData.id]], (isTreeOpen === false ? rows.filter(function (row) { return row[parentKey] === rowData.id; }) : []), true);
        for (var key = 0; key < rowsToChange.length; key++) {
            rowsToChange[key].isTreeOpen = rowsToChange[key].isTreeOpen === undefined ? undefined : isTreeOpen;
        }
        return rows;
    };
};
//# sourceMappingURL=helpers.js.map