import ___default, { flatten, countBy, isEqual, isMatch, noop, get } from 'lodash';
import React__default, { forwardRef, createElement, useState, useEffect, useMemo, useRef, Fragment as Fragment$1, useContext, useCallback, Suspense } from 'react';
import { useField, useFormikContext, Formik, FieldArray } from 'formik';
import { FormGroup, HelperTextItem, Split, SplitItem, TextInput, Checkbox, TextArea, FormSelect, FormSelectOption, SelectOption, Select, SelectVariant, Button, FileUpload, Switch, Popover, Radio, NumberInput, Label, Bullseye, EmptyState as EmptyState$1, EmptyStateIcon, Title, EmptyStateBody, EmptyStateSecondaryActions, ButtonVariant, EmptyStateVariant, Spinner, ToolbarItem, Text, ToolbarGroup, Progress, ProgressSize, TextContent, Stack, StackItem, Toolbar, ToolbarContent, TextVariants, DropdownItem, DropdownToggle, Dropdown, TextList, TextListVariants, TextListItem, TextListItemVariants, ToolbarFilter, Badge, InputGroup, Modal, ModalVariant, ModalBoxBody, WizardNavItem, AlertVariant, AlertGroup, Alert, AlertActionCloseButton, ClipboardCopy, clipboardCopyFunc, WizardBody, ListItem as ListItem$1, List, Tooltip, TextInputTypes, AlertActionLink, Form, ModalBoxFooter, Grid, GridItem, DescriptionList, DescriptionListGroup, DescriptionListTerm, DescriptionListDescription, Flex, FlexItem, Level, LevelItem, ProgressMeasureLocation, ProgressVariant, ButtonType, ExpandableSection, TitleSizes, Card, CardHeader, CardTitle, CardExpandableContent, CardBody, WizardNav, ListComponent, ActionGroup, PageSection, PageSectionVariants, Breadcrumb, BreadcrumbItem } from '@patternfly/react-core';
import Fuse from 'fuse.js';
import { shallowEqual, useDispatch, useSelector, Provider } from 'react-redux';
import { OutlinedQuestionCircleIcon, ExternalLinkAltIcon, SearchIcon, ExclamationCircleIcon, CaretDownIcon, ExclamationTriangleIcon, InfoCircleIcon, FilterIcon, CheckCircleIcon, PendingIcon, UnknownIcon, AddCircleOIcon, InProgressIcon, BanIcon, DisconnectedIcon, ConnectedIcon, MinusCircleIcon, PlusCircleIcon, IconSize, FileAltIcon, HelpIcon, SyncIcon } from '@patternfly/react-icons';
import classNames from 'classnames';
import { CodeEditor, Language } from '@patternfly/react-code-editor';
import { string, mixed, number, lazy, object, boolean, bool, array } from 'yup';
import { Address6, Address4 } from 'ip-address';
import { isInSubnet } from 'is-in-subnet';
import isCIDR from 'is-cidr';
import TagsInput from 'react-tagsinput';
import { global_danger_color_200, global_warning_color_100, global_danger_color_100, global_success_color_100 } from '@patternfly/react-tokens';
import { useTranslation, initReactI18next, I18nextProvider } from 'react-i18next';
import { SortColumn, SortByDirection, Table, breakWord as breakWord$1, TableVariant, TableBody, sortable as sortable$1, expandable, TableHeader, RowWrapper, cellWidth } from '@patternfly/react-table';
import { v4 } from 'uuid';
import { createSlice, createAsyncThunk, configureStore } from '@reduxjs/toolkit';
import Highlight, { defaultProps } from 'prism-react-renderer';
import defaultTheme from 'prism-react-renderer/themes/github';
import filesize from 'filesize.js';
import { saveAs } from 'file-saver';
import Humanize, { pluralize } from 'humanize-plus';
import hdate from 'human-date';
import axios from 'axios';
import applyCaseMiddleware from 'axios-case-converter';
import { captureMessage, captureException as captureException$1, Severity } from '@sentry/browser';
import { global_palette_green_500 } from '@patternfly/react-tokens/dist/js/global_palette_green_500';
import { global_warning_color_100 as global_warning_color_100$1 } from '@patternfly/react-tokens/dist/js/global_warning_color_100';
import { Link, useHistory, Redirect, Switch as Switch$1, Route } from 'react-router-dom';
import { dump, load } from 'js-yaml';
import i18n from 'i18next';
import LanguageDetector from 'i18next-browser-languagedetector';
import { combineReducers } from 'redux';
import { createSelector } from 'reselect';
import useSWR from 'swr';

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

var REQUIRED_AGENT_CONDITION_TYPES = ['SpecSynced', 'Connected', 'Validated'];
var getFailingAgentConditions = function getFailingAgentConditions(agents) {
  if (agents === void 0) {
    agents = [];
  }

  var agentsAlerts = {};
  var ofType = REQUIRED_AGENT_CONDITION_TYPES;
  agents.forEach(function (a) {
    var _a$status, _a$status$conditions;

    var failingConds = (_a$status = a.status) === null || _a$status === void 0 ? void 0 : (_a$status$conditions = _a$status.conditions) === null || _a$status$conditions === void 0 ? void 0 : _a$status$conditions.filter(function (condition) {
      return ofType.includes(condition.type) && condition.status === 'False';
    });

    if (failingConds === null || failingConds === void 0 ? void 0 : failingConds.length) {
      var _a$metadata;

      agentsAlerts[((_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : _a$metadata.name) || 'unknownname'] = failingConds;
    }
  });
  return agentsAlerts;
};
var getFailingResourceConditions = function getFailingResourceConditions(resource, ofType) {
  var _resource$status, _resource$status$cond;

  if (resource === void 0) {
    resource = {};
  }

  return ((_resource$status = resource.status) === null || _resource$status === void 0 ? void 0 : (_resource$status$cond = _resource$status.conditions) === null || _resource$status$cond === void 0 ? void 0 : _resource$status$cond.filter(function (c) {
    return (!ofType || (ofType === null || ofType === void 0 ? void 0 : ofType.includes(c.type))) && c.status === 'False';
  })) || [];
};

var conditionsByTypeReducer = function conditionsByTypeReducer(result, condition) {
  var _extends2;

  return _extends({}, result, (_extends2 = {}, _extends2[condition.type] = condition, _extends2));
};

var getClusterStatusFromConditions = function getClusterStatusFromConditions(agentClusterInstall) {
  var _agentClusterInstall$;

  var conditions = (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.status) === null || _agentClusterInstall$ === void 0 ? void 0 : _agentClusterInstall$.conditions) || [];
  var conditionsByType = conditions.reduce(conditionsByTypeReducer, {});
  var Validated = conditionsByType.Validated,
      RequirementsMet = conditionsByType.RequirementsMet,
      Completed = conditionsByType.Completed,
      Stopped = conditionsByType.Stopped;

  if (!Validated || !RequirementsMet || !Completed || !Stopped) {
    return ['insufficient', 'AgentClusterInstall conditions are missing.'];
  }

  if (Stopped.status === 'True' && Stopped.reason === 'InstallationCancelled') return ['cancelled', Stopped.message];
  if (Stopped.status === 'True' && Stopped.reason === 'InstallationFailed') return ['error', Stopped.message];
  if (Completed.status === 'True' && Completed.reason === 'InstallationCompleted') return ['installed', Completed.message];
  if (Completed.status === 'False' && Completed.reason === 'InstallationInProgress') return ['installing', Completed.message];
  if (Validated.status === 'False' && Validated.reason === 'ValidationsFailing') return ['insufficient', Validated.message];
  if (Validated.status === 'False' && Validated.reason === 'ValidationsUserPending') return ['pending-for-input', Validated.message];
  if (Validated.status === 'False' && Validated.reason === 'ValidationsUnknown') return ['insufficient', Validated.message];
  if (RequirementsMet.status === 'False' && RequirementsMet.reason === 'ClusterNotReady') return ['insufficient', RequirementsMet.message];
  if (RequirementsMet.status === 'False' && RequirementsMet.reason === 'InsufficientAgents') return ['insufficient', RequirementsMet.message];
  if (RequirementsMet.status === 'False' && RequirementsMet.reason === 'UnapprovedAgents') return ['insufficient', RequirementsMet.message];
  if (Completed.status === 'False' && Completed.reason === 'UnapprovedAgents') return ['insufficient', Completed.message];
  console.error('Unhandled conditions to cluster status mapping: ', conditionsByType);
  return ['insufficient', 'Unexpected AgentClusterInstall conditions.'];
};
var getClusterStatus = function getClusterStatus(agentClusterInstall) {
  var _agentClusterInstall$2;

  var _ref = (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$2 = agentClusterInstall.status) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.debugInfo) || {},
      status = _ref.state,
      statusInfo = _ref.stateInfo;

  return [status || 'insufficient', statusInfo || ''];
};
var isDraft = function isDraft(agentClusterInstall) {
  return !!agentClusterInstall && ['pending-for-input', 'insufficient', 'ready'].includes(getClusterStatus(agentClusterInstall)[0]);
};
var getAgentStatusFromConditions = function getAgentStatusFromConditions(agent) {
  var _agent$status;

  var conditions = (_agent$status = agent.status) === null || _agent$status === void 0 ? void 0 : _agent$status.conditions;
  var conditionsByType = (conditions || []).reduce(conditionsByTypeReducer, {});
  var Installed = conditionsByType.Installed,
      Connected = conditionsByType.Connected,
      ReadyForInstallation = conditionsByType.ReadyForInstallation;
  if ((Installed === null || Installed === void 0 ? void 0 : Installed.status) === 'True') return ['installed', Installed.message];
  if ((Installed === null || Installed === void 0 ? void 0 : Installed.status) === 'False' && Installed.reason === 'InstallationFailed') return ['error', Installed.message];
  if ((Installed === null || Installed === void 0 ? void 0 : Installed.status) === 'False' && (Installed === null || Installed === void 0 ? void 0 : Installed.reason) === 'InstallationInProgress') return ['installing', Installed === null || Installed === void 0 ? void 0 : Installed.message];
  if ((Connected === null || Connected === void 0 ? void 0 : Connected.status) === 'False') return ['disconnected', Connected.message];
  if ((ReadyForInstallation === null || ReadyForInstallation === void 0 ? void 0 : ReadyForInstallation.status) === 'True') return ['known', ReadyForInstallation.message];
  if ((ReadyForInstallation === null || ReadyForInstallation === void 0 ? void 0 : ReadyForInstallation.status) === 'False' && (ReadyForInstallation === null || ReadyForInstallation === void 0 ? void 0 : ReadyForInstallation.reason) === 'AgentIsNotApproved') return ['pending-for-input', ReadyForInstallation.message];
  if ((ReadyForInstallation === null || ReadyForInstallation === void 0 ? void 0 : ReadyForInstallation.status) === 'False' && (ReadyForInstallation === null || ReadyForInstallation === void 0 ? void 0 : ReadyForInstallation.reason) === 'AgentNotReady') return ['insufficient', ReadyForInstallation.message];
  console.error('Unhandled conditions to agent status mapping: ', conditionsByType);
  return ['insufficient', 'Unexpected Agent conditions.'];
};
var getAgentStatus = function getAgentStatus(agent, excludeDiscovered) {
  var _agent$status2, _agent$status2$debugI, _agent$status3, _validationsInfo, _agent$status4, _agent$status4$debugI;

  if (excludeDiscovered === void 0) {
    excludeDiscovered = false;
  }

  var state = ((_agent$status2 = agent.status) === null || _agent$status2 === void 0 ? void 0 : (_agent$status2$debugI = _agent$status2.debugInfo) === null || _agent$status2$debugI === void 0 ? void 0 : _agent$status2$debugI.state) || 'insufficient';
  var conditions = getFailingResourceConditions(agent, REQUIRED_AGENT_CONDITION_TYPES);
  var validationsInfo = (_agent$status3 = agent.status) === null || _agent$status3 === void 0 ? void 0 : _agent$status3.hostValidationInfo;

  if (conditions === null || conditions === void 0 ? void 0 : conditions.length) {
    validationsInfo = {
      infrastructure: conditions.map(function (c) {
        return {
          id: c.type,
          status: 'failure',
          message: c.message
        };
      })
    };
  }

  if (!excludeDiscovered && !agent.spec.approved) {
    state = 'Discovered';
  } else if (state !== 'binding' && ((_validationsInfo = validationsInfo) === null || _validationsInfo === void 0 ? void 0 : _validationsInfo.infrastructure) && !validationsInfo.infrastructure.find(function (c) {
    return c.id.toLowerCase() === 'connected';
  })) {
    state = 'insufficient';
  }

  return [state, ((_agent$status4 = agent.status) === null || _agent$status4 === void 0 ? void 0 : (_agent$status4$debugI = _agent$status4.debugInfo) === null || _agent$status4$debugI === void 0 ? void 0 : _agent$status4$debugI.stateInfo) || '', validationsInfo || {}];
};
var getBMHStatus = function getBMHStatus(bmh) {
  var _bmh$status, _bmh$status2, _bmh$status2$provisio, _bmh$status3;

  var state = ((_bmh$status = bmh.status) === null || _bmh$status === void 0 ? void 0 : _bmh$status.errorType) || ((_bmh$status2 = bmh.status) === null || _bmh$status2 === void 0 ? void 0 : (_bmh$status2$provisio = _bmh$status2.provisioning) === null || _bmh$status2$provisio === void 0 ? void 0 : _bmh$status2$provisio.state);
  return {
    title: state ? state.charAt(0).toUpperCase() + state.slice(1) : state,
    message: (_bmh$status3 = bmh.status) === null || _bmh$status3 === void 0 ? void 0 : _bmh$status3.errorMessage
  };
};

var getHostNetworks = function getHostNetworks(agents, agentClusterInstall) {
  var _agentClusterInstall$;

  if (!(agents === null || agents === void 0 ? void 0 : agents.length) || !(agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.status) === null || _agentClusterInstall$ === void 0 ? void 0 : _agentClusterInstall$.connectivityMajorityGroups)) {
    return [];
  }

  var connectivityMajorityGroups = JSON.parse(agentClusterInstall.status.connectivityMajorityGroups);
  return Object.keys(connectivityMajorityGroups).filter(function (k) {
    return !['IPv4', 'IPv6'].includes(k);
  }).map(function (cidr) {
    var hostIds = [];
    connectivityMajorityGroups[cidr].forEach(function (hostName) {
      var _agent$metadata2;

      var agent = agents.find(function (agent) {
        var _agent$metadata;

        return ((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : _agent$metadata.name) === hostName;
      });

      if (!(agent === null || agent === void 0 ? void 0 : (_agent$metadata2 = agent.metadata) === null || _agent$metadata2 === void 0 ? void 0 : _agent$metadata2.uid)) {
        console.warn("Can not find agent of " + hostName + " name.");
      } else {
        hostIds.push(agent.metadata.uid);
      }
    });
    return {
      cidr: cidr,
      hostIds: hostIds
    };
  });
};

var AGENT_LOCATION_LABEL_KEY = 'agentclusterinstalls.extensions.hive.openshift.io/location';
var AGENT_SELECTOR = 'agentBareMetal-agentSelector-';
var AGENT_AUTO_SELECT_ANNOTATION_KEY = "agentBareMetal-agentSelector/autoSelect";
var AGENT_NOLOCATION_VALUE = 'NOLOCATION';
var INFRAENV_AGENTINSTALL_LABEL_KEY = 'infraenvs.agent-install.openshift.io';
var AGENT_BMH_HOSTNAME_LABEL_KEY = 'agent-install.openshift.io/bmh';

var AGENT_FOR_SELECTION_STATUSES = ['known', 'known-unbound', 'insufficient', 'insufficient-unbound', 'pending-for-input'];
var hostToAgent = function hostToAgent(agents, host) {
  if (agents === void 0) {
    agents = [];
  }

  return agents.find(function (a) {
    var _a$metadata;

    return ((_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : _a$metadata.uid) === host.id;
  });
};
var getAgentsForSelection = function getAgentsForSelection(agents) {
  return agents.filter(function (agent) {
    var _getAgentStatus = getAgentStatus(agent),
        status = _getAgentStatus[0];

    return AGENT_FOR_SELECTION_STATUSES.includes(status);
  });
};
var getAgentRole = function getAgentRole(agent) {
  var _agent$status;

  return agent.spec.role || ((_agent$status = agent.status) === null || _agent$status === void 0 ? void 0 : _agent$status.role);
};
var getAgentProgressStages = function getAgentProgressStages(agent) {
  var _agent$status2;

  var isBootstrap = (_agent$status2 = agent.status) === null || _agent$status2 === void 0 ? void 0 : _agent$status2.bootstrap;
  var role = getAgentRole(agent);
  var bootstrapHostStages = ['Starting installation', 'Installing', 'Writing image to disk', 'Waiting for control plane', 'Waiting for bootkube', 'Waiting for controller', 'Rebooting', 'Configuring', 'Joined', 'Done'];
  var masterHostStages = ['Starting installation', 'Installing', 'Writing image to disk', 'Rebooting', 'Configuring', 'Joined', 'Done'];
  var workerHostStages = ['Starting installation', 'Installing', 'Writing image to disk', 'Waiting for control plane', 'Rebooting', 'Waiting for ignition', 'Configuring', 'Joined', 'Done'];
  if (isBootstrap) return bootstrapHostStages;
  if (role === 'master') return masterHostStages;
  if (role === 'worker') return workerHostStages;
  return [];
};
var getAgentProgress = function getAgentProgress(agent) {
  var _agent$status3;

  return (_agent$status3 = agent.status) === null || _agent$status3 === void 0 ? void 0 : _agent$status3.progress;
};

var getAIHosts = function getAIHosts(agents, bmhs, infraEnv) {
  var bmhAgents = [];
  var hosts = agents.map(function (agent) {
    var _agent$status, _inventory$interfaces, _agent$metadata, _agent$metadata$label, _agent$metadata3, _agent$metadata4, _agent$status2;

    var _getAgentStatus = getAgentStatus(agent, true),
        status = _getAgentStatus[0],
        statusInfo = _getAgentStatus[1];

    var inventory = ___default.cloneDeep(((_agent$status = agent.status) === null || _agent$status === void 0 ? void 0 : _agent$status.inventory) || {});

    (_inventory$interfaces = inventory.interfaces) === null || _inventory$interfaces === void 0 ? void 0 : _inventory$interfaces.forEach(function (intf) {
      intf.ipv4Addresses = ___default.cloneDeep(intf.ipV4Addresses);
      intf.ipv6Addresses = ___default.cloneDeep(intf.ipV6Addresses);
    });

    if ((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : (_agent$metadata$label = _agent$metadata.labels) === null || _agent$metadata$label === void 0 ? void 0 : _agent$metadata$label[AGENT_BMH_HOSTNAME_LABEL_KEY]) {
      var _agent$metadata2, _agent$metadata2$labe;

      bmhAgents.push((_agent$metadata2 = agent.metadata) === null || _agent$metadata2 === void 0 ? void 0 : (_agent$metadata2$labe = _agent$metadata2.labels) === null || _agent$metadata2$labe === void 0 ? void 0 : _agent$metadata2$labe[AGENT_BMH_HOSTNAME_LABEL_KEY]);
    }

    var agentProgress = getAgentProgress(agent);
    return {
      kind: 'Host',
      id: ((_agent$metadata3 = agent.metadata) === null || _agent$metadata3 === void 0 ? void 0 : _agent$metadata3.uid) || '',
      href: '',
      status: status,
      statusInfo: statusInfo,
      role: getAgentRole(agent),
      requestedHostname: agent.spec.hostname || inventory.hostname,
      createdAt: (_agent$metadata4 = agent.metadata) === null || _agent$metadata4 === void 0 ? void 0 : _agent$metadata4.creationTimestamp,
      validationsInfo: JSON.stringify({
        hardware: []
      }),
      inventory: JSON.stringify(inventory),
      progress: agentProgress && {
        currentStage: agentProgress.currentStage,
        progressInfo: agentProgress.progressInfo,
        stageStartedAt: agentProgress.stageStartTime,
        stageUpdatedAt: agentProgress.stageUpdateTime
      },
      progressStages: getAgentProgressStages(agent),
      bootstrap: (_agent$status2 = agent.status) === null || _agent$status2 === void 0 ? void 0 : _agent$status2.bootstrap
    };
  });
  var restBmhs = infraEnv && bmhs ? bmhs === null || bmhs === void 0 ? void 0 : bmhs.filter(function (h) {
    var _h$metadata, _infraEnv$metadata, _h$metadata2, _h$metadata2$labels, _infraEnv$metadata2, _h$metadata3;

    return ((_h$metadata = h.metadata) === null || _h$metadata === void 0 ? void 0 : _h$metadata.namespace) === ((_infraEnv$metadata = infraEnv.metadata) === null || _infraEnv$metadata === void 0 ? void 0 : _infraEnv$metadata.namespace) && ((_h$metadata2 = h.metadata) === null || _h$metadata2 === void 0 ? void 0 : (_h$metadata2$labels = _h$metadata2.labels) === null || _h$metadata2$labels === void 0 ? void 0 : _h$metadata2$labels[INFRAENV_AGENTINSTALL_LABEL_KEY]) === ((_infraEnv$metadata2 = infraEnv.metadata) === null || _infraEnv$metadata2 === void 0 ? void 0 : _infraEnv$metadata2.name) && ((_h$metadata3 = h.metadata) === null || _h$metadata3 === void 0 ? void 0 : _h$metadata3.name) ? !bmhAgents.includes(h.metadata.name) : true;
  }).map(function (h) {
    var _h$metadata4, _h$spec, _h$spec$bmc, _h$metadata5, _h$metadata6, _h$metadata7;

    var hostInventory = {
      hostname: (_h$metadata4 = h.metadata) === null || _h$metadata4 === void 0 ? void 0 : _h$metadata4.name,
      bmcAddress: (_h$spec = h.spec) === null || _h$spec === void 0 ? void 0 : (_h$spec$bmc = _h$spec.bmc) === null || _h$spec$bmc === void 0 ? void 0 : _h$spec$bmc.address,
      systemVendor: {
        virtual: false,
        productName: 'Bare Metal Host'
      }
    };
    var restBmh = {
      id: ((_h$metadata5 = h.metadata) === null || _h$metadata5 === void 0 ? void 0 : _h$metadata5.uid) || '',
      href: '',
      kind: 'Host',
      status: 'known',
      statusInfo: '',
      inventory: JSON.stringify(hostInventory),
      requestedHostname: (_h$metadata6 = h.metadata) === null || _h$metadata6 === void 0 ? void 0 : _h$metadata6.name,
      role: undefined,
      createdAt: (_h$metadata7 = h.metadata) === null || _h$metadata7 === void 0 ? void 0 : _h$metadata7.creationTimestamp
    };
    return restBmh;
  }) : [];
  return [].concat(hosts, restBmhs);
};
var getAICluster = function getAICluster(_ref) {
  var _clusterDeployment$me, _clusterDeployment$sp, _clusterDeployment$sp2, _agentClusterInstall$, _agentClusterInstall$2, _agentClusterInstall$3, _agentClusterInstall$4, _agentClusterInstall$5, _agentClusterInstall$6, _agentClusterInstall$7, _agentClusterInstall$8, _agentClusterInstall$9, _agentClusterInstall$10, _agentClusterInstall$11, _agentClusterInstall$12, _agentClusterInstall$13, _agentClusterInstall$14, _agentClusterInstall$15, _agentClusterInstall$16, _agentClusterInstall$17, _agentClusterInstall$18, _agentClusterInstall$19, _agentClusterInstall$20, _agentClusterInstall$21, _agentClusterInstall$22, _agentClusterInstall$23, _agentClusterInstall$24, _agentClusterInstall$25, _clusterDeployment$st, _clusterDeployment$st2;

  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      _ref$agents = _ref.agents,
      agents = _ref$agents === void 0 ? [] : _ref$agents;

  var _getClusterStatus = getClusterStatus(agentClusterInstall),
      status = _getClusterStatus[0],
      statusInfo = _getClusterStatus[1];

  var aiCluster = {
    id: ((_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.uid) || '',
    kind: 'Cluster',
    href: '',
    name: (_clusterDeployment$sp = clusterDeployment.spec) === null || _clusterDeployment$sp === void 0 ? void 0 : _clusterDeployment$sp.clusterName,
    baseDnsDomain: (_clusterDeployment$sp2 = clusterDeployment.spec) === null || _clusterDeployment$sp2 === void 0 ? void 0 : _clusterDeployment$sp2.baseDomain,
    openshiftVersion: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.imageSetRef) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.name,
    apiVip: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$3 = agentClusterInstall.spec) === null || _agentClusterInstall$3 === void 0 ? void 0 : _agentClusterInstall$3.apiVIP,
    ingressVip: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$4 = agentClusterInstall.spec) === null || _agentClusterInstall$4 === void 0 ? void 0 : _agentClusterInstall$4.ingressVIP,
    highAvailabilityMode: (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$5 = agentClusterInstall.spec) === null || _agentClusterInstall$5 === void 0 ? void 0 : (_agentClusterInstall$6 = _agentClusterInstall$5.provisionRequirements) === null || _agentClusterInstall$6 === void 0 ? void 0 : _agentClusterInstall$6.controlPlaneAgents) === 1 ? 'None' : 'Full',
    status: status,
    statusInfo: statusInfo,
    imageInfo: {
      sshPublicKey: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$7 = agentClusterInstall.spec) === null || _agentClusterInstall$7 === void 0 ? void 0 : _agentClusterInstall$7.sshPublicKey
    },
    sshPublicKey: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$8 = agentClusterInstall.spec) === null || _agentClusterInstall$8 === void 0 ? void 0 : _agentClusterInstall$8.sshPublicKey,
    clusterNetworkHostPrefix: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$9 = agentClusterInstall.spec) === null || _agentClusterInstall$9 === void 0 ? void 0 : (_agentClusterInstall$10 = _agentClusterInstall$9.networking) === null || _agentClusterInstall$10 === void 0 ? void 0 : (_agentClusterInstall$11 = _agentClusterInstall$10.clusterNetwork) === null || _agentClusterInstall$11 === void 0 ? void 0 : (_agentClusterInstall$12 = _agentClusterInstall$11[0]) === null || _agentClusterInstall$12 === void 0 ? void 0 : _agentClusterInstall$12.hostPrefix,
    clusterNetworkCidr: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$13 = agentClusterInstall.spec) === null || _agentClusterInstall$13 === void 0 ? void 0 : (_agentClusterInstall$14 = _agentClusterInstall$13.networking) === null || _agentClusterInstall$14 === void 0 ? void 0 : (_agentClusterInstall$15 = _agentClusterInstall$14.clusterNetwork) === null || _agentClusterInstall$15 === void 0 ? void 0 : (_agentClusterInstall$16 = _agentClusterInstall$15[0]) === null || _agentClusterInstall$16 === void 0 ? void 0 : _agentClusterInstall$16.cidr,
    serviceNetworkCidr: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$17 = agentClusterInstall.spec) === null || _agentClusterInstall$17 === void 0 ? void 0 : (_agentClusterInstall$18 = _agentClusterInstall$17.networking) === null || _agentClusterInstall$18 === void 0 ? void 0 : (_agentClusterInstall$19 = _agentClusterInstall$18.serviceNetwork) === null || _agentClusterInstall$19 === void 0 ? void 0 : _agentClusterInstall$19[0],
    machineNetworkCidr: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$20 = agentClusterInstall.spec) === null || _agentClusterInstall$20 === void 0 ? void 0 : (_agentClusterInstall$21 = _agentClusterInstall$20.networking) === null || _agentClusterInstall$21 === void 0 ? void 0 : (_agentClusterInstall$22 = _agentClusterInstall$21.machineNetwork) === null || _agentClusterInstall$22 === void 0 ? void 0 : (_agentClusterInstall$23 = _agentClusterInstall$22[0]) === null || _agentClusterInstall$23 === void 0 ? void 0 : _agentClusterInstall$23.cidr,
    monitoredOperators: [],
    vipDhcpAllocation: false,
    userManagedNetworking: (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$24 = agentClusterInstall.spec) === null || _agentClusterInstall$24 === void 0 ? void 0 : (_agentClusterInstall$25 = _agentClusterInstall$24.provisionRequirements) === null || _agentClusterInstall$25 === void 0 ? void 0 : _agentClusterInstall$25.controlPlaneAgents) === 1,
    hostNetworks: getHostNetworks(agents, agentClusterInstall),
    totalHostCount: agents === null || agents === void 0 ? void 0 : agents.length,
    hosts: getAIHosts(agents),
    installStartedAt: (_clusterDeployment$st = clusterDeployment.status) === null || _clusterDeployment$st === void 0 ? void 0 : _clusterDeployment$st.installStartedTimestamp,
    installCompletedAt: (_clusterDeployment$st2 = clusterDeployment.status) === null || _clusterDeployment$st2 === void 0 ? void 0 : _clusterDeployment$st2.installedTimestamp
  };
  return aiCluster;
};

var getVersion = function getVersion(releaseImage) {
  if (releaseImage === void 0) {
    releaseImage = '';
  }

  var match = /.+:(.*)-/gm.exec(releaseImage);

  if (match && match[1]) {
    return match[1];
  }

  return '';
};

var getOCPVersions = function getOCPVersions(clusterImageSets) {
  var versions = clusterImageSets.filter(function (clusterImageSet) {
    var _clusterImageSet$meta, _clusterImageSet$meta2;

    return ((_clusterImageSet$meta = clusterImageSet.metadata) === null || _clusterImageSet$meta === void 0 ? void 0 : (_clusterImageSet$meta2 = _clusterImageSet$meta.labels) === null || _clusterImageSet$meta2 === void 0 ? void 0 : _clusterImageSet$meta2.visible) !== 'false';
  }).map(function (clusterImageSet) {
    var _clusterImageSet$spec, _clusterImageSet$meta3, _clusterImageSet$meta4;

    var version = getVersion((_clusterImageSet$spec = clusterImageSet.spec) === null || _clusterImageSet$spec === void 0 ? void 0 : _clusterImageSet$spec.releaseImage);
    return {
      label: version ? "OpenShift " + version : (_clusterImageSet$meta3 = clusterImageSet.metadata) === null || _clusterImageSet$meta3 === void 0 ? void 0 : _clusterImageSet$meta3.name,
      version: version,
      value: (_clusterImageSet$meta4 = clusterImageSet.metadata) === null || _clusterImageSet$meta4 === void 0 ? void 0 : _clusterImageSet$meta4.name,
      "default": false,
      supportLevel: 'production'
    };
  }).sort(function (versionA, versionB) {
    return -1 * versionA.label.localeCompare(versionB.label);
  });

  if (versions.length) {
    versions[0]["default"] = true;
  }

  return versions;
};

var getLocationsFromMatchExpressions = function getLocationsFromMatchExpressions(expressions) {
  var _expressions$find;

  if (expressions === void 0) {
    expressions = [];
  }

  return ((_expressions$find = expressions.find(function (expr) {
    return expr.key === AGENT_LOCATION_LABEL_KEY;
  })) === null || _expressions$find === void 0 ? void 0 : _expressions$find.values) || [];
};
var getAgentLocationMatchExpression = function getAgentLocationMatchExpression(locations) {
  return (locations === null || locations === void 0 ? void 0 : locations.length) ? [{
    key: AGENT_LOCATION_LABEL_KEY,
    operator: 'In',
    values: locations
  }] : undefined;
};

var version = "1.5.39-4-acm2.4";

var _OPERATOR_LABELS;
var OPENSHIFT_LIFE_CYCLE_DATES_LINK = 'https://access.redhat.com/support/policy/updates/openshift#dates';
var OPENSHIFT_NETWORKING_DOCS_LINK = 'https://docs.openshift.com/container-platform/4.7/installing/installing_bare_metal/installing-bare-metal.html#installation-network-user-infra_installing-bare-metal';
var CLUSTER_MANAGER_SITE_LINK = 'https://cloud.redhat.com/openshift/install/pull-secret';
var PULL_SECRET_INFO_LINK = CLUSTER_MANAGER_SITE_LINK;
var VSPHERE_CONFIG_LINK = 'https://issues.redhat.com/secure/attachment/12531134/12531134_How+to+modify+the+vSphere+configuration+in+OpenShift+4.x+-+Red+Hat+Customer+Portal.pdf';
var getBugzillaLink = function getBugzillaLink(version) {
  if (version === void 0) {
    version = '';
  }

  return "https://bugzilla.redhat.com/enter_bug.cgi?product=OpenShift%20Container%20Platform&Component=OpenShift%20Container%20Platform&component=assisted-installer&version=" + version;
};
var FEEDBACK_FORM_LINK = 'https://docs.google.com/forms/d/e/1FAIpQLSfg9M8wRW4m_HkWeAl6KpB5dTcMu8iI3iJ29GlLfZpF2hnjng/viewform';
var getOcpConsoleNodesPage = function getOcpConsoleNodesPage(ocpConsoleUrl) {
  return ocpConsoleUrl + "/k8s/cluster/nodes";
};
var getProductBrandingCode = function getProductBrandingCode() {
  return 'redhat';
};
var POLLING_INTERVAL = 10 * 1000;
var EVENTS_POLLING_INTERVAL = 10 * 1000;
var HOST_ROLES = [{
  value: 'auto-assign',
  label: 'Automatic',
  description: 'A role will be chosen automatically based on detected hardware and network latency.'
}, {
  value: 'master',
  label: 'Control plane node',
  description: 'Runs the control plane components of OpenShift, including the API server.'
}, {
  value: 'worker',
  label: 'Worker',
  description: 'Runs application workloads. Connect at least 5 hosts to enable dedicated workers.'
}];
var CLUSTER_STATUS_LABELS = {
  'pending-for-input': 'Draft',
  insufficient: 'Draft',
  ready: 'Draft',
  'preparing-for-installation': 'Preparing for installation',
  installing: 'Installing',
  'installing-pending-user-action': 'Installing (pending action)',
  finalizing: 'Finalizing',
  cancelled: 'Installation cancelled',
  error: 'Error',
  installed: 'Installed',
  'adding-hosts': 'Adding hosts'
};
var HOST_STATUS_LABELS = {
  unbinding: 'Unbinding',
  'disabled-unbound': 'Disabled',
  'disconnected-unbound': 'Disconnected',
  'discovering-unbound': 'Discovering',
  'insufficient-unbound': 'Insufficient',
  'known-unbound': 'Ready',
  binding: 'Binding',
  discovering: 'Discovering',
  'pending-for-input': 'Pending input',
  known: 'Ready',
  disconnected: 'Disconnected',
  insufficient: 'Insufficient',
  disabled: 'Disabled',
  'preparing-for-installation': 'Preparing for installation',
  'preparing-successful': 'Preparing installation successful',
  installing: 'Starting installation',
  'installing-in-progress': 'Installing',
  'installing-pending-user-action': 'Pending user action',
  installed: 'Installed',
  cancelled: 'Installation cancelled',
  error: 'Error',
  resetting: 'Resetting',
  'resetting-pending-user-action': 'Reboot required',
  'added-to-existing-cluster': 'Installed'
};
var CLUSTER_FIELD_LABELS = {
  name: 'Cluster name',
  baseDnsDomain: 'Base domain',
  clusterNetworkCidr: 'Cluster network CIDR',
  clusterNetworkHostPrefix: 'Cluster network host prefix',
  serviceNetworkCidr: 'Service network CIDR',
  apiVip: 'API Virtual IP',
  ingressVip: 'Ingress Virtual IP',
  pullSecret: 'Pull secret',
  sshPublicKey: 'SSH public key',
  SNODisclaimer: 'Single Node OpenShift disclaimer'
};
var HOST_STATUS_DETAILS = {
  unbinding: 'This host is being unbound from the cluster.',
  'disabled-unbound': 'This host was manually disabled and can not be included in the cluster. Enable this host to make it available again.',
  'disconnected-unbound': 'This host has lost its connection to the installer and can not be included in the cluster unless connectivity is restored.',
  'discovering-unbound': 'This host is transmitting its hardware and networking information to the installer. Please wait while this information is received.',
  'insufficient-unbound': 'This host does not meet the minimum hardware or networking requirements and can not be included in the cluster.',
  'known-unbound': 'This host meets the minimum hardware and networking requirements and can be included in the cluster.',
  binding: 'This host is being bound to the cluster.',
  discovering: 'This host is transmitting its hardware and networking information to the installer. Please wait while this information is received.',
  'pending-for-input': '',
  known: 'This host meets the minimum hardware and networking requirements and will be included in the cluster.',
  disconnected: 'This host has lost its connection to the installer and will not be included in the cluster unless connectivity is restored.',
  insufficient: 'This host does not meet the minimum hardware or networking requirements and will not be included in the cluster.',
  disabled: 'This host was manually disabled and will not be included in the cluster. Enable this host to include it again.',
  'preparing-for-installation': '',
  'preparing-successful': '',
  installing: '',
  'installing-in-progress': '',
  'installing-pending-user-action': 'This host is pending user action',
  installed: 'This host completed its installation successfully.',
  cancelled: 'This host installation has been cancelled.',
  error: 'This host failed its installation.',
  resetting: 'This host is resetting the installation.',
  'resetting-pending-user-action': 'Host already booted from disk during previous installation. To finish resetting the installation please boot the host into Discovery ISO.',
  'added-to-existing-cluster': ''
};
var HOST_VALIDATION_GROUP_LABELS = {
  hardware: 'Hardware',
  network: 'Network',
  operators: 'Operators',
  infrastructure: 'Infrastructure'
};
var HOST_VALIDATION_LABELS = {
  'disk-encryption-requirements-satisfied': 'Disk encryption requirements',
  'compatible-with-cluster-platform': '',
  'has-default-route': 'Default route to host',
  'sufficient-network-latency-requirement-for-role': 'Network latency',
  'sufficient-packet-loss-requirement-for-role': 'Packet loss',
  'has-inventory': 'Hardware information',
  'has-min-cpu-cores': 'Minimum CPU cores',
  'has-min-memory': 'Minimum Memory',
  'has-min-valid-disks': 'Minimum disks of required size',
  'has-cpu-cores-for-role': 'Minimum CPU cores for selected role',
  'has-memory-for-role': 'Minimum memory for selected role',
  'hostname-unique': 'Unique hostname',
  'hostname-valid': 'Valid hostname',
  connected: 'Connected',
  'machine-cidr-defined': 'Machine CIDR',
  'belongs-to-machine-cidr': 'Belongs to machine CIDR',
  'api-vip-connected': 'API VIP connected',
  'belongs-to-majority-group': 'Belongs to majority connected group',
  'valid-platform-network-settings': 'Platform network settings',
  'ntp-synced': 'NTP synchronization',
  'container-images-available': 'Container images availability',
  'lso-requirements-satisfied': 'LSO requirements',
  'ocs-requirements-satisfied': 'OCS requirements',
  'sufficient-installation-disk-speed': 'Installation disk speed',
  'cnv-requirements-satisfied': 'CNV requirements',
  'api-domain-name-resolved-correctly': 'API domain name resolution',
  'api-int-domain-name-resolved-correctly': 'API internal domain name resolution',
  'apps-domain-name-resolved-correctly': 'Application ingress domain name resolution',
  'dns-wildcard-not-configured': 'DNS wildcard not configured'
};
var HOST_VALIDATION_FAILURE_HINTS = {
  'disk-encryption-requirements-satisfied': '',
  'compatible-with-cluster-platform': '',
  'has-default-route': '',
  'sufficient-network-latency-requirement-for-role': '',
  'sufficient-packet-loss-requirement-for-role': '',
  'has-inventory': '',
  'has-min-cpu-cores': '',
  'has-min-memory': '',
  'has-min-valid-disks': '',
  'has-cpu-cores-for-role': '',
  'has-memory-for-role': '',
  'hostname-unique': '',
  'hostname-valid': '',
  connected: '',
  'machine-cidr-defined': '',
  'belongs-to-machine-cidr': '',
  'api-vip-connected': '',
  'belongs-to-majority-group': '',
  'valid-platform-network-settings': '',
  'ntp-synced': "Please manually fix host's NTP configuration or provide additional NTP sources.",
  'container-images-available': '',
  'lso-requirements-satisfied': '',
  'ocs-requirements-satisfied': '',
  'sufficient-installation-disk-speed': '',
  'cnv-requirements-satisfied': '',
  'api-domain-name-resolved-correctly': '',
  'api-int-domain-name-resolved-correctly': '',
  'apps-domain-name-resolved-correctly': '',
  'dns-wildcard-not-configured': ''
};
var CLUSTER_VALIDATION_LABELS = {
  'network-type-valid': 'Valid network type',
  'machine-cidr-defined': 'Machine CIDR',
  'cluster-cidr-defined': 'Cluster CIDR',
  'service-cidr-defined': 'Service CIDR',
  'no-cidrs-overlapping': 'No overlapping CIDR',
  'network-prefix-valid': 'Valid network prefix',
  'machine-cidr-equals-to-calculated-cidr': 'Machine CIDR conforms expected',
  'api-vip-defined': 'API VIP',
  'api-vip-valid': 'API VIP validity',
  'ingress-vip-defined': 'Ingress VIP',
  'ingress-vip-valid': 'Ingress VIP validity',
  'all-hosts-are-ready-to-install': 'All hosts are ready to install',
  'sufficient-masters-count': 'Control plane nodes count',
  'dns-domain-defined': 'DNS domain',
  'pull-secret-set': 'Pull secret',
  'ntp-server-configured': 'NTP server',
  'lso-requirements-satisfied': 'LSO requirements',
  'ocs-requirements-satisfied': 'OCS requirements',
  'cnv-requirements-satisfied': 'CNV requirements'
};
var CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV4 = {
  clusterNetworkCidr: '10.128.0.0/14',
  clusterNetworkHostPrefix: 23,
  serviceNetworkCidr: '172.30.0.0/16'
};
var CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV6 = {
  clusterNetworkCidr: '2002:db8::/53',
  clusterNetworkHostPrefix: 64,
  serviceNetworkCidr: '2003:db8::/112'
};
var getAssistedUiLibVersion = function getAssistedUiLibVersion() {
  return version;
};
var EVENT_SEVERITIES = ['info', 'warning', 'error', 'critical'];
var TIME_ZERO = '0001-01-01T00:00:00.000Z';
var NO_SUBNET_SET = 'NO_SUBNET_SET';
var PREFIX_MAX_RESTRICTION = {
  IPv6: 128,
  IPv4: 25
};
var DISK_ROLE_LABELS = {
  none: 'None',
  install: 'Installation disk'
};
var SNO_SUPPORT_MIN_VERSION = 4.8;
var OPERATOR_NAME_CNV = 'cnv';
var OPERATOR_NAME_LSO = 'lso';
var OPERATOR_NAME_OCS = 'ocs';
var OPERATOR_NAME_CVO = 'cvo';
var OPERATOR_NAME_CONSOLE = 'console';
var OPERATOR_LABELS = (_OPERATOR_LABELS = {}, _OPERATOR_LABELS[OPERATOR_NAME_CONSOLE] = 'OpenShift Console', _OPERATOR_LABELS[OPERATOR_NAME_CVO] = 'OpenShift Cluster Version Operator', _OPERATOR_LABELS[OPERATOR_NAME_LSO] = 'OpenShift Local Storage', _OPERATOR_LABELS[OPERATOR_NAME_OCS] = 'OpenShift Container Storage', _OPERATOR_LABELS[OPERATOR_NAME_CNV] = 'OpenShift Virtualization', _OPERATOR_LABELS);



var index = {
  __proto__: null,
  OPENSHIFT_LIFE_CYCLE_DATES_LINK: OPENSHIFT_LIFE_CYCLE_DATES_LINK,
  OPENSHIFT_NETWORKING_DOCS_LINK: OPENSHIFT_NETWORKING_DOCS_LINK,
  CLUSTER_MANAGER_SITE_LINK: CLUSTER_MANAGER_SITE_LINK,
  PULL_SECRET_INFO_LINK: PULL_SECRET_INFO_LINK,
  VSPHERE_CONFIG_LINK: VSPHERE_CONFIG_LINK,
  getBugzillaLink: getBugzillaLink,
  FEEDBACK_FORM_LINK: FEEDBACK_FORM_LINK,
  getOcpConsoleNodesPage: getOcpConsoleNodesPage,
  getProductBrandingCode: getProductBrandingCode,
  POLLING_INTERVAL: POLLING_INTERVAL,
  EVENTS_POLLING_INTERVAL: EVENTS_POLLING_INTERVAL,
  HOST_ROLES: HOST_ROLES,
  CLUSTER_STATUS_LABELS: CLUSTER_STATUS_LABELS,
  HOST_STATUS_LABELS: HOST_STATUS_LABELS,
  CLUSTER_FIELD_LABELS: CLUSTER_FIELD_LABELS,
  HOST_STATUS_DETAILS: HOST_STATUS_DETAILS,
  HOST_VALIDATION_GROUP_LABELS: HOST_VALIDATION_GROUP_LABELS,
  HOST_VALIDATION_LABELS: HOST_VALIDATION_LABELS,
  HOST_VALIDATION_FAILURE_HINTS: HOST_VALIDATION_FAILURE_HINTS,
  CLUSTER_VALIDATION_LABELS: CLUSTER_VALIDATION_LABELS,
  CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV4: CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV4,
  CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV6: CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV6,
  getAssistedUiLibVersion: getAssistedUiLibVersion,
  EVENT_SEVERITIES: EVENT_SEVERITIES,
  TIME_ZERO: TIME_ZERO,
  NO_SUBNET_SET: NO_SUBNET_SET,
  PREFIX_MAX_RESTRICTION: PREFIX_MAX_RESTRICTION,
  DISK_ROLE_LABELS: DISK_ROLE_LABELS,
  SNO_SUPPORT_MIN_VERSION: SNO_SUPPORT_MIN_VERSION,
  OPERATOR_NAME_CNV: OPERATOR_NAME_CNV,
  OPERATOR_NAME_LSO: OPERATOR_NAME_LSO,
  OPERATOR_NAME_OCS: OPERATOR_NAME_OCS,
  OPERATOR_NAME_CVO: OPERATOR_NAME_CVO,
  OPERATOR_NAME_CONSOLE: OPERATOR_NAME_CONSOLE,
  OPERATOR_LABELS: OPERATOR_LABELS
};

window['Fragment'] = React__default.Fragment;

if (process.env.NODE_ENV !== 'test') {
  console.log('Assisted-ui-lib version: ', getAssistedUiLibVersion());
}

var getFieldId = function getFieldId(fieldName, fieldType, unique) {
  unique = unique ? unique + "-" : '';
  return "form-" + fieldType + "-" + fieldName.replace(/\./g, '-') + "-" + unique + "field";
};
var trimSshPublicKey = function trimSshPublicKey(key) {
  return key.split('\n').map(function (row) {
    return row.trim();
  }).filter(Boolean).join('\n');
};
var trimCommaSeparatedList = function trimCommaSeparatedList(list) {
  return list.split(',').map(function (item) {
    return item.trim();
  }).filter(Boolean).join(',');
};
var getFormikErrorFields = function getFormikErrorFields(errors, touched) {
  return Object.keys(errors).filter(function (field) {
    return touched[field];
  });
};
var getDefaultOpenShiftVersion = function getDefaultOpenShiftVersion(versions) {
  var _versions$find, _versions$;

  return ((_versions$find = versions.find(function (v) {
    return v["default"];
  })) === null || _versions$find === void 0 ? void 0 : _versions$find.value) || ((_versions$ = versions[0]) === null || _versions$ === void 0 ? void 0 : _versions$.value) || '';
};
var labelsToArray = function labelsToArray(labels) {
  if (labels === void 0) {
    labels = {};
  }

  var result = [];

  for (var key in labels) {
    result.push(key + "=" + labels[key]);
  }

  return result;
};
var parseStringLabels = function parseStringLabels(strValues) {
  var labels = strValues.reduce(function (acc, curr) {
    var label = curr.split('=');
    acc[label[0]] = label[1];
    return acc;
  }, {});
  return labels;
};
var uniqueLabels = function uniqueLabels(labelPairs) {
  return labelsToArray(parseStringLabels(labelPairs));
};
var selectedLabelsOnly = function selectedLabelsOnly(labelPairs, allowedKeys) {
  return labelPairs.filter(function (pair) {
    return allowedKeys.includes(pair.split('=')[0]);
  });
};

/** Joins args into a className string
 *
 * @param {any} args list of objects, string, or arrays to reduce
 */
function css(...args) {
    // Adapted from https://github.com/JedWatson/classnames/blob/master/index.js
    const classes = [];
    const hasOwn = {}.hasOwnProperty;
    args.filter(Boolean).forEach((arg) => {
        const argType = typeof arg;
        if (argType === 'string' || argType === 'number') {
            classes.push(arg);
        }
        else if (Array.isArray(arg) && arg.length) {
            const inner = css(...arg);
            if (inner) {
                classes.push(inner);
            }
        }
        else if (argType === 'object') {
            for (const key in arg) {
                if (hasOwn.call(arg, key) && arg[key]) {
                    classes.push(key);
                }
            }
        }
    });
    return classes.join(' ');
}
//# sourceMappingURL=index.js.map

var HelperText = function HelperText(_ref) {
  var fieldId = _ref.fieldId,
      children = _ref.children,
      _ref$isError = _ref.isError,
      isError = _ref$isError === void 0 ? false : _ref$isError;
  return /*#__PURE__*/React__default.createElement("div", {
    className: css('pf-c-form__helper-text', {
      'pf-m-error': isError
    }),
    id: fieldId + "-helper",
    "aria-live": "polite"
  }, children);
};

var InputField = forwardRef(function (_ref, ref) {
  var label = _ref.label,
      labelIcon = _ref.labelIcon,
      helperText = _ref.helperText,
      isRequired = _ref.isRequired,
      _onChange = _ref.onChange,
      validate = _ref.validate,
      idPostfix = _ref.idPostfix,
      children = _ref.children,
      noDefaultOnChange = _ref.noDefaultOnChange,
      inputError = _ref.inputError,
      description = _ref.description,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "labelIcon", "helperText", "isRequired", "onChange", "validate", "idPostfix", "children", "noDefaultOnChange", "inputError", "description"]);

  var _useField = useField({
    name: props.name,
    validate: validate
  }),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error;

  var fieldId = getFieldId(props.name, 'input', idPostfix);
  var isValid = inputError ? false : !(touched && error);
  var errorMessage = (!isValid ? error : '') || inputError;
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, description && /*#__PURE__*/createElement(HelperText, {
    fieldId: fieldId
  }, /*#__PURE__*/createElement(HelperTextItem, {
    variant: "indeterminate"
  }, description)), /*#__PURE__*/createElement(Split, null, /*#__PURE__*/createElement(SplitItem, {
    isFilled: true
  }, /*#__PURE__*/createElement(TextInput, _extends({}, field, props, {
    ref: ref,
    id: fieldId,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    "aria-describedby": fieldId + "-helper",
    onChange: function onChange(value, event) {
      !noDefaultOnChange && field.onChange(event);
      _onChange && _onChange(event);
    }
  }))), /*#__PURE__*/createElement(SplitItem, null, children)));
});

var CheckboxField = function CheckboxField(_ref) {
  var label = _ref.label,
      helperText = _ref.helperText,
      _onChange = _ref.onChange,
      validate = _ref.validate,
      idPostfix = _ref.idPostfix,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "helperText", "onChange", "validate", "idPostfix"]);

  var _useField = useField({
    name: props.name,
    validate: validate
  }),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error;

  var fieldId = getFieldId(props.name, 'checkbox', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error'
  }, /*#__PURE__*/createElement(Checkbox, _extends({}, field, props, {
    id: fieldId,
    label: label,
    "aria-describedby": fieldId + "-helper",
    description: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    isValid: isValid,
    isChecked: field.value,
    onChange: function onChange(value, event) {
      field.onChange(event);
      _onChange && _onChange(value, event);
    }
  })));
};

var TextAreaField = function TextAreaField(_ref) {
  var label = _ref.label,
      helperText = _ref.helperText,
      getErrorText = _ref.getErrorText,
      isRequired = _ref.isRequired,
      children = _ref.children,
      idPostfix = _ref.idPostfix,
      labelIcon = _ref.labelIcon,
      groupClassName = _ref.groupClassName,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "helperText", "getErrorText", "isRequired", "children", "idPostfix", "labelIcon", "groupClassName"]);

  var _useField = useField(props.name),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error;

  var fieldId = getFieldId(props.name, 'input', idPostfix);
  var isValid = !(touched && error);

  var getErrorMessage = function getErrorMessage() {
    if (!isValid && error) {
      return getErrorText ? getErrorText(error) : error;
    }

    return '';
  };

  var errorMessage = getErrorMessage();

  var isDisabled = props.isDisabled,
      restProps = _objectWithoutPropertiesLoose(props, ["isDisabled"]);

  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: typeof errorMessage === 'string' ? errorMessage : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId,
      isError: true
    }, errorMessage),
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon,
    className: groupClassName
  }, children, /*#__PURE__*/createElement(TextArea, _extends({}, field, restProps, {
    id: fieldId,
    style: {
      resize: 'vertical'
    },
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    "aria-describedby": fieldId + "-helper",
    onChange: function onChange(value, event) {
      return field.onChange(event);
    },
    disabled: isDisabled
  })));
};

var SelectField = function SelectField(_ref) {
  var label = _ref.label,
      options = _ref.options,
      helperText = _ref.helperText,
      isRequired = _ref.isRequired,
      _onChange = _ref.onChange,
      getHelperText = _ref.getHelperText,
      idPostfix = _ref.idPostfix,
      labelIcon = _ref.labelIcon,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "options", "helperText", "isRequired", "onChange", "getHelperText", "idPostfix", "labelIcon"]);

  var _useField = useField(props.name),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error;

  var fieldId = getFieldId(props.name, 'input', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';
  var hText = getHelperText ? getHelperText(field.value) : helperText;
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof hText === 'string' ? hText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, hText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, /*#__PURE__*/createElement(FormSelect, _extends({}, field, props, {
    id: fieldId,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    "aria-describedby": fieldId + "-helper",
    onChange: function onChange(value, event) {
      field.onChange(event);
      _onChange && _onChange(event);
    }
  }), options.map(function (option, index) {
    return /*#__PURE__*/createElement(FormSelectOption, _extends({
      key: option.id || index
    }, option));
  })));
};

var MultiSelectField = function MultiSelectField(_ref) {
  var label = _ref.label,
      options = _ref.options,
      helperText = _ref.helperText,
      placeholderText = _ref.placeholderText,
      isRequired = _ref.isRequired,
      onChange = _ref.onChange,
      getHelperText = _ref.getHelperText,
      idPostfix = _ref.idPostfix,
      labelIcon = _ref.labelIcon,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "options", "helperText", "placeholderText", "isRequired", "onChange", "getHelperText", "idPostfix", "labelIcon"]);

  var _React$useState = React__default.useState(false),
      isOpen = _React$useState[0],
      setOpen = _React$useState[1];

  var _useField = useField(props.name),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error,
      setValue = _useField[2].setValue;

  var fieldId = getFieldId(props.name, 'multiinput', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';
  var hText = getHelperText ? getHelperText(field.value) : helperText;

  var onToggle = function onToggle(isOpen) {
    return setOpen(isOpen);
  };

  var onClearSelection = function onClearSelection() {
    setValue([]);
    onChange && onChange([]);
    setOpen(false);
  };

  var onSelect = function onSelect(event, selection) {
    var selected = field.value;
    var selectionValue = selection.value || selection;
    var newValue;

    if (selected.includes(selectionValue)) {
      newValue = selected.filter(function (sel) {
        return sel !== selectionValue;
      });
    } else {
      newValue = [].concat(field.value, [selectionValue]);
    }

    setValue(newValue);
    onChange && onChange(newValue);
  };

  var selections = field.value.map(function (value) {
    var option = options.find(function (opt) {
      return opt.value === value;
    });
    return option ? {
      value: option.value,
      toString: function toString() {
        return option.displayName;
      },
      compareTo: function compareTo(selectOption) {
        return selectOption.value === value;
      }
    } : value;
  });
  var children = options.filter(function (option) {
    return !(field.value || []).includes(option.value);
  }).map(function (option) {
    return /*#__PURE__*/React__default.createElement(SelectOption, {
      key: option.id,
      id: option.id,
      value: option.value
    }, option.displayName);
  });
  var fuse = new Fuse(options, {
    ignoreLocation: true,
    keys: ['displayName']
  });
  return /*#__PURE__*/React__default.createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof hText === 'string' ? hText : /*#__PURE__*/React__default.createElement(HelperText, {
      fieldId: fieldId
    }, hText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, /*#__PURE__*/React__default.createElement(Select, _extends({}, field, props, {
    id: fieldId,
    variant: SelectVariant.typeaheadMulti,
    typeAheadAriaLabel: "Select a state",
    validated: isValid ? 'default' : 'error',
    "aria-describedby": fieldId + "-helper",
    isCreatable: false,
    placeholderText: placeholderText,
    isOpen: isOpen,
    onToggle: onToggle,
    onSelect: onSelect,
    onClear: onClearSelection,
    selections: selections,
    onFilter: function onFilter(e, val) {
      if (!val || val === '') {
        return children;
      }

      var results = fuse.search(val).map(function (result) {
        return result.item.id;
      });
      return React__default.Children.toArray(children).filter(function (_ref2) {
        var props = _ref2.props;
        return results.includes(props.id);
      });
    }
  }), children));
};

var TextAreaSecretField = function TextAreaSecretField(_ref) {
  var isSet = _ref.isSet,
      isEdit = _ref.isEdit,
      helperTextHidden = _ref.helperTextHidden,
      onToggle = _ref.onToggle,
      idPostfix = _ref.idPostfix,
      props = _objectWithoutPropertiesLoose(_ref, ["isSet", "isEdit", "helperTextHidden", "onToggle", "idPostfix"]);

  var label = props.label,
      name = props.name;
  var fieldId = getFieldId(name, 'input', idPostfix);

  if (isEdit) {
    return /*#__PURE__*/createElement(TextAreaField, props, isSet && /*#__PURE__*/createElement(Button, {
      onClick: function onClick() {
        return onToggle(true);
      },
      variant: "link"
    }, "Keep existing value"));
  }

  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: helperTextHidden,
    isRequired: props.isRequired
  }, /*#__PURE__*/createElement(Button, {
    onClick: function onClick() {
      return onToggle(false);
    },
    variant: "link"
  }, "Change"));
};

var UploadField = function UploadField(_ref) {
  var label = _ref.label,
      labelIcon = _ref.labelIcon,
      helperText = _ref.helperText,
      getErrorText = _ref.getErrorText,
      isRequired = _ref.isRequired,
      children = _ref.children,
      idPostfix = _ref.idPostfix,
      isDisabled = _ref.isDisabled,
      name = _ref.name,
      _onBlur = _ref.onBlur,
      _ref$allowEdittingUpl = _ref.allowEdittingUploadedText,
      allowEdittingUploadedText = _ref$allowEdittingUpl === void 0 ? true : _ref$allowEdittingUpl,
      dropzoneProps = _ref.dropzoneProps;

  var _React$useState = useState(),
      filename = _React$useState[0],
      setFilename = _React$useState[1];

  var _React$useState2 = useState(false),
      isFileUploading = _React$useState2[0],
      setIsFileUploading = _React$useState2[1];

  var _useField = useField(name),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error,
      helpers = _useField[2];

  var fieldId = getFieldId(name, 'input', idPostfix);
  var isValid = !((touched || filename) && error);

  var getErrorMessage = function getErrorMessage() {
    if (!isValid && error) {
      return getErrorText ? getErrorText(error) : error;
    }

    return '';
  };

  var errorMessage = getErrorMessage();
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: typeof errorMessage === 'string' ? errorMessage : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId,
      isError: true
    }, errorMessage),
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, children, /*#__PURE__*/createElement(FileUpload, {
    id: field.name,
    style: {
      resize: 'vertical'
    },
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    "aria-describedby": fieldId + "-helper",
    type: "text",
    value: field.value,
    filename: filename,
    onChange: function onChange(value, filename) {
      setFilename(filename);
      helpers.setTouched(true);
      helpers.setValue(value);
    },
    onBlur: function onBlur(e) {
      field.onBlur(e);
      _onBlur && _onBlur(e);
    },
    onReadStarted: function onReadStarted() {
      return setIsFileUploading(true);
    },
    onReadFinished: function onReadFinished() {
      return setIsFileUploading(false);
    },
    isLoading: isFileUploading,
    disabled: isDisabled,
    dropzoneProps: _extends({}, dropzoneProps, {
      onDropRejected: (dropzoneProps === null || dropzoneProps === void 0 ? void 0 : dropzoneProps.onDropRejected) && (dropzoneProps === null || dropzoneProps === void 0 ? void 0 : dropzoneProps.onDropRejected(helpers))
    }),
    allowEditingUploadedText: allowEdittingUploadedText
  }));
};

var SwitchField = function SwitchField(_ref) {
  var label = _ref.label,
      helperText = _ref.helperText,
      isRequired = _ref.isRequired,
      _onChange = _ref.onChange,
      onChangeCustomOverride = _ref.onChangeCustomOverride,
      getHelperText = _ref.getHelperText,
      idPostfix = _ref.idPostfix,
      labelIcon = _ref.labelIcon,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "helperText", "isRequired", "onChange", "onChangeCustomOverride", "getHelperText", "idPostfix", "labelIcon"]);

  var _useField = useField(props.name),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error;

  var fieldId = getFieldId(props.name, 'input', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';
  var hText = getHelperText ? getHelperText(field.value) : helperText;
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    helperText: typeof hText === 'string' ? hText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, hText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, /*#__PURE__*/createElement(Switch, _extends({}, field, {
    id: fieldId,
    label: label,
    isDisabled: props.isDisabled,
    isChecked: field.value,
    onChange: function onChange(checked, event) {
      if (onChangeCustomOverride) {
        onChangeCustomOverride(checked, event);
      } else {
        field.onChange(event);
        _onChange && _onChange(checked, event);
      }
    }
  })));
};

var FormikAutoSave = function FormikAutoSave(_ref) {
  var _ref$debounce = _ref.debounce,
      debounce = _ref$debounce === void 0 ? 1000 : _ref$debounce;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values,
      dirty = _useFormikContext.dirty,
      isSubmitting = _useFormikContext.isSubmitting,
      submitForm = _useFormikContext.submitForm;

  var prevValuesRef = React__default.useRef(values);
  var commitRef = React__default.useRef(___default.debounce(submitForm, debounce));
  React__default.useEffect(function () {
    if (!shallowEqual(prevValuesRef.current, values) && dirty && !isSubmitting) {
      commitRef.current();
    }

    if (!isSubmitting) {
      prevValuesRef.current = values;
    }
  }, [values, dirty, isSubmitting]);
  React__default.useEffect(function () {
    var commit = commitRef.current;
    return function () {
      return commit.cancel();
    };
  }, []);
  return null;
};

var PopoverIcon = function PopoverIcon(_ref) {
  var component = _ref.component,
      _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? 'link' : _ref$variant,
      _ref$IconComponent = _ref.IconComponent,
      IconComponent = _ref$IconComponent === void 0 ? OutlinedQuestionCircleIcon : _ref$IconComponent,
      _ref$noVerticalAlign = _ref.noVerticalAlign,
      noVerticalAlign = _ref$noVerticalAlign === void 0 ? false : _ref$noVerticalAlign,
      buttonClassName = _ref.buttonClassName,
      props = _objectWithoutPropertiesLoose(_ref, ["component", "variant", "IconComponent", "noVerticalAlign", "buttonClassName"]);

  return /*#__PURE__*/React__default.createElement(Popover, props, /*#__PURE__*/React__default.createElement(Button, {
    component: component,
    variant: variant,
    onClick: function onClick(e) {
      return e.preventDefault();
    },
    className: classNames('pf-c-form__group-label-help', buttonClassName)
  }, /*#__PURE__*/React__default.createElement(IconComponent, {
    noVerticalAlign: noVerticalAlign
  })));
};

var PullSecretInfo = function PullSecretInfo(_ref) {
  var isOcm = _ref.isOcm;
  return /*#__PURE__*/React__default.createElement(PopoverIcon, {
    noVerticalAlign: true,
    bodyContent: /*#__PURE__*/React__default.createElement(Fragment, null, "Pull secrets are used to download OpenShift Container Platform components and connect clusters to a Red Hat account.\xA0", isOcm ? /*#__PURE__*/React__default.createElement(PullSecretInfoLink, null) : /*#__PURE__*/React__default.createElement(Fragment, null, "Pull secrets can be found in\xA0", /*#__PURE__*/React__default.createElement(ClusterManagerSiteLink, null)))
  });
};

var ClusterManagerSiteLink = function ClusterManagerSiteLink() {
  return /*#__PURE__*/React__default.createElement("a", {
    href: CLUSTER_MANAGER_SITE_LINK,
    target: "_blank",
    rel: "noopener noreferrer"
  }, "OpenShift Cluster Manager ", /*#__PURE__*/React__default.createElement(ExternalLinkAltIcon, null));
};

var PullSecretInfoLink = function PullSecretInfoLink() {
  return /*#__PURE__*/React__default.createElement("a", {
    href: PULL_SECRET_INFO_LINK,
    target: "_blank",
    rel: "noopener noreferrer"
  }, "Learn more about pull secrets ", /*#__PURE__*/React__default.createElement(ExternalLinkAltIcon, null), ".");
};

var getPullSecretHelperText = function getPullSecretHelperText(isOcm) {
  return isOcm ? /*#__PURE__*/React__default.createElement(Fragment, null, "Your Red Hat account's pull secret is used by default.\xA0", /*#__PURE__*/React__default.createElement(PullSecretInfoLink, null)) : /*#__PURE__*/React__default.createElement(Fragment, null, "A Red Hat account's pull secret can be found in \xA0", /*#__PURE__*/React__default.createElement(ClusterManagerSiteLink, null));
};

var PullSecretField = function PullSecretField(_ref2) {
  var isOcm = _ref2.isOcm;
  return /*#__PURE__*/React__default.createElement(TextAreaField, {
    name: "pullSecret",
    label: "Pull secret",
    labelIcon: isOcm ? undefined : /*#__PURE__*/React__default.createElement(PullSecretInfo, {
      isOcm: isOcm
    }),
    getErrorText: function getErrorText(error) {
      return /*#__PURE__*/React__default.createElement(Fragment, null, error, " ", getPullSecretHelperText(isOcm));
    },
    helperText: getPullSecretHelperText(isOcm),
    rows: 10,
    isRequired: true
  });
};

var RadioField = function RadioField(props) {
  var _useField = useField({
    name: props.name,
    value: props.value,
    type: 'radio'
  }),
      field = _useField[0];

  var fieldId = getFieldId(props.name, 'radio', field.value);
  return /*#__PURE__*/React__default.createElement(Radio, _extends({}, field, {
    id: fieldId,
    label: props.label,
    isChecked: !!field.checked,
    isDisabled: props.isDisabled,
    onChange: function onChange(checked, e) {
      props.onChange && props.onChange(checked, e);
      field.onChange(e);
    }
  }));
};

var ACM_ENABLED_FEATURES = {
  ASSISTED_INSTALLER_SNO_FEATURE: true,
  ASSISTED_INSTALLER_OCS_FEATURE: false,
  ASSISTED_INSTALLER_CNV_FEATURE: false,
  ASSISTED_INSTALLER_NETWORK_TYPE_SELECTION_FEATURE: false,
  ASSISTED_INSTALLER_PLATFORM_INTEGRATION_FEATURE: false
};
var SINGLE_CLUSTER_ENABLED_FEATURES = {
  ASSISTED_INSTALLER_SNO_FEATURE: false,
  ASSISTED_INSTALLER_OCS_FEATURE: false,
  ASSISTED_INSTALLER_CNV_FEATURE: false,
  ASSISTED_INSTALLER_NETWORK_TYPE_SELECTION_FEATURE: false,
  ASSISTED_INSTALLER_PLATFORM_INTEGRATION_FEATURE: false
};
var STANDALONE_DEPLOYMENT_ENABLED_FEATURES = {
  ASSISTED_INSTALLER_SNO_FEATURE: true,
  ASSISTED_INSTALLER_OCS_FEATURE: true,
  ASSISTED_INSTALLER_CNV_FEATURE: true,
  ASSISTED_INSTALLER_NETWORK_TYPE_SELECTION_FEATURE: true,
  ASSISTED_INSTALLER_PLATFORM_INTEGRATION_FEATURE: true
};
var FeatureGateContext = React__default.createContext({
  isFeatureEnabled: function isFeatureEnabled() {
    return false;
  }
});
var FeatureGateContextProvider = function FeatureGateContextProvider(_ref) {
  var features = _ref.features,
      children = _ref.children;

  var featuresWithDefaults = _extends({
    ASSISTED_INSTALLER_OCS_FEATURE: false,
    ASSISTED_INSTALLER_CNV_FEATURE: false
  }, features);

  var isFeatureEnabled = function isFeatureEnabled(feature) {
    return !!featuresWithDefaults[feature];
  };

  return /*#__PURE__*/React__default.createElement(FeatureGateContext.Provider, {
    value: {
      isFeatureEnabled: isFeatureEnabled
    }
  }, children);
};
var useFeature = function useFeature(feature) {
  var _React$useContext = React__default.useContext(FeatureGateContext),
      isFeatureEnabled = _React$useContext.isFeatureEnabled;

  return isFeatureEnabled(feature);
};



var index$1 = {
  __proto__: null,
  ACM_ENABLED_FEATURES: ACM_ENABLED_FEATURES,
  SINGLE_CLUSTER_ENABLED_FEATURES: SINGLE_CLUSTER_ENABLED_FEATURES,
  STANDALONE_DEPLOYMENT_ENABLED_FEATURES: STANDALONE_DEPLOYMENT_ENABLED_FEATURES,
  FeatureGateContext: FeatureGateContext,
  FeatureGateContextProvider: FeatureGateContextProvider,
  useFeature: useFeature
};

var DASH = '-';
var OpticalDiskDriveType = 'ODD';

var getHumanizedDateTime = function getHumanizedDateTime(dateTime) {
  if (!dateTime) return DASH;
  var date = new Date(dateTime);
  return date.toLocaleString();
};
var getHumanizedTime = function getHumanizedTime(dateTime) {
  if (!dateTime) return DASH;
  var date = new Date(dateTime);
  return date.toLocaleTimeString();
};

var isSNOSupportedVersionString = function isSNOSupportedVersionString(version) {
  var parsed = parseFloat(version);

  if (isNaN(parsed)) {
    var _version$split;

    parsed = parseFloat(version === null || version === void 0 ? void 0 : (_version$split = version.split('-v')) === null || _version$split === void 0 ? void 0 : _version$split[1]);
  }

  return parsed >= SNO_SUPPORT_MIN_VERSION;
};

var isSNOSupportedVersion = function isSNOSupportedVersion(version) {
  return isSNOSupportedVersionString(version.version);
};

var SingleNodeCheckbox = function SingleNodeCheckbox(_ref) {
  var versions = _ref.versions,
      validate = _ref.validate,
      idPostfix = _ref.idPostfix,
      props = _objectWithoutPropertiesLoose(_ref, ["versions", "validate", "idPostfix"]);

  var isSingleNodeOpenshiftEnabled = useFeature('ASSISTED_INSTALLER_SNO_FEATURE');

  var _useField = useField({
    name: props.name,
    validate: validate
  }),
      field = _useField[0],
      meta = _useField[1],
      helpers = _useField[2];

  var fieldId = getFieldId(props.name, 'input', idPostfix);
  var value = meta.value;
  var setValue = helpers.setValue;
  var isSupportedVersionAvailable = !!versions.find(isSNOSupportedVersion);

  if (isSingleNodeOpenshiftEnabled && isSupportedVersionAvailable) {
    return /*#__PURE__*/createElement(Checkbox, _extends({}, field, props, {
      id: fieldId,
      label: "Install single node OpenShift (SNO)",
      "aria-describedby": fieldId + "-helper",
      description: /*#__PURE__*/createElement(HelperText, {
        fieldId: fieldId
      }, "SNO enables you to install OpenShift using only one host."),
      isChecked: value === 'None',
      onChange: function onChange(checked) {
        return setValue(checked ? 'None' : 'Full');
      }
    }));
  }

  return null;
};

var NumberInputField = forwardRef(function (_ref, ref) {
  var label = _ref.label,
      labelIcon = _ref.labelIcon,
      helperText = _ref.helperText,
      isRequired = _ref.isRequired,
      validate = _ref.validate,
      idPostfix = _ref.idPostfix,
      _ref$minValue = _ref.minValue,
      minValue = _ref$minValue === void 0 ? 0 : _ref$minValue,
      maxValue = _ref.maxValue,
      children = _ref.children,
      formatValue = _ref.formatValue,
      props = _objectWithoutPropertiesLoose(_ref, ["label", "labelIcon", "helperText", "isRequired", "validate", "idPostfix", "minValue", "maxValue", "children", "formatValue"]);

  var _useField = useField({
    name: props.name,
    validate: validate
  }),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error,
      setValue = _useField[2].setValue;

  var fieldId = getFieldId(props.name, 'numberinput', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';

  var doChange = function doChange(value) {
    var newValue = value < minValue ? minValue : value;
    newValue = maxValue && newValue > maxValue ? maxValue : newValue;
    setValue(formatValue ? formatValue(newValue) : newValue);
  };

  var onPlus = function onPlus() {
    doChange(field.value + 1);
  };

  var onMinus = function onMinus() {
    doChange(field.value - 1);
  };

  var handleChange = function handleChange(event) {
    var targetValue = event.target['value'];
    doChange(isNaN(targetValue) ? 0 : Number(targetValue));
  };

  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, /*#__PURE__*/createElement(Split, null, /*#__PURE__*/createElement(SplitItem, {
    isFilled: true
  }, /*#__PURE__*/createElement(NumberInput, _extends({}, props, {
    value: field.value,
    onMinus: onMinus,
    onChange: handleChange,
    onPlus: onPlus,
    min: minValue,
    max: maxValue,
    ref: ref,
    id: fieldId,
    "aria-describedby": fieldId + "-helper"
  }))), /*#__PURE__*/createElement(SplitItem, null, children)));
});

var CodeField = function CodeField(_ref) {
  var label = _ref.label,
      labelIcon = _ref.labelIcon,
      helperText = _ref.helperText,
      isRequired = _ref.isRequired,
      validate = _ref.validate,
      idPostfix = _ref.idPostfix,
      language = _ref.language,
      name = _ref.name,
      description = _ref.description;

  var _useField = useField({
    name: name,
    validate: validate
  }),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error,
      _useField$2 = _useField[2],
      setValue = _useField$2.setValue,
      setTouched = _useField$2.setTouched;

  var fieldId = getFieldId(name, 'input', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, description && /*#__PURE__*/createElement(HelperText, {
    fieldId: fieldId
  }, /*#__PURE__*/createElement(HelperTextItem, {
    variant: "indeterminate"
  }, description)), /*#__PURE__*/createElement(CodeEditor, {
    code: field.value,
    isUploadEnabled: true,
    isDownloadEnabled: true,
    isCopyEnabled: true,
    isLanguageLabelVisible: true,
    height: "400px",
    language: language,
    onChange: function onChange(val) {
      setTouched(true);
      setValue(val, true);
    },
    onEditorDidMount: function onEditorDidMount(editor) {
      setTouched(true);
      setValue(editor.getValue(), true);
    }
  }));
};

var CLUSTER_NAME_REGEX = /^[a-z]([-a-z0-9]*[a-z0-9])?$/;
var SSH_PUBLIC_KEY_REGEX = /^(ssh-rsa|ssh-ed25519|ecdsa-[-a-z0-9]*) AAAA[0-9A-Za-z+/]+[=]{0,3}( .+)?$/;
var IP_ADDRESS_REGEX = /^(((([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]))|([0-9a-f]{1,4}:){7,7}[0-9a-f]{1,4}|([0-9a-f]{1,4}:){1,7}:|([0-9a-f]{1,4}:){1,6}:[0-9a-f]{1,4}|([0-9a-f]{1,4}:){1,5}(:[0-9a-f]{1,4}){1,2}|([0-9a-f]{1,4}:){1,4}(:[0-9a-f]{1,4}){1,3}|([0-9a-f]{1,4}:){1,3}(:[0-9a-f]{1,4}){1,4}|([0-9a-f]{1,4}:){1,2}(:[0-9a-f]{1,4}){1,5}|[0-9a-f]{1,4}:((:[0-9a-f]{1,4}){1,6})|:((:[0-9a-f]{1,4}){1,7}|:)|fe80:(:[0-9a-f]{0,4}){0,4}%[0-9a-z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
var DNS_NAME_REGEX = /^([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,}$/;
var HOSTNAME_REGEX = /^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9-]*[A-Za-z0-9])$/;
var IP_V4_ZERO = '0.0.0.0';
var IP_V6_ZERO = '0000:0000:0000:0000:0000:0000:0000:0000';
var MAC_REGEX = /^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})|([0-9a-fA-F]{4}\\.[0-9a-fA-F]{4}\\.[0-9a-fA-F]{4})$”/;
var nameValidationSchema = function nameValidationSchema(usedClusterNames, baseDnsDomain) {
  if (baseDnsDomain === void 0) {
    baseDnsDomain = '';
  }

  return string().matches(CLUSTER_NAME_REGEX, {
    message: 'Name must consist of lower-case letters, numbers and hyphens. It must start with a letter and end with a letter or number.',
    excludeEmptyString: true
  }).max(54, 'Cannot be longer than 54 characters.').required('Required').when('useRedHatDnsService', {
    is: true,
    then: string().test('is-name-unique', 'The name is already taken.', function (value) {
      var clusterFullName = value + "." + baseDnsDomain;
      return !value || !usedClusterNames.includes(clusterFullName);
    })
  });
};
var sshPublicKeyValidationSchema = string().test('ssh-public-key', 'SSH public key must consist of "[TYPE] key [[EMAIL]]", supported types are: ssh-rsa, ssh-ed25519, ecdsa-[VARIANT]. A single key can be provided only.', function (value) {
  if (!value) {
    return true;
  }

  return !!trimSshPublicKey(value).match(SSH_PUBLIC_KEY_REGEX);
});
var pullSecretValidationSchema = string().test('is-well-formed-json', 'The pull-secret format is malformed, refer to the documentation for examples.', function (value) {
  var isValid = true;
  if (!value) return isValid;

  try {
    JSON.parse(value);
    return isValid;
  } catch (_unused) {
    return !isValid;
  }
}).test('is-valid-pull-secret', 'The pull-secret format is invalid, refer to the documentation for examples.', function (value) {
  if (!value) return true;

  try {
    var pullSecret = JSON.parse(value);
    return pullSecret.constructor.name === 'Object' && !!(pullSecret === null || pullSecret === void 0 ? void 0 : pullSecret.auths) && pullSecret.auths.constructor.name === 'Object';
  } catch (_unused2) {
    return false;
  }
});
var ipValidationSchema = string().matches(IP_ADDRESS_REGEX, {
  message: 'Value "${value}" is not valid IP address.',
  excludeEmptyString: true
});
var macAddressValidationSchema = string().matches(MAC_REGEX, {
  message: 'Value "${value}" is not valid MAC address.',
  excludeEmptyString: true
});
var vipRangeValidationSchema = function vipRangeValidationSchema(hostSubnets, _ref) {
  var hostSubnet = _ref.hostSubnet;
  return string().test('vip-validation', 'IP Address is outside of selected subnet', function (value) {
    if (!value) {
      return true;
    }

    try {
      ipValidationSchema.validateSync(value);
    } catch (err) {
      return this.createError({
        message: err.message
      });
    }

    var foundHostSubnet = hostSubnets.find(function (hn) {
      return hn.subnet === hostSubnet;
    });

    if (foundHostSubnet === null || foundHostSubnet === void 0 ? void 0 : foundHostSubnet.subnet) {
      return foundHostSubnet.hostIDs.length ? isInSubnet(value, foundHostSubnet.subnet) : true;
    }

    return false;
  });
};

var vipUniqueValidationSchema = function vipUniqueValidationSchema(_ref2) {
  var ingressVip = _ref2.ingressVip,
      apiVip = _ref2.apiVip;
  return string().test('vip-uniqueness-validation', 'The Ingress and API Virtual IP addresses cannot be the same.', function (value) {
    if (!value) {
      return true;
    }

    return ingressVip !== apiVip;
  });
};

var requiredOnceSet = function requiredOnceSet(initialValue, message) {
  return string().test('required-once-set', message || 'The value is required.', function (value) {
    return value || !initialValue;
  });
};

var stringToIPAddress = function stringToIPAddress(value) {
  var ip = null;

  if (Address4.isValid(value)) {
    ip = new Address4(value);
  } else if (Address6.isValid(value)) {
    ip = new Address6(value);
  }

  return ip;
};

var vipValidationSchema = function vipValidationSchema(hostSubnets, values, initialValue) {
  return mixed().when(['vipDhcpAllocation', 'managedNetworkingType'], {
    is: function is(vipDhcpAllocation, managedNetworkingType) {
      return !vipDhcpAllocation && managedNetworkingType !== 'userManaged';
    },
    then: requiredOnceSet(initialValue).concat(vipRangeValidationSchema(hostSubnets, values)).concat(vipUniqueValidationSchema(values)).when('hostSubnet', {
      is: function is(hostSubnet) {
        return hostSubnet !== NO_SUBNET_SET;
      },
      then: string().required('Required. Please provide an IP address')
    })
  });
};
var ipBlockValidationSchema = string().required('A value is required.').test('valid-ip-address', 'Invalid IP address block. Expected value is a network expressed in CIDR notation (IP/netmask). For example: 123.123.123.0/24, 2055:d7a::/116', function (value) {
  if (value === void 0) {
    value = '';
  }

  return isCIDR.v4(value) || isCIDR.v6(value);
}).test('valid-netmask', 'IPv4 netmask must be between 1-25 and include at least 128 addresses.\nIPv6 netmask must be between 8-128 and include at least 256 addresses.', function (value) {
  if (value === void 0) {
    value = '';
  }

  var suffix = parseInt(value.split('/')[1]);
  return isCIDR.v4(value) && 0 < suffix && suffix < 26 || isCIDR.v6(value) && 7 < suffix && suffix < 129;
}).test('cidr-is-not-unspecified', 'The specified CIDR is invalid because its resulting routing prefix matches the unspecified address.', function (value) {
  if (value === void 0) {
    value = '';
  }

  var ip = stringToIPAddress(value);

  if (ip === null) {
    return false;
  }

  var startAddress = ip.startAddress().address;
  return startAddress !== IP_V4_ZERO && startAddress !== IP_V6_ZERO;
}).test('valid-cidr-base-address', function (_ref3) {
  var value = _ref3.value;
  return value + " is not a valid CIDR";
}, function (value) {
  if (value === void 0) {
    value = '';
  }

  var ip = stringToIPAddress(value);

  if (ip === null) {
    return false;
  }

  var networkAddress = ip.startAddress().parsedAddress;
  var ipAddress = ip.parsedAddress;
  var result = ipAddress.every(function (part, idx) {
    return part === networkAddress[idx];
  });
  return result;
});
var dnsNameValidationSchema = string().test('dns-name-label-length', 'Single label of the DNS name can not be longer than 63 characters.', function (value) {
  if (value === void 0) {
    value = '';
  }

  return value.split('.').every(function (label) {
    return label.length <= 63;
  });
}).matches(DNS_NAME_REGEX, {
  message: 'Value "${value}" is not valid DNS name. Example: basedomain.example.com'
});
var hostPrefixValidationSchema = function hostPrefixValidationSchema(_ref4) {
  var clusterNetworkCidr = _ref4.clusterNetworkCidr;
  var requiredText = 'The host prefix is required.';
  var minMaxText = 'The host prefix is a number between 1 and 32 for IPv4 and between 8 and 128 for IPv6.';
  var netBlock = (clusterNetworkCidr || '').split('/')[1];

  if (!netBlock) {
    return number().required(requiredText).min(1, minMaxText).max(32, minMaxText);
  }

  var netBlockNumber = parseInt(netBlock);

  if (isNaN(netBlockNumber)) {
    netBlockNumber = 1;
  }

  var errorMsgPrefix = 'The host prefix is a number between size of the cluster network CIDR range';
  var errorMsgIPv4 = errorMsgPrefix + " (" + netBlockNumber + ") and 25.";
  var errorMsgIPv6 = errorMsgPrefix + " (8) and 128.";

  if (Address6.isValid(clusterNetworkCidr || '')) {
    return number().required(requiredText).min(8, errorMsgIPv6).max(128, errorMsgIPv6);
  }

  if (Address4.isValid(clusterNetworkCidr || '')) {
    return number().required(requiredText).min(netBlockNumber, errorMsgIPv4).max(25, errorMsgIPv4);
  }

  return number().required(requiredText);
};
var hostnameValidationSchema = string().max(63, 'The hostname can not be longer than 63 characters.').matches(HOSTNAME_REGEX, {
  message: 'Value "${value}" is not valid hostname.',
  excludeEmptyString: true
});
var uniqueHostnameValidationSchema = function uniqueHostnameValidationSchema(origHostname, usedHostnames) {
  return string().test('unique-hostname-validation', 'Hostname must be unique.', function (value) {
    if (!value || value === origHostname) {
      return true;
    }

    return !usedHostnames.find(function (h) {
      return h === value;
    });
  });
};
var httpProxyValidationMessage = 'Provide a valid HTTP URL.';
var httpProxyValidationSchema = function httpProxyValidationSchema(values, pairValueName) {
  return string().test('http-proxy-no-empty-validation', 'At least one of the HTTP or HTTPS proxy URLs is required.', function (value) {
    return !values.enableProxy || value || values[pairValueName];
  }).test('http-proxy-validation', httpProxyValidationMessage, function (value) {
    if (!value) {
      return true;
    }

    try {
      var url = new URL(value);
      return url.protocol === 'http:';
    } catch (_unused3) {
      return false;
    }
  });
};
var noProxyValidationSchema = string().test('no-proxy-validation', 'Provide comma-separated list of domains excluded from proxy.', function (value) {
  if (!value) {
    return true;
  }

  return trimCommaSeparatedList(value).split(',').every(function (item) {
    if (item === '*') {
      return true;
    }

    var domain = item;

    if (item.charAt(0) === '.') {
      domain = item.substr(1);
    }

    if (domain.match(DNS_NAME_REGEX)) {
      return true;
    }

    if (Address4.isValid(item)) {
      return true;
    }

    if (Address6.isValid(item)) {
      return true;
    }

    return false;
  });
});

var isIPorDN = function isIPorDN(value) {
  if (!value) {
    return true;
  }

  if (value.match(DNS_NAME_REGEX)) {
    return true;
  }

  if (value.match(IP_ADDRESS_REGEX)) {
    return true;
  }

  return false;
};

var ntpSourceValidationSchema = string().test('ntp-source-validation', 'Provide a comma separated list of valid DNS names or IP addresses.', function (value) {
  if (!value) {
    return true;
  }

  return trimCommaSeparatedList(value).split(',').every(isIPorDN);
});

var LabelValue = function LabelValue(_ref) {
  var value = _ref.value,
      onClose = _ref.onClose;
  return /*#__PURE__*/createElement(Label, {
    className: "label-field__value",
    variant: "outline",
    onClose: onClose
  }, value);
};
var LabelField = function LabelField(_ref2) {
  var _field$value, _ref4;

  var label = _ref2.label,
      labelIcon = _ref2.labelIcon,
      helperText = _ref2.helperText,
      isRequired = _ref2.isRequired,
      _onChange = _ref2.onChange,
      validate = _ref2.validate,
      idPostfix = _ref2.idPostfix,
      props = _objectWithoutPropertiesLoose(_ref2, ["label", "labelIcon", "helperText", "isRequired", "onChange", "validate", "idPostfix"]);

  var _React$useState = useState(''),
      input = _React$useState[0],
      setInput = _React$useState[1];

  var _useField = useField({
    name: props.name,
    validate: validate
  }),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error,
      _useField$2 = _useField[2],
      setValue = _useField$2.setValue,
      setTouched = _useField$2.setTouched;

  var fieldId = getFieldId(props.name, 'input', idPostfix);
  var isValid = !(touched && error);
  var errorMessage = !isValid ? error : '';
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: errorMessage,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired,
    labelIcon: labelIcon
  }, "Enter key=value and then press 'enter' or 'space' or use a ',' to input the label.", /*#__PURE__*/createElement("div", {
    className: "co-search-input pf-c-form-control"
  }, /*#__PURE__*/createElement(TagsInput, _extends({}, field, {
    onChange: function onChange(tags) {
      setValue(tags);
      setInput('');
      _onChange && _onChange(tags);
      !touched && setTouched(true);
    },
    addKeys: [13, 32, 188],
    renderTag: function renderTag(_ref3) {
      var tag = _ref3.tag,
          key = _ref3.key,
          onRemove = _ref3.onRemove,
          getTagDisplayValue = _ref3.getTagDisplayValue;
      return /*#__PURE__*/createElement(LabelValue, {
        key: key,
        onClose: function onClose() {
          return onRemove(key);
        },
        value: getTagDisplayValue(tag)
      });
    },
    addOnBlur: true,
    inputProps: (_ref4 = {
      autoFocus: false,
      className: 'label-field__input',
      placeholder: ((_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.length) ? '' : 'app=frontend',
      spellCheck: 'false',
      id: 'tags-input',
      value: input,
      onChange: function onChange(e) {
        return setInput(e.target.value);
      }
    }, _ref4['data-test'] = 'tags-input', _ref4)
  }))));
};

var EmptyState = function EmptyState(_ref) {
  var _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'No results found' : _ref$title,
      content = _ref.content,
      _ref$icon = _ref.icon,
      icon = _ref$icon === void 0 ? SearchIcon : _ref$icon,
      primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions;
  return /*#__PURE__*/React__default.createElement(Bullseye, null, /*#__PURE__*/React__default.createElement(EmptyState$1, null, /*#__PURE__*/React__default.createElement(EmptyStateIcon, {
    icon: icon
  }), /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h2"
  }, title), content && /*#__PURE__*/React__default.createElement(EmptyStateBody, null, content), primaryAction, secondaryActions && /*#__PURE__*/React__default.createElement(EmptyStateSecondaryActions, null, secondaryActions)));
};

var ErrorState = function ErrorState(_ref) {
  var _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'Error loading data' : _ref$title,
      content = _ref.content,
      fetchData = _ref.fetchData,
      _ref$icon = _ref.icon,
      icon = _ref$icon === void 0 ? ExclamationCircleIcon : _ref$icon,
      _ref$iconColor = _ref.iconColor,
      iconColor = _ref$iconColor === void 0 ? global_danger_color_200.value : _ref$iconColor,
      _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? EmptyStateVariant.small : _ref$variant,
      primaryAction = _ref.primaryAction,
      actions = _ref.actions;
  var defaultContent = /*#__PURE__*/React__default.createElement(Fragment, null, "There was an error retrieving data. Check your connection and", ' ', fetchData ? /*#__PURE__*/React__default.createElement(Button, {
    onClick: fetchData,
    variant: ButtonVariant.link,
    isInline: true
  }, "try again") : 'try again', ".");
  return /*#__PURE__*/React__default.createElement(Bullseye, null, /*#__PURE__*/React__default.createElement(EmptyState$1, {
    variant: variant
  }, /*#__PURE__*/React__default.createElement(EmptyStateIcon, {
    icon: icon,
    color: iconColor
  }), /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h2"
  }, title), /*#__PURE__*/React__default.createElement(EmptyStateBody, null, content || defaultContent), primaryAction, actions && /*#__PURE__*/React__default.createElement(EmptyStateSecondaryActions, null, actions)));
};

var LoadingState = function LoadingState(_ref) {
  var content = _ref.content,
      primaryAction = _ref.primaryAction,
      secondaryActions = _ref.secondaryActions;
  return /*#__PURE__*/React__default.createElement(Bullseye, null, /*#__PURE__*/React__default.createElement(EmptyState$1, {
    variant: EmptyStateVariant.small
  }, /*#__PURE__*/React__default.createElement(Spinner, {
    size: "xl"
  }), content && /*#__PURE__*/React__default.createElement(EmptyStateBody, null, content), primaryAction, secondaryActions && /*#__PURE__*/React__default.createElement(EmptyStateSecondaryActions, null, secondaryActions)));
};

var ToolbarButton = function ToolbarButton(_ref) {
  var props = _extends({}, _ref);

  return /*#__PURE__*/React__default.createElement(ToolbarItem, null, /*#__PURE__*/React__default.createElement(Button, props));
};

var ToolbarText = function ToolbarText(props) {
  return /*#__PURE__*/React__default.createElement(ToolbarItem, null, /*#__PURE__*/React__default.createElement(Text, props));
};

var ToolbarProgress = function ToolbarProgress(_ref) {
  var style = _ref.style,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? ProgressSize.sm : _ref$size;
  return /*#__PURE__*/React__default.createElement(ToolbarGroup, {
    style: {
      flexGrow: 1
    }
  }, /*#__PURE__*/React__default.createElement(ToolbarItem, {
    style: {
      flexGrow: 1
    }
  }, /*#__PURE__*/React__default.createElement(Progress, {
    style: _extends({}, style, {
      gridGap: 0
    }),
    size: size
  })));
};

var ToolbarSecondaryGroup = function ToolbarSecondaryGroup(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React__default.createElement(ToolbarGroup, {
    alignment: {
      md: 'alignRight'
    }
  }, children);
};

var StaticField = function StaticField(_ref) {
  var label = _ref.label,
      name = _ref.name,
      children = _ref.children,
      helperText = _ref.helperText,
      helperTextInvalid = _ref.helperTextInvalid,
      isRequired = _ref.isRequired,
      _ref$isValid = _ref.isValid,
      isValid = _ref$isValid === void 0 ? true : _ref$isValid;
  var fieldId = getFieldId(name, 'static');
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label,
    helperText: typeof helperText === 'string' ? helperText : /*#__PURE__*/createElement(HelperText, {
      fieldId: fieldId
    }, helperText),
    helperTextInvalid: helperTextInvalid,
    validated: isValid ? 'default' : 'error',
    isRequired: isRequired
  }, children);
};
var FormikStaticField = function FormikStaticField(_ref2) {
  var value = _ref2.value,
      props = _objectWithoutPropertiesLoose(_ref2, ["value"]);

  var _useField = useField({
    name: props.name
  }),
      helpers = _useField[2];

  useEffect(function () {
    helpers.setValue(value);
  }, [value]);
  return /*#__PURE__*/createElement(StaticField, props);
};
var StaticTextField = function StaticTextField(_ref3) {
  var children = _ref3.children,
      props = _objectWithoutPropertiesLoose(_ref3, ["children"]);

  var fieldId = getFieldId(props.name, 'static');
  return /*#__PURE__*/createElement(StaticField, props, /*#__PURE__*/createElement(TextContent, null, /*#__PURE__*/createElement(Text, {
    component: "p",
    id: fieldId,
    "aria-describedby": fieldId + "-helper"
  }, children)));
};

var WizardFooter = function WizardFooter(_ref) {
  var alerts = _ref.alerts,
      errors = _ref.errors,
      onNext = _ref.onNext,
      onBack = _ref.onBack,
      onCancel = _ref.onCancel,
      isNextDisabled = _ref.isNextDisabled,
      isBackDisabled = _ref.isBackDisabled,
      leftExtraActions = _ref.leftExtraActions,
      isSubmitting = _ref.isSubmitting,
      submittingText = _ref.submittingText,
      nextButtonText = _ref.nextButtonText;

  var _useTranslation = useTranslation(),
      t = _useTranslation.t;

  submittingText = submittingText || t('Saving changes...');
  return /*#__PURE__*/createElement(Stack, {
    hasGutter: true
  }, alerts && /*#__PURE__*/createElement(StackItem, null, alerts), errors && /*#__PURE__*/createElement(StackItem, null, errors), /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Toolbar, {
    "data-testid": "wizard-step-actions"
  }, /*#__PURE__*/createElement(ToolbarContent, null, leftExtraActions, onNext && /*#__PURE__*/createElement(ToolbarButton, {
    variant: ButtonVariant.primary,
    name: "next",
    onClick: onNext,
    isDisabled: isNextDisabled
  }, nextButtonText || t('Next')), onBack && /*#__PURE__*/createElement(ToolbarButton, {
    variant: ButtonVariant.secondary,
    name: "back",
    onClick: onBack,
    isDisabled: isBackDisabled
  }, t('Back')), /*#__PURE__*/createElement(ToolbarButton, {
    variant: ButtonVariant.link,
    name: "cancel",
    onClick: onCancel,
    isDisabled: false
  }, t('Cancel')), isSubmitting && /*#__PURE__*/createElement(ToolbarItem, null, /*#__PURE__*/createElement(Text, {
    component: TextVariants.small
  }, /*#__PURE__*/createElement(Spinner, {
    size: "sm"
  }), " ", submittingText))))));
};

var sortable = function sortable(label, extra) {
  var columnIndex = extra.columnIndex,
      column = extra.column,
      property = extra.property;
  var _column$extraParams = column.extraParams,
      sortBy = _column$extraParams.sortBy,
      onSort = _column$extraParams.onSort;
  var extraData = {
    columnIndex: columnIndex,
    column: column,
    property: property
  };
  var isSortedBy = sortBy && columnIndex === sortBy.index;

  function sortClicked(event) {
    var reversedDirection;

    if (!isSortedBy) {
      reversedDirection = SortByDirection.asc;
    } else {
      reversedDirection = (sortBy === null || sortBy === void 0 ? void 0 : sortBy.direction) === SortByDirection.asc ? SortByDirection.desc : SortByDirection.asc;
    }

    onSort && onSort(event, columnIndex, reversedDirection, extraData);
  }

  return {
    className: css('pf-c-table__sort', isSortedBy && 'pf-m-selected'),
    'aria-sort': isSortedBy ? (sortBy === null || sortBy === void 0 ? void 0 : sortBy.direction) + "ending" : 'none',
    children: /*#__PURE__*/createElement(SortColumn, {
      isSortedBy: isSortedBy,
      sortDirection: isSortedBy ? sortBy === null || sortBy === void 0 ? void 0 : sortBy.direction : '',
      onSort: sortClicked,
      type: "button"
    }, label)
  };
};

var getColSpanRow = function getColSpanRow(content, columnCount) {
  return [{
    heightAuto: true,
    cells: [{
      props: {
        colSpan: columnCount
      },
      title: content
    }]
  }];
};
var rowSorter = function rowSorter(sortBy, getCell) {
  return function (a, b) {
    var coefficient = sortBy.direction === SortByDirection.asc ? 1 : -1;
    var cellA = getCell(a, sortBy.index);
    var cellB = getCell(b, sortBy.index);
    var valA = typeof cellA === 'string' ? cellA : cellA === null || cellA === void 0 ? void 0 : cellA.sortableValue;
    var valB = typeof cellB === 'string' ? cellB : cellB === null || cellB === void 0 ? void 0 : cellB.sortableValue;

    if (typeof valA === 'string' || typeof valB === 'string') {
      valA = valA || '';
      return valA.localeCompare(valB) * coefficient;
    }

    valA = valA || 0;
    valB = valB || 0;
    return (valA - valB) * coefficient;
  };
};
var toSentence = function toSentence(s) {
  return "" + ___default.upperFirst(s) + (___default.endsWith(s, '.') || s === '' ? '' : '.');
};
var getDateTimeCell = function getDateTimeCell(time) {
  var date = getHumanizedDateTime(time);
  return {
    title: date,
    sortableValue: time ? new Date(time).getTime() : 0
  };
};

var breakWord = function breakWord() {
  return {
    className: 'pf-m-break-word'
  };
};
var fitContent = function fitContent() {
  return {
    className: 'pf-m-fit-content'
  };
};
var nowrap = function nowrap() {
  return {
    className: 'pf-m-nowrap'
  };
};
var truncate = function truncate() {
  return {
    className: 'pf-m-truncate'
  };
};
var wrappable = function wrappable() {
  return {
    className: 'pf-m-wrap'
  };
};
var noPadding = function noPadding() {
  return {
    className: 'table-no-padding'
  };
};

var RenderIf = function RenderIf(_ref) {
  var _ref$condition = _ref.condition,
      condition = _ref$condition === void 0 ? false : _ref$condition,
      children = _ref.children;
  return condition ? /*#__PURE__*/React__default.createElement(Fragment, null, children) : null;
};

var SimpleDropdown = function SimpleDropdown(_ref) {
  var current = _ref.current,
      defaultValue = _ref.defaultValue,
      items = _ref.items,
      setValue = _ref.setValue,
      isDisabled = _ref.isDisabled,
      idPrefix = _ref.idPrefix;

  var _React$useState = React__default.useState(false),
      isOpen = _React$useState[0],
      setOpen = _React$useState[1];

  var dropdownItems = items.map(function (_ref2) {
    var value = _ref2.value,
        label = _ref2.label,
        description = _ref2.description;
    return /*#__PURE__*/React__default.createElement(DropdownItem, {
      key: value,
      id: value,
      description: description
    }, label);
  });
  var onSelect = React__default.useCallback(function (event) {
    setValue(event === null || event === void 0 ? void 0 : event.currentTarget.id);
    setOpen(false);
  }, [setValue, setOpen]);
  var toggle = React__default.useMemo(function () {
    return /*#__PURE__*/React__default.createElement(DropdownToggle, {
      onToggle: function onToggle(val) {
        return setOpen(!isDisabled && val);
      },
      toggleIndicator: CaretDownIcon,
      isDisabled: isDisabled,
      id: idPrefix ? idPrefix + "-dropdown-toggle-items" : undefined
    }, current || defaultValue);
  }, [setOpen, current, isDisabled, defaultValue, idPrefix]);
  return /*#__PURE__*/React__default.createElement(Dropdown, {
    onSelect: onSelect,
    dropdownItems: dropdownItems,
    toggle: toggle,
    isOpen: isOpen,
    isPlain: true,
    id: idPrefix ? idPrefix + "-dropdown-toggle" : undefined
  });
};

var DetailList = function DetailList(_ref) {
  var children = _ref.children,
      title = _ref.title,
      _ref$titleComponent = _ref.titleComponent,
      titleComponent = _ref$titleComponent === void 0 ? 'h2' : _ref$titleComponent;
  return /*#__PURE__*/React__default.createElement(TextContent, null, title && /*#__PURE__*/React__default.createElement(Text, {
    component: titleComponent
  }, title), /*#__PURE__*/React__default.createElement(TextList, {
    component: TextListVariants.dl,
    className: "detail-list"
  }, children));
};
var DetailItem = function DetailItem(_ref2) {
  var title = _ref2.title,
      _ref2$value = _ref2.value,
      value = _ref2$value === void 0 ? '' : _ref2$value,
      idPrefix = _ref2.idPrefix,
      testId = _ref2.testId,
      _ref2$isHidden = _ref2.isHidden,
      isHidden = _ref2$isHidden === void 0 ? false : _ref2$isHidden,
      classNameValue = _ref2.classNameValue;
  return isHidden ? null : /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(TextListItem, {
    component: TextListItemVariants.dt,
    id: idPrefix ? idPrefix + "-title" : undefined,
    "data-testid": testId ? testId + "-title" : undefined
  }, title), /*#__PURE__*/React__default.createElement(TextListItem, {
    component: TextListItemVariants.dd,
    id: idPrefix ? idPrefix + "-value" : undefined,
    "data-testid": testId ? testId + "-value" : undefined,
    className: classNameValue
  }, Array.isArray(value) ? /*#__PURE__*/React__default.createElement(TextList, {
    component: TextListVariants.dl
  }, value.map(function (item, idx) {
    return [/*#__PURE__*/React__default.createElement(TextListItem, {
      "data-testid": testId ? testId + "-title-" + idx : undefined,
      key: item.title,
      component: TextListItemVariants.dt
    }, item.title), /*#__PURE__*/React__default.createElement(TextListItem, {
      "data-testid": testId ? testId + "-value-" + idx : undefined,
      key: "dd-" + item.title,
      component: TextListItemVariants.dd
    }, item.value)];
  })) : value));
};

var getEventRowKey = function getEventRowKey(_ref) {
  var _rowData$props, _rowData$props2;

  var rowData = _ref.rowData;
  return (rowData === null || rowData === void 0 ? void 0 : (_rowData$props = rowData.props) === null || _rowData$props === void 0 ? void 0 : _rowData$props.event.sortableTime) + (rowData === null || rowData === void 0 ? void 0 : (_rowData$props2 = rowData.props) === null || _rowData$props2 === void 0 ? void 0 : _rowData$props2.event.message);
};

var getLabelColor = function getLabelColor(severity) {
  switch (severity) {
    case 'info':
      return 'blue';

    case 'warning':
      return 'orange';

    case 'error':
      return 'red';

    case 'critical':
      return 'purple';
  }
};

var getLabelIcon = function getLabelIcon(severity) {
  switch (severity) {
    case 'info':
      return /*#__PURE__*/React__default.createElement(InfoCircleIcon, null);

    case 'warning':
      return /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, null);

    case 'error':
    case 'critical':
      return /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, null);
  }
};

var EventsList = function EventsList(_ref2) {
  var events = _ref2.events,
      className = _ref2.className;

  if (events.length === 0) {
    return /*#__PURE__*/React__default.createElement(EmptyState, {
      icon: SearchIcon,
      title: "No events found",
      content: "There are no events found."
    });
  }

  var sortedEvents = events.map(function (event) {
    return _extends({}, event, {
      sortableTime: new Date(event.eventTime).getTime()
    });
  }).sort(function (a, b) {
    return b.sortableTime - a.sortableTime;
  });
  var rows = sortedEvents.map(function (event) {
    return {
      cells: [{
        title: /*#__PURE__*/React__default.createElement("strong", null, getHumanizedDateTime(event.eventTime))
      }, {
        title: /*#__PURE__*/React__default.createElement(Fragment, null, event.severity !== 'info' && /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Label, {
          color: getLabelColor(event.severity),
          icon: getLabelIcon(event.severity)
        }, event.severity), ' '), event.message)
      }],
      props: {
        event: event
      }
    };
  });
  return /*#__PURE__*/React__default.createElement("div", {
    className: className
  }, /*#__PURE__*/React__default.createElement(Table, {
    rows: rows,
    cells: [{
      title: 'Time',
      cellTransforms: [fitContent, noPadding]
    }, {
      title: 'Message',
      cellTransforms: [breakWord$1]
    }],
    variant: TableVariant.compact,
    "aria-label": "Events table",
    borders: false
  }, /*#__PURE__*/React__default.createElement(TableBody, {
    rowKey: getEventRowKey
  })));
};

var stringToJSON = function stringToJSON(jsonString) {
  var jsObject;

  if (jsonString) {
    try {
      var camelCased = jsonString.replace(/"([\w-]+)":/g, function (_match, offset) {
        return "\"" + ___default.camelCase(offset) + "\":";
      });
      jsObject = JSON.parse(camelCased);
    } catch (e) {
      console.error('Failed to parse api string', e, jsonString);
    }
  } else {
    console.info('Empty api string received.');
  }

  return jsObject;
};
var removeProtocolFromURL = function removeProtocolFromURL(url) {
  if (url === void 0) {
    url = '';
  }

  return url.replace(/^(http|https):\/\//, '');
};

var Placeholder = function Placeholder(_ref) {
  var text = _ref.text;
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(FilterIcon, null), " ", text);
};

var SELECT_ALL = 'select-all-actions';
var CLUSTER_LEVEL = 'cluster-level-action';
var ORPHANS = 'deleted-hosts-action';

var mapHosts = function mapHosts(hosts) {
  return (hosts || []).map(function (host) {
    var inventory = stringToJSON(host.inventory) || {};
    var hostname = host.requestedHostname;

    if (inventory.hostname !== host.requestedHostname) {
      hostname += " (" + inventory.hostname + ")";
    }

    return {
      hostname: hostname,
      id: host.id
    };
  });
};

var getInitialClusterEventsFilters = function getInitialClusterEventsFilters(cluster) {
  return {
    fulltext: '',
    hosts: mapHosts(cluster.hosts).map(function (host) {
      return host.id;
    }),
    severity: [],
    clusterLevel: true,
    orphanedHosts: true,
    selectAll: true
  };
};

var getEventsCount = function getEventsCount(severity, events) {
  return events.filter(function (event) {
    return event.severity === severity;
  }).length;
};

var ClusterEventsToolbar = function ClusterEventsToolbar(_ref2) {
  var _filters$hosts;

  var filters = _ref2.filters,
      setFilters = _ref2.setFilters,
      cluster = _ref2.cluster,
      events = _ref2.events;

  var _React$useState = React__default.useState(false),
      isHostExpanded = _React$useState[0],
      setHostExpanded = _React$useState[1];

  var _React$useState2 = React__default.useState(false),
      isSeverityExpanded = _React$useState2[0],
      setSeverityExpanded = _React$useState2[1];

  var allHosts = React__default.useMemo(function () {
    return mapHosts(cluster.hosts);
  }, [cluster.hosts]);

  var onClearAllFilters = function onClearAllFilters() {
    setFilters(getInitialClusterEventsFilters(cluster));
  };

  var onSelect = function onSelect(type, isChecked, value) {
    var _cluster$hosts;

    var setNextSelectedValues = function setNextSelectedValues(type, isChecked, value, filters) {
      var _extends2;

      return _extends({}, filters, (_extends2 = {}, _extends2[type] = isChecked ? [].concat(filters[type], [value]) : filters[type].filter(function (val) {
        return val !== value;
      }), _extends2));
    };

    var setNextSelectAllValue = function setNextSelectAllValue(totalHostsInCluster, filters) {
      return _extends({}, filters, {
        selectAll: type === 'severity' ? filters.selectAll : filters.hosts.length === totalHostsInCluster && filters.orphanedHosts && filters.clusterLevel
      });
    };

    var nextFilters = setNextSelectedValues(type, isChecked, value, filters);
    nextFilters = setNextSelectAllValue(((_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.length) || 0, nextFilters);
    setFilters(nextFilters);
  };

  var onHostToggle = function onHostToggle() {
    return setHostExpanded(!isHostExpanded);
  };

  var onHostSelect = function onHostSelect(event, value) {
    var _cluster$hosts2, _cluster$hosts3;

    var isChecked = event.target.checked;

    switch (value) {
      case SELECT_ALL:
        if (isChecked) {
          setFilters(_extends({}, filters, {
            hosts: mapHosts(cluster.hosts).map(function (host) {
              return host.id;
            }),
            clusterLevel: true,
            orphanedHosts: true,
            selectAll: true
          }));
        } else {
          setFilters(_extends({}, filters, {
            clusterLevel: false,
            orphanedHosts: false,
            selectAll: false,
            hosts: []
          }));
        }

        break;

      case ORPHANS:
        setFilters(_extends({}, filters, {
          orphanedHosts: isChecked,
          selectAll: isChecked && filters.clusterLevel && filters.hosts.length === ((_cluster$hosts2 = cluster.hosts) === null || _cluster$hosts2 === void 0 ? void 0 : _cluster$hosts2.length)
        }));
        break;

      case CLUSTER_LEVEL:
        setFilters(_extends({}, filters, {
          clusterLevel: isChecked,
          selectAll: isChecked && filters.orphanedHosts && filters.hosts.length === ((_cluster$hosts3 = cluster.hosts) === null || _cluster$hosts3 === void 0 ? void 0 : _cluster$hosts3.length)
        }));
        break;

      default:
        onSelect('hosts', isChecked, value);
    }
  };

  var onSeverityToggle = function onSeverityToggle() {
    return setSeverityExpanded(!isSeverityExpanded);
  };

  var onSeveritySelect = function onSeveritySelect(event, value) {
    onSelect('severity', event.target.checked, value);
  };

  var onFulltextChange = function onFulltextChange(fulltext) {
    setFilters(_extends({}, filters, {
      fulltext: fulltext
    }));
  };

  var onDeleteChip = function onDeleteChip(type, chip) {
    if (type) {
      var _extends3;

      var id = chip['key'] || chip;
      setFilters(_extends({}, filters, (_extends3 = {}, _extends3[type] = filters[type].filter(function (v) {
        return v !== id;
      }), _extends3)));
    } else {
      onClearAllFilters();
    }
  };

  var onDeleteChipGroup = function onDeleteChipGroup(type) {
    var _extends4;

    setFilters(_extends({}, filters, (_extends4 = {}, _extends4[type] = [], _extends4)));
  };

  var getSelections = function getSelections() {
    var selections = filters.clusterLevel ? [].concat(filters.hosts, [CLUSTER_LEVEL]) : filters.hosts;
    selections = filters.orphanedHosts ? [].concat(selections, [ORPHANS]) : selections;
    selections = filters.selectAll ? [].concat(selections, [SELECT_ALL]) : selections;
    return selections;
  };

  return /*#__PURE__*/React__default.createElement(Toolbar, {
    id: "clusters-events-toolbar",
    className: "pf-m-toggle-group-container",
    collapseListedFiltersBreakpoint: "xl",
    clearAllFilters: onClearAllFilters
  }, /*#__PURE__*/React__default.createElement(ToolbarContent, null, /*#__PURE__*/React__default.createElement(ToolbarFilter, {
    categoryName: "hosts"
  }, /*#__PURE__*/React__default.createElement(Select, {
    variant: "checkbox",
    "aria-label": "hosts",
    onToggle: onHostToggle,
    onSelect: onHostSelect,
    selections: getSelections(),
    customBadgeText: ((_filters$hosts = filters.hosts) === null || _filters$hosts === void 0 ? void 0 : _filters$hosts.length) || 0,
    isOpen: isHostExpanded,
    placeholderText: /*#__PURE__*/React__default.createElement(Placeholder, {
      text: "Hosts"
    }),
    isDisabled: allHosts.length === 0
  }, [/*#__PURE__*/React__default.createElement(SelectOption, {
    inputId: "checkbox-" + SELECT_ALL,
    key: SELECT_ALL,
    value: SELECT_ALL
  }, "Select All"), /*#__PURE__*/React__default.createElement(SelectOption, {
    inputId: "checkbox-" + CLUSTER_LEVEL,
    key: CLUSTER_LEVEL,
    value: CLUSTER_LEVEL
  }, "Cluster-level events"), /*#__PURE__*/React__default.createElement(SelectOption, {
    inputId: "checkbox-" + ORPHANS,
    key: ORPHANS,
    value: ORPHANS
  }, "Deleted hosts")].concat(allHosts.map(function (host) {
    return /*#__PURE__*/React__default.createElement(SelectOption, {
      key: host.id,
      value: host.id
    }, host.hostname);
  })))), /*#__PURE__*/React__default.createElement(ToolbarFilter, {
    chips: filters.severity.map(function (severity) {
      return {
        key: severity,
        node: ___default.capitalize(severity)
      };
    }),
    deleteChip: onDeleteChip,
    deleteChipGroup: onDeleteChipGroup,
    categoryName: "severity"
  }, /*#__PURE__*/React__default.createElement(Select, {
    variant: "checkbox",
    "aria-label": "Severity",
    onToggle: onSeverityToggle,
    onSelect: onSeveritySelect,
    selections: filters.severity,
    isOpen: isSeverityExpanded,
    placeholderText: /*#__PURE__*/React__default.createElement(Placeholder, {
      text: "Severity"
    })
  }, EVENT_SEVERITIES.map(function (severity) {
    return /*#__PURE__*/React__default.createElement(SelectOption, {
      "data-testid": severity + "-filter-option",
      key: severity,
      value: severity
    }, ___default.capitalize(severity), " ", /*#__PURE__*/React__default.createElement(Badge, {
      isRead: true
    }, getEventsCount(severity, events)));
  }))), /*#__PURE__*/React__default.createElement(ToolbarItem, null, /*#__PURE__*/React__default.createElement(InputGroup, null, /*#__PURE__*/React__default.createElement(TextInput, {
    name: "search-text",
    id: "search-text",
    type: "search",
    "aria-label": "text to be searched",
    onChange: onFulltextChange,
    value: filters.fulltext,
    placeholder: "Filter by text ..."
  }), /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.control,
    "aria-label": "search text button"
  }, /*#__PURE__*/React__default.createElement(SearchIcon, null))))));
};

var filterEvents = function filterEvents(filters, events, clusterHosts) {
  if (events === void 0) {
    events = [];
  }

  return events.filter(function (event) {
    return filters.severity.length === 0 || filters.severity.includes(event.severity);
  }).filter(function (event) {
    return !event.hostId || filters.hosts.includes(event.hostId) || filters.orphanedHosts && !(clusterHosts || []).find(function (host) {
      return host.id === event.hostId;
    });
  }).filter(function (event) {
    return event.hostId || filters.clusterLevel;
  }).filter(function (event) {
    return !filters.fulltext || (event.message || '').toLowerCase().includes(filters.fulltext.toLowerCase());
  });
};

var ClusterEventsList = function ClusterEventsList(_ref) {
  var events = _ref.events,
      cluster = _ref.cluster,
      className = _ref.className;

  var _React$useState = React__default.useState(function () {
    return getInitialClusterEventsFilters(cluster);
  }),
      filters = _React$useState[0],
      setFilters = _React$useState[1];

  var filteredEvents = React__default.useMemo(function () {
    return filterEvents(filters, events, cluster.hosts);
  }, [filters, events, cluster.hosts]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterEventsToolbar, {
    filters: filters,
    setFilters: setFilters,
    cluster: cluster,
    events: events
  }), filteredEvents.length === 0 && events.length > 0 ? /*#__PURE__*/React__default.createElement(EmptyState, {
    icon: SearchIcon,
    title: "No matching events",
    content: "There are no events that match the current filters. Adjust or clear the filters to view events.",
    primaryAction: /*#__PURE__*/React__default.createElement(Button, {
      variant: ButtonVariant.primary,
      onClick: function onClick() {
        return setFilters(getInitialClusterEventsFilters(cluster));
      },
      id: "empty-state-cluster-events-clear-filters-button",
      "data-ouia-id": "button-clear-events-filter"
    }, "Clear filters")
  }) : /*#__PURE__*/React__default.createElement(EventsList, {
    events: filteredEvents,
    className: className
  }));
};

var EventListFetch = function EventListFetch(_ref) {
  var onFetchEvents = _ref.onFetchEvents,
      props = _objectWithoutPropertiesLoose(_ref, ["onFetchEvents"]);

  var _useState = useState(),
      events = _useState[0],
      setEvents = _useState[1];

  var _useState2 = useState(0),
      lastPolling = _useState2[0],
      setLastPolling = _useState2[1];

  var _useState3 = useState(''),
      error = _useState3[0],
      setError = _useState3[1];

  var cluster = props.cluster,
      hostId = props.hostId,
      entityKind = props.entityKind,
      className = props.className;
  useEffect(function () {
    var timer;
    onFetchEvents({
      clusterId: cluster.id,
      hostId: hostId
    }, function (events) {
      setEvents(events);
      setError('');
      timer = setTimeout(function () {
        return setLastPolling(Date.now());
      }, EVENTS_POLLING_INTERVAL);
    }, setError);
    return function () {
      return clearTimeout(timer);
    };
  }, [lastPolling, cluster.id, hostId, onFetchEvents]);
  var forceRefetch = React__default.useCallback(function () {
    setLastPolling(Date.now());
  }, [setLastPolling]);

  if (error) {
    return /*#__PURE__*/React__default.createElement(ErrorState, {
      title: error,
      fetchData: forceRefetch
    });
  }

  if (!events) {
    return /*#__PURE__*/React__default.createElement(LoadingState, null);
  }

  if (entityKind === 'cluster') {
    return /*#__PURE__*/React__default.createElement(ClusterEventsList, {
      events: events,
      cluster: cluster,
      className: className
    });
  }

  return /*#__PURE__*/React__default.createElement(EventsList, {
    events: events,
    className: className
  });
};

var ExternalLink = function ExternalLink(_ref) {
  var href = _ref.href,
      children = _ref.children,
      rest = _objectWithoutPropertiesLoose(_ref, ["href", "children"]);

  return /*#__PURE__*/React__default.createElement(Text, _extends({
    component: "a",
    href: href,
    target: "_blank",
    rel: "noopener noreferrer"
  }, rest), children ? children : href, " ", /*#__PURE__*/React__default.createElement(ExternalLinkAltIcon, {
    color: "rgb(0, 123, 186)"
  }));
};

var EventsModalButton = function EventsModalButton(_ref) {
  var _ref$ButtonComponent = _ref.ButtonComponent,
      ButtonComponent = _ref$ButtonComponent === void 0 ? ToolbarButton : _ref$ButtonComponent,
      onFetchEvents = _ref.onFetchEvents,
      onClick = _ref.onClick,
      hostId = _ref.hostId,
      cluster = _ref.cluster,
      entityKind = _ref.entityKind,
      children = _ref.children,
      title = _ref.title,
      fallbackEventsURL = _ref.fallbackEventsURL,
      props = _objectWithoutPropertiesLoose(_ref, ["ButtonComponent", "onFetchEvents", "onClick", "hostId", "cluster", "entityKind", "children", "title", "fallbackEventsURL"]);

  var _React$useState = React__default.useState(false),
      isModalOpen = _React$useState[0],
      setIsModalOpen = _React$useState[1];

  var closeModal = function closeModal() {
    return setIsModalOpen(false);
  };

  var handleClick = onClick || function () {
    return setIsModalOpen(true);
  };

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ButtonComponent, _extends({}, props, {
    onClick: handleClick
  }), children || title), /*#__PURE__*/React__default.createElement(EventsModal, {
    title: title,
    isOpen: isModalOpen,
    onClose: closeModal,
    hostId: hostId,
    cluster: cluster,
    entityKind: entityKind,
    onFetchEvents: onFetchEvents,
    fallbackEventsURL: fallbackEventsURL
  }));
};
var EventsModal = function EventsModal(_ref2) {
  var onFetchEvents = _ref2.onFetchEvents,
      hostId = _ref2.hostId,
      cluster = _ref2.cluster,
      entityKind = _ref2.entityKind,
      onClose = _ref2.onClose,
      isOpen = _ref2.isOpen,
      title = _ref2.title,
      fallbackEventsURL = _ref2.fallbackEventsURL;
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: title,
    isOpen: isOpen,
    "aria-label": "Displays events",
    hasNoBodyWrapper: true,
    actions: [/*#__PURE__*/React__default.createElement(Button, {
      key: "close",
      variant: ButtonVariant.primary,
      onClick: onClose
    }, "Close")],
    onClose: onClose,
    variant: ModalVariant.large,
    className: "events-modal"
  }, /*#__PURE__*/React__default.createElement(ModalBoxBody, {
    className: "events-modal__body"
  }, fallbackEventsURL ? /*#__PURE__*/React__default.createElement(ErrorState, {
    title: "Could not load events",
    content: /*#__PURE__*/React__default.createElement(Fragment, null, "Could not load events from the standard location. You can check the events in the\xA0", /*#__PURE__*/React__default.createElement(ExternalLink, {
      href: fallbackEventsURL
    }, "raw format"), "."),
    icon: ExclamationTriangleIcon,
    iconColor: global_warning_color_100.value
  }) : /*#__PURE__*/React__default.createElement(EventListFetch, {
    hostId: hostId,
    cluster: cluster,
    entityKind: entityKind,
    onFetchEvents: onFetchEvents,
    className: "events-modal__event-list"
  })));
};

var PreviewBadgePosition;

(function (PreviewBadgePosition) {
  PreviewBadgePosition[PreviewBadgePosition["default"] = 0] = "default";
  PreviewBadgePosition[PreviewBadgePosition["inline"] = 1] = "inline";
  PreviewBadgePosition[PreviewBadgePosition["inlineRight"] = 2] = "inlineRight";
})(PreviewBadgePosition || (PreviewBadgePosition = {}));

var PreviewBadge = function PreviewBadge(_ref) {
  var _ref$position = _ref.position,
      position = _ref$position === void 0 ? PreviewBadgePosition.inlineRight : _ref$position,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'orange' : _ref$color,
      text = _ref.text;
  var clsName = className;

  switch (position) {
    case PreviewBadgePosition.inlineRight:
      clsName += ' pf-u-float-right';
      break;

    case PreviewBadgePosition.inline:
      clsName += ' pf-u-display-inline';
      break;
  }

  return /*#__PURE__*/React__default.createElement(Label, {
    className: clsName,
    color: color
  }, text);
};

var DeveloperPreview = function DeveloperPreview(props) {
  return /*#__PURE__*/React__default.createElement(PreviewBadge, _extends({}, props, {
    text: "Developer Preview"
  }));
};
var TechnologyPreview = function TechnologyPreview(props) {
  return /*#__PURE__*/React__default.createElement(PreviewBadge, _extends({}, props, {
    text: "Technology Preview"
  }));
};

var NavItem = function NavItem(_ref) {
  var _ref$isValid = _ref.isValid,
      isValid = _ref$isValid === void 0 ? function () {
    return true;
  } : _ref$isValid,
      props = _objectWithoutPropertiesLoose(_ref, ["isValid"]);

  var content = props.content,
      isDisabled = props.isDisabled,
      isCurrent = props.isCurrent;
  var validatedLinkName = content;

  if (!isDisabled && !isCurrent && !isValid()) {
    validatedLinkName = /*#__PURE__*/React__default.createElement(Fragment, null, content, /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
      className: "wizard-nav-item-warning-icon",
      color: global_danger_color_100.value,
      size: "sm"
    }));
  }

  return /*#__PURE__*/React__default.createElement(WizardNavItem, _extends({}, props, {
    content: validatedLinkName
  }));
};

var initialState = [];
var alertsSlice = createSlice({
  initialState: initialState,
  name: 'alerts',
  reducers: {
    addAlert: function addAlert(state, action) {
      return [_extends({
        key: v4(),
        variant: AlertVariant.danger
      }, action.payload)].concat(state);
    },
    removeAlert: function removeAlert(state, action) {
      return state.filter(function (alert) {
        return alert.key !== action.payload;
      });
    },
    clearAlerts: function clearAlerts() {
      return initialState;
    }
  }
});

var initialState$1 = {};
var dialogsSlice = createSlice({
  initialState: initialState$1,
  name: 'alerts',
  reducers: {
    openDialog: function openDialog(state, action) {
      state[action.payload.dialogId] = action.payload.data || {};
      return state;
    },
    closeDialog: function closeDialog(state, action) {
      state[action.payload.dialogId] = undefined;
      return state;
    }
  }
});



var index$2 = {
  __proto__: null,
  alertsSlice: alertsSlice,
  dialogsSlice: dialogsSlice
};

var _alertsSlice$actions = alertsSlice.actions,
    addAlertAction = _alertsSlice$actions.addAlert,
    removeAlertAction = _alertsSlice$actions.removeAlert,
    clearAlertsAction = _alertsSlice$actions.clearAlerts;
var alertsReducer = alertsSlice.reducer;
var AlertsContext = React__default.createContext({
  alerts: [],
  addAlert: function addAlert() {
    return null;
  },
  removeAlert: function removeAlert() {
    return null;
  },
  clearAlerts: function clearAlerts() {
    return null;
  }
});
var AlertsContextProvider = function AlertsContextProvider(_ref) {
  var children = _ref.children;

  var _React$useReducer = React__default.useReducer(alertsReducer, []),
      alerts = _React$useReducer[0],
      dispatchAlertsAction = _React$useReducer[1];

  var addAlert = function addAlert(alert) {
    return dispatchAlertsAction(addAlertAction(alert));
  };

  var removeAlert = function removeAlert(alertKey) {
    return dispatchAlertsAction(removeAlertAction(alertKey));
  };

  var clearAlerts = function clearAlerts() {
    return dispatchAlertsAction(clearAlertsAction());
  };

  return /*#__PURE__*/React__default.createElement(AlertsContext.Provider, {
    value: {
      alerts: alerts,
      addAlert: addAlert,
      removeAlert: removeAlert,
      clearAlerts: clearAlerts
    }
  }, children);
};
var useAlerts = function useAlerts() {
  var context = React__default.useContext(AlertsContext);

  if (context === undefined) {
    throw new Error('useAlerts must be used within AlertsContextProvider');
  }

  return context;
};

var Alerts = function Alerts(_ref) {
  var className = _ref.className;

  var _useAlerts = useAlerts(),
      alerts = _useAlerts.alerts,
      removeAlert = _useAlerts.removeAlert;

  var _onClose = function onClose(alert) {
    return removeAlert(alert.key);
  };

  if (alerts.length) {
    return /*#__PURE__*/React__default.createElement(AlertGroup, {
      className: className
    }, alerts.map(function (alert) {
      return (
        /*#__PURE__*/
        React__default.createElement(Alert, _extends({
          actionClose: /*#__PURE__*/React__default.createElement(AlertActionCloseButton, {
            onClose: function onClose() {
              return _onClose(alert);
            }
          }),
          isInline: true
        }, alert), alert.message)
      );
    }));
  }

  return null;
};

var PrismCode = function PrismCode(_ref) {
  var code = _ref.code,
      _ref$language = _ref.language,
      language = _ref$language === void 0 ? 'bash' : _ref$language,
      _ref$theme = _ref.theme,
      theme = _ref$theme === void 0 ? defaultTheme : _ref$theme,
      _ref$copiable = _ref.copiable,
      copiable = _ref$copiable === void 0 ? false : _ref$copiable;
  return /*#__PURE__*/React__default.createElement(Highlight, _extends({}, defaultProps, {
    code: code,
    language: language,
    theme: theme
  }), function (_ref2) {
    var className = _ref2.className,
        style = _ref2.style,
        tokens = _ref2.tokens,
        getLineProps = _ref2.getLineProps,
        getTokenProps = _ref2.getTokenProps;
    return /*#__PURE__*/React__default.createElement(Text, {
      component: TextVariants.pre,
      className: className,
      style: style
    }, copiable && /*#__PURE__*/React__default.createElement(ClipboardCopy, {
      isReadOnly: true,
      variant: 'inline-compact',
      onCopy: function onCopy(e) {
        return clipboardCopyFunc(e, code);
      },
      style: {
        "float": 'right',
        background: 'inherit'
      }
    }), tokens.map(function (line, i) {
      return /*#__PURE__*/React__default.createElement("div", _extends({
        key: i
      }, getLineProps({
        line: line,
        key: i
      })), line.map(function (token, key) {
        return /*#__PURE__*/React__default.createElement("span", _extends({
          key: key
        }, getTokenProps({
          token: token,
          key: key
        })));
      }));
    }));
  });
};

var GridGap = function GridGap(props) {
  return /*#__PURE__*/React__default.createElement("div", _extends({}, props, {
    className: "pf-c-form"
  }));
};

var ClusterWizardStepHeader = function ClusterWizardStepHeader(_ref) {
  var children = _ref.children,
      extraItems = _ref.extraItems;
  return /*#__PURE__*/React__default.createElement(Split, null, /*#__PURE__*/React__default.createElement(SplitItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h2"
  }, children))), /*#__PURE__*/React__default.createElement(SplitItem, {
    isFilled: true
  }), extraItems);
};

function unwrapExports (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var wizard = createCommonjsModule(function (module, exports) {
exports.__esModule = true;

exports.default = {
  "button": "pf-c-button",
  "card": "pf-c-card",
  "modalBox": "pf-c-modal-box",
  "modifiers": {
    "finished": "pf-m-finished",
    "expanded": "pf-m-expanded",
    "current": "pf-m-current",
    "expandable": "pf-m-expandable",
    "disabled": "pf-m-disabled",
    "noPadding": "pf-m-no-padding"
  },
  "pageMainWizard": "pf-c-page__main-wizard",
  "wizard": "pf-c-wizard",
  "wizardClose": "pf-c-wizard__close",
  "wizardDescription": "pf-c-wizard__description",
  "wizardFooter": "pf-c-wizard__footer",
  "wizardFooterCancel": "pf-c-wizard__footer-cancel",
  "wizardHeader": "pf-c-wizard__header",
  "wizardInnerWrap": "pf-c-wizard__inner-wrap",
  "wizardMain": "pf-c-wizard__main",
  "wizardMainBody": "pf-c-wizard__main-body",
  "wizardNav": "pf-c-wizard__nav",
  "wizardNavItem": "pf-c-wizard__nav-item",
  "wizardNavLink": "pf-c-wizard__nav-link",
  "wizardNavLinkText": "pf-c-wizard__nav-link-text",
  "wizardNavLinkToggle": "pf-c-wizard__nav-link-toggle",
  "wizardNavLinkToggleIcon": "pf-c-wizard__nav-link-toggle-icon",
  "wizardNavList": "pf-c-wizard__nav-list",
  "wizardOuterWrap": "pf-c-wizard__outer-wrap",
  "wizardTitle": "pf-c-wizard__title",
  "wizardToggle": "pf-c-wizard__toggle",
  "wizardToggleIcon": "pf-c-wizard__toggle-icon",
  "wizardToggleList": "pf-c-wizard__toggle-list",
  "wizardToggleListItem": "pf-c-wizard__toggle-list-item",
  "wizardToggleNum": "pf-c-wizard__toggle-num",
  "wizardToggleSeparator": "pf-c-wizard__toggle-separator"
};
});

var styles = unwrapExports(wizard);

var ClusterWizardStep = function ClusterWizardStep(_ref) {
  var navigation = _ref.navigation,
      footer = _ref.footer,
      children = _ref.children;
  return /*#__PURE__*/React__default.createElement("div", {
    className: css(styles.wizardOuterWrap, 'cluster-wizard-step')
  }, /*#__PURE__*/React__default.createElement("div", {
    className: css(styles.wizardInnerWrap)
  }, navigation, /*#__PURE__*/React__default.createElement(WizardBody, {
    "aria-labelledby": "step-id",
    hasNoBodyPadding: false
  }, children)), footer && /*#__PURE__*/React__default.createElement("div", {
    className: "pf-c-wizard__footer cluster-wizard-step__footer"
  }, footer));
};

var SNODisclaimer = function SNODisclaimer(_ref) {
  var _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      _ref$snoSupportLevel = _ref.snoSupportLevel,
      snoSupportLevel = _ref$snoSupportLevel === void 0 ? 'supported' : _ref$snoSupportLevel;
  var isUnsupported = snoSupportLevel !== 'supported';
  var generalSNOFacts = /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ListItem$1, null, "Installing SNO will result in a non-highly available OpenShift deployment."), /*#__PURE__*/React__default.createElement(ListItem$1, null, "Adding additional machines to your cluster is currently out of scope."));
  var unsupportedWarnings = /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ListItem$1, null, "SNO is in a proof-of-concept stage and is not supported in any way."), /*#__PURE__*/React__default.createElement(ListItem$1, null, "OpenShift in-place upgrades aren't expected to work with SNO. If an upgrade is needed, your system will need a redeployment."));
  return /*#__PURE__*/React__default.createElement(Alert, {
    variant: isUnsupported ? AlertVariant.warning : AlertVariant.info,
    title: "Limitations for using Single Node OpenShift",
    isInline: true
  }, /*#__PURE__*/React__default.createElement(Stack, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(List, null, generalSNOFacts, isUnsupported && unsupportedWarnings)), isUnsupported && /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(CheckboxField, {
    name: "SNODisclaimer",
    label: "I understand, accept, and agree to the limitations associated with using Single Node OpenShift.",
    isDisabled: isDisabled
  }))));
};

var isSingleNodeCluster = function isSingleNodeCluster(cluster) {
  return cluster.highAvailabilityMode === 'None';
};

var canEnable = function canEnable(clusterStatus, status) {
  return ['pending-for-input', 'insufficient', 'ready', 'adding-hosts'].includes(clusterStatus) && ['disabled', 'disabled-unbound'].includes(status);
};
var canDisable = function canDisable(clusterStatus, status) {
  return ['pending-for-input', 'insufficient', 'ready', 'adding-hosts'].includes(clusterStatus) && ['discovering', 'discovering-unbound', 'disconnected', 'disconnected-unbound', 'known', 'known-unbound', 'insufficient', 'insufficient-unbound', 'pending-for-input'].includes(status);
};
var canDelete = function canDelete(clusterStatus, status) {
  return ['pending-for-input', 'insufficient', 'ready', 'adding-hosts'].includes(clusterStatus) && ['discovering', 'discovering-unbound', 'known', 'known-unbound', 'disconnected', 'disconnected-unbound', 'disabled', 'disabled-unbound', 'insufficient', 'insufficient-unbound', 'resetting', 'resetting-pending-user-input', 'resetting-pending-user-action', 'installing-pending-user-action', 'pending-for-input', 'added-to-existing-cluster', 'error'].includes(status);
};
var canReset = function canReset(clusterStatus, status) {
  return ['adding-hosts'].includes(clusterStatus) && ['error', 'installing-pending-user-action'].includes(status);
};
var canEditRole = function canEditRole(cluster, hostStatus) {
  return !isSingleNodeCluster(cluster) && ['pending-for-input', 'insufficient', 'ready'].includes(cluster.status) && ['discovering', 'discovering-unbound', 'known', 'known-unbound', 'disconnected', 'disconnected-unbound', 'disabled', 'disabled-unbound', 'insufficient', 'insufficient-unbound', 'pending-for-input'].includes(hostStatus);
};
var canEditHost = function canEditHost(clusterStatus, status) {
  return ['pending-for-input', 'insufficient', 'ready'].includes(clusterStatus) && ['discovering', 'discovering-unbound', 'known', 'known-unbound', 'disconnected', 'disconnected-unbound', 'disabled', 'disabled-unbound', 'insufficient', 'insufficient-unbound', 'pending-for-input'].includes(status);
};
var canEditDisks = canEditHost;
var canDownloadKubeconfig = function canDownloadKubeconfig(clusterStatus) {
  return ['installing', 'finalizing', 'error', 'cancelled', 'installed', 'adding-hosts'].includes(clusterStatus);
};
var canInstallHost = function canInstallHost(cluster, hostStatus) {
  return cluster.kind === 'AddHostsCluster' && cluster.status === 'adding-hosts' && hostStatus === 'known';
};
var getHostProgressStages = function getHostProgressStages(host) {
  return host.progressStages || [];
};
var getHostProgress = function getHostProgress(host) {
  return host.progress || {
    currentStage: 'Preparing installation',
    progressInfo: undefined
  };
};
var getHostProgressStageNumber = function getHostProgressStageNumber(host) {
  var stages = getHostProgressStages(host);
  var progress = getHostProgress(host);

  if (progress === null || progress === void 0 ? void 0 : progress.currentStage) {
    var currentStage = progress.currentStage;
    return stages.findIndex(function (s) {
      return currentStage.match(s);
    }) + 1;
  }

  return 0;
};
var canHostnameBeChanged = function canHostnameBeChanged(hostStatus) {
  return ['discovering', 'discovering-unbound', 'known', 'known-unbound', 'disconnected', 'disconnected-unbound', 'insufficient', 'insufficient-unbound', 'pending-for-input'].includes(hostStatus);
};
var getHostRole = function getHostRole(host) {
  var _HOST_ROLES$find;

  return "" + (((_HOST_ROLES$find = HOST_ROLES.find(function (role) {
    return role.value === host.role;
  })) === null || _HOST_ROLES$find === void 0 ? void 0 : _HOST_ROLES$find.label) || HOST_ROLES[0].label) + (host.bootstrap ? ' (bootstrap)' : '');
};
var canDownloadHostLogs = function canDownloadHostLogs(host) {
  return !!host.logsCollectedAt && host.logsCollectedAt != TIME_ZERO;
};
var canDownloadClusterLogs = function canDownloadClusterLogs(cluster) {
  return !!(cluster.hosts || []).find(function (host) {
    return canDownloadHostLogs(host);
  });
};
var getReadyHostCount = function getReadyHostCount(cluster) {
  return cluster.readyHostCount || 0;
};
var getEnabledHostCount = function getEnabledHostCount(cluster) {
  return cluster.enabledHostCount || 0;
};
var getTotalHostCount = function getTotalHostCount(cluster) {
  return cluster.totalHostCount || 0;
};
var getEnabledHosts = function getEnabledHosts(hosts) {
  if (hosts === void 0) {
    hosts = [];
  }

  return hosts.filter(function (host) {
    return host.status !== 'disabled';
  });
};
var getHostname = function getHostname(host, inventory) {
  return host.requestedHostname || inventory.hostname;
};
var getHardwareTypeText = function getHardwareTypeText(inventory) {
  var hardwareTypeText = DASH;
  var systemVendor = inventory.systemVendor;

  if (systemVendor !== undefined) {
    if (systemVendor.virtual) {
      hardwareTypeText = 'Virtual machine';
    } else {
      hardwareTypeText = 'Bare metal';
    }
  }

  return hardwareTypeText;
};
var fileSize = function fileSize() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return filesize.call.apply(filesize, [null].concat(args)).toUpperCase().replace(/I/, 'i');
};

var getSubnet = function getSubnet(cidr) {
  if (Address4.isValid(cidr)) {
    return new Address4(cidr);
  } else if (Address6.isValid(cidr)) {
    return new Address6(cidr);
  } else {
    return null;
  }
};

var getHumanizedSubnet = function getHumanizedSubnet(subnet) {
  if (subnet) {
    var subnetStart = subnet.startAddress().correctForm();
    var subnetEnd = subnet.endAddress().correctForm();
    return subnet.address + " (" + subnetStart + " - " + subnetEnd + ")";
  }

  return '';
};

var getHostSubnets = function getHostSubnets(cluster) {
  var _cluster$hosts, _cluster$hostNetworks;

  var hostnameMap = ((_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.reduce(function (acc, host) {
    var _extends2;

    var inventory = stringToJSON(host.inventory) || {};
    acc = _extends({}, acc, (_extends2 = {}, _extends2[host.id] = getHostname(host, inventory), _extends2));
    return acc;
  }, {})) || {};
  return ((_cluster$hostNetworks = cluster.hostNetworks) === null || _cluster$hostNetworks === void 0 ? void 0 : _cluster$hostNetworks.map(function (hn) {
    var _hn$hostIds;

    return {
      subnet: hn.cidr || '',
      hostIDs: ((_hn$hostIds = hn.hostIds) === null || _hn$hostIds === void 0 ? void 0 : _hn$hostIds.map(function (id) {
        return hostnameMap[id] || id;
      })) || [],
      humanized: getHumanizedSubnet(getSubnet(hn.cidr))
    };
  })) || [];
};
var getSubnetFromMachineNetworkCidr = function getSubnetFromMachineNetworkCidr(machineNetworkCidr) {
  if (!machineNetworkCidr) {
    return NO_SUBNET_SET;
  }

  var subnet = getSubnet(machineNetworkCidr);
  return subnet === null || subnet === void 0 ? void 0 : subnet.address;
};
var isAdvNetworkConf = function isAdvNetworkConf(cluster, defaultNetworkSettings) {
  return cluster.clusterNetworkCidr !== defaultNetworkSettings.clusterNetworkCidr || cluster.clusterNetworkHostPrefix !== defaultNetworkSettings.clusterNetworkHostPrefix || cluster.serviceNetworkCidr !== defaultNetworkSettings.serviceNetworkCidr || Boolean(cluster.networkType) && cluster.networkType !== 'OpenShiftSDN';
};
var getHostDiscoveryInitialValues = function getHostDiscoveryInitialValues(cluster) {
  var _cluster$platform;

  var monitoredOperators = cluster.monitoredOperators || [];

  var isOperatorEnabled = function isOperatorEnabled(name) {
    return !!monitoredOperators.find(function (operator) {
      return operator.name === name;
    });
  };

  return {
    useExtraDisksForLocalStorage: isOperatorEnabled('ocs'),
    useContainerNativeVirtualization: isOperatorEnabled('cnv'),
    usePlatformIntegration: ((_cluster$platform = cluster.platform) === null || _cluster$platform === void 0 ? void 0 : _cluster$platform.type) !== 'baremetal'
  };
};
var getSNOSupportLevel = function getSNOSupportLevel(version) {
  if (version === void 0) {
    version = '';
  }

  if (version.startsWith('4.9')) {
    return 'supported';
  }

  return 'dev-preview';
};

var SNOControlGroup = function SNOControlGroup(_ref) {
  var versions = _ref.versions,
      highAvailabilityMode = _ref.highAvailabilityMode,
      isDisabled = _ref.isDisabled;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  var selectedVersion = versions.find(function (version) {
    return version.value === values.openshiftVersion;
  });
  var snoSupportLevel = getSNOSupportLevel(selectedVersion === null || selectedVersion === void 0 ? void 0 : selectedVersion.version);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(SingleNodeCheckbox, {
    name: "highAvailabilityMode",
    versions: versions,
    isDisabled: isDisabled
  }), highAvailabilityMode === 'None' && /*#__PURE__*/React__default.createElement(SNODisclaimer, {
    isDisabled: isDisabled,
    snoSupportLevel: snoSupportLevel
  }));
};

var OpenShiftLifeCycleDatesLink = function OpenShiftLifeCycleDatesLink() {
  return /*#__PURE__*/React__default.createElement("a", {
    href: OPENSHIFT_LIFE_CYCLE_DATES_LINK,
    target: "_blank",
    rel: "noopener noreferrer"
  }, 'Learn more', " ", /*#__PURE__*/React__default.createElement(ExternalLinkAltIcon, null));
};

var getOpenshiftVersionHelperText = function getOpenshiftVersionHelperText(versions) {
  return function (selectedVersionValue) {
    var helperTextComponent = null;
    var selectedVersion = versions.find(function (version) {
      return version.value === selectedVersionValue;
    });

    if ((selectedVersion === null || selectedVersion === void 0 ? void 0 : selectedVersion.supportLevel) !== 'production') {
      helperTextComponent = /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
        color: global_warning_color_100.value,
        size: "sm"
      }), "\xA0Please note that this version is not production ready. ", /*#__PURE__*/React__default.createElement(OpenShiftLifeCycleDatesLink, null));
    }

    return helperTextComponent;
  };
};

var OpenShiftVersionSelect = function OpenShiftVersionSelect(_ref) {
  var versions = _ref.versions;

  var _useFormikContext = useFormikContext(),
      _useFormikContext$val = _useFormikContext.values,
      highAvailabilityMode = _useFormikContext$val.highAvailabilityMode,
      openshiftVersion = _useFormikContext$val.openshiftVersion,
      setFieldValue = _useFormikContext.setFieldValue;

  var selectedVersion = versions.find(function (v) {
    return v.value === openshiftVersion;
  }) || versions[0];
  React__default.useEffect(function () {
    if (highAvailabilityMode === 'None' && !isSNOSupportedVersion(selectedVersion)) {
      var _versions$find;

      var firstSupportedVersionValue = (_versions$find = versions.find(isSNOSupportedVersion)) === null || _versions$find === void 0 ? void 0 : _versions$find.value;
      setFieldValue('openshiftVersion', firstSupportedVersionValue);
    }
  }, [highAvailabilityMode, selectedVersion, setFieldValue, versions]);
  var selectOptions = React__default.useMemo(function () {
    return versions.filter(function (version) {
      return highAvailabilityMode !== 'None' || isSNOSupportedVersion(version);
    }).map(function (version) {
      return {
        label: version.label,
        value: version.value
      };
    });
  }, [versions, highAvailabilityMode]);
  return /*#__PURE__*/React__default.createElement(SelectField, {
    label: "OpenShift version",
    name: "openshiftVersion",
    options: selectOptions,
    getHelperText: getOpenshiftVersionHelperText(versions),
    isDisabled: versions.length === 0,
    isRequired: true
  });
};

var NetworkTypeControlGroup = function NetworkTypeControlGroup(_ref) {
  var _ref$isIPv = _ref.isIPv6,
      isIPv6 = _ref$isIPv === void 0 ? false : _ref$isIPv;
  var GROUP_NAME = 'networkType';
  return /*#__PURE__*/React__default.createElement(FormGroup, {
    fieldId: GROUP_NAME,
    label: "Network type"
  }, /*#__PURE__*/React__default.createElement(Split, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(SplitItem, null, /*#__PURE__*/React__default.createElement(Tooltip, {
    hidden: !isIPv6,
    content: 'Software-Defined Networking (SDN) can be selected only when IPv4 is detected.'
  }, /*#__PURE__*/React__default.createElement(RadioField, {
    id: GROUP_NAME,
    name: GROUP_NAME,
    isDisabled: isIPv6,
    value: 'OpenShiftSDN',
    label: /*#__PURE__*/React__default.createElement(Fragment, null, "Software-Defined Networking (SDN)", ' ', /*#__PURE__*/React__default.createElement(PopoverIcon, {
      variant: 'plain',
      bodyContent: 'The classic bullet-proof networking type'
    }))
  }))), /*#__PURE__*/React__default.createElement(SplitItem, null), /*#__PURE__*/React__default.createElement(SplitItem, null, /*#__PURE__*/React__default.createElement(RadioField, {
    id: GROUP_NAME,
    name: GROUP_NAME,
    value: 'OVNKubernetes',
    label: /*#__PURE__*/React__default.createElement(Fragment, null, "Open Virtual Networking (OVN)", ' ', /*#__PURE__*/React__default.createElement(PopoverIcon, {
      variant: 'plain',
      bodyContent: "The next generation networking type, select this when you're using new features and telco features"
    }))
  }))));
};

var AdvancedNetworkFields = function AdvancedNetworkFields() {
  var isNetworkTypeSelectionEnabled = useFeature('ASSISTED_INSTALLER_NETWORK_TYPE_SELECTION_FEATURE');

  var _useFormikContext = useFormikContext(),
      setFieldValue = _useFormikContext.setFieldValue,
      values = _useFormikContext.values;

  var clusterNetworkCidrPrefix = parseInt((values.clusterNetworkCidr || '').split('/')[1]) || 1;

  var formatClusterNetworkHostPrefix = function formatClusterNetworkHostPrefix(e) {
    if (isNaN(parseInt(e.target.value))) {
      setFieldValue('clusterNetworkHostPrefix', clusterNetworkCidrPrefix);
    }
  };

  var isClusterCIDRIPv6 = Address6.isValid(values.clusterNetworkCidr || '');
  var isIPv6 = useMemo(function () {
    return isClusterCIDRIPv6 || Address6.isValid(values.machineNetworkCidr || '') || Address6.isValid(values.serviceNetworkCidr || '');
  }, [isClusterCIDRIPv6, values.machineNetworkCidr, values.serviceNetworkCidr]);
  var clusterNetworkHostPrefixHelperText = isClusterCIDRIPv6 ? 'The subnet prefix length to assign to each individual node. For example, if Cluster Network Host Prefix is set to 116, then each node is assigned a /116 subnet out of the given cidr (clusterNetworkCIDR), which allows for 4,094 (2^(128 - 116) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.' : 'The subnet prefix length to assign to each individual node. For example, if Cluster Network Host Prefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.';
  useEffect(function () {
    if (isNetworkTypeSelectionEnabled && isIPv6) {
      setFieldValue('networkType', 'OVNKubernetes');
    }
  }, [isIPv6, setFieldValue, isNetworkTypeSelectionEnabled]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(InputField, {
    name: "clusterNetworkCidr",
    label: "Cluster network CIDR",
    helperText: "IP address block from which Pod IPs are allocated This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.",
    isRequired: true
  }), /*#__PURE__*/React__default.createElement(InputField, {
    name: "clusterNetworkHostPrefix",
    label: "Cluster network host prefix",
    type: TextInputTypes.number,
    min: clusterNetworkCidrPrefix,
    max: isClusterCIDRIPv6 ? PREFIX_MAX_RESTRICTION.IPv6 : PREFIX_MAX_RESTRICTION.IPv4,
    onBlur: function onBlur(e) {
      return formatClusterNetworkHostPrefix(e);
    },
    helperText: clusterNetworkHostPrefixHelperText,
    isRequired: true
  }), /*#__PURE__*/React__default.createElement(InputField, {
    name: "serviceNetworkCidr",
    label: "Service network CIDR",
    helperText: "The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.",
    isRequired: true
  }), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: isNetworkTypeSelectionEnabled
  }, /*#__PURE__*/React__default.createElement(NetworkTypeControlGroup, {
    isIPv6: isIPv6
  })));
};

var SubnetHelperText = function SubnetHelperText(_ref) {
  var matchingSubnet = _ref.matchingSubnet,
      hosts = _ref.hosts;
  var excludedHosts = (hosts === null || hosts === void 0 ? void 0 : hosts.filter(function (host) {
    return !['disabled', 'disconnected'].includes(host.status) && !matchingSubnet.hostIDs.includes(host.requestedHostname || '');
  })) || [];

  if (excludedHosts.length === 0 || !matchingSubnet.hostIDs.length) {
    return null;
  }

  var actionLinks = /*#__PURE__*/React__default.createElement(Popover, {
    position: "right",
    bodyContent: /*#__PURE__*/React__default.createElement("ul", null, excludedHosts.sort(function (hostA, hostB) {
      var _hostA$requestedHostn;

      return ((_hostA$requestedHostn = hostA.requestedHostname) === null || _hostA$requestedHostn === void 0 ? void 0 : _hostA$requestedHostn.localeCompare(hostB.requestedHostname || '')) || 0;
    }).map(function (host) {
      return /*#__PURE__*/React__default.createElement("li", {
        key: host.id
      }, host.requestedHostname || host.id);
    })),
    minWidth: "30rem",
    maxWidth: "50rem"
  }, /*#__PURE__*/React__default.createElement(AlertActionLink, {
    id: "form-input-hostSubnet-field-helper-view-excluded"
  }, "View " + excludedHosts.length + " affected host" + (excludedHosts.length > 1 ? 's' : '')));
  return /*#__PURE__*/React__default.createElement(Alert, {
    title: 'This subnet range is not available on all hosts',
    variant: AlertVariant.warning,
    actionLinks: actionLinks,
    isInline: true
  }, 'Hosts outside of this range will not be included in the new cluster.');
};

var AvailableSubnetsControl = function AvailableSubnetsControl(_ref2) {
  var hostSubnets = _ref2.hostSubnets,
      hosts = _ref2.hosts,
      _ref2$isRequired = _ref2.isRequired,
      isRequired = _ref2$isRequired === void 0 ? false : _ref2$isRequired,
      isMultiNodeCluster = _ref2.isMultiNodeCluster;

  var getHelperText = function getHelperText(value) {
    var matchingSubnet = hostSubnets.find(function (hn) {
      return hn.subnet === value;
    });

    if (matchingSubnet) {
      return isMultiNodeCluster && /*#__PURE__*/React__default.createElement(SubnetHelperText, {
        matchingSubnet: matchingSubnet,
        hosts: hosts
      });
    }

    return undefined;
  };

  return /*#__PURE__*/React__default.createElement(SelectField, {
    name: "hostSubnet",
    label: "Available subnets",
    options: hostSubnets.length ? [{
      label: "Please select a subnet. (" + hostSubnets.length + " available)",
      value: NO_SUBNET_SET,
      isDisabled: true,
      id: 'form-input-hostSubnet-field-option-no-subnet'
    }].concat(hostSubnets.sort(function (subA, subB) {
      return subA.humanized.localeCompare(subB.humanized);
    }).map(function (hn, index) {
      return {
        label: hn.humanized,
        value: hn.subnet,
        id: "form-input-hostSubnet-field-option-" + index
      };
    })) : [{
      label: 'No subnets are currently available',
      value: NO_SUBNET_SET
    }],
    getHelperText: getHelperText,
    isDisabled: !hostSubnets.length,
    isRequired: isRequired
  });
};

var UserManagedNetworkingTextContent = function UserManagedNetworkingTextContent(_ref) {
  var _ref$shouldDisplayLoa = _ref.shouldDisplayLoadBalancersBullet,
      shouldDisplayLoadBalancersBullet = _ref$shouldDisplayLoa === void 0 ? false : _ref$shouldDisplayLoa;
  return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: 'p'
  }, "Please refer to the", ' ', /*#__PURE__*/React__default.createElement(ExternalLink, {
    href: OPENSHIFT_NETWORKING_DOCS_LINK
  }, "OpenShift networking documentation"), ' ', "to configure your cluster's networking, including:", ' '), /*#__PURE__*/React__default.createElement(List, null, /*#__PURE__*/React__default.createElement(ListItem$1, null, "DHCP or static IP Addresses"), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: shouldDisplayLoadBalancersBullet
  }, /*#__PURE__*/React__default.createElement(ListItem$1, null, "Load balancers")), /*#__PURE__*/React__default.createElement(ListItem$1, null, "Network ports"), /*#__PURE__*/React__default.createElement(ListItem$1, null, "DNS")));
};

var ManagedNetworkingControlGroup = function ManagedNetworkingControlGroup(_ref) {
  var _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled;
  var GROUP_NAME = 'managedNetworkingType';
  return /*#__PURE__*/React__default.createElement(Split, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(SplitItem, null, /*#__PURE__*/React__default.createElement(RadioField, {
    name: GROUP_NAME,
    isDisabled: disabled,
    value: 'clusterManaged',
    label: "Cluster-Managed Networking"
  })), /*#__PURE__*/React__default.createElement(SplitItem, null), /*#__PURE__*/React__default.createElement(SplitItem, null, /*#__PURE__*/React__default.createElement(RadioField, {
    name: GROUP_NAME,
    isDisabled: disabled,
    value: 'userManaged',
    label: "User-Managed Networking"
  })));
};

var VipStaticValue = function VipStaticValue(_ref) {
  var vipName = _ref.vipName,
      cluster = _ref.cluster,
      validationErrorMessage = _ref.validationErrorMessage;
  var vipDhcpAllocation = cluster.vipDhcpAllocation,
      machineNetworkCidr = cluster.machineNetworkCidr;

  if (vipDhcpAllocation && cluster[vipName]) {
    return cluster[vipName];
  }

  if (vipDhcpAllocation && validationErrorMessage) {
    return /*#__PURE__*/React__default.createElement(Alert, {
      variant: AlertVariant.danger,
      title: "The DHCP server failed to allocate the IP",
      isInline: true
    }, validationErrorMessage);
  }

  if (vipDhcpAllocation && machineNetworkCidr) {
    return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Spinner, {
      size: "md"
    }), /*#__PURE__*/React__default.createElement("i", null, " This IP is being allocated by the DHCP server"));
  }

  return /*#__PURE__*/React__default.createElement("i", null, "This IP will be allocated by the DHCP server");
};

var getVipHelperSuffix = function getVipHelperSuffix(vip, vipDhcpAllocation, vipDhcpAllocationFormValue) {
  if (!vipDhcpAllocationFormValue) {
    return 'Make sure that the VIP is unique and not used by any other device on your network.';
  }

  if (vipDhcpAllocation && vip) {
    return 'This IP was allocated by the DHCP server.';
  }

  return '';
};

var getVipValidationsById = function getVipValidationsById(validationsInfoString) {
  var validationsInfo = stringToJSON(validationsInfoString) || {};
  var failedDhcpAllocationMessageStubs = ['VIP IP allocation from DHCP server has been timed out', 'IP allocation from the DHCP server timed out.'];
  return (validationsInfo.network || []).reduce(function (lookup, validation) {
    if (['api-vip-defined', 'ingress-vip-defined'].includes(validation.id)) {
      lookup[validation.id] = validation.status === 'failure' && failedDhcpAllocationMessageStubs.find(function (stub) {
        return validation.message.match(stub);
      }) ? validation.message : undefined;
    }

    return lookup;
  }, {});
};

var VirtualIPControlGroup = function VirtualIPControlGroup(_ref2) {
  var cluster = _ref2.cluster,
      hostSubnets = _ref2.hostSubnets,
      isVipDhcpAllocationDisabled = _ref2.isVipDhcpAllocationDisabled;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  var apiVipHelperText = "Provide an endpoint for users, both human and machine, to interact with and configure the platform. If needed, contact your IT manager for more information. " + getVipHelperSuffix(cluster.apiVip, cluster.vipDhcpAllocation, values.vipDhcpAllocation);
  var ingressVipHelperText = "Provide an endpoint for application traffic flowing in from outside the cluster. If needed, contact your IT manager for more information. " + getVipHelperSuffix(cluster.ingressVip, cluster.vipDhcpAllocation, values.vipDhcpAllocation);

  var _React$useMemo = React__default.useMemo(function () {
    return getVipValidationsById(cluster.validationsInfo);
  }, [cluster.validationsInfo]),
      apiVipFailedValidationMessage = _React$useMemo['api-vip-defined'],
      ingressVipFailedValidationMessage = _React$useMemo['ingress-vip-defined'];

  return /*#__PURE__*/React__default.createElement(Fragment, null, !isVipDhcpAllocationDisabled && /*#__PURE__*/React__default.createElement(CheckboxField, {
    label: "Allocate virtual IPs via DHCP server",
    name: "vipDhcpAllocation"
  }), values.vipDhcpAllocation ? /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(FormikStaticField, {
    label: "API Virtual IP",
    name: "apiVip",
    helperText: apiVipHelperText,
    value: cluster.apiVip || '',
    isValid: !apiVipFailedValidationMessage,
    isRequired: true
  }, /*#__PURE__*/React__default.createElement(VipStaticValue, {
    vipName: "apiVip",
    cluster: cluster,
    validationErrorMessage: apiVipFailedValidationMessage
  })), /*#__PURE__*/React__default.createElement(FormikStaticField, {
    label: "Ingress Virtual IP",
    name: "ingressVip",
    helperText: ingressVipHelperText,
    value: cluster.ingressVip || '',
    isValid: !ingressVipFailedValidationMessage,
    isRequired: true
  }, /*#__PURE__*/React__default.createElement(VipStaticValue, {
    vipName: "ingressVip",
    cluster: cluster,
    validationErrorMessage: ingressVipFailedValidationMessage
  }))) : /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(InputField, {
    label: "API Virtual IP",
    name: "apiVip",
    helperText: apiVipHelperText,
    isRequired: true,
    isDisabled: !hostSubnets.length || values.hostSubnet === NO_SUBNET_SET
  }), /*#__PURE__*/React__default.createElement(InputField, {
    name: "ingressVip",
    label: "Ingress Virtual IP",
    helperText: ingressVipHelperText,
    isRequired: true,
    isDisabled: !hostSubnets.length || values.hostSubnet === NO_SUBNET_SET
  })));
};

var PullSecret = function PullSecret(_ref) {
  var defaultPullSecret = _ref.defaultPullSecret,
      isOcm = _ref.isOcm;

  var _React$useState = React__default.useState(!defaultPullSecret),
      isExpanded = _React$useState[0],
      setExpanded = _React$useState[1];

  var _useFormikContext = useFormikContext(),
      setFieldValue = _useFormikContext.setFieldValue;

  if (isOcm) {
    var onCheckboxChange = function onCheckboxChange() {
      if (isExpanded) {
        setFieldValue('pullSecret', defaultPullSecret);
      }

      setExpanded(!isExpanded);
    };

    return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Checkbox, {
      id: "checkbox-pull-secret",
      className: "pf-u-display-inline-flex",
      "aria-label": "edit pull secret",
      isChecked: isExpanded,
      onChange: onCheckboxChange,
      label: /*#__PURE__*/React__default.createElement(Fragment, null, "Edit pull secret ", /*#__PURE__*/React__default.createElement(PullSecretInfo, {
        isOcm: isOcm
      }))
    }), isExpanded && /*#__PURE__*/React__default.createElement(PullSecretField, {
      isOcm: isOcm
    }));
  }

  return /*#__PURE__*/React__default.createElement(PullSecretField, {
    isOcm: isOcm
  });
};

var NetworkConfiguration = function NetworkConfiguration(_ref) {
  var cluster = _ref.cluster,
      hostSubnets = _ref.hostSubnets,
      isVipDhcpAllocationDisabled = _ref.isVipDhcpAllocationDisabled,
      defaultNetworkSettings = _ref.defaultNetworkSettings,
      hideManagedNetworking = _ref.hideManagedNetworking,
      children = _ref.children;

  var _useFormikContext = useFormikContext(),
      setFieldValue = _useFormikContext.setFieldValue,
      values = _useFormikContext.values,
      touched = _useFormikContext.touched,
      validateField = _useFormikContext.validateField;

  var _React$useState = React__default.useState(isAdvNetworkConf(cluster, defaultNetworkSettings)),
      isAdvanced = _React$useState[0],
      setAdvanced = _React$useState[1];

  var toggleAdvConfiguration = function toggleAdvConfiguration(checked) {
    setAdvanced(checked);

    if (!checked) {
      setFieldValue('clusterNetworkCidr', defaultNetworkSettings.clusterNetworkCidr);
      setFieldValue('serviceNetworkCidr', defaultNetworkSettings.serviceNetworkCidr);
      setFieldValue('clusterNetworkHostPrefix', defaultNetworkSettings.clusterNetworkHostPrefix);
      setFieldValue('networkType', 'OpenShiftSDN');
    }
  };

  var isMultiNodeCluster = !isSingleNodeCluster(cluster);
  var isUserManagedNetworking = values.managedNetworkingType === 'userManaged';
  useEffect(function () {
    if (isUserManagedNetworking) {
      var shouldValidate = true;
      setFieldValue('vipDhcpAllocation', false);
      setFieldValue('ingressVip', '', !shouldValidate);
      setFieldValue('apiVip', '', !shouldValidate);

      if (!touched.hostSubnet || isMultiNodeCluster) {
        setFieldValue('hostSubnet', NO_SUBNET_SET, !shouldValidate);
      }
    } else {
      if (!values.vipDhcpAllocation) {
        validateField('ingressVip');
        validateField('apiVip');
      }
    }
  }, [touched.hostSubnet, isMultiNodeCluster, isUserManagedNetworking, setFieldValue, values.vipDhcpAllocation, validateField]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, !hideManagedNetworking && /*#__PURE__*/React__default.createElement(ManagedNetworkingControlGroup, {
    disabled: !isMultiNodeCluster
  }), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: isUserManagedNetworking
  }, /*#__PURE__*/React__default.createElement(UserManagedNetworkingTextContent, {
    shouldDisplayLoadBalancersBullet: isMultiNodeCluster
  })), children, /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: !(isMultiNodeCluster && isUserManagedNetworking)
  }, /*#__PURE__*/React__default.createElement(AvailableSubnetsControl, {
    hostSubnets: hostSubnets,
    hosts: cluster.hosts || [],
    isRequired: !isUserManagedNetworking,
    isMultiNodeCluster: isMultiNodeCluster
  })), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: !isUserManagedNetworking
  }, /*#__PURE__*/React__default.createElement(VirtualIPControlGroup, {
    cluster: cluster,
    hostSubnets: hostSubnets,
    isVipDhcpAllocationDisabled: isVipDhcpAllocationDisabled
  })), /*#__PURE__*/React__default.createElement(Checkbox, {
    id: "useAdvancedNetworking",
    label: "Use advanced networking",
    description: "Configure advanced networking properties (e.g. CIDR ranges).",
    isChecked: isAdvanced,
    onChange: toggleAdvConfiguration
  }), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: isAdvanced
  }, /*#__PURE__*/React__default.createElement(AdvancedNetworkFields, null)));
};

var SshPublicKeyHelperText = function SshPublicKeyHelperText(_ref) {
  var _ref$fieldId = _ref.fieldId,
      fieldId = _ref$fieldId === void 0 ? 'sshPublicKey' : _ref$fieldId;
  return /*#__PURE__*/createElement(HelperText, {
    fieldId: fieldId
  }, "SSH key used to debug OpenShift nodes. Generate a new key using ", /*#__PURE__*/createElement("em", null, "ssh-keygen"), " command and upload or paste the resulting public key here (by default it is content of the", ' ', /*#__PURE__*/createElement("em", null, "~/.ssh/id_rsa.pub"), " file).");
};
var label = 'Host SSH Public Key for troubleshooting after installation';

var ClusterSshKeyFields = function ClusterSshKeyFields(_ref2) {
  var clusterSshKey = _ref2.clusterSshKey,
      imageSshKey = _ref2.imageSshKey;

  var _React$useState = useState(false),
      shareSshKey = _React$useState[0],
      setShareSshKey = _React$useState[1];

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values,
      setFieldValue = _useFormikContext.setFieldValue;

  var handleSshKeyBlur = function handleSshKeyBlur() {
    if (values.sshPublicKey) {
      setFieldValue('sshPublicKey', trimSshPublicKey(values.sshPublicKey));
    }
  };

  useEffect(function () {
    if (imageSshKey && (clusterSshKey === imageSshKey || !clusterSshKey)) {
      setShareSshKey(true);
    }
  }, [imageSshKey, clusterSshKey]);
  useEffect(function () {
    if (shareSshKey) {
      setFieldValue('sshPublicKey', imageSshKey);
    }
  }, [shareSshKey, imageSshKey, setFieldValue]);
  var fieldId = getFieldId('shareDiscoverySshKey', 'checkbox');
  return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: label
  }, /*#__PURE__*/createElement(RenderIf, {
    condition: Boolean(imageSshKey)
  }, /*#__PURE__*/createElement(Checkbox, {
    name: "shareDiscoverySshKey",
    id: fieldId,
    label: "Use the same host discovery SSH key",
    "aria-describedby": fieldId + "-helper",
    isChecked: shareSshKey,
    onChange: setShareSshKey
  })), /*#__PURE__*/createElement(RenderIf, {
    condition: !shareSshKey
  }, /*#__PURE__*/createElement(TextAreaField, {
    name: "sshPublicKey",
    helperText: /*#__PURE__*/createElement(SshPublicKeyHelperText, null),
    onBlur: handleSshKeyBlur
  }))));
};

var NetworkConfigurationFormFields = function NetworkConfigurationFormFields(_ref) {
  var props = _extends({}, _ref);

  var cluster = props.cluster;
  return /*#__PURE__*/React__default.createElement(Form, null, /*#__PURE__*/React__default.createElement(NetworkConfiguration, props), /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h2"
  }, "Security")), /*#__PURE__*/React__default.createElement(ClusterSshKeyFields, {
    clusterSshKey: cluster.sshPublicKey,
    imageSshKey: cluster.imageInfo.sshPublicKey
  }));
};

var UploadSSH = function UploadSSH() {
  var _useField = useField('sshPublicKey'),
      _useField$ = _useField[0],
      name = _useField$.name,
      value = _useField$.value,
      setValue = _useField[2].setValue;

  return /*#__PURE__*/createElement(UploadField, {
    label: "SSH public key",
    name: name,
    helperText: /*#__PURE__*/createElement(SshPublicKeyHelperText, null),
    idPostfix: "discovery",
    onBlur: function onBlur() {
      return value && setValue(trimSshPublicKey(value));
    },
    dropzoneProps: {
      accept: '.pub',
      maxSize: 2048,
      onDropRejected: function onDropRejected(_ref) {
        var setError = _ref.setError;
        return function () {
          return setError('File not supported.');
        };
      }
    }
  });
};

var ProxyFields = function ProxyFields() {
  var _useFormikContext = useFormikContext(),
      setFieldValue = _useFormikContext.setFieldValue,
      values = _useFormikContext.values,
      initialValues = _useFormikContext.initialValues;

  var resetProxy = function resetProxy(isNewlyChecked) {
    if (isNewlyChecked) {
      setFieldValue('httpProxy', initialValues.httpProxy);
      setFieldValue('httpsProxy', initialValues.httpsProxy);
      setFieldValue('noProxy', initialValues.noProxy);
    } else {
      setFieldValue('httpProxy', '');
      setFieldValue('httpsProxy', '');
      setFieldValue('noProxy', '');
    }
  };

  var noProxyHelperText = 'A comma-separated list of destination domain names, domains, IP addresses or other network CIDRs to exclude proxying. Preface a domain with . to include all subdomains of that domain. Use * to bypass proxy for all destinations.';

  var onNoProxyBlur = function onNoProxyBlur() {
    if (values.noProxy) {
      setFieldValue('noProxy', trimCommaSeparatedList(values.noProxy));
    }
  };

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(CheckboxField, {
    label: "Configure cluster-wide proxy settings",
    name: "enableProxy",
    helperText: "If hosts are behind a firewall that requires the use of a proxy, provide additional information about the proxy.",
    onChange: function onChange(value) {
      return resetProxy(value);
    }
  }), values.enableProxy && /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(InputField, {
    label: "HTTP Proxy URL",
    name: "httpProxy",
    placeholder: "http://<user>:<password>@<ipaddr>:<port>",
    helperText: /*#__PURE__*/React__default.createElement("div", null, "HTTP proxy URL that agents should use to access the discovery service. The URL scheme ", /*#__PURE__*/React__default.createElement("b", null, "must be http"), ".")
  }), /*#__PURE__*/React__default.createElement(InputField, {
    label: "HTTPS Proxy URL",
    name: "httpsProxy",
    placeholder: "http://<user>:<password>@<ipaddr>:<port>",
    helperText: /*#__PURE__*/React__default.createElement("div", null, "HTTPS proxy URL that agents should use to access the discovery service. If the value is not specified, the HTTP Proxy URL is used as default for both http and https connections. The URL scheme ", /*#__PURE__*/React__default.createElement("b", null, "must be http"), ", the ", /*#__PURE__*/React__default.createElement("i", null, "https"), " is currently not supported.")
  }), /*#__PURE__*/React__default.createElement(InputField, {
    label: "No Proxy domains",
    name: "noProxy",
    placeholder: "one.domain.com,second.domain.com",
    helperText: noProxyHelperText,
    onBlur: onNoProxyBlur
  })));
};

var DownloadIso = function DownloadIso(_ref) {
  var _ref$fileName = _ref.fileName,
      fileName = _ref$fileName === void 0 ? 'discovery.iso' : _ref$fileName,
      downloadUrl = _ref.downloadUrl,
      onClose = _ref.onClose,
      onReset = _ref.onReset;
  var wgetCommand = "wget -O " + fileName + " '" + downloadUrl + "'";
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ModalBoxBody, null, /*#__PURE__*/React__default.createElement(EmptyState$1, {
    variant: EmptyStateVariant.small
  }, /*#__PURE__*/React__default.createElement(EmptyStateIcon, {
    icon: CheckCircleIcon,
    color: global_success_color_100.value
  }), /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h4",
    size: "lg"
  }, "Discovery ISO is ready to download")), /*#__PURE__*/React__default.createElement(DetailList, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Discovery ISO URL",
    value: /*#__PURE__*/React__default.createElement(ClipboardCopy, {
      isReadOnly: true,
      onCopy: function onCopy(event) {
        return clipboardCopyFunc(event, downloadUrl);
      }
    }, downloadUrl)
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Command to download the ISO:",
    value: /*#__PURE__*/React__default.createElement(ClipboardCopy, {
      isReadOnly: true,
      onCopy: function onCopy(event) {
        return clipboardCopyFunc(event, wgetCommand);
      }
    }, wgetCommand)
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Boot instructions",
    value: /*#__PURE__*/React__default.createElement(Fragment, null, "Use a bootable device (local disk, USB drive, etc.) or network booting (PXE) to boot each host ", /*#__PURE__*/React__default.createElement("b", null, "once"), " from the Discovery ISO.")
  })), /*#__PURE__*/React__default.createElement(Alert, {
    variant: "info",
    isInline: true,
    title: 'Never share your downloaded ISO with anyone else. ' + 'Forwarding it could put your credentials and personal data at risk.'
  })), /*#__PURE__*/React__default.createElement(ModalBoxFooter, null, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.primary,
    onClick: function onClick() {
      return downloadUrl && saveAs(downloadUrl);
    },
    "data-testid": "download-iso-btn",
    isDisabled: !downloadUrl
  }, "Download Discovery ISO"), /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.secondary,
    onClick: onClose,
    "data-testid": "close-iso-btn"
  }, "Close"), onReset && /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    onClick: onReset,
    "data-testid": "edit-iso-btn"
  }, "Edit ISO configuration")));
};

var DownloadIsoModal = function DownloadIsoModal(_ref) {
  var isOpen = _ref.isOpen,
      props = _objectWithoutPropertiesLoose(_ref, ["isOpen"]);

  return /*#__PURE__*/React__default.createElement(Modal, {
    "aria-label": "Download host discovery ISO dialog",
    title: "Add Host",
    isOpen: isOpen,
    onClose: props.onClose,
    variant: ModalVariant.small,
    hasNoBodyWrapper: true,
    id: "download-discovery-iso-modal"
  }, /*#__PURE__*/React__default.createElement(DownloadIso, props));
};

var getNetworkInitialValues = function getNetworkInitialValues(cluster, defaultNetworkSettings) {
  return {
    clusterNetworkCidr: cluster.clusterNetworkCidr || defaultNetworkSettings.clusterNetworkCidr,
    clusterNetworkHostPrefix: cluster.clusterNetworkHostPrefix || defaultNetworkSettings.clusterNetworkHostPrefix,
    serviceNetworkCidr: cluster.serviceNetworkCidr || defaultNetworkSettings.serviceNetworkCidr,
    apiVip: cluster.apiVip || '',
    ingressVip: cluster.ingressVip || '',
    sshPublicKey: cluster.sshPublicKey || '',
    hostSubnet: getSubnetFromMachineNetworkCidr(cluster.machineNetworkCidr),
    vipDhcpAllocation: cluster.vipDhcpAllocation,
    managedNetworkingType: cluster.userManagedNetworking ? 'userManaged' : 'clusterManaged',
    networkType: cluster.networkType || 'OpenShiftSDN'
  };
};
var getNetworkConfigurationValidationSchema = function getNetworkConfigurationValidationSchema(initialValues, hostSubnets) {
  return lazy(function (values) {
    return object().shape({
      clusterNetworkHostPrefix: hostPrefixValidationSchema(values),
      clusterNetworkCidr: ipBlockValidationSchema,
      serviceNetworkCidr: ipBlockValidationSchema,
      apiVip: vipValidationSchema(hostSubnets, values, initialValues.apiVip),
      ingressVip: vipValidationSchema(hostSubnets, values, initialValues.ingressVip),
      sshPublicKey: sshPublicKeyValidationSchema
    });
  });
};

var HostsNotShowingLink = function HostsNotShowingLink(_ref) {
  var setDiscoveryHintModalOpen = _ref.setDiscoveryHintModalOpen;
  return /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return setDiscoveryHintModalOpen(true);
    },
    isInline: true
  }, /*#__PURE__*/React__default.createElement(InfoCircleIcon, {
    size: "sm"
  }), "\xA0Hosts not showing up?");
};
var DiscoveryTroubleshootingModal = function DiscoveryTroubleshootingModal(_ref2) {
  var setDiscoveryHintModalOpen = _ref2.setDiscoveryHintModalOpen,
      isOpen = _ref2.isOpen;
  var onClose = React__default.useCallback(function () {
    return setDiscoveryHintModalOpen(false);
  }, [setDiscoveryHintModalOpen]);
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "Troubleshooting Host Discovery Issues",
    isOpen: isOpen,
    actions: [/*#__PURE__*/React__default.createElement(Button, {
      key: "close",
      variant: ButtonVariant.primary,
      onClick: onClose
    }, "Close")],
    onClose: onClose,
    variant: ModalVariant.large
  }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "To troubleshoot host discovery issues, complete the following steps:"), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Verify that your host machine is powered on"), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "Note: Boot time depends on several factors such as your hardware and network configuration, and if you are booting from an ISO."), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Verify if DHCP is enabled"), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "SSH into your machine"), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "Verify that you can access your host machine using SSH, or a console such as BMC or virtual machine console. In the CLI, enter the following command:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "ssh -i <identity_file> core@<machine-ip>"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "NOTE: Authentication is provided by the discovery ISO, therefore when you access your host using SSH, a password is not required. Optional -i parameter can be used to specify the private key that matches the public key provided when generating Discovery ISO."), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Verify that the discovery agent is running with the correct parameters"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "ps -ef | grep agent"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "The output displays the following:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "root        1786       1  0 08:03 ?        00:00:00 /usr/local/bin/agent --url https://api.openshift.com --cluster-id e4c85fbe-77c7-411e-b107-5120f615c4fb --agent-version registry.redhat.io/openshift4/assisted-installer-agent-rhel8:v4.6.0-17 --insecure=false\ncore        2362    2311  0 08:04 pts/0    00:00:00 grep --color=auto agent"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Verify that the agent ran successfully"), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "To verify that the agent ran successfully, check the logs:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "sudo journalctl -u agent.service"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "In the following example, the errors indicate there is a network issue:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "Oct 15 11:26:35 localhost systemd[1]: agent.service: Service RestartSec=3s expired, scheduling restart.\nOct 15 11:26:35 localhost systemd[1]: agent.service: Scheduled restart job, restart counter is at 9.\nOct 15 11:26:35 localhost systemd[1]: Stopped agent.service.\nOct 15 11:26:35 localhost systemd[1]: Starting agent.service...\nOct 15 11:26:35 localhost podman[1834]: Trying to pull quay.io/ocpmetal/assisted-installer-agent:latest...\nOct 15 11:26:35 localhost podman[1834]:   Get \"https://quay.io/v2/\": dial tcp: lookup quay.io on [::1]:53: read udp [::1]:58297->[::1]:53: read: connection refused\nOct 15 11:26:35 localhost podman[1834]: Error: unable to pull quay.io/ocpmetal/assisted-installer-agent:latest: unable to pull image: Error initializing source docker://quay.io/ocpmetal/assisted-installer-agent:latest: error pinging dock>\nOct 15 11:26:35 localhost systemd[1]: agent.service: Control process exited, code=exited status=125\nOct 15 11:26:35 localhost systemd[1]: agent.service: Failed with result 'exit-code'.\nOct 15 11:26:35 localhost systemd[1]: Failed to start agent.service."
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "Check the proxy settings and verify that the assisted installer service is connected to a network. You can use ", /*#__PURE__*/React__default.createElement("code", null, "nmcli"), " to get additional information about your network configuration."), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Check agent logs"), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "To view detailed agent logs and communication use following command:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "sudo journalctl TAG=agent | less"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Check assisted-installer logs"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "sudo su\npodman ps -a | grep assisted-installer\npodman logs <container id>"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.h2
  }, "Check bootkube logs"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "sudo journalctl -u bootkube"
  })));
};

var BaseDnsHelperText = function BaseDnsHelperText(_ref) {
  var name = _ref.name,
      baseDnsDomain = _ref.baseDnsDomain;
  return /*#__PURE__*/createElement(Fragment, null, "All DNS records must be subdomains of this base and include the cluster name. This cannot be changed after cluster installation. The full cluster address will be: ", /*#__PURE__*/createElement("br", null), /*#__PURE__*/createElement("strong", null, name || '[Cluster Name]', ".", baseDnsDomain || '[example.com]'));
};

var ClusterDetailsFormFields = function ClusterDetailsFormFields(_ref2) {
  var _ref2$managedDomains = _ref2.managedDomains,
      managedDomains = _ref2$managedDomains === void 0 ? [] : _ref2$managedDomains,
      toggleRedHatDnsService = _ref2.toggleRedHatDnsService,
      canEditPullSecret = _ref2.canEditPullSecret,
      isSNOGroupDisabled = _ref2.isSNOGroupDisabled,
      isNameDisabled = _ref2.isNameDisabled,
      isBaseDnsDomainDisabled = _ref2.isBaseDnsDomainDisabled,
      versions = _ref2.versions,
      defaultPullSecret = _ref2.defaultPullSecret,
      forceOpenshiftVersion = _ref2.forceOpenshiftVersion,
      extensionAfter = _ref2.extensionAfter,
      isOcm = _ref2.isOcm;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  var name = values.name,
      baseDnsDomain = values.baseDnsDomain,
      highAvailabilityMode = values.highAvailabilityMode,
      useRedHatDnsService = values.useRedHatDnsService;
  var nameInputRef = useRef();
  useEffect(function () {
    var _nameInputRef$current;

    (_nameInputRef$current = nameInputRef.current) === null || _nameInputRef$current === void 0 ? void 0 : _nameInputRef$current.focus();
  }, []);
  return /*#__PURE__*/createElement(Form, {
    id: "wizard-cluster-details__form"
  }, /*#__PURE__*/createElement(InputField, {
    ref: nameInputRef,
    label: "Cluster name",
    name: "name",
    placeholder: isOcm ? '' : 'Enter cluster name',
    isDisabled: isNameDisabled,
    isRequired: true
  }), (extensionAfter === null || extensionAfter === void 0 ? void 0 : extensionAfter['name']) && extensionAfter['name'], !!managedDomains.length && toggleRedHatDnsService && /*#__PURE__*/createElement(CheckboxField, {
    name: "useRedHatDnsService",
    label: "Use a temporary 60-day domain",
    helperText: "A base domain will be provided for temporary, non-production clusters.",
    onChange: toggleRedHatDnsService
  }), useRedHatDnsService ? /*#__PURE__*/createElement(SelectField, {
    label: "Base domain",
    name: "baseDnsDomain",
    helperText: /*#__PURE__*/createElement(BaseDnsHelperText, {
      name: name,
      baseDnsDomain: baseDnsDomain
    }),
    options: managedDomains.map(function (d) {
      return {
        label: d.domain + " (" + d.provider + ")",
        value: d.domain
      };
    }),
    isRequired: true
  }) : /*#__PURE__*/createElement(InputField, {
    label: "Base domain",
    name: "baseDnsDomain",
    helperText: /*#__PURE__*/createElement(BaseDnsHelperText, {
      name: name,
      baseDnsDomain: baseDnsDomain
    }),
    placeholder: "example.com",
    isDisabled: isBaseDnsDomainDisabled || useRedHatDnsService,
    isRequired: true
  }), /*#__PURE__*/createElement(SNOControlGroup, {
    isDisabled: isSNOGroupDisabled,
    versions: versions,
    highAvailabilityMode: highAvailabilityMode
  }), forceOpenshiftVersion ? /*#__PURE__*/createElement(StaticTextField, {
    name: "openshiftVersion",
    label: "OpenShift version",
    isRequired: true
  }, "OpenShift ", forceOpenshiftVersion) : /*#__PURE__*/createElement(OpenShiftVersionSelect, {
    versions: versions
  }), (extensionAfter === null || extensionAfter === void 0 ? void 0 : extensionAfter['openshiftVersion']) && extensionAfter['openshiftVersion'], canEditPullSecret && /*#__PURE__*/createElement(PullSecret, {
    isOcm: isOcm,
    defaultPullSecret: defaultPullSecret
  }));
};

var getClusterDetailsInitialValues = function getClusterDetailsInitialValues(_ref) {
  var cluster = _ref.cluster,
      pullSecret = _ref.pullSecret,
      managedDomains = _ref.managedDomains,
      ocpVersions = _ref.ocpVersions,
      baseDomain = _ref.baseDomain;

  var _ref2 = cluster || {},
      _ref2$name = _ref2.name,
      name = _ref2$name === void 0 ? '' : _ref2$name,
      _ref2$highAvailabilit = _ref2.highAvailabilityMode,
      highAvailabilityMode = _ref2$highAvailabilit === void 0 ? 'Full' : _ref2$highAvailabilit,
      _ref2$baseDnsDomain = _ref2.baseDnsDomain,
      baseDnsDomain = _ref2$baseDnsDomain === void 0 ? baseDomain || '' : _ref2$baseDnsDomain,
      _ref2$openshiftVersio = _ref2.openshiftVersion,
      openshiftVersion = _ref2$openshiftVersio === void 0 ? getDefaultOpenShiftVersion(ocpVersions) : _ref2$openshiftVersio;

  return {
    name: name,
    highAvailabilityMode: highAvailabilityMode,
    openshiftVersion: openshiftVersion,
    pullSecret: pullSecret || '',
    baseDnsDomain: baseDnsDomain,
    SNODisclaimer: highAvailabilityMode === 'None',
    useRedHatDnsService: !!baseDnsDomain && managedDomains.map(function (d) {
      return d.domain;
    }).includes(baseDnsDomain)
  };
};
var getClusterDetailsValidationSchema = function getClusterDetailsValidationSchema(usedClusterNames, cluster, ocpVersions) {
  return lazy(function (values) {
    if (cluster === null || cluster === void 0 ? void 0 : cluster.pullSecretSet) {
      return object({
        name: nameValidationSchema(usedClusterNames, values.baseDnsDomain),
        baseDnsDomain: dnsNameValidationSchema.required('Required')
      });
    }

    return object({
      name: nameValidationSchema(usedClusterNames, values.baseDnsDomain),
      pullSecret: pullSecretValidationSchema.required('Required.'),
      baseDnsDomain: dnsNameValidationSchema.required('Required'),
      SNODisclaimer: boolean().when(['highAvailabilityMode', 'openshiftVersion'], {
        is: function is(highAvailabilityMode, openshiftVersion) {
          var selectedVersion = (ocpVersions || []).find(function (v) {
            return v.value === openshiftVersion;
          });
          return highAvailabilityMode === 'None' && getSNOSupportLevel(selectedVersion === null || selectedVersion === void 0 ? void 0 : selectedVersion.version) !== 'supported';
        },
        then: bool().oneOf([true], 'Confirm the Single Node OpenShift disclaimer to continue.')
      })
    });
  });
};

var ListItem = function ListItem(_ref) {
  var item = _ref.item;
  return /*#__PURE__*/React__default.createElement(DescriptionListGroup, null, /*#__PURE__*/React__default.createElement(DescriptionListTerm, null, item.key), /*#__PURE__*/React__default.createElement(DescriptionListDescription, null, item.value || DASH));
};

var ClusterPropertiesList = function ClusterPropertiesList(_ref2) {
  var leftItems = _ref2.leftItems,
      _ref2$rightItems = _ref2.rightItems,
      rightItems = _ref2$rightItems === void 0 ? [] : _ref2$rightItems;
  return /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, {
    span: rightItems.length ? 6 : 12
  }, /*#__PURE__*/React__default.createElement(DescriptionList, null, leftItems.map(function (item) {
    return /*#__PURE__*/React__default.createElement(ListItem, {
      key: item.key,
      item: item
    });
  }))), rightItems.length && /*#__PURE__*/React__default.createElement(GridItem, {
    span: 6
  }, /*#__PURE__*/React__default.createElement(DescriptionList, null, rightItems.map(function (item) {
    return /*#__PURE__*/React__default.createElement(ListItem, {
      key: item.key,
      item: item
    });
  }))));
};

var Hostname = function Hostname(_ref) {
  var host = _ref.host,
      _ref$inventory = _ref.inventory,
      inventory = _ref$inventory === void 0 ? {} : _ref$inventory,
      onEditHostname = _ref.onEditHostname,
      title = _ref.title,
      className = _ref.className,
      hosts = _ref.hosts;
  var hostname = title || getHostname(host, inventory) || DASH;
  var isHostnameChangeRequested = !title && host.requestedHostname !== inventory.hostname;
  var isNotLocalhost = hostname !== 'localhost';
  var isUnique = hosts ? !hosts.find(function (h) {
    var hostInventory = stringToJSON(h.inventory || '') || {};
    return h.id !== host.id && getHostname(h, hostInventory) === hostname;
  }) : true;
  var isValid = isUnique && isNotLocalhost;
  var body = /*#__PURE__*/React__default.createElement(Flex, {
    alignItems: {
      "default": 'alignItemsCenter'
    }
  }, onEditHostname && !isValid && /*#__PURE__*/React__default.createElement(FlexItem, {
    className: 'pf-u-mr-xs'
  }, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
    color: global_warning_color_100.value
  })), /*#__PURE__*/React__default.createElement(FlexItem, null, hostname, isHostnameChangeRequested && ' *'));
  return onEditHostname ? isValid ? /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true,
    onClick: onEditHostname,
    className: className
  }, body) : /*#__PURE__*/React__default.createElement(Popover, {
    headerContent: /*#__PURE__*/React__default.createElement(Flex, {
      alignItems: {
        "default": 'alignItemsCenter'
      }
    }, /*#__PURE__*/React__default.createElement(FlexItem, {
      className: 'pf-u-mr-xs'
    }, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
      color: global_warning_color_100.value
    })), /*#__PURE__*/React__default.createElement(FlexItem, null, "Hostname is not valid")),
    bodyContent: !isNotLocalhost ? 'Hostname can not be localhost' : 'Hostname is not unique',
    footerContent: /*#__PURE__*/React__default.createElement(Button, {
      variant: ButtonVariant.link,
      isInline: true,
      className: className,
      onClick: onEditHostname
    }, "Change hostname"),
    minWidth: "30rem",
    maxWidth: "50rem",
    hideOnOutsideClick: true,
    zIndex: 300
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true,
    className: className
  }, body)) : body;
};

var ValidationGroupAlert = function ValidationGroupAlert(_ref) {
  var variant = _ref.variant,
      validations = _ref.validations,
      title = _ref.title,
      onEditHostname = _ref.onEditHostname,
      AdditionalNTPSourcesDialogToggleComponent = _ref.AdditionalNTPSourcesDialogToggleComponent,
      props = _objectWithoutPropertiesLoose(_ref, ["variant", "validations", "title", "onEditHostname", "AdditionalNTPSourcesDialogToggleComponent"]);

  var isValidHostname = true;

  if (!validations.length) {
    return null;
  }

  var actionLinks = [];

  if (validations.find(function (validation) {
    return validation.status === 'failure' && ['hostname-unique', 'hostname-valid'].includes(validation.id);
  })) {
    actionLinks.push( /*#__PURE__*/React__default.createElement(Hostname, _extends({
      key: "change-hostname",
      title: "Change hostname",
      onEditHostname: onEditHostname
    }, props)));
    isValidHostname = false;
  }

  if (AdditionalNTPSourcesDialogToggleComponent && validations.find(function (validation) {
    return validation.status === 'failure' && validation.id === 'ntp-synced';
  })) {
    actionLinks.push( /*#__PURE__*/React__default.createElement(AdditionalNTPSourcesDialogToggleComponent, {
      key: "add-ntp-sources"
    }));
  }

  return /*#__PURE__*/React__default.createElement(Alert, {
    title: title,
    variant: variant,
    actionLinks: actionLinks,
    isInline: true
  }, /*#__PURE__*/React__default.createElement("ul", null, validations.map(function (v) {
    return /*#__PURE__*/React__default.createElement("li", {
      key: v.id
    }, /*#__PURE__*/React__default.createElement("strong", null, HOST_VALIDATION_LABELS[v.id] || v.id, ":"), "\xA0", toSentence(v.message), ' ', v.status === 'failure' && HOST_VALIDATION_FAILURE_HINTS[v.id]);
  })), !isValidHostname && /*#__PURE__*/React__default.createElement("span", null, "To fix this click the \"Change hostname\" link and rename the host."));
};

var HostValidationGroups = function HostValidationGroups(_ref2) {
  var validationsInfo = _ref2.validationsInfo,
      props = _objectWithoutPropertiesLoose(_ref2, ["validationsInfo"]);

  return /*#__PURE__*/React__default.createElement(Fragment$1, null, Object.keys(validationsInfo).map(function (groupName) {
    var groupLabel = HOST_VALIDATION_GROUP_LABELS[groupName];
    var pendingValidations = validationsInfo[groupName].filter(function (v) {
      return v.status === 'pending';
    });
    var failedValidations = validationsInfo[groupName].filter(function (v) {
      return v.status === 'failure' || v.status === 'error';
    });

    var getValidationGroupState = function getValidationGroupState() {
      if (pendingValidations.length) {
        return /*#__PURE__*/React__default.createElement(Fragment$1, null, "Pending input ", /*#__PURE__*/React__default.createElement(PendingIcon, null));
      } else if (failedValidations.length) {
        return /*#__PURE__*/React__default.createElement(Fragment$1, null, "Failed ", /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
          color: global_warning_color_100.value
        }));
      }

      return /*#__PURE__*/React__default.createElement(Fragment$1, null, "Ready ", /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
        color: global_success_color_100.value
      }));
    };

    return /*#__PURE__*/React__default.createElement(Fragment$1, {
      key: groupName
    }, /*#__PURE__*/React__default.createElement(Level, {
      className: "host-validation-groups__validation-group"
    }, /*#__PURE__*/React__default.createElement(LevelItem, null, /*#__PURE__*/React__default.createElement("strong", null, groupLabel)), /*#__PURE__*/React__default.createElement(LevelItem, null, getValidationGroupState())), /*#__PURE__*/React__default.createElement(AlertGroup, null, !failedValidations.length &&
    /*#__PURE__*/
    React__default.createElement(ValidationGroupAlert, _extends({
      variant: AlertVariant.info,
      title: "Pending validations:",
      validations: pendingValidations
    }, props)), /*#__PURE__*/React__default.createElement(ValidationGroupAlert, _extends({
      variant: AlertVariant.warning,
      title: "Failed validations:",
      validations: failedValidations
    }, props))));
  }));
};

// A type of promise-like that resolves synchronously and supports only one observer

const _iteratorSymbol = /*#__PURE__*/ typeof Symbol !== "undefined" ? (Symbol.iterator || (Symbol.iterator = Symbol("Symbol.iterator"))) : "@@iterator";

const _asyncIteratorSymbol = /*#__PURE__*/ typeof Symbol !== "undefined" ? (Symbol.asyncIterator || (Symbol.asyncIterator = Symbol("Symbol.asyncIterator"))) : "@@asyncIterator";

// Asynchronously call a function and send errors to recovery continuation
function _catch(body, recover) {
	try {
		var result = body();
	} catch(e) {
		return recover(e);
	}
	if (result && result.then) {
		return result.then(void 0, recover);
	}
	return result;
}

// Asynchronously await a promise and pass the result to a finally continuation
function _finallyRethrows(body, finalizer) {
	try {
		var result = body();
	} catch (e) {
		return finalizer(true, e);
	}
	if (result && result.then) {
		return result.then(finalizer.bind(null, false), finalizer.bind(null, true));
	}
	return finalizer(false, result);
}

var RoleDropdown = function RoleDropdown(_ref) {
  var host = _ref.host,
      onEditRole = _ref.onEditRole;

  var _React$useState = React__default.useState(false),
      isDisabled = _React$useState[0],
      setDisabled = _React$useState[1];

  var setRole = function setRole(role) {
    try {
      setDisabled(true);

      var _temp2 = _finallyRethrows(function () {
        return Promise.resolve(onEditRole(role)).then(function () {});
      }, function (_wasThrown, _result) {
        setDisabled(false);
        if (_wasThrown) throw _result;
        return _result;
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(SimpleDropdown, {
    defaultValue: HOST_ROLES[0].value,
    current: getHostRole(host),
    items: HOST_ROLES,
    setValue: setRole,
    isDisabled: isDisabled,
    idPrefix: "role-" + host.requestedHostname
  });
};

var RoleCell = function RoleCell(_ref) {
  var host = _ref.host,
      role = _ref.role,
      _ref$readonly = _ref.readonly,
      readonly = _ref$readonly === void 0 ? false : _ref$readonly,
      onEditRole = _ref.onEditRole;
  return !readonly && onEditRole ? /*#__PURE__*/React__default.createElement(RoleDropdown, {
    host: host,
    onEditRole: onEditRole
  }) : /*#__PURE__*/React__default.createElement(Fragment, null, role);
};

var HostsCount = function HostsCount(_ref) {
  var cluster = _ref.cluster,
      _ref$inParenthesis = _ref.inParenthesis,
      inParenthesis = _ref$inParenthesis === void 0 ? false : _ref$inParenthesis,
      _ref$valueId = _ref.valueId,
      valueId = _ref$valueId === void 0 ? 'hosts-count' : _ref$valueId;
  var body = /*#__PURE__*/React__default.createElement(Fragment, null, 'readyHostCount' in cluster && /*#__PURE__*/React__default.createElement(Level, null, /*#__PURE__*/React__default.createElement(LevelItem, null, "Ready for the installation"), /*#__PURE__*/React__default.createElement(LevelItem, null, getReadyHostCount(cluster))), 'enabledHostCount' in cluster && /*#__PURE__*/React__default.createElement(Level, null, /*#__PURE__*/React__default.createElement(LevelItem, null, "Enabled for the installation"), /*#__PURE__*/React__default.createElement(LevelItem, null, getEnabledHostCount(cluster))), /*#__PURE__*/React__default.createElement(Level, null, /*#__PURE__*/React__default.createElement(LevelItem, null, "All discovered"), /*#__PURE__*/React__default.createElement(LevelItem, null, getTotalHostCount(cluster))));
  var summary = 'enabledHostCount' in cluster ? getEnabledHostCount(cluster) : getTotalHostCount(cluster);
  return /*#__PURE__*/React__default.createElement(Popover, {
    headerContent: "Hosts in the cluster",
    bodyContent: body
  }, /*#__PURE__*/React__default.createElement("a", {
    id: valueId
  }, inParenthesis && '(', summary, inParenthesis && ')'));
};

var getProgressVariant = function getProgressVariant(status) {
  switch (status) {
    case 'cancelled':
    case 'error':
      return ProgressVariant.danger;

    case 'installed':
      return ProgressVariant.success;

    default:
      return undefined;
  }
};

var getMeasureLocation = function getMeasureLocation(status) {
  return status === 'installed' ? ProgressMeasureLocation.none : ProgressMeasureLocation.top;
};

var HostProgress = function HostProgress(_ref) {
  var host = _ref.host;
  var status = host.status;
  var stages = getHostProgressStages(host);

  var _getHostProgress = getHostProgress(host),
      currentStage = _getHostProgress.currentStage,
      progressInfo = _getHostProgress.progressInfo;

  var currentStageNumber = getHostProgressStageNumber(host);
  var progressLabel = currentStage + (progressInfo ? ": " + progressInfo : ' ');
  return /*#__PURE__*/React__default.createElement(Progress, {
    title: progressLabel,
    value: currentStageNumber,
    min: 1,
    max: stages.length,
    label: "Step " + currentStageNumber + " of " + stages.length,
    valueText: "Step " + currentStageNumber + " of " + stages.length + ": " + progressLabel,
    variant: getProgressVariant(status),
    measureLocation: getMeasureLocation(status),
    size: ProgressSize.sm
  });
};

var AddHostsContext = React__default.createContext({});
var AddHostsContextProvider = function AddHostsContextProvider(_ref) {
  var cluster = _ref.cluster,
      ocpConsoleUrl = _ref.ocpConsoleUrl,
      children = _ref.children;
  return /*#__PURE__*/React__default.createElement(AddHostsContext.Provider, {
    value: {
      cluster: cluster,
      ocpConsoleUrl: ocpConsoleUrl
    }
  }, children);
};

var OcpConsoleNodesSectionLink = function OcpConsoleNodesSectionLink(_ref) {
  var id = _ref.id,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'OpenShift console' : _ref$title;

  var _ref2 = React__default.useContext(AddHostsContext) || {},
      ocpConsoleUrl = _ref2.ocpConsoleUrl;

  if (!ocpConsoleUrl) {
    return null;
  }

  return /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return window.open(getOcpConsoleNodesPage(ocpConsoleUrl), '_blank', 'noopener noreferrer');
    },
    id: id
  }, title, " ", /*#__PURE__*/React__default.createElement(ExternalLinkAltIcon, null));
};

var getStatusIcon = function getStatusIcon(status) {
  var icon = null;

  switch (status) {
    case 'discovering':
    case 'discovering-unbound':
      icon = /*#__PURE__*/React__default.createElement(ConnectedIcon, null);
      break;

    case 'pending-for-input':
      icon = /*#__PURE__*/React__default.createElement(PendingIcon, null);
      break;

    case 'disconnected':
    case 'disconnected-unbound':
      icon = /*#__PURE__*/React__default.createElement(DisconnectedIcon, null);
      break;

    case 'cancelled':
    case 'disabled':
    case 'disabled-unbound':
      icon = /*#__PURE__*/React__default.createElement(BanIcon, null);
      break;

    case 'error':
      icon = /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
        color: global_danger_color_100.value
      });
      break;

    case 'resetting-pending-user-action':
    case 'insufficient':
    case 'insufficient-unbound':
    case 'installing-pending-user-action':
      icon = /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
        color: global_warning_color_100.value
      });
      break;

    case 'known':
    case 'known-unbound':
    case 'installed':
      icon = /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
        color: global_success_color_100.value
      });
      break;

    case 'preparing-for-installation':
    case 'preparing-successful':
    case 'installing':
    case 'installing-in-progress':
    case 'resetting':
      icon = /*#__PURE__*/React__default.createElement(InProgressIcon, null);
      break;

    case 'added-to-existing-cluster':
      icon = /*#__PURE__*/React__default.createElement(AddCircleOIcon, null);
      break;

    default:
      icon = /*#__PURE__*/React__default.createElement(UnknownIcon, null);
  }

  return icon;
};

var withProgress = function withProgress(title, currentStage, totalStages, status) {
  var shouldAppendProgress = ['installing', 'installing-in-progress', 'error', 'cancelled'].includes(status || '');
  return shouldAppendProgress ? title + " " + currentStage + "/" + totalStages : title;
};

var HostStatusPopoverContent = function HostStatusPopoverContent(_ref) {
  var statusOverride = _ref.statusOverride,
      props = _objectWithoutPropertiesLoose(_ref, ["statusOverride"]);

  if (statusOverride === 'Bound') {
    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, "This host is bound to the cluster."));
  }

  var host = props.host;
  var status = host.status,
      statusInfo = host.statusInfo;
  var statusDetails = HOST_STATUS_DETAILS[status];

  if (status === 'added-to-existing-cluster') {
    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, "This host was successfully installed.", /*#__PURE__*/React__default.createElement("br", null), "To finish adding it to the cluster, approve its request to join in the Nodes section of the OpenShift console. It might take a few minutes till the node request gets available."));
  }

  if (['installing', 'installing-in-progress'].includes(status)) {
    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(HostProgress, {
      host: host
    }));
  }

  if (['error', 'cancelled', 'installing-pending-user-action'].includes(status)) {
    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, statusDetails, /*#__PURE__*/React__default.createElement("br", null), toSentence(statusInfo)), /*#__PURE__*/React__default.createElement(HostProgress, {
      host: host
    }));
  }

  if (['installed'].includes(status)) {
    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, statusDetails), /*#__PURE__*/React__default.createElement(HostProgress, {
      host: host
    }));
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, statusDetails && /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, statusDetails)), /*#__PURE__*/React__default.createElement(HostValidationGroups, props));
};

var HostStatusPopoverFooter = function HostStatusPopoverFooter(_ref2) {
  var host = _ref2.host;
  var progress = host.progress,
      statusUpdatedAt = host.statusUpdatedAt;

  if (host.status === 'added-to-existing-cluster') {
    return /*#__PURE__*/React__default.createElement(OcpConsoleNodesSectionLink, {
      id: "host-status-detail-link-to-ocp-nodes-" + (host.requestedHostname || host.id)
    });
  }

  var footerText;

  if (host.status === 'installing-in-progress') {
    if ((progress === null || progress === void 0 ? void 0 : progress.stageUpdatedAt) && progress.stageUpdatedAt != progress.stageStartedAt) {
      footerText = "Step started at " + getHumanizedDateTime(progress.stageStartedAt) + ", updated " + hdate.relativeTime(progress.stageUpdatedAt);
    } else {
      footerText = "Step started at " + getHumanizedDateTime((progress === null || progress === void 0 ? void 0 : progress.stageStartedAt) || statusUpdatedAt);
    }
  } else if (statusUpdatedAt) {
    footerText = "Status updated at " + getHumanizedDateTime(statusUpdatedAt);
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, !!footerText && /*#__PURE__*/React__default.createElement("small", null, footerText));
};

var WithHostStatusPopover = function WithHostStatusPopover(props) {
  return /*#__PURE__*/React__default.createElement(Popover, {
    headerContent: /*#__PURE__*/React__default.createElement("div", null, props.title),
    bodyContent: /*#__PURE__*/React__default.createElement(HostStatusPopoverContent, props),
    footerContent: /*#__PURE__*/React__default.createElement(HostStatusPopoverFooter, {
      host: props.host
    }),
    minWidth: "30rem",
    maxWidth: "50rem",
    hideOnOutsideClick: props.hideOnOutsideClick,
    zIndex: 300
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: 'link',
    isInline: true,
    isSmall: props.isSmall
  }, props.children));
};

var HostStatus = function HostStatus(_ref3) {
  var host = _ref3.host,
      validationsInfo = _ref3.validationsInfo,
      statusOverride = _ref3.statusOverride,
      sublabel = _ref3.sublabel,
      onEditHostname = _ref3.onEditHostname,
      AdditionalNTPSourcesDialogToggleComponent = _ref3.AdditionalNTPSourcesDialogToggleComponent;

  var _React$useState = React__default.useState(false),
      keepOnOutsideClick = _React$useState[0],
      onValidationActionToggle = _React$useState[1];

  var status = statusOverride || host.status || '';
  var title = HOST_STATUS_LABELS[status] || status;
  var icon = getStatusIcon(status);
  var stages = getHostProgressStages(host);
  var stageNumber = getHostProgressStageNumber(host);
  var toggleHostname = React__default.useCallback(function () {
    onValidationActionToggle(!keepOnOutsideClick);
    onEditHostname === null || onEditHostname === void 0 ? void 0 : onEditHostname();
  }, [keepOnOutsideClick, onEditHostname]);
  sublabel = sublabel || ['installing-pending-user-action', 'disconnected'].includes(status) && 'Action required' || status === 'added-to-existing-cluster' && 'Finish in console' || undefined;
  var titleWithProgress = withProgress(title, stageNumber, stages.length, status);
  return /*#__PURE__*/React__default.createElement(Flex, {
    alignItems: {
      "default": 'alignItemsCenter'
    }
  }, icon && /*#__PURE__*/React__default.createElement(FlexItem, {
    className: 'pf-u-mr-xs'
  }, icon), /*#__PURE__*/React__default.createElement(Flex, {
    direction: {
      "default": 'column'
    }
  }, !sublabel && status !== 'Discovered' ? /*#__PURE__*/React__default.createElement(WithHostStatusPopover, {
    hideOnOutsideClick: !keepOnOutsideClick,
    host: host,
    onEditHostname: toggleHostname,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggleComponent,
    title: title,
    validationsInfo: validationsInfo,
    statusOverride: status
  }, titleWithProgress) : /*#__PURE__*/React__default.createElement(FlexItem, {
    className: 'pf-u-mb-0'
  }, titleWithProgress), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: Boolean(sublabel)
  }, /*#__PURE__*/React__default.createElement(FlexItem, {
    className: 'pf-u-font-size-xs',
    style: {
      marginTop: 'calc(-1 * var(--pf-l-flex--spacer--xs))'
    }
  }, /*#__PURE__*/React__default.createElement(WithHostStatusPopover, {
    hideOnOutsideClick: !keepOnOutsideClick,
    host: host,
    onEditHostname: toggleHostname,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggleComponent,
    title: title,
    validationsInfo: validationsInfo,
    statusOverride: status
  }, sublabel)))));
};

var validationSchema = function validationSchema(initialValues, usedHostnames) {
  if (usedHostnames === void 0) {
    usedHostnames = [];
  }

  return object().shape({
    hostname: hostnameValidationSchema.concat(uniqueHostnameValidationSchema(initialValues.hostname, usedHostnames).notOneOf(['localhost', 'localhost.localdomain'], 'Hostname ${value} is not allowed.'))
  });
};

var EditHostForm = function EditHostForm(_ref) {
  var host = _ref.host,
      inventory = _ref.inventory,
      usedHostnames = _ref.usedHostnames,
      onCancel = _ref.onCancel,
      onSave = _ref.onSave,
      onFormSaveError = _ref.onFormSaveError;
  var hostnameInputRef = React__default.useRef();
  React__default.useEffect(function () {
    var _hostnameInputRef$cur;

    return (_hostnameInputRef$cur = hostnameInputRef.current) === null || _hostnameInputRef$cur === void 0 ? void 0 : _hostnameInputRef$cur.focus();
  }, []);
  var requestedHostname = host.requestedHostname;
  var hostname = inventory.hostname;
  var initialValues = {
    hostId: host.id,
    hostname: requestedHostname || ''
  };
  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    initialStatus: {
      error: null
    },
    validationSchema: validationSchema(initialValues, usedHostnames),
    onSubmit: function onSubmit(values, formikActions) {
      try {
        if (values.hostname === initialValues.hostname) {
          onCancel();
          return Promise.resolve();
        }

        var _temp2 = _catch(function () {
          return Promise.resolve(onSave(values)).then(function () {
            onCancel();
          });
        }, function (e) {
          var message = onFormSaveError(e);
          formikActions.setStatus({
            error: {
              title: 'Failed to update host',
              message: message
            }
          });
        });

        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    }
  }, function (_ref2) {
    var handleSubmit = _ref2.handleSubmit,
        status = _ref2.status,
        setStatus = _ref2.setStatus,
        isSubmitting = _ref2.isSubmitting,
        isValid = _ref2.isValid,
        dirty = _ref2.dirty;
    return /*#__PURE__*/React__default.createElement(Form, {
      onSubmit: handleSubmit
    }, /*#__PURE__*/React__default.createElement(ModalBoxBody, null, /*#__PURE__*/React__default.createElement(GridGap, null, status.error && /*#__PURE__*/React__default.createElement(Alert, {
      variant: AlertVariant.danger,
      title: status.error.title,
      actionClose: /*#__PURE__*/React__default.createElement(AlertActionCloseButton, {
        onClose: function onClose() {
          return setStatus({
            error: null
          });
        }
      }),
      isInline: true
    }, status.error.message), /*#__PURE__*/React__default.createElement(StaticTextField, {
      name: "discoveredHostname",
      label: "Discovered Hostname"
    }, hostname || ''), /*#__PURE__*/React__default.createElement(InputField, {
      label: "Requested Hostname",
      name: "hostname",
      ref: hostnameInputRef,
      helperText: "This name will replace the original discovered hostname after installation.",
      isRequired: true,
      isDisabled: !canHostnameBeChanged(host.status)
    }))), /*#__PURE__*/React__default.createElement(ModalBoxFooter, null, /*#__PURE__*/React__default.createElement(Button, {
      key: "submit",
      type: ButtonType.submit,
      isDisabled: isSubmitting || !isValid || !dirty
    }, "Save"), /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: ButtonVariant.link,
      onClick: onCancel
    }, "Cancel")));
  });
};

var EditHostModal = function EditHostModal(_ref) {
  var isOpen = _ref.isOpen,
      host = _ref.host,
      inventory = _ref.inventory,
      usedHostnames = _ref.usedHostnames,
      onClose = _ref.onClose,
      onSave = _ref.onSave,
      onFormSaveError = _ref.onFormSaveError;
  return host && inventory ? /*#__PURE__*/React__default.createElement(Modal, {
    "aria-label": "Edit host dialog",
    title: "Edit Host",
    isOpen: isOpen,
    onClose: onClose,
    variant: ModalVariant.small,
    hasNoBodyWrapper: true
  }, /*#__PURE__*/React__default.createElement(EditHostForm, {
    host: host,
    inventory: inventory,
    usedHostnames: usedHostnames,
    onCancel: onClose,
    onSave: onSave,
    onFormSaveError: onFormSaveError
  })) : null;
};

var parseRAM = function parseRAM(req) {
  return fileSize(((req === null || req === void 0 ? void 0 : req.ramMib) || 16 * 1024) * 1024 * 1024, 2, 'iec');
};

var HostRequirements = function HostRequirements(_ref) {
  var master = _ref.master,
      worker = _ref.worker,
      sno = _ref.sno,
      isSNOCluster = _ref.isSNOCluster;
  var masterRam = parseRAM(master);
  var workerRam = parseRAM(worker);
  var snoRam = parseRAM(sno);
  return /*#__PURE__*/createElement(TextContent, null, /*#__PURE__*/createElement(List, null, !isSNOCluster && /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(ListItem$1, null, "Control plane nodes: At least ", (master === null || master === void 0 ? void 0 : master.cpuCores) || 4, " CPU cores, ", masterRam, " RAM,", ' ', (master === null || master === void 0 ? void 0 : master.diskSizeGb) || 120, " GB filesystem for every supervisor."), /*#__PURE__*/createElement(ListItem$1, null, "Workers: At least ", (worker === null || worker === void 0 ? void 0 : worker.cpuCores) || 2, " CPU cores, ", workerRam, " RAM,", ' ', (worker === null || worker === void 0 ? void 0 : worker.diskSizeGb) || 120, " GB filesystem for each worker")), (isSNOCluster === true || isSNOCluster === undefined) && /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(ListItem$1, null, "SNO: One host is required with at least ", (sno === null || sno === void 0 ? void 0 : sno.cpuCores) || 4, " CPU cores, ", snoRam, " of RAM, and ", (sno === null || sno === void 0 ? void 0 : sno.diskSizeGb) || 120, " GB of filesystem storage.")), /*#__PURE__*/createElement(ListItem$1, null, "Also note that each hosts' disk write speed should meet the minimum requirements to run OpenShift.", ' ', /*#__PURE__*/createElement(ExternalLink, {
    href: 'https://access.redhat.com/solutions/4885641'
  }, "Learn more"))));
};

function getAggregatedStatus(operators) {
  var operatorStates = operators.map(function (operator) {
    return operator.status || 'pending';
  });
  if (operatorStates.includes('failed')) return 'failed';
  if (operatorStates.includes('progressing')) return 'progressing';
  if (operatorStates.includes('pending')) return 'pending';
  return 'available';
}
var getOperatorCountString = function getOperatorCountString(count) {
  return count + " " + pluralize(count, 'operator');
};
function getLabel(operators) {
  var failedOperatorsCount = operators.filter(function (o) {
    return o.status === 'failed';
  }).length;
  var status = getAggregatedStatus(operators);
  var operatorsCountString = getOperatorCountString(operators.length);

  switch (status) {
    case 'available':
      return operatorsCountString + " installed";

    case 'failed':
      return operators.length > 1 ? failedOperatorsCount + "/" + operatorsCountString + " failed" : getOperatorCountString(failedOperatorsCount) + " failed";

    case 'progressing':
      return "Installing " + operatorsCountString;

    default:
      return "" + operatorsCountString;
  }
}
function getIcon(status) {
  switch (status) {
    case 'available':
      return /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
        color: global_success_color_100.value
      });

    case 'failed':
      return /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
        color: global_danger_color_100.value
      });

    case 'progressing':
      return /*#__PURE__*/React__default.createElement(InProgressIcon, null);

    default:
      return /*#__PURE__*/React__default.createElement(PendingIcon, null);
  }
}

var OperatorsPopover = function OperatorsPopover(_ref) {
  var operators = _ref.operators,
      children = _ref.children;
  return /*#__PURE__*/React__default.createElement(Popover, {
    headerContent: /*#__PURE__*/React__default.createElement("div", null, "Operators"),
    bodyContent: /*#__PURE__*/React__default.createElement(List, {
      className: "operators-progress-item__operators-list"
    }, operators.map(function (operator) {
      var status = operator.status || 'pending';
      var name = operator.name && OPERATOR_LABELS[operator.name];
      return /*#__PURE__*/React__default.createElement(ListItem$1, {
        key: operator.name,
        title: operator.statusInfo
      }, name, " ", status);
    })),
    minWidth: "30rem",
    maxWidth: "50rem"
  }, children);
};

var OperatorsProgressItem = function OperatorsProgressItem(_ref2) {
  var operators = _ref2.operators;
  var icon = getIcon(getAggregatedStatus(operators));
  var label = getLabel(operators);
  return /*#__PURE__*/React__default.createElement(Flex, {
    className: "pf-u-mr-3xl"
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, icon), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(OperatorsPopover, {
    operators: operators
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true,
    "data-testid": "operators-progress-item"
  }, label))));
};

var getOlmOperators = function getOlmOperators(monitoredOperators) {
  if (monitoredOperators === void 0) {
    monitoredOperators = [];
  }

  return monitoredOperators.filter(function (operator) {
    return operator.operatorType === 'olm';
  });
};

var getProgressVariant$1 = function getProgressVariant(status) {
  switch (status) {
    case 'cancelled':
    case 'error':
      return ProgressVariant.danger;

    case 'installed':
    case 'adding-hosts':
      return ProgressVariant.success;

    default:
      return undefined;
  }
};

var getMeasureLocation$1 = function getMeasureLocation(status) {
  return ['installed', 'adding-hosts'].includes(status) ? ProgressMeasureLocation.none : ProgressMeasureLocation.top;
};

var getInstallationStatus = function getInstallationStatus(status, installCompletedAt) {
  if (status === 'installed') {
    return "Installed on " + getHumanizedDateTime(installCompletedAt);
  }

  if (status === 'error') {
    return "Failed on " + getHumanizedDateTime(installCompletedAt);
  }

  if (status === 'cancelled') {
    return "Cancelled on " + getHumanizedDateTime(installCompletedAt);
  }

  return CLUSTER_STATUS_LABELS[status] || status;
};

var getHostStatusIcon = function getHostStatusIcon(hosts) {
  if (hosts.some(function (host) {
    return ['cancelled', 'error'].includes(host.status);
  })) {
    return /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
      color: global_danger_color_100.value
    });
  }

  if (hosts.every(function (host) {
    return host.status === 'installed';
  })) {
    return /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
      color: global_success_color_100.value
    });
  }

  return /*#__PURE__*/React__default.createElement(InProgressIcon, null);
};

var HostProgress$1 = function HostProgress(_ref) {
  var hosts = _ref.hosts,
      hostRole = _ref.hostRole;
  var filteredHosts = hosts.filter(function (host) {
    return host.role && hostRole === host.role;
  });
  var icon = getHostStatusIcon(filteredHosts);
  var failedHostsCount = filteredHosts.filter(function (host) {
    return host.status === 'error';
  }).length;

  var hostCountText = function hostCountText(hostType) {
    return failedHostsCount === 0 ? filteredHosts.length + " " + pluralize(filteredHosts.length, hostType) : failedHostsCount + "/" + filteredHosts.length + " " + pluralize(filteredHosts.length, hostType);
  };

  var text = hostRole === 'master' ? "" + hostCountText('control plane node') : "" + hostCountText('worker');
  return /*#__PURE__*/React__default.createElement(Flex, {
    className: "pf-u-mr-3xl"
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, icon), /*#__PURE__*/React__default.createElement(FlexItem, null, text));
};

var getFinalizingStatusIcon = function getFinalizingStatusIcon(cluster) {
  var statusIcon;
  var _cluster$monitoredOpe = cluster.monitoredOperators,
      monitoredOperators = _cluster$monitoredOpe === void 0 ? [] : _cluster$monitoredOpe;
  var areAllBuiltInOperatorsAvailable = monitoredOperators.length ? monitoredOperators.filter(function (op) {
    return op.operatorType === 'builtin';
  }).every(function (op) {
    return op.status === 'available';
  }) : false;

  if (areAllBuiltInOperatorsAvailable) {
    statusIcon = /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
      color: global_success_color_100.value
    });
  } else {
    switch (cluster.status) {
      case 'finalizing':
        statusIcon = /*#__PURE__*/React__default.createElement(InProgressIcon, null);
        break;

      case 'error':
      case 'cancelled':
        statusIcon = /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
          color: global_danger_color_100.value
        });
        break;

      case 'installed':
      case 'adding-hosts':
        statusIcon = /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
          color: global_success_color_100.value
        });
        break;

      default:
        statusIcon = /*#__PURE__*/React__default.createElement(PendingIcon, null);
    }
  }

  return statusIcon;
};

var FinalizingProgress = function FinalizingProgress(_ref2) {
  var cluster = _ref2.cluster,
      onFetchEvents = _ref2.onFetchEvents,
      fallbackEventsURL = _ref2.fallbackEventsURL;
  var status = cluster.status;

  var _React$useState = React__default.useState(false),
      isModalOpen = _React$useState[0],
      setIsModalOpen = _React$useState[1];

  var closeModal = function closeModal() {
    return setIsModalOpen(false);
  };

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(EventsModal, {
    title: "Cluster Events",
    isOpen: isModalOpen,
    onClose: closeModal,
    hostId: undefined,
    cluster: cluster,
    entityKind: "cluster",
    onFetchEvents: onFetchEvents,
    fallbackEventsURL: fallbackEventsURL
  }), /*#__PURE__*/React__default.createElement(Flex, {
    className: "pf-u-mr-3xl"
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, getFinalizingStatusIcon(cluster)), /*#__PURE__*/React__default.createElement(FlexItem, null, status === 'finalizing' ? /*#__PURE__*/React__default.createElement(Popover, {
    zIndex: 300,
    headerContent: /*#__PURE__*/React__default.createElement(Fragment, null, "Initialization"),
    bodyContent: /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, "This stage may take a while to finish. To view detailed information, click the events log link below.")),
    footerContent: /*#__PURE__*/React__default.createElement(Button, {
      variant: ButtonVariant.link,
      isInline: true,
      onClick: function onClick() {
        return setIsModalOpen(true);
      }
    }, "Open Events Log")
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true
  }, "Initialization")) : 'Initialization')));
};

var ClusterProgress = function ClusterProgress(_ref3) {
  var cluster = _ref3.cluster,
      _ref3$minimizedView = _ref3.minimizedView,
      minimizedView = _ref3$minimizedView === void 0 ? false : _ref3$minimizedView,
      totalPercentage = _ref3.totalPercentage,
      onFetchEvents = _ref3.onFetchEvents,
      fallbackEventsURL = _ref3.fallbackEventsURL;
  var status = cluster.status,
      _cluster$monitoredOpe2 = cluster.monitoredOperators,
      monitoredOperators = _cluster$monitoredOpe2 === void 0 ? [] : _cluster$monitoredOpe2;
  var enabledHosts = getEnabledHosts(cluster.hosts);
  var isWorkersPresent = enabledHosts && enabledHosts.some(function (host) {
    return host.role === 'worker';
  });
  var olmOperators = getOlmOperators(monitoredOperators);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(DetailList, null, /*#__PURE__*/React__default.createElement(Flex, {
    direction: {
      "default": minimizedView ? 'row' : 'column'
    }
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Started on",
    value: getHumanizedDateTime(cluster.installStartedAt),
    idPrefix: "cluster-progress-started-on"
  })), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Status",
    value: getInstallationStatus(cluster.status, cluster.installCompletedAt),
    idPrefix: "cluster-progress-status"
  })))), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: !minimizedView
  }, /*#__PURE__*/React__default.createElement(Progress, {
    value: totalPercentage,
    label: totalPercentage + "%",
    title: " ",
    measureLocation: getMeasureLocation$1(status),
    variant: getProgressVariant$1(status),
    className: "cluster-progress-bar"
  }), /*#__PURE__*/React__default.createElement(Flex, {
    className: "pf-u-mt-md",
    display: {
      "default": 'inlineFlex'
    }
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(HostProgress$1, {
    hosts: enabledHosts,
    hostRole: "master"
  })), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: isWorkersPresent
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(HostProgress$1, {
    hosts: enabledHosts,
    hostRole: "worker"
  }))), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(FinalizingProgress, {
    cluster: cluster,
    onFetchEvents: onFetchEvents,
    fallbackEventsURL: fallbackEventsURL
  })), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: olmOperators.length > 0
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(OperatorsProgressItem, {
    operators: olmOperators
  }))))));
};

var formatMultilineString = function formatMultilineString(multiLineList) {
  return multiLineList && multiLineList.length > 0 ? [].concat(multiLineList.slice(1)).reduce(function (accu, elem) {
    return accu + "\n" + elem;
  }, multiLineList[0]) : '';
};

var ModalExpandableSection = function ModalExpandableSection(props) {
  var requiredList = props.requiredList,
      optionalList = props.optionalList,
      otherProps = _objectWithoutPropertiesLoose(props, ["requiredList", "optionalList"]);

  return /*#__PURE__*/React__default.createElement(ExpandableSection, otherProps, /*#__PURE__*/React__default.createElement(PrismCode, {
    code: formatMultilineString(requiredList),
    language: "markup",
    copiable: true
  }), /*#__PURE__*/React__default.createElement("br", null), /*#__PURE__*/React__default.createElement(Text, {
    component: "h6"
  }, "Optional:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: formatMultilineString(optionalList),
    language: "markup",
    copiable: true
  }));
};

var getHostIPs = function getHostIPs(cluster) {
  var _cluster$hosts;

  var hostIPAddresses = {};
  (_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.map(function (host) {
    if (host && host.requestedHostname) {
      var _stringToJSON;

      var interfaces = ((_stringToJSON = stringToJSON(host.inventory)) === null || _stringToJSON === void 0 ? void 0 : _stringToJSON.interfaces) || undefined;

      if (interfaces && interfaces.length > 0) {
        if (interfaces[0].ipv4Addresses && interfaces[0].ipv4Addresses.length > 0) {
          hostIPAddresses[host.requestedHostname] = interfaces[0].ipv4Addresses[0].split('/')[0];
        } else if (interfaces[0].ipv6Addresses && interfaces[0].ipv6Addresses.length > 0) {
          hostIPAddresses[host.requestedHostname] = interfaces[0].ipv6Addresses[0].split('/')[0];
        }
      }
    }
  });
  return hostIPAddresses;
};

var WebConsoleHint = function WebConsoleHint(_ref) {
  var cluster = _ref.cluster,
      consoleUrl = _ref.consoleUrl;

  var _React$useState = React__default.useState(true),
      isDNSExpanded = _React$useState[0],
      setIsDNSExpanded = _React$useState[1];

  var handleToggle = function handleToggle() {
    return setIsDNSExpanded(!isDNSExpanded);
  };

  var hostIPs = React__default.useMemo(function () {
    return getHostIPs(cluster);
  }, [cluster]);

  var _ref2 = isSingleNodeCluster(cluster) ? [Object.values(hostIPs || {})[0], Object.values(hostIPs || {})[0]] : [cluster.apiVip, cluster.ingressVip],
      apiVip = _ref2[0],
      ingressVip = _ref2[1];

  var sortedHostIPs = Object.keys(hostIPs).sort();
  var etcHostsOptional = sortedHostIPs.map(function (hostname) {
    return hostIPs[hostname] + "\t" + hostname;
  });
  var clusterUrl = cluster.name + "." + cluster.baseDnsDomain;
  var appsUrl = "apps." + clusterUrl;
  var etcHosts = [apiVip + "\tapi." + clusterUrl, ingressVip + "\toauth-openshift." + appsUrl, ingressVip + "\t" + removeProtocolFromURL(consoleUrl), ingressVip + "\tgrafana-openshift-monitoring." + appsUrl, ingressVip + "\tthanos-querier-openshift-monitoring." + appsUrl, ingressVip + "\tprometheus-k8s-openshift-monitoring." + appsUrl, ingressVip + "\talertmanager-main-openshift-monitoring." + appsUrl];
  var paddingNum = ("*." + appsUrl + ".").length + 2;
  var aRecords = [("api." + clusterUrl).padEnd(paddingNum) + ("A\t" + apiVip), ("*." + appsUrl).padEnd(paddingNum) + ("A\t" + ingressVip)];
  var aRecordsOptional = sortedHostIPs.map(function (hostname) {
    return hostname + "\tA\t" + hostIPs[hostname];
  });
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, "In order to access the OpenShift Web Console, use external DNS server or local configuration to resolve its hostname. To do so, either:"), /*#__PURE__*/React__default.createElement(ModalExpandableSection, {
    toggleText: "Option 1: Add the following records to your DNS server (recommended)",
    className: "pf-u-pb-md",
    isExpanded: isDNSExpanded,
    onToggle: handleToggle,
    requiredList: aRecords,
    optionalList: aRecordsOptional
  }), /*#__PURE__*/React__default.createElement(ModalExpandableSection, {
    toggleText: "Option 2: Update your local /etc/hosts or /etc/resolve.conf files",
    className: "pf-u-pb-md",
    isExpanded: !isDNSExpanded,
    onToggle: handleToggle,
    requiredList: etcHosts,
    optionalList: etcHostsOptional
  }));
};
var LaunchOpenshiftConsoleButton = function LaunchOpenshiftConsoleButton(_ref3) {
  var cluster = _ref3.cluster,
      consoleUrl = _ref3.consoleUrl,
      isDisabled = _ref3.isDisabled,
      id = _ref3.id;

  var _React$useState2 = React__default.useState(false),
      isOpen = _React$useState2[0],
      setOpen = _React$useState2[1];

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ToolbarButton, {
    type: "button",
    variant: ButtonVariant.primary,
    isDisabled: isDisabled,
    onClick: function onClick() {
      return setOpen(true);
    },
    "data-testid": id
  }, "Launch OpenShift Console"), /*#__PURE__*/React__default.createElement(ConsoleModal, {
    closeModal: function closeModal() {
      return setOpen(false);
    },
    consoleUrl: consoleUrl,
    cluster: cluster,
    isOpen: isOpen
  }));
};
var TroubleshootingOpenshiftConsoleButton = function TroubleshootingOpenshiftConsoleButton(_ref4) {
  var cluster = _ref4.cluster,
      consoleUrl = _ref4.consoleUrl,
      idPrefix = _ref4.idPrefix;

  var _React$useState3 = React__default.useState(false),
      isOpen = _React$useState3[0],
      setOpen = _React$useState3[1];

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Button, {
    variant: "link",
    icon: /*#__PURE__*/React__default.createElement(InfoCircleIcon, null),
    iconPosition: "left",
    isInline: true,
    onClick: function onClick() {
      return setOpen(true);
    },
    "data-testid": idPrefix + "-troubleshooting-hint-open"
  }, "Not able to access the Web Console?"), /*#__PURE__*/React__default.createElement(ConsoleModal, {
    closeModal: function closeModal() {
      return setOpen(false);
    },
    consoleUrl: consoleUrl,
    cluster: cluster,
    isOpen: isOpen
  }));
};
var ConsoleModal = function ConsoleModal(_ref5) {
  var closeModal = _ref5.closeModal,
      cluster = _ref5.cluster,
      consoleUrl = _ref5.consoleUrl,
      isOpen = _ref5.isOpen;
  var actions = [/*#__PURE__*/React__default.createElement(Button, {
    type: "submit",
    key: "launch",
    variant: ButtonVariant.primary,
    onClick: function onClick() {
      return window.open(consoleUrl, '_blank', 'noopener');
    },
    isDisabled: !consoleUrl
  }, "Launch OpenShift Console"), /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.secondary,
    onClick: function onClick() {
      return closeModal();
    },
    key: "close"
  }, "Close")];
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "OpenShift Web Console troubleshooting",
    isOpen: isOpen,
    onClose: closeModal,
    actions: actions,
    variant: ModalVariant.large
  }, /*#__PURE__*/React__default.createElement(WebConsoleHint, {
    cluster: cluster,
    consoleUrl: consoleUrl
  }));
};

var ClusterCredentials = function ClusterCredentials(_ref) {
  var cluster = _ref.cluster,
      credentials = _ref.credentials,
      _ref$error = _ref.error,
      error = _ref$error === void 0 ? false : _ref$error,
      retry = _ref.retry,
      _ref$idPrefix = _ref.idPrefix,
      idPrefix = _ref$idPrefix === void 0 ? 'cluster-creds' : _ref$idPrefix;
  var credentialsBody;

  if (error) {
    credentialsBody = /*#__PURE__*/React__default.createElement(ErrorState, {
      title: "Failed to fetch cluster credentials.",
      fetchData: retry
    });
  } else if (!credentials) {
    credentialsBody = /*#__PURE__*/React__default.createElement(LoadingState, null);
  } else {
    credentialsBody = /*#__PURE__*/React__default.createElement(DetailList, null, /*#__PURE__*/React__default.createElement(DetailItem, {
      title: "Web Console URL",
      value: /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Button, {
        variant: "link",
        icon: /*#__PURE__*/React__default.createElement(ExternalLinkAltIcon, null),
        iconPosition: "right",
        isInline: true,
        onClick: function onClick() {
          return window.open(credentials.consoleUrl, '_blank', 'noopener');
        },
        "data-testid": idPrefix + "-link-console-url"
      }, credentials.consoleUrl), /*#__PURE__*/React__default.createElement("br", null), /*#__PURE__*/React__default.createElement(TroubleshootingOpenshiftConsoleButton, {
        consoleUrl: credentials.consoleUrl,
        cluster: cluster,
        idPrefix: idPrefix
      }))
    }), /*#__PURE__*/React__default.createElement(DetailItem, {
      title: "Username",
      value: credentials.username
    }), /*#__PURE__*/React__default.createElement(DetailItem, {
      title: "Password",
      value: /*#__PURE__*/React__default.createElement(ClipboardCopy, {
        isReadOnly: true,
        onCopy: function onCopy(event) {
          return clipboardCopyFunc(event, credentials.password);
        }
      }, "\u2022\u2022\u2022\u2022\u2022")
    }));
  }

  return /*#__PURE__*/React__default.createElement(GridItem, {
    span: 12
  }, credentialsBody);
};

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

/**
 * Source: ftp://ftp.unicode.org/Public/UCD/latest/ucd/SpecialCasing.txt
 */
/**
 * Lower case as a function.
 */
function lowerCase(str) {
    return str.toLowerCase();
}
//# sourceMappingURL=index.js.map

// Support camel case ("camelCase" -> "camel Case" and "CAMELCase" -> "CAMEL Case").
var DEFAULT_SPLIT_REGEXP = [/([a-z0-9])([A-Z])/g, /([A-Z])([A-Z][a-z])/g];
// Remove all non-word characters.
var DEFAULT_STRIP_REGEXP = /[^A-Z0-9]+/gi;
/**
 * Normalize the string into something other libraries can manipulate easier.
 */
function noCase(input, options) {
    if (options === void 0) { options = {}; }
    var _a = options.splitRegexp, splitRegexp = _a === void 0 ? DEFAULT_SPLIT_REGEXP : _a, _b = options.stripRegexp, stripRegexp = _b === void 0 ? DEFAULT_STRIP_REGEXP : _b, _c = options.transform, transform = _c === void 0 ? lowerCase : _c, _d = options.delimiter, delimiter = _d === void 0 ? " " : _d;
    var result = replace(replace(input, splitRegexp, "$1\0$2"), stripRegexp, "\0");
    var start = 0;
    var end = result.length;
    // Trim the delimiter from around the output string.
    while (result.charAt(start) === "\0")
        start++;
    while (result.charAt(end - 1) === "\0")
        end--;
    // Transform each token independently.
    return result
        .slice(start, end)
        .split("\0")
        .map(transform)
        .join(delimiter);
}
/**
 * Replace `re` in the input string with the replacement value.
 */
function replace(input, re, value) {
    if (re instanceof RegExp)
        return input.replace(re, value);
    return re.reduce(function (input, re) { return input.replace(re, value); }, input);
}
//# sourceMappingURL=index.js.map

function pascalCaseTransform(input, index) {
    var firstChar = input.charAt(0);
    var lowerChars = input.substr(1).toLowerCase();
    if (index > 0 && firstChar >= "0" && firstChar <= "9") {
        return "_" + firstChar + lowerChars;
    }
    return "" + firstChar.toUpperCase() + lowerChars;
}
function pascalCase(input, options) {
    if (options === void 0) { options = {}; }
    return noCase(input, __assign({ delimiter: "", transform: pascalCaseTransform }, options));
}
//# sourceMappingURL=index.js.map

function camelCaseTransform(input, index) {
    if (index === 0)
        return input.toLowerCase();
    return pascalCaseTransform(input, index);
}
function camelCase(input, options) {
    if (options === void 0) { options = {}; }
    return pascalCase(input, __assign({ transform: camelCaseTransform }, options));
}
//# sourceMappingURL=index.js.map

var BASE_PATH = '/api/assisted-install';
var axiosCaseConverterOptions = {
  caseFunctions: {
    camel: function camel(input) {
      return camelCase(input, {
        stripRegexp: /[^A-Z0-9.]+/gi
      });
    }
  }
};

var getDefaultClient = function getDefaultClient() {
  var client = axios.create();
  client.interceptors.request.use(function (cfg) {
    return _extends({}, cfg, {
      url: "" + process.env.REACT_APP_API_ROOT + cfg.url
    });
  });
  return applyCaseMiddleware(client, axiosCaseConverterOptions);
};

var client = getDefaultClient();
var ocmClient;

var aiInterceptor = function aiInterceptor(client) {
  client.interceptors.request.use(function (cfg) {
    return _extends({}, cfg, {
      url: "" + BASE_PATH + cfg.url
    });
  });
  return client;
};

var setAuthInterceptor = function setAuthInterceptor(authInterceptor) {
  ocmClient = authInterceptor(axios.create());
  client = applyCaseMiddleware(aiInterceptor(authInterceptor(axios.create())), axiosCaseConverterOptions);
};

var getClusters = function getClusters() {
  return client.get('/v1/clusters');
};
var getClustersDefaultConfiguration = function getClustersDefaultConfiguration() {
  return client.get('/v1/clusters/default-config');
};
var getCluster = function getCluster(id) {
  return client.get("/v1/clusters/" + id);
};
var getClustersByOpenshiftId = function getClustersByOpenshiftId(openshiftId) {
  return client.get("/v1/clusters?openshift_cluster_id=" + openshiftId);
};
var postCluster = function postCluster(params) {
  return client.post('/v1/clusters', params);
};
var patchCluster = function patchCluster(id, params) {
  return client.patch("/v1/clusters/" + id, params);
};
var deleteCluster = function deleteCluster(id) {
  return client["delete"]("/v1/clusters/" + id);
};
var getClusterHosts = function getClusterHosts(id) {
  return client.get("/v1/clusters/" + id + "/hosts");
};
var enableClusterHost = function enableClusterHost(clusterId, hostId) {
  return client.post("/v1/clusters/" + clusterId + "/hosts/" + hostId + "/actions/enable");
};
var disableClusterHost = function disableClusterHost(clusterId, hostId) {
  return client["delete"]("/v1/clusters/" + clusterId + "/hosts/" + hostId + "/actions/enable");
};
var resetClusterHost = function resetClusterHost(clusterId, hostId) {
  return client.post("/v1/clusters/" + clusterId + "/hosts/" + hostId + "/actions/reset");
};
var deleteClusterHost = function deleteClusterHost(clusterId, hostId) {
  return client["delete"]("/v1/clusters/" + clusterId + "/hosts/" + hostId);
};
var postInstallCluster = function postInstallCluster(clusterId) {
  return client.post("/v1/clusters/" + clusterId + "/actions/install");
};
var postResetCluster = function postResetCluster(clusterId) {
  return client.post("/v1/clusters/" + clusterId + "/actions/reset");
};
var postCancelInstallation = function postCancelInstallation(clusterId) {
  return client.post("/v1/clusters/" + clusterId + "/actions/cancel");
};
var createClusterDownloadsImage = function createClusterDownloadsImage(id, params, axiosOptions) {
  return client.post("/v1/clusters/" + id + "/downloads/image", params, axiosOptions);
};
var API_ROOT = process.env.REACT_APP_API_ROOT || BASE_PATH;
var getPresignedFileUrl = function getPresignedFileUrl(_ref) {
  var clusterId = _ref.clusterId,
      fileName = _ref.fileName,
      hostId = _ref.hostId,
      logsType = _ref.logsType;
  return client.get("/v1/clusters/" + clusterId + "/downloads/files-presigned?file_name=" + fileName + (logsType ? "&logs_type=" + logsType : '') + (hostId ? "&host_id=" + hostId : ''));
};
var getClusterFileDownload = function getClusterFileDownload(clusterID, fileName) {
  return client.get("/v1/clusters/" + clusterID + "/downloads/files?file_name=" + fileName, {
    responseType: 'blob',
    headers: {
      Accept: 'application/octet-stream'
    }
  });
};
var getClusterDownloadsImageUrl = function getClusterDownloadsImageUrl(clusterId) {
  return API_ROOT + "/v1/clusters/" + clusterId + "/downloads/image";
};
var getClusterCredentials = function getClusterCredentials(clusterID) {
  return client.get("/v1/clusters/" + clusterID + "/credentials");
};
var getHostLogsDownloadUrl = function getHostLogsDownloadUrl(hostId, clusterId) {
  return API_ROOT + "/v1/clusters/" + clusterId + "/logs?logs_type=host&host_id=" + hostId;
};
var getClusterLogsDownloadUrl = function getClusterLogsDownloadUrl(clusterId) {
  return API_ROOT + "/v1/clusters/" + clusterId + "/logs?logs_type=all";
};
var getEvents = function getEvents(clusterID, hostID) {
  return client.get("/v1/clusters/" + clusterID + "/events" + (hostID ? "?host_id=" + hostID : ''));
};
var getClusterPreflightRequirements = function getClusterPreflightRequirements(clusterID) {
  return client.get("/v1/clusters/" + clusterID + "/preflight-requirements");
};
var getClusterSupportedPlatforms = function getClusterSupportedPlatforms(clusterID) {
  return client.get("/v1/clusters/" + clusterID + "/supported-platforms");
};

var captureException = function captureException(error, message, severity) {
  if (severity === void 0) {
    severity = Severity.Error;
  }

  if (ocmClient) {
    message && captureMessage(message, severity);
    captureException$1(error);
  } else {
    severity === Severity.Error ? console.error(message, error) : console.warn(message, error);
  }
};

var handleApiError = function handleApiError(error, onError) {
  if (axios.isCancel(error)) {
    captureException(error, 'Request canceled', Severity.Info);
  } else {
    var message = "Error config: " + JSON.stringify(error.config, null, 2) + "\n";

    if (error.response) {
      message += "Response data: " + JSON.stringify(error.response.data, null, 2) + "\n";
      message += "Response status: " + error.response.status + "\n";
      message += "Response headers: " + JSON.stringify(error.response.headers, null, 2);
    } else if (error.request) {
      message += "Request: " + JSON.stringify(error.request, null, 2);
    } else {
      message += "Error: " + JSON.stringify(error.message, null, 2);
    }

    captureException(error, message);
    if (onError) return onError(error);
  }
};
var getErrorMessage = function getErrorMessage(error) {
  var _error$response, _error$response$data, _error$response2, _error$response2$data;

  return ((_error$response = error.response) === null || _error$response === void 0 ? void 0 : (_error$response$data = _error$response.data) === null || _error$response$data === void 0 ? void 0 : _error$response$data.reason) || ((_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : (_error$response2$data = _error$response2.data) === null || _error$response2$data === void 0 ? void 0 : _error$response2$data.message) || error.message;
};

var KubeconfigDownload = function KubeconfigDownload(_ref) {
  var clusterId = _ref.clusterId,
      status = _ref.status,
      id = _ref.id,
      handleDownload = _ref.handleDownload;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var download = React__default.useCallback(function (clusterId, status) {
    try {
      var fileName = status === 'installed' ? 'kubeconfig' : 'kubeconfig-noingress';

      var _temp4 = function () {
        if (ocmClient) {
          var _temp5 = _catch(function () {
            return Promise.resolve(getPresignedFileUrl({
              clusterId: clusterId,
              fileName: fileName
            })).then(function (_ref2) {
              var data = _ref2.data;
              saveAs(data.url);
            });
          }, function (e) {
            handleApiError(e, function (e) {
              try {
                addAlert({
                  title: 'Could not download kubeconfig',
                  message: getErrorMessage(e)
                });
                return Promise.resolve();
              } catch (e) {
                return Promise.reject(e);
              }
            });
          });

          if (_temp5 && _temp5.then) return _temp5.then(function () {});
        } else {
          var _temp6 = _catch(function () {
            return Promise.resolve(getClusterFileDownload(clusterId, fileName)).then(function (response) {
              var _contentHeader$match;

              var contentHeader = response.headers.contentDisposition;
              var name = contentHeader === null || contentHeader === void 0 ? void 0 : (_contentHeader$match = contentHeader.match(/filename="(.+)"/)) === null || _contentHeader$match === void 0 ? void 0 : _contentHeader$match[1];
              saveAs(response.data, name);
            });
          }, function (e) {
            handleApiError(e, function (e) {
              try {
                addAlert({
                  title: 'Could not download kubeconfig',
                  message: getErrorMessage(e)
                });
                return Promise.resolve();
              } catch (e) {
                return Promise.reject(e);
              }
            });
          });

          if (_temp6 && _temp6.then) return _temp6.then(function () {});
        }
      }();

      return Promise.resolve(_temp4 && _temp4.then ? _temp4.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  }, [addAlert]);
  return /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.secondary,
    onClick: handleDownload || function () {
      return download(clusterId, status);
    },
    isDisabled: !canDownloadKubeconfig(status),
    id: id,
    "data-testid": id
  }, "Download kubeconfig");
};

var ResourceUIState;

(function (ResourceUIState) {
  ResourceUIState["LOADING"] = "LOADING";
  ResourceUIState["RELOADING"] = "RELOADING";
  ResourceUIState["ERROR"] = "ERROR";
  ResourceUIState["EMPTY"] = "EMPTY";
  ResourceUIState["LOADED"] = "LOADED";
})(ResourceUIState || (ResourceUIState = {}));

var getAgentSelectorFieldsFromAnnotations = function getAgentSelectorFieldsFromAnnotations(annotations) {
  var _annotations$AGENT_LO;

  if (annotations === void 0) {
    annotations = {};
  }

  var locations = ((_annotations$AGENT_LO = annotations[AGENT_LOCATION_LABEL_KEY]) === null || _annotations$AGENT_LO === void 0 ? void 0 : _annotations$AGENT_LO.split(',')) || [];
  var labels = Object.keys(annotations).map(function (key) {
    if (key.startsWith(AGENT_SELECTOR)) {
      var label = key.substr(AGENT_SELECTOR.length);
      return label + "=" + annotations[key];
    }

    return undefined;
  }).filter(Boolean);
  return {
    labels: labels,
    locations: locations,
    autoSelect: !annotations[AGENT_AUTO_SELECT_ANNOTATION_KEY] || annotations[AGENT_AUTO_SELECT_ANNOTATION_KEY] === 'true'
  };
};
var getAnnotationsFromAgentSelector = function getAnnotationsFromAgentSelector(clusterDeployment, values) {
  var _clusterDeployment$me;

  var labelValuePairs = values.agentLabels,
      locations = values.locations,
      autoSelectHosts = values.autoSelectHosts;
  var agentLabels = parseStringLabels(labelValuePairs || []);

  var annotations = _extends({}, (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.annotations) || {});

  Object.keys(annotations).forEach(function (key) {
    if (key.startsWith(AGENT_SELECTOR)) {
      delete annotations[key];
    }
  });
  Object.keys(agentLabels).forEach(function (key) {
    annotations["" + AGENT_SELECTOR + key] = agentLabels[key];
  });
  delete annotations[AGENT_AUTO_SELECT_ANNOTATION_KEY];

  if (locations === null || locations === void 0 ? void 0 : locations.length) {
    annotations[AGENT_LOCATION_LABEL_KEY] = locations.join(',');
  }

  if (!autoSelectHosts) {
    annotations[AGENT_AUTO_SELECT_ANNOTATION_KEY] = 'false';
  }

  return annotations;
};
var getClusterDeploymentResource = function getClusterDeploymentResource(_ref) {
  var name = _ref.name,
      namespace = _ref.namespace,
      baseDnsDomain = _ref.baseDnsDomain,
      annotations = _ref.annotations,
      pullSecretName = _ref.pullSecretName;
  return {
    apiVersion: 'hive.openshift.io/v1',
    kind: 'ClusterDeployment',
    metadata: {
      name: name,
      namespace: namespace,
      annotations: annotations
    },
    spec: {
      baseDomain: baseDnsDomain,
      clusterInstallRef: {
        group: 'extensions.hive.openshift.io',
        kind: 'AgentClusterInstall',
        name: name,
        version: 'v1beta1'
      },
      clusterName: name,
      platform: {
        agentBareMetal: {
          agentSelector: {}
        }
      },
      pullSecretRef: {
        name: pullSecretName
      }
    }
  };
};
var getConsoleUrl = function getConsoleUrl(clusterDeployment) {
  var _clusterDeployment$st, _clusterDeployment$sp, _clusterDeployment$sp2;

  return (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$st = clusterDeployment.status) === null || _clusterDeployment$st === void 0 ? void 0 : _clusterDeployment$st.webConsoleURL) || "https://console-openshift-console.apps." + (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$sp = clusterDeployment.spec) === null || _clusterDeployment$sp === void 0 ? void 0 : _clusterDeployment$sp.clusterName) + "." + (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$sp2 = clusterDeployment.spec) === null || _clusterDeployment$sp2 === void 0 ? void 0 : _clusterDeployment$sp2.baseDomain);
};
var getClusterApiUrl = function getClusterApiUrl(clusterDeployment) {
  var _clusterDeployment$st2, _clusterDeployment$sp3, _clusterDeployment$sp4;

  return (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$st2 = clusterDeployment.status) === null || _clusterDeployment$st2 === void 0 ? void 0 : _clusterDeployment$st2.apiURL) || "https://api." + (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$sp3 = clusterDeployment.spec) === null || _clusterDeployment$sp3 === void 0 ? void 0 : _clusterDeployment$sp3.clusterName) + "." + (clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$sp4 = clusterDeployment.spec) === null || _clusterDeployment$sp4 === void 0 ? void 0 : _clusterDeployment$sp4.baseDomain);
};
var getClusterProperties = function getClusterProperties(clusterDeployment, agentClusterInstall) {
  var _clusterDeployment$me2, _agentClusterInstall$, _agentClusterInstall$2, _clusterDeployment$me3, _clusterDeployment$sp5, _agentClusterInstall$3, _agentClusterInstall$4, _agentClusterInstall$5, _agentClusterInstall$6, _agentClusterInstall$7, _agentClusterInstall$8, _agentClusterInstall$9, _agentClusterInstall$10, _agentClusterInstall$11, _agentClusterInstall$12, _agentClusterInstall$13, _agentClusterInstall$14, _clusterDeployment$st3;

  return {
    name: {
      key: 'Name',
      value: (_clusterDeployment$me2 = clusterDeployment.metadata) === null || _clusterDeployment$me2 === void 0 ? void 0 : _clusterDeployment$me2.name
    },
    openshiftVersion: {
      key: 'OpenShift version',
      value: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.imageSetRef) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.name
    },
    clusterId: {
      key: 'Cluster ID',
      value: (_clusterDeployment$me3 = clusterDeployment.metadata) === null || _clusterDeployment$me3 === void 0 ? void 0 : _clusterDeployment$me3.uid
    },
    baseDnsDomain: {
      key: 'Base DNS domain',
      value: (_clusterDeployment$sp5 = clusterDeployment.spec) === null || _clusterDeployment$sp5 === void 0 ? void 0 : _clusterDeployment$sp5.baseDomain
    },
    apiVip: {
      key: 'API Virtual IP',
      value: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$3 = agentClusterInstall.spec) === null || _agentClusterInstall$3 === void 0 ? void 0 : _agentClusterInstall$3.apiVIP
    },
    ingressVip: {
      key: 'Ingress Virtual IP',
      value: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$4 = agentClusterInstall.spec) === null || _agentClusterInstall$4 === void 0 ? void 0 : _agentClusterInstall$4.ingressVIP
    },
    clusterNetworkCidr: {
      key: 'Cluster network CIDR',
      value: (_agentClusterInstall$5 = agentClusterInstall.spec) === null || _agentClusterInstall$5 === void 0 ? void 0 : (_agentClusterInstall$6 = _agentClusterInstall$5.networking) === null || _agentClusterInstall$6 === void 0 ? void 0 : (_agentClusterInstall$7 = _agentClusterInstall$6.clusterNetwork) === null || _agentClusterInstall$7 === void 0 ? void 0 : _agentClusterInstall$7[0].cidr
    },
    clusterNetworkHostPrefix: {
      key: 'Cluster network host prefix',
      value: (_agentClusterInstall$8 = agentClusterInstall.spec) === null || _agentClusterInstall$8 === void 0 ? void 0 : (_agentClusterInstall$9 = _agentClusterInstall$8.networking) === null || _agentClusterInstall$9 === void 0 ? void 0 : (_agentClusterInstall$10 = _agentClusterInstall$9.clusterNetwork) === null || _agentClusterInstall$10 === void 0 ? void 0 : (_agentClusterInstall$11 = _agentClusterInstall$10[0]) === null || _agentClusterInstall$11 === void 0 ? void 0 : _agentClusterInstall$11.hostPrefix
    },
    serviceNetworkCidr: {
      key: 'Service network CIDR',
      value: (_agentClusterInstall$12 = agentClusterInstall.spec) === null || _agentClusterInstall$12 === void 0 ? void 0 : (_agentClusterInstall$13 = _agentClusterInstall$12.networking) === null || _agentClusterInstall$13 === void 0 ? void 0 : (_agentClusterInstall$14 = _agentClusterInstall$13.serviceNetwork) === null || _agentClusterInstall$14 === void 0 ? void 0 : _agentClusterInstall$14[0]
    },
    installedTimestamp: {
      key: 'Installed at',
      value: getHumanizedDateTime((_clusterDeployment$st3 = clusterDeployment.status) === null || _clusterDeployment$st3 === void 0 ? void 0 : _clusterDeployment$st3.installedTimestamp)
    }
  };
};

var getIsSNOCluster = function getIsSNOCluster(agentClusterInstall) {
  var _agentClusterInstall$, _agentClusterInstall$2;

  return (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.provisionRequirements) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.controlPlaneAgents) === 1;
};

var getHWRequirements = function getHWRequirements(aiConfigMap) {
  var _hwRequirements, _hwRequirements$maste, _hwRequirements2, _hwRequirements2$mast, _hwRequirements3, _hwRequirements3$mast, _hwRequirements4, _hwRequirements4$work, _hwRequirements5, _hwRequirements5$work, _hwRequirements6, _hwRequirements6$work, _hwRequirements7, _hwRequirements7$sno, _hwRequirements8, _hwRequirements8$sno, _hwRequirements9, _hwRequirements9$sno;

  var hwRequirements;

  try {
    var _JSON$parse, _aiConfigMap$data;

    hwRequirements = (_JSON$parse = JSON.parse(((_aiConfigMap$data = aiConfigMap.data) === null || _aiConfigMap$data === void 0 ? void 0 : _aiConfigMap$data.HW_VALIDATOR_REQUIREMENTS) || '[]')) === null || _JSON$parse === void 0 ? void 0 : _JSON$parse.find(function (req) {
      return req.version === 'default';
    });
  } catch (_unused) {
    hwRequirements = {};
  }

  return {
    master: {
      cpuCores: (_hwRequirements = hwRequirements) === null || _hwRequirements === void 0 ? void 0 : (_hwRequirements$maste = _hwRequirements.master) === null || _hwRequirements$maste === void 0 ? void 0 : _hwRequirements$maste.cpu_cores,
      ramMib: (_hwRequirements2 = hwRequirements) === null || _hwRequirements2 === void 0 ? void 0 : (_hwRequirements2$mast = _hwRequirements2.master) === null || _hwRequirements2$mast === void 0 ? void 0 : _hwRequirements2$mast.ram_mib,
      diskSizeGb: (_hwRequirements3 = hwRequirements) === null || _hwRequirements3 === void 0 ? void 0 : (_hwRequirements3$mast = _hwRequirements3.master) === null || _hwRequirements3$mast === void 0 ? void 0 : _hwRequirements3$mast.disk_size_gb
    },
    worker: {
      cpuCores: (_hwRequirements4 = hwRequirements) === null || _hwRequirements4 === void 0 ? void 0 : (_hwRequirements4$work = _hwRequirements4.worker) === null || _hwRequirements4$work === void 0 ? void 0 : _hwRequirements4$work.cpu_cores,
      ramMib: (_hwRequirements5 = hwRequirements) === null || _hwRequirements5 === void 0 ? void 0 : (_hwRequirements5$work = _hwRequirements5.worker) === null || _hwRequirements5$work === void 0 ? void 0 : _hwRequirements5$work.ram_mib,
      diskSizeGb: (_hwRequirements6 = hwRequirements) === null || _hwRequirements6 === void 0 ? void 0 : (_hwRequirements6$work = _hwRequirements6.worker) === null || _hwRequirements6$work === void 0 ? void 0 : _hwRequirements6$work.disk_size_gb
    },
    sno: {
      cpuCores: (_hwRequirements7 = hwRequirements) === null || _hwRequirements7 === void 0 ? void 0 : (_hwRequirements7$sno = _hwRequirements7.sno) === null || _hwRequirements7$sno === void 0 ? void 0 : _hwRequirements7$sno.cpu_cores,
      ramMib: (_hwRequirements8 = hwRequirements) === null || _hwRequirements8 === void 0 ? void 0 : (_hwRequirements8$sno = _hwRequirements8.sno) === null || _hwRequirements8$sno === void 0 ? void 0 : _hwRequirements8$sno.ram_mib,
      diskSizeGb: (_hwRequirements9 = hwRequirements) === null || _hwRequirements9 === void 0 ? void 0 : (_hwRequirements9$sno = _hwRequirements9.sno) === null || _hwRequirements9$sno === void 0 ? void 0 : _hwRequirements9$sno.disk_size_gb
    }
  };
};

var MinimalHWRequirements = function MinimalHWRequirements(_ref) {
  var aiConfigMap = _ref.aiConfigMap,
      isSNOCluster = _ref.isSNOCluster;

  var _React$useState = useState(false),
      isHostRequirementsOpen = _React$useState[0],
      setHostRequirementsOpen = _React$useState[1];

  return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(Button, {
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return setHostRequirementsOpen(true);
    },
    isInline: true,
    className: "host-requirements-link"
  }, /*#__PURE__*/createElement(InfoCircleIcon, {
    size: "sm"
  }), "\xA0Minimum hardware requirements"), /*#__PURE__*/createElement(Modal, {
    title: "Minimum hardware requirements",
    isOpen: isHostRequirementsOpen,
    actions: [/*#__PURE__*/createElement(Button, {
      key: "close",
      variant: ButtonVariant.primary,
      onClick: function onClick() {
        return setHostRequirementsOpen(false);
      }
    }, "Close")],
    onClose: function onClose() {
      return setHostRequirementsOpen(false);
    },
    variant: ModalVariant.medium
  }, /*#__PURE__*/createElement(HostRequirements, _extends({}, getHWRequirements(aiConfigMap), {
    isSNOCluster: isSNOCluster
  }))));
};

var EnvironmentDetails = function EnvironmentDetails(_ref) {
  var _infraEnv$metadata, _infraEnv$metadata$la, _infraEnv$metadata2, _infraEnv$metadata2$l, _infraEnv$metadata3, _infraEnv$metadata5, _infraEnv$spec, _infraEnv$spec2, _infraEnv$spec3;

  var infraEnv = _ref.infraEnv,
      aiConfigMap = _ref.aiConfigMap;
  return /*#__PURE__*/createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/createElement(GridItem, {
    span: 12
  }, /*#__PURE__*/createElement(Title, {
    headingLevel: "h1",
    size: TitleSizes.lg
  }, "Environment details")), /*#__PURE__*/createElement(GridItem, {
    span: 6
  }, /*#__PURE__*/createElement(DescriptionList, null, /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "Infrastructure Environment name"), /*#__PURE__*/createElement(DescriptionListDescription, null, (_infraEnv$metadata = infraEnv.metadata) === null || _infraEnv$metadata === void 0 ? void 0 : _infraEnv$metadata.name)), /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "Location"), /*#__PURE__*/createElement(DescriptionListDescription, null, (_infraEnv$metadata$la = (_infraEnv$metadata2 = infraEnv.metadata) === null || _infraEnv$metadata2 === void 0 ? void 0 : (_infraEnv$metadata2$l = _infraEnv$metadata2.labels) === null || _infraEnv$metadata2$l === void 0 ? void 0 : _infraEnv$metadata2$l[AGENT_LOCATION_LABEL_KEY]) != null ? _infraEnv$metadata$la : 'No location')), /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "Labels"), /*#__PURE__*/createElement(DescriptionListDescription, null, Object.keys(((_infraEnv$metadata3 = infraEnv.metadata) === null || _infraEnv$metadata3 === void 0 ? void 0 : _infraEnv$metadata3.labels) || {}).map(function (k) {
    var _infraEnv$metadata4, _infraEnv$metadata4$l;

    return /*#__PURE__*/createElement(LabelValue, {
      key: k,
      value: k + "=" + ((_infraEnv$metadata4 = infraEnv.metadata) === null || _infraEnv$metadata4 === void 0 ? void 0 : (_infraEnv$metadata4$l = _infraEnv$metadata4.labels) === null || _infraEnv$metadata4$l === void 0 ? void 0 : _infraEnv$metadata4$l[k])
    });
  }))), ((_infraEnv$metadata5 = infraEnv.metadata) === null || _infraEnv$metadata5 === void 0 ? void 0 : _infraEnv$metadata5.creationTimestamp) && /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "Created at"), /*#__PURE__*/createElement(DescriptionListDescription, null, new Date(infraEnv.metadata.creationTimestamp).toString())))), /*#__PURE__*/createElement(GridItem, {
    span: 6
  }, /*#__PURE__*/createElement(DescriptionList, null, ((_infraEnv$spec = infraEnv.spec) === null || _infraEnv$spec === void 0 ? void 0 : _infraEnv$spec.proxy) && /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "HTTP Proxy URL"), /*#__PURE__*/createElement(DescriptionListDescription, null, infraEnv.spec.proxy.httpProxy)), /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "HTTPS Proxy URL"), /*#__PURE__*/createElement(DescriptionListDescription, null, infraEnv.spec.proxy.httpsProxy)), /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "No proxy domains"), /*#__PURE__*/createElement(DescriptionListDescription, null, infraEnv.spec.proxy.noProxy))), /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListTerm, null, "Secret and keys"), /*#__PURE__*/createElement(DescriptionListDescription, null, /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement("div", null, ((_infraEnv$spec2 = infraEnv.spec) === null || _infraEnv$spec2 === void 0 ? void 0 : _infraEnv$spec2.pullSecretRef) ? /*#__PURE__*/createElement(CheckCircleIcon, {
    color: global_palette_green_500.value
  }) : /*#__PURE__*/createElement(ExclamationTriangleIcon, {
    color: global_warning_color_100$1.value
  }), "\xA0Pull Secret"), /*#__PURE__*/createElement("div", null, ((_infraEnv$spec3 = infraEnv.spec) === null || _infraEnv$spec3 === void 0 ? void 0 : _infraEnv$spec3.sshAuthorizedKey) ? /*#__PURE__*/createElement(CheckCircleIcon, {
    color: global_palette_green_500.value
  }) : /*#__PURE__*/createElement(ExclamationTriangleIcon, {
    color: global_warning_color_100$1.value
  }), "\xA0Public SSH Key")))), aiConfigMap && /*#__PURE__*/createElement(DescriptionListGroup, null, /*#__PURE__*/createElement(DescriptionListDescription, null, /*#__PURE__*/createElement(MinimalHWRequirements, {
    aiConfigMap: aiConfigMap
  }))))));
};

var AgentStatus = function AgentStatus(_ref) {
  var _agent$status, _agent$status$invento, _agent$status$invento2, _agent$status$invento3, _agent$status2;

  var agent = _ref.agent,
      onApprove = _ref.onApprove,
      onEditHostname = _ref.onEditHostname;

  var _getAIHosts = getAIHosts([agent]),
      host = _getAIHosts[0];

  var editHostname = onEditHostname ? function () {
    return onEditHostname(agent);
  } : undefined;
  var pendingApproval = !agent.spec.approved;
  var macAddress = (_agent$status = agent.status) === null || _agent$status === void 0 ? void 0 : (_agent$status$invento = _agent$status.inventory) === null || _agent$status$invento === void 0 ? void 0 : (_agent$status$invento2 = _agent$status$invento.interfaces) === null || _agent$status$invento2 === void 0 ? void 0 : (_agent$status$invento3 = _agent$status$invento2[0]) === null || _agent$status$invento3 === void 0 ? void 0 : _agent$status$invento3.macAddress;
  var hostname = getHostname(host, ((_agent$status2 = agent.status) === null || _agent$status2 === void 0 ? void 0 : _agent$status2.inventory) || {});

  var _getAgentStatus = getAgentStatus(agent),
      status = _getAgentStatus[0],
      validationsInfo = _getAgentStatus[2];

  return /*#__PURE__*/createElement(Stack, null, /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(HostStatus, {
    host: host,
    onEditHostname: editHostname,
    validationsInfo: validationsInfo,
    statusOverride: status
  })), pendingApproval && onApprove && /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Popover, {
    "aria-label": "Approve host popover",
    minWidth: "30rem",
    maxWidth: "50rem",
    headerContent: /*#__PURE__*/createElement("div", null, "Approve host to join infrastructure environment"),
    bodyContent: /*#__PURE__*/createElement(Fragment, null, hostname && /*#__PURE__*/createElement("div", null, "Hostname: ", hostname), macAddress && /*#__PURE__*/createElement("div", null, "MAC address: ", macAddress)),
    footerContent: /*#__PURE__*/createElement(Button, {
      variant: "link",
      onClick: function onClick() {
        return onApprove(agent);
      },
      isInline: true
    }, "Approve host")
  }, /*#__PURE__*/createElement(Button, {
    variant: "link",
    isInline: true,
    className: "pf-u-font-size-xs"
  }, "Approve host"))));
};

var getClusterWizardFirstStep = function getClusterWizardFirstStep(state) {
  switch (state) {
    case 'ready':
      return 'review';

    case 'pending-for-input':
    case 'adding-hosts':
    case 'insufficient':
      return 'host-discovery';

    default:
      return 'cluster-details';
  }
};
var clusterDetailsStepValidationsMap = {
  cluster: {
    groups: [],
    validationIds: ['pull-secret-set', 'dns-domain-defined']
  },
  host: {
    allowedStatuses: [],
    groups: [],
    validationIds: []
  },
  softValidationIds: []
};
var hostDiscoveryStepValidationsMap = {
  cluster: {
    groups: [],
    validationIds: ['sufficient-masters-count', 'ocs-requirements-satisfied', 'lso-requirements-satisfied', 'cnv-requirements-satisfied']
  },
  host: {
    allowedStatuses: ['known', 'disabled'],
    groups: ['hardware'],
    validationIds: ['connected', 'ocs-requirements-satisfied', 'lso-requirements-satisfied', 'cnv-requirements-satisfied']
  },
  softValidationIds: []
};
var networkingStepValidationsMap = {
  cluster: {
    groups: ['network'],
    validationIds: []
  },
  host: {
    allowedStatuses: ['known', 'disabled'],
    groups: ['network'],
    validationIds: []
  },
  softValidationIds: ['ntp-synced', 'container-images-available']
};
var reviewStepValidationsMap = {
  cluster: {
    groups: [],
    validationIds: ['all-hosts-are-ready-to-install']
  },
  host: {
    allowedStatuses: ['known', 'disabled'],
    groups: [],
    validationIds: []
  },
  softValidationIds: []
};
var wizardStepsValidationsMap = {
  'cluster-details': clusterDetailsStepValidationsMap,
  'host-discovery': hostDiscoveryStepValidationsMap,
  networking: networkingStepValidationsMap,
  review: reviewStepValidationsMap
};
var allClusterWizardSoftValidationIds = Object.keys(wizardStepsValidationsMap).reduce(function (prev, curr) {
  return [].concat(prev, wizardStepsValidationsMap[curr].softValidationIds);
}, []);
var getFailingClusterWizardSoftValidationIds = function getFailingClusterWizardSoftValidationIds(wizardHostStepValidationsInfo, wizardStepId) {
  var failingValidationIds = Object.keys(wizardHostStepValidationsInfo).reduce(function (curr, group) {
    var failingValidations = wizardHostStepValidationsInfo[group].filter(function (validation) {
      return validation.status === 'failure';
    });
    return [].concat(curr, failingValidations);
  }, []).map(function (validation) {
    return validation.id;
  });
  return failingValidationIds.filter(function (id) {
    return wizardStepsValidationsMap[wizardStepId].softValidationIds.includes(id);
  });
};
var checkClusterValidations = function checkClusterValidations(clusterValidationsInfo, requiredIds) {
  var requiredValidations = ___default.values(clusterValidationsInfo).flat().filter(function (v) {
    return v && requiredIds.includes(v.id);
  });

  return requiredValidations.length === requiredIds.length && requiredValidations.every(function (v) {
    return (v === null || v === void 0 ? void 0 : v.status) === 'disabled' || (v === null || v === void 0 ? void 0 : v.status) === 'success';
  });
};
var checkClusterValidationGroups = function checkClusterValidationGroups(clusterValidationsInfo, groups, softValidationIds) {
  return groups.every(function (group) {
    var _clusterValidationsIn;

    return (_clusterValidationsIn = clusterValidationsInfo[group]) === null || _clusterValidationsIn === void 0 ? void 0 : _clusterValidationsIn.every(function (validation) {
      return validation.status === 'disabled' || validation.status === 'success' || softValidationIds.includes(validation.id);
    });
  });
};
var checkHostValidations = function checkHostValidations(hostValidationsInfo, requiredIds) {
  var requiredValidations = ___default.values(hostValidationsInfo).flat().filter(function (v) {
    return v && requiredIds.includes(v.id);
  });

  return requiredValidations.length === requiredIds.length && requiredValidations.every(function (v) {
    return (v === null || v === void 0 ? void 0 : v.status) === 'disabled' || (v === null || v === void 0 ? void 0 : v.status) === 'success';
  });
};
var checkHostValidationGroups = function checkHostValidationGroups(hostValidationsInfo, groups, softValidationIds) {
  return groups.every(function (group) {
    var _hostValidationsInfo$;

    return (_hostValidationsInfo$ = hostValidationsInfo[group]) === null || _hostValidationsInfo$ === void 0 ? void 0 : _hostValidationsInfo$.every(function (validation) {
      return validation.status === 'disabled' || validation.status === 'success' || softValidationIds.includes(validation.id);
    });
  });
};
var getWizardStepHostValidationsInfo = function getWizardStepHostValidationsInfo(validationsInfo, wizardStepId) {
  var _wizardStepsValidatio = wizardStepsValidationsMap[wizardStepId].host,
      groups = _wizardStepsValidatio.groups,
      validationIds = _wizardStepsValidatio.validationIds;
  return ___default.reduce(validationsInfo, function (result, groupValidations, groupName) {
    if (groups.includes(groupName)) {
      result[groupName] = groupValidations;
      return result;
    }

    var selectedValidations = (groupValidations || []).filter(function (validation) {
      return validationIds.includes(validation.id);
    });

    if (selectedValidations.length) {
      result[groupName] = selectedValidations;
      return result;
    }

    return result;
  }, {});
};
var getWizardStepHostStatus = function getWizardStepHostStatus(host, wizardStepId) {
  var status = host.status;

  if (['insufficient', 'pending-for-input'].includes(status)) {
    var softValidationIds = wizardStepsValidationsMap[wizardStepId].softValidationIds;
    var validationsInfo = stringToJSON(host.validationsInfo) || {};
    var _wizardStepsValidatio2 = wizardStepsValidationsMap[wizardStepId].host,
        groups = _wizardStepsValidatio2.groups,
        validationIds = _wizardStepsValidatio2.validationIds;
    return checkHostValidationGroups(validationsInfo, groups, softValidationIds) && checkHostValidations(validationsInfo, validationIds) ? 'known' : status;
  }

  return status;
};
var getWizardStepClusterValidationsInfo = function getWizardStepClusterValidationsInfo(validationsInfo, wizardStepId) {
  var _wizardStepsValidatio3 = wizardStepsValidationsMap[wizardStepId].cluster,
      groups = _wizardStepsValidatio3.groups,
      validationIds = _wizardStepsValidatio3.validationIds;
  return ___default.reduce(validationsInfo, function (result, groupValidations, groupName) {
    if (groups.includes(groupName)) {
      result[groupName] = groupValidations;
      return result;
    }

    var selectedValidations = (groupValidations || []).filter(function (validation) {
      return validationIds.includes(validation.id);
    });

    if (selectedValidations.length) {
      result[groupName] = selectedValidations;
      return result;
    }

    return result;
  }, {});
};
var getWizardStepClusterStatus = function getWizardStepClusterStatus(cluster, wizardStepId) {
  var status = cluster.status;

  if (['insufficient', 'pending-for-input'].includes(status)) {
    var validationsInfo = stringToJSON(cluster.validationsInfo) || {};
    var _wizardStepsValidatio4 = wizardStepsValidationsMap[wizardStepId].cluster,
        groups = _wizardStepsValidatio4.groups,
        validationIds = _wizardStepsValidatio4.validationIds;
    var softValidationIds = wizardStepsValidationsMap[wizardStepId].softValidationIds;
    var allowedStatuses = wizardStepsValidationsMap[wizardStepId].host.allowedStatuses;
    var allHostsReady = ((cluster === null || cluster === void 0 ? void 0 : cluster.hosts) || []).every(function (host) {
      return allowedStatuses.length === 0 || allowedStatuses.includes(getWizardStepHostStatus(host, wizardStepId));
    });
    return allHostsReady && checkClusterValidationGroups(validationsInfo, groups, softValidationIds) && checkClusterValidations(validationsInfo, validationIds) ? 'ready' : status;
  }

  return status;
};
var findValidationFixStep = function findValidationFixStep(_ref) {
  var id = _ref.id,
      hostGroup = _ref.hostGroup,
      clusterGroup = _ref.clusterGroup;

  var keys = ___default.keys(wizardStepsValidationsMap);

  return keys.find(function (key) {
    var _wizardStepsValidatio5 = wizardStepsValidationsMap[key],
        clusterValidationMap = _wizardStepsValidatio5.cluster,
        hostValidationMap = _wizardStepsValidatio5.host;
    return clusterValidationMap.validationIds.includes(id) || hostValidationMap.validationIds.includes(id) || clusterGroup && clusterValidationMap.groups.includes(clusterGroup) || hostGroup && hostValidationMap.groups.includes(hostGroup);
  });
};
var canNextClusterDetails = function canNextClusterDetails(_ref2) {
  var cluster = _ref2.cluster;
  return getWizardStepClusterStatus(cluster, 'cluster-details') === 'ready';
};
var canNextHostDiscovery = function canNextHostDiscovery(_ref3) {
  var cluster = _ref3.cluster;
  return getWizardStepClusterStatus(cluster, 'host-discovery') === 'ready';
};
var canNextNetwork = function canNextNetwork(_ref4) {
  var cluster = _ref4.cluster;
  return getWizardStepClusterStatus(cluster, 'networking') === 'ready';
};

var _dialogsSlice$actions = dialogsSlice.actions,
    openDialogAction = _dialogsSlice$actions.openDialog,
    closeDialogAction = _dialogsSlice$actions.closeDialog;
var dialogsReducer = dialogsSlice.reducer;
var dialogIds = ['eventsDialog', 'editHostDialog', 'deleteHostDialog', 'resetHostDialog', 'additionalNTPSourcesDialog', 'resetClusterDialog', 'cancelInstallationDialog', 'discoveryImageDialog'];
var ModalDialogsContext = React__default.createContext(undefined);

var ModalDialogsContextProvider = function ModalDialogsContextProvider(_ref) {
  var children = _ref.children;

  var _React$useReducer = React__default.useReducer(dialogsReducer, {}),
      dialogsState = _React$useReducer[0],
      dispatchDialogsAction = _React$useReducer[1];

  function getOpenDialog(dialogId) {
    return function (data) {
      return dispatchDialogsAction(openDialogAction({
        dialogId: dialogId,
        data: data
      }));
    };
  }

  var getCloseDialog = function getCloseDialog(dialogId) {
    return function () {
      return dispatchDialogsAction(closeDialogAction({
        dialogId: dialogId
      }));
    };
  };

  var context = dialogIds.reduce(function (context, dialogId) {
    context[dialogId] = {
      isOpen: !!dialogsState[dialogId],
      open: function open(data) {
        return getOpenDialog(dialogId)(data);
      },
      close: function close() {
        return getCloseDialog(dialogId)();
      },
      data: dialogsState[dialogId]
    };
    return context;
  }, {});
  return /*#__PURE__*/React__default.createElement(ModalDialogsContext.Provider, {
    value: context
  }, children);
};

var useModalDialogsContext = function useModalDialogsContext() {
  var context = React__default.useContext(ModalDialogsContext);

  if (context === undefined) {
    throw new Error('useModalDialogsContext must be used within a ModalDialogsContextProvider');
  }

  return context;
};

var AdditionalNTPSourcesDialogToggle = function AdditionalNTPSourcesDialogToggle() {
  var _useModalDialogsConte = useModalDialogsContext(),
      open = _useModalDialogsConte.additionalNTPSourcesDialog.open;

  return /*#__PURE__*/React__default.createElement(AlertActionLink, {
    onClick: function onClick() {
      return open();
    }
  }, "Add NTP sources");
};

var HardwareStatus = function HardwareStatus(props) {
  var hardwareStatus = getWizardStepHostStatus(props.host, 'host-discovery');
  var validationsInfo = getWizardStepHostValidationsInfo(props.validationsInfo, 'host-discovery');
  var sublabel = getFailingClusterWizardSoftValidationIds(validationsInfo, 'host-discovery').length ? 'Some validations failed' : undefined;
  return /*#__PURE__*/React__default.createElement(HostStatus, _extends({}, props, {
    statusOverride: hardwareStatus,
    validationsInfo: validationsInfo,
    sublabel: sublabel,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle
  }));
};

var NetworkingStatus = function NetworkingStatus(props) {
  var networkingStatus = getWizardStepHostStatus(props.host, 'networking');
  var validationsInfo = getWizardStepHostValidationsInfo(props.validationsInfo, 'networking');
  var sublabel = getFailingClusterWizardSoftValidationIds(validationsInfo, 'networking').length ? 'Some validations failed' : undefined;
  return /*#__PURE__*/React__default.createElement(HostStatus, _extends({}, props, {
    statusOverride: networkingStatus,
    validationsInfo: validationsInfo,
    sublabel: sublabel,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle
  }));
};

var getMemoryCapacity = function getMemoryCapacity(inventory) {
  var _inventory$memory;

  return ((_inventory$memory = inventory.memory) === null || _inventory$memory === void 0 ? void 0 : _inventory$memory.physicalBytes) || 0;
};
var getDiskCapacity = function getDiskCapacity(inventory) {
  var _inventory$disks;

  return ((_inventory$disks = inventory.disks) === null || _inventory$disks === void 0 ? void 0 : _inventory$disks.filter(function (disk) {
    return disk.driveType !== OpticalDiskDriveType;
  }).reduce(function (diskSize, disk) {
    return diskSize + (disk.sizeBytes || 0);
  }, 0)) || 0;
};
var getHumanizedCpuClockSpeed = function getHumanizedCpuClockSpeed(inventory) {
  var _inventory$cpu;

  return Humanize.formatNumber(((_inventory$cpu = inventory.cpu) === null || _inventory$cpu === void 0 ? void 0 : _inventory$cpu.frequency) || 0);
};
var getSimpleHardwareInfo = function getSimpleHardwareInfo(inventory) {
  var _inventory$cpu2;

  return {
    cores: ((_inventory$cpu2 = inventory.cpu) === null || _inventory$cpu2 === void 0 ? void 0 : _inventory$cpu2.count) || 0,
    memory: getMemoryCapacity(inventory),
    disks: getDiskCapacity(inventory)
  };
};
var EMPTY = {
  title: DASH,
  sortableValue: 0
};
var getHostRowHardwareInfo = function getHostRowHardwareInfo(inventory) {
  var _inventory$cpu3, _inventory$systemVend;

  var cores = EMPTY;
  var memory = EMPTY;
  var disk = EMPTY;
  var cpuSpeed = DASH;

  if ((_inventory$cpu3 = inventory.cpu) === null || _inventory$cpu3 === void 0 ? void 0 : _inventory$cpu3.count) {
    var _inventory$cpu4, _inventory$cpu4$flags, _inventory$cpu5, _inventory$cpu6, _inventory$cpu7;

    var hyperThreading = ((_inventory$cpu4 = inventory.cpu) === null || _inventory$cpu4 === void 0 ? void 0 : (_inventory$cpu4$flags = _inventory$cpu4.flags) === null || _inventory$cpu4$flags === void 0 ? void 0 : _inventory$cpu4$flags.includes('ht')) ? ' (hyper-threaded)' : '';
    cpuSpeed = ((_inventory$cpu5 = inventory.cpu) === null || _inventory$cpu5 === void 0 ? void 0 : _inventory$cpu5.count) + " cores" + hyperThreading + " at " + getHumanizedCpuClockSpeed(inventory) + " MHz";
    cores = {
      title: (_inventory$cpu6 = inventory.cpu) === null || _inventory$cpu6 === void 0 ? void 0 : _inventory$cpu6.count.toString(),
      sortableValue: (_inventory$cpu7 = inventory.cpu) === null || _inventory$cpu7 === void 0 ? void 0 : _inventory$cpu7.count
    };
  }

  var memCapacity = getMemoryCapacity(inventory);

  if (memCapacity) {
    memory = {
      title: fileSize(memCapacity, 2, 'iec'),
      sortableValue: memCapacity
    };
  }

  var disksCapacity = getDiskCapacity(inventory);

  if (disksCapacity) {
    disk = {
      title: fileSize(disksCapacity, 2, 'si'),
      sortableValue: disksCapacity
    };
  }

  return {
    serialNumber: ((_inventory$systemVend = inventory.systemVendor) === null || _inventory$systemVend === void 0 ? void 0 : _inventory$systemVend.serialNumber) || DASH,
    cores: cores,
    cpuSpeed: cpuSpeed,
    memory: memory,
    disk: disk
  };
};

var ValidationPopover = function ValidationPopover(_ref) {
  var validation = _ref.validation,
      actions = _ref.actions,
      children = _ref.children;
  var failedValidationHint = HOST_VALIDATION_FAILURE_HINTS[validation.id];
  return /*#__PURE__*/React__default.createElement(Popover, {
    headerContent: /*#__PURE__*/React__default.createElement("div", null, HOST_VALIDATION_LABELS[validation.id]),
    bodyContent: /*#__PURE__*/React__default.createElement("div", null, toSentence(validation.message), validation.status === 'failure' && failedValidationHint && " " + failedValidationHint),
    footerContent: actions,
    zIndex: 300
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true
  }, children));
};

var HostPropertyValidationPopover = function HostPropertyValidationPopover(_ref2) {
  var validation = _ref2.validation,
      failureActions = _ref2.failureActions,
      pendingActions = _ref2.pendingActions,
      children = _ref2.children,
      _ref2$showFailure = _ref2.showFailure,
      showFailure = _ref2$showFailure === void 0 ? true : _ref2$showFailure,
      _ref2$showPending = _ref2.showPending,
      showPending = _ref2$showPending === void 0 ? false : _ref2$showPending,
      _ref2$showSuccess = _ref2.showSuccess,
      showSuccess = _ref2$showSuccess === void 0 ? false : _ref2$showSuccess;

  if (validation) {
    if (showFailure && validation.status === 'failure') {
      return /*#__PURE__*/React__default.createElement(ValidationPopover, {
        validation: validation,
        actions: failureActions
      }, /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
        color: global_danger_color_100.value
      }), " ", children);
    }

    if (showPending && validation.status === 'pending') {
      return /*#__PURE__*/React__default.createElement(ValidationPopover, {
        validation: validation,
        actions: pendingActions
      }, /*#__PURE__*/React__default.createElement(PendingIcon, null), " ", children);
    }

    if (showSuccess && validation.status === 'success') {
      return /*#__PURE__*/React__default.createElement(ValidationPopover, {
        validation: validation
      }, /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
        color: global_success_color_100.value
      }), " ", children);
    }
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, children);
};

var getSelectedNic = function getSelectedNic(nics, currentSubnet) {
  return nics.find(function (nic) {
    var ipv4Addresses = (nic.ipv4Addresses || []).reduce(function (addresses, address) {
      if (Address4.isValid(address)) {
        addresses.push(new Address4(address));
      }

      return addresses;
    }, []);

    if (ipv4Addresses.find(function (address) {
      return address.isInSubnet(currentSubnet);
    })) {
      return true;
    }

    var ipv6Addresses = (nic.ipv6Addresses || []).reduce(function (addresses, address) {
      if (Address6.isValid(address)) {
        addresses.push(new Address6(address));
      }

      return addresses;
    }, []);
    return ipv6Addresses.find(function (address) {
      return address.isInSubnet(currentSubnet);
    });
  });
};
var hostnameColumn = function hostnameColumn(onEditHostname, hosts) {
  return {
    header: {
      title: 'Hostname',
      props: {
        id: 'col-header-hostname'
      },
      transforms: [sortable$1],
      cellFormatters: [expandable],
      cellTransforms: [breakWord$1]
    },
    cell: function cell(host) {
      var _host$inventory = host.inventory,
          inventoryString = _host$inventory === void 0 ? '' : _host$inventory;
      var inventory = stringToJSON(inventoryString) || {};
      var editHostname = onEditHostname ? function () {
        return onEditHostname(host);
      } : undefined;
      var computedHostname = getHostname(host, inventory);
      return {
        title: /*#__PURE__*/createElement(Hostname, {
          host: host,
          inventory: inventory,
          onEditHostname: editHostname,
          hosts: hosts
        }),
        props: {
          'data-testid': 'host-name'
        },
        sortableValue: computedHostname || ''
      };
    }
  };
};
var roleColumn = function roleColumn(canEditRole, onEditRole) {
  return {
    header: {
      title: 'Role',
      props: {
        id: 'col-header-role'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var editRole = onEditRole ? function (role) {
        return onEditRole(host, role);
      } : undefined;
      var hostRole = getHostRole(host);
      return {
        title: /*#__PURE__*/createElement(RoleCell, {
          host: host,
          readonly: !(canEditRole === null || canEditRole === void 0 ? void 0 : canEditRole(host)),
          role: hostRole,
          onEditRole: editRole
        }),
        props: {
          'data-testid': 'host-role'
        },
        sortableValue: hostRole
      };
    }
  };
};
var statusColumn = function statusColumn(AdditionalNTPSourcesDialogToggleComponent, onEditHostname) {
  return {
    header: {
      title: 'Status',
      props: {
        id: 'col-header-status'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var validationsInfo = stringToJSON(host.validationsInfo) || {};
      var editHostname = onEditHostname ? function () {
        return onEditHostname(host);
      } : undefined;
      return {
        title: /*#__PURE__*/createElement(HostStatus, {
          host: host,
          onEditHostname: editHostname,
          validationsInfo: validationsInfo,
          AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggleComponent
        }),
        props: {
          'data-testid': 'host-status'
        },
        sortableValue: host.status
      };
    }
  };
};
var hardwareStatusColumn = function hardwareStatusColumn(onEditHostname) {
  return {
    header: {
      title: 'Status',
      props: {
        id: 'col-header-hwstatus'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var validationsInfo = stringToJSON(host.validationsInfo) || {};
      var editHostname = onEditHostname ? function () {
        return onEditHostname(host);
      } : undefined;
      return {
        title: /*#__PURE__*/createElement(HardwareStatus, {
          host: host,
          onEditHostname: editHostname,
          validationsInfo: validationsInfo
        }),
        props: {
          'data-testid': 'host-hw-status'
        },
        sortableValue: status
      };
    }
  };
};
var discoveredAtColumn = {
  header: {
    title: 'Discovered at',
    props: {
      id: 'col-header-discoveredat'
    },
    transforms: [sortable$1]
  },
  cell: function cell(host) {
    var createdAt = host.createdAt;
    var dateTimeCell = getDateTimeCell(createdAt);
    return {
      title: dateTimeCell.title,
      props: {
        'data-testid': 'host-discovered-time'
      },
      sortableValue: dateTimeCell.sortableValue
    };
  }
};
var cpuCoresColumn = {
  header: {
    title: 'CPU Cores',
    props: {
      id: 'col-header-cpucores'
    },
    transforms: [sortable$1]
  },
  cell: function cell(host) {
    var _validationsInfo$hard;

    var _host$inventory2 = host.inventory,
        inventoryString = _host$inventory2 === void 0 ? '' : _host$inventory2;
    var inventory = stringToJSON(inventoryString) || {};

    var _getHostRowHardwareIn = getHostRowHardwareInfo(inventory),
        cores = _getHostRowHardwareIn.cores;

    var validationsInfo = stringToJSON(host.validationsInfo) || {};
    var cpuCoresValidation = validationsInfo === null || validationsInfo === void 0 ? void 0 : (_validationsInfo$hard = validationsInfo.hardware) === null || _validationsInfo$hard === void 0 ? void 0 : _validationsInfo$hard.find(function (v) {
      return v.id === 'has-cpu-cores-for-role';
    });
    return {
      title: /*#__PURE__*/createElement(HostPropertyValidationPopover, {
        validation: cpuCoresValidation
      }, cores.title),
      props: {
        'data-testid': 'host-cpu-cores'
      },
      sortableValue: cores.sortableValue
    };
  }
};
var memoryColumn = {
  header: {
    title: 'Memory',
    props: {
      id: 'col-header-memory'
    },
    transforms: [sortable$1]
  },
  cell: function cell(host) {
    var _validationsInfo$hard2;

    var _host$inventory3 = host.inventory,
        inventoryString = _host$inventory3 === void 0 ? '' : _host$inventory3;
    var inventory = stringToJSON(inventoryString) || {};

    var _getHostRowHardwareIn2 = getHostRowHardwareInfo(inventory),
        memory = _getHostRowHardwareIn2.memory;

    var validationsInfo = stringToJSON(host.validationsInfo) || {};
    var memoryValidation = validationsInfo === null || validationsInfo === void 0 ? void 0 : (_validationsInfo$hard2 = validationsInfo.hardware) === null || _validationsInfo$hard2 === void 0 ? void 0 : _validationsInfo$hard2.find(function (v) {
      return v.id === 'has-memory-for-role';
    });
    return {
      title: /*#__PURE__*/createElement(HostPropertyValidationPopover, {
        validation: memoryValidation
      }, memory.title),
      props: {
        'data-testid': 'host-memory'
      },
      sortableValue: memory.sortableValue
    };
  }
};
var disksColumn = {
  header: {
    title: 'Disk',
    props: {
      id: 'col-header-disk'
    },
    transforms: [sortable$1]
  },
  cell: function cell(host) {
    var _validationsInfo$hard3;

    var _host$inventory4 = host.inventory,
        inventoryString = _host$inventory4 === void 0 ? '' : _host$inventory4;
    var inventory = stringToJSON(inventoryString) || {};

    var _getHostRowHardwareIn3 = getHostRowHardwareInfo(inventory),
        disk = _getHostRowHardwareIn3.disk;

    var validationsInfo = stringToJSON(host.validationsInfo) || {};
    var diskValidation = validationsInfo === null || validationsInfo === void 0 ? void 0 : (_validationsInfo$hard3 = validationsInfo.hardware) === null || _validationsInfo$hard3 === void 0 ? void 0 : _validationsInfo$hard3.find(function (v) {
      return v.id === 'has-min-valid-disks';
    });
    return {
      title: /*#__PURE__*/createElement(HostPropertyValidationPopover, {
        validation: diskValidation
      }, disk.title),
      props: {
        'data-testid': 'host-disks'
      },
      sortableValue: disk.sortableValue
    };
  }
};
var countColumn = function countColumn(cluster) {
  return {
    header: {
      title: /*#__PURE__*/createElement(HostsCount, {
        cluster: cluster,
        inParenthesis: true
      })
    }
  };
};
var networkingStatusColumn = function networkingStatusColumn(onEditHostname) {
  return {
    header: {
      title: 'Status',
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var editHostname = onEditHostname ? function () {
        return onEditHostname(host);
      } : undefined;
      var validationsInfo = stringToJSON(host.validationsInfo) || {};
      return {
        title: /*#__PURE__*/createElement(NetworkingStatus, {
          host: host,
          onEditHostname: editHostname,
          validationsInfo: validationsInfo
        }),
        props: {
          'data-testid': 'nic-status'
        },
        sortableValue: status
      };
    }
  };
};
var activeNICColumn = function activeNICColumn(cluster) {
  return {
    header: {
      title: 'Active NIC',
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _host$inventory5 = host.inventory,
          inventoryString = _host$inventory5 === void 0 ? '' : _host$inventory5;
      var inventory = stringToJSON(inventoryString) || {};
      var nics = inventory.interfaces || [];
      var currentSubnet = cluster.machineNetworkCidr ? getSubnet(cluster.machineNetworkCidr) : null;
      var selectedNic = currentSubnet ? getSelectedNic(nics, currentSubnet) : null;
      return {
        title: (selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.name) || DASH,
        props: {
          'data-testid': 'nic-name'
        },
        sortableValue: (selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.name) || DASH
      };
    }
  };
};
var ipv4Column = function ipv4Column(cluster) {
  return {
    header: {
      title: 'IPv4 address',
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _host$inventory6 = host.inventory,
          inventoryString = _host$inventory6 === void 0 ? '' : _host$inventory6;
      var inventory = stringToJSON(inventoryString) || {};
      var nics = inventory.interfaces || [];
      var currentSubnet = cluster.machineNetworkCidr ? getSubnet(cluster.machineNetworkCidr) : null;
      var selectedNic = currentSubnet ? getSelectedNic(nics, currentSubnet) : null;
      return {
        title: ((selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.ipv4Addresses) || []).join(', ') || DASH,
        props: {
          'data-testid': 'nic-ipv4'
        },
        sortableValue: ((selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.ipv4Addresses) || []).join(', ') || DASH
      };
    }
  };
};
var ipv6Column = function ipv6Column(cluster) {
  return {
    header: {
      title: 'IPv6 address',
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _host$inventory7 = host.inventory,
          inventoryString = _host$inventory7 === void 0 ? '' : _host$inventory7;
      var inventory = stringToJSON(inventoryString) || {};
      var nics = inventory.interfaces || [];
      var currentSubnet = cluster.machineNetworkCidr ? getSubnet(cluster.machineNetworkCidr) : null;
      var selectedNic = currentSubnet ? getSelectedNic(nics, currentSubnet) : null;
      return {
        title: ((selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.ipv6Addresses) || []).join(', ') || DASH,
        props: {
          'data-testid': 'nic-ipv6'
        },
        sortableValue: ((selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.ipv6Addresses) || []).join(', ') || DASH
      };
    }
  };
};
var macAddressColumn = function macAddressColumn(cluster) {
  return {
    header: {
      title: 'MAC address',
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _host$inventory8 = host.inventory,
          inventoryString = _host$inventory8 === void 0 ? '' : _host$inventory8;
      var inventory = stringToJSON(inventoryString) || {};
      var nics = inventory.interfaces || [];
      var currentSubnet = cluster.machineNetworkCidr ? getSubnet(cluster.machineNetworkCidr) : null;
      var selectedNic = currentSubnet ? getSelectedNic(nics, currentSubnet) : null;
      return {
        title: (selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.macAddress) || DASH,
        props: {
          'data-testid': 'nic-mac-address'
        },
        sortableValue: (selectedNic === null || selectedNic === void 0 ? void 0 : selectedNic.macAddress) || DASH
      };
    }
  };
};
var hostActionResolver = function hostActionResolver(_ref) {
  var onInstallHost = _ref.onInstallHost,
      canInstallHost = _ref.canInstallHost,
      onEditHost = _ref.onEditHost,
      canEditHost = _ref.canEditHost,
      onHostEnable = _ref.onHostEnable,
      canEnable = _ref.canEnable,
      onHostDisable = _ref.onHostDisable,
      canDisable = _ref.canDisable,
      onHostReset = _ref.onHostReset,
      canReset = _ref.canReset,
      onViewHostEvents = _ref.onViewHostEvents,
      onDownloadHostLogs = _ref.onDownloadHostLogs,
      canDownloadHostLogs = _ref.canDownloadHostLogs,
      onDeleteHost = _ref.onDeleteHost,
      canDelete = _ref.canDelete,
      onEditBMH = _ref.onEditBMH,
      canEditBMH = _ref.canEditBMH;
  return function (host) {
    var actions = [];

    if (host) {
      var _host$inventory9 = host.inventory,
          inventoryString = _host$inventory9 === void 0 ? '' : _host$inventory9;
      var inventory = stringToJSON(inventoryString) || {};
      var hostname = getHostname(host, inventory);

      if (onInstallHost && (canInstallHost === null || canInstallHost === void 0 ? void 0 : canInstallHost(host))) {
        actions.push({
          title: 'Install host',
          id: "button-install-host-" + hostname,
          onClick: function onClick() {
            return onInstallHost(host);
          }
        });
      }

      if (onEditHost && (canEditHost === null || canEditHost === void 0 ? void 0 : canEditHost(host))) {
        actions.push({
          title: 'Edit host',
          id: "button-edit-host-" + hostname,
          onClick: function onClick() {
            return onEditHost(host);
          }
        });
      }

      if (onHostEnable && (canEnable === null || canEnable === void 0 ? void 0 : canEnable(host))) {
        actions.push({
          title: 'Enable in cluster',
          id: "button-enable-in-cluster-" + hostname,
          onClick: function onClick() {
            return onHostEnable(host);
          }
        });
      }

      if (onHostDisable && (canDisable === null || canDisable === void 0 ? void 0 : canDisable(host))) {
        actions.push({
          title: 'Disable in cluster',
          id: "button-disable-in-cluster-" + hostname,
          onClick: function onClick() {
            return onHostDisable(host);
          }
        });
      }

      if (onHostReset && (canReset === null || canReset === void 0 ? void 0 : canReset(host))) {
        actions.push({
          title: 'Reset host',
          id: "button-reset-host-" + hostname,
          onClick: function onClick() {
            return onHostReset(host);
          }
        });
      }

      if (onViewHostEvents) {
        actions.push({
          title: 'View host events',
          id: "button-view-host-events-" + hostname,
          onClick: function onClick() {
            return onViewHostEvents(host);
          }
        });
      }

      if (onDownloadHostLogs && (canDownloadHostLogs === null || canDownloadHostLogs === void 0 ? void 0 : canDownloadHostLogs(host))) {
        actions.push({
          title: 'Download host logs',
          id: "button-download-host-installation-logs-" + hostname,
          onClick: function onClick() {
            return onDownloadHostLogs(host);
          }
        });
      }

      if (onDeleteHost && (canDelete === null || canDelete === void 0 ? void 0 : canDelete(host))) {
        actions.push({
          title: 'Delete host',
          id: "button-delete-host-" + hostname,
          onClick: function onClick() {
            return onDeleteHost(host);
          }
        });
      }

      if (onEditBMH && (canEditBMH === null || canEditBMH === void 0 ? void 0 : canEditBMH(host))) {
        actions.push({
          title: 'Edit BMC',
          id: "button-edit-bmh-host-" + hostname,
          onClick: function onClick() {
            return onEditBMH(host);
          }
        });
      }
    }

    return actions;
  };
};

var NetworkingStatus$1 = function NetworkingStatus(_ref) {
  var host = _ref.host,
      onEditHostname = _ref.onEditHostname;
  var validationsInfo = stringToJSON(host.validationsInfo) || {};
  var networkingStatus = getWizardStepHostStatus(host, 'networking');
  var netValidationsInfo = getWizardStepHostValidationsInfo(validationsInfo, 'networking');
  var sublabel = getFailingClusterWizardSoftValidationIds(validationsInfo, 'networking').length ? 'Some validations failed' : undefined;
  var statusOverride = networkingStatus;

  if (networkingStatus === 'pending-for-input' || networkingStatus === 'insufficient') {
    statusOverride = 'Bound';
  }

  return /*#__PURE__*/createElement(HostStatus, {
    host: host,
    onEditHostname: onEditHostname,
    statusOverride: statusOverride,
    validationsInfo: netValidationsInfo,
    sublabel: sublabel,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle
  });
};

var discoveryTypeColumn = function discoveryTypeColumn(agents, bareMetalHosts) {
  return {
    header: {
      title: 'Discovery type',
      props: {
        id: 'col-header-discovery-type'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var agent = agents.find(function (a) {
        var _a$metadata;

        return ((_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : _a$metadata.uid) === host.id;
      });
      var discoveryType = 'Unknown';

      if (agent) {
        var _agent$metadata, _agent$metadata$label;

        discoveryType = (agent === null || agent === void 0 ? void 0 : (_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : (_agent$metadata$label = _agent$metadata.labels) === null || _agent$metadata$label === void 0 ? void 0 : _agent$metadata$label.hasOwnProperty(AGENT_BMH_HOSTNAME_LABEL_KEY)) ? 'BMC' : 'Discovery ISO';
      } else {
        var bmh = bareMetalHosts.find(function (bmh) {
          var _bmh$metadata;

          return ((_bmh$metadata = bmh.metadata) === null || _bmh$metadata === void 0 ? void 0 : _bmh$metadata.uid) === host.id;
        });

        if (bmh) {
          discoveryType = 'BMC';
        }
      }

      return {
        title: discoveryType,
        props: {
          'data-testid': 'discovery-type'
        },
        sortableValue: discoveryType
      };
    }
  };
};
var infraEnvStatusColumn = function infraEnvStatusColumn(_ref) {
  var agents = _ref.agents,
      bareMetalHosts = _ref.bareMetalHosts,
      onEditHostname = _ref.onEditHostname,
      onApprove = _ref.onApprove;
  return {
    header: {
      title: 'Status',
      props: {
        id: 'col-header-infraenvstatus'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _bmhStatus;

      var agent = agents.find(function (a) {
        var _a$metadata2;

        return ((_a$metadata2 = a.metadata) === null || _a$metadata2 === void 0 ? void 0 : _a$metadata2.uid) === host.id;
      });
      var bmh = bareMetalHosts === null || bareMetalHosts === void 0 ? void 0 : bareMetalHosts.find(function (b) {
        var _b$metadata;

        return ((_b$metadata = b.metadata) === null || _b$metadata === void 0 ? void 0 : _b$metadata.uid) === host.id;
      });
      var bmhStatus;
      var title = '--';

      if (agent) {
        var editHostname = onEditHostname ? function () {
          return onEditHostname(agent);
        } : undefined;
        title = /*#__PURE__*/createElement(AgentStatus, {
          agent: agent,
          onApprove: onApprove,
          onEditHostname: editHostname
        });
      } else if (bmh) {
        bmhStatus = getBMHStatus(bmh);
        title = bmhStatus.message ? /*#__PURE__*/createElement(Popover, {
          headerContent: "Error",
          bodyContent: bmhStatus.message,
          minWidth: "30rem",
          maxWidth: "50rem",
          hideOnOutsideClick: true,
          zIndex: 300
        }, /*#__PURE__*/createElement(Button, {
          variant: 'link',
          isInline: true
        }, bmhStatus.title)) : bmhStatus.title;
      }

      return {
        title: title,
        props: {
          'data-testid': 'host-status'
        },
        sortableValue: agent ? getAgentStatus(agent)[0] : ((_bmhStatus = bmhStatus) === null || _bmhStatus === void 0 ? void 0 : _bmhStatus.title) ? bmhStatus.title : ''
      };
    }
  };
};
var clusterColumn = function clusterColumn(agents, getClusterDeploymentLink) {
  return {
    header: {
      title: 'Cluster',
      props: {
        id: 'col-header-cluster'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _agent$spec, _agent$spec$clusterDe, _agent$spec2, _agent$spec2$clusterD;

      var agent = agents.find(function (a) {
        var _a$metadata3;

        return ((_a$metadata3 = a.metadata) === null || _a$metadata3 === void 0 ? void 0 : _a$metadata3.uid) === host.id;
      });
      var title = '--';

      if (agent === null || agent === void 0 ? void 0 : (_agent$spec = agent.spec) === null || _agent$spec === void 0 ? void 0 : _agent$spec.clusterDeploymentName) {
        title = /*#__PURE__*/createElement(Link, {
          to: getClusterDeploymentLink(agent.spec.clusterDeploymentName)
        }, agent.spec.clusterDeploymentName.name);
      }

      return {
        title: title,
        props: {
          'data-testid': 'cluster'
        },
        sortableValue: (_agent$spec$clusterDe = agent === null || agent === void 0 ? void 0 : (_agent$spec2 = agent.spec) === null || _agent$spec2 === void 0 ? void 0 : (_agent$spec2$clusterD = _agent$spec2.clusterDeploymentName) === null || _agent$spec2$clusterD === void 0 ? void 0 : _agent$spec2$clusterD.name) != null ? _agent$spec$clusterDe : '--'
      };
    }
  };
};
var infraEnvColumn = function infraEnvColumn(agents) {
  return {
    header: {
      title: 'Infrastructure env',
      props: {
        id: 'col-header-infraenv'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var _agent$metadata2, _agent$metadata2$labe;

      var agent = agents.find(function (a) {
        var _a$metadata4;

        return ((_a$metadata4 = a.metadata) === null || _a$metadata4 === void 0 ? void 0 : _a$metadata4.uid) === host.id;
      });
      var infraEnvName = ((_agent$metadata2 = agent.metadata) === null || _agent$metadata2 === void 0 ? void 0 : (_agent$metadata2$labe = _agent$metadata2.labels) === null || _agent$metadata2$labe === void 0 ? void 0 : _agent$metadata2$labe[INFRAENV_AGENTINSTALL_LABEL_KEY]) || 'N/A';
      return {
        title: infraEnvName,
        props: {
          'data-testid': 'infra-env'
        },
        sortableValue: infraEnvName
      };
    }
  };
};
var networkingStatusColumn$1 = function networkingStatusColumn(onEditHostname) {
  return {
    header: {
      title: 'Status',
      props: {
        id: 'col-header-networkingstatus'
      },
      transforms: [sortable$1]
    },
    cell: function cell(host) {
      var editHostname = onEditHostname ? function () {
        return onEditHostname(host);
      } : undefined;
      return {
        title: /*#__PURE__*/createElement(NetworkingStatus$1, {
          host: host,
          onEditHostname: editHostname
        }),
        props: {
          'data-testid': 'nic-status'
        },
        sortableValue: status
      };
    }
  };
};
var useAgentsTable = function useAgentsTable(_ref2, _ref3) {
  var onEditHost = _ref2.onEditHost,
      canEditHost = _ref2.canEditHost,
      onDeleteHost = _ref2.onDeleteHost,
      canDelete = _ref2.canDelete,
      onEditRole = _ref2.onEditRole,
      canEditRole = _ref2.canEditRole,
      onSelect = _ref2.onSelect,
      onEditBMH = _ref2.onEditBMH;
  var agents = _ref3.agents,
      bmhs = _ref3.bmhs,
      infraEnv = _ref3.infraEnv;

  var _React$useMemo = useMemo(function () {
    return [getAIHosts(agents, bmhs, infraEnv), {
      onEditHost: onEditHost ? function (host) {
        var agent = agents.find(function (a) {
          var _a$metadata5;

          return ((_a$metadata5 = a.metadata) === null || _a$metadata5 === void 0 ? void 0 : _a$metadata5.uid) === host.id;
        });
        return onEditHost(agent);
      } : undefined,
      canEditHost: canEditHost ? function (host) {
        var agent = agents.find(function (a) {
          var _a$metadata6;

          return ((_a$metadata6 = a.metadata) === null || _a$metadata6 === void 0 ? void 0 : _a$metadata6.uid) === host.id;
        });
        return agent ? canEditHost(agent) : false;
      } : undefined,
      onDeleteHost: onDeleteHost ? function (host) {
        var agent = agents.find(function (a) {
          var _a$metadata7;

          return ((_a$metadata7 = a.metadata) === null || _a$metadata7 === void 0 ? void 0 : _a$metadata7.uid) === host.id;
        });
        var bmh = bmhs === null || bmhs === void 0 ? void 0 : bmhs.find(function (a) {
          var _a$metadata8;

          return ((_a$metadata8 = a.metadata) === null || _a$metadata8 === void 0 ? void 0 : _a$metadata8.uid) === host.id;
        });
        return onDeleteHost(agent, bmh);
      } : undefined,
      canDelete: canDelete ? function (host) {
        var agent = agents.find(function (a) {
          var _a$metadata9;

          return ((_a$metadata9 = a.metadata) === null || _a$metadata9 === void 0 ? void 0 : _a$metadata9.uid) === host.id;
        });
        var bmh = bmhs === null || bmhs === void 0 ? void 0 : bmhs.find(function (a) {
          var _a$metadata10;

          return ((_a$metadata10 = a.metadata) === null || _a$metadata10 === void 0 ? void 0 : _a$metadata10.uid) === host.id;
        });
        return canDelete(agent, bmh);
      } : undefined,
      onEditRole: onEditRole ? function (host, role) {
        var agent = agents.find(function (a) {
          var _a$metadata11;

          return ((_a$metadata11 = a.metadata) === null || _a$metadata11 === void 0 ? void 0 : _a$metadata11.uid) === host.id;
        });
        return onEditRole(agent, role);
      } : undefined,
      canEditRole: canEditRole ? function (host) {
        var agent = agents.find(function (a) {
          var _a$metadata12;

          return ((_a$metadata12 = a.metadata) === null || _a$metadata12 === void 0 ? void 0 : _a$metadata12.uid) === host.id;
        });
        return agent ? canEditRole(agent) : false;
      } : undefined,
      onSelect: onSelect ? function (host, selected) {
        var agent = agents.find(function (a) {
          var _a$metadata13;

          return ((_a$metadata13 = a.metadata) === null || _a$metadata13 === void 0 ? void 0 : _a$metadata13.uid) === host.id;
        });
        return onSelect(agent, selected);
      } : undefined,
      onEditBMH: onEditBMH ? function (host) {
        var bmh = bmhs === null || bmhs === void 0 ? void 0 : bmhs.find(function (h) {
          var _h$metadata;

          return ((_h$metadata = h.metadata) === null || _h$metadata === void 0 ? void 0 : _h$metadata.uid) === host.id;
        });
        return onEditBMH(bmh);
      } : undefined,
      canEditBMH: function canEditBMH(host) {
        return !!(bmhs === null || bmhs === void 0 ? void 0 : bmhs.find(function (h) {
          var _h$metadata2;

          return ((_h$metadata2 = h.metadata) === null || _h$metadata2 === void 0 ? void 0 : _h$metadata2.uid) === host.id;
        }));
      }
    }];
  }, [onEditHost, canEditHost, onDeleteHost, canDelete, onEditRole, canEditRole, agents, onSelect, onEditBMH, bmhs, infraEnv]),
      hosts = _React$useMemo[0],
      actions = _React$useMemo[1];

  var actionResolver = useMemo(function () {
    return hostActionResolver(actions);
  }, [actions]);
  return [hosts, actions, actionResolver];
};

var rowKey = function rowKey(_ref) {
  var rowData = _ref.rowData;
  return rowData === null || rowData === void 0 ? void 0 : rowData.key;
};

var HostsTableRowWrapper = function HostsTableRowWrapper(props) {
  var _props$rowProps;

  return /*#__PURE__*/React__default.createElement(RowWrapper, _extends({}, props, {
    "data-testid": "host-row-" + ((_props$rowProps = props.rowProps) === null || _props$rowProps === void 0 ? void 0 : _props$rowProps.rowIndex)
  }));
};

var AITable = function AITable(_ref2) {
  var data = _ref2.data,
      _ref2$testId = _ref2.testId,
      testId = _ref2$testId === void 0 ? 'hosts-table' : _ref2$testId,
      className = _ref2.className,
      content = _ref2.content,
      ExpandComponent = _ref2.ExpandComponent,
      getDataId = _ref2.getDataId,
      actionResolver = _ref2.actionResolver,
      onSelect = _ref2.onSelect,
      children = _ref2.children,
      selectedIDs = _ref2.selectedIDs;

  var _React$useState = React__default.useState({}),
      openRows = _React$useState[0],
      setOpenRows = _React$useState[1];

  var _React$useState2 = React__default.useState({
    index: 1,
    direction: SortByDirection.asc
  }),
      sortBy = _React$useState2[0],
      setSortBy = _React$useState2[1];

  var contentWithAdditions = content;

  if (onSelect) {
    contentWithAdditions = [{
      header: {
        title: '',
        cellFormatters: []
      },
      cell: function cell(obj) {
        var id = getDataId(obj);
        var isChecked = selectedIDs === null || selectedIDs === void 0 ? void 0 : selectedIDs.includes(id);
        var selectId = "select-" + id;
        return {
          title: /*#__PURE__*/React__default.createElement(Checkbox, {
            id: selectId,
            onChange: function onChange() {
              return onSelect(obj, !isChecked);
            },
            isChecked: isChecked
          }),
          props: {
            'data-testid': selectId
          }
        };
      }
    }].concat(content);
  }

  var columns = contentWithAdditions.map(function (c) {
    return c.header;
  });

  var hostRows = flatten((data || []).map(function (obj) {
    var id = getDataId(obj);
    var cells = contentWithAdditions.filter(function (c) {
      return !!c.cell;
    }).map(function (c) {
      var _c$cell;

      return (_c$cell = c.cell) === null || _c$cell === void 0 ? void 0 : _c$cell.call(c, obj);
    });
    return [{
      isOpen: !!openRows[id],
      cells: cells,
      key: id + "-master",
      obj: obj,
      id: id
    }, {
      fullWidth: true,
      cells: [{
        title: /*#__PURE__*/React__default.createElement(ExpandComponent, {
          obj: obj
        })
      }],
      key: id + "-detail"
    }];
  }).sort(rowSorter(sortBy, function (row, index) {
    if (index === void 0) {
      index = 1;
    }

    return row[0].cells[index - 1];
  })).map(function (row, index) {
    row[1].parent = index * 2;
    return row;
  }));

  var rows = React__default.useMemo(function () {
    if (hostRows.length) {
      return hostRows;
    }

    return getColSpanRow(children, columns.length);
  }, [hostRows, columns, children]);
  var onCollapse = React__default.useCallback(function (_event, rowKey) {
    var id = hostRows[rowKey].id;

    if (id) {
      var _Object$assign;

      setOpenRows(Object.assign({}, openRows, (_Object$assign = {}, _Object$assign[id] = !openRows[id], _Object$assign)));
    }
  }, [hostRows, openRows]);
  var onSort = React__default.useCallback(function (_event, index, direction) {
    setOpenRows({});
    setSortBy({
      index: index,
      direction: direction
    });
  }, [setSortBy, setOpenRows]);
  var tableActionResolver = React__default.useCallback(function (rowData) {
    return actionResolver === null || actionResolver === void 0 ? void 0 : actionResolver(rowData.obj);
  }, [actionResolver]);
  return /*#__PURE__*/React__default.createElement(Table, {
    rows: rows,
    cells: columns,
    onCollapse: onCollapse,
    variant: TableVariant.compact,
    "aria-label": "Hosts table",
    className: classNames(className, 'hosts-table'),
    sortBy: sortBy,
    onSort: onSort,
    rowWrapper: HostsTableRowWrapper,
    "data-testid": testId,
    actionResolver: actionResolver ? tableActionResolver : undefined
  }, /*#__PURE__*/React__default.createElement(TableHeader, null), /*#__PURE__*/React__default.createElement(TableBody, {
    rowKey: rowKey
  }));
};

var getLabel$1 = function getLabel(validationStatus) {
  switch (validationStatus) {
    case 'failure':
      return 'Unreachable';

    case 'success':
      return 'Synced';

    default:
      return 'Pending';
  }
};

var NtpValidationStatus = function NtpValidationStatus(_ref) {
  var _validationsInfo$netw;

  var validationsInfo = _ref.validationsInfo,
      AdditionalNTPSourcesDialogToggleComponent = _ref.AdditionalNTPSourcesDialogToggleComponent;
  var ntpSyncedValidation = (_validationsInfo$netw = validationsInfo.network) === null || _validationsInfo$netw === void 0 ? void 0 : _validationsInfo$netw.find(function (v) {
    return v.id === 'ntp-synced';
  });
  var actions = [];

  if (AdditionalNTPSourcesDialogToggleComponent) {
    actions.push( /*#__PURE__*/React__default.createElement(AdditionalNTPSourcesDialogToggleComponent, {
      key: "add-ntp-sources"
    }));
  }

  return /*#__PURE__*/React__default.createElement(HostPropertyValidationPopover, {
    validation: ntpSyncedValidation,
    failureActions: actions,
    pendingActions: actions,
    showSuccess: true,
    showPending: true
  }, getLabel$1(ntpSyncedValidation === null || ntpSyncedValidation === void 0 ? void 0 : ntpSyncedValidation.status));
};

var DiskLimitations = function DiskLimitations(_ref) {
  var _disk$installationEli;

  var disk = _ref.disk;

  if (!((_disk$installationEli = disk.installationEligibility) === null || _disk$installationEli === void 0 ? void 0 : _disk$installationEli.eligible)) {
    var _disk$installationEli2, _disk$installationEli3;

    var limitationsCount = ((_disk$installationEli2 = disk.installationEligibility) === null || _disk$installationEli2 === void 0 ? void 0 : (_disk$installationEli3 = _disk$installationEli2.notEligibleReasons) === null || _disk$installationEli3 === void 0 ? void 0 : _disk$installationEli3.length) || 0;
    return /*#__PURE__*/React__default.createElement(Popover, {
      headerContent: /*#__PURE__*/React__default.createElement("div", null, "Disk limitations"),
      bodyContent: /*#__PURE__*/React__default.createElement(DiskLimitationsPopoverContent, disk.installationEligibility),
      minWidth: "30rem",
      maxWidth: "50rem"
    }, /*#__PURE__*/React__default.createElement(Button, {
      variant: ButtonVariant.link,
      isInline: true
    }, limitationsCount));
  }

  return null;
};

var DiskLimitationsPopoverContent = function DiskLimitationsPopoverContent(_ref2) {
  var eligible = _ref2.eligible,
      notEligibleReasons = _ref2.notEligibleReasons;
  var alerts = [];

  if (!eligible) {
    alerts.push( /*#__PURE__*/React__default.createElement(Alert, {
      key: "install-eligibility",
      variant: AlertVariant.warning,
      title: "Disk is not eligible for installation",
      isInline: true
    }, notEligibleReasons && /*#__PURE__*/React__default.createElement(List, null, notEligibleReasons.map(function (reason) {
      return /*#__PURE__*/React__default.createElement(ListItem$1, {
        key: reason
      }, reason);
    }))));
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, alerts);
};

var getCurrentDiskRoleLabel = function getCurrentDiskRoleLabel(disk, installationDiskId) {
  return disk.id === installationDiskId ? DISK_ROLE_LABELS.install : DISK_ROLE_LABELS.none;
};

var DiskRole = function DiskRole(_ref) {
  var host = _ref.host,
      disk = _ref.disk,
      installationDiskId = _ref.installationDiskId,
      isEditable = _ref.isEditable,
      onDiskRole = _ref.onDiskRole;

  if (isEditable && disk.id !== installationDiskId && onDiskRole) {
    return /*#__PURE__*/React__default.createElement(DiskRoleDropdown, {
      host: host,
      disk: disk,
      installationDiskId: installationDiskId,
      onDiskRole: onDiskRole
    });
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, getCurrentDiskRoleLabel(disk, installationDiskId));
};

var DiskRoleDropdown = function DiskRoleDropdown(_ref2) {
  var _disk$installationEli, _disk$installationEli2;

  var host = _ref2.host,
      disk = _ref2.disk,
      installationDiskId = _ref2.installationDiskId,
      onDiskRole = _ref2.onDiskRole;

  var _React$useState = React__default.useState(false),
      isOpen = _React$useState[0],
      setOpen = _React$useState[1];

  var _React$useState2 = React__default.useState(false),
      isDisabled = _React$useState2[0],
      setDisabled = _React$useState2[1];

  var dropdownItems = [/*#__PURE__*/React__default.createElement(DropdownItem, {
    key: "install",
    id: "install",
    isDisabled: !((_disk$installationEli = disk.installationEligibility) === null || _disk$installationEli === void 0 ? void 0 : _disk$installationEli.eligible),
    description: !((_disk$installationEli2 = disk.installationEligibility) === null || _disk$installationEli2 === void 0 ? void 0 : _disk$installationEli2.eligible) && 'Disk is not eligible for installation'
  }, DISK_ROLE_LABELS.install)];
  var onSelect = React__default.useCallback(function (event) {
    var asyncFunc = function asyncFunc() {
      try {
        var _temp3 = function _temp3() {
          setOpen(false);
        };

        var _temp4 = function () {
          if (event === null || event === void 0 ? void 0 : event.currentTarget.id) {
            setDisabled(true);
            return Promise.resolve(onDiskRole(host.id, disk.id, event.currentTarget.id)).then(function () {
              setDisabled(false);
            });
          }
        }();

        return Promise.resolve(_temp4 && _temp4.then ? _temp4.then(_temp3) : _temp3(_temp4));
      } catch (e) {
        return Promise.reject(e);
      }
    };

    asyncFunc();
  }, [setOpen, disk.id, host.id, onDiskRole]);
  var currentRoleLabel = getCurrentDiskRoleLabel(disk, installationDiskId);
  var toggle = React__default.useMemo(function () {
    return /*#__PURE__*/React__default.createElement(DropdownToggle, {
      onToggle: function onToggle(val) {
        return setOpen(val);
      },
      toggleIndicator: CaretDownIcon,
      isDisabled: isDisabled,
      className: "pf-c-button pf-m-link pf-m-inline"
    }, currentRoleLabel);
  }, [setOpen, currentRoleLabel, isDisabled]);
  return /*#__PURE__*/React__default.createElement(Dropdown, {
    onSelect: onSelect,
    dropdownItems: dropdownItems,
    toggle: toggle,
    isOpen: isOpen,
    isPlain: true
  });
};

var SectionTitle = function SectionTitle(_ref) {
  var title = _ref.title,
      testId = _ref.testId;
  return /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    "data-testid": testId,
    component: TextVariants.h3
  }, title)));
};

var SectionColumn = function SectionColumn(_ref2) {
  var children = _ref2.children;
  return /*#__PURE__*/React__default.createElement(GridItem, {
    span: 4
  }, /*#__PURE__*/React__default.createElement(DetailList, null, children));
};

var diskColumns = [{
  title: 'Name'
}, {
  title: 'Role'
}, {
  title: 'Limitations'
}, {
  title: 'Drive type'
}, {
  title: 'Size'
}, {
  title: 'Serial'
}, {
  title: 'Model'
}, {
  title: 'WWN'
}];

var diskRowKey = function diskRowKey(_ref3) {
  var rowData = _ref3.rowData;
  return rowData === null || rowData === void 0 ? void 0 : rowData.key;
};

var DisksTableRowWrapper = function DisksTableRowWrapper(props) {
  var _props$row;

  return /*#__PURE__*/React__default.createElement(RowWrapper, _extends({}, props, {
    "data-testid": "disk-row:" + ((_props$row = props.row) === null || _props$row === void 0 ? void 0 : _props$row.key)
  }));
};

var DisksTable = function DisksTable(_ref4) {
  var canEditDisks = _ref4.canEditDisks,
      host = _ref4.host,
      disks = _ref4.disks,
      installationDiskId = _ref4.installationDiskId,
      testId = _ref4.testId,
      onDiskRole = _ref4.onDiskRole;
  var isEditable = !!(canEditDisks === null || canEditDisks === void 0 ? void 0 : canEditDisks(host));
  var rows = [].concat(disks).sort(function (diskA, diskB) {
    var _diskA$name;

    return ((_diskA$name = diskA.name) === null || _diskA$name === void 0 ? void 0 : _diskA$name.localeCompare(diskB.name || '')) || 0;
  }).map(function (disk) {
    return {
      cells: [{
        title: disk.bootable ? disk.name + " (bootable)" : disk.name,
        props: {
          'data-testid': 'disk-name'
        }
      }, {
        title: /*#__PURE__*/React__default.createElement(DiskRole, {
          host: host,
          disk: disk,
          installationDiskId: installationDiskId,
          isEditable: isEditable,
          onDiskRole: onDiskRole
        }),
        props: {
          'data-testid': 'disk-role'
        }
      }, {
        title: /*#__PURE__*/React__default.createElement(DiskLimitations, {
          disk: disk
        }),
        props: {
          'data-testid': 'disk-limitations'
        }
      }, {
        title: disk.driveType,
        props: {
          'data-testid': 'drive-type'
        }
      }, {
        title: fileSize(disk.sizeBytes || 0, 2, 'si'),
        props: {
          'data-testid': 'disk-size'
        }
      }, {
        title: disk.serial,
        props: {
          'data-testid': 'disk-serial'
        }
      }, {
        title: disk.model,
        props: {
          'data-testid': 'disk-model'
        }
      }, {
        title: disk.wwn,
        props: {
          'data-testid': 'disk-wwn'
        }
      }],
      key: disk.path
    };
  });
  return /*#__PURE__*/React__default.createElement(Table, {
    "data-testid": testId,
    rows: rows,
    cells: diskColumns,
    variant: TableVariant.compact,
    "aria-label": "Host's disks table",
    borders: false,
    rowWrapper: DisksTableRowWrapper
  }, /*#__PURE__*/React__default.createElement(TableHeader, null), /*#__PURE__*/React__default.createElement(TableBody, {
    rowKey: diskRowKey
  }));
};

var nicsColumns = [{
  title: 'Name'
}, {
  title: 'MAC address'
}, {
  title: 'IPv4 address'
}, {
  title: 'IPv6 address'
}, {
  title: 'Speed'
}];

var nicsRowKey = function nicsRowKey(_ref5) {
  var _rowData$name;

  var rowData = _ref5.rowData;
  return rowData === null || rowData === void 0 ? void 0 : (_rowData$name = rowData.name) === null || _rowData$name === void 0 ? void 0 : _rowData$name.title;
};

var NICsTableRowWrapper = function NICsTableRowWrapper(props) {
  var _props$row2;

  return /*#__PURE__*/React__default.createElement(RowWrapper, _extends({}, props, {
    "data-testid": "nic-row:" + ((_props$row2 = props.row) === null || _props$row2 === void 0 ? void 0 : _props$row2.key)
  }));
};

var NicsTable = function NicsTable(_ref6) {
  var interfaces = _ref6.interfaces,
      testId = _ref6.testId;
  var rows = interfaces.sort(function (nicA, nicB) {
    var _nicA$name;

    return ((_nicA$name = nicA.name) === null || _nicA$name === void 0 ? void 0 : _nicA$name.localeCompare(nicB.name || '')) || 0;
  }).map(function (nic) {
    return {
      cells: [{
        title: nic.name,
        props: {
          'data-testid': 'nic-name'
        }
      }, {
        title: nic.macAddress,
        props: {
          'data-testid': 'nic-mac'
        }
      }, {
        title: (nic.ipv4Addresses || []).join(', '),
        props: {
          'data-testid': 'nic-ipv4'
        }
      }, {
        title: (nic.ipv6Addresses || []).join(', '),
        props: {
          'data-testid': 'nic-ipv6'
        }
      }, {
        title: nic.speedMbps && nic.speedMbps > 0 ? nic.speedMbps + " Mbps" : 'N/A',
        props: {
          'data-testid': 'nic-speed'
        }
      }],
      key: nic.name
    };
  });
  return /*#__PURE__*/React__default.createElement(Table, {
    "data-testid": testId,
    rows: rows,
    cells: nicsColumns,
    variant: TableVariant.compact,
    "aria-label": "Host's network interfaces table",
    borders: false,
    rowWrapper: NICsTableRowWrapper
  }, /*#__PURE__*/React__default.createElement(TableHeader, null), /*#__PURE__*/React__default.createElement(TableBody, {
    rowKey: nicsRowKey
  }));
};

var HostDetail = function HostDetail(_ref7) {
  var _inventory$systemVend, _inventory$systemVend2, _inventory$cpu, _inventory$cpu2, _inventory$boot, _inventory$boot2, _inventory$boot3;

  var canEditDisks = _ref7.canEditDisks,
      onDiskRole = _ref7.onDiskRole,
      host = _ref7.host,
      AdditionalNTPSourcesDialogToggleComponent = _ref7.AdditionalNTPSourcesDialogToggleComponent;
  var id = host.id,
      installationDiskId = host.installationDiskId,
      _host$inventory = host.inventory,
      inventoryString = _host$inventory === void 0 ? '' : _host$inventory;
  var inventory = stringToJSON(inventoryString) || {};
  var validationsInfo = stringToJSON(host.validationsInfo) || {};
  var rowInfo = getHostRowHardwareInfo(inventory);
  var disks = inventory.disks || [];
  var nics = inventory.interfaces || [];
  var bmcAddress = inventory.bmcAddress;

  if (inventory.bmcV6address) {
    bmcAddress = bmcAddress ? bmcAddress + ", " + inventory.bmcV6address : inventory.bmcV6address;
  }

  bmcAddress = bmcAddress || DASH;
  var hardwareType = getHardwareTypeText(inventory);
  var ntpValidationStatus = React__default.useMemo(function () {
    return /*#__PURE__*/React__default.createElement(NtpValidationStatus, {
      AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggleComponent,
      validationsInfo: validationsInfo
    });
  }, [AdditionalNTPSourcesDialogToggleComponent, validationsInfo]);
  return /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(SectionTitle, {
    testId: 'host-details-section',
    title: "Host details"
  }), /*#__PURE__*/React__default.createElement(SectionColumn, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'uuid',
    title: "UUID",
    value: id
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'manufacturer',
    title: "Manufacturer",
    value: ((_inventory$systemVend = inventory.systemVendor) === null || _inventory$systemVend === void 0 ? void 0 : _inventory$systemVend.manufacturer) || DASH
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'product',
    title: "Product",
    value: ((_inventory$systemVend2 = inventory.systemVendor) === null || _inventory$systemVend2 === void 0 ? void 0 : _inventory$systemVend2.productName) || DASH
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'serial-number',
    title: "Serial number",
    value: rowInfo.serialNumber
  })), /*#__PURE__*/React__default.createElement(SectionColumn, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'memory-capacity',
    title: "Memory capacity",
    value: rowInfo.memory.title
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'cpu-model',
    title: "CPU model name",
    value: ((_inventory$cpu = inventory.cpu) === null || _inventory$cpu === void 0 ? void 0 : _inventory$cpu.modelName) || DASH
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'cpu-cores-and-clock',
    title: "CPU cores and clock speed",
    value: rowInfo.cpuSpeed
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'cpu-arch',
    title: "CPU architecture",
    value: ((_inventory$cpu2 = inventory.cpu) === null || _inventory$cpu2 === void 0 ? void 0 : _inventory$cpu2.architecture) || DASH
  })), /*#__PURE__*/React__default.createElement(SectionColumn, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'hw-type',
    title: "Hardware type",
    value: hardwareType
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'bmc-address',
    title: "BMC address",
    value: bmcAddress
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'boot-mode',
    title: "Boot mode",
    value: ((_inventory$boot = inventory.boot) === null || _inventory$boot === void 0 ? void 0 : _inventory$boot.currentBootMode) || DASH
  }), ((_inventory$boot2 = inventory.boot) === null || _inventory$boot2 === void 0 ? void 0 : _inventory$boot2.pxeInterface) && /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'pxe-interface',
    title: "PXE interface",
    value: (_inventory$boot3 = inventory.boot) === null || _inventory$boot3 === void 0 ? void 0 : _inventory$boot3.pxeInterface
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    testId: 'ntp-status',
    title: "NTP status",
    value: ntpValidationStatus
  })), /*#__PURE__*/React__default.createElement(SectionTitle, {
    testId: 'disks-section',
    title: disks.length + " Disk" + (disks.length === 1 ? '' : 's')
  }), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(DisksTable, {
    testId: 'disks-table',
    canEditDisks: canEditDisks,
    host: host,
    disks: disks,
    installationDiskId: installationDiskId,
    onDiskRole: onDiskRole
  })), /*#__PURE__*/React__default.createElement(SectionTitle, {
    testId: 'nics-section',
    title: nics.length + " NIC" + (nics.length === 1 ? '' : 's')
  }), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(NicsTable, {
    interfaces: nics,
    testId: 'nics-table'
  })));
};

var AdditionalNTPSourcesForm = function AdditionalNTPSourcesForm(_ref) {
  var cluster = _ref.cluster,
      onClose = _ref.onClose,
      onAdditionalNtpSource = _ref.onAdditionalNtpSource;
  var initialValues = {
    additionalNtpSource: cluster.additionalNtpSource || ''
  };
  var validationSchema = object().shape({
    additionalNtpSource: ntpSourceValidationSchema.required()
  });

  var handleSubmit = function handleSubmit(values, formikHelpers) {
    try {
      formikHelpers.setStatus({
        error: null
      });

      if (onAdditionalNtpSource && values.additionalNtpSource) {
        var onError = function onError(message) {
          return formikHelpers.setStatus({
            error: {
              title: 'Failed to add NTP sources',
              message: message
            }
          });
        };

        onAdditionalNtpSource(values.additionalNtpSource, onError);
      }

      onClose();
      return Promise.resolve();
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    initialTouched: {
      additionalNtpSource: true
    },
    initialStatus: {
      error: null
    },
    validationSchema: validationSchema,
    onSubmit: handleSubmit
  }, function (_ref2) {
    var submitForm = _ref2.submitForm,
        status = _ref2.status,
        setStatus = _ref2.setStatus,
        setFieldValue = _ref2.setFieldValue,
        setFieldTouched = _ref2.setFieldTouched,
        isSubmitting = _ref2.isSubmitting,
        isValid = _ref2.isValid,
        dirty = _ref2.dirty,
        values = _ref2.values;

    var formatAdditionalNtpSource = function formatAdditionalNtpSource() {
      if (values.additionalNtpSource) {
        setFieldValue('additionalNtpSource', trimCommaSeparatedList(values.additionalNtpSource));
        setFieldTouched('additionalNtpSource');
      }
    };

    return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ModalBoxBody, null, /*#__PURE__*/React__default.createElement(Form, null, status.error && /*#__PURE__*/React__default.createElement(Alert, {
      variant: AlertVariant.danger,
      title: status.error.title,
      actionClose: /*#__PURE__*/React__default.createElement(AlertActionCloseButton, {
        onClose: function onClose() {
          return setStatus({
            error: null
          });
        }
      }),
      isInline: true
    }, status.error.message), /*#__PURE__*/React__default.createElement(TextAreaField, {
      name: "additionalNtpSource",
      label: "Additional NTP Sources",
      helperText: "A comma separated list of IP or domain names of the NTP pools or servers. Additional NTP sources are added to all hosts to ensure all hosts clocks are synchronized with a valid NTP server. It may take a few minutes for the new NTP sources to sync.",
      onBlur: formatAdditionalNtpSource,
      spellCheck: false,
      isRequired: true
    }))), /*#__PURE__*/React__default.createElement(ModalBoxFooter, null, /*#__PURE__*/React__default.createElement(Button, {
      key: "submit",
      onClick: submitForm,
      isDisabled: isSubmitting || !isValid || !dirty,
      isLoading: isSubmitting
    }, isSubmitting ? 'Adding...' : 'Add'), /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: "link",
      onClick: onClose
    }, "Cancel")));
  });
};

var AdditionalNTPSourcesDialog = function AdditionalNTPSourcesDialog(_ref3) {
  var cluster = _ref3.cluster,
      isOpen = _ref3.isOpen,
      onClose = _ref3.onClose,
      onAdditionalNtpSource = _ref3.onAdditionalNtpSource;
  return /*#__PURE__*/React__default.createElement(Modal, {
    "aria-label": "Add NTP sources",
    title: "Add NTP sources",
    isOpen: isOpen,
    onClose: onClose,
    variant: ModalVariant.small,
    hasNoBodyWrapper: true
  }, /*#__PURE__*/React__default.createElement(AdditionalNTPSourcesForm, {
    cluster: cluster,
    onClose: onClose,
    onAdditionalNtpSource: onAdditionalNtpSource
  }));
};

var getVersions = function getVersions() {
  return client.get('/v1/component_versions');
};
var getOpenshiftVersions = function getOpenshiftVersions() {
  return client.get('/v1/openshift_versions');
};

var getManagedDomains = function getManagedDomains() {
  return client.get('/v1/domains');
};

var addHostsClusters = function addHostsClusters(params) {
  return client.post('/v1/add_hosts_clusters', params);
};
var installHosts = function installHosts(clusterId) {
  return client.post("/v1/clusters/" + clusterId + "/actions/install_hosts");
};
var installHost = function installHost(clusterId, hostId) {
  return client.post("/v1/clusters/" + clusterId + "/hosts/" + hostId + "/actions/install");
};

var reducer = function reducer(state, _ref) {
  var type = _ref.type,
      payload = _ref.payload;

  switch (type) {
    case 'REQUEST':
      return _extends({}, state, {
        uiState: ResourceUIState.LOADING
      });

    case 'SUCCESS':
      if (payload instanceof Array && !payload.length) {
        return _extends({}, state, {
          uiState: ResourceUIState.EMPTY,
          data: payload
        });
      } else {
        return _extends({}, state, {
          uiState: ResourceUIState.LOADED,
          data: payload
        });
      }

    case 'ERROR':
      return _extends({}, state, {
        uiState: ResourceUIState.ERROR
      });

    default:
      return state;
  }
};

var createInitialState = function createInitialState(config) {
  return {
    uiState: config.initialUIState,
    data: undefined
  };
};

var fetchData = function fetchData(dispatch, apiCall, params) {
  try {
    dispatch({
      type: 'REQUEST'
    });

    var _temp2 = _catch(function () {
      return Promise.resolve(apiCall(params)).then(function (_ref2) {
        var data = _ref2.data;
        dispatch({
          type: 'SUCCESS',
          payload: data
        });
      });
    }, function (e) {
      captureException(e);
      dispatch({
        type: 'ERROR'
      });
    });

    return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
  } catch (e) {
    return Promise.reject(e);
  }
};

var useApi = function useApi(apiCall, params, config) {
  var cfg = _extends({
    manual: false,
    initialUIState: ResourceUIState.LOADING
  }, config);

  var _React$useReducer = React__default.useReducer(reducer, createInitialState(cfg)),
      state = _React$useReducer[0],
      dispatch = _React$useReducer[1];

  var stringifiedParams = typeof params === 'string' ? params : JSON.stringify(params);
  React__default.useEffect(function () {
    if (!cfg.manual) {
      fetchData(dispatch, apiCall, params);
    }
  }, [apiCall, stringifiedParams]);
  var refetch = React__default.useCallback(function (newParams) {
    fetchData(dispatch, apiCall, newParams || params);
  }, [params, stringifiedParams]);
  return [state, refetch];
};



var index$3 = {
  __proto__: null,
  useApi: useApi,
  BASE_PATH: BASE_PATH,
  setAuthInterceptor: setAuthInterceptor,
  get client () { return client; },
  get ocmClient () { return ocmClient; },
  handleApiError: handleApiError,
  getErrorMessage: getErrorMessage,
  getClusters: getClusters,
  getClustersDefaultConfiguration: getClustersDefaultConfiguration,
  getCluster: getCluster,
  getClustersByOpenshiftId: getClustersByOpenshiftId,
  postCluster: postCluster,
  patchCluster: patchCluster,
  deleteCluster: deleteCluster,
  getClusterHosts: getClusterHosts,
  enableClusterHost: enableClusterHost,
  disableClusterHost: disableClusterHost,
  resetClusterHost: resetClusterHost,
  deleteClusterHost: deleteClusterHost,
  postInstallCluster: postInstallCluster,
  postResetCluster: postResetCluster,
  postCancelInstallation: postCancelInstallation,
  createClusterDownloadsImage: createClusterDownloadsImage,
  getPresignedFileUrl: getPresignedFileUrl,
  getClusterFileDownload: getClusterFileDownload,
  getClusterDownloadsImageUrl: getClusterDownloadsImageUrl,
  getClusterCredentials: getClusterCredentials,
  getHostLogsDownloadUrl: getHostLogsDownloadUrl,
  getClusterLogsDownloadUrl: getClusterLogsDownloadUrl,
  getEvents: getEvents,
  getClusterPreflightRequirements: getClusterPreflightRequirements,
  getClusterSupportedPlatforms: getClusterSupportedPlatforms,
  getVersions: getVersions,
  getOpenshiftVersions: getOpenshiftVersions,
  getManagedDomains: getManagedDomains,
  addHostsClusters: addHostsClusters,
  installHosts: installHosts,
  installHost: installHost
};

var fetchClustersAsync = createAsyncThunk('clusters/fetchClustersAsync', function () {
  try {
    return Promise.resolve(_catch(function () {
      return Promise.resolve(getClusters()).then(function (_ref) {
        var data = _ref.data;
        return data.filter(function (cluster) {
          return cluster.kind === 'Cluster';
        });
      });
    }, function (e) {
      return handleApiError(e, function () {
        return Promise.reject('Failed to fetch clusters.');
      });
    }));
  } catch (e) {
    return Promise.reject(e);
  }
});
var initialState$2 = {
  data: [],
  uiState: ResourceUIState.LOADING
};
var clustersSlice = createSlice({
  initialState: initialState$2,
  name: 'clusters',
  reducers: {
    deleteCluster: function deleteCluster(state, action) {
      return _extends({}, state, {
        data: state.data.filter(function (item) {
          return item.id !== action.payload;
        })
      });
    }
  },
  extraReducers: function extraReducers(builder) {
    var LOADED = ResourceUIState.LOADED,
        LOADING = ResourceUIState.LOADING,
        RELOADING = ResourceUIState.RELOADING,
        ERROR = ResourceUIState.ERROR;
    builder.addCase(fetchClustersAsync.pending, function (state) {
      var uiState = state.uiState === LOADED ? RELOADING : LOADING;
      return _extends({}, state, {
        uiState: uiState
      });
    }).addCase(fetchClustersAsync.fulfilled, function (state, action) {
      return _extends({}, state, {
        data: [].concat(action.payload),
        uiState: LOADED
      });
    }).addCase(fetchClustersAsync.rejected, function (state) {
      return _extends({}, state, {
        uiState: ERROR
      });
    });
  }
});
var deleteCluster$1 = clustersSlice.actions.deleteCluster;
var clustersReducer = clustersSlice.reducer;

var fetchClusterAsync = createAsyncThunk('currentCluster/fetchClusterAsync', function (clusterId, _ref) {
  var rejectWithValue = _ref.rejectWithValue;

  try {
    return Promise.resolve(_catch(function () {
      return Promise.resolve(getCluster(clusterId)).then(function (_ref2) {
        var data = _ref2.data;
        return data;
      });
    }, function (e) {
      return handleApiError(e, function () {
        return rejectWithValue(e.response.data);
      });
    }));
  } catch (e) {
    return Promise.reject(e);
  }
});
var initialState$3 = {
  data: undefined,
  uiState: ResourceUIState.LOADING,
  errorDetail: undefined,
  isReloadScheduled: 0
};
var currentClusterSlice = createSlice({
  initialState: initialState$3,
  name: 'currentCluster',
  reducers: {
    updateCluster: function updateCluster(state, action) {
      return _extends({}, state, {
        data: action.payload
      });
    },
    updateHost: function updateHost(state, action) {
      var _state$data;

      var hostIndex = ___default.findIndex((_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.hosts, function (host) {
        return host.id === action.payload.id;
      });

      if (hostIndex >= 0) {
        ___default.set(state, "data.hosts[" + hostIndex + "]", action.payload);
      }

      return state;
    },
    cleanCluster: function cleanCluster() {
      return initialState$3;
    },
    forceReload: function forceReload(state) {
      return _extends({}, state, {
        isReloadScheduled: state.isReloadScheduled + 1
      });
    },
    cancelForceReload: function cancelForceReload(state) {
      return _extends({}, state, {
        isReloadScheduled: 0
      });
    }
  },
  extraReducers: function extraReducers(builder) {
    builder.addCase(fetchClusterAsync.pending, function (state) {
      return _extends({}, state, {
        uiState: state.uiState === ResourceUIState.LOADED ? ResourceUIState.RELOADING : ResourceUIState.LOADING
      });
    }).addCase(fetchClusterAsync.fulfilled, function (state, action) {
      return _extends({}, state, {
        data: action.payload,
        uiState: ResourceUIState.LOADED
      });
    }).addCase(fetchClusterAsync.rejected, function (state, action) {
      return _extends({}, state, {
        uiState: ResourceUIState.ERROR,
        errorDetail: action.payload
      });
    });
  }
});
var _currentClusterSlice$ = currentClusterSlice.actions,
    updateCluster = _currentClusterSlice$.updateCluster,
    updateHost = _currentClusterSlice$.updateHost,
    cleanCluster = _currentClusterSlice$.cleanCluster,
    forceReload = _currentClusterSlice$.forceReload,
    cancelForceReload = _currentClusterSlice$.cancelForceReload;
var currentClusterReducer = currentClusterSlice.reducer;

var downloadHostInstallationLogs = function downloadHostInstallationLogs(addAlert, host) {
  try {
    var _temp3 = function () {
      if (ocmClient) {
        var _temp4 = _catch(function () {
          return Promise.resolve(getPresignedFileUrl({
            clusterId: host.clusterId || 'UNKNOWN_CLUSTER',
            fileName: 'logs',
            hostId: host.id,
            logsType: 'host'
          })).then(function (_ref) {
            var data = _ref.data;
            saveAs(data.url);
          });
        }, function (e) {
          handleApiError(e, function (e) {
            try {
              addAlert({
                title: 'Could not download host logs.',
                message: getErrorMessage(e)
              });
              return Promise.resolve();
            } catch (e) {
              return Promise.reject(e);
            }
          });
        });

        if (_temp4 && _temp4.then) return _temp4.then(function () {});
      } else {
        saveAs(getHostLogsDownloadUrl(host.id, host.clusterId));
      }
    }();

    return Promise.resolve(_temp3 && _temp3.then ? _temp3.then(function () {}) : void 0);
  } catch (e) {
    return Promise.reject(e);
  }
};
var onAdditionalNtpSourceAction = function onAdditionalNtpSourceAction(dispatch, clusterId, additionalNtpSource, onError) {
  try {
    var _temp6 = _catch(function () {
      var values = {
        additionalNtpSource: additionalNtpSource
      };
      return Promise.resolve(patchCluster(clusterId, values)).then(function (_ref2) {
        var data = _ref2.data;
        dispatch(updateCluster(data));
      });
    }, function (e) {
      handleApiError(e, function () {
        return onError(getErrorMessage(e));
      });
    });

    return Promise.resolve(_temp6 && _temp6.then ? _temp6.then(function () {}) : void 0);
  } catch (e) {
    return Promise.reject(e);
  }
};

var ResetHostModal = function ResetHostModal(_ref) {
  var isOpen = _ref.isOpen,
      hostname = _ref.hostname,
      onClose = _ref.onClose,
      onReset = _ref.onReset;
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "Reset Host",
    isOpen: isOpen,
    onClose: onClose,
    variant: ModalVariant.small,
    actions: [/*#__PURE__*/React__default.createElement(Button, {
      "data-testid": "reset-host-submit",
      key: "confirm",
      variant: ButtonVariant.danger,
      onClick: onReset
    }, "Reset"), /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: ButtonVariant.link,
      onClick: onClose
    }, "Cancel")]
  }, "Are you sure you want to reset host", " " + hostname || '', " ?");
};

var DeleteHostModal = function DeleteHostModal(_ref) {
  var isOpen = _ref.isOpen,
      hostname = _ref.hostname,
      onClose = _ref.onClose,
      onDelete = _ref.onDelete;
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "Delete Host",
    isOpen: isOpen,
    onClose: onClose,
    variant: ModalVariant.small,
    actions: [/*#__PURE__*/React__default.createElement(Button, {
      "data-testid": "delete-host-submit",
      key: "confirm",
      variant: ButtonVariant.danger,
      onClick: onDelete
    }, "Delete"), /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: ButtonVariant.link,
      onClick: onClose
    }, "Cancel")]
  }, "Are you sure you want to delete host", " " + hostname || '', " ?");
};

var onFetchEvents = function onFetchEvents(props, onSuccess, onError) {
  try {
    var _temp2 = _catch(function () {
      return Promise.resolve(getEvents(props.clusterId, props.hostId)).then(function (_ref) {
        var data = _ref.data;
        onSuccess(data);
      });
    }, function (error) {
      handleApiError(error, function () {
        onError('Failed to load events');
      });
    });

    return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
  } catch (e) {
    return Promise.reject(e);
  }
};

var useHostsTable = function useHostsTable(cluster) {
  var _React$useContext = useContext(AlertsContext),
      addAlert = _React$useContext.addAlert;

  var _useModalDialogsConte = useModalDialogsContext(),
      eventsDialog = _useModalDialogsConte.eventsDialog,
      editHostDialog = _useModalDialogsConte.editHostDialog,
      deleteHostDialog = _useModalDialogsConte.deleteHostDialog,
      resetHostDialog = _useModalDialogsConte.resetHostDialog;

  var dispatch = useDispatch();
  var hostActions = useMemo(function () {
    return {
      onDeleteHost: function onDeleteHost(host) {
        var _host$inventory = host.inventory,
            inventoryString = _host$inventory === void 0 ? '' : _host$inventory;
        var inventory = stringToJSON(inventoryString) || {};
        deleteHostDialog.open({
          hostId: host.id,
          hostname: (host === null || host === void 0 ? void 0 : host.requestedHostname) || (inventory === null || inventory === void 0 ? void 0 : inventory.hostname)
        });
      },
      onHostEnable: function (host) {
        try {
          var hostId = host.id;

          var _temp2 = _catch(function () {
            return Promise.resolve(enableClusterHost(cluster.id, hostId)).then(function (_ref) {
              var data = _ref.data;
              dispatch(updateCluster(data));
            });
          }, function (e) {
            handleApiError(e, function () {
              return addAlert({
                title: "Failed to enable host " + hostId,
                message: getErrorMessage(e)
              });
            });
          });

          return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
        } catch (e) {
          return Promise.reject(e);
        }
      },
      onInstallHost: function (host) {
        try {
          var hostId = host.id;

          var _temp4 = _catch(function () {
            return Promise.resolve(installHost(cluster.id, hostId)).then(function (_ref2) {
              var data = _ref2.data;
              dispatch(updateHost(data));
            });
          }, function (e) {
            handleApiError(e, function () {
              return addAlert({
                title: "Failed to enable host " + hostId,
                message: getErrorMessage(e)
              });
            });
          });

          return Promise.resolve(_temp4 && _temp4.then ? _temp4.then(function () {}) : void 0);
        } catch (e) {
          return Promise.reject(e);
        }
      },
      onHostDisable: function (host) {
        try {
          var hostId = host.id;

          var _temp6 = _catch(function () {
            return Promise.resolve(disableClusterHost(cluster.id, hostId)).then(function (_ref3) {
              var data = _ref3.data;
              dispatch(updateCluster(data));
            });
          }, function (e) {
            handleApiError(e, function () {
              return addAlert({
                title: "Failed to disable host " + hostId,
                message: getErrorMessage(e)
              });
            });
          });

          return Promise.resolve(_temp6 && _temp6.then ? _temp6.then(function () {}) : void 0);
        } catch (e) {
          return Promise.reject(e);
        }
      }
    };
  }, [cluster.id, dispatch, addAlert, deleteHostDialog]);
  var onViewHostEvents = useCallback(function (host) {
    var id = host.id,
        requestedHostname = host.requestedHostname,
        _host$inventory2 = host.inventory,
        inventoryString = _host$inventory2 === void 0 ? '' : _host$inventory2;
    var inventory = stringToJSON(inventoryString) || {};
    var hostname = requestedHostname || (inventory === null || inventory === void 0 ? void 0 : inventory.hostname) || id;
    eventsDialog.open({
      hostId: id,
      hostname: hostname
    });
  }, [eventsDialog]);
  var onEditHost = useCallback(function (host) {
    var _host$inventory3 = host.inventory,
        inventoryString = _host$inventory3 === void 0 ? '' : _host$inventory3;
    var inventory = stringToJSON(inventoryString) || {};
    editHostDialog.open({
      host: host,
      inventory: inventory
    });
  }, [editHostDialog]);
  var onHostReset = useCallback(function (host) {
    var _host$inventory4 = host.inventory,
        inventoryString = _host$inventory4 === void 0 ? '' : _host$inventory4;
    var inventory = stringToJSON(inventoryString) || {};
    var hostname = (host === null || host === void 0 ? void 0 : host.requestedHostname) || (inventory === null || inventory === void 0 ? void 0 : inventory.hostname) || '';
    resetHostDialog.open({
      hostId: host.id,
      hostname: hostname
    });
  }, [resetHostDialog]);
  var onDownloadHostLogs = useCallback(function (host) {
    return downloadHostInstallationLogs(addAlert, host);
  }, [addAlert]);
  var onDiskRole = useCallback(function (hostId, diskId, role) {
    try {
      var params = {};
      params.disksSelectedConfig = [{
        id: hostId,
        disksConfig: [{
          id: diskId,
          role: role
        }]
      }];

      var _temp8 = _catch(function () {
        return Promise.resolve(patchCluster(cluster.id, params)).then(function (_ref4) {
          var data = _ref4.data;
          dispatch(updateCluster(data));
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to set disk role',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp8 && _temp8.then ? _temp8.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  }, [dispatch, addAlert, cluster.id]);
  var onAdditionalNtpSource = useMemo(function () {
    return function () {
      try {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        return Promise.resolve(onAdditionalNtpSourceAction.apply(void 0, [dispatch, cluster.id].concat(args)));
      } catch (e) {
        return Promise.reject(e);
      }
    };
  }, [cluster.id, dispatch]);
  var actionChecks = useMemo(function () {
    return {
      canEditRole: function canEditRole$1(host) {
        return canEditRole(cluster, host.status);
      },
      canInstallHost: function canInstallHost$1(host) {
        return canInstallHost(cluster, host.status);
      },
      canEditDisks: function canEditDisks$1(host) {
        return canEditDisks(cluster.status, host.status);
      },
      canEnable: function canEnable$1(host) {
        return canEnable(cluster.status, host.status);
      },
      canDisable: function canDisable$1(host) {
        return canDisable(cluster.status, host.status);
      },
      canDelete: function canDelete$1(host) {
        return canDelete(cluster.status, host.status);
      },
      canEditHost: function canEditHost$1(host) {
        return canEditHost(cluster.status, host.status);
      },
      canReset: function canReset$1(host) {
        return canReset(cluster.status, host.status);
      }
    };
  }, [cluster]);
  var onReset = useCallback(function () {
    var _resetHostDialog$data;

    var reset = function reset(hostId) {
      try {
        return Promise.resolve(function () {
          if (hostId) {
            return _catch(function () {
              return Promise.resolve(resetClusterHost(cluster.id, hostId)).then(function (_ref5) {
                var data = _ref5.data;
                dispatch(updateHost(data));
              });
            }, function (e) {
              return handleApiError(e, function () {
                return addAlert({
                  title: "Failed to reset host " + hostId,
                  message: getErrorMessage(e)
                });
              });
            });
          }
        }());
      } catch (e) {
        return Promise.reject(e);
      }
    };

    reset((_resetHostDialog$data = resetHostDialog.data) === null || _resetHostDialog$data === void 0 ? void 0 : _resetHostDialog$data.hostId);
    resetHostDialog.close();
  }, [addAlert, cluster.id, dispatch, resetHostDialog]);
  var onDelete = useCallback(function () {
    var _deleteHostDialog$dat;

    var deleteHost = function deleteHost(hostId) {
      try {
        return Promise.resolve(function () {
          if (hostId) {
            return _catch(function () {
              return Promise.resolve(deleteClusterHost(cluster.id, hostId)).then(function () {
                dispatch(forceReload());
              });
            }, function (e) {
              return handleApiError(e, function () {
                return addAlert({
                  title: "Failed to delete host " + hostId,
                  message: getErrorMessage(e)
                });
              });
            });
          }
        }());
      } catch (e) {
        return Promise.reject(e);
      }
    };

    deleteHost((_deleteHostDialog$dat = deleteHostDialog.data) === null || _deleteHostDialog$dat === void 0 ? void 0 : _deleteHostDialog$dat.hostId);
    deleteHostDialog.close();
  }, [addAlert, cluster.id, dispatch, deleteHostDialog]);
  var onEditRole = useCallback(function (_ref6, role) {
    var id = _ref6.id,
        clusterId = _ref6.clusterId;

    try {
      var params = {};
      params.hostsRoles = [{
        id: id,
        role: role
      }];

      var _temp10 = _catch(function () {
        return Promise.resolve(patchCluster(clusterId, params)).then(function (_ref7) {
          var data = _ref7.data;
          dispatch(updateCluster(data));
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to set role',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp10 && _temp10.then ? _temp10.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  }, [addAlert, dispatch]);
  var actionResolver = useMemo(function () {
    return hostActionResolver(_extends({}, actionChecks, {
      onEditRole: onEditRole,
      onDiskRole: onDiskRole,
      onEditHost: onEditHost,
      onHostReset: onHostReset,
      onDownloadHostLogs: onDownloadHostLogs,
      onViewHostEvents: onViewHostEvents,
      canDownloadHostLogs: canDownloadHostLogs
    }, hostActions));
  }, [actionChecks, hostActions, onEditRole, onDiskRole, onEditHost, onHostReset, onDownloadHostLogs, onViewHostEvents]);
  return {
    onDiskRole: onDiskRole,
    onEditHost: onEditHost,
    actionChecks: actionChecks,
    onEditRole: onEditRole,
    actionResolver: actionResolver,
    onReset: onReset,
    onDelete: onDelete,
    onAdditionalNtpSource: onAdditionalNtpSource
  };
};
var HostsTableModals = function HostsTableModals(_ref8) {
  var _eventsDialog$data, _eventsDialog$data2, _resetHostDialog$data2, _deleteHostDialog$dat2, _editHostDialog$data, _editHostDialog$data2, _cluster$hosts;

  var cluster = _ref8.cluster,
      onDelete = _ref8.onDelete,
      onReset = _ref8.onReset,
      onAdditionalNtpSource = _ref8.onAdditionalNtpSource;
  var dispatch = useDispatch();

  var _useModalDialogsConte2 = useModalDialogsContext(),
      eventsDialog = _useModalDialogsConte2.eventsDialog,
      editHostDialog = _useModalDialogsConte2.editHostDialog,
      deleteHostDialog = _useModalDialogsConte2.deleteHostDialog,
      resetHostDialog = _useModalDialogsConte2.resetHostDialog,
      additionalNTPSourcesDialog = _useModalDialogsConte2.additionalNTPSourcesDialog;

  return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(EventsModal, {
    title: "Host Events" + (eventsDialog.isOpen ? ": " + ((_eventsDialog$data = eventsDialog.data) === null || _eventsDialog$data === void 0 ? void 0 : _eventsDialog$data.hostname) : ''),
    entityKind: "host",
    cluster: cluster,
    hostId: (_eventsDialog$data2 = eventsDialog.data) === null || _eventsDialog$data2 === void 0 ? void 0 : _eventsDialog$data2.hostId,
    onClose: eventsDialog.close,
    isOpen: eventsDialog.isOpen,
    onFetchEvents: onFetchEvents
  }), /*#__PURE__*/createElement(ResetHostModal, {
    hostname: (_resetHostDialog$data2 = resetHostDialog.data) === null || _resetHostDialog$data2 === void 0 ? void 0 : _resetHostDialog$data2.hostname,
    onClose: resetHostDialog.close,
    isOpen: resetHostDialog.isOpen,
    onReset: onReset
  }), /*#__PURE__*/createElement(DeleteHostModal, {
    hostname: (_deleteHostDialog$dat2 = deleteHostDialog.data) === null || _deleteHostDialog$dat2 === void 0 ? void 0 : _deleteHostDialog$dat2.hostname,
    onClose: deleteHostDialog.close,
    isOpen: deleteHostDialog.isOpen,
    onDelete: onDelete
  }), /*#__PURE__*/createElement(EditHostModal, {
    host: (_editHostDialog$data = editHostDialog.data) === null || _editHostDialog$data === void 0 ? void 0 : _editHostDialog$data.host,
    inventory: (_editHostDialog$data2 = editHostDialog.data) === null || _editHostDialog$data2 === void 0 ? void 0 : _editHostDialog$data2.inventory,
    usedHostnames: cluster === null || cluster === void 0 ? void 0 : (_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.map(function (h) {
      return h.requestedHostname;
    }).filter(function (h) {
      return h;
    }),
    onClose: editHostDialog.close,
    isOpen: editHostDialog.isOpen,
    onSave: function onSave(values) {
      try {
        var params = {
          hostsNames: [{
            id: values.hostId,
            hostname: values.hostname
          }]
        };
        return Promise.resolve(patchCluster(cluster.id, params)).then(function (_ref9) {
          var data = _ref9.data;
          dispatch(updateCluster(data));
          editHostDialog.close();
        });
      } catch (e) {
        return Promise.reject(e);
      }
    },
    onFormSaveError: function onFormSaveError(e) {
      var message;
      handleApiError(e, function () {
        return message = getErrorMessage(e);
      });
      return message;
    }
  }), /*#__PURE__*/createElement(AdditionalNTPSourcesDialog, {
    cluster: cluster,
    isOpen: additionalNTPSourcesDialog.isOpen,
    onClose: additionalNTPSourcesDialog.close,
    onAdditionalNtpSource: onAdditionalNtpSource
  }));
};
var getHostId = function getHostId(host) {
  return host.id;
};

var HostsTableEmptyState = function HostsTableEmptyState(_ref) {
  var setDiscoveryHintModalOpen = _ref.setDiscoveryHintModalOpen;
  return /*#__PURE__*/createElement(EmptyState, {
    icon: ConnectedIcon,
    title: "Waiting for hosts...",
    content: "Hosts may take a few minutes to appear here after booting.",
    secondaryActions: setDiscoveryHintModalOpen && [/*#__PURE__*/createElement(HostsNotShowingLink, {
      key: "hosts-not-showing",
      setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
    })]
  });
};
var DefaultExpandComponent = function DefaultExpandComponent(_ref2) {
  var obj = _ref2.obj;
  return /*#__PURE__*/createElement(HostDetail, {
    key: obj.id,
    host: obj,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle
  });
};

var HostsTable = function HostsTable(_ref3) {
  var hosts = _ref3.hosts,
      skipDisabled = _ref3.skipDisabled,
      children = _ref3.children,
      content = _ref3.content,
      actionResolver = _ref3.actionResolver,
      _ref3$ExpandComponent = _ref3.ExpandComponent,
      ExpandComponent = _ref3$ExpandComponent === void 0 ? DefaultExpandComponent : _ref3$ExpandComponent,
      className = _ref3.className,
      testId = _ref3.testId,
      onSelect = _ref3.onSelect,
      selectedIDs = _ref3.selectedIDs;
  var data = (hosts || []).filter(function (host) {
    return !skipDisabled || host.status != 'disabled';
  });
  return /*#__PURE__*/createElement(AITable, {
    getDataId: getHostId,
    data: data,
    ExpandComponent: ExpandComponent,
    content: content,
    actionResolver: actionResolver,
    className: className,
    testId: testId,
    onSelect: onSelect,
    selectedIDs: selectedIDs
  }, children);
};

var InfraEnvAgentTable = function InfraEnvAgentTable(_ref) {
  var agents = _ref.agents,
      className = _ref.className,
      getClusterDeploymentLink = _ref.getClusterDeploymentLink,
      bareMetalHosts = _ref.bareMetalHosts,
      infraEnv = _ref.infraEnv,
      actions = _objectWithoutPropertiesLoose(_ref, ["agents", "className", "getClusterDeploymentLink", "bareMetalHosts", "infraEnv"]);

  var _React$useState = useState(false),
      isDiscoveryHintModalOpen = _React$useState[0],
      setDiscoveryHintModalOpen = _React$useState[1];

  var _useAgentsTable = useAgentsTable(actions, {
    agents: agents,
    bmhs: bareMetalHosts,
    infraEnv: infraEnv
  }),
      hosts = _useAgentsTable[0],
      hostActions = _useAgentsTable[1],
      actionResolver = _useAgentsTable[2];

  var content = useMemo(function () {
    return [hostnameColumn(hostActions.onEditHost), discoveryTypeColumn(agents, bareMetalHosts), infraEnvStatusColumn({
      agents: agents,
      bareMetalHosts: bareMetalHosts,
      onEditHostname: actions.onEditHost,
      onApprove: actions.onApprove
    }), clusterColumn(agents, getClusterDeploymentLink), discoveredAtColumn, cpuCoresColumn, memoryColumn, disksColumn];
  }, [agents, actions, getClusterDeploymentLink, hostActions, bareMetalHosts]);
  return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(HostsTable, {
    hosts: hosts,
    content: content,
    actionResolver: actionResolver,
    className: className
  }, /*#__PURE__*/createElement(HostsTableEmptyState, {
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/createElement(DiscoveryTroubleshootingModal, {
    isOpen: isDiscoveryHintModalOpen,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  }));
};

var InfraEnvHostsTabAgentsWarning = function InfraEnvHostsTabAgentsWarning(_ref) {
  var infraAgents = _ref.infraAgents;
  var faiingAgentConditions = getFailingAgentConditions(infraAgents);
  var failingAgentNames = Object.getOwnPropertyNames(faiingAgentConditions);

  if (!failingAgentNames.length) {
    return null;
  }

  return /*#__PURE__*/createElement(ExclamationTriangleIcon, {
    color: global_warning_color_100.value,
    className: "infra-env-hosts-tab-title__icon"
  });
};

var SingleResourceAlerts = function SingleResourceAlerts(_ref) {
  var title = _ref.title,
      conditions = _ref.conditions;

  if (!conditions.length) {
    return null;
  }

  return /*#__PURE__*/React__default.createElement(Alert, {
    title: title,
    variant: AlertVariant.danger,
    isInline: true,
    className: "cim-resource-alerts"
  }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(TextList, {
    component: TextListVariants.ul
  }, conditions.map(function (c) {
    var _c$message$split = c.message.split(/:|\.,/),
        title = _c$message$split[0],
        messages = _c$message$split.slice(1);

    return /*#__PURE__*/React__default.createElement(React__default.Fragment, {
      key: title
    }, /*#__PURE__*/React__default.createElement(TextListItem, {
      component: TextListItemVariants.li
    }, /*#__PURE__*/React__default.createElement("strong", null, title)), messages.map(function (m) {
      return /*#__PURE__*/React__default.createElement(TextListItem, {
        key: m,
        component: TextListItemVariants.li
      }, m);
    }));
  }))));
};

var EnvironmentErrors = function EnvironmentErrors(_ref) {
  var infraEnv = _ref.infraEnv;
  var infraEnvAlerts = getFailingResourceConditions(infraEnv, undefined);
  return /*#__PURE__*/createElement(Fragment, null, !infraEnv.status && /*#__PURE__*/createElement(Alert, {
    title: "Central infrastructure management is not running",
    variant: AlertVariant.warning,
    isInline: true,
    className: "cim-resource-alerts",
    actionLinks: /*#__PURE__*/createElement("a", {
      href: "https://access.redhat.com/documentation/en-us/red_hat_advanced_cluster_management_for_kubernetes/",
      target: "_blank",
      rel: "noopener noreferrer"
    }, "Open documentation")
  }, "It seems the Central infrastructure management is not configured which will prevent its features to be used. Please refer to the documentation for the first time setup steps."), /*#__PURE__*/createElement(SingleResourceAlerts, {
    title: "Failing infrastructure environment",
    conditions: infraEnvAlerts
  }));
};

var validationSchema$1 = function validationSchema(usedNames) {
  return lazy(function (values) {
    return object().shape({
      name: string().required('Name is a required field.').test('duplicate-name', 'Infrastructure environment with the same name already exists!', function (value) {
        return !usedNames.find(function (n) {
          return n === value;
        });
      }),
      location: string().required('Location is a required field.'),
      pullSecret: pullSecretValidationSchema.required('Pull secret is a required field.'),
      sshPublicKey: sshPublicKeyValidationSchema.required('An SSH key is required to debug hosts as they register.'),
      httpProxy: httpProxyValidationSchema(values, 'httpsProxy'),
      httpsProxy: httpProxyValidationSchema(values, 'httpProxy'),
      noProxy: noProxyValidationSchema,
      labels: array().of(string()).test('label-equals-validation', 'Label selector needs to be in a `key=value` form', function (values) {
        return values.every(function (value) {
          var parts = value.split('=');
          return parts.length === 2;
        });
      })
    });
  });
};

var initialValues = {
  name: '',
  location: '',
  pullSecret: '',
  sshPublicKey: '',
  httpProxy: '',
  httpsProxy: '',
  noProxy: '',
  enableProxy: false,
  labels: [],
  networkType: 'dhcp'
};

var InfraEnvForm = function InfraEnvForm(_ref) {
  var onValuesChanged = _ref.onValuesChanged,
      isBMPlatform = _ref.isBMPlatform;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  useEffect(function () {
    return onValuesChanged === null || onValuesChanged === void 0 ? void 0 : onValuesChanged(values);
  }, [onValuesChanged, values]);
  return /*#__PURE__*/createElement(Stack, {
    hasGutter: true
  }, /*#__PURE__*/createElement(StackItem, null, "Infrastructure environments are used by clusters. Create an infrastructure environment to add resources to your cluster."), /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Form, null, /*#__PURE__*/createElement(InputField, {
    label: "Name",
    name: "name",
    placeholder: "Enter infrastructure environment name",
    isRequired: true
  }), /*#__PURE__*/createElement(FormGroup, {
    fieldId: "network-type",
    label: "Network type",
    labelIcon: /*#__PURE__*/createElement(PopoverIcon, {
      noVerticalAlign: true,
      bodyContent: /*#__PURE__*/createElement(Fragment, null, "This will determine for the infrastructure environment which kind of hosts would be able to be added. If the hosts that you want to add are using DHCP server, select this option, else, select the static IP.", !isBMPlatform &&
      /*#__PURE__*/
      createElement(Fragment, null, /*#__PURE__*/createElement("br", null), "Static IPs are only supported on bare metal platforms."))
    })
  }, /*#__PURE__*/createElement(Flex, {
    justifyContent: {
      "default": 'justifyContentFlexStart'
    }
  }, /*#__PURE__*/createElement(FlexItem, null, /*#__PURE__*/createElement(RadioField, {
    name: "networkType",
    id: "dhcp",
    value: "dhcp",
    label: "Use DHCP server"
  })), /*#__PURE__*/createElement(FlexItem, {
    spacer: {
      "default": 'spacer4xl'
    }
  }), /*#__PURE__*/createElement(FlexItem, null, /*#__PURE__*/createElement(RadioField, {
    name: "networkType",
    id: "static-ip",
    value: "static",
    label: "Use static IP",
    isDisabled: !isBMPlatform
  })))), /*#__PURE__*/createElement(InputField, {
    label: "Location",
    name: "location",
    placeholder: "Enter geographic location for the environment",
    helperText: "Used to describe hosts' physical location. Helps for quicker host selection during cluster creation.",
    isRequired: true
  }), /*#__PURE__*/createElement(LabelField, {
    label: "Labels",
    name: "labels"
  }), /*#__PURE__*/createElement(PullSecretField, {
    isOcm: false
  }), /*#__PURE__*/createElement(UploadSSH, null), /*#__PURE__*/createElement(ProxyFields, null))));
};

var InfraEnvFormPage = function InfraEnvFormPage(_ref2) {
  var usedNames = _ref2.usedNames,
      isBMPlatform = _ref2.isBMPlatform,
      _onSubmit = _ref2.onSubmit,
      onClose = _ref2.onClose,
      onFinish = _ref2.onFinish,
      onValuesChanged = _ref2.onValuesChanged;

  var _React$useState = useState(),
      error = _React$useState[0],
      setError = _React$useState[1];

  return /*#__PURE__*/createElement(Formik, {
    initialValues: initialValues,
    initialStatus: {
      error: null
    },
    validationSchema: validationSchema$1(usedNames),
    onSubmit: function onSubmit(values) {
      try {
        var _temp2 = _catch(function () {
          return Promise.resolve(_onSubmit === null || _onSubmit === void 0 ? void 0 : _onSubmit(values)).then(function () {
            onFinish === null || onFinish === void 0 ? void 0 : onFinish(values);
          });
        }, function (e) {
          var _e$message;

          setError((_e$message = e === null || e === void 0 ? void 0 : e.message) != null ? _e$message : 'An error occured');
        });

        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    }
  }, function (_ref3) {
    var isValid = _ref3.isValid,
        isSubmitting = _ref3.isSubmitting,
        submitForm = _ref3.submitForm;
    return /*#__PURE__*/createElement(Stack, {
      hasGutter: true
    }, /*#__PURE__*/createElement(StackItem, null, _onSubmit && onClose ? /*#__PURE__*/createElement(Grid, {
      hasGutter: true,
      span: 8
    }, /*#__PURE__*/createElement(GridItem, null, /*#__PURE__*/createElement(Title, {
      headingLevel: "h1",
      size: TitleSizes.xl
    }, "Configure environment")), /*#__PURE__*/createElement(GridItem, null, /*#__PURE__*/createElement(InfraEnvForm, {
      onValuesChanged: onValuesChanged,
      isBMPlatform: isBMPlatform
    }))) : /*#__PURE__*/createElement("div", {
      className: "infra-env__form"
    }, /*#__PURE__*/createElement(InfraEnvForm, {
      onValuesChanged: onValuesChanged,
      isBMPlatform: isBMPlatform
    }))), error && /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Alert, {
      variant: AlertVariant.danger,
      actionClose: /*#__PURE__*/createElement(AlertActionCloseButton, {
        onClose: function onClose() {
          return setError(undefined);
        }
      }),
      title: "Error creating InfraEnv"
    }, error)), _onSubmit && onClose && /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(Button, {
      variant: "primary",
      type: "submit",
      isDisabled: !isValid || isSubmitting,
      onClick: submitForm
    }, "Create ", isSubmitting && /*#__PURE__*/createElement(Spinner, {
      isSVG: true,
      size: "md"
    })), /*#__PURE__*/createElement(Button, {
      variant: "link",
      onClick: onClose,
      isDisabled: isSubmitting
    }, "Cancel"))));
  });
};

var getLabels = function getLabels(values) {
  return values.labels.reduce(function (acc, curr) {
    var label = curr.split('=');
    acc[label[0]] = label[1];
    return acc;
  }, {});
};
var getClusterDeploymentForInfraEnv = function getClusterDeploymentForInfraEnv(pullSecretName, namespace, values) {
  return getClusterDeploymentResource({
    name: values.name,
    namespace: namespace,
    baseDnsDomain: '',
    annotations: getLabels(values),
    pullSecretName: pullSecretName
  });
};
var getAgentClusterInstall = function getAgentClusterInstall(_ref) {
  var clusterDeploymentName = _ref.clusterDeploymentName,
      namespace = _ref.namespace,
      values = _ref.values;
  var obj = {
    apiVersion: 'extensions.hive.openshift.io/v1beta1',
    kind: 'AgentClusterInstall',
    metadata: {
      name: values.name,
      namespace: namespace
    },
    spec: {
      clusterDeploymentRef: clusterDeploymentName ? {
        name: clusterDeploymentName,
        namespace: namespace
      } : {},
      networking: {
        clusterNetwork: [{
          cidr: '10.128.0.0/14',
          hostPrefix: 23
        }],
        serviceNetwork: ['172.30.0.0/16']
      },
      provisionRequirements: {
        controlPlaneAgents: 3
      },
      imageSetRef: {
        name: 'openshift-v4.8.0'
      }
    }
  };

  if (obj.spec && values.sshPublicKey) {
    obj.spec.sshPublicKey = values.sshPublicKey;
  }

  return obj;
};
var getSecret = function getSecret(namespace, values) {
  return {
    kind: 'Secret',
    apiVersion: 'v1',
    metadata: {
      name: values.name,
      namespace: namespace
    },
    data: {
      '.dockerconfigjson': btoa(values.pullSecret)
    },
    type: 'kubernetes.io/dockerconfigjson'
  };
};
var getInfraEnv = function getInfraEnv(namespace, values) {
  var _labels;

  var labels = getLabels(values);

  if (values.location) {
    labels[AGENT_LOCATION_LABEL_KEY] = labels[AGENT_LOCATION_LABEL_KEY] || values.location;
  }

  var infraEnv = {
    apiVersion: 'agent-install.openshift.io/v1beta1',
    kind: 'InfraEnv',
    metadata: {
      name: values.name,
      namespace: namespace,
      labels: (_labels = {}, _labels[AGENT_LOCATION_LABEL_KEY] = values.location, _labels)
    },
    spec: {
      agentLabels: labels,
      clusterRef: {
        name: values.name,
        namespace: namespace
      },
      pullSecretRef: {
        name: values.name
      },
      sshAuthorizedKey: values.sshPublicKey
    },
    status: {
      agentLabelSelector: {
        matchLabels: labels
      }
    }
  };

  if (infraEnv.spec && values.enableProxy) {
    infraEnv.spec.proxy = {
      httpProxy: values.httpProxy,
      httpsProxy: values.httpsProxy,
      noProxy: values.noProxy
    };
  }

  return infraEnv;
};

var getK8sProxyURL = function getK8sProxyURL(aiNamespace) {
  if (aiNamespace === void 0) {
    aiNamespace = 'open-cluster-management';
  }

  return "/api/v1/namespaces/" + aiNamespace + "/services/https:assisted-service:8090/proxy";
};

var shouldShowClusterCredentials = function shouldShowClusterCredentials(agentClusterInstall) {
  var _getClusterStatus = getClusterStatus(agentClusterInstall),
      clusterStatus = _getClusterStatus[0];

  return ['installed', 'adding-hosts'].includes(clusterStatus);
};
var shouldShowClusterInstallationProgress = function shouldShowClusterInstallationProgress(agentClusterInstall) {
  var _getClusterStatus2 = getClusterStatus(agentClusterInstall),
      clusterStatus = _getClusterStatus2[0];

  return ['preparing-for-installation', 'installing', 'installing-pending-user-action', 'finalizing', 'installed', 'error', 'cancelled', 'adding-hosts'].includes(clusterStatus);
};
var isInstallationReady = function isInstallationReady(agentClusterInstall) {
  var _getClusterStatus3 = getClusterStatus(agentClusterInstall),
      clusterStatus = _getClusterStatus3[0];

  return ['ready', 'error', 'preparing-for-installation', 'installing', 'finalizing', 'installed', 'adding-hosts', 'cancelled', 'installing-pending-user-action'].includes(clusterStatus);
};
var shouldShowClusterInstallationError = function shouldShowClusterInstallationError(agentClusterInstall) {
  var _getClusterStatus4 = getClusterStatus(agentClusterInstall),
      clusterStatus = _getClusterStatus4[0];

  return ['error', 'cancelled'].includes(clusterStatus);
};
var formatEventsData = function formatEventsData(rawData) {
  return rawData.map(function (event) {
    return ___default.mapKeys(event, function (value, key) {
      return ___default.camelCase(key);
    });
  });
};

var getEventsURL = function getEventsURL(aiNamespace, agentClusterInstall) {
  var _agentClusterInstall$, _agentClusterInstall$2;

  if (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.status) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.debugInfo) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.eventsURL) {
    var _agentClusterInstall$3, _agentClusterInstall$4;

    var eventsURL = new URL((_agentClusterInstall$3 = agentClusterInstall.status) === null || _agentClusterInstall$3 === void 0 ? void 0 : (_agentClusterInstall$4 = _agentClusterInstall$3.debugInfo) === null || _agentClusterInstall$4 === void 0 ? void 0 : _agentClusterInstall$4.eventsURL);
    return "" + getK8sProxyURL(aiNamespace) + eventsURL.pathname + eventsURL.search;
  }

  return null;
};

var getOnFetchEventsHandler = function getOnFetchEventsHandler(fetchEvents, aiNamespace, agentClusterInstall) {
  return function (params, onSuccess, onError) {
    try {
      var eventsURL = getEventsURL(aiNamespace, agentClusterInstall);

      if (!eventsURL) {
        onError('Cannot determine events URL');
        return Promise.resolve();
      }

      var _temp2 = _catch(function () {
        return Promise.resolve(fetchEvents(eventsURL)).then(function (result) {
          var data = formatEventsData(result);
          onSuccess(data);
        });
      }, function (e) {
        onError(e.message);
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };
};

var onAdditionalNtpSource = function onAdditionalNtpSource(additionalNtpSource) {
  try {
    console.info('TODO: implement onAdditionalNtpSource for CIM: ', additionalNtpSource);
    return Promise.resolve();
  } catch (e) {
    return Promise.reject(e);
  }
};
var AdditionalNTPSourcesDialogToggle$1 = function AdditionalNTPSourcesDialogToggle(_ref) {
  var cluster = _ref.cluster;

  var _React$useState = React__default.useState(false),
      isOpen = _React$useState[0],
      setOpen = _React$useState[1];

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(AlertActionLink, {
    onClick: function onClick() {
      return setOpen(true);
    }
  }, "Add NTP sources"), ";", isOpen && /*#__PURE__*/React__default.createElement(AdditionalNTPSourcesDialog, {
    cluster: cluster,
    isOpen: isOpen,
    onClose: function onClose() {
      return setOpen(false);
    },
    onAdditionalNtpSource: onAdditionalNtpSource
  }));
};

var ClusterErrors = function ClusterErrors(_ref) {
  var agentClusterInstall = _ref.agentClusterInstall;
  var agentClusterInstallAlerts = getFailingResourceConditions(agentClusterInstall, ['Validated', 'SpecSynced']);
  return /*#__PURE__*/createElement(SingleResourceAlerts, {
    title: "Failing agent cluster installation",
    conditions: agentClusterInstallAlerts
  });
};

var LogsDownloadButton = function LogsDownloadButton(_ref) {
  var _agentClusterInstall$, _agentClusterInstall$2;

  var _ref$Component = _ref.Component,
      Component = _ref$Component === void 0 ? Button : _ref$Component,
      agentClusterInstall = _ref.agentClusterInstall,
      id = _ref.id,
      variant = _ref.variant;
  var logsURL = agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.status) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.debugInfo) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.logsURL;
  return /*#__PURE__*/React__default.createElement(Component, {
    onClick: function onClick() {
      return logsURL && saveAs(logsURL, 'logs.tar');
    },
    isDisabled: !logsURL,
    id: id,
    variant: variant
  }, "Download Installation Logs");
};

var ClusterDeploymentCredentials = function ClusterDeploymentCredentials(_ref) {
  var _agentClusterInstall$, _agentClusterInstall$2, _agentClusterInstall$3, _clusterDeployment$me;

  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      consoleUrl = _ref.consoleUrl,
      fetchSecret = _ref.fetchSecret;

  var _React$useState = React__default.useState({}),
      credentials = _React$useState[0],
      setCredentials = _React$useState[1];

  var _React$useState2 = React__default.useState(false),
      isError = _React$useState2[0],
      setIsError = _React$useState2[1];

  var cluster = getAICluster({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents
  });
  var adminPasswordSecretRefName = (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.clusterMetadata) === null || _agentClusterInstall$2 === void 0 ? void 0 : (_agentClusterInstall$3 = _agentClusterInstall$2.adminPasswordSecretRef) === null || _agentClusterInstall$3 === void 0 ? void 0 : _agentClusterInstall$3.name;
  var namespace = (_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.namespace;
  React__default.useEffect(function () {
    var fetchCredentials = function fetchCredentials() {
      try {
        var _temp3 = function () {
          if (adminPasswordSecretRefName && namespace) {
            var _temp4 = _catch(function () {
              return Promise.resolve(fetchSecret(adminPasswordSecretRefName, namespace)).then(function (secret) {
                var _secret$data, _secret$data2;

                setCredentials({
                  username: atob((secret === null || secret === void 0 ? void 0 : (_secret$data = secret.data) === null || _secret$data === void 0 ? void 0 : _secret$data.username) || ''),
                  password: atob((secret === null || secret === void 0 ? void 0 : (_secret$data2 = secret.data) === null || _secret$data2 === void 0 ? void 0 : _secret$data2.password) || '')
                });
              });
            }, function (e) {
              setIsError(true);
              console.error('Failed to fetch adminPasswordSecret secret.', e);
            });

            if (_temp4 && _temp4.then) return _temp4.then(function () {});
          }
        }();

        return Promise.resolve(_temp3 && _temp3.then ? _temp3.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    fetchCredentials();
  }, [adminPasswordSecretRefName, namespace, fetchSecret]);
  return /*#__PURE__*/React__default.createElement(ClusterCredentials, {
    cluster: cluster,
    credentials: _extends({}, credentials, {
      consoleUrl: consoleUrl
    }),
    error: isError
  });
};

var AgentTableEmptyState = function AgentTableEmptyState() {
  return /*#__PURE__*/createElement(EmptyState, {
    icon: ConnectedIcon,
    title: "Waiting for hosts...",
    content: "Hosts may take a few minutes to appear here after booting."
  });
};

var AgentTable = function AgentTable(_ref) {
  var agents = _ref.agents,
      className = _ref.className,
      actions = _objectWithoutPropertiesLoose(_ref, ["agents", "className"]);

  var _useAgentsTable = useAgentsTable(actions, {
    agents: agents
  }),
      hosts = _useAgentsTable[0],
      hostActions = _useAgentsTable[1],
      actionResolver = _useAgentsTable[2];

  var content = useMemo(function () {
    return [hostnameColumn(hostActions.onEditHost), roleColumn(hostActions.canEditRole, hostActions.onEditRole), infraEnvStatusColumn({
      agents: agents,
      onEditHostname: actions.onEditHost,
      onApprove: actions.onApprove
    }), infraEnvColumn(agents), cpuCoresColumn, memoryColumn, disksColumn];
  }, [agents, hostActions, actions]);
  return /*#__PURE__*/createElement(HostsTable, {
    hosts: hosts,
    content: content,
    actionResolver: actionResolver,
    className: className
  }, /*#__PURE__*/createElement(AgentTableEmptyState, null));
};

var ClusterDeploymentKubeconfigDownload = function ClusterDeploymentKubeconfigDownload(_ref) {
  var _clusterDeployment$me2;

  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      fetchSecret = _ref.fetchSecret;

  var _getClusterStatus = getClusterStatus(agentClusterInstall),
      clusterStatus = _getClusterStatus[0];

  var handleKubeconfigDownload = function handleKubeconfigDownload() {
    try {
      var _agentClusterInstall$, _agentClusterInstall$2, _agentClusterInstall$3, _clusterDeployment$me;

      var kubeconfigSecretName = (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.clusterMetadata) === null || _agentClusterInstall$2 === void 0 ? void 0 : (_agentClusterInstall$3 = _agentClusterInstall$2.adminKubeconfigSecretRef) === null || _agentClusterInstall$3 === void 0 ? void 0 : _agentClusterInstall$3.name;
      var kubeconfigSecretNamespace = (_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.namespace;
      return Promise.resolve(function () {
        if (kubeconfigSecretName && kubeconfigSecretNamespace) {
          return _catch(function () {
            return Promise.resolve(fetchSecret(kubeconfigSecretName, kubeconfigSecretNamespace)).then(function (kubeconfigSecret) {
              var _kubeconfigSecret$dat;

              var kubeconfig = (_kubeconfigSecret$dat = kubeconfigSecret.data) === null || _kubeconfigSecret$dat === void 0 ? void 0 : _kubeconfigSecret$dat.kubeconfig;
              if (!kubeconfig) throw new Error('Kubeconfig is empty.');
              var blob = new Blob([atob(kubeconfig)], {
                type: 'text/plain;charset=utf-8'
              });
              saveAs(blob, 'kubeconfig.json');
            });
          }, function (e) {
            console.error('Failed to fetch kubeconfig secret.', e);
          });
        }
      }());
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(KubeconfigDownload, {
    handleDownload: handleKubeconfigDownload,
    clusterId: ((_clusterDeployment$me2 = clusterDeployment.metadata) === null || _clusterDeployment$me2 === void 0 ? void 0 : _clusterDeployment$me2.uid) || '',
    status: clusterStatus
  });
};

var ClusterDeploymentDetails = function ClusterDeploymentDetails(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      fetchSecret = _ref.fetchSecret,
      agentTableClassName = _ref.agentTableClassName,
      onFetchEvents = _ref.onFetchEvents;

  var _React$useState = React__default.useState(true),
      progressCardExpanded = _React$useState[0],
      setProgressCardExpanded = _React$useState[1];

  var _React$useState2 = React__default.useState(true),
      inventoryCardExpanded = _React$useState2[0],
      setInventoryCardExpanded = _React$useState2[1];

  var _React$useState3 = React__default.useState(true),
      detailsCardExpanded = _React$useState3[0],
      setDetailsCardExpanded = _React$useState3[1];

  var clusterAgents = agents.filter(function (a) {
    var _a$spec$clusterDeploy, _clusterDeployment$me, _a$spec$clusterDeploy2, _clusterDeployment$me2;

    return ((_a$spec$clusterDeploy = a.spec.clusterDeploymentName) === null || _a$spec$clusterDeploy === void 0 ? void 0 : _a$spec$clusterDeploy.name) === ((_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.name) && ((_a$spec$clusterDeploy2 = a.spec.clusterDeploymentName) === null || _a$spec$clusterDeploy2 === void 0 ? void 0 : _a$spec$clusterDeploy2.namespace) === ((_clusterDeployment$me2 = clusterDeployment.metadata) === null || _clusterDeployment$me2 === void 0 ? void 0 : _clusterDeployment$me2.namespace);
  });
  var cluster = getAICluster({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: clusterAgents
  });
  var clusterProperties = React__default.useMemo(function () {
    return getClusterProperties(clusterDeployment, agentClusterInstall);
  }, [clusterDeployment, agentClusterInstall]);
  return /*#__PURE__*/React__default.createElement(Stack, {
    hasGutter: true
  }, shouldShowClusterInstallationProgress(agentClusterInstall) && /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(Card, {
    id: "cluster-installation-progress-card",
    isExpanded: progressCardExpanded
  }, /*#__PURE__*/React__default.createElement(CardHeader, {
    onExpand: function onExpand() {
      return setProgressCardExpanded(!progressCardExpanded);
    },
    toggleButtonProps: {
      id: 'progress-card-toggle-button',
      'aria-label': 'Cluster installation process',
      'aria-labelledby': 'titleId progress-card-toggle-button',
      'aria-expanded': progressCardExpanded
    }
  }, /*#__PURE__*/React__default.createElement(CardTitle, {
    id: "titleId"
  }, "Cluster installation process")), /*#__PURE__*/React__default.createElement(CardExpandableContent, null, /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(Stack, {
    hasGutter: true
  }, shouldShowClusterCredentials(agentClusterInstall) && /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(ClusterDeploymentCredentials, {
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: clusterAgents,
    fetchSecret: fetchSecret,
    consoleUrl: getConsoleUrl(clusterDeployment)
  })), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(ClusterDeploymentKubeconfigDownload, {
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    fetchSecret: fetchSecret
  }), ' ', /*#__PURE__*/React__default.createElement(EventsModalButton, {
    id: "cluster-events-button",
    entityKind: "cluster",
    cluster: cluster,
    title: "Cluster Events",
    variant: ButtonVariant.link,
    style: {
      textAlign: 'right'
    },
    onFetchEvents: onFetchEvents,
    ButtonComponent: Button
  }, "View Cluster Events"))))))), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(Card, {
    id: "cluster-inventory-card",
    isExpanded: inventoryCardExpanded
  }, /*#__PURE__*/React__default.createElement(CardHeader, {
    onExpand: function onExpand() {
      return setInventoryCardExpanded(!inventoryCardExpanded);
    },
    toggleButtonProps: {
      id: 'inventory-card-toggle-button',
      'aria-label': 'Hosts inventory',
      'aria-labelledby': 'titleId inventory-card-toggle-button',
      'aria-expanded': inventoryCardExpanded
    }
  }, /*#__PURE__*/React__default.createElement(CardTitle, {
    id: "titleId"
  }, "Hosts inventory")), /*#__PURE__*/React__default.createElement(CardExpandableContent, null, /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(AgentTable, {
    agents: clusterAgents,
    className: agentTableClassName
  }))))), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(Card, {
    id: "cluster-details-card",
    isExpanded: detailsCardExpanded
  }, /*#__PURE__*/React__default.createElement(CardHeader, {
    onExpand: function onExpand() {
      return setDetailsCardExpanded(!detailsCardExpanded);
    },
    toggleButtonProps: {
      id: 'details-card-toggle-button',
      'aria-label': 'Details',
      'aria-labelledby': 'titleId details-card-toggle-button',
      'aria-expanded': detailsCardExpanded
    }
  }, /*#__PURE__*/React__default.createElement(CardTitle, {
    id: "titleId"
  }, "Details")), /*#__PURE__*/React__default.createElement(CardExpandableContent, null, /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(ClusterPropertiesList, {
    leftItems: [clusterProperties.name, clusterProperties.openshiftVersion, clusterProperties.clusterId, clusterProperties.installedTimestamp, clusterProperties.baseDnsDomain],
    rightItems: [clusterProperties.apiVip, clusterProperties.ingressVip, clusterProperties.clusterNetworkCidr, clusterProperties.clusterNetworkHostPrefix, clusterProperties.serviceNetworkCidr]
  }))))));
};

var getAgentProgressStageNumber = function getAgentProgressStageNumber(agent) {
  var stages = getAgentProgressStages(agent);
  var progress = getAgentProgress(agent);
  var currentStage = progress === null || progress === void 0 ? void 0 : progress.currentStage;
  return stages.findIndex(function (s) {
    return currentStage === null || currentStage === void 0 ? void 0 : currentStage.match(s);
  }) + 1;
};

var getAgentsProgressPercent = function getAgentsProgressPercent(agents) {
  if (agents === void 0) {
    agents = [];
  }

  var totalSteps = agents.reduce(function (steps, agent) {
    return steps + getAgentProgressStages(agent).length;
  }, 0);
  var completedSteps = agents.reduce(function (steps, agent) {
    return steps + getAgentProgressStageNumber(agent);
  }, 0);
  return totalSteps ? Math.round(completedSteps / totalSteps * 100) : 100;
};

var ClusterDeploymentProgress = function ClusterDeploymentProgress(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      onFetchEvents = _ref.onFetchEvents,
      fallbackEventsURL = _ref.fallbackEventsURL;
  var agentsProgressPercent = React__default.useMemo(function () {
    return getAgentsProgressPercent(agents);
  }, [agents]);
  var cluster = getAICluster({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents
  });
  return /*#__PURE__*/React__default.createElement(ClusterProgress, {
    totalPercentage: agentsProgressPercent,
    cluster: cluster,
    onFetchEvents: onFetchEvents,
    fallbackEventsURL: fallbackEventsURL
  });
};

var ClusterDeploymentWizardContext = React__default.createContext({
  currentStepId: 'cluster-details',
  setCurrentStepId: function setCurrentStepId() {
    console.error('Tried to use ClusterWizardContext but there was no provider rendered.');
  }
});

var CLUSTER_HOSTS_SELECTION_LABELS = {
  hostCount: 'Host Count',
  masterLabels: 'Host Labels',
  workerLabels: 'Worker Hosts Labels'
};
var CLUSTER_DEPLOYMENT_FIELD_LABELS = _extends({}, CLUSTER_FIELD_LABELS, CLUSTER_HOSTS_SELECTION_LABELS);
var wizardStepNames = {
  'cluster-details': 'Cluster details',
  'hosts-selection': 'Cluster hosts',
  networking: 'Installation details'
};
var HOSTS_MAX_COUNT = 1024;
var HOSTS_MIN_COUNT = 3;

var ValidationSection = function ValidationSection(_ref) {
  var _ref$errorFields = _ref.errorFields,
      errorFields = _ref$errorFields === void 0 ? [] : _ref$errorFields;
  return errorFields.length > 0 ? /*#__PURE__*/React__default.createElement(AlertGroup, null, /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.danger,
    title: "Provided cluster configuration is not valid",
    isInline: true
  }, "The following fields are not valid:", ' ', errorFields.map(function (field) {
    return CLUSTER_DEPLOYMENT_FIELD_LABELS[field] || field;
  }).join(', '), ".")) : null;
};

var ClusterDeploymentWizardFooter = function ClusterDeploymentWizardFooter(_ref2) {
  var errorFields = _ref2.errorFields,
      rest = _objectWithoutPropertiesLoose(_ref2, ["errorFields"]);

  var _useAlerts = useAlerts(),
      alerts = _useAlerts.alerts;

  var alertsSection = alerts.length ? /*#__PURE__*/React__default.createElement(Alerts, null) : undefined;
  var errorsSection = /*#__PURE__*/React__default.createElement(ValidationSection, {
    errorFields: errorFields
  });
  return /*#__PURE__*/React__default.createElement(WizardFooter, _extends({
    alerts: alertsSection,
    errors: errorsSection
  }, rest));
};

var wizardSteps = Object.keys(wizardStepNames);

var ClusterDeploymentWizardNavigation = function ClusterDeploymentWizardNavigation() {
  var _React$useContext = React__default.useContext(ClusterDeploymentWizardContext),
      currentStepId = _React$useContext.currentStepId,
      setCurrentStepId = _React$useContext.setCurrentStepId;

  return /*#__PURE__*/React__default.createElement(WizardNav, null, /*#__PURE__*/React__default.createElement(NavItem, {
    key: "cluster-details",
    content: wizardStepNames['cluster-details'],
    isCurrent: currentStepId === 'cluster-details',
    isValid: function isValid() {
      return true;
    },
    isDisabled: false,
    step: 0,
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('cluster-details');
    }
  }), /*#__PURE__*/React__default.createElement(NavItem, {
    key: "hosts-selection",
    content: wizardStepNames['hosts-selection'],
    isDisabled: !wizardSteps.slice(1).includes(currentStepId),
    isValid: function isValid() {
      return true;
    },
    isCurrent: currentStepId === 'hosts-selection',
    step: 1,
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('hosts-selection');
    }
  }), /*#__PURE__*/React__default.createElement(NavItem, {
    key: "networking",
    content: wizardStepNames['networking'],
    isDisabled: !wizardSteps.slice(2).includes(currentStepId),
    isValid: function isValid() {
      return true;
    },
    isCurrent: currentStepId === 'networking',
    step: 2,
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('networking');
    }
  }));
};

var ClusterDeploymentWizardStep = ClusterWizardStep;

var ClusterDeploymentDetailsForm = function ClusterDeploymentDetailsForm(_ref) {
  var _agentClusterInstall$, _agentClusterInstall$2;

  var agentClusterInstall = _ref.agentClusterInstall,
      clusterDeployment = _ref.clusterDeployment,
      clusterImages = _ref.clusterImages,
      toggleRedHatDnsService = _ref.toggleRedHatDnsService,
      onValuesChanged = _ref.onValuesChanged,
      pullSecret = _ref.pullSecret,
      extensionAfter = _ref.extensionAfter;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  useEffect(function () {
    return onValuesChanged === null || onValuesChanged === void 0 ? void 0 : onValuesChanged(values);
  }, [onValuesChanged, values]);
  var ocpVersions = useMemo(function () {
    return getOCPVersions(clusterImages);
  }, [clusterImages]);
  var isEditFlow = !!clusterDeployment;
  return /*#__PURE__*/createElement(ClusterDetailsFormFields, {
    toggleRedHatDnsService: toggleRedHatDnsService,
    versions: ocpVersions,
    canEditPullSecret: !clusterDeployment,
    isSNOGroupDisabled: !!clusterDeployment,
    isNameDisabled: isEditFlow,
    isBaseDnsDomainDisabled: isEditFlow,
    forceOpenshiftVersion: agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.imageSetRef) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.name,
    isOcm: false,
    defaultPullSecret: pullSecret,
    extensionAfter: extensionAfter
  });
};

var useDetailsFormik = function useDetailsFormik(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      clusterImages = _ref.clusterImages,
      usedClusterNames = _ref.usedClusterNames,
      defaultBaseDomain = _ref.defaultBaseDomain,
      pullSecret = _ref.pullSecret;
  var ocpVersions = getOCPVersions(clusterImages);
  var cluster = React__default.useMemo(function () {
    return clusterDeployment && agentClusterInstall ? getAICluster({
      clusterDeployment: clusterDeployment,
      agentClusterInstall: agentClusterInstall,
      agents: agents
    }) : undefined;
  }, [agentClusterInstall, clusterDeployment, agents]);
  var initialValues = React__default.useMemo(function () {
    return getClusterDetailsInitialValues({
      managedDomains: [],
      cluster: cluster,
      ocpVersions: ocpVersions,
      baseDomain: defaultBaseDomain,
      pullSecret: pullSecret
    });
  }, []);
  var validationSchema = React__default.useMemo(function () {
    return getClusterDetailsValidationSchema(usedClusterNames, cluster, ocpVersions);
  }, [usedClusterNames, cluster, ocpVersions]);
  return [initialValues, validationSchema];
};

var ClusterDeploymentDetailsStep = function ClusterDeploymentDetailsStep(_ref2) {
  var clusterImages = _ref2.clusterImages,
      clusterDeployment = _ref2.clusterDeployment,
      agentClusterInstall = _ref2.agentClusterInstall,
      agents = _ref2.agents,
      usedClusterNames = _ref2.usedClusterNames,
      onSaveDetails = _ref2.onSaveDetails,
      onClose = _ref2.onClose,
      pullSecret = _ref2.pullSecret;

  var _useTranslation = useTranslation(),
      t = _useTranslation.t;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _React$useContext = React__default.useContext(ClusterDeploymentWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var _useDetailsFormik = useDetailsFormik({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents,
    clusterImages: clusterImages,
    usedClusterNames: usedClusterNames
  }),
      initialValues = _useDetailsFormik[0],
      validationSchema = _useDetailsFormik[1];

  var next = function next() {
    return setCurrentStepId('hosts-selection');
  };

  var handleSubmit = function handleSubmit(values) {
    try {
      var _temp2 = _catch(function () {
        return Promise.resolve(onSaveDetails(values)).then(function () {
          next();
        });
      }, function (error) {
        addAlert({
          title: 'Failed to save ClusterDeployment',
          message: error
        });
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    onSubmit: handleSubmit
  }, function (_ref3) {
    var submitForm = _ref3.submitForm,
        isSubmitting = _ref3.isSubmitting,
        isValid = _ref3.isValid,
        isValidating = _ref3.isValidating,
        dirty = _ref3.dirty,
        errors = _ref3.errors,
        touched = _ref3.touched;

    var handleOnNext = function handleOnNext() {
      if (dirty) {
        submitForm();
      } else {
        next();
      }
    };

    var footer = /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardFooter, {
      errorFields: getFormikErrorFields(errors, touched),
      isSubmitting: isSubmitting,
      isNextDisabled: !isValid || isValidating || isSubmitting,
      onNext: handleOnNext,
      onCancel: onClose
    });
    var navigation = /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardNavigation, null);
    return /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardStep, {
      navigation: navigation,
      footer: footer
    }, /*#__PURE__*/React__default.createElement(Grid, {
      hasGutter: true
    }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, null, t('Cluster Details'))), /*#__PURE__*/React__default.createElement(GridItem, {
      span: 12,
      lg: 10,
      xl: 9,
      xl2: 7
    }, /*#__PURE__*/React__default.createElement(ClusterDeploymentDetailsForm, {
      agentClusterInstall: agentClusterInstall,
      clusterDeployment: clusterDeployment,
      clusterImages: clusterImages,
      pullSecret: pullSecret
    }))));
  });
};

var ClusterDeploymentHostsNetworkTable = function ClusterDeploymentHostsNetworkTable(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      hostActions = _ref.hostActions;
  var cluster = getAICluster({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents
  });

  var _useAgentsTable = useAgentsTable(hostActions, {
    agents: agents
  }),
      hosts = _useAgentsTable[0],
      _useAgentsTable$ = _useAgentsTable[1],
      onEditHost = _useAgentsTable$.onEditHost,
      canEditRole = _useAgentsTable$.canEditRole,
      onEditRole = _useAgentsTable$.onEditRole,
      actionResolver = _useAgentsTable[2];

  var AdditionalNTPSourcesDialogToggleWithCluster = useCallback(function () {
    return /*#__PURE__*/createElement(AdditionalNTPSourcesDialogToggle$1, {
      cluster: cluster
    });
  }, [cluster]);
  var isSNOCluster = getIsSNOCluster(agentClusterInstall);
  var content = useMemo(function () {
    return isSNOCluster ? [hostnameColumn(onEditHost, hosts), networkingStatusColumn$1(onEditHost), activeNICColumn(cluster), countColumn(cluster)] : [hostnameColumn(onEditHost, hosts), roleColumn(canEditRole, onEditRole), networkingStatusColumn$1(onEditHost), activeNICColumn(cluster), countColumn(cluster)];
  }, [onEditHost, onEditRole, canEditRole, cluster, isSNOCluster, hosts]);
  return /*#__PURE__*/createElement(HostsTable, {
    testId: "networking-host-table",
    hosts: hosts,
    ExpandComponent: function ExpandComponent(_ref2) {
      var obj = _ref2.obj;
      return /*#__PURE__*/createElement(HostDetail, {
        host: obj,
        AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggleWithCluster
      });
    },
    content: content,
    actionResolver: actionResolver
  }, /*#__PURE__*/createElement(EmptyState, {
    icon: ConnectedIcon,
    title: "Waiting for hosts...",
    content: "Hosts may take a few minutes to appear here after booting."
  }));
};

var defaultNetworkSettings = CLUSTER_DEFAULT_NETWORK_SETTINGS_IPV4;

var ClusterDeploymentNetworkingForm = function ClusterDeploymentNetworkingForm(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      onValuesChanged = _ref.onValuesChanged,
      rest = _objectWithoutPropertiesLoose(_ref, ["clusterDeployment", "agentClusterInstall", "agents", "onValuesChanged"]);

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  useEffect(function () {
    return onValuesChanged === null || onValuesChanged === void 0 ? void 0 : onValuesChanged(values);
  }, [onValuesChanged, values]);
  var isVipDhcpAllocationDisabled = true;
  var cluster = getAICluster({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents
  });
  var hostSubnets = [];
  var bindingAgents = [];
  var discoveringAgents = [];
  agents.forEach(function (a) {
    var _getAgentStatus = getAgentStatus(a),
        status = _getAgentStatus[0];

    if (status === 'binding') {
      bindingAgents.push(a);
    }

    if (status === 'discovering') {
      discoveringAgents.push(a);
    }
  });

  if (bindingAgents.length === 0 && discoveringAgents.length === 0) {
    hostSubnets = getHostSubnets(cluster);
  }

  return /*#__PURE__*/createElement(NetworkConfigurationFormFields, {
    cluster: cluster,
    hostSubnets: hostSubnets,
    isVipDhcpAllocationDisabled: isVipDhcpAllocationDisabled,
    defaultNetworkSettings: defaultNetworkSettings,
    hideManagedNetworking: true
  }, /*#__PURE__*/createElement(Grid, {
    hasGutter: true
  }, !!bindingAgents.length && /*#__PURE__*/createElement(GridItem, null, /*#__PURE__*/createElement(Alert, {
    variant: "info",
    isInline: true,
    title: bindingAgents.length + " " + (bindingAgents.length === 1 ? 'host is' : 'hosts are') + " binding. Please wait until they are available to continue configuring. It may take several seconds."
  })), /*#__PURE__*/createElement(GridItem, null, /*#__PURE__*/createElement(TextContent, null, /*#__PURE__*/createElement(Text, {
    component: "h2"
  }, "Host inventory"))), /*#__PURE__*/createElement(GridItem, null, /*#__PURE__*/createElement(ClusterDeploymentHostsNetworkTable, _extends({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents
  }, rest)))));
};

var useNetworkingFormik = function useNetworkingFormik(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents;
  var initialValues = React__default.useMemo(function () {
    var cluster = getAICluster({
      clusterDeployment: clusterDeployment,
      agentClusterInstall: agentClusterInstall,
      agents: agents
    });
    return getNetworkInitialValues(cluster, defaultNetworkSettings);
  }, []);
  var validationSchema = React__default.useMemo(function () {
    var cluster = getAICluster({
      clusterDeployment: clusterDeployment,
      agentClusterInstall: agentClusterInstall,
      agents: agents
    });
    var hostSubnets = getHostSubnets(cluster);
    return getNetworkConfigurationValidationSchema(initialValues, hostSubnets);
  }, [initialValues, clusterDeployment, agentClusterInstall, agents]);
  return [initialValues, validationSchema];
};

var ClusterDeploymentNetworkingStep = function ClusterDeploymentNetworkingStep(_ref2) {
  var clusterDeployment = _ref2.clusterDeployment,
      agentClusterInstall = _ref2.agentClusterInstall,
      agents = _ref2.agents,
      onSaveNetworking = _ref2.onSaveNetworking,
      onClose = _ref2.onClose,
      onFinish = _ref2.onFinish,
      rest = _objectWithoutPropertiesLoose(_ref2, ["clusterDeployment", "agentClusterInstall", "agents", "onSaveNetworking", "onClose", "onFinish"]);

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _React$useContext = React__default.useContext(ClusterDeploymentWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var matchingAgents = agents.filter(function (a) {
    var _a$spec$clusterDeploy, _clusterDeployment$me, _a$spec$clusterDeploy2, _clusterDeployment$me2;

    return ((_a$spec$clusterDeploy = a.spec.clusterDeploymentName) === null || _a$spec$clusterDeploy === void 0 ? void 0 : _a$spec$clusterDeploy.name) === ((_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.name) && ((_a$spec$clusterDeploy2 = a.spec.clusterDeploymentName) === null || _a$spec$clusterDeploy2 === void 0 ? void 0 : _a$spec$clusterDeploy2.namespace) === ((_clusterDeployment$me2 = clusterDeployment.metadata) === null || _clusterDeployment$me2 === void 0 ? void 0 : _clusterDeployment$me2.namespace);
  });

  var _useNetworkingFormik = useNetworkingFormik({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: matchingAgents
  }),
      initialValues = _useNetworkingFormik[0],
      validationSchema = _useNetworkingFormik[1];

  var next = function next() {
    onFinish();
  };

  var handleSubmit = function handleSubmit(values) {
    try {
      var _temp2 = _catch(function () {
        return Promise.resolve(onSaveNetworking(values)).then(function () {
          next();
        });
      }, function (error) {
        addAlert({
          title: 'Failed to save ClusterDeployment',
          message: error
        });
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    onSubmit: handleSubmit
  }, function (_ref3) {
    var submitForm = _ref3.submitForm,
        isSubmitting = _ref3.isSubmitting,
        isValid = _ref3.isValid,
        isValidating = _ref3.isValidating,
        dirty = _ref3.dirty,
        errors = _ref3.errors,
        touched = _ref3.touched;

    var handleOnNext = function handleOnNext() {
      if (dirty) {
        submitForm();
      } else {
        next();
      }
    };

    var footer = /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardFooter, {
      errorFields: getFormikErrorFields(errors, touched),
      isSubmitting: isSubmitting,
      isNextDisabled: !isValid || isValidating || isSubmitting,
      onNext: handleOnNext,
      onBack: function onBack() {
        return setCurrentStepId('hosts-selection');
      },
      onCancel: onClose,
      nextButtonText: "Save and install"
    });
    var navigation = /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardNavigation, null);
    return /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardStep, {
      navigation: navigation,
      footer: footer
    }, /*#__PURE__*/React__default.createElement(Grid, {
      hasGutter: true
    }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, null, "Networking")), /*#__PURE__*/React__default.createElement(GridItem, {
      span: 12,
      lg: 10,
      xl: 9,
      xl2: 7
    }, /*#__PURE__*/React__default.createElement(ClusterDeploymentNetworkingForm, _extends({
      clusterDeployment: clusterDeployment,
      agentClusterInstall: agentClusterInstall,
      agents: matchingAgents
    }, rest)))));
  });
};

var LocationsLabelIcon = function LocationsLabelIcon() {
  return /*#__PURE__*/React__default.createElement(PopoverIcon, {
    position: "right",
    bodyContent: /*#__PURE__*/React__default.createElement(Fragment, null, "Select one or multiple locations to choose the hosts from.", /*#__PURE__*/React__default.createElement("br", null), "Keep the field empty to match ", /*#__PURE__*/React__default.createElement("b", null, "any"), " location.", /*#__PURE__*/React__default.createElement("br", null), "Set ", /*#__PURE__*/React__default.createElement("b", null, AGENT_LOCATION_LABEL_KEY), " label in Agent resource to specify it's location.")
  });
};

var getNumOfHosts = function getNumOfHosts(size) {
  if (size === 0) {
    return '(no hosts available)';
  } else if (size === 1) {
    return '(1 host available)';
  }

  return "(" + size + " hosts available)";
};

var LocationsSelector = function LocationsSelector(_ref) {
  var agents = _ref.agents;

  var locations = countBy(agents, function (_ref2) {
    var _metadata$labels;

    var metadata = _ref2.metadata;
    return (metadata === null || metadata === void 0 ? void 0 : (_metadata$labels = metadata.labels) === null || _metadata$labels === void 0 ? void 0 : _metadata$labels[AGENT_LOCATION_LABEL_KEY]) || AGENT_NOLOCATION_VALUE;
  });

  var agentLocationOptions = Object.keys(locations).map(function (location) {
    return {
      isLastOptionBeforeFooter: function isLastOptionBeforeFooter(index) {
        return index === locations.length;
      },
      id: location,
      value: location,
      displayName: (location === AGENT_NOLOCATION_VALUE ? 'No location' : location) + " " + getNumOfHosts(locations[location])
    };
  });
  return /*#__PURE__*/React__default.createElement(MultiSelectField, {
    idPostfix: "locations",
    name: "locations",
    label: "Host locations",
    labelIcon: /*#__PURE__*/React__default.createElement(LocationsLabelIcon, null),
    placeholderText: "Type or select location(s)",
    helperText: "Select one or more locations to view hosts",
    options: agentLocationOptions
  });
};

var getTotalCompute = function getTotalCompute(selectedAgents) {
  var totals = selectedAgents.reduce(function (acc, agent) {
    var _agent$status, _agent$status$invento, _agent$status2, _agent$status2$invent;

    acc.cpus += ((_agent$status = agent.status) === null || _agent$status === void 0 ? void 0 : (_agent$status$invento = _agent$status.inventory.cpu) === null || _agent$status$invento === void 0 ? void 0 : _agent$status$invento.count) || 0;
    acc.memory += ((_agent$status2 = agent.status) === null || _agent$status2 === void 0 ? void 0 : (_agent$status2$invent = _agent$status2.inventory.memory) === null || _agent$status2$invent === void 0 ? void 0 : _agent$status2$invent.usableBytes) || 0;
    return acc;
  }, {
    cpus: 0,
    memory: 0
  });
  return totals.cpus + " CPUs | " + fileSize(totals.memory, 2, 'iec') + " Memory";
};

var ShortCapacitySummary = function ShortCapacitySummary(_ref) {
  var selectedAgents = _ref.selectedAgents;
  return /*#__PURE__*/React__default.createElement("div", null, "Total compute: ", getTotalCompute(selectedAgents));
};

var getHostCountWarningText = function getHostCountWarningText(hostsSelected) {
  switch (hostsSelected) {
    case 0:
      return 'No host is selected.';

    case 1:
      return 'Only 1 host is selected.';
  }

  return "Only " + hostsSelected + " hosts are selected.";
};

var AgentsSelectionHostCountAlerts = function AgentsSelectionHostCountAlerts(_ref) {
  var matchingAgentsCount = _ref.matchingAgentsCount,
      selectedAgents = _ref.selectedAgents,
      targetHostCount = _ref.targetHostCount;
  var selectedAgentsCount = selectedAgents.length;
  return /*#__PURE__*/React__default.createElement(AlertGroup, null, selectedAgentsCount === targetHostCount && /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.success,
    title: selectedAgentsCount + " " + (selectedAgentsCount === 1 ? 'host' : 'hosts') + " selected out of " + matchingAgentsCount + " matching.",
    isInline: true
  }, /*#__PURE__*/React__default.createElement(ShortCapacitySummary, {
    selectedAgents: selectedAgents
  })), selectedAgentsCount < targetHostCount && /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.warning,
    title: getHostCountWarningText(selectedAgentsCount),
    isInline: true
  }, /*#__PURE__*/React__default.createElement(ShortCapacitySummary, {
    selectedAgents: selectedAgents
  })));
};

var AgentsSelectionHostCountLabelIcon = function AgentsSelectionHostCountLabelIcon() {
  return /*#__PURE__*/React__default.createElement(PopoverIcon, {
    position: "right",
    bodyContent: /*#__PURE__*/React__default.createElement(Fragment, null, "Total count of hosts to be included in the cluster.")
  });
};

var useAgentsAutoSelection = function useAgentsAutoSelection(availableAgents) {
  var _useFormikContext = useFormikContext(),
      setFieldValue = _useFormikContext.setFieldValue,
      values = _useFormikContext.values;

  var hostCount = values.hostCount,
      locations = values.locations,
      autoSelectedHostIds = values.autoSelectedHostIds;

  var _React$useMemo = React__default.useMemo(function () {
    var mAgents = availableAgents.filter(function (agent) {
      var _agent$metadata, _agent$metadata$label;

      var agentLocation = ((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : (_agent$metadata$label = _agent$metadata.labels) === null || _agent$metadata$label === void 0 ? void 0 : _agent$metadata$label[AGENT_LOCATION_LABEL_KEY]) || AGENT_NOLOCATION_VALUE;
      return locations.length ? locations.includes(agentLocation) : true;
    });
    var sAgents = mAgents.filter(function (a) {
      var _a$metadata;

      return autoSelectedHostIds.includes(((_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : _a$metadata.uid) || '');
    });
    return [mAgents, sAgents];
  }, [availableAgents, locations, autoSelectedHostIds]),
      matchingAgents = _React$useMemo[0],
      selectedAgents = _React$useMemo[1];

  React__default.useEffect(function () {
    var ids = matchingAgents.map(function (a) {
      var _a$metadata2;

      return (_a$metadata2 = a.metadata) === null || _a$metadata2 === void 0 ? void 0 : _a$metadata2.uid;
    }).splice(0, hostCount);

    if (!isEqual(ids, autoSelectedHostIds)) {
      setTimeout(function () {
        return setFieldValue('autoSelectedHostIds', ids, true);
      });
    }
  }, [matchingAgents, setFieldValue, autoSelectedHostIds, hostCount]);
  return {
    matchingAgents: matchingAgents,
    selectedAgents: selectedAgents,
    hostCount: hostCount
  };
};

var ClusterDeploymentHostsSelectionBasic = function ClusterDeploymentHostsSelectionBasic(_ref) {
  var isSNOCluster = _ref.isSNOCluster,
      availableAgents = _ref.availableAgents;

  var _useFormikContext = useFormikContext(),
      setFieldValue = _useFormikContext.setFieldValue;

  var _useAgentsAutoSelecti = useAgentsAutoSelection(availableAgents),
      matchingAgents = _useAgentsAutoSelecti.matchingAgents,
      selectedAgents = _useAgentsAutoSelecti.selectedAgents,
      hostCount = _useAgentsAutoSelecti.hostCount;

  React__default.useEffect(function () {
    if (hostCount === 3) {
      setFieldValue('useMastersAsWorkers', true);
    }
  }, [hostCount, setFieldValue]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(NumberInputField, {
    label: "Number of hosts",
    labelIcon: /*#__PURE__*/React__default.createElement(AgentsSelectionHostCountLabelIcon, null),
    idPostfix: "hostcount",
    name: "hostCount",
    isRequired: true,
    minValue: isSNOCluster ? 1 : HOSTS_MIN_COUNT,
    maxValue: isSNOCluster ? 1 : HOSTS_MAX_COUNT,
    isDisabled: isSNOCluster,
    formatValue: function formatValue(newValue) {
      if (newValue === 4) {
        return hostCount >= 4 ? 3 : 5;
      }

      return newValue;
    }
  })), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(CheckboxField, {
    idPostfix: "mastersasworkers",
    name: "useMastersAsWorkers",
    label: "Run workloads on control plane hosts",
    isDisabled: hostCount < 5
  })), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(LocationsSelector, {
    agents: availableAgents
  }))), /*#__PURE__*/React__default.createElement(AgentsSelectionHostCountAlerts, {
    matchingAgentsCount: matchingAgents.length,
    selectedAgents: selectedAgents,
    targetHostCount: hostCount
  }));
};

var LabelsSelector = function LabelsSelector(_ref) {
  var agents = _ref.agents;
  var agentLabelOptions = Array.from(new Set(flatten(agents.map(function (agent) {
    var _agent$metadata;

    return Object.keys(((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : _agent$metadata.labels) || {}).filter(function (k) {
      return ![INFRAENV_AGENTINSTALL_LABEL_KEY, AGENT_LOCATION_LABEL_KEY].includes(k);
    }).map(function (k) {
      var _agent$metadata2, _agent$metadata2$labe;

      return k + "=" + ((_agent$metadata2 = agent.metadata) === null || _agent$metadata2 === void 0 ? void 0 : (_agent$metadata2$labe = _agent$metadata2.labels) === null || _agent$metadata2$labe === void 0 ? void 0 : _agent$metadata2$labe[k]);
    });
  })))).map(function (value) {
    return {
      isLastOptionBeforeFooter: function isLastOptionBeforeFooter(index) {
        return index === value.length;
      },
      id: value,
      value: value,
      displayName: value
    };
  });
  return /*#__PURE__*/React__default.createElement(MultiSelectField, {
    idPostfix: "agentLabels",
    name: "agentLabels",
    label: "Labels matching hosts",
    placeholderText: "app=frontend",
    helperText: "Provide as many labels as you can to narrow the list to relevant hosts only.",
    options: agentLabelOptions
  });
};

var AgentsSelectionTable = function AgentsSelectionTable(_ref) {
  var matchingAgents = _ref.matchingAgents;

  var _useField = useField('selectedHostIds'),
      selectedHostIdsField = _useField[0],
      setSelectedHostIdsValue = _useField[2].setValue;

  React__default.useEffect(function () {
    var allIds = matchingAgents.map(function (a) {
      var _a$metadata;

      return (_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : _a$metadata.uid;
    });
    var presentIds = selectedHostIdsField.value.filter(function (id) {
      return allIds.includes(id);
    });

    if (presentIds.length !== selectedHostIdsField.value.length) {
      setSelectedHostIdsValue(presentIds);
    }
  }, [matchingAgents, setSelectedHostIdsValue, selectedHostIdsField.value]);

  var onSelect = function onSelect(agent, selected) {
    if (selected) {
      var _agent$metadata;

      setSelectedHostIdsValue([].concat(selectedHostIdsField.value, [((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : _agent$metadata.uid) || '']));
    } else {
      setSelectedHostIdsValue(selectedHostIdsField.value.filter(function (uid) {
        var _agent$metadata2;

        return uid !== ((_agent$metadata2 = agent.metadata) === null || _agent$metadata2 === void 0 ? void 0 : _agent$metadata2.uid);
      }));
    }
  };

  var _useAgentsTable = useAgentsTable({
    onSelect: onSelect
  }, {
    agents: matchingAgents
  }),
      hosts = _useAgentsTable[0],
      actions = _useAgentsTable[1],
      actionResolver = _useAgentsTable[2];

  var content = React__default.useMemo(function () {
    return [hostnameColumn(), infraEnvColumn(matchingAgents), cpuCoresColumn, memoryColumn, disksColumn];
  }, [matchingAgents]);
  return /*#__PURE__*/React__default.createElement(HostsTable, _extends({
    hosts: hosts,
    content: content,
    selectedIDs: selectedHostIdsField.value,
    actionResolver: actionResolver,
    className: "agents-table"
  }, actions), /*#__PURE__*/React__default.createElement(EmptyState, {
    title: "No hosts found",
    content: "No host matches provided labels/locations"
  }));
};

var ClusterDeploymentHostsSelectionAdvanced = function ClusterDeploymentHostsSelectionAdvanced(_ref) {
  var availableAgents = _ref.availableAgents;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  var matchingAgents = React__default.useMemo(function () {
    return availableAgents.filter(function (agent) {
      var _agent$metadata, _agent$metadata$label, _agent$metadata2, _agent$metadata3;

      var labels = values.agentLabels.reduce(function (acc, curr) {
        var label = curr.split('=');
        acc[label[0]] = label[1];
        return acc;
      }, {});
      var matchesLocation = values.locations.length ? values.locations.includes(((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : (_agent$metadata$label = _agent$metadata.labels) === null || _agent$metadata$label === void 0 ? void 0 : _agent$metadata$label[AGENT_LOCATION_LABEL_KEY]) || AGENT_NOLOCATION_VALUE) : true;
      var matchesLabels = ((_agent$metadata2 = agent.metadata) === null || _agent$metadata2 === void 0 ? void 0 : _agent$metadata2.labels) ? isMatch((_agent$metadata3 = agent.metadata) === null || _agent$metadata3 === void 0 ? void 0 : _agent$metadata3.labels, labels) : true;
      return matchesLocation && matchesLabels;
    });
  }, [availableAgents, values.locations, values.agentLabels]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(LocationsSelector, {
    agents: availableAgents
  })), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(LabelsSelector, {
    agents: matchingAgents
  }))), /*#__PURE__*/React__default.createElement(AgentsSelectionTable, {
    matchingAgents: matchingAgents
  }));
};

var NoAgentsAlert = function NoAgentsAlert() {
  return /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.warning,
    title: "No available hosts were found",
    isInline: true
  }, "The cluster can not be installed yet because there are no available hosts found. To continue:", /*#__PURE__*/React__default.createElement("br", null), /*#__PURE__*/React__default.createElement(List, {
    component: ListComponent.ol
  }, /*#__PURE__*/React__default.createElement(ListItem$1, null, "Add hosts to an ", /*#__PURE__*/React__default.createElement(Link, {
    to: "/multicloud/infra-environments"
  }, "infrastructure environment")), /*#__PURE__*/React__default.createElement(ListItem$1, null, "Continue configuration by editing this cluster and utilize the newly added hosts")));
};

var ClusterDeploymentHostsSelection = function ClusterDeploymentHostsSelection(_ref) {
  var _clusterDeployment$me, _clusterDeployment$me2;

  var agentClusterInstall = _ref.agentClusterInstall,
      clusterDeployment = _ref.clusterDeployment,
      agents = _ref.agents,
      onValuesChanged = _ref.onValuesChanged,
      aiConfigMap = _ref.aiConfigMap;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  React__default.useEffect(function () {
    return onValuesChanged === null || onValuesChanged === void 0 ? void 0 : onValuesChanged(values);
  }, [values, onValuesChanged]);
  var autoSelectHosts = values.autoSelectHosts;
  var isSNOCluster = getIsSNOCluster(agentClusterInstall);
  var cdName = clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.name;
  var cdNamespace = clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me2 = clusterDeployment.metadata) === null || _clusterDeployment$me2 === void 0 ? void 0 : _clusterDeployment$me2.namespace;
  var availableAgents = React__default.useMemo(function () {
    return getAgentsForSelection(agents).filter(function (agent) {
      var _agent$spec$clusterDe, _agent$spec$clusterDe2, _agent$spec$clusterDe3, _agent$spec$clusterDe4;

      return ((_agent$spec$clusterDe = agent.spec.clusterDeploymentName) === null || _agent$spec$clusterDe === void 0 ? void 0 : _agent$spec$clusterDe.name) === cdName && ((_agent$spec$clusterDe2 = agent.spec.clusterDeploymentName) === null || _agent$spec$clusterDe2 === void 0 ? void 0 : _agent$spec$clusterDe2.namespace) === cdNamespace || !((_agent$spec$clusterDe3 = agent.spec.clusterDeploymentName) === null || _agent$spec$clusterDe3 === void 0 ? void 0 : _agent$spec$clusterDe3.name) && !((_agent$spec$clusterDe4 = agent.spec.clusterDeploymentName) === null || _agent$spec$clusterDe4 === void 0 ? void 0 : _agent$spec$clusterDe4.namespace);
    });
  }, [agents, cdNamespace, cdName]);
  return /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h3"
  }, "Number of hosts"))), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, isSNOCluster ? 'Exactly 1 host is required, capable of functioning both as control plane and worker node.' : 'At least 3 hosts are required, capable of functioning as control plane nodes.')), aiConfigMap && /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(MinimalHWRequirements, {
    aiConfigMap: aiConfigMap,
    isSNOCluster: isSNOCluster
  })), /*#__PURE__*/React__default.createElement(GridItem, null, availableAgents.length ? /*#__PURE__*/React__default.createElement(Form, null, /*#__PURE__*/React__default.createElement(SwitchField, {
    name: "autoSelectHosts",
    label: "Auto-select hosts"
  }), autoSelectHosts && /*#__PURE__*/React__default.createElement(ClusterDeploymentHostsSelectionBasic, {
    availableAgents: availableAgents,
    isSNOCluster: isSNOCluster
  }), !autoSelectHosts && /*#__PURE__*/React__default.createElement(ClusterDeploymentHostsSelectionAdvanced, {
    availableAgents: availableAgents
  })) : /*#__PURE__*/React__default.createElement(NoAgentsAlert, null)));
};

var hostCountValidationSchema = number().min(HOSTS_MIN_COUNT, "A cluster can have " + HOSTS_MIN_COUNT + " hosts at minimum.").max(HOSTS_MAX_COUNT, "Maximum hosts count (" + HOSTS_MAX_COUNT + ") reached.").test('not-four', 'A cluster needs 2 or more worker nodes.', function (value) {
  return value != 4;
}).required();

var getInitialValues = function getInitialValues(_ref) {
  var _clusterDeployment$me, _clusterDeployment$me2, _agentClusterInstall$, _agentClusterInstall$2, _agentClusterInstall$3, _agentClusterInstall$4, _clusterDeployment$me3;

  var agents = _ref.agents,
      clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall;
  var isSNOCluster = getIsSNOCluster(agentClusterInstall);
  var cdName = clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.name;
  var cdNamespace = clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me2 = clusterDeployment.metadata) === null || _clusterDeployment$me2 === void 0 ? void 0 : _clusterDeployment$me2.namespace;
  var hostCount = ((agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.spec) === null || _agentClusterInstall$ === void 0 ? void 0 : (_agentClusterInstall$2 = _agentClusterInstall$.provisionRequirements) === null || _agentClusterInstall$2 === void 0 ? void 0 : _agentClusterInstall$2.controlPlaneAgents) || 0) + ((agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$3 = agentClusterInstall.spec) === null || _agentClusterInstall$3 === void 0 ? void 0 : (_agentClusterInstall$4 = _agentClusterInstall$3.provisionRequirements) === null || _agentClusterInstall$4 === void 0 ? void 0 : _agentClusterInstall$4.workerAgents) || 0);

  if (isSNOCluster) {
    hostCount = 1;
  } else if (hostCount === 2 || hostCount === 0) {
    hostCount = 3;
  } else if (hostCount === 4) {
    hostCount = 5;
  }

  var agentSelector = getAgentSelectorFieldsFromAnnotations(clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me3 = clusterDeployment.metadata) === null || _clusterDeployment$me3 === void 0 ? void 0 : _clusterDeployment$me3.annotations);
  var selectedIds = agents.filter(function (agent) {
    var _agent$spec, _agent$spec$clusterDe, _agent$spec2, _agent$spec2$clusterD;

    return ((_agent$spec = agent.spec) === null || _agent$spec === void 0 ? void 0 : (_agent$spec$clusterDe = _agent$spec.clusterDeploymentName) === null || _agent$spec$clusterDe === void 0 ? void 0 : _agent$spec$clusterDe.name) === cdName && ((_agent$spec2 = agent.spec) === null || _agent$spec2 === void 0 ? void 0 : (_agent$spec2$clusterD = _agent$spec2.clusterDeploymentName) === null || _agent$spec2$clusterD === void 0 ? void 0 : _agent$spec2$clusterD.namespace) === cdNamespace;
  }).map(function (agent) {
    var _agent$metadata;

    return (_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : _agent$metadata.uid;
  });
  var autoSelectHosts = agentSelector.autoSelect;
  return {
    autoSelectHosts: autoSelectHosts,
    hostCount: hostCount,
    useMastersAsWorkers: hostCount === 1 || hostCount === 3,
    agentLabels: (agentSelector === null || agentSelector === void 0 ? void 0 : agentSelector.labels) || [],
    locations: (agentSelector === null || agentSelector === void 0 ? void 0 : agentSelector.locations) || [],
    selectedHostIds: autoSelectHosts ? [] : selectedIds,
    autoSelectedHostIds: autoSelectHosts ? selectedIds : []
  };
};

var getValidationSchema = function getValidationSchema(agentClusterInstall) {
  var isSNOCluster = getIsSNOCluster(agentClusterInstall);
  return lazy(function (values) {
    return object().shape({
      hostCount: isSNOCluster ? number() : hostCountValidationSchema,
      useMastersAsWorkers: boolean().required(),
      autoSelectedHostIds: values.autoSelectHosts ? array().min(values.hostCount).max(values.hostCount) : array(),
      selectedHostIds: values.autoSelectHosts ? array() : isSNOCluster ? array().min(1).max(1) : array().min(values.selectedHostIds.length === 4 ? 5 : 3)
    });
  });
};

var useHostsSelectionFormik = function useHostsSelectionFormik(_ref2) {
  var agents = _ref2.agents,
      clusterDeployment = _ref2.clusterDeployment,
      agentClusterInstall = _ref2.agentClusterInstall;
  var initialValues = React__default.useMemo(function () {
    return getInitialValues({
      agents: agents,
      clusterDeployment: clusterDeployment,
      agentClusterInstall: agentClusterInstall
    });
  }, []);
  var validationSchema = React__default.useMemo(function () {
    return getValidationSchema(agentClusterInstall);
  }, [agentClusterInstall]);
  return [initialValues, validationSchema];
};

var ClusterDeploymentHostSelectionStep = function ClusterDeploymentHostSelectionStep(_ref3) {
  var clusterDeployment = _ref3.clusterDeployment,
      agentClusterInstall = _ref3.agentClusterInstall,
      agents = _ref3.agents,
      onClose = _ref3.onClose,
      onSaveHostsSelection = _ref3.onSaveHostsSelection,
      aiConfigMap = _ref3.aiConfigMap;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _React$useContext = React__default.useContext(ClusterDeploymentWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var _useHostsSelectionFor = useHostsSelectionFormik({
    agents: agents,
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall
  }),
      initialValues = _useHostsSelectionFor[0],
      validationSchema = _useHostsSelectionFor[1];

  var next = function next() {
    return setCurrentStepId('networking');
  };

  var handleSubmit = function handleSubmit(values) {
    try {
      var _temp2 = _catch(function () {
        return Promise.resolve(onSaveHostsSelection(values)).then(function () {
          next();
        });
      }, function (error) {
        addAlert({
          title: 'Failed to save host selection.',
          message: error.message
        });
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    onSubmit: handleSubmit
  }, function (_ref4) {
    var submitForm = _ref4.submitForm,
        isSubmitting = _ref4.isSubmitting,
        isValid = _ref4.isValid,
        isValidating = _ref4.isValidating,
        dirty = _ref4.dirty,
        errors = _ref4.errors,
        touched = _ref4.touched;

    var handleOnNext = function handleOnNext() {
      if (dirty) {
        submitForm();
      } else {
        next();
      }
    };

    var footer = /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardFooter, {
      errorFields: getFormikErrorFields(errors, touched),
      isSubmitting: isSubmitting,
      isNextDisabled: !isValid || isValidating || isSubmitting,
      onNext: handleOnNext,
      onBack: function onBack() {
        return setCurrentStepId('cluster-details');
      },
      onCancel: onClose
    });
    var navigation = /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardNavigation, null);
    return /*#__PURE__*/React__default.createElement(ClusterDeploymentWizardStep, {
      navigation: navigation,
      footer: footer
    }, /*#__PURE__*/React__default.createElement(Grid, {
      hasGutter: true
    }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, null, "Cluster hosts")), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterDeploymentHostsSelection, {
      agentClusterInstall: agentClusterInstall,
      agents: agents,
      clusterDeployment: clusterDeployment,
      aiConfigMap: aiConfigMap
    }))));
  });
};

var ClusterDeploymentWizard = function ClusterDeploymentWizard(_ref) {
  var className = _ref.className,
      onSaveDetails = _ref.onSaveDetails,
      onSaveNetworking = _ref.onSaveNetworking,
      onSaveHostsSelection = _ref.onSaveHostsSelection,
      onClose = _ref.onClose,
      hostActions = _ref.hostActions,
      clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      clusterImages = _ref.clusterImages,
      usedClusterNames = _ref.usedClusterNames,
      onFinish = _ref.onFinish,
      aiConfigMap = _ref.aiConfigMap;

  var _React$useState = useState('cluster-details'),
      currentStepId = _React$useState[0],
      setCurrentStepId = _React$useState[1];

  var renderCurrentStep = useCallback(function () {
    var _agentClusterInstall$;

    var stepId = !clusterDeployment ? 'cluster-details' : currentStepId;

    switch (stepId) {
      case 'hosts-selection':
        return (agentClusterInstall === null || agentClusterInstall === void 0 ? void 0 : (_agentClusterInstall$ = agentClusterInstall.metadata) === null || _agentClusterInstall$ === void 0 ? void 0 : _agentClusterInstall$.name) ? /*#__PURE__*/createElement(ClusterDeploymentHostSelectionStep, {
          clusterDeployment: clusterDeployment,
          agentClusterInstall: agentClusterInstall,
          onClose: onClose,
          onSaveHostsSelection: onSaveHostsSelection,
          agents: agents,
          aiConfigMap: aiConfigMap
        }) : /*#__PURE__*/createElement(LoadingState, null);

      case 'networking':
        return /*#__PURE__*/createElement(ClusterDeploymentNetworkingStep, {
          clusterDeployment: clusterDeployment,
          agentClusterInstall: agentClusterInstall,
          agents: agents,
          onSaveNetworking: onSaveNetworking,
          onClose: onClose,
          hostActions: hostActions,
          onFinish: onFinish
        });

      case 'cluster-details':
      default:
        return /*#__PURE__*/createElement(ClusterDeploymentDetailsStep, {
          clusterImages: clusterImages,
          usedClusterNames: usedClusterNames,
          clusterDeployment: clusterDeployment,
          agentClusterInstall: agentClusterInstall,
          agents: agents,
          onSaveDetails: onSaveDetails,
          onClose: onClose
        });
    }
  }, [currentStepId, clusterDeployment, agentClusterInstall, agents, clusterImages, usedClusterNames, onSaveDetails, onSaveNetworking, onSaveHostsSelection, onClose, hostActions, onFinish, aiConfigMap]);
  return /*#__PURE__*/createElement(AlertsContextProvider, null, /*#__PURE__*/createElement(ClusterDeploymentWizardContext.Provider, {
    value: {
      currentStepId: currentStepId,
      setCurrentStepId: setCurrentStepId
    }
  }, /*#__PURE__*/createElement("div", {
    className: classNames('pf-c-wizard', className)
  }, renderCurrentStep())));
};

var getID = function getID(suffix) {
  return "cluster-install-error-" + suffix;
};

var ClusterInstallationError = function ClusterInstallationError(_ref) {
  var _clusterDeployment$st;

  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall;
  var openshiftVersion = ((_clusterDeployment$st = clusterDeployment.status) === null || _clusterDeployment$st === void 0 ? void 0 : _clusterDeployment$st.installVersion) || '4.8';

  var _getClusterStatus = getClusterStatus(agentClusterInstall),
      clusterStatus = _getClusterStatus[0],
      statusInfo = _getClusterStatus[1];

  var title = clusterStatus === 'cancelled' ? 'Cluster installation was cancelled' : 'Cluster installation failed';
  return /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.danger,
    title: title,
    actionLinks: /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(LogsDownloadButton, {
      id: getID('button-download-installation-logs'),
      Component: AlertActionLink,
      agentClusterInstall: agentClusterInstall
    }), /*#__PURE__*/React__default.createElement(AlertActionLink, {
      onClick: function onClick() {
        return window.open(getBugzillaLink(openshiftVersion), '_blank');
      },
      id: getID('button-report-bug')
    }, "Report a bug")),
    isInline: true
  }, toSentence(statusInfo)));
};

var ACMClusterDeploymentDetailsStep = function ACMClusterDeploymentDetailsStep(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      clusterImages = _ref.clusterImages,
      formRef = _ref.formRef,
      onValuesChanged = _ref.onValuesChanged,
      usedClusterNames = _ref.usedClusterNames,
      agents = _ref.agents,
      defaultBaseDomain = _ref.defaultBaseDomain,
      pullSecret = _ref.pullSecret,
      extensionAfter = _ref.extensionAfter;

  var _useDetailsFormik = useDetailsFormik({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    clusterImages: clusterImages,
    usedClusterNames: usedClusterNames,
    agents: agents,
    defaultBaseDomain: defaultBaseDomain,
    pullSecret: pullSecret
  }),
      initialValues = _useDetailsFormik[0],
      validationSchema = _useDetailsFormik[1];

  return /*#__PURE__*/createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    innerRef: formRef,
    onSubmit: noop
  }, /*#__PURE__*/createElement(ClusterDeploymentDetailsForm, {
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    onValuesChanged: onValuesChanged,
    clusterImages: clusterImages,
    pullSecret: pullSecret,
    extensionAfter: extensionAfter
  }));
};

var ACMClusterDeploymentNetworkingStep = function ACMClusterDeploymentNetworkingStep(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      agents = _ref.agents,
      formRef = _ref.formRef,
      onValuesChanged = _ref.onValuesChanged,
      rest = _objectWithoutPropertiesLoose(_ref, ["clusterDeployment", "agentClusterInstall", "agents", "formRef", "onValuesChanged"]);

  var _useNetworkingFormik = useNetworkingFormik({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents
  }),
      initialValues = _useNetworkingFormik[0],
      validationSchema = _useNetworkingFormik[1];

  return /*#__PURE__*/createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    innerRef: formRef,
    onSubmit: noop
  }, /*#__PURE__*/createElement(ClusterDeploymentNetworkingForm, _extends({
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    agents: agents,
    onValuesChanged: onValuesChanged
  }, rest)));
};

var ACMClusterDeploymentHostsStep = function ACMClusterDeploymentHostsStep(_ref) {
  var clusterDeployment = _ref.clusterDeployment,
      agentClusterInstall = _ref.agentClusterInstall,
      formRef = _ref.formRef,
      onValuesChanged = _ref.onValuesChanged,
      agents = _ref.agents,
      error = _ref.error,
      aiConfigMap = _ref.aiConfigMap;

  var _useHostsSelectionFor = useHostsSelectionFormik({
    agents: agents,
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall
  }),
      initialValues = _useHostsSelectionFor[0],
      validationSchema = _useHostsSelectionFor[1];

  return /*#__PURE__*/createElement(Stack, {
    hasGutter: true
  }, /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    innerRef: formRef,
    onSubmit: noop
  }, /*#__PURE__*/createElement(ClusterDeploymentHostsSelection, {
    agents: agents,
    clusterDeployment: clusterDeployment,
    agentClusterInstall: agentClusterInstall,
    onValuesChanged: onValuesChanged,
    aiConfigMap: aiConfigMap
  }))), error && /*#__PURE__*/createElement(StackItem, null, /*#__PURE__*/createElement(Alert, {
    variant: "danger",
    title: "Failed host selection"
  }, error)));
};

var GreenCheckCircleIcon = function GreenCheckCircleIcon(props) {
  return /*#__PURE__*/createElement(CheckCircleIcon, _extends({}, props, {
    color: global_palette_green_500.value
  }));
};

var ClusterDeploymentCreateProgress = function ClusterDeploymentCreateProgress(_ref) {
  var agentClusterInstall = _ref.agentClusterInstall,
      toDetails = _ref.toDetails,
      toListView = _ref.toListView;
  return /*#__PURE__*/createElement(Bullseye, null, /*#__PURE__*/createElement(EmptyState$1, null, isInstallationReady(agentClusterInstall) ? /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(EmptyStateIcon, {
    icon: GreenCheckCircleIcon
  }), /*#__PURE__*/createElement(Title, {
    headingLevel: "h4",
    size: "lg"
  }, "Cluster is ready for installation"), /*#__PURE__*/createElement(EmptyStateBody, null, /*#__PURE__*/createElement("div", null, "This cluster has been created and is ready to begin installation."), /*#__PURE__*/createElement("div", null, "To see the status of the installation see the details page."))) : /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(EmptyStateIcon, {
    icon: Spinner
  }), /*#__PURE__*/createElement(Title, {
    headingLevel: "h4",
    size: "lg"
  }, "Preparing cluster installation"), /*#__PURE__*/createElement(EmptyStateBody, null, /*#__PURE__*/createElement("div", null, "This cluster is in the process of getting ready to start installation."), /*#__PURE__*/createElement("div", null, "If you exit this flow you can see its status in the list view or details page."))), /*#__PURE__*/createElement(EmptyStateSecondaryActions, null, /*#__PURE__*/createElement(Button, {
    variant: "primary",
    onClick: toDetails
  }, "See cluster details"), /*#__PURE__*/createElement(Button, {
    variant: "link",
    onClick: toListView
  }, "Go to cluster list"))));
};

var EditAgentModal = function EditAgentModal(_ref) {
  var _agent$status;

  var agent = _ref.agent,
      _onSave = _ref.onSave,
      rest = _objectWithoutPropertiesLoose(_ref, ["agent", "onSave"]);

  var _ref2 = agent ? getAIHosts([agent]) : [],
      host = _ref2[0];

  return /*#__PURE__*/createElement(EditHostModal, _extends({
    host: host,
    inventory: agent === null || agent === void 0 ? void 0 : (_agent$status = agent.status) === null || _agent$status === void 0 ? void 0 : _agent$status.inventory
  }, rest, {
    onSave: function onSave(_ref3) {
      var hostname = _ref3.hostname;

      try {
        return Promise.resolve(agent && _onSave(agent, hostname));
      } catch (e) {
        return Promise.reject(e);
      }
    }
  }));
};

var MacMapping = function MacMapping() {
  var _useField = useField({
    name: 'macMapping'
  }),
      field = _useField[0],
      _useField$ = _useField[1],
      touched = _useField$.touched,
      error = _useField$.error;

  var fieldId = getFieldId('macMapping', 'input');
  var isValid = !(touched && error);
  return /*#__PURE__*/createElement(FormGroup, {
    fieldId: fieldId,
    label: "Mac to interface name mapping",
    validated: isValid ? 'default' : 'error',
    isRequired: true
  }, /*#__PURE__*/createElement(FieldArray, {
    name: "macMapping",
    render: function render(_ref) {
      var push = _ref.push,
          remove = _ref.remove;
      return /*#__PURE__*/createElement(Grid, {
        hasGutter: true
      }, /*#__PURE__*/createElement(GridItem, {
        span: 5
      }, /*#__PURE__*/createElement(Text, {
        component: TextVariants.small
      }, "MAC address")), /*#__PURE__*/createElement(GridItem, {
        span: 5
      }, /*#__PURE__*/createElement(Text, {
        component: TextVariants.small
      }, "NIC")), field.value.map(function (mac, index) {
        var _error$index, _error$index2;

        return /*#__PURE__*/createElement(Fragment$1, {
          key: index
        }, /*#__PURE__*/createElement(GridItem, {
          span: 5
        }, /*#__PURE__*/createElement(InputField, {
          name: "macMapping[" + index + "].macAddress",
          inputError: error === null || error === void 0 ? void 0 : (_error$index = error[index]) === null || _error$index === void 0 ? void 0 : _error$index.macAddress
        })), /*#__PURE__*/createElement(GridItem, {
          span: 5
        }, /*#__PURE__*/createElement(InputField, {
          name: "macMapping[" + index + "].name",
          inputError: error === null || error === void 0 ? void 0 : (_error$index2 = error[index]) === null || _error$index2 === void 0 ? void 0 : _error$index2.name
        })), index !== 0 && /*#__PURE__*/createElement(GridItem, {
          span: 2
        }, /*#__PURE__*/createElement(MinusCircleIcon, {
          onClick: function onClick() {
            return remove(index);
          }
        })));
      }), /*#__PURE__*/createElement(GridItem, {
        span: 6
      }, /*#__PURE__*/createElement(Button, {
        icon: /*#__PURE__*/createElement(PlusCircleIcon, null),
        onClick: function onClick() {
          return push({
            macAddress: '',
            name: ''
          });
        },
        variant: "link",
        isInline: true
      }, "Add more")));
    }
  }));
};

var getNMState = function getNMState(values, infraEnv) {
  var _infraEnv$metadata, _infraEnv$metadata2, _labels;

  var config = load(values.nmState);
  var nmState = {
    apiVersion: 'agent-install.openshift.io/v1beta1',
    kind: 'NMStateConfig',
    metadata: {
      generateName: ((_infraEnv$metadata = infraEnv.metadata) === null || _infraEnv$metadata === void 0 ? void 0 : _infraEnv$metadata.name) + "-",
      namespace: (_infraEnv$metadata2 = infraEnv.metadata) === null || _infraEnv$metadata2 === void 0 ? void 0 : _infraEnv$metadata2.namespace,
      labels: (_labels = {}, _labels[AGENT_BMH_HOSTNAME_LABEL_KEY] = values.hostname, _labels)
    },
    spec: {
      config: config,
      interfaces: values.macMapping.filter(function (m) {
        return m.macAddress.length && m.name.length;
      })
    }
  };
  return nmState;
};

var getValidationSchema$1 = function getValidationSchema(hasDHCP) {
  return object({
    hostname: hostnameValidationSchema.required(),
    bmcAddress: string().required(),
    username: string().required(),
    password: string().required(),
    bootMACAddress: macAddressValidationSchema,
    nmState: hasDHCP ? string() : string().required(),
    macMapping: hasDHCP ? array() : array().of(object().shape({
      macAddress: macAddressValidationSchema.required('MAC Address is a required field'),
      name: string().required('NIC is a required field')
    }))
  });
};

var emptyValues = {
  hostname: '',
  bmcAddress: '',
  username: '',
  password: '',
  bootMACAddress: '',
  disableCertificateVerification: true,
  online: false,
  nmState: '',
  macMapping: [{
    macAddress: '',
    name: ''
  }]
};

var getInitValues = function getInitValues(bmh, nmState, secret, isEdit) {
  if (isEdit) {
    var _bmh$metadata, _bmh$spec, _bmh$spec$bmc, _secret$data, _secret$data2, _bmh$spec2, _bmh$spec3, _bmh$spec3$bmc, _bmh$spec4, _nmState$spec, _nmState$spec2;

    return {
      hostname: (bmh === null || bmh === void 0 ? void 0 : (_bmh$metadata = bmh.metadata) === null || _bmh$metadata === void 0 ? void 0 : _bmh$metadata.name) || '',
      bmcAddress: (bmh === null || bmh === void 0 ? void 0 : (_bmh$spec = bmh.spec) === null || _bmh$spec === void 0 ? void 0 : (_bmh$spec$bmc = _bmh$spec.bmc) === null || _bmh$spec$bmc === void 0 ? void 0 : _bmh$spec$bmc.address) || '',
      username: (secret === null || secret === void 0 ? void 0 : (_secret$data = secret.data) === null || _secret$data === void 0 ? void 0 : _secret$data.username) ? atob(secret.data.username) : '',
      password: (secret === null || secret === void 0 ? void 0 : (_secret$data2 = secret.data) === null || _secret$data2 === void 0 ? void 0 : _secret$data2.password) ? atob(secret.data.password) : '',
      bootMACAddress: (bmh === null || bmh === void 0 ? void 0 : (_bmh$spec2 = bmh.spec) === null || _bmh$spec2 === void 0 ? void 0 : _bmh$spec2.bootMACAddress) || '',
      disableCertificateVerification: !!(bmh === null || bmh === void 0 ? void 0 : (_bmh$spec3 = bmh.spec) === null || _bmh$spec3 === void 0 ? void 0 : (_bmh$spec3$bmc = _bmh$spec3.bmc) === null || _bmh$spec3$bmc === void 0 ? void 0 : _bmh$spec3$bmc.disableCertificateVerification),
      online: !!(bmh === null || bmh === void 0 ? void 0 : (_bmh$spec4 = bmh.spec) === null || _bmh$spec4 === void 0 ? void 0 : _bmh$spec4.online),
      nmState: nmState ? dump(nmState === null || nmState === void 0 ? void 0 : (_nmState$spec = nmState.spec) === null || _nmState$spec === void 0 ? void 0 : _nmState$spec.config) : '',
      macMapping: (nmState === null || nmState === void 0 ? void 0 : (_nmState$spec2 = nmState.spec) === null || _nmState$spec2 === void 0 ? void 0 : _nmState$spec2.interfaces) || [{
        macAddress: '',
        name: ''
      }]
    };
  } else {
    return emptyValues;
  }
};

var BMCForm = function BMCForm(_ref2) {
  var onCreate = _ref2.onCreate,
      onClose = _ref2.onClose,
      hasDHCP = _ref2.hasDHCP,
      infraEnv = _ref2.infraEnv,
      bmh = _ref2.bmh,
      nmState = _ref2.nmState,
      secret = _ref2.secret,
      isEdit = _ref2.isEdit;

  var _React$useState = useState(),
      error = _React$useState[0],
      setError = _React$useState[1];

  var handleSubmit = function handleSubmit(values) {
    try {
      var _temp2 = _catch(function () {
        setError(undefined);
        var nmState = hasDHCP ? undefined : getNMState(values, infraEnv);
        return Promise.resolve(onCreate(values, nmState)).then(function () {
          onClose();
        });
      }, function (e) {
        setError(e.message);
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var validationSchema = useMemo(function () {
    return getValidationSchema$1(hasDHCP);
  }, [hasDHCP]);
  return /*#__PURE__*/createElement(Formik, {
    initialValues: getInitValues(bmh, nmState, secret, isEdit),
    isInitialValid: false,
    validationSchema: validationSchema,
    onSubmit: handleSubmit
  }, function (_ref3) {
    var isSubmitting = _ref3.isSubmitting,
        isValid = _ref3.isValid,
        submitForm = _ref3.submitForm;
    return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(ModalBoxBody, null, /*#__PURE__*/createElement(Form, {
      id: "add-bmc-form"
    }, /*#__PURE__*/createElement(InputField, {
      label: "Host name",
      name: "hostname",
      placeholder: "Enter the name for the Host",
      isRequired: true,
      isDisabled: isEdit
    }), /*#__PURE__*/createElement(InputField, {
      label: "Baseboard Management Controller Address",
      name: "bmcAddress",
      placeholder: "Enter an address",
      isRequired: true
    }), /*#__PURE__*/createElement(InputField, {
      label: "Boot NIC MAC Address",
      name: "bootMACAddress",
      placeholder: "Enter an address",
      description: "The MAC address of the host's network connected NIC that wll be used to provision the host."
    }), /*#__PURE__*/createElement(InputField, {
      label: "Username",
      name: "username",
      placeholder: "Enter a username for the BMC",
      isRequired: true
    }), /*#__PURE__*/createElement(InputField, {
      type: TextInputTypes.password,
      label: "Password",
      name: "password",
      placeholder: "Enter a password for the BMC",
      isRequired: true
    }), !hasDHCP && /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(CodeField, {
      label: "NMState",
      name: "nmState",
      language: Language.yaml,
      isRequired: true,
      description: "Upload a YAML file in NMstate format that includes your network configuration (static IPs, bonds, etc.)."
    }), /*#__PURE__*/createElement(MacMapping, null))), error && /*#__PURE__*/createElement(Alert, {
      title: "Failed to add host",
      variant: AlertVariant.danger,
      isInline: true,
      actionClose: /*#__PURE__*/createElement(AlertActionCloseButton, {
        onClose: function onClose() {
          return setError(undefined);
        }
      })
    }, error)), /*#__PURE__*/createElement(ModalBoxFooter, null, /*#__PURE__*/createElement(Button, {
      onClick: submitForm,
      isDisabled: isSubmitting || !isValid
    }, isEdit ? 'Submit' : 'Create'), /*#__PURE__*/createElement(Button, {
      onClick: onClose,
      variant: ButtonVariant.secondary
    }, "Cancel")));
  });
};

var BmOnBmOnlyPopoverIcon = function BmOnBmOnlyPopoverIcon() {
  return /*#__PURE__*/createElement(PopoverIcon, {
    noVerticalAlign: true,
    bodyContent: /*#__PURE__*/createElement(Fragment, null, "The Advanced Cluster Manager can manage bare metal hosts when deployed on bare metal platform only.")
  });
};

var AddHostModal = function AddHostModal(_ref) {
  var _infraEnv$metadata, _infraEnv$metadata$la, _infraEnv$status;

  var isOpen = _ref.isOpen,
      onClose = _ref.onClose,
      infraEnv = _ref.infraEnv,
      onCreate = _ref.onCreate,
      isBMPlatform = _ref.isBMPlatform;
  var hasDHCP = ((_infraEnv$metadata = infraEnv.metadata) === null || _infraEnv$metadata === void 0 ? void 0 : (_infraEnv$metadata$la = _infraEnv$metadata.labels) === null || _infraEnv$metadata$la === void 0 ? void 0 : _infraEnv$metadata$la.networkType) !== 'static';

  var _React$useState = useState(hasDHCP),
      isDiscoveryISO = _React$useState[0],
      setDiscoveryISO = _React$useState[1];

  return /*#__PURE__*/createElement(Modal, {
    "aria-label": "Add host dialog",
    title: "Add Host",
    isOpen: isOpen,
    onClose: onClose,
    variant: ModalVariant.small,
    hasNoBodyWrapper: true,
    id: "add-host-modal"
  }, hasDHCP && /*#__PURE__*/createElement(ModalBoxBody, null, /*#__PURE__*/createElement(Flex, {
    justifyContent: {
      "default": 'justifyContentSpaceBetween'
    }
  }, /*#__PURE__*/createElement(FlexItem, null, /*#__PURE__*/createElement(Radio, {
    id: "iso",
    name: "type",
    label: "Discovery ISO",
    isChecked: isDiscoveryISO,
    onChange: setDiscoveryISO
  })), /*#__PURE__*/createElement(FlexItem, {
    spacer: {
      "default": isBMPlatform ? 'spacerXl' : 'spacerSm'
    }
  }), /*#__PURE__*/createElement(FlexItem, null, /*#__PURE__*/createElement(Radio, {
    id: "bmc",
    name: "type",
    label: "Baseboard Management Controller (BMC)",
    isChecked: !isDiscoveryISO,
    onChange: function onChange(checked) {
      return setDiscoveryISO(!checked);
    },
    isDisabled: !isBMPlatform
  })), !isBMPlatform && /*#__PURE__*/createElement(FlexItem, null, /*#__PURE__*/createElement(BmOnBmOnlyPopoverIcon, null)))), isDiscoveryISO ? /*#__PURE__*/createElement(DownloadIso, {
    onClose: onClose,
    downloadUrl: infraEnv === null || infraEnv === void 0 ? void 0 : (_infraEnv$status = infraEnv.status) === null || _infraEnv$status === void 0 ? void 0 : _infraEnv$status.isoDownloadURL
  }) : /*#__PURE__*/createElement(BMCForm, {
    onCreate: onCreate,
    onClose: onClose,
    hasDHCP: hasDHCP,
    infraEnv: infraEnv
  }));
};

var EditBMHModal = function EditBMHModal(_ref) {
  var _infraEnv$metadata, _infraEnv$metadata$la, _bmh$metadata, _bmh$metadata2, _bmh$spec, _bmh$spec$bmc;

  var isOpen = _ref.isOpen,
      onClose = _ref.onClose,
      onEdit = _ref.onEdit,
      infraEnv = _ref.infraEnv,
      bmh = _ref.bmh,
      fetchNMState = _ref.fetchNMState,
      fetchSecret = _ref.fetchSecret;

  var _React$useState = useState(),
      nmState = _React$useState[0],
      setNMState = _React$useState[1];

  var _React$useState2 = useState(),
      secret = _React$useState2[0],
      setSecret = _React$useState2[1];

  var _React$useState3 = useState(true),
      isLoading = _React$useState3[0],
      setLoading = _React$useState3[1];

  var hasDHCP = ((_infraEnv$metadata = infraEnv.metadata) === null || _infraEnv$metadata === void 0 ? void 0 : (_infraEnv$metadata$la = _infraEnv$metadata.labels) === null || _infraEnv$metadata$la === void 0 ? void 0 : _infraEnv$metadata$la.networkType) !== 'static';
  var bmhName = bmh === null || bmh === void 0 ? void 0 : (_bmh$metadata = bmh.metadata) === null || _bmh$metadata === void 0 ? void 0 : _bmh$metadata.name;
  var bmhNamespace = bmh === null || bmh === void 0 ? void 0 : (_bmh$metadata2 = bmh.metadata) === null || _bmh$metadata2 === void 0 ? void 0 : _bmh$metadata2.namespace;
  var bmhSecret = bmh === null || bmh === void 0 ? void 0 : (_bmh$spec = bmh.spec) === null || _bmh$spec === void 0 ? void 0 : (_bmh$spec$bmc = _bmh$spec.bmc) === null || _bmh$spec$bmc === void 0 ? void 0 : _bmh$spec$bmc.credentialsName;
  useEffect(function () {
    setNMState(undefined);
    setSecret(undefined);

    var getResources = function getResources() {
      try {
        var _temp7 = function _temp7() {
          function _temp4() {
            setLoading(false);
          }

          var _temp3 = function () {
            if (bmhSecret && bmhNamespace) {
              var _temp9 = _catch(function () {
                return Promise.resolve(fetchSecret(bmhNamespace, bmhSecret)).then(function (secretResult) {
                  setSecret(secretResult);
                });
              }, function (err) {
                console.error('Could not get secret', err);
              });

              if (_temp9 && _temp9.then) return _temp9.then(function () {});
            }
          }();

          return _temp3 && _temp3.then ? _temp3.then(_temp4) : _temp4(_temp3);
        };

        var _temp8 = function () {
          if (bmhName && bmhNamespace && !hasDHCP) {
            var _temp10 = _catch(function () {
              return Promise.resolve(fetchNMState(bmhNamespace, bmhName)).then(function (nmStateResult) {
                setNMState(nmStateResult);
              });
            }, function (err) {
              console.error('Could not get nm state', err);
            });

            if (_temp10 && _temp10.then) return _temp10.then(function () {});
          }
        }();

        return Promise.resolve(_temp8 && _temp8.then ? _temp8.then(_temp7) : _temp7(_temp8));
      } catch (e) {
        return Promise.reject(e);
      }
    };

    if (bmhNamespace && bmhName) {
      setLoading(true);
      getResources();
    }
  }, [bmhName, bmhNamespace, fetchNMState, fetchSecret, bmhSecret, hasDHCP]);
  return /*#__PURE__*/createElement(Modal, {
    "aria-label": "Edit BMH dialog",
    title: "Edit BMH",
    isOpen: isOpen,
    onClose: onClose,
    variant: ModalVariant.small,
    hasNoBodyWrapper: true,
    id: "edit-bmh-modal"
  }, isLoading ? /*#__PURE__*/createElement(LoadingState, null) : /*#__PURE__*/createElement(BMCForm, {
    isEdit: true,
    onCreate: onEdit({
      bmh: bmh,
      secret: secret,
      nmState: nmState
    }),
    onClose: onClose,
    hasDHCP: hasDHCP,
    infraEnv: infraEnv,
    bmh: bmh,
    secret: secret,
    nmState: nmState
  }));
};

var ClusterScaleUpAutoHostsSelection = function ClusterScaleUpAutoHostsSelection(_ref) {
  var availableAgents = _ref.availableAgents;

  var _useAgentsAutoSelecti = useAgentsAutoSelection(availableAgents),
      matchingAgents = _useAgentsAutoSelecti.matchingAgents,
      selectedAgents = _useAgentsAutoSelecti.selectedAgents,
      hostCount = _useAgentsAutoSelecti.hostCount;

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, {
    span: 12,
    lg: 10,
    xl: 9,
    xl2: 7
  }, /*#__PURE__*/React__default.createElement(NumberInputField, {
    label: "Number of hosts",
    labelIcon: /*#__PURE__*/React__default.createElement(AgentsSelectionHostCountLabelIcon, null),
    idPostfix: "hostcount",
    name: "hostCount",
    minValue: 1,
    maxValue: matchingAgents.length,
    isRequired: true
  })), /*#__PURE__*/React__default.createElement(GridItem, {
    span: 12,
    lg: 10,
    xl: 9,
    xl2: 7
  }, /*#__PURE__*/React__default.createElement(LocationsSelector, {
    agents: availableAgents
  }))), /*#__PURE__*/React__default.createElement(AgentsSelectionHostCountAlerts, {
    matchingAgentsCount: matchingAgents.length,
    selectedAgents: selectedAgents,
    targetHostCount: hostCount
  }));
};

var ScaleUpForm = function ScaleUpForm(_ref) {
  var agents = _ref.agents;

  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  var autoSelectHosts = values.autoSelectHosts;
  var availableAgents = React__default.useMemo(function () {
    return getAgentsForSelection(agents).filter(function (agent) {
      var _agent$spec, _agent$spec$clusterDe, _agent$spec2, _agent$spec2$clusterD;

      return !(((_agent$spec = agent.spec) === null || _agent$spec === void 0 ? void 0 : (_agent$spec$clusterDe = _agent$spec.clusterDeploymentName) === null || _agent$spec$clusterDe === void 0 ? void 0 : _agent$spec$clusterDe.name) || ((_agent$spec2 = agent.spec) === null || _agent$spec2 === void 0 ? void 0 : (_agent$spec2$clusterD = _agent$spec2.clusterDeploymentName) === null || _agent$spec2$clusterD === void 0 ? void 0 : _agent$spec2$clusterD.namespace));
    });
  }, [agents]);
  return /*#__PURE__*/React__default.createElement(Form, null, /*#__PURE__*/React__default.createElement(SwitchField, {
    name: "autoSelectHosts",
    label: "Auto-select hosts"
  }), autoSelectHosts && /*#__PURE__*/React__default.createElement(ClusterScaleUpAutoHostsSelection, {
    availableAgents: availableAgents
  }), !autoSelectHosts && /*#__PURE__*/React__default.createElement(ClusterDeploymentHostsSelectionAdvanced, {
    availableAgents: availableAgents
  }));
};

var getAgentsToAdd = function getAgentsToAdd(selectedHostIds, agents) {
  return agents.filter(function (agent) {
    var _agent$metadata, _agent$spec, _agent$spec$clusterDe, _agent$spec2, _agent$spec2$clusterD;

    return selectedHostIds.includes(((_agent$metadata = agent.metadata) === null || _agent$metadata === void 0 ? void 0 : _agent$metadata.uid) || '') && !(((_agent$spec = agent.spec) === null || _agent$spec === void 0 ? void 0 : (_agent$spec$clusterDe = _agent$spec.clusterDeploymentName) === null || _agent$spec$clusterDe === void 0 ? void 0 : _agent$spec$clusterDe.name) || ((_agent$spec2 = agent.spec) === null || _agent$spec2 === void 0 ? void 0 : (_agent$spec2$clusterD = _agent$spec2.clusterDeploymentName) === null || _agent$spec2$clusterD === void 0 ? void 0 : _agent$spec2$clusterD.namespace));
  });
};

var getValidationSchema$2 = function getValidationSchema(agentsCount) {
  return lazy(function (values) {
    return object().shape({
      hostCount: number().min(1).max(agentsCount),
      autoSelectedHostIds: values.autoSelectHosts ? array().min(1).max(agentsCount) : array(),
      selectedHostIds: values.autoSelectHosts ? array() : array().min(1).max(agentsCount)
    });
  });
};

var ScaleUpModal = function ScaleUpModal(_ref) {
  var isOpen = _ref.isOpen,
      onClose = _ref.onClose,
      addHostsToCluster = _ref.addHostsToCluster,
      clusterDeployment = _ref.clusterDeployment,
      agents = _ref.agents;

  var _React$useState = React__default.useState(),
      error = _React$useState[0],
      setError = _React$useState[1];

  var getInitialValues = function getInitialValues() {
    var _clusterDeployment$me;

    var agentSelector = getAgentSelectorFieldsFromAnnotations(clusterDeployment === null || clusterDeployment === void 0 ? void 0 : (_clusterDeployment$me = clusterDeployment.metadata) === null || _clusterDeployment$me === void 0 ? void 0 : _clusterDeployment$me.annotations);
    var autoSelectHosts = agentSelector.autoSelect;
    return {
      autoSelectHosts: autoSelectHosts,
      hostCount: 1,
      agentLabels: agentSelector.labels,
      locations: agentSelector.locations,
      selectedHostIds: [],
      autoSelectedHostIds: []
    };
  };

  var validationSchema = React__default.useMemo(function () {
    return getValidationSchema$2(agents.length);
  }, [agents.length]);

  var handleSubmit = function handleSubmit(values) {
    try {
      var autoSelectHosts = values.autoSelectHosts,
          autoSelectedHostIds = values.autoSelectedHostIds,
          selectedHostIds = values.selectedHostIds;

      var _temp2 = _catch(function () {
        setError(undefined);
        var agentsToAdd = getAgentsToAdd(autoSelectHosts ? autoSelectedHostIds : selectedHostIds, agents);
        return Promise.resolve(addHostsToCluster(agentsToAdd)).then(function () {
          onClose();
        });
      }, function (e) {
        setError(e.message);
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Modal, {
    "aria-label": "Add worker host dialog",
    title: "Add worker hosts",
    isOpen: isOpen,
    onClose: onClose,
    hasNoBodyWrapper: true,
    id: "scale-up-modal"
  }, /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: getInitialValues(),
    validationSchema: validationSchema,
    onSubmit: handleSubmit,
    validateOnMount: true
  }, function (_ref2) {
    var isSubmitting = _ref2.isSubmitting,
        isValid = _ref2.isValid,
        submitForm = _ref2.submitForm;
    return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ModalBoxBody, null, /*#__PURE__*/React__default.createElement(Stack, {
      hasGutter: true
    }, /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(ScaleUpForm, {
      agents: agents
    })), error && /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(Alert, {
      title: "Failed to add hosts to the cluster",
      variant: AlertVariant.danger,
      actionClose: /*#__PURE__*/React__default.createElement(AlertActionCloseButton, {
        onClose: function onClose() {
          return setError(undefined);
        }
      }),
      isInline: true
    }, error)))), /*#__PURE__*/React__default.createElement(ModalBoxFooter, null, /*#__PURE__*/React__default.createElement(Button, {
      onClick: submitForm,
      isDisabled: isSubmitting || !isValid
    }, "Submit"), /*#__PURE__*/React__default.createElement(Button, {
      onClick: onClose,
      variant: ButtonVariant.secondary
    }, "Cancel")));
  }));
};

var getBareMetalHostCredentialsSecret = function getBareMetalHostCredentialsSecret(values, namespace) {
  return {
    apiVersion: 'v1',
    kind: 'Secret',
    data: {
      username: btoa(values.username),
      password: btoa(values.password)
    },
    metadata: {
      generateName: "bmc-" + values.hostname.split('.').shift() + "-",
      namespace: namespace
    },
    type: 'Opaque'
  };
};
var getBareMetalHost = function getBareMetalHost(values, infraEnv, secret) {
  var _infraEnv$metadata, _infraEnv$metadata2, _labels, _secret$metadata;

  return {
    apiVersion: 'metal3.io/v1alpha1',
    kind: 'BareMetalHost',
    metadata: {
      name: values.hostname,
      namespace: (_infraEnv$metadata = infraEnv.metadata) === null || _infraEnv$metadata === void 0 ? void 0 : _infraEnv$metadata.namespace,
      labels: (_labels = {}, _labels[INFRAENV_AGENTINSTALL_LABEL_KEY] = (_infraEnv$metadata2 = infraEnv.metadata) === null || _infraEnv$metadata2 === void 0 ? void 0 : _infraEnv$metadata2.name, _labels),
      annotations: {
        'inspect.metal3.io': 'disabled'
      }
    },
    spec: {
      bmc: {
        address: values.bmcAddress,
        credentialsName: (_secret$metadata = secret.metadata) === null || _secret$metadata === void 0 ? void 0 : _secret$metadata.name,
        disableCertificateVerification: !!values.disableCertificateVerification
      },
      bootMACAddress: values.bootMACAddress,
      description: '',
      online: !!values.online,
      automatedCleaningMode: 'disabled'
    }
  };
};

var Next = "Next";
var Cancel = "Cancel";
var Back = "Back";
var en = {
	"dynamic-cim~failed-to-create-CD": "Failed to cretate the ClusterDeployment or agentClusterInstall resource: {{msg}}",
	"dynamic-cim~Name": "Name",
	"dynamic-cim~Status": "Status",
	"dynamic-cim~Distribution version": "Distribution version",
	"dynamic-cim~Clusters": "Clusters",
	"dynamic-cim~Edit": "Edit",
	"dynamic-cim~Delete": "Delete",
	"Cluster Details": "Cluster Details",
	"Saving changes...": "Saving changes...",
	Next: Next,
	Cancel: Cancel,
	Back: Back
};

var Next$1 = "Next (in Chineese)";
var Cancel$1 = "Cancel (in Chineese)";
var Back$1 = "Back (in Chineese)";
var zh = {
	"dynamic-cim~Name": "Name (in Chineese)",
	"dynamic-cim~Status": "Status (in Chineese)",
	"Cluster Details": "Cluster Details (in Chineese)",
	"Saving changes...": "Saving changes... (in Chineese)",
	Next: Next$1,
	Cancel: Cancel$1,
	Back: Back$1
};

var _resources;
var DEFAULT_LANG = 'en';
var i18nInstance = i18n.createInstance().use(LanguageDetector).use(initReactI18next);
var resources = (_resources = {}, _resources[DEFAULT_LANG] = {
  translation: en
}, _resources.zh = {
  translation: zh
}, _resources);
i18nInstance.init({
  debug: true,
  fallbackLng: DEFAULT_LANG,
  interpolation: {
    escapeValue: false
  },
  resources: resources,
  react: {
    useSuspense: true
  },
  saveMissing: true,
  missingKeyHandler: function missingKeyHandler(lngs, ns, key) {
    console.error("= Missing i18n key \"" + key + "\" in namespace \"" + ns + "\" and language \"" + lngs + ".\"");
  }
}, function (err) {
  if (err) {
    console.error('Failed to initialize i18next for the Assisted UI: ', err);
    return;
  }

  console.info("Assisted UI's i18next initialized.");
});

var I18N = function I18N(_ref) {
  var _ref$preferredLang = _ref.preferredLang,
      preferredLang = _ref$preferredLang === void 0 ? DEFAULT_LANG : _ref$preferredLang,
      children = _ref.children;
  var supportedLang = resources[preferredLang] ? preferredLang : DEFAULT_LANG;
  useEffect(function () {
    if (supportedLang !== i18nInstance.language) {
      console.info("assisted-ui-lib: changing language from " + i18nInstance.language + " to " + supportedLang + ".");
      i18nInstance.changeLanguage(supportedLang);
    }
  }, [supportedLang]);
  return /*#__PURE__*/createElement(Suspense, {
    fallback: /*#__PURE__*/createElement(LoadingState, null)
  }, /*#__PURE__*/createElement(I18nextProvider, {
    i18n: i18nInstance
  }, children));
};



var index$4 = {
  __proto__: null,
  Reducers: index$2,
  DownloadIsoModal: DownloadIsoModal,
  getClusterStatusFromConditions: getClusterStatusFromConditions,
  getClusterStatus: getClusterStatus,
  isDraft: isDraft,
  getAgentStatusFromConditions: getAgentStatusFromConditions,
  getAgentStatus: getAgentStatus,
  getBMHStatus: getBMHStatus,
  getAIHosts: getAIHosts,
  getAICluster: getAICluster,
  getHostNetworks: getHostNetworks,
  REQUIRED_AGENT_CONDITION_TYPES: REQUIRED_AGENT_CONDITION_TYPES,
  getFailingAgentConditions: getFailingAgentConditions,
  getFailingResourceConditions: getFailingResourceConditions,
  getOCPVersions: getOCPVersions,
  getLocationsFromMatchExpressions: getLocationsFromMatchExpressions,
  getAgentLocationMatchExpression: getAgentLocationMatchExpression,
  hostToAgent: hostToAgent,
  getAgentsForSelection: getAgentsForSelection,
  getAgentRole: getAgentRole,
  getAgentProgressStages: getAgentProgressStages,
  getAgentProgress: getAgentProgress,
  getAgentSelectorFieldsFromAnnotations: getAgentSelectorFieldsFromAnnotations,
  getAnnotationsFromAgentSelector: getAnnotationsFromAgentSelector,
  getClusterDeploymentResource: getClusterDeploymentResource,
  getConsoleUrl: getConsoleUrl,
  getClusterApiUrl: getClusterApiUrl,
  getClusterProperties: getClusterProperties,
  getIsSNOCluster: getIsSNOCluster,
  AGENT_LOCATION_LABEL_KEY: AGENT_LOCATION_LABEL_KEY,
  AGENT_SELECTOR: AGENT_SELECTOR,
  AGENT_AUTO_SELECT_ANNOTATION_KEY: AGENT_AUTO_SELECT_ANNOTATION_KEY,
  AGENT_NOLOCATION_VALUE: AGENT_NOLOCATION_VALUE,
  INFRAENV_AGENTINSTALL_LABEL_KEY: INFRAENV_AGENTINSTALL_LABEL_KEY,
  AGENT_BMH_HOSTNAME_LABEL_KEY: AGENT_BMH_HOSTNAME_LABEL_KEY,
  EnvironmentDetails: EnvironmentDetails,
  InfraEnvAgentTable: InfraEnvAgentTable,
  InfraEnvHostsTabAgentsWarning: InfraEnvHostsTabAgentsWarning,
  EnvironmentErrors: EnvironmentErrors,
  InfraEnvFormPage: InfraEnvFormPage,
  getLabels: getLabels,
  getClusterDeploymentForInfraEnv: getClusterDeploymentForInfraEnv,
  getAgentClusterInstall: getAgentClusterInstall,
  getSecret: getSecret,
  getInfraEnv: getInfraEnv,
  ClusterDeploymentDetails: ClusterDeploymentDetails,
  ClusterDeploymentProgress: ClusterDeploymentProgress,
  ClusterDeploymentCredentials: ClusterDeploymentCredentials,
  ClusterDeploymentKubeconfigDownload: ClusterDeploymentKubeconfigDownload,
  ClusterDeploymentWizard: ClusterDeploymentWizard,
  ClusterInstallationError: ClusterInstallationError,
  ACMClusterDeploymentDetailsStep: ACMClusterDeploymentDetailsStep,
  ACMClusterDeploymentNetworkingStep: ACMClusterDeploymentNetworkingStep,
  ACMClusterDeploymentHostsStep: ACMClusterDeploymentHostsStep,
  ClusterDeploymentCreateProgress: ClusterDeploymentCreateProgress,
  getTotalCompute: getTotalCompute,
  shouldShowClusterCredentials: shouldShowClusterCredentials,
  shouldShowClusterInstallationProgress: shouldShowClusterInstallationProgress,
  isInstallationReady: isInstallationReady,
  shouldShowClusterInstallationError: shouldShowClusterInstallationError,
  formatEventsData: formatEventsData,
  getOnFetchEventsHandler: getOnFetchEventsHandler,
  onAdditionalNtpSource: onAdditionalNtpSource,
  AdditionalNTPSourcesDialogToggle: AdditionalNTPSourcesDialogToggle$1,
  ClusterErrors: ClusterErrors,
  LogsDownloadButton: LogsDownloadButton,
  EditAgentModal: EditAgentModal,
  AddHostModal: AddHostModal,
  EditBMHModal: EditBMHModal,
  ScaleUpModal: ScaleUpModal,
  getBareMetalHostCredentialsSecret: getBareMetalHostCredentialsSecret,
  getBareMetalHost: getBareMetalHost,
  AgentTable: AgentTable,
  BMCForm: BMCForm,
  stringToJSON: stringToJSON,
  removeProtocolFromURL: removeProtocolFromURL,
  get ResourceUIState () { return ResourceUIState; },
  ACM_ENABLED_FEATURES: ACM_ENABLED_FEATURES,
  SINGLE_CLUSTER_ENABLED_FEATURES: SINGLE_CLUSTER_ENABLED_FEATURES,
  STANDALONE_DEPLOYMENT_ENABLED_FEATURES: STANDALONE_DEPLOYMENT_ENABLED_FEATURES,
  FeatureGateContext: FeatureGateContext,
  FeatureGateContextProvider: FeatureGateContextProvider,
  useFeature: useFeature,
  PopoverIcon: PopoverIcon,
  WizardNavItem: NavItem,
  Alerts: Alerts,
  ExternalLink: ExternalLink,
  PrismCode: PrismCode,
  GridGap: GridGap,
  EventsList: EventsList,
  ClusterEventsList: ClusterEventsList,
  ClusterEventsToolbar: ClusterEventsToolbar,
  InputField: InputField,
  CheckboxField: CheckboxField,
  TextAreaField: TextAreaField,
  SelectField: SelectField,
  MultiSelectField: MultiSelectField,
  TextAreaSecretField: TextAreaSecretField,
  UploadField: UploadField,
  SwitchField: SwitchField,
  HelperText: HelperText,
  FormikAutoSave: FormikAutoSave,
  PullSecretField: PullSecretField,
  RadioField: RadioField,
  SingleNodeCheckbox: SingleNodeCheckbox,
  NumberInputField: NumberInputField,
  CodeField: CodeField,
  getFieldId: getFieldId,
  trimSshPublicKey: trimSshPublicKey,
  trimCommaSeparatedList: trimCommaSeparatedList,
  getFormikErrorFields: getFormikErrorFields,
  getDefaultOpenShiftVersion: getDefaultOpenShiftVersion,
  labelsToArray: labelsToArray,
  parseStringLabels: parseStringLabels,
  uniqueLabels: uniqueLabels,
  selectedLabelsOnly: selectedLabelsOnly,
  PullSecretInfo: PullSecretInfo,
  nameValidationSchema: nameValidationSchema,
  sshPublicKeyValidationSchema: sshPublicKeyValidationSchema,
  pullSecretValidationSchema: pullSecretValidationSchema,
  ipValidationSchema: ipValidationSchema,
  macAddressValidationSchema: macAddressValidationSchema,
  vipRangeValidationSchema: vipRangeValidationSchema,
  vipValidationSchema: vipValidationSchema,
  ipBlockValidationSchema: ipBlockValidationSchema,
  dnsNameValidationSchema: dnsNameValidationSchema,
  hostPrefixValidationSchema: hostPrefixValidationSchema,
  hostnameValidationSchema: hostnameValidationSchema,
  uniqueHostnameValidationSchema: uniqueHostnameValidationSchema,
  httpProxyValidationSchema: httpProxyValidationSchema,
  noProxyValidationSchema: noProxyValidationSchema,
  ntpSourceValidationSchema: ntpSourceValidationSchema,
  LabelValue: LabelValue,
  LabelField: LabelField,
  EmptyState: EmptyState,
  ErrorState: ErrorState,
  LoadingState: LoadingState,
  ToolbarButton: ToolbarButton,
  ToolbarText: ToolbarText,
  ToolbarrProgress: ToolbarProgress,
  ToolbarSecondaryGroup: ToolbarSecondaryGroup,
  StaticField: StaticField,
  FormikStaticField: FormikStaticField,
  StaticTextField: StaticTextField,
  WizardFooter: WizardFooter,
  sortable: sortable,
  getColSpanRow: getColSpanRow,
  rowSorter: rowSorter,
  toSentence: toSentence,
  getDateTimeCell: getDateTimeCell,
  breakWord: breakWord,
  fitContent: fitContent,
  nowrap: nowrap,
  truncate: truncate,
  wrappable: wrappable,
  noPadding: noPadding,
  RenderIf: RenderIf,
  SimpleDropdown: SimpleDropdown,
  DetailList: DetailList,
  DetailItem: DetailItem,
  EventsModalButton: EventsModalButton,
  EventsModal: EventsModal,
  get PreviewBadgePosition () { return PreviewBadgePosition; },
  DeveloperPreview: DeveloperPreview,
  TechnologyPreview: TechnologyPreview,
  getHumanizedDateTime: getHumanizedDateTime,
  getHumanizedTime: getHumanizedTime,
  isSNOSupportedVersion: isSNOSupportedVersion,
  RoleCell: RoleCell,
  RoleDropdown: RoleDropdown,
  HostsCount: HostsCount,
  HostStatus: HostStatus,
  EditHostModal: EditHostModal,
  HostRequirements: HostRequirements,
  canEnable: canEnable,
  canDisable: canDisable,
  canDelete: canDelete,
  canReset: canReset,
  canEditRole: canEditRole,
  canEditHost: canEditHost,
  canEditDisks: canEditDisks,
  canDownloadKubeconfig: canDownloadKubeconfig,
  canInstallHost: canInstallHost,
  getHostProgressStages: getHostProgressStages,
  getHostProgress: getHostProgress,
  getHostProgressStageNumber: getHostProgressStageNumber,
  canHostnameBeChanged: canHostnameBeChanged,
  getHostRole: getHostRole,
  canDownloadHostLogs: canDownloadHostLogs,
  canDownloadClusterLogs: canDownloadClusterLogs,
  getReadyHostCount: getReadyHostCount,
  getEnabledHostCount: getEnabledHostCount,
  getTotalHostCount: getTotalHostCount,
  getEnabledHosts: getEnabledHosts,
  getHostname: getHostname,
  getHardwareTypeText: getHardwareTypeText,
  fileSize: fileSize,
  HostValidationGroups: HostValidationGroups,
  ClusterPropertiesList: ClusterPropertiesList,
  ClusterProgress: ClusterProgress,
  ClusterCredentials: ClusterCredentials,
  KubeconfigDownload: KubeconfigDownload,
  getOlmOperators: getOlmOperators,
  I18N: I18N
};

var rootReducer = combineReducers({
  clusters: clustersReducer,
  currentCluster: currentClusterReducer
});

var store = configureStore({
  reducer: rootReducer,
  preloadedState: {}
});

var index$5 = {
  __proto__: null,
  store: store
};

var selectCurrentClusterState = function selectCurrentClusterState(state) {
  return state.currentCluster;
};
var selectCurrentCluster = function selectCurrentCluster(state) {
  return state.currentCluster.data;
};
var selectCurrentClusterUIState = function selectCurrentClusterUIState(state) {
  return state.currentCluster.uiState;
};

var ClusterStatusIcon = function ClusterStatusIcon(_ref) {
  var status = _ref.status,
      extraProps = _objectWithoutPropertiesLoose(_ref, ["status"]);

  var iconProps = _extends({
    size: IconSize.sm
  }, extraProps);

  switch (status) {
    case 'cancelled':
      return /*#__PURE__*/React__default.createElement(BanIcon, iconProps);

    case 'insufficient':
    case 'pending-for-input':
    case 'ready':
      return /*#__PURE__*/React__default.createElement(FileAltIcon, iconProps);

    case 'error':
      return /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, _extends({
        color: global_danger_color_100.value
      }, iconProps));

    case 'installed':
      return /*#__PURE__*/React__default.createElement(CheckCircleIcon, _extends({
        color: global_success_color_100.value
      }, iconProps));

    case 'installing-pending-user-action':
      return /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, _extends({
        color: global_warning_color_100.value
      }, iconProps));

    case 'preparing-for-installation':
    case 'installing':
    case 'finalizing':
    case 'adding-hosts':
      return /*#__PURE__*/React__default.createElement(InProgressIcon, iconProps);

    default:
      return /*#__PURE__*/React__default.createElement(Fragment, null);
  }
};
var getClusterStatusText = function getClusterStatusText(status) {
  return CLUSTER_STATUS_LABELS[status] || status;
};

var ClusterStatus = function ClusterStatus(_ref2) {
  var status = _ref2.status,
      testId = _ref2.testId,
      className = _ref2.className;
  var title = getClusterStatusText(status);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterStatusIcon, {
    status: status,
    "data-testid": testId,
    className: className
  }), " ", title);
};

var routeBasePath = '';
var setRouteBasePath = function setRouteBasePath(basePath) {
  routeBasePath = basePath;
};

var selectClusters = function selectClusters(state) {
  return state.clusters.data;
};

var clustersUIState = function clustersUIState(state) {
  return state.clusters.uiState;
};

var currentClusterName = function currentClusterName(state) {
  var _state$currentCluster;

  return (_state$currentCluster = state.currentCluster.data) === null || _state$currentCluster === void 0 ? void 0 : _state$currentCluster.name;
};

var selectClustersUIState = createSelector([selectClusters, clustersUIState], function (clusters, uiState) {
  var LOADED = ResourceUIState.LOADED,
      EMPTY = ResourceUIState.EMPTY;
  return !clusters.length && uiState === LOADED ? EMPTY : uiState;
});

var clusterToClusterTableRow = function clusterToClusterTableRow(cluster) {
  var id = cluster.id,
      name = cluster.name,
      openshiftVersion = cluster.openshiftVersion,
      baseDnsDomain = cluster.baseDnsDomain,
      createdAt = cluster.createdAt;
  var dateTimeCell = getDateTimeCell(createdAt);
  return {
    cells: [{
      title: /*#__PURE__*/React__default.createElement(Link, {
        key: name,
        to: routeBasePath + "/clusters/" + id,
        id: "cluster-link-" + id
      }, name),
      props: {
        'data-testid': "cluster-name-" + name
      },
      sortableValue: name
    }, {
      title: baseDnsDomain || DASH,
      props: {
        'data-testid': "cluster-base-domain-" + name
      },
      sortableValue: baseDnsDomain
    }, {
      title: openshiftVersion,
      props: {
        'data-testid': "cluster-version-" + name
      },
      sortableValue: openshiftVersion
    }, {
      title: /*#__PURE__*/React__default.createElement(ClusterStatus, {
        status: cluster.status
      }),
      props: {
        'data-testid': "cluster-status-" + name
      },
      sortableValue: getClusterStatusText(cluster.status)
    }, {
      title: /*#__PURE__*/React__default.createElement(HostsCount, {
        cluster: cluster
      }),
      props: {
        'data-testid': "cluster-hosts-count-" + name
      },
      sortableValue: getReadyHostCount(cluster)
    }, {
      title: dateTimeCell.title,
      props: {
        'data-testid': "cluster-created-time-" + name
      },
      sortableValue: dateTimeCell.sortableValue
    }],
    props: {
      name: name,
      id: id,
      baseDnsDomain: baseDnsDomain
    }
  };
};

var getClusterTableStatusCell = function getClusterTableStatusCell(rowData) {
  var _rowData$cells;

  return rowData === null || rowData === void 0 ? void 0 : (_rowData$cells = rowData.cells) === null || _rowData$cells === void 0 ? void 0 : _rowData$cells[3];
};
var selectClusterTableRows = createSelector(selectClusters, function (clusters) {
  return clusters.map(clusterToClusterTableRow);
});
var selectClusterNames = createSelector(selectClusters, function (clusters) {
  return clusters.map(function (c) {
    return c.name;
  });
});
var selectClusterNamesButCurrent = createSelector(selectClusterNames, currentClusterName, function (clusterNames, currentName) {
  return clusterNames.filter(function (n) {
    return n !== currentName;
  });
});



var index$6 = {
  __proto__: null,
  selectCurrentClusterState: selectCurrentClusterState,
  selectCurrentCluster: selectCurrentCluster,
  selectCurrentClusterUIState: selectCurrentClusterUIState,
  selectClustersUIState: selectClustersUIState,
  getClusterTableStatusCell: getClusterTableStatusCell,
  selectClusterTableRows: selectClusterTableRows,
  selectClusterNames: selectClusterNames,
  selectClusterNamesButCurrent: selectClusterNamesButCurrent
};

var isSingleClusterMode = function isSingleClusterMode() {
  return process.env.REACT_APP_BUILD_MODE === 'single-cluster';
};
var OCM_CLUSTER_LIST_LINK = '/openshift';



var index$7 = {
  __proto__: null,
  get routeBasePath () { return routeBasePath; },
  setRouteBasePath: setRouteBasePath,
  isSingleClusterMode: isSingleClusterMode,
  OCM_CLUSTER_LIST_LINK: OCM_CLUSTER_LIST_LINK
};

var downloadClusterInstallationLogs = function downloadClusterInstallationLogs(addAlert, clusterId) {
  try {
    var _temp3 = function () {
      if (ocmClient) {
        var _temp4 = _catch(function () {
          return Promise.resolve(getPresignedFileUrl({
            clusterId: clusterId,
            fileName: 'logs',
            hostId: undefined,
            logsType: 'all'
          })).then(function (_ref) {
            var data = _ref.data;
            saveAs(data.url);
          });
        }, function (e) {
          handleApiError(e, function (e) {
            try {
              addAlert({
                title: 'Could not download cluster installation logs.',
                message: getErrorMessage(e)
              });
              return Promise.resolve();
            } catch (e) {
              return Promise.reject(e);
            }
          });
        });

        if (_temp4 && _temp4.then) return _temp4.then(function () {});
      } else {
        saveAs(getClusterLogsDownloadUrl(clusterId));
      }
    }();

    return Promise.resolve(_temp3 && _temp3.then ? _temp3.then(function () {}) : void 0);
  } catch (e) {
    return Promise.reject(e);
  }
};

var getHostRoleCount = function getHostRoleCount(hosts, role) {
  return hosts.filter(function (host) {
    return host.status !== 'disabled' && host.role === role;
  }).length;
};

var getMasterCount = function getMasterCount(hosts) {
  return getHostRoleCount(hosts, 'master');
};
var getWorkerCount = function getWorkerCount(hosts) {
  return getHostRoleCount(hosts, 'worker');
};

var getClusterResources = function getClusterResources(cluster, resourcePath) {
  if (!cluster.hosts) {
    return 0;
  }

  var masterCount = getMasterCount(cluster.hosts);
  var workerCount = getWorkerCount(cluster.hosts);
  var countMastersOnly = masterCount >= 3 && workerCount === 0;
  var countWorkersOnly = masterCount >= 3 && workerCount >= 2;
  var singleNodeMode = masterCount === 1;
  var result = cluster.hosts.filter(function (host) {
    return 'inventory' in host;
  }).filter(function (host) {
    return host.role === 'worker' && countWorkersOnly || host.role === 'master' && countMastersOnly || host.role === 'master' && singleNodeMode;
  }).map(function (host) {
    return stringToJSON(host.inventory) || {};
  }).map(function (inventory) {
    return get(inventory, resourcePath, 0);
  }).reduce(function (total, value) {
    return total + value;
  }, 0);
  return result;
};

var getClustervCPUCount = function getClustervCPUCount(cluster) {
  return getClusterResources(cluster, 'cpu.count');
};
var getClusterMemoryAmount = function getClusterMemoryAmount(cluster) {
  return getClusterResources(cluster, 'memory.physicalBytes');
};
var getClusterDetailId = function getClusterDetailId(suffix) {
  return "cluster-detail-" + suffix;
};

var ExpandComponent = function ExpandComponent(_ref) {
  var obj = _ref.obj;
  return /*#__PURE__*/createElement(HostDetail, {
    host: obj,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle
  });
};

var ClusterHostsTable = function ClusterHostsTable(_ref2) {
  var cluster = _ref2.cluster,
      setDiscoveryHintModalOpen = _ref2.setDiscoveryHintModalOpen,
      skipDisabled = _ref2.skipDisabled;

  var _useHostsTable = useHostsTable(cluster),
      onEditHost = _useHostsTable.onEditHost,
      actionChecks = _useHostsTable.actionChecks,
      onEditRole = _useHostsTable.onEditRole,
      actionResolver = _useHostsTable.actionResolver,
      modalProps = _objectWithoutPropertiesLoose(_useHostsTable, ["onEditHost", "actionChecks", "onEditRole", "actionResolver"]);

  var content = useMemo(function () {
    return [hostnameColumn(onEditHost), roleColumn(actionChecks.canEditRole, onEditRole), statusColumn(AdditionalNTPSourcesDialogToggle, onEditHost), discoveredAtColumn, cpuCoresColumn, memoryColumn, disksColumn, countColumn(cluster)];
  }, [onEditHost, onEditRole, actionChecks.canEditRole, cluster]);
  return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(HostsTable, {
    hosts: cluster.hosts || [],
    skipDisabled: skipDisabled,
    ExpandComponent: ExpandComponent,
    content: content,
    actionResolver: actionResolver
  }, /*#__PURE__*/createElement(HostsTableEmptyState, {
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/createElement(HostsTableModals, _extends({
    cluster: cluster
  }, modalProps)));
};

var ClusterToolbar = function ClusterToolbar(_ref) {
  var children = _ref.children,
      validationSection = _ref.validationSection;
  return /*#__PURE__*/React__default.createElement(Fragment, null, validationSection, /*#__PURE__*/React__default.createElement(ActionGroup, null, /*#__PURE__*/React__default.createElement(Toolbar, {
    id: "cluster-toolbar",
    className: "cluster-toolbar"
  }, /*#__PURE__*/React__default.createElement(ToolbarContent, {
    className: "cluster-toolbar__content"
  }, children))));
};

var ClusterProperties = function ClusterProperties(_ref) {
  var cluster = _ref.cluster;
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h2"
  }, "Cluster Details"))), /*#__PURE__*/React__default.createElement(GridItem, {
    md: 6
  }, /*#__PURE__*/React__default.createElement(DetailList, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "OpenShift version",
    value: cluster.openshiftVersion
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Base DNS domain",
    value: cluster.baseDnsDomain
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "API virtual IP",
    value: cluster.apiVip,
    isHidden: isSingleNodeCluster(cluster)
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Ingress virtual IP",
    value: cluster.ingressVip,
    isHidden: isSingleNodeCluster(cluster)
  }))), /*#__PURE__*/React__default.createElement(GridItem, {
    md: 6
  }, /*#__PURE__*/React__default.createElement(DetailList, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "UUID",
    value: cluster.id
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Cluster network CIDR",
    value: cluster.clusterNetworkCidr
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Cluster network host prefix",
    value: cluster.clusterNetworkHostPrefix
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Service network CIDR",
    value: cluster.serviceNetworkCidr
  }))));
};

var getID$1 = function getID(suffix) {
  return "cluster-install-error-" + suffix;
};

var ClusterInstallationError$1 = function ClusterInstallationError(_ref) {
  var cluster = _ref.cluster,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'Cluster installation failed' : _ref$title;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _useModalDialogsConte = useModalDialogsContext(),
      resetClusterDialog = _useModalDialogsConte.resetClusterDialog;

  return /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.danger,
    title: title,
    actionLinks: /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(AlertActionLink, {
      onClick: function onClick() {
        return resetClusterDialog.open({
          cluster: cluster
        });
      },
      id: getID$1('button-reset-cluster')
    }, "Reset Cluster"), /*#__PURE__*/React__default.createElement(AlertActionLink, {
      onClick: function onClick() {
        return downloadClusterInstallationLogs(addAlert, cluster.id);
      },
      isDisabled: !canDownloadClusterLogs(cluster),
      id: getID$1('button-download-installation-logs')
    }, "Download Installation Logs"), /*#__PURE__*/React__default.createElement(AlertActionLink, {
      onClick: function onClick() {
        return window.open(getBugzillaLink(cluster.openshiftVersion), '_blank');
      },
      id: getID$1('button-report-bug')
    }, "Report a bug")),
    isInline: true
  }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, toSentence(cluster.statusInfo), /*#__PURE__*/React__default.createElement("br", null), "Reset the installation process to return to the configuration and try again. Some hosts may need to be re-registered by rebooting into the Discovery ISO."))));
};

var FailedHosts = function FailedHosts(_ref) {
  var failedHosts = _ref.failedHosts,
      title = _ref.title,
      titleSingle = _ref.titleSingle,
      text = _ref.text;

  if (failedHosts.length === 0) {
    return null;
  }

  return /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.warning,
    title: failedHosts.length === 1 ? titleSingle : title,
    isInline: true
  }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, text))));
};

var FailedHostsWarning = function FailedHostsWarning(_ref2) {
  var _cluster$hosts, _cluster$hosts2;

  var cluster = _ref2.cluster;
  var failedHosts = ((_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.filter(function (host) {
    return host.role === 'worker' && host.status === 'error';
  })) || [];
  var hostsPendingUserAction = ((_cluster$hosts2 = cluster.hosts) === null || _cluster$hosts2 === void 0 ? void 0 : _cluster$hosts2.filter(function (host) {
    return host.status === 'installing-pending-user-action';
  })) || [];
  var failedHostsText = 'Error information for each host is available below.';

  if (cluster.status !== 'finalizing') {
    failedHostsText += ' Debug and reboot each failed worker to retry their installation.';
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(FailedHosts, {
    failedHosts: hostsPendingUserAction,
    title: hostsPendingUserAction.length + " are waiting for user action",
    titleSingle: "1 host is waiting for user action",
    text: cluster.statusInfo
  }), /*#__PURE__*/React__default.createElement(FailedHosts, {
    failedHosts: failedHosts,
    title: failedHosts.length + " worker hosts failed to install",
    titleSingle: "1 worker host failed to install",
    text: failedHostsText
  }));
};

var FailedOperatorsWarning = function FailedOperatorsWarning(_ref) {
  var failedOperators = _ref.failedOperators;
  var operatorText = failedOperators.length === 1 ? OPERATOR_LABELS[failedOperators[0].name || ''] + " operator" : failedOperators.length + " operators";
  return /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.warning,
    title: "Some operators failed to install",
    isInline: true
  }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, null, operatorText + " failed to install. Due to this, the cluster will be degraded, but you can try\n          to install the operator from the Operator Hub.", /*#__PURE__*/React__default.createElement("br", null), "Please check the installation logs for more information.")));
};

var useClusterStatusVarieties = function useClusterStatusVarieties(cluster) {
  var _React$useState = React__default.useState(),
      credentials = _React$useState[0],
      setCredentials = _React$useState[1];

  var _React$useState2 = React__default.useState(),
      credentialsError = _React$useState2[0],
      setCredentialsError = _React$useState2[1];

  var olmOperators = getOlmOperators(cluster.monitoredOperators);
  var failedOlmOperators = olmOperators.filter(function (o) {
    return o.status === 'failed';
  });
  var consoleOperator = React__default.useMemo(function () {
    var _cluster$monitoredOpe;

    return (_cluster$monitoredOpe = cluster.monitoredOperators) === null || _cluster$monitoredOpe === void 0 ? void 0 : _cluster$monitoredOpe.find(function (o) {
      return o.name === 'console';
    });
  }, [cluster.monitoredOperators]);
  var fetchCredentials = React__default.useCallback(function () {
    var fetch = function fetch() {
      try {
        setCredentialsError(undefined);

        var _temp2 = _catch(function () {
          return Promise.resolve(getClusterCredentials(cluster.id)).then(function (response) {
            setCredentials(response.data);
          });
        }, function (err) {
          setCredentialsError(err);
        });

        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    fetch();
  }, [cluster.id]);
  var consoleOperatorStatus = consoleOperator === null || consoleOperator === void 0 ? void 0 : consoleOperator.status;
  React__default.useEffect(function () {
    if (!consoleOperatorStatus && cluster.status === 'installed' || consoleOperatorStatus === 'available') {
      fetchCredentials();
    }
  }, [cluster.status, consoleOperatorStatus, fetchCredentials]);
  return {
    credentials: credentials,
    credentialsError: credentialsError,
    olmOperators: olmOperators,
    failedOlmOperators: failedOlmOperators,
    consoleOperator: consoleOperator,
    fetchCredentials: fetchCredentials
  };
};

var ClusterDetailStatusVarieties = function ClusterDetailStatusVarieties(_ref) {
  var cluster = _ref.cluster,
      clusterVarieties = _ref.clusterVarieties;
  var credentials = clusterVarieties.credentials,
      credentialsError = clusterVarieties.credentialsError,
      failedOlmOperators = clusterVarieties.failedOlmOperators,
      consoleOperator = clusterVarieties.consoleOperator,
      fetchCredentials = clusterVarieties.fetchCredentials;
  var showClusterCredentials = (consoleOperator === null || consoleOperator === void 0 ? void 0 : consoleOperator.status) === 'available' || !consoleOperator && cluster.status === 'installed';
  return /*#__PURE__*/React__default.createElement(Fragment, null, ['installed', 'installing', 'installing-pending-user-action', 'finalizing'].includes(cluster.status) && /*#__PURE__*/React__default.createElement(FailedHostsWarning, {
    cluster: cluster
  }), !!failedOlmOperators.length && /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(FailedOperatorsWarning, {
    failedOperators: failedOlmOperators
  })), cluster.status === 'error' && /*#__PURE__*/React__default.createElement(ClusterInstallationError$1, {
    cluster: cluster
  }), cluster.status === 'cancelled' && /*#__PURE__*/React__default.createElement(ClusterInstallationError$1, {
    title: "Cluster installation was cancelled",
    cluster: cluster
  }), showClusterCredentials && /*#__PURE__*/React__default.createElement(ClusterCredentials, {
    cluster: cluster,
    credentials: credentials,
    error: !!credentialsError,
    retry: fetchCredentials,
    idPrefix: getClusterDetailId('cluster-creds')
  }));
};

var isAddHostsCluster = function isAddHostsCluster(cluster) {
  return cluster.kind === 'AddHostsCluster';
};
var filterHostsByLogStates = function filterHostsByLogStates(cluster, logStates) {
  var _cluster$hosts;

  return ((_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.filter(function (_ref) {
    var logsInfo = _ref.logsInfo;
    return logsInfo && logStates.includes(logsInfo);
  })) || [];
};
var calculateCollectedLogsCount = function calculateCollectedLogsCount(cluster) {
  var collectedLogStates = ['completed', 'timeout'];
  var clusterHasCollectedLogs = cluster.logsInfo && collectedLogStates.includes(cluster.logsInfo);
  var hostsWithCollectedLogsCount = filterHostsByLogStates(cluster, collectedLogStates).length;
  return (clusterHasCollectedLogs ? 1 : 0) + hostsWithCollectedLogsCount;
};
var getOlmOperatorCreateParams = function getOlmOperatorCreateParams(monitoredOperators) {
  if (monitoredOperators === void 0) {
    monitoredOperators = [];
  }

  return getOlmOperators(monitoredOperators).map(function (operator) {
    return {
      name: operator.name,
      properties: operator.properties
    };
  });
};
var getOlmOperatorCreateParamsByName = function getOlmOperatorCreateParamsByName(monitoredOperators) {
  if (monitoredOperators === void 0) {
    monitoredOperators = [];
  }

  return getOlmOperatorCreateParams(monitoredOperators).reduce(function (result, operator) {
    if (operator.name) {
      result[operator.name] = operator;
    }

    return result;
  }, {});
};
var canAbortInstallation = function canAbortInstallation(cluster) {
  var allowedClusterStates = ['preparing-for-installation', 'installing', 'installing-pending-user-action', 'finalizing'];
  return allowedClusterStates.includes(cluster.status);
};

var reducer$1 = function reducer(state, action) {
  var newState;

  switch (action.type) {
    case 'request':
      newState = {
        status: 'loading',
        data: {}
      };
      break;

    case 'success':
      newState = {
        status: 'succeeded',
        data: action.data
      };
      break;

    case 'failure':
      newState = {
        status: 'failed',
        data: action.data
      };
      break;

    default:
      newState = state;
      break;
  }

  return newState;
};

var ClusterDefaultConfigurationContext = React__default.createContext({});
var ClusterDefaultConfigurationProvider = function ClusterDefaultConfigurationProvider(_ref) {
  var children = _ref.children,
      errorUI = _ref.errorUI,
      loadingUI = _ref.loadingUI;

  var _React$useReducer = React__default.useReducer(reducer$1, {
    status: 'idle',
    data: {}
  }),
      state = _React$useReducer[0],
      dispatch = _React$useReducer[1];

  useEffect(function () {
    var mounted = true;

    var fetchAndSetDefaultConfiguration = function fetchAndSetDefaultConfiguration() {
      try {
        var _temp2 = _catch(function () {
          if (mounted) dispatch({
            type: 'request'
          });
          return Promise.resolve(getClustersDefaultConfiguration()).then(function (_ref2) {
            var data = _ref2.data;
            if (mounted) dispatch({
              type: 'success',
              data: data
            });
          });
        }, function () {
          if (mounted) dispatch({
            type: 'failure',
            data: {}
          });
        });

        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    fetchAndSetDefaultConfiguration();
    return function () {
      mounted = false;
    };
  }, []);

  var render = function render(state) {
    var result = {
      ui: loadingUI,
      value: state.data
    };

    switch (state.status) {
      case 'idle':
      case 'loading':
        break;

      case 'failed':
        result = _extends({}, result, {
          ui: errorUI
        });
        break;

      case 'succeeded':
        result = _extends({}, result, {
          ui: children
        });
        break;
    }

    return result;
  };

  var _render = render(state),
      ui = _render.ui,
      value = _render.value;

  return /*#__PURE__*/React__default.createElement(ClusterDefaultConfigurationContext.Provider, {
    value: value
  }, ui);
};
var useDefaultConfiguration = function useDefaultConfiguration(keys) {
  return ___default.pick(useContext(ClusterDefaultConfigurationContext), keys);
};

var ClusterDetail = function ClusterDetail(_ref) {
  var _cluster$progress, _cluster$platform;

  var cluster = _ref.cluster;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _useModalDialogsConte = useModalDialogsContext(),
      resetClusterDialog = _useModalDialogsConte.resetClusterDialog,
      cancelInstallationDialog = _useModalDialogsConte.cancelInstallationDialog;

  var clusterVarieties = useClusterStatusVarieties(cluster);
  var credentials = clusterVarieties.credentials,
      credentialsError = clusterVarieties.credentialsError;

  var _useDefaultConfigurat = useDefaultConfiguration(['inactiveDeletionHours']),
      inactiveDeletionHours = _useDefaultConfigurat.inactiveDeletionHours;

  var inactiveDeletionDays = Math.round((inactiveDeletionHours || 0) / 24);
  return /*#__PURE__*/React__default.createElement(Stack, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h2"
  }, "Installation progress"))), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterProgress, {
    cluster: cluster,
    onFetchEvents: onFetchEvents,
    totalPercentage: ((_cluster$progress = cluster.progress) === null || _cluster$progress === void 0 ? void 0 : _cluster$progress.totalPercentage) || 0
  })), /*#__PURE__*/React__default.createElement(ClusterDetailStatusVarieties, {
    cluster: cluster,
    clusterVarieties: clusterVarieties
  }), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(KubeconfigDownload, {
    status: cluster.status,
    clusterId: cluster.id,
    id: getClusterDetailId('button-download-kubeconfig')
  })), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: typeof inactiveDeletionHours === 'number'
  }, /*#__PURE__*/React__default.createElement(Alert, {
    variant: "info",
    isInline: true,
    title: 'Download and save your kubeconfig file in a safe place. This file will be ' + "automatically deleted from Assisted Installer's service " + ("" + (inactiveDeletionDays > 0 ? "in " + inactiveDeletionDays + " days." : 'today'))
  })), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: ((_cluster$platform = cluster.platform) === null || _cluster$platform === void 0 ? void 0 : _cluster$platform.type) !== 'baremetal'
  }, /*#__PURE__*/React__default.createElement(Alert, {
    variant: "warning",
    isInline: true,
    title: /*#__PURE__*/React__default.createElement("p", null, "Modify your platform configuration to access your platform's features directly in OpenShift.", ' ', /*#__PURE__*/React__default.createElement("a", {
      href: VSPHERE_CONFIG_LINK,
      target: "_blank",
      rel: "noopener noreferrer"
    }, "Learn more about configuration ", /*#__PURE__*/React__default.createElement("i", {
      className: "fas fa-external-link-alt"
    })))
  })), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h2"
  }, "Host Inventory")), /*#__PURE__*/React__default.createElement(ClusterHostsTable, {
    cluster: cluster,
    skipDisabled: true
  })), /*#__PURE__*/React__default.createElement(ClusterProperties, {
    cluster: cluster
  }))), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(Alerts, null)), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(ClusterToolbar, null, canAbortInstallation(cluster) && /*#__PURE__*/React__default.createElement(ToolbarButton, {
    id: getClusterDetailId('button-cancel-installation'),
    variant: ButtonVariant.danger,
    onClick: function onClick() {
      return cancelInstallationDialog.open({
        clusterId: cluster.id
      });
    }
  }, "Abort Installation"), cluster.status === 'error' && /*#__PURE__*/React__default.createElement(ToolbarButton, {
    id: getClusterDetailId('button-reset-cluster'),
    onClick: function onClick() {
      return resetClusterDialog.open({
        cluster: cluster
      });
    }
  }, "Reset Cluster"), ['finalizing', 'installed'].includes(cluster.status) && /*#__PURE__*/React__default.createElement(LaunchOpenshiftConsoleButton, {
    isDisabled: !credentials || !!credentialsError,
    cluster: cluster,
    consoleUrl: credentials === null || credentials === void 0 ? void 0 : credentials.consoleUrl,
    id: getClusterDetailId('button-launch-console')
  }), !isSingleClusterMode() && /*#__PURE__*/React__default.createElement(ToolbarButton, {
    variant: ButtonVariant.link,
    component: function component(props) {
      return /*#__PURE__*/React__default.createElement(Link, _extends({
        to: routeBasePath + "/clusters"
      }, props));
    },
    id: getClusterDetailId('button-back-to-all-clusters')
  }, "Back to all clusters"), /*#__PURE__*/React__default.createElement(ToolbarSecondaryGroup, null, /*#__PURE__*/React__default.createElement(ToolbarButton, {
    id: "cluster-installation-logs-button",
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return downloadClusterInstallationLogs(addAlert, cluster.id);
    },
    isDisabled: !canDownloadClusterLogs(cluster)
  }, "Download Installation Logs"), /*#__PURE__*/React__default.createElement(EventsModalButton, {
    id: "cluster-events-button",
    entityKind: "cluster",
    cluster: cluster,
    title: "Cluster Events",
    variant: ButtonVariant.link,
    onFetchEvents: onFetchEvents
  }, "View Cluster Events")))));
};

var getID$2 = function getID(suffix) {
  return "cluster-detail-" + suffix;
};

var ClusterDetailsButtonGroup = function ClusterDetailsButtonGroup(_ref) {
  var cluster = _ref.cluster;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _useModalDialogsConte = useModalDialogsContext(),
      cancelInstallationDialog = _useModalDialogsConte.cancelInstallationDialog;

  return /*#__PURE__*/React__default.createElement(Flex, {
    className: "assisted-ui-vertical-margin",
    spaceItems: {
      "default": 'spaceItemsSm'
    },
    direction: {
      "default": 'row'
    },
    justifyContent: {
      "default": 'justifyContentFlexStart'
    }
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(Button, {
    "data-testid": "cluster-installation-abort-button",
    variant: ButtonVariant.danger,
    onClick: function onClick() {
      return cancelInstallationDialog.open({
        clusterId: cluster.id
      });
    },
    isDisabled: !canAbortInstallation(cluster)
  }, "Abort Installation")), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(KubeconfigDownload, {
    status: cluster.status,
    clusterId: cluster.id,
    "data-testid": getID$2('button-download-kubeconfig')
  })), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(Button, {
    "data-testid": "cluster-installation-logs-button",
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return downloadClusterInstallationLogs(addAlert, cluster.id);
    },
    isDisabled: !canDownloadClusterLogs(cluster)
  }, "Download Installation Logs")), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(EventsModalButton, {
    "data-testid": "cluster-events-button",
    entityKind: "cluster",
    cluster: cluster,
    title: "Cluster Events",
    variant: ButtonVariant.link,
    onFetchEvents: onFetchEvents
  }, "View Cluster Events")));
};

var ClusterInstallationProgressCard = function ClusterInstallationProgressCard(_ref) {
  var _cluster$progress;

  var cluster = _ref.cluster;

  var _React$useState = React__default.useState(cluster.status !== 'installed'),
      isCardExpanded = _React$useState[0],
      setIsCardExpanded = _React$useState[1];

  var clusterVarieties = useClusterStatusVarieties(cluster);
  return /*#__PURE__*/React__default.createElement(Card, {
    "data-testid": "ai-cluster-details-card",
    isExpanded: isCardExpanded
  }, /*#__PURE__*/React__default.createElement(CardHeader, {
    onExpand: function onExpand() {
      return setIsCardExpanded(!isCardExpanded);
    },
    toggleButtonProps: {
      'data-testid': 'toggle-ai-cluster-details',
      'aria-label': 'AI Cluster Details',
      'aria-labelledby': 'titleId toggle-button',
      'aria-expanded': isCardExpanded
    }
  }, /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h1",
    size: "lg",
    className: "card-title"
  }, "Installation progress"), !isCardExpanded && /*#__PURE__*/React__default.createElement("div", {
    className: "pf-u-ml-md"
  }, /*#__PURE__*/React__default.createElement(ClusterStatusIcon, {
    status: cluster.status
  }))), /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(ClusterProgress, {
    cluster: cluster,
    minimizedView: !isCardExpanded,
    onFetchEvents: onFetchEvents,
    totalPercentage: ((_cluster$progress = cluster.progress) === null || _cluster$progress === void 0 ? void 0 : _cluster$progress.totalPercentage) || 0
  }), /*#__PURE__*/React__default.createElement(ClusterDetailsButtonGroup, {
    cluster: cluster
  })), /*#__PURE__*/React__default.createElement(CardExpandableContent, null, /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(ClusterDetailStatusVarieties, {
    cluster: cluster,
    clusterVarieties: clusterVarieties
  }), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterHostsTable, {
    cluster: cluster,
    skipDisabled: true
  }))))));
};

var useFetchCluster = function useFetchCluster(clusterId) {
  var dispatch = useDispatch();
  return React__default.useCallback(function () {
    return dispatch(fetchClusterAsync(clusterId));
  }, [clusterId, dispatch]);
};
var useClusterPolling = function useClusterPolling(clusterId) {
  var _useSelector = useSelector(selectCurrentClusterState),
      isReloadScheduled = _useSelector.isReloadScheduled,
      uiState = _useSelector.uiState,
      data = _useSelector.data,
      errorDetail = _useSelector.errorDetail;

  var dispatch = useDispatch();
  var fetchCluster = useFetchCluster(clusterId);
  React__default.useEffect(function () {
    if (isReloadScheduled) {
      var bannedUIStates = [ResourceUIState.LOADING, ResourceUIState.RELOADING, ResourceUIState.ERROR];

      if (!bannedUIStates.includes(uiState)) {
        fetchCluster();
      }
    }

    dispatch(cancelForceReload());
  }, [fetchCluster, dispatch, isReloadScheduled, uiState]);
  React__default.useEffect(function () {
    fetchCluster();
    var timer = window.setInterval(function () {
      return dispatch(forceReload());
    }, POLLING_INTERVAL);
    return function () {
      clearInterval(timer);
      dispatch(cancelForceReload());
      dispatch(cleanCluster());
    };
  }, [dispatch, fetchCluster]);
  return {
    cluster: data,
    uiState: uiState,
    errorDetail: errorDetail
  };
};

var ClusterWizardContext = React__default.createContext({
  currentStepId: 'cluster-details',
  setCurrentStepId: function setCurrentStepId() {
    console.warn('Tried to use ClusterWizardContext but there was no provider rendered.');
  }
});

var ClusterAlerts = function ClusterAlerts(_ref) {
  var cluster = _ref.cluster;

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      currentStepId = _React$useContext.currentStepId;

  var _React$useMemo = React__default.useMemo(function () {
    var validationsInfo = stringToJSON(cluster.validationsInfo) || {};
    var reducedValidationsInfo = getWizardStepClusterValidationsInfo(validationsInfo, currentStepId);

    var flattenedValues = ___default.values(reducedValidationsInfo).flat();

    return {
      pendingClusterValidations: flattenedValues.filter(function (validation) {
        return validation.status === 'pending';
      }),
      failedClusterValidations: flattenedValues.filter(function (validation) {
        return validation.status === 'failure';
      })
    };
  }, [cluster.validationsInfo, currentStepId]),
      failedClusterValidations = _React$useMemo.failedClusterValidations;

  var isClusterReady = getWizardStepClusterStatus(cluster, currentStepId) === 'ready';
  return /*#__PURE__*/React__default.createElement(Fragment, null, !cluster.validationsInfo && /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.info,
    title: "Cluster validations are initializing",
    isInline: true
  }, "Please hold on till backgroud checks are started."), !isClusterReady && /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.warning,
    title: "Cluster is not ready yet",
    isInline: true
  }, !!failedClusterValidations.length && /*#__PURE__*/React__default.createElement(Flex, {
    spaceItems: {
      "default": 'spaceItemsSm'
    },
    direction: {
      "default": 'column'
    }
  }, /*#__PURE__*/React__default.createElement(FlexItem, null, "The following requirements must be met:"), /*#__PURE__*/React__default.createElement(FlexItem, null, /*#__PURE__*/React__default.createElement(List, null, failedClusterValidations.map(function (validation) {
    return /*#__PURE__*/React__default.createElement(ListItem$1, {
      key: validation.id
    }, validation.message);
  }))))));
};

var ClusterValidationSection = function ClusterValidationSection(_ref2) {
  var cluster = _ref2.cluster,
      _ref2$errorFields = _ref2.errorFields,
      errorFields = _ref2$errorFields === void 0 ? [] : _ref2$errorFields;
  return /*#__PURE__*/React__default.createElement(AlertGroup, null, !!errorFields.length && /*#__PURE__*/React__default.createElement(Alert, {
    variant: AlertVariant.danger,
    title: "Provided cluster configuration is not valid",
    isInline: true
  }, "The following fields are not valid:", ' ', errorFields.map(function (field) {
    return CLUSTER_FIELD_LABELS[field];
  }).join(', '), "."), cluster && /*#__PURE__*/React__default.createElement(ClusterAlerts, {
    cluster: cluster
  }));
};

var ClusterWizardFooter = function ClusterWizardFooter(_ref) {
  var cluster = _ref.cluster,
      additionalActions = _ref.additionalActions,
      errorFields = _ref.errorFields,
      onCancel = _ref.onCancel,
      rest = _objectWithoutPropertiesLoose(_ref, ["cluster", "additionalActions", "errorFields", "onCancel"]);

  var _useAlerts = useAlerts(),
      alerts = _useAlerts.alerts;

  var history = useHistory();
  var handleCancel = React__default.useCallback(function () {
    return history.push(routeBasePath + "/clusters/");
  }, [history]);
  var alertsSection = alerts.length ? /*#__PURE__*/React__default.createElement(Alerts, null) : undefined;
  var errorsSection = /*#__PURE__*/React__default.createElement(ClusterValidationSection, {
    cluster: cluster,
    errorFields: errorFields
  });
  return /*#__PURE__*/React__default.createElement(WizardFooter, _extends({
    alerts: alertsSection,
    errors: errorsSection,
    onCancel: onCancel || handleCancel,
    leftExtraActions: additionalActions
  }, rest));
};

var wizardStepNames$1 = {
  'cluster-details': 'Cluster details',
  'host-discovery': 'Host discovery',
  networking: 'Networking',
  review: 'Review and create'
};

var wizardSteps$1 = Object.keys(wizardStepsValidationsMap);

var ClusterWizardNavigation = function ClusterWizardNavigation(_ref) {
  var cluster = _ref.cluster;

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      currentStepId = _React$useContext.currentStepId,
      setCurrentStepId = _React$useContext.setCurrentStepId;

  return /*#__PURE__*/React__default.createElement(WizardNav, null, /*#__PURE__*/React__default.createElement(NavItem, {
    key: "cluster-details",
    content: wizardStepNames$1['cluster-details'],
    isCurrent: currentStepId === 'cluster-details',
    isValid: function isValid() {
      return !(cluster === null || cluster === void 0 ? void 0 : cluster.validationsInfo) || canNextClusterDetails({
        cluster: cluster
      });
    },
    isDisabled: false,
    step: 0,
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('cluster-details');
    }
  }), /*#__PURE__*/React__default.createElement(NavItem, {
    key: "host-discovery",
    content: wizardStepNames$1['host-discovery'],
    isDisabled: !wizardSteps$1.slice(1).includes(currentStepId),
    isValid: function isValid() {
      return !cluster || canNextHostDiscovery({
        cluster: cluster
      });
    },
    isCurrent: currentStepId === 'host-discovery',
    step: 1,
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('host-discovery');
    }
  }), /*#__PURE__*/React__default.createElement(NavItem, {
    content: wizardStepNames$1['networking'],
    step: 2,
    isDisabled: !wizardSteps$1.slice(2).includes(currentStepId),
    isValid: function isValid() {
      return !cluster || canNextNetwork({
        cluster: cluster
      });
    },
    key: "networking",
    isCurrent: currentStepId === 'networking',
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('networking');
    }
  }), /*#__PURE__*/React__default.createElement(NavItem, {
    content: wizardStepNames$1['review'],
    step: 3,
    isDisabled: !wizardSteps$1.slice(3).includes(currentStepId),
    key: "review",
    isCurrent: currentStepId === 'review',
    onNavItemClick: function onNavItemClick() {
      return setCurrentStepId('review');
    }
  }));
};

var ClusterWizardHeaderExtraActions = function ClusterWizardHeaderExtraActions(_ref) {
  var cluster = _ref.cluster;
  return cluster ? /*#__PURE__*/React__default.createElement(SplitItem, null, /*#__PURE__*/React__default.createElement(EventsModalButton, {
    id: "cluster-events-button",
    entityKind: "cluster",
    cluster: cluster,
    title: "Cluster events",
    variant: ButtonVariant.secondary,
    onFetchEvents: onFetchEvents
  }, "View cluster events")) : null;
};

var NetworkConfigurationTable = function NetworkConfigurationTable(_ref) {
  var cluster = _ref.cluster,
      skipDisabled = _ref.skipDisabled,
      AdditionalNTPSourcesDialogToggleComponent = _ref.AdditionalNTPSourcesDialogToggleComponent,
      onEditHost = _ref.onEditHost,
      onEditRole = _ref.onEditRole,
      canEditRole = _ref.canEditRole,
      actionResolver = _ref.actionResolver,
      children = _ref.children,
      onSelect = _ref.onSelect,
      selectedIDs = _ref.selectedIDs;
  var content = useMemo(function () {
    return [hostnameColumn(onEditHost), roleColumn(canEditRole, onEditRole), networkingStatusColumn(onEditHost), activeNICColumn(cluster), ipv4Column(cluster), ipv6Column(cluster), macAddressColumn(cluster), countColumn(cluster)];
  }, [onEditHost, onEditRole, canEditRole, cluster]);
  return /*#__PURE__*/createElement(HostsTable, {
    testId: "networking-host-table",
    hosts: cluster.hosts || [],
    skipDisabled: skipDisabled,
    ExpandComponent: function ExpandComponent(_ref2) {
      var obj = _ref2.obj;
      return /*#__PURE__*/createElement(HostDetail, {
        host: obj,
        AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggleComponent
      });
    },
    content: content,
    actionResolver: actionResolver,
    onSelect: onSelect,
    selectedIDs: selectedIDs
  }, children);
};

var NetworkConfigurationTable$1 = function NetworkConfigurationTable$1(_ref) {
  var cluster = _ref.cluster,
      setDiscoveryHintModalOpen = _ref.setDiscoveryHintModalOpen,
      skipDisabled = _ref.skipDisabled;

  var _useHostsTable = useHostsTable(cluster),
      onEditHost = _useHostsTable.onEditHost,
      actionChecks = _useHostsTable.actionChecks,
      onEditRole = _useHostsTable.onEditRole,
      actionResolver = _useHostsTable.actionResolver,
      modalProps = _objectWithoutPropertiesLoose(_useHostsTable, ["onEditHost", "actionChecks", "onEditRole", "actionResolver"]);

  return /*#__PURE__*/createElement(Fragment, null, /*#__PURE__*/createElement(NetworkConfigurationTable, {
    cluster: cluster,
    skipDisabled: skipDisabled,
    AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle,
    canEditRole: actionChecks.canEditRole,
    onEditHost: onEditHost,
    onEditRole: onEditRole,
    actionResolver: actionResolver
  }, /*#__PURE__*/createElement(HostsTableEmptyState, {
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/createElement(HostsTableModals, _extends({
    cluster: cluster
  }, modalProps)));
};

var NetworkConfigurationForm = function NetworkConfigurationForm(_ref) {
  var cluster = _ref.cluster;
  var defaultNetworkSettings = useDefaultConfiguration(['clusterNetworkCidr', 'serviceNetworkCidr', 'clusterNetworkHostPrefix']);

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert,
      clearAlerts = _useAlerts.clearAlerts;

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var dispatch = useDispatch();
  var hostSubnets = React__default.useMemo(function () {
    return getHostSubnets(cluster);
  }, [cluster]);
  var initialValues = React__default.useMemo(function () {
    return getNetworkInitialValues(cluster, defaultNetworkSettings);
  }, []);
  var initialTouched = React__default.useMemo(function () {
    return ___default.mapValues(initialValues, function () {
      return true;
    });
  }, [initialValues]);
  var memoizedValidationSchema = React__default.useMemo(function () {
    return getNetworkConfigurationValidationSchema(initialValues, hostSubnets);
  }, [hostSubnets, initialValues]);

  var handleSubmit = function handleSubmit(values, actions) {
    try {
      clearAlerts();

      var _temp2 = _catch(function () {
        var _hostSubnets$find;

        var isMultiNodeCluster = !isSingleNodeCluster(cluster);
        var isUserManagedNetworking = values.managedNetworkingType === 'userManaged';

        var params = ___default.omit(values, ['hostSubnet', 'useRedHatDnsService', 'managedNetworkingType', 'machineNetworkCidr', 'serviceNetworkCidr', 'clusterNetworkCidr', 'clusterNetworkHostPrefix']);

        params.userManagedNetworking = isUserManagedNetworking;
        params.clusterNetworks = [{
          cidr: values.clusterNetworkCidr,
          hostPrefix: values.clusterNetworkHostPrefix
        }];
        params.serviceNetworks = [{
          cidr: values.serviceNetworkCidr
        }];
        params.machineNetworks = [{
          cidr: (_hostSubnets$find = hostSubnets.find(function (hn) {
            return hn.subnet === values.hostSubnet;
          })) === null || _hostSubnets$find === void 0 ? void 0 : _hostSubnets$find.subnet
        }];

        if (isUserManagedNetworking) {
          delete params.apiVip;
          delete params.ingressVip;

          if (isMultiNodeCluster) {
            delete params.machineNetworks;
          }
        } else {
          if (values.vipDhcpAllocation) {
            delete params.apiVip;
            delete params.ingressVip;
          } else {
            delete params.machineNetworks;
          }
        }

        return Promise.resolve(patchCluster(cluster.id, params)).then(function (_ref2) {
          var data = _ref2.data;
          dispatch(updateCluster(data));
          actions.resetForm({
            values: getNetworkInitialValues(data, defaultNetworkSettings)
          });
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to update the cluster',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    validationSchema: memoizedValidationSchema,
    onSubmit: handleSubmit,
    initialTouched: initialTouched,
    validateOnMount: true
  }, function (_ref3) {
    var isSubmitting = _ref3.isSubmitting,
        dirty = _ref3.dirty,
        errors = _ref3.errors,
        touched = _ref3.touched;
    var errorFields = getFormikErrorFields(errors, touched);
    var form = /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Grid, {
      hasGutter: true
    }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, {
      extraItems: /*#__PURE__*/React__default.createElement(ClusterWizardHeaderExtraActions, {
        cluster: cluster
      })
    }, "Networking")), /*#__PURE__*/React__default.createElement(GridItem, {
      span: 12,
      lg: 10,
      xl: 9,
      xl2: 7
    }, /*#__PURE__*/React__default.createElement(NetworkConfigurationFormFields, {
      cluster: cluster,
      hostSubnets: hostSubnets,
      defaultNetworkSettings: defaultNetworkSettings
    })), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
      component: "h2"
    }, "Host inventory")), /*#__PURE__*/React__default.createElement(NetworkConfigurationTable$1, {
      cluster: cluster
    }))), /*#__PURE__*/React__default.createElement(FormikAutoSave, null));
    var footer = /*#__PURE__*/React__default.createElement(ClusterWizardFooter, {
      cluster: cluster,
      errorFields: errorFields,
      isSubmitting: isSubmitting,
      isNextDisabled: dirty || !canNextNetwork({
        cluster: cluster
      }),
      onNext: function onNext() {
        return setCurrentStepId('review');
      },
      onBack: function onBack() {
        return setCurrentStepId('host-discovery');
      }
    });
    return /*#__PURE__*/React__default.createElement(ClusterWizardStep, {
      navigation: /*#__PURE__*/React__default.createElement(ClusterWizardNavigation, {
        cluster: cluster
      }),
      footer: footer
    }, form);
  });
};

var AllValidationsPassed = function AllValidationsPassed() {
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(CheckCircleIcon, {
    color: global_success_color_100.value
  }), " All validations passed");
};

var PendingValidations = function PendingValidations(_ref) {
  var id = _ref.id,
      count = _ref.count;
  return /*#__PURE__*/React__default.createElement("div", {
    id: id
  }, "There ", count === 1 ? 'is' : 'are', " still ", count, " pending validation", count === 1 ? '' : 's', ".");
};

var ValidationActionLink = function ValidationActionLink(_ref2) {
  var step = _ref2.step;

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  return /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return setCurrentStepId(step);
    },
    isInline: true
  }, wizardStepNames$1[step]);
};

var FailingValidation = function FailingValidation(_ref3) {
  var validation = _ref3.validation,
      clusterGroup = _ref3.clusterGroup,
      hostGroup = _ref3.hostGroup,
      _ref3$severity = _ref3.severity,
      severity = _ref3$severity === void 0 ? 'danger' : _ref3$severity;
  var issue = (HOST_VALIDATION_LABELS[validation.id] || CLUSTER_VALIDATION_LABELS[validation.id] || validation.id) + " check failed. ";
  var fix;
  var step = findValidationFixStep({
    id: validation.id,
    clusterGroup: clusterGroup,
    hostGroup: hostGroup
  });

  if (step === 'review') {
    fix = 'Please wait till all validations are finished.';
  } else if (step) {
    fix = /*#__PURE__*/React__default.createElement(Fragment, null, "It can be fixed in the ", /*#__PURE__*/React__default.createElement(ValidationActionLink, {
      step: step
    }), " step.");
  } else {
    console.error('Unknown validation ID detected in the ', clusterGroup || hostGroup, ' group:', JSON.stringify(validation));
  }

  var icon;

  if (severity === 'warning') {
    icon = /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
      color: global_warning_color_100.value
    });
  } else {
    icon = /*#__PURE__*/React__default.createElement(ExclamationCircleIcon, {
      color: global_danger_color_100.value,
      size: "sm"
    });
  }

  return /*#__PURE__*/React__default.createElement("div", {
    id: "failing-validation-" + validation.id
  }, icon, " ", issue, fix);
};

var ClusterValidations = function ClusterValidations(_ref4) {
  var _ref4$validationsInfo = _ref4.validationsInfo,
      validationsInfoString = _ref4$validationsInfo === void 0 ? '' : _ref4$validationsInfo;
  var validationsInfo = stringToJSON(validationsInfoString) || {};
  var failingValidations = [];
  var pendingCount = 0;
  Object.keys(validationsInfo).forEach(function (group) {
    var f = function f(validation) {
      if (validation.status === 'pending') {
        pendingCount++;
      }

      if (validation.status === 'failure') {
        failingValidations.push( /*#__PURE__*/React__default.createElement(FailingValidation, {
          key: validation.id,
          validation: validation,
          clusterGroup: group
        }));
      }
    };

    validationsInfo[group].forEach(f);
  });

  if (pendingCount) {
    failingValidations.unshift( /*#__PURE__*/React__default.createElement(PendingValidations, {
      key: "pending-validations",
      id: "cluster-pending-validations",
      count: pendingCount
    }));
  }

  if (failingValidations.length === 0) {
    return /*#__PURE__*/React__default.createElement(AllValidationsPassed, null);
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, failingValidations);
};
var HostsValidations = function HostsValidations(_ref5) {
  var _ref5$hosts = _ref5.hosts,
      hosts = _ref5$hosts === void 0 ? [] : _ref5$hosts;
  var failingValidations = {};
  getEnabledHosts(hosts).forEach(function (host) {
    var validationsInfo = stringToJSON(host.validationsInfo) || {};
    Object.keys(validationsInfo).forEach(function (group) {
      var f = function f(validation) {
        if (validation.status === 'failure') {
          var severity = allClusterWizardSoftValidationIds.includes(validation.id) ? 'warning' : 'danger';
          failingValidations[validation.id] = failingValidations[validation.id] || /*#__PURE__*/React__default.createElement(FailingValidation, {
            key: validation.id,
            validation: validation,
            hostGroup: group,
            severity: severity
          });
        }
      };

      validationsInfo[group].forEach(f);
    });
  });

  var array = ___default.values(failingValidations);

  if (array.length === 0) {
    return /*#__PURE__*/React__default.createElement(AllValidationsPassed, null);
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, array);
};

var ReviewHostsInventory = function ReviewHostsInventory(_ref) {
  var _ref$hosts = _ref.hosts,
      hosts = _ref$hosts === void 0 ? [] : _ref$hosts;
  var rows = React__default.useMemo(function () {
    var summary = getEnabledHosts(hosts).reduce(function (summary, host) {
      summary.count++;
      var inventory = stringToJSON(host.inventory);

      if (inventory) {
        var hwInfo = getSimpleHardwareInfo(inventory);
        summary.cores += hwInfo.cores;
        summary.memory += hwInfo.memory;
        summary.fs += hwInfo.disks;
      }

      return summary;
    }, {
      count: 0,
      cores: 0,
      memory: 0,
      fs: 0
    });
    return [{
      cells: ['Hosts', summary.count]
    }, {
      cells: ['Cores', summary.cores]
    }, {
      cells: ['Memory', fileSize(summary.memory, 2, 'iec')]
    }, {
      cells: ['Storage', fileSize(summary.fs, 2, 'si')]
    }];
  }, [hosts]);
  return /*#__PURE__*/React__default.createElement(Table, {
    rows: rows,
    cells: ['', ''],
    variant: TableVariant.compact,
    borders: false,
    "aria-label": "Cluster summary table",
    className: "review-hosts-table"
  }, /*#__PURE__*/React__default.createElement(TableBody, null));
};

var PlatformIntegrationNote = function PlatformIntegrationNote() {
  return /*#__PURE__*/React__default.createElement("p", null, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
    color: global_warning_color_100.value,
    size: "sm"
  }), " You will need to modify your platform configuration after cluster installation is completed.", ' ', /*#__PURE__*/React__default.createElement("a", {
    href: VSPHERE_CONFIG_LINK,
    target: "_blank",
    rel: "noopener noreferrer"
  }, "Learn more ", /*#__PURE__*/React__default.createElement("i", {
    className: "fas fa-external-link-alt"
  })));
};

var ReviewCluster = function ReviewCluster(_ref2) {
  var _cluster$platform;

  var cluster = _ref2.cluster;
  return /*#__PURE__*/React__default.createElement(DetailList, null, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Cluster address",
    value: cluster.name + "." + cluster.baseDnsDomain
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "OpenShift version",
    value: cluster.openshiftVersion
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Management network CIDR",
    value: cluster.clusterNetworkCidr
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Cluster summary",
    value: /*#__PURE__*/React__default.createElement(ReviewHostsInventory, {
      hosts: cluster.hosts
    })
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Cluster validations",
    value: /*#__PURE__*/React__default.createElement(ClusterValidations, {
      validationsInfo: cluster.validationsInfo
    })
  }), /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Host validations",
    value: /*#__PURE__*/React__default.createElement(HostsValidations, {
      hosts: cluster.hosts
    })
  }), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: ((_cluster$platform = cluster.platform) === null || _cluster$platform === void 0 ? void 0 : _cluster$platform.type) !== 'baremetal'
  }, /*#__PURE__*/React__default.createElement(DetailItem, {
    title: "Platform integration",
    value: /*#__PURE__*/React__default.createElement(PlatformIntegrationNote, null)
  })));
};

var ReviewStep = function ReviewStep(_ref) {
  var cluster = _ref.cluster;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var _React$useState = React__default.useState(false),
      isStartingInstallation = _React$useState[0],
      setIsStartingInstallation = _React$useState[1];

  var dispatch = useDispatch();

  var handleClusterInstall = function handleClusterInstall() {
    try {
      setIsStartingInstallation(true);

      var _temp2 = _catch(function () {
        return Promise.resolve(postInstallCluster(cluster.id)).then(function (_ref2) {
          var data = _ref2.data;
          dispatch(updateCluster(data));
          setIsStartingInstallation(false);
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to start cluster installation',
            message: getErrorMessage(e)
          });
        });
        setIsStartingInstallation(false);
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var footer = /*#__PURE__*/React__default.createElement(ClusterWizardFooter, {
    cluster: cluster,
    onBack: function onBack() {
      return setCurrentStepId('networking');
    },
    isSubmitting: isStartingInstallation,
    submittingText: "Starting installation...",
    additionalActions: /*#__PURE__*/React__default.createElement(ToolbarButton, {
      variant: ButtonVariant.primary,
      name: "install",
      onClick: handleClusterInstall,
      isDisabled: isStartingInstallation || cluster.status !== 'ready'
    }, "Install cluster")
  });
  return /*#__PURE__*/React__default.createElement(ClusterWizardStep, {
    navigation: /*#__PURE__*/React__default.createElement(ClusterWizardNavigation, {
      cluster: cluster
    }),
    footer: footer
  }, /*#__PURE__*/React__default.createElement(Grid, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, {
    extraItems: /*#__PURE__*/React__default.createElement(ClusterWizardHeaderExtraActions, {
      cluster: cluster
    })
  }, "Review and create")), /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ReviewCluster, {
    cluster: cluster
  }))));
};

var usePullSecretFetch = function usePullSecretFetch() {
  var _React$useState = React__default.useState(),
      pullSecret = _React$useState[0],
      setPullSecret = _React$useState[1];

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  React__default.useEffect(function () {
    var getPullSecret = function getPullSecret() {
      try {
        var _temp3 = function () {
          if (ocmClient) {
            var _temp4 = _catch(function () {
              return Promise.resolve(ocmClient.post('/api/accounts_mgmt/v1/access_token')).then(function (response) {
                var _response$request;

                setPullSecret((response === null || response === void 0 ? void 0 : (_response$request = response.request) === null || _response$request === void 0 ? void 0 : _response$request.response) || '');
              });
            }, function (e) {
              handleApiError(e, function (e) {
                setPullSecret('');
                addAlert({
                  title: 'Failed to retrieve pull secret',
                  message: getErrorMessage(e)
                });
              });
            });

            if (_temp4 && _temp4.then) return _temp4.then(function () {});
          } else {
            setPullSecret('');
          }
        }();

        return Promise.resolve(_temp3 && _temp3.then ? _temp3.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    getPullSecret();
  }, []);
  return pullSecret;
};

var useOpenshiftVersions = function useOpenshiftVersions() {
  var _React$useState = React__default.useState(),
      versions = _React$useState[0],
      setVersions = _React$useState[1];

  var _React$useState2 = React__default.useState(),
      error = _React$useState2[0],
      setError = _React$useState2[1];

  React__default.useEffect(function () {
    var doAsync = function doAsync() {
      try {
        return Promise.resolve(_catch(function () {
          return Promise.resolve(getOpenshiftVersions()).then(function (_ref) {
            var data = _ref.data;
            var versions = Object.keys(data).sort().map(function (key) {
              return {
                label: "OpenShift " + (data[key].displayName || key),
                value: key,
                version: data[key].displayName,
                "default": !!data[key]["default"],
                supportLevel: data[key].supportLevel
              };
            });
            setVersions(versions);
          });
        }, function (e) {
          return handleApiError(e, function (e) {
            setError({
              title: 'Failed to retrieve list of supported OpenShift versions.',
              message: getErrorMessage(e)
            });
          });
        }));
      } catch (e) {
        return Promise.reject(e);
      }
    };

    doAsync();
  }, [setVersions]);
  var normalizeClusterVersion = React__default.useCallback(function (version) {
    if (version === void 0) {
      version = '';
    }

    return (versions === null || versions === void 0 ? void 0 : versions.map(function (obj) {
      return obj.value;
    }).find(function (normalized) {
      return version.startsWith(normalized);
    })) || version;
  }, [versions]);
  return {
    error: error,
    loading: !error && !versions,
    versions: versions || [],
    normalizeClusterVersion: normalizeClusterVersion
  };
};

var ClusterDetailsForm = function ClusterDetailsForm(props) {
  var cluster = props.cluster,
      pullSecret = props.pullSecret,
      managedDomains = props.managedDomains,
      ocpVersions = props.ocpVersions,
      _props$usedClusterNam = props.usedClusterNames,
      usedClusterNames = _props$usedClusterNam === void 0 ? [] : _props$usedClusterNam,
      moveNext = props.moveNext,
      handleClusterUpdate = props.handleClusterUpdate,
      handleClusterCreate = props.handleClusterCreate,
      navigation = props.navigation;

  var handleSubmit = function handleSubmit(values) {
    try {
      var params = ___default.omit(values, ['useRedHatDnsService', 'SNODisclaimer']);

      var _temp2 = function () {
        if (cluster) {
          return Promise.resolve(handleClusterUpdate(cluster.id, params)).then(function () {});
        } else {
          return Promise.resolve(handleClusterCreate(params)).then(function () {});
        }
      }();

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var handleOnNext = function handleOnNext(dirty, submitForm, cluster) {
    var fn = submitForm;

    if (!dirty && !___default.isUndefined(cluster) && canNextClusterDetails({
      cluster: cluster
    })) {
      fn = moveNext;
    }

    return fn;
  };

  var initialValues = getClusterDetailsInitialValues(props);
  var validationSchema = getClusterDetailsValidationSchema(usedClusterNames, cluster, ocpVersions);
  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    validationSchema: validationSchema,
    onSubmit: handleSubmit
  }, function (_ref) {
    var submitForm = _ref.submitForm,
        isSubmitting = _ref.isSubmitting,
        isValid = _ref.isValid,
        dirty = _ref.dirty,
        setFieldValue = _ref.setFieldValue,
        setFieldTouched = _ref.setFieldTouched,
        errors = _ref.errors,
        touched = _ref.touched;

    if (!touched.name) {
      setFieldTouched('name');
    }

    var errorFields = getFormikErrorFields(errors, touched);

    var toggleRedHatDnsService = function toggleRedHatDnsService(checked) {
      return setFieldValue('baseDnsDomain', checked ? managedDomains.map(function (d) {
        return d.domain;
      })[0] : '');
    };

    var form = /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Grid, {
      hasGutter: true
    }, /*#__PURE__*/React__default.createElement(GridItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, {
      extraItems: /*#__PURE__*/React__default.createElement(ClusterWizardHeaderExtraActions, {
        cluster: cluster
      })
    }, "Cluster details")), /*#__PURE__*/React__default.createElement(GridItem, {
      span: 12,
      lg: 10,
      xl: 9,
      xl2: 7
    }, /*#__PURE__*/React__default.createElement(ClusterDetailsFormFields, {
      toggleRedHatDnsService: toggleRedHatDnsService,
      versions: ocpVersions,
      canEditPullSecret: !(cluster === null || cluster === void 0 ? void 0 : cluster.pullSecretSet),
      forceOpenshiftVersion: cluster === null || cluster === void 0 ? void 0 : cluster.openshiftVersion,
      isSNOGroupDisabled: !!cluster,
      defaultPullSecret: pullSecret,
      isOcm: !!ocmClient
    }))));
    var footer = /*#__PURE__*/React__default.createElement(ClusterWizardFooter, {
      cluster: cluster,
      errorFields: errorFields,
      isSubmitting: isSubmitting,
      isNextDisabled: !(!isSubmitting && isValid && (dirty || cluster && canNextClusterDetails({
        cluster: cluster
      }))),
      onNext: handleOnNext(dirty, submitForm, cluster)
    });
    return /*#__PURE__*/React__default.createElement(ClusterWizardStep, {
      navigation: navigation,
      footer: footer
    }, form);
  });
};

var ClusterDetails = function ClusterDetails(_ref) {
  var cluster = _ref.cluster;

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var _React$useState = React__default.useState(),
      managedDomains = _React$useState[0],
      setManagedDomains = _React$useState[1];

  var _React$useState2 = React__default.useState(),
      usedClusterNames = _React$useState2[0],
      setUsedClusterNames = _React$useState2[1];

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert,
      clearAlerts = _useAlerts.clearAlerts;

  var history = useHistory();
  var dispatch = useDispatch();
  React__default.useEffect(function () {
    var fetchManagedDomains = function fetchManagedDomains() {
      try {
        var _temp2 = _catch(function () {
          return Promise.resolve(getManagedDomains()).then(function (_ref2) {
            var data = _ref2.data;
            setManagedDomains(data);
          });
        }, function (e) {
          setManagedDomains([]);
          handleApiError(e, function () {
            return addAlert({
              title: 'Failed to retrieve managed domains',
              message: getErrorMessage(e)
            });
          });
        });

        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    fetchManagedDomains();
  }, []);
  React__default.useEffect(function () {
    var fetcher = function fetcher() {
      try {
        var _temp4 = _catch(function () {
          return Promise.resolve(getClusters()).then(function (_ref3) {
            var clusters = _ref3.data;
            var names = clusters.filter(function (c) {
              return !cluster || c.id !== cluster.id;
            }).map(function (c) {
              return c.name + "." + c.baseDnsDomain;
            });
            setUsedClusterNames(names);
          });
        }, function (e) {
          setUsedClusterNames([]);
          handleApiError(e, function () {
            return addAlert({
              title: 'Failed to retrieve names of existing clusters.',
              message: getErrorMessage(e)
            });
          });
        });

        return Promise.resolve(_temp4 && _temp4.then ? _temp4.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    fetcher();
  }, []);
  var pullSecret = usePullSecretFetch();

  var _useOpenshiftVersions = useOpenshiftVersions(),
      errorOCPVersions = _useOpenshiftVersions.error,
      loadingOCPVersions = _useOpenshiftVersions.loading,
      versions = _useOpenshiftVersions.versions;

  React__default.useEffect(function () {
    return errorOCPVersions && addAlert(errorOCPVersions);
  }, [errorOCPVersions, addAlert]);

  var moveNext = function moveNext() {
    return setCurrentStepId('host-discovery');
  };

  var handleClusterUpdate = function handleClusterUpdate(clusterId, values) {
    try {
      clearAlerts();

      var params = ___default.omit(values, ['highAvailabilityMode', 'pullSecret', 'openshiftVersion']);

      var _temp6 = _catch(function () {
        return Promise.resolve(patchCluster(clusterId, params)).then(function (_ref4) {
          var data = _ref4.data;
          dispatch(updateCluster(data));
          canNextClusterDetails({
            cluster: data
          }) && moveNext();
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to update the cluster',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp6 && _temp6.then ? _temp6.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var handleClusterCreate = function handleClusterCreate(params) {
    try {
      clearAlerts();

      var _temp8 = _catch(function () {
        return Promise.resolve(postCluster(params)).then(function (_ref5) {
          var data = _ref5.data;
          var locationState = 'new';
          history.push(routeBasePath + "/clusters/" + data.id, locationState);
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to create new cluster',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp8 && _temp8.then ? _temp8.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  if (pullSecret === undefined || !managedDomains || loadingOCPVersions || !usedClusterNames) {
    return /*#__PURE__*/React__default.createElement(ClusterWizardStep, {
      navigation: /*#__PURE__*/React__default.createElement(ClusterWizardNavigation, {
        cluster: cluster
      })
    }, /*#__PURE__*/React__default.createElement(LoadingState, null));
  }

  var navigation = /*#__PURE__*/React__default.createElement(ClusterWizardNavigation, {
    cluster: cluster
  });
  return /*#__PURE__*/React__default.createElement(ClusterDetailsForm, {
    cluster: cluster,
    pullSecret: pullSecret,
    managedDomains: managedDomains,
    ocpVersions: versions,
    usedClusterNames: usedClusterNames,
    moveNext: moveNext,
    handleClusterUpdate: handleClusterUpdate,
    handleClusterCreate: handleClusterCreate,
    navigation: navigation
  });
};

var getExpandComponent = function getExpandComponent(onDiskRole, canEditDisks) {
  return function (_ref) {
    var host = _ref.obj;
    return /*#__PURE__*/React__default.createElement(HostDetail, {
      key: host.id,
      host: host,
      onDiskRole: onDiskRole,
      canEditDisks: canEditDisks,
      AdditionalNTPSourcesDialogToggleComponent: AdditionalNTPSourcesDialogToggle
    });
  };
};

var HostsDiscoveryTable = function HostsDiscoveryTable(_ref2) {
  var cluster = _ref2.cluster,
      setDiscoveryHintModalOpen = _ref2.setDiscoveryHintModalOpen;

  var _useHostsTable = useHostsTable(cluster),
      onEditHost = _useHostsTable.onEditHost,
      actionChecks = _useHostsTable.actionChecks,
      onEditRole = _useHostsTable.onEditRole,
      onDiskRole = _useHostsTable.onDiskRole,
      actionResolver = _useHostsTable.actionResolver,
      modalProps = _objectWithoutPropertiesLoose(_useHostsTable, ["onEditHost", "actionChecks", "onEditRole", "onDiskRole", "actionResolver"]);

  var content = React__default.useMemo(function () {
    return [hostnameColumn(onEditHost), roleColumn(actionChecks.canEditRole, onEditRole), hardwareStatusColumn(onEditHost), discoveredAtColumn, cpuCoresColumn, memoryColumn, disksColumn, countColumn(cluster)];
  }, [onEditHost, onEditRole, actionChecks.canEditRole, cluster]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(HostsTable, {
    testId: "hosts-discovery-table",
    hosts: cluster.hosts || [],
    content: content,
    actionResolver: actionResolver,
    ExpandComponent: getExpandComponent(onDiskRole, actionChecks.canEditDisks)
  }, /*#__PURE__*/React__default.createElement(HostsTableEmptyState, {
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/React__default.createElement(HostsTableModals, _extends({
    cluster: cluster
  }, modalProps)));
};

var DiscoveryInstructions = function DiscoveryInstructions(_ref) {
  var _ref$isSingleNodeClus = _ref.isSingleNodeCluster,
      isSingleNodeCluster = _ref$isSingleNodeClus === void 0 ? false : _ref$isSingleNodeClus;
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h3"
  }, "Instructions"), /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, "Generate a Discovery ISO and use a bootable device (local Disk, USB drive, etc.) or network booting (PXE) to ", /*#__PURE__*/React__default.createElement("b", null, "boot once"), " your ", "" + (isSingleNodeCluster ? 'machine' : 'machines'), ' ', "from it on hardware that should become part of this OCP cluster.", /*#__PURE__*/React__default.createElement("br", null), "Hosts connected to the internet with a valid IP address will appear in the table below."));
};

var GROUP_NAME = 'imageType';

var DiscoveryImageTypeControlGroupLabel = function DiscoveryImageTypeControlGroupLabel(_ref) {
  var text = _ref.text,
      popoverContent = _ref.popoverContent;
  return /*#__PURE__*/React__default.createElement(Fragment, null, text, /*#__PURE__*/React__default.createElement(PopoverIcon, {
    component: 'a',
    variant: 'plain',
    IconComponent: HelpIcon,
    bodyContent: popoverContent,
    noVerticalAlign: true
  }));
};

var DiscoveryImageTypeControlGroup = function DiscoveryImageTypeControlGroup() {
  return /*#__PURE__*/React__default.createElement(Stack, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(RadioField, {
    name: GROUP_NAME,
    id: 'full-iso',
    value: 'full-iso',
    label: /*#__PURE__*/React__default.createElement(DiscoveryImageTypeControlGroupLabel, {
      text: 'Full image file: Provision with physical media',
      popoverContent: 'The generated discovery ISO will contain the full image file'
    })
  })), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(RadioField, {
    name: GROUP_NAME,
    id: 'minimal-iso',
    value: 'minimal-iso',
    label: /*#__PURE__*/React__default.createElement(DiscoveryImageTypeControlGroupLabel, {
      text: 'Minimal image file: Provision with virtual media',
      popoverContent: 'The generated discovery ISO will contain the minimal image file'
    })
  })));
};

var validationSchema$2 = lazy(function (values) {
  return object().shape({
    sshPublicKey: sshPublicKeyValidationSchema,
    httpProxy: httpProxyValidationSchema(values, 'httpsProxy'),
    httpsProxy: httpProxyValidationSchema(values, 'httpProxy'),
    noProxy: noProxyValidationSchema
  });
});

var DiscoveryImageForm = function DiscoveryImageForm(_ref) {
  var cluster = _ref.cluster,
      onCancel = _ref.onCancel,
      onSuccess = _ref.onSuccess;
  var cancelSourceRef = React__default.useRef();
  var sshPublicKey = cluster.imageInfo.sshPublicKey;
  var dispatch = useDispatch();
  var ocmPullSecret = usePullSecretFetch();
  React__default.useEffect(function () {
    cancelSourceRef.current = axios.CancelToken.source();
    return function () {
      var _cancelSourceRef$curr;

      return (_cancelSourceRef$curr = cancelSourceRef.current) === null || _cancelSourceRef$curr === void 0 ? void 0 : _cancelSourceRef$curr.cancel('Image generation cancelled by user.');
    };
  }, []);

  var handleCancel = function handleCancel() {
    dispatch(forceReload());
    onCancel();
  };

  var handleSubmit = function handleSubmit(values, formikActions) {
    try {
      var _temp3 = function () {
        if (cluster.id) {
          var _temp4 = _catch(function () {
            var proxyParams = {
              httpProxy: values.httpProxy,
              httpsProxy: values.httpsProxy,
              noProxy: values.noProxy,
              pullSecret: cluster.kind === 'AddHostsCluster' && ocmPullSecret ? ocmPullSecret : undefined
            };
            return Promise.resolve(patchCluster(cluster.id, proxyParams)).then(function () {
              var _cancelSourceRef$curr2;

              var imageCreateParams = {
                sshPublicKey: values.sshPublicKey,
                imageType: values.imageType
              };
              return Promise.resolve(createClusterDownloadsImage(cluster.id, imageCreateParams, {
                cancelToken: (_cancelSourceRef$curr2 = cancelSourceRef.current) === null || _cancelSourceRef$curr2 === void 0 ? void 0 : _cancelSourceRef$curr2.token
              })).then(function (_ref2) {
                var updatedCluster = _ref2.data;
                onSuccess(updatedCluster.imageInfo);
                dispatch(updateCluster(updatedCluster));
              });
            });
          }, function (error) {
            handleApiError(error, function () {
              formikActions.setStatus({
                error: {
                  title: 'Failed to download the discovery Image',
                  message: getErrorMessage(error)
                }
              });
            });
          });

          if (_temp4 && _temp4.then) return _temp4.then(function () {});
        }
      }();

      return Promise.resolve(_temp3 && _temp3.then ? _temp3.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var initialValues = {
    sshPublicKey: sshPublicKey || '',
    httpProxy: cluster.httpProxy || '',
    httpsProxy: cluster.httpsProxy || '',
    noProxy: cluster.noProxy || '',
    enableProxy: !!(cluster.httpProxy || cluster.httpsProxy || cluster.noProxy),
    imageType: cluster.imageInfo.type || 'full-iso'
  };
  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    initialStatus: {
      error: null
    },
    validationSchema: validationSchema$2,
    onSubmit: handleSubmit
  }, function (_ref3) {
    var submitForm = _ref3.submitForm,
        isSubmitting = _ref3.isSubmitting,
        status = _ref3.status,
        setStatus = _ref3.setStatus;
    return isSubmitting ? /*#__PURE__*/React__default.createElement(LoadingState, {
      content: "Discovery image is being prepared, this might take a few seconds.",
      secondaryActions: [/*#__PURE__*/React__default.createElement(Button, {
        key: "close",
        variant: ButtonVariant.secondary,
        onClick: handleCancel
      }, "Cancel")]
    }) : /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ModalBoxBody, null, /*#__PURE__*/React__default.createElement(Form, null, status.error && /*#__PURE__*/React__default.createElement(Alert, {
      variant: AlertVariant.danger,
      title: status.error.title,
      actionClose: /*#__PURE__*/React__default.createElement(AlertActionCloseButton, {
        onClose: function onClose() {
          return setStatus({
            error: null
          });
        }
      }),
      isInline: true
    }, status.error.message), /*#__PURE__*/React__default.createElement(DiscoveryImageTypeControlGroup, null), /*#__PURE__*/React__default.createElement(UploadSSH, null), /*#__PURE__*/React__default.createElement(ProxyFields, null))), /*#__PURE__*/React__default.createElement(ModalBoxFooter, null, /*#__PURE__*/React__default.createElement(Button, {
      key: "submit",
      onClick: submitForm
    }, "Generate Discovery ISO"), /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: "link",
      onClick: onCancel
    }, "Cancel")));
  });
};

var DiscoveryImageSummary = function DiscoveryImageSummary(_ref) {
  var cluster = _ref.cluster,
      imageInfo = _ref.imageInfo,
      restProps = _objectWithoutPropertiesLoose(_ref, ["cluster", "imageInfo"]);

  var isoPath = getClusterDownloadsImageUrl(cluster.id);
  var isoUrl = "" + window.location.origin + isoPath;
  var downloadUrl = imageInfo.downloadUrl || isoUrl;
  return /*#__PURE__*/React__default.createElement(DownloadIso, _extends({
    fileName: "discovery_image_" + cluster.name + ".iso",
    downloadUrl: downloadUrl
  }, restProps));
};

var DiscoveryImageModalButton = function DiscoveryImageModalButton(_ref) {
  var _ref$ButtonComponent = _ref.ButtonComponent,
      ButtonComponent = _ref$ButtonComponent === void 0 ? Button : _ref$ButtonComponent,
      cluster = _ref.cluster,
      idPrefix = _ref.idPrefix;

  var _useModalDialogsConte = useModalDialogsContext(),
      discoveryImageDialog = _useModalDialogsConte.discoveryImageDialog;

  var open = discoveryImageDialog.open;
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ButtonComponent, {
    variant: ButtonVariant.secondary,
    onClick: function onClick() {
      return open({
        cluster: cluster
      });
    },
    id: idPrefix + "-button-download-discovery-iso"
  }, "Generate Discovery ISO"));
};
var DiscoveryImageModal = function DiscoveryImageModal() {
  var _React$useState = React__default.useState(),
      imageInfo = _React$useState[0],
      setImageInfo = _React$useState[1];

  var _useModalDialogsConte2 = useModalDialogsContext(),
      discoveryImageDialog = _useModalDialogsConte2.discoveryImageDialog;

  var data = discoveryImageDialog.data,
      isOpen = discoveryImageDialog.isOpen,
      close = discoveryImageDialog.close;
  var cluster = data === null || data === void 0 ? void 0 : data.cluster;

  if (!cluster) {
    return null;
  }

  return /*#__PURE__*/React__default.createElement(Modal, {
    "aria-label": "Generate Discovery ISO dialog",
    title: "Generate Discovery ISO",
    isOpen: isOpen,
    onClose: close,
    variant: ModalVariant.small,
    hasNoBodyWrapper: true,
    id: "generate-discovery-iso-modal"
  }, imageInfo ? /*#__PURE__*/React__default.createElement(DiscoveryImageSummary, {
    cluster: cluster,
    imageInfo: imageInfo,
    onClose: close,
    onReset: function onReset() {
      return setImageInfo(undefined);
    }
  }) : /*#__PURE__*/React__default.createElement(DiscoveryImageForm, {
    cluster: cluster,
    onCancel: close,
    onSuccess: function onSuccess(imageInfo) {
      return setImageInfo(imageInfo);
    }
  }));
};

var HostRequirementsModal = function HostRequirementsModal(_ref) {
  var setHostRequirementsOpen = _ref.setHostRequirementsOpen,
      isOpen = _ref.isOpen,
      ContentComponent = _ref.ContentComponent,
      clusterId = _ref.clusterId;
  var onClose = React__default.useCallback(function () {
    return setHostRequirementsOpen(false);
  }, [setHostRequirementsOpen]);
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "Minimum hardware requirements",
    isOpen: isOpen,
    actions: [/*#__PURE__*/React__default.createElement(Button, {
      key: "close",
      variant: ButtonVariant.primary,
      onClick: onClose
    }, "Close")],
    onClose: onClose,
    variant: ModalVariant.medium
  }, /*#__PURE__*/React__default.createElement(ContentComponent, {
    clusterId: clusterId
  }));
};

var HostRequirementsLink = function HostRequirementsLink(props) {
  var _React$useState = React__default.useState(false),
      isHostRequirementsOpen = _React$useState[0],
      setHostRequirementsOpen = _React$useState[1];

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    onClick: function onClick() {
      return setHostRequirementsOpen(true);
    },
    isInline: true,
    className: "host-requirements-link"
  }, /*#__PURE__*/React__default.createElement(InfoCircleIcon, {
    size: "sm"
  }), "\xA0Minimum hardware requirements"), /*#__PURE__*/React__default.createElement(HostRequirementsModal, _extends({}, props, {
    isOpen: isHostRequirementsOpen,
    setHostRequirementsOpen: setHostRequirementsOpen
  })));
};

var Hint = function Hint() {
  return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "Your libvirt virtual machines should be configured to restart automatically after a reboot. You can check this by running:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "virsh dumpxml <name> | grep on_reboot"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "And verify that this is the output:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "<on_reboot>restart</on_reboot>"
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "If not, please start your VMs with the following configuration:"), /*#__PURE__*/React__default.createElement(PrismCode, {
    code: "--events on_reboot=restart"
  }));
};

var VMRebootConfigurationInfo = function VMRebootConfigurationInfo(_ref) {
  var hosts = _ref.hosts;
  var isVM = React__default.useMemo(function () {
    return !!hosts.find(function (host) {
      var _inventory$systemVend;

      var inventory = stringToJSON(host.inventory || '') || {};
      return (_inventory$systemVend = inventory.systemVendor) === null || _inventory$systemVend === void 0 ? void 0 : _inventory$systemVend.virtual;
    });
  }, [hosts]);
  return isVM ? /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, /*#__PURE__*/React__default.createElement(Popover, {
    bodyContent: /*#__PURE__*/React__default.createElement(Hint, null),
    minWidth: "30rem"
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true
  }, /*#__PURE__*/React__default.createElement(InfoCircleIcon, {
    size: "sm"
  }), "\xA0Check your VM reboot configuration"))) : null;
};

var Hint$1 = function Hint() {
  return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: TextVariants.p
  }, "All non-installation disks will be used for local storage. To view available disks, expand each host row in the table"));
};

var OCSDisksManualFormattingHint = function OCSDisksManualFormattingHint() {
  var _useFormikContext = useFormikContext(),
      values = _useFormikContext.values;

  return values.useExtraDisksForLocalStorage ? /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, /*#__PURE__*/React__default.createElement(Popover, {
    bodyContent: /*#__PURE__*/React__default.createElement(Hint$1, null),
    minWidth: "30rem"
  }, /*#__PURE__*/React__default.createElement(Button, {
    variant: ButtonVariant.link,
    isInline: true
  }, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
    className: "status-icon",
    color: global_warning_color_100$1.value,
    size: "sm"
  }), "\xA0Format all non-installation disks"))) : null;
};

var FormatDiskWarning = function FormatDiskWarning() {
  return /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
    className: "status-icon",
    color: global_warning_color_100.value,
    size: "sm"
  }), "\xA0All bootable disks will be formatted during installation");
};

var InformationAndAlerts = function InformationAndAlerts(_ref) {
  var cluster = _ref.cluster,
      HostRequirementsContent = _ref.HostRequirementsContent,
      setDiscoveryHintModalOpen = _ref.setDiscoveryHintModalOpen;
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h3"
  }, "Information and warnings"), /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, /*#__PURE__*/React__default.createElement(HostRequirementsLink, {
    clusterId: cluster.id,
    ContentComponent: HostRequirementsContent
  }), /*#__PURE__*/React__default.createElement(HostsNotShowingLink, {
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/React__default.createElement(VMRebootConfigurationInfo, {
    hosts: cluster.hosts || []
  }), !isAddHostsCluster(cluster) && /*#__PURE__*/React__default.createElement(OCSDisksManualFormattingHint, null), /*#__PURE__*/React__default.createElement(FormatDiskWarning, null));
};

var addAlert = alertsSlice.actions.addAlert;

var useClusterPreflightRequirements = function useClusterPreflightRequirements(clusterId) {
  var _React$useState = React__default.useState(),
      preflightRequirements = _React$useState[0],
      setPreflightRequirements = _React$useState[1];

  var _React$useState2 = React__default.useState(),
      error = _React$useState2[0],
      setError = _React$useState2[1];

  React__default.useEffect(function () {
    var fetchFunc = function fetchFunc() {
      try {
        var _temp2 = _catch(function () {
          return Promise.resolve(getClusterPreflightRequirements(clusterId)).then(function (_ref) {
            var data = _ref.data;
            setPreflightRequirements(data);
          });
        }, function (e) {
          setError(e);
          handleApiError(e, function () {
            return addAlert({
              title: 'Failed to retrieve preflight cluster requirements',
              message: getErrorMessage(e)
            });
          });
        });

        return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
      } catch (e) {
        return Promise.reject(e);
      }
    };

    fetchFunc();
  }, [setPreflightRequirements, setError, clusterId]);
  return {
    preflightRequirements: preflightRequirements,
    error: error,
    isLoading: !error && !preflightRequirements
  };
};

var AddHostRequirementsContent = function AddHostRequirementsContent(_ref2) {
  var _preflightRequirement, _preflightRequirement2;

  var clusterId = _ref2.clusterId;

  var _useClusterPreflightR = useClusterPreflightRequirements(clusterId),
      preflightRequirements = _useClusterPreflightR.preflightRequirements,
      error = _useClusterPreflightR.error,
      isLoading = _useClusterPreflightR.isLoading;

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(LoadingState, {
      content: "Loading hardware requirements ..."
    });
  }

  if (error) {
    return /*#__PURE__*/React__default.createElement(ErrorState, null);
  }

  var worker = preflightRequirements === null || preflightRequirements === void 0 ? void 0 : (_preflightRequirement = preflightRequirements.ocp) === null || _preflightRequirement === void 0 ? void 0 : (_preflightRequirement2 = _preflightRequirement.worker) === null || _preflightRequirement2 === void 0 ? void 0 : _preflightRequirement2.quantitative;
  var workerRam = fileSize(((worker === null || worker === void 0 ? void 0 : worker.ramMib) || 8 * 1024) * 1024 * 1024, 2, 'iec');
  return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, "Worker hosts must have at least ", (worker === null || worker === void 0 ? void 0 : worker.cpuCores) || 2, " CPU cores, ", workerRam, " of RAM, and", ' ', (worker === null || worker === void 0 ? void 0 : worker.diskSizeGb) || 120, " GB of filesystem storage."));
};
var HostRequirementsContent = function HostRequirementsContent(_ref3) {
  var _preflightRequirement3, _preflightRequirement4, _preflightRequirement5, _preflightRequirement6;

  var clusterId = _ref3.clusterId;

  var _useClusterPreflightR2 = useClusterPreflightRequirements(clusterId),
      preflightRequirements = _useClusterPreflightR2.preflightRequirements,
      error = _useClusterPreflightR2.error,
      isLoading = _useClusterPreflightR2.isLoading;

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(LoadingState, {
      content: "Loading hardware requirements ..."
    });
  }

  if (error) {
    return /*#__PURE__*/React__default.createElement(ErrorState, null);
  }

  var master = preflightRequirements === null || preflightRequirements === void 0 ? void 0 : (_preflightRequirement3 = preflightRequirements.ocp) === null || _preflightRequirement3 === void 0 ? void 0 : (_preflightRequirement4 = _preflightRequirement3.master) === null || _preflightRequirement4 === void 0 ? void 0 : _preflightRequirement4.quantitative;
  var worker = preflightRequirements === null || preflightRequirements === void 0 ? void 0 : (_preflightRequirement5 = preflightRequirements.ocp) === null || _preflightRequirement5 === void 0 ? void 0 : (_preflightRequirement6 = _preflightRequirement5.worker) === null || _preflightRequirement6 === void 0 ? void 0 : _preflightRequirement6.quantitative;
  return /*#__PURE__*/React__default.createElement(HostRequirements, {
    master: master,
    worker: worker
  });
};
var SingleHostRequirementsContent = function SingleHostRequirementsContent(_ref4) {
  var _preflightRequirement7, _preflightRequirement8;

  var clusterId = _ref4.clusterId;

  var _useClusterPreflightR3 = useClusterPreflightRequirements(clusterId),
      preflightRequirements = _useClusterPreflightR3.preflightRequirements,
      error = _useClusterPreflightR3.error,
      isLoading = _useClusterPreflightR3.isLoading;

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(LoadingState, {
      content: "Loading hardware requirements ..."
    });
  }

  if (error) {
    return /*#__PURE__*/React__default.createElement(ErrorState, null);
  }

  var master = preflightRequirements === null || preflightRequirements === void 0 ? void 0 : (_preflightRequirement7 = preflightRequirements.ocp) === null || _preflightRequirement7 === void 0 ? void 0 : (_preflightRequirement8 = _preflightRequirement7.master) === null || _preflightRequirement8 === void 0 ? void 0 : _preflightRequirement8.quantitative;
  var masterRam = fileSize(((master === null || master === void 0 ? void 0 : master.ramMib) || 16 * 1024) * 1024 * 1024, 2, 'iec');
  return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, "One host is required with at least ", (master === null || master === void 0 ? void 0 : master.cpuCores) || 4, " CPU cores, ", masterRam, " of RAM, and ", (master === null || master === void 0 ? void 0 : master.diskSizeGb) || 120, " GB of filesystem storage."));
};
var CNVHostRequirementsContent = function CNVHostRequirementsContent(_ref5) {
  var _preflightRequirement9, _cnvRequirements$requ, _cnvRequirements$requ2, _cnvRequirements$requ3, _cnvRequirements$requ4;

  var clusterId = _ref5.clusterId,
      _ref5$isSingleNode = _ref5.isSingleNode,
      isSingleNode = _ref5$isSingleNode === void 0 ? false : _ref5$isSingleNode;

  var _useClusterPreflightR4 = useClusterPreflightRequirements(clusterId),
      preflightRequirements = _useClusterPreflightR4.preflightRequirements,
      error = _useClusterPreflightR4.error,
      isLoading = _useClusterPreflightR4.isLoading;

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(LoadingState, {
      content: "Loading hardware requirements ..."
    });
  }

  if (error) {
    return /*#__PURE__*/React__default.createElement(ErrorState, null);
  }

  var cnvRequirements = preflightRequirements === null || preflightRequirements === void 0 ? void 0 : (_preflightRequirement9 = preflightRequirements.operators) === null || _preflightRequirement9 === void 0 ? void 0 : _preflightRequirement9.find(function (operatorRequirements) {
    return operatorRequirements.operatorName === OPERATOR_NAME_CNV;
  });
  var workerRequirements = cnvRequirements === null || cnvRequirements === void 0 ? void 0 : (_cnvRequirements$requ = cnvRequirements.requirements) === null || _cnvRequirements$requ === void 0 ? void 0 : (_cnvRequirements$requ2 = _cnvRequirements$requ.worker) === null || _cnvRequirements$requ2 === void 0 ? void 0 : _cnvRequirements$requ2.quantitative;
  var masterRequirements = cnvRequirements === null || cnvRequirements === void 0 ? void 0 : (_cnvRequirements$requ3 = cnvRequirements.requirements) === null || _cnvRequirements$requ3 === void 0 ? void 0 : (_cnvRequirements$requ4 = _cnvRequirements$requ3.master) === null || _cnvRequirements$requ4 === void 0 ? void 0 : _cnvRequirements$requ4.quantitative;
  return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(List, null, /*#__PURE__*/React__default.createElement(ListItem$1, null, "Enabled CPU virtualization support in BIOS (Intel-VT / AMD-V) on all nodes"), /*#__PURE__*/React__default.createElement(RenderIf, {
    condition: !isSingleNode
  }, /*#__PURE__*/React__default.createElement(ListItem$1, null, "Each worker node requires an additional ", (workerRequirements === null || workerRequirements === void 0 ? void 0 : workerRequirements.ramMib) || 360, " MiB of memory ", (workerRequirements === null || workerRequirements === void 0 ? void 0 : workerRequirements.diskSizeGb) ? ',' : ' and', ' ', (workerRequirements === null || workerRequirements === void 0 ? void 0 : workerRequirements.cpuCores) || 2, " CPUs", (workerRequirements === null || workerRequirements === void 0 ? void 0 : workerRequirements.diskSizeGb) ? " and " + (workerRequirements === null || workerRequirements === void 0 ? void 0 : workerRequirements.diskSizeGb) + " storage space" : '')), /*#__PURE__*/React__default.createElement(ListItem$1, null, "Each supervisor node requires an additional ", (masterRequirements === null || masterRequirements === void 0 ? void 0 : masterRequirements.ramMib) || 150, " MiB of memory ", (masterRequirements === null || masterRequirements === void 0 ? void 0 : masterRequirements.diskSizeGb) ? ',' : ' and', " ", (masterRequirements === null || masterRequirements === void 0 ? void 0 : masterRequirements.cpuCores) || 4, ' ', "CPUs", (masterRequirements === null || masterRequirements === void 0 ? void 0 : masterRequirements.diskSizeGb) ? " and " + (masterRequirements === null || masterRequirements === void 0 ? void 0 : masterRequirements.diskSizeGb) + " storage space" : ''), /*#__PURE__*/React__default.createElement(ListItem$1, null, "OpenShift Data Foundation (recommended for full functionality) or another persistent storage service")));
};

var fetcher = function fetcher(url) {
  return client.get(url).then(function (res) {
    return res.data;
  });
};

var useClusterSupportedPlatforms = function useClusterSupportedPlatforms(clusterId) {
  var _ref;

  var _useSWR = useSWR("/v2/clusters/" + clusterId + "/supported-platforms", fetcher, {
    refreshInterval: POLLING_INTERVAL
  }),
      data = _useSWR.data,
      error = _useSWR.error;

  if (error) {
    handleApiError(error, function () {
      return alertsSlice.actions.addAlert({
        title: "Failed to retrieve supported platforms (clusterId: " + clusterId + ")",
        message: getErrorMessage(error)
      });
    });
  }

  var isLoading = !error && !data;
  var isPlatformIntegrationSupported = ((_ref = (data === null || data === void 0 ? void 0 : data.filter(function (platform) {
    return platform !== 'baremetal';
  })) || []) === null || _ref === void 0 ? void 0 : _ref.length) > 0;
  return {
    isPlatformIntegrationSupported: isPlatformIntegrationSupported,
    isLoading: isLoading,
    error: error
  };
};

var OCSLabel = function OCSLabel() {
  return /*#__PURE__*/React__default.createElement(Fragment, null, "Install OpenShift Container Storage");
};

var CNVLabel = function CNVLabel(_ref) {
  var clusterId = _ref.clusterId,
      isSingleNode = _ref.isSingleNode;
  return /*#__PURE__*/React__default.createElement(Fragment, null, "Install OpenShift Virtualization", ' ', /*#__PURE__*/React__default.createElement(PopoverIcon, {
    component: 'a',
    variant: 'plain',
    IconComponent: HelpIcon,
    minWidth: "50rem",
    headerContent: "Additional Requirements",
    bodyContent: /*#__PURE__*/React__default.createElement(CNVHostRequirementsContent, {
      clusterId: clusterId,
      isSingleNode: isSingleNode
    })
  }));
};

var PlatformIntegrationLabel = function PlatformIntegrationLabel(_ref2) {
  var _ref2$isTooltipHidden = _ref2.isTooltipHidden,
      isTooltipHidden = _ref2$isTooltipHidden === void 0 ? false : _ref2$isTooltipHidden;
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(Tooltip, {
    hidden: isTooltipHidden,
    content: 'Platform integration is applicable only when all discovered hosts are from the same platform'
  }, /*#__PURE__*/React__default.createElement("span", null, "Integrate with platform")), ' ', /*#__PURE__*/React__default.createElement(PopoverIcon, {
    variant: 'plain',
    bodyContent: /*#__PURE__*/React__default.createElement("p", null, "Enable platform integration to access your platform's features directly in OpenShift.", /*#__PURE__*/React__default.createElement("br", null), /*#__PURE__*/React__default.createElement("strong", null, "Note:"), " You will need to modify your platform configuration after cluster installation is completed.")
  }));
};

var HostInventory = function HostInventory(_ref3) {
  var _cluster$platform;

  var cluster = _ref3.cluster;

  var _React$useState = React__default.useState(false),
      isDiscoveryHintModalOpen = _React$useState[0],
      setDiscoveryHintModalOpen = _React$useState[1];

  var _useClusterSupportedP = useClusterSupportedPlatforms(cluster.id),
      isPlatformIntegrationSupported = _useClusterSupportedP.isPlatformIntegrationSupported;

  var isPlatformIntegrationFeatureEnabled = useFeature('ASSISTED_INSTALLER_PLATFORM_INTEGRATION_FEATURE');
  var isOpenshiftClusterStorageEnabled = useFeature('ASSISTED_INSTALLER_OCS_FEATURE');
  var isContainerNativeVirtualizationEnabled = useFeature('ASSISTED_INSTALLER_CNV_FEATURE');
  var isSNO = isSingleNodeCluster(cluster);
  return /*#__PURE__*/React__default.createElement(Stack, {
    hasGutter: true
  }, /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(ClusterWizardStepHeader, {
    extraItems: /*#__PURE__*/React__default.createElement(ClusterWizardHeaderExtraActions, {
      cluster: cluster
    })
  }, "Host discovery")), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(DiscoveryInstructions, {
    isSingleNodeCluster: isSNO
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, /*#__PURE__*/React__default.createElement(DiscoveryImageModalButton, {
    ButtonComponent: Button,
    cluster: cluster,
    idPrefix: "host-inventory"
  })))), /*#__PURE__*/React__default.createElement(StackItem, null, isContainerNativeVirtualizationEnabled && /*#__PURE__*/React__default.createElement(CheckboxField, {
    name: "useContainerNativeVirtualization",
    label: /*#__PURE__*/React__default.createElement(CNVLabel, {
      clusterId: cluster.id,
      isSingleNode: isSNO
    }),
    helperText: "Run virtual machines along containers."
  })), /*#__PURE__*/React__default.createElement(StackItem, null, isOpenshiftClusterStorageEnabled && !isSNO && /*#__PURE__*/React__default.createElement(CheckboxField, {
    name: "useExtraDisksForLocalStorage",
    label: /*#__PURE__*/React__default.createElement(OCSLabel, null),
    helperText: "Persistent software-defined storage for hybrid applications."
  })), /*#__PURE__*/React__default.createElement(StackItem, null, isPlatformIntegrationFeatureEnabled && /*#__PURE__*/React__default.createElement(SwitchField, {
    isDisabled: !isPlatformIntegrationSupported && (cluster === null || cluster === void 0 ? void 0 : (_cluster$platform = cluster.platform) === null || _cluster$platform === void 0 ? void 0 : _cluster$platform.type) === 'baremetal',
    name: 'usePlatformIntegration',
    label: /*#__PURE__*/React__default.createElement(PlatformIntegrationLabel, {
      isTooltipHidden: isPlatformIntegrationSupported
    })
  })), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(InformationAndAlerts, {
    cluster: cluster,
    HostRequirementsContent: isSNO ? SingleHostRequirementsContent : HostRequirementsContent,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  }))), /*#__PURE__*/React__default.createElement(StackItem, null, /*#__PURE__*/React__default.createElement(HostsDiscoveryTable, {
    cluster: cluster,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/React__default.createElement(DiscoveryTroubleshootingModal, {
    isOpen: isDiscoveryHintModalOpen,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  }));
};

var setPlatform = function setPlatform(params, usePlatformIntegration) {
  if (usePlatformIntegration) {
    params.platform = {
      type: 'vsphere',
      vsphere: {}
    };
  } else {
    params.platform = {
      type: 'baremetal'
    };
  }
};

var setOLMOperators = function setOLMOperators(params, values, monitoredOperators) {
  if (monitoredOperators === void 0) {
    monitoredOperators = [];
  }

  var enabledOlmOperatorsByName = getOlmOperatorCreateParamsByName(monitoredOperators);

  var setOperator = function setOperator(name, enabled) {
    if (enabled) {
      enabledOlmOperatorsByName[name] = {
        name: name
      };
    } else {
      delete enabledOlmOperatorsByName[name];
    }
  };

  setOperator(OPERATOR_NAME_CNV, values.useContainerNativeVirtualization);
  setOperator(OPERATOR_NAME_OCS, values.useExtraDisksForLocalStorage);

  if (!values.useExtraDisksForLocalStorage && !values.useContainerNativeVirtualization) {
    setOperator(OPERATOR_NAME_LSO, false);
  }

  params.olmOperators = Object.values(enabledOlmOperatorsByName);
};

var HostDiscovery = function HostDiscovery(_ref) {
  var cluster = _ref.cluster;
  var dispatch = useDispatch();

  var _React$useContext = React__default.useContext(ClusterWizardContext),
      setCurrentStepId = _React$useContext.setCurrentStepId;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert,
      clearAlerts = _useAlerts.clearAlerts;

  var initialValues = React__default.useMemo(function () {
    return getHostDiscoveryInitialValues(cluster);
  }, []);

  var handleSubmit = function handleSubmit(values, actions) {
    try {
      clearAlerts();
      var params = {};
      setPlatform(params, values.usePlatformIntegration);
      setOLMOperators(params, values, cluster.monitoredOperators);

      var _temp2 = _catch(function () {
        return Promise.resolve(patchCluster(cluster.id, params)).then(function (_ref2) {
          var data = _ref2.data;
          dispatch(updateCluster(data));
          actions.resetForm({
            values: getHostDiscoveryInitialValues(data)
          });
        });
      }, function (e) {
        handleApiError(e, function () {
          return addAlert({
            title: 'Failed to update the cluster',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(Formik, {
    initialValues: initialValues,
    onSubmit: handleSubmit
  }, function (_ref3) {
    var isSubmitting = _ref3.isSubmitting,
        dirty = _ref3.dirty,
        errors = _ref3.errors,
        touched = _ref3.touched;
    var errorFields = getFormikErrorFields(errors, touched);
    var footer = /*#__PURE__*/React__default.createElement(ClusterWizardFooter, {
      cluster: cluster,
      errorFields: errorFields,
      isSubmitting: isSubmitting,
      isNextDisabled: dirty || !canNextHostDiscovery({
        cluster: cluster
      }),
      onNext: function onNext() {
        return setCurrentStepId('networking');
      },
      onBack: function onBack() {
        return setCurrentStepId('cluster-details');
      }
    });
    return /*#__PURE__*/React__default.createElement(ClusterWizardStep, {
      navigation: /*#__PURE__*/React__default.createElement(ClusterWizardNavigation, {
        cluster: cluster
      }),
      footer: footer
    }, /*#__PURE__*/React__default.createElement(HostInventory, {
      cluster: cluster
    }), /*#__PURE__*/React__default.createElement(FormikAutoSave, null));
  });
};

var ClusterWizard = function ClusterWizard(_ref) {
  var cluster = _ref.cluster;

  var _React$useState = React__default.useState(function () {
    return getClusterWizardFirstStep(cluster.status);
  }),
      currentStepId = _React$useState[0],
      setCurrentStepId = _React$useState[1];

  var renderCurrentStep = React__default.useCallback(function () {
    switch (currentStepId) {
      case 'host-discovery':
        return /*#__PURE__*/React__default.createElement(HostDiscovery, {
          cluster: cluster
        });

      case 'networking':
        return /*#__PURE__*/React__default.createElement(NetworkConfigurationForm, {
          cluster: cluster
        });

      case 'review':
        return /*#__PURE__*/React__default.createElement(ReviewStep, {
          cluster: cluster
        });

      case 'cluster-details':
      default:
        return /*#__PURE__*/React__default.createElement(ClusterDetails, {
          cluster: cluster
        });
    }
  }, [currentStepId, cluster]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterWizardContext.Provider, {
    value: {
      currentStepId: currentStepId,
      setCurrentStepId: setCurrentStepId
    }
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "pf-c-wizard cluster-wizard"
  }, renderCurrentStep())));
};

var CancelInstallationModal = function CancelInstallationModal() {
  var dispatch = useDispatch();

  var _React$useState = React__default.useState(false),
      isSubmitting = _React$useState[0],
      setIsSubmitting = _React$useState[1];

  var _React$useState2 = React__default.useState(null),
      error = _React$useState2[0],
      setError = _React$useState2[1];

  var _useModalDialogsConte = useModalDialogsContext(),
      cancelInstallationDialog = _useModalDialogsConte.cancelInstallationDialog;

  var data = cancelInstallationDialog.data,
      isOpen = cancelInstallationDialog.isOpen,
      onClose = cancelInstallationDialog.close;
  var clusterId = data === null || data === void 0 ? void 0 : data.clusterId;

  if (!clusterId) {
    return null;
  }

  var handleSubmit = function handleSubmit() {
    try {
      var _temp3 = function _temp3() {
        setIsSubmitting(false);
      };

      setIsSubmitting(true);

      var _temp4 = _catch(function () {
        setError(null);
        return Promise.resolve(postCancelInstallation(clusterId)).then(function (_ref) {
          var data = _ref.data;
          dispatch(updateCluster(data));
          onClose();
        });
      }, function (e) {
        handleApiError(e, function () {
          setError({
            title: 'Failed to abort cluster installation',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp4 && _temp4.then ? _temp4.then(_temp3) : _temp3(_temp4));
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var getModalContent = function getModalContent() {
    if (isSubmitting) {
      return /*#__PURE__*/React__default.createElement(LoadingState, {
        content: "Aborting cluster installation..."
      });
    }

    if (error) {
      return /*#__PURE__*/React__default.createElement(ErrorState, {
        title: error.title,
        content: error.message
      });
    }

    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
      component: "p"
    }, "This will abort cluster installation. Are you sure you want to proceed?"));
  };

  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "Abort Cluster Installation",
    isOpen: isOpen,
    variant: ModalVariant.small,
    actions: [/*#__PURE__*/React__default.createElement(Button, {
      key: "submit",
      variant: ButtonVariant.danger,
      onClick: handleSubmit,
      isDisabled: isSubmitting
    }, "Abort Installation"), /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: ButtonVariant.link,
      onClick: onClose,
      isDisabled: isSubmitting
    }, "Cancel")],
    onClose: onClose
  }, getModalContent());
};

var ResetClusterModal = function ResetClusterModal() {
  var _cluster$hosts;

  var dispatch = useDispatch();

  var _React$useState = React__default.useState(false),
      isSubmitting = _React$useState[0],
      setIsSubmitting = _React$useState[1];

  var _React$useState2 = React__default.useState(null),
      error = _React$useState2[0],
      setError = _React$useState2[1];

  var _useModalDialogsConte = useModalDialogsContext(),
      resetClusterDialog = _useModalDialogsConte.resetClusterDialog;

  var data = resetClusterDialog.data,
      isOpen = resetClusterDialog.isOpen,
      onClose = resetClusterDialog.close;
  var cluster = data === null || data === void 0 ? void 0 : data.cluster;

  if (!cluster) {
    return null;
  }

  var handleClose = function handleClose() {
    setIsSubmitting(false);
    setError(null);
    onClose();
  };

  var handleReset = function handleReset() {
    try {
      var _temp3 = function _temp3() {
        setIsSubmitting(false);
      };

      setIsSubmitting(true);

      var _temp4 = _catch(function () {
        setError(null);
        return Promise.resolve(postResetCluster(cluster.id)).then(function (_ref) {
          var data = _ref.data;
          dispatch(updateCluster(data));
          onClose();
        });
      }, function (e) {
        handleApiError(e, function () {
          setError({
            title: 'Failed to reset cluster installation',
            message: getErrorMessage(e)
          });
        });
      });

      return Promise.resolve(_temp4 && _temp4.then ? _temp4.then(_temp3) : _temp3(_temp4));
    } catch (e) {
      return Promise.reject(e);
    }
  };

  var collectedLogsPercentage = Math.round(calculateCollectedLogsCount(cluster) / ((((_cluster$hosts = cluster.hosts) === null || _cluster$hosts === void 0 ? void 0 : _cluster$hosts.length) || 0) + 1) * 100) + " ";

  var getModalContent = function getModalContent() {
    if (isSubmitting) {
      return /*#__PURE__*/React__default.createElement(LoadingState, {
        content: "Resetting cluster installation..."
      });
    }

    if (error) {
      return /*#__PURE__*/React__default.createElement(ErrorState, {
        title: error.title,
        content: error.message
      });
    }

    return /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
      component: "p"
    }, "This will reset the installation and return to the cluster configuration. Some hosts may need to be re-registered by rebooting into the Discovery ISO."), /*#__PURE__*/React__default.createElement(Text, {
      component: "p"
    }, /*#__PURE__*/React__default.createElement("strong", null, "Download the installation logs"), " to troubleshoot or report a bug.", /*#__PURE__*/React__default.createElement("br", null), "Currently, ", collectedLogsPercentage, "% of the installation logs were collected and are ready for download."), /*#__PURE__*/React__default.createElement(Text, {
      component: "p"
    }, /*#__PURE__*/React__default.createElement(ExclamationTriangleIcon, {
      className: "status-icon",
      color: global_warning_color_100.value,
      size: "sm"
    }), ' ', "Logs won't be available after the installation is reset."), /*#__PURE__*/React__default.createElement(Text, {
      component: "p"
    }, "Are you sure you want to reset the cluster?"));
  };

  var actions = [/*#__PURE__*/React__default.createElement(Button, {
    key: "reset",
    variant: ButtonVariant.danger,
    onClick: handleReset,
    isDisabled: isSubmitting
  }, "Reset Cluster")];
  actions.push( /*#__PURE__*/React__default.createElement(Button, {
    key: "cancel",
    variant: ButtonVariant.link,
    onClick: handleClose,
    isDisabled: isSubmitting
  }, "Cancel"));
  return /*#__PURE__*/React__default.createElement(Modal, {
    title: "Reset Cluster Installation",
    isOpen: isOpen,
    variant: ModalVariant.small,
    actions: actions,
    onClose: handleClose
  }, getModalContent());
};

var errorStateActions = [];

if (!isSingleClusterMode()) {
  errorStateActions.push( /*#__PURE__*/React__default.createElement(Button, {
    key: "cancel",
    variant: ButtonVariant.secondary,
    component: function component(props) {
      return /*#__PURE__*/React__default.createElement(Link, _extends({
        to: OCM_CLUSTER_LIST_LINK
      }, props));
    }
  }, "Back"));
}

var LoadingCard = function LoadingCard() {
  return /*#__PURE__*/React__default.createElement(Card, {
    "data-testid": "ai-cluster-details-card"
  }, /*#__PURE__*/React__default.createElement(CardHeader, null, /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h1",
    size: "lg",
    className: "card-title"
  }, "Loading additional details")), /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(LoadingState, null)));
};

var ClusterLoadFailed = function ClusterLoadFailed(_ref) {
  var fetchCluster = _ref.fetchCluster;
  return /*#__PURE__*/React__default.createElement(Card, {
    "data-testid": "ai-cluster-details-card"
  }, /*#__PURE__*/React__default.createElement(CardHeader, null, /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h1",
    size: "lg",
    className: "card-title"
  }, "Loading additional details")), /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(ErrorState, {
    title: "Failed to fetch the cluster",
    fetchData: fetchCluster,
    actions: errorStateActions
  })));
};

var LoadingDefaultConfigFailedCard = function LoadingDefaultConfigFailedCard() {
  return /*#__PURE__*/React__default.createElement(Card, {
    "data-testid": "ai-cluster-details-card"
  }, /*#__PURE__*/React__default.createElement(CardHeader, null, /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h1",
    size: "lg",
    className: "card-title"
  }, "Loading additional details")), /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(ErrorState, {
    title: "Failed to retrieve the default configuration",
    actions: errorStateActions
  })));
};

var AssistedInstallerDetailCard = function AssistedInstallerDetailCard(_ref2) {
  var aiClusterId = _ref2.aiClusterId;
  var fetchCluster = useFetchCluster(aiClusterId);

  var _useClusterPolling = useClusterPolling(aiClusterId),
      cluster = _useClusterPolling.cluster,
      uiState = _useClusterPolling.uiState;

  if (uiState === ResourceUIState.LOADING) {
    return /*#__PURE__*/React__default.createElement(LoadingCard, null);
  } else if (uiState === ResourceUIState.ERROR) {
    return /*#__PURE__*/React__default.createElement(ClusterLoadFailed, {
      fetchCluster: fetchCluster
    });
  }

  if (!cluster) {
    return null;
  }

  if (cluster.status === 'adding-hosts') {
    return null;
  }

  var content;

  if (['insufficient', 'ready', 'pending-for-input'].includes(cluster.status)) {
    content = /*#__PURE__*/React__default.createElement(ClusterWizard, {
      cluster: cluster
    });
  } else {
    content = /*#__PURE__*/React__default.createElement(ClusterInstallationProgressCard, {
      cluster: cluster
    });
  }

  return /*#__PURE__*/React__default.createElement(FeatureGateContextProvider, {
    features: {}
  }, /*#__PURE__*/React__default.createElement(AlertsContextProvider, null, /*#__PURE__*/React__default.createElement(ModalDialogsContextProvider, null, /*#__PURE__*/React__default.createElement(ClusterDefaultConfigurationProvider, {
    loadingUI: /*#__PURE__*/React__default.createElement(LoadingCard, null),
    errorUI: /*#__PURE__*/React__default.createElement(LoadingDefaultConfigFailedCard, null)
  }, content, /*#__PURE__*/React__default.createElement(CancelInstallationModal, null), /*#__PURE__*/React__default.createElement(ResetClusterModal, null), /*#__PURE__*/React__default.createElement(DiscoveryImageModal, null)))));
};

var Wrapper = function Wrapper(props) {
  return /*#__PURE__*/React__default.createElement(Provider, {
    store: store
  }, /*#__PURE__*/React__default.createElement(AssistedInstallerDetailCard, props));
};

var DeleteClusterModal = function DeleteClusterModal(_ref) {
  var name = _ref.name,
      onClose = _ref.onClose,
      onDelete = _ref.onDelete;
  return /*#__PURE__*/createElement(Modal, {
    title: "Delete cluster",
    isOpen: true,
    onClose: onClose,
    variant: ModalVariant.small,
    actions: [/*#__PURE__*/createElement(Button, {
      "data-testid": "delete-cluster-submit",
      key: "confirm",
      variant: "danger",
      onClick: onDelete
    }, "Delete"), /*#__PURE__*/createElement(Button, {
      key: "cancel",
      variant: "link",
      onClick: onClose
    }, "Cancel")]
  }, "Are you sure you want to delete cluster ", name, " ?");
};

var clusterStatusLabelUniqueValues = Array.from(new Set(Object.values(CLUSTER_STATUS_LABELS)));

var ClustersListToolbar = function ClustersListToolbar(_ref) {
  var searchString = _ref.searchString,
      setSearchString = _ref.setSearchString,
      filters = _ref.filters,
      setFilters = _ref.setFilters;

  var _React$useState = React__default.useState(false),
      isStatusExpanded = _React$useState[0],
      setStatusExpanded = _React$useState[1];

  var history = useHistory();
  var clustersUIState = useSelector(selectClustersUIState);
  var dispatch = useDispatch();
  var fetchClusters = React__default.useCallback(function () {
    return dispatch(fetchClustersAsync());
  }, [dispatch]);

  var onClearAllFilters = function onClearAllFilters() {
    setFilters({
      status: []
    });
  };

  var onSearchNameChanged = setSearchString;

  var onSelect = function onSelect(type, isChecked, value) {
    var _extends2;

    setFilters(_extends({}, filters, (_extends2 = {}, _extends2[type] = isChecked ? [].concat(filters[type], [value]) : filters[type].filter(function (v) {
      return v !== value;
    }), _extends2)));
  };

  var onStatusToggle = function onStatusToggle() {
    return setStatusExpanded(!isStatusExpanded);
  };

  var onStatusSelect = function onStatusSelect(event, value) {
    onSelect('status', event.target.checked, value);
  };

  var onDeleteChip = function onDeleteChip(type, id) {
    if (type) {
      var _extends3;

      setFilters(_extends({}, filters, (_extends3 = {}, _extends3[type] = filters[type].filter(function (v) {
        return v !== id;
      }), _extends3)));
    } else {
      onClearAllFilters();
    }
  };

  var onDeleteChipGroup = function onDeleteChipGroup(type) {
    var _extends4;

    setFilters(_extends({}, filters, (_extends4 = {}, _extends4[type] = [], _extends4)));
  };

  var statusPlaceholder = /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(FilterIcon, null), " Status");
  return /*#__PURE__*/React__default.createElement(Toolbar, {
    id: "clusters-list-toolbar",
    className: "pf-m-toggle-group-container",
    collapseListedFiltersBreakpoint: "xl",
    clearAllFilters: onClearAllFilters
  }, /*#__PURE__*/React__default.createElement(ToolbarContent, null, /*#__PURE__*/React__default.createElement(ToolbarItem, null, /*#__PURE__*/React__default.createElement(InputGroup, null, /*#__PURE__*/React__default.createElement(TextInput, {
    name: "search-string",
    id: "search-string",
    type: "search",
    "aria-label": "string to be searched in cluster names or ids",
    onChange: onSearchNameChanged,
    value: searchString,
    placeholder: "Filter by Name, ID or Base domain",
    title: "Filter by Name, ID or Base domain"
  }))), /*#__PURE__*/React__default.createElement(ToolbarFilter, {
    chips: filters.status,
    deleteChip: onDeleteChip,
    deleteChipGroup: onDeleteChipGroup,
    categoryName: "status"
  }, /*#__PURE__*/React__default.createElement(Select, {
    variant: "checkbox",
    "aria-label": "status",
    onToggle: onStatusToggle,
    onSelect: onStatusSelect,
    selections: filters.status,
    isOpen: isStatusExpanded,
    placeholderText: statusPlaceholder,
    toggleId: "cluster-list-filter-status"
  }, clusterStatusLabelUniqueValues.map(function (label) {
    return /*#__PURE__*/React__default.createElement(SelectOption, {
      key: label,
      value: label,
      inputId: "cluster-list-filter-status-" + label
    });
  }))), /*#__PURE__*/React__default.createElement(ToolbarButton, {
    variant: ButtonVariant.primary,
    onClick: function onClick() {
      return history.push(routeBasePath + "/clusters/~new");
    },
    id: "button-create-new-cluster",
    "data-ouia-id": "button-create-new-cluster"
  }, "Create Cluster"), clustersUIState === ResourceUIState.RELOADING && /*#__PURE__*/React__default.createElement(Spinner, {
    size: "lg"
  }), /*#__PURE__*/React__default.createElement(ToolbarGroup, {
    alignment: {
      lg: 'alignRight'
    }
  }, /*#__PURE__*/React__default.createElement(ToolbarButton, {
    variant: ButtonVariant.plain,
    onClick: function onClick() {
      return fetchClusters();
    },
    isDisabled: clustersUIState === ResourceUIState.RELOADING
  }, /*#__PURE__*/React__default.createElement(Tooltip, {
    content: "Refresh"
  }, /*#__PURE__*/React__default.createElement(SyncIcon, null))))));
};

var _columnConfig$transfo, _columnConfig$cellTra, _columnConfig$transfo2, _columnConfig$cellTra2;

var rowKey$1 = function rowKey(_ref) {
  var rowData = _ref.rowData;
  return rowData === null || rowData === void 0 ? void 0 : rowData.props.id;
};

var STORAGE_KEY_CLUSTERS_FILTER = 'assisted-installer-cluster-list-filters';
var columnConfig = {
  transforms: [sortable],
  cellTransforms: [],
  formatters: [],
  cellFormatters: [],
  props: {}
};
var columns = [_extends({
  title: 'Name',
  dataLabel: 'Name'
}, columnConfig, {
  transforms: columnConfig === null || columnConfig === void 0 ? void 0 : (_columnConfig$transfo = columnConfig.transforms) === null || _columnConfig$transfo === void 0 ? void 0 : _columnConfig$transfo.concat(cellWidth(20)),
  cellTransforms: columnConfig === null || columnConfig === void 0 ? void 0 : (_columnConfig$cellTra = columnConfig.cellTransforms) === null || _columnConfig$cellTra === void 0 ? void 0 : _columnConfig$cellTra.concat(breakWord$1)
}), _extends({
  title: 'Base domain',
  dataLabel: 'Base domain'
}, columnConfig, {
  transforms: columnConfig === null || columnConfig === void 0 ? void 0 : (_columnConfig$transfo2 = columnConfig.transforms) === null || _columnConfig$transfo2 === void 0 ? void 0 : _columnConfig$transfo2.concat(cellWidth(40)),
  cellTransforms: columnConfig === null || columnConfig === void 0 ? void 0 : (_columnConfig$cellTra2 = columnConfig.cellTransforms) === null || _columnConfig$cellTra2 === void 0 ? void 0 : _columnConfig$cellTra2.concat(breakWord$1)
}), _extends({
  title: 'Version',
  dataLabel: 'Version'
}, columnConfig), _extends({
  title: 'Status',
  dataLabel: 'Status'
}, columnConfig), _extends({
  title: 'Hosts',
  dataLabel: 'Hosts'
}, columnConfig), _extends({
  title: 'Created at',
  dataLabel: 'Created at'
}, columnConfig)];

var getStatusCell = function getStatusCell(row) {
  var _row$cells;

  return (_row$cells = row.cells) === null || _row$cells === void 0 ? void 0 : _row$cells[3];
};

var ClusterRowWrapper = function ClusterRowWrapper(props) {
  var _props$row, _props$row$props, _props$row2, _props$row2$props;

  return /*#__PURE__*/React__default.createElement(RowWrapper, _extends({}, props, {
    "data-testid": "cluster-row-" + ((_props$row = props.row) === null || _props$row === void 0 ? void 0 : (_props$row$props = _props$row.props) === null || _props$row$props === void 0 ? void 0 : _props$row$props.name),
    id: "cluster-row-" + ((_props$row2 = props.row) === null || _props$row2 === void 0 ? void 0 : (_props$row2$props = _props$row2.props) === null || _props$row2$props === void 0 ? void 0 : _props$row2$props.name)
  }));
};

var ClustersTable = function ClustersTable(_ref2) {
  var rows = _ref2.rows,
      deleteCluster = _ref2.deleteCluster;

  var _React$useState = React__default.useState(),
      deleteClusterID = _React$useState[0],
      setDeleteClusterID = _React$useState[1];

  var _React$useState2 = React__default.useState({
    index: 0,
    direction: SortByDirection.asc
  }),
      sortBy = _React$useState2[0],
      setSortBy = _React$useState2[1];

  var _React$useState3 = React__default.useState(''),
      searchString = _React$useState3[0],
      setSearchString = _React$useState3[1];

  var _React$useState4 = React__default.useState({
    status: []
  }),
      filters = _React$useState4[0],
      setFilters = _React$useState4[1];

  React__default.useEffect(function () {
    var marshalled = window.sessionStorage.getItem(STORAGE_KEY_CLUSTERS_FILTER);

    if (marshalled) {
      try {
        var parsed = JSON.parse(marshalled);
        parsed.filters && setFilters(parsed.filters);
        parsed.sortBy && setSortBy(parsed.sortBy);
        parsed.searchString && setSearchString(parsed.searchString);
      } catch (e) {
        console.info('Failed to restore clusters filter: ', e);
      }
    }
  }, []);
  React__default.useEffect(function () {
    window.sessionStorage.setItem(STORAGE_KEY_CLUSTERS_FILTER, JSON.stringify({
      filters: filters,
      sortBy: sortBy,
      searchString: searchString
    }));
  }, [filters, sortBy, searchString]);
  var actionResolver = React__default.useCallback(function (rowData) {
    return [{
      title: 'Delete',
      id: "button-delete-" + rowData.props.name,
      isDisabled: getClusterTableStatusCell(rowData).sortableValue === CLUSTER_STATUS_LABELS.installing,
      onClick: function onClick(event, rowIndex, rowData) {
        setDeleteClusterID({
          id: rowData.props.id,
          name: rowData.props.name
        });
      }
    }];
  }, [setDeleteClusterID]);
  var onSort = React__default.useCallback(function (_event, index, direction) {
    setSortBy({
      index: index,
      direction: direction
    });
  }, [setSortBy]);
  var rowFilter = React__default.useCallback(function (row) {
    var _getStatusCell;

    var searchableProps = [row.props.name, row.props.id, row.props.baseDnsDomain].map(function (prop) {
      return (prop || '').toLowerCase();
    });

    if (searchString && !searchableProps.find(function (prop) {
      return prop.includes(searchString.toLowerCase());
    })) {
      return false;
    }

    var value = (_getStatusCell = getStatusCell(row)) === null || _getStatusCell === void 0 ? void 0 : _getStatusCell.sortableValue;

    if (filters.status.length > 0 && value && !filters.status.includes(value)) {
      return false;
    }

    return true;
  }, [searchString, filters]);
  var sortedRows = React__default.useMemo(function () {
    return rows.filter(rowFilter).sort(rowSorter(sortBy, function (row, index) {
      var _row$cells2;

      if (index === void 0) {
        index = 0;
      }

      return (_row$cells2 = row.cells) === null || _row$cells2 === void 0 ? void 0 : _row$cells2[index];
    }));
  }, [rows, sortBy, rowFilter]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClustersListToolbar, {
    searchString: searchString,
    setSearchString: setSearchString,
    filters: filters,
    setFilters: setFilters
  }), /*#__PURE__*/React__default.createElement(Table, {
    rows: sortedRows,
    cells: columns,
    actionResolver: actionResolver,
    "aria-label": "Clusters table",
    sortBy: sortBy,
    onSort: onSort,
    rowWrapper: ClusterRowWrapper,
    "data-testid": 'clusters-table'
  }, /*#__PURE__*/React__default.createElement(TableHeader, null), /*#__PURE__*/React__default.createElement(TableBody, {
    rowKey: rowKey$1
  })), deleteClusterID && /*#__PURE__*/React__default.createElement(DeleteClusterModal, {
    name: deleteClusterID.name,
    onClose: function onClose() {
      return setDeleteClusterID(undefined);
    },
    onDelete: function onDelete() {
      deleteCluster(deleteClusterID.id);
      setDeleteClusterID(undefined);
    }
  }));
};

var ClusterBreadcrumbs = function ClusterBreadcrumbs(_ref) {
  var clusterName = _ref.clusterName,
      _ref$isHidden = _ref.isHidden,
      isHidden = _ref$isHidden === void 0 ? isSingleClusterMode() : _ref$isHidden;
  return isHidden ? null : /*#__PURE__*/React__default.createElement(PageSection, {
    variant: PageSectionVariants.light
  }, (clusterName || ocmClient) && /*#__PURE__*/React__default.createElement(Breadcrumb, null, /*#__PURE__*/React__default.createElement(BreadcrumbItem, null, /*#__PURE__*/React__default.createElement(Link, {
    to: '/'
  }, "Clusters")), clusterName ? /*#__PURE__*/React__default.createElement(BreadcrumbItem, null, /*#__PURE__*/React__default.createElement(Link, {
    to: routeBasePath + "/clusters"
  }, "Assisted Clusters")) : /*#__PURE__*/React__default.createElement(BreadcrumbItem, {
    isActive: true
  }, "Assisted Clusters"), clusterName && /*#__PURE__*/React__default.createElement(BreadcrumbItem, {
    isActive: true
  }, clusterName)));
};

var Clusters = function Clusters(_ref) {
  var history = _ref.history;
  var LOADING = ResourceUIState.LOADING,
      EMPTY = ResourceUIState.EMPTY,
      ERROR = ResourceUIState.ERROR,
      RELOADING = ResourceUIState.RELOADING;

  var _useAlerts = useAlerts(),
      addAlert = _useAlerts.addAlert;

  var clusterRows = useSelector(selectClusterTableRows);
  var clustersUIState = useSelector(selectClustersUIState);
  var uiState = React__default.useRef(clustersUIState);

  if (clustersUIState !== RELOADING) {
    uiState.current = clustersUIState;
  }

  var dispatch = useDispatch();
  var fetchClusters = React__default.useCallback(function () {
    return dispatch(fetchClustersAsync());
  }, [dispatch]);
  var deleteClusterAsync = React__default.useCallback(function (clusterId) {
    try {
      return Promise.resolve(_catch(function () {
        return Promise.resolve(deleteCluster(clusterId)).then(function () {
          dispatch(deleteCluster$1(clusterId));
        });
      }, function (e) {
        return handleApiError(e, function () {
          return addAlert({
            title: 'Cluster could not be deleted',
            message: getErrorMessage(e)
          });
        });
      }));
    } catch (e) {
      return Promise.reject(e);
    }
  }, [dispatch, addAlert]);
  React__default.useEffect(function () {
    fetchClusters();
  }, [fetchClusters]);

  switch (uiState.current) {
    case LOADING:
      return /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light,
        isFilled: true
      }, /*#__PURE__*/React__default.createElement(LoadingState, null));

    case ERROR:
      return /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light,
        isFilled: true
      }, /*#__PURE__*/React__default.createElement(ErrorState, {
        title: "Failed to fetch clusters.",
        fetchData: fetchClusters
      }));

    case EMPTY:
      return /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light,
        isFilled: true
      }, /*#__PURE__*/React__default.createElement(EmptyState, {
        icon: AddCircleOIcon,
        title: "Create new assisted cluster",
        content: "There are no clusters yet. This wizard is going to guide you through the OpenShift cluster deployment.",
        primaryAction: /*#__PURE__*/React__default.createElement(Button, {
          variant: ButtonVariant.primary,
          onClick: function onClick() {
            return history.push(routeBasePath + "/clusters/~new");
          },
          id: "empty-state-new-cluster-button",
          "data-ouia-id": "button-create-new-cluster"
        }, "Create New Cluster")
      }));

    default:
      return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterBreadcrumbs, null), /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light
      }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
        component: "h1"
      }, "Assisted Clusters"))), /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light,
        isFilled: true
      }, /*#__PURE__*/React__default.createElement(Alerts, null), /*#__PURE__*/React__default.createElement(ClustersTable, {
        rows: clusterRows,
        deleteCluster: deleteClusterAsync
      })));
  }
};

var ClustersPage = function ClustersPage(props) {
  return /*#__PURE__*/React__default.createElement(AlertsContextProvider, null, /*#__PURE__*/React__default.createElement(Clusters, props));
};

var NewClusterWizard = function NewClusterWizard() {
  var _React$useState = React__default.useState('cluster-details'),
      currentStepId = _React$useState[0],
      setCurrentStepId = _React$useState[1];

  var renderCurrentStep = React__default.useCallback(function () {
    switch (currentStepId) {
      case 'cluster-details':
      default:
        return /*#__PURE__*/React__default.createElement(ClusterDetails, null);
    }
  }, [currentStepId]);
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterWizardContext.Provider, {
    value: {
      currentStepId: currentStepId,
      setCurrentStepId: setCurrentStepId
    }
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "pf-c-wizard cluster-wizard"
  }, renderCurrentStep())));
};

var loadingUI = /*#__PURE__*/React__default.createElement(PageSection, {
  variant: PageSectionVariants.light,
  isFilled: true
}, /*#__PURE__*/React__default.createElement(LoadingState, null));
var errorUI = /*#__PURE__*/React__default.createElement(PageSection, {
  variant: PageSectionVariants.light,
  isFilled: true
}, /*#__PURE__*/React__default.createElement(ErrorState, {
  title: "Failed to retrieve the default configuration",
  actions: [/*#__PURE__*/React__default.createElement(Button, {
    key: "cancel",
    variant: ButtonVariant.secondary,
    component: function component(props) {
      return /*#__PURE__*/React__default.createElement(Link, _extends({
        to: routeBasePath + "/clusters"
      }, props));
    }
  }, "Back")]
}));

var NewClusterPage = function NewClusterPage() {
  return /*#__PURE__*/React__default.createElement(AlertsContextProvider, null, /*#__PURE__*/React__default.createElement(ClusterDefaultConfigurationProvider, {
    loadingUI: loadingUI,
    errorUI: errorUI
  }, /*#__PURE__*/React__default.createElement(ClusterBreadcrumbs, {
    clusterName: "New cluster"
  }), /*#__PURE__*/React__default.createElement(PageSection, {
    variant: PageSectionVariants.light
  }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
    component: "h1"
  }, "Install OpenShift with the Assisted Installer"))), /*#__PURE__*/React__default.createElement(PageSection, {
    variant: PageSectionVariants.light,
    isFilled: true
  }, /*#__PURE__*/React__default.createElement(NewClusterWizard, null))));
};

var InventoryAddHosts = function InventoryAddHosts() {
  var _React$useContext = React__default.useContext(AddHostsContext),
      cluster = _React$useContext.cluster;

  var _React$useState = React__default.useState(false),
      isDiscoveryHintModalOpen = _React$useState[0],
      setDiscoveryHintModalOpen = _React$useState[1];

  if (!cluster) {
    return null;
  }

  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(DiscoveryInstructions, {
    isSingleNodeCluster: isSingleNodeCluster(cluster)
  }), /*#__PURE__*/React__default.createElement(Text, {
    component: "p"
  }, /*#__PURE__*/React__default.createElement(DiscoveryImageModalButton, {
    ButtonComponent: Button,
    cluster: cluster,
    idPrefix: "bare-metal-inventory-add-host"
  })), /*#__PURE__*/React__default.createElement(InformationAndAlerts, {
    cluster: cluster,
    HostRequirementsContent: AddHostRequirementsContent,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  })), /*#__PURE__*/React__default.createElement(ClusterHostsTable, {
    cluster: cluster,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  }), /*#__PURE__*/React__default.createElement(DiscoveryTroubleshootingModal, {
    isOpen: isDiscoveryHintModalOpen,
    setDiscoveryHintModalOpen: setDiscoveryHintModalOpen
  }));
};

var addAlert$1 = alertsSlice.actions.addAlert;

var AddHosts = function AddHosts() {
  var _React$useContext = React__default.useContext(AddHostsContext),
      cluster = _React$useContext.cluster;

  var dispatch = useDispatch();

  var _React$useState = React__default.useState(false),
      isSubmitting = _React$useState[0],
      setSubmitting = _React$useState[1];

  if (!cluster) {
    return null;
  }

  var handleHostsInstall = function handleHostsInstall() {
    try {
      setSubmitting(true);

      var _temp2 = _finallyRethrows(function () {
        return _catch(function () {
          return Promise.resolve(installHosts(cluster.id)).then(function (_ref) {
            var data = _ref.data;
            dispatch(updateCluster(data));
          });
        }, function (e) {
          handleApiError(e, function () {
            return addAlert$1({
              title: 'Failed to start hosts installation.',
              message: getErrorMessage(e)
            });
          });
        });
      }, function (_wasThrown, _result) {
        setSubmitting(false);
        if (_wasThrown) throw _result;
        return _result;
      });

      return Promise.resolve(_temp2 && _temp2.then ? _temp2.then(function () {}) : void 0);
    } catch (e) {
      return Promise.reject(e);
    }
  };

  return /*#__PURE__*/React__default.createElement(ModalDialogsContextProvider, null, /*#__PURE__*/React__default.createElement(Card, null, /*#__PURE__*/React__default.createElement(CardTitle, null, /*#__PURE__*/React__default.createElement(Title, {
    headingLevel: "h2",
    size: "lg",
    className: "card-title"
  }, "Host Discovery")), /*#__PURE__*/React__default.createElement(CardBody, null, /*#__PURE__*/React__default.createElement(InventoryAddHosts, null), /*#__PURE__*/React__default.createElement(Alerts, null), /*#__PURE__*/React__default.createElement(Toolbar, {
    id: "cluster-toolbar"
  }, /*#__PURE__*/React__default.createElement(ToolbarContent, null, /*#__PURE__*/React__default.createElement(ToolbarButton, {
    variant: ButtonVariant.primary,
    name: "install",
    onClick: handleHostsInstall,
    isDisabled: getReadyHostCount(cluster) <= 0 || isSubmitting
  }, "Install ready hosts"), /*#__PURE__*/React__default.createElement(ToolbarSecondaryGroup, null, /*#__PURE__*/React__default.createElement(EventsModalButton, {
    id: "cluster-events-button",
    entityKind: "cluster",
    cluster: cluster,
    title: "Cluster Events",
    variant: ButtonVariant.link,
    style: {
      textAlign: 'right'
    },
    onFetchEvents: onFetchEvents
  }, "View Cluster Events")))))), /*#__PURE__*/React__default.createElement(DiscoveryImageModal, null));
};

var AssistedUILibVersion = function AssistedUILibVersion(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React__default.createElement(Fragment, null, children, /*#__PURE__*/React__default.createElement("div", {
    "data-testid": "assisted-ui-lib-version",
    hidden: true
  }, getAssistedUiLibVersion()));
};

var getOpenshiftClusterId = function getOpenshiftClusterId(ocmCluster) {
  return ocmCluster && ocmCluster.external_id;
};
var canAddHost = function canAddHost(_ref) {
  var cluster = _ref.cluster;
  var isAllowed = false;

  if (getOpenshiftClusterId(cluster)) {
    var _cluster$product, _cluster$product2, _cluster$cloud_provid;

    if (cluster.state === 'ready' && ((_cluster$product = cluster.product) === null || _cluster$product === void 0 ? void 0 : _cluster$product.id) === 'OCP-AssistedInstall' && (!cluster.aiCluster || cluster.aiCluster.status === 'installed') || ((_cluster$product2 = cluster.product) === null || _cluster$product2 === void 0 ? void 0 : _cluster$product2.id) !== 'OCP-AssistedInstall' && ((_cluster$cloud_provid = cluster.cloud_provider) === null || _cluster$cloud_provid === void 0 ? void 0 : _cluster$cloud_provid.id) === 'baremetal') {
      isAllowed = true;
    }

    if (cluster.aiCluster && cluster.aiCluster['high_availability_mode'] === 'None') {
      isAllowed = false;
    }
  }

  return isAllowed;
};

var HostsClusterDetailTabContent = function HostsClusterDetailTabContent(_ref) {
  var _cluster$console3;

  var cluster = _ref.cluster,
      isVisible = _ref.isVisible,
      openModal = _ref.openModal;

  var _React$useState = React__default.useState(),
      error = _React$useState[0],
      setError = _React$useState[1];

  var _React$useState2 = React__default.useState(),
      day2Cluster = _React$useState2[0],
      setDay2Cluster = _React$useState2[1];

  var pullSecret = usePullSecretFetch();

  var _useOpenshiftVersions = useOpenshiftVersions(),
      normalizeClusterVersion = _useOpenshiftVersions.normalizeClusterVersion;

  var TryAgain = React__default.useCallback(function () {
    return /*#__PURE__*/React__default.createElement(Button, {
      onClick: function onClick() {
        setError(undefined);
        setDay2Cluster(undefined);
      },
      variant: ButtonVariant.link,
      isInline: true
    }, "try again");
  }, [setError, setDay2Cluster]);
  var MissingApiUrl = React__default.useCallback(function () {
    return /*#__PURE__*/React__default.createElement(Fragment, null, "Neither API nor Console URL has been reported by the cluster yet.", openModal && /*#__PURE__*/React__default.createElement(Fragment, null, ' ', /*#__PURE__*/React__default.createElement("br", null), "Please hold on and ", /*#__PURE__*/React__default.createElement(TryAgain, null), " later or", ' ', /*#__PURE__*/React__default.createElement(Button, {
      variant: ButtonVariant.link,
      isInline: true,
      onClick: function onClick() {
        return openModal('edit-console-url', cluster);
      }
    }, "add console URL"), ' ', "manually."));
  }, [openModal, cluster]);
  React__default.useEffect(function () {
    if (!isVisible && day2Cluster) {
      setDay2Cluster(undefined);
    }

    var openshiftClusterId = getOpenshiftClusterId(cluster);

    if (isVisible && day2Cluster === undefined && cluster && openshiftClusterId && pullSecret) {
      var _cluster$api, _cluster$console;

      setDay2Cluster(null);
      var openshiftVersion = normalizeClusterVersion(cluster.openshift_version);

      if (!openshiftVersion) {
        setError( /*#__PURE__*/React__default.createElement(Fragment, null, "Unsupported OpenShift cluster version: $", cluster.openshift_version, ".", /*#__PURE__*/React__default.createElement("br", null), "Check your connection and ", /*#__PURE__*/React__default.createElement(TryAgain, null), "."));
        return;
      }

      var apiVipDnsname = '';

      if ((_cluster$api = cluster.api) === null || _cluster$api === void 0 ? void 0 : _cluster$api.url) {
        try {
          var apiVipUrl = new URL(cluster.api.url);
          apiVipDnsname = apiVipUrl.hostname;
        } catch (_unused) {
          setError( /*#__PURE__*/React__default.createElement(Fragment, null, "Cluster API URL is not valid ($", cluster.api.url, "), you can ", /*#__PURE__*/React__default.createElement(TryAgain, null), "."));
          return;
        }
      } else if ((_cluster$console = cluster.console) === null || _cluster$console === void 0 ? void 0 : _cluster$console.url) {
        try {
          var consoleUrlHostname = new URL(cluster.console.url).hostname;
          var APPS = '.apps.';
          apiVipDnsname = 'api.' + consoleUrlHostname.substring(consoleUrlHostname.indexOf(APPS) + APPS.length);
        } catch (_unused2) {
          var _cluster$console2;

          setError( /*#__PURE__*/React__default.createElement(Fragment, null, "Cluster Console URL is not valid ($", (_cluster$console2 = cluster.console) === null || _cluster$console2 === void 0 ? void 0 : _cluster$console2.url, "), you can ", /*#__PURE__*/React__default.createElement(TryAgain, null), "."));
          return;
        }
      }

      if (!apiVipDnsname) {
        setError( /*#__PURE__*/React__default.createElement(MissingApiUrl, null));
        return;
      }

      var doItAsync = function doItAsync() {
        try {
          var _temp5 = function _temp5(_result) {
            if (_exit2) return _result;

            var _temp2 = function () {
              if (!dayTwoClusterExists) {
                var _temp7 = _catch(function () {
                  return Promise.resolve(addHostsClusters({
                    id: openshiftClusterId,
                    name: "scale-up-" + (cluster.display_name || cluster.name || openshiftClusterId),
                    openshiftVersion: openshiftVersion,
                    apiVipDnsname: apiVipDnsname
                  })).then(function (_ref2) {
                    var data = _ref2.data;
                    setDay2Cluster(data);
                  });
                }, function (e) {
                  handleApiError(e);
                  setError( /*#__PURE__*/React__default.createElement(Fragment, null, "Failed to create wrapping cluster for adding new hosts.", /*#__PURE__*/React__default.createElement("br", null), "Check your connection and ", /*#__PURE__*/React__default.createElement(TryAgain, null), "."));
                });

                if (_temp7 && _temp7.then) return _temp7.then(function () {});
              }
            }();

            if (_temp2 && _temp2.then) return _temp2.then(function () {});
          };

          var _exit2 = false;
          var dayTwoClusterExists = false;

          var _temp6 = _catch(function () {
            return Promise.resolve(getCluster(openshiftClusterId)).then(function (_ref3) {
              var data = _ref3.data;
              setDay2Cluster(data);
              dayTwoClusterExists = true;
            });
          }, function (e) {
            var _e$response;

            if (Number(e === null || e === void 0 ? void 0 : (_e$response = e.response) === null || _e$response === void 0 ? void 0 : _e$response.status) !== 404) {
              handleApiError(e);
              setError( /*#__PURE__*/React__default.createElement(Fragment, null, "Failed to read cluster details.", /*#__PURE__*/React__default.createElement("br", null), "Check your connection and ", /*#__PURE__*/React__default.createElement(TryAgain, null), "."));
              _exit2 = true;
            }
          });

          return Promise.resolve(_temp6 && _temp6.then ? _temp6.then(_temp5) : _temp5(_temp6));
        } catch (e) {
          return Promise.reject(e);
        }
      };

      doItAsync();
    }
  }, [cluster, openModal, pullSecret, day2Cluster, isVisible, normalizeClusterVersion]);
  React__default.useEffect(function () {
    if (day2Cluster) {
      var id = setTimeout(function () {
        var doItAsync = function doItAsync() {
          try {
            var _temp9 = _catch(function () {
              return Promise.resolve(getCluster(day2Cluster.id)).then(function (_ref4) {
                var data = _ref4.data;
                setDay2Cluster(data);
              });
            }, function (e) {
              handleApiError(e);
              setError( /*#__PURE__*/React__default.createElement(Fragment, null, "Failed to reload cluster data.", /*#__PURE__*/React__default.createElement("br", null), "Check your connection and ", /*#__PURE__*/React__default.createElement(TryAgain, null), "."));
            });

            return Promise.resolve(_temp9 && _temp9.then ? _temp9.then(function () {}) : void 0);
          } catch (e) {
            return Promise.reject(e);
          }
        };

        doItAsync();
      }, POLLING_INTERVAL);
      return function () {
        return clearTimeout(id);
      };
    }
  }, [day2Cluster]);

  if (error) {
    return /*#__PURE__*/React__default.createElement(ErrorState, {
      variant: EmptyStateVariant.large,
      content: error,
      title: "Failed to prepare the cluster for adding hosts."
    });
  }

  if (!day2Cluster) {
    return /*#__PURE__*/React__default.createElement(LoadingState, {
      content: "Preparing cluster for adding hosts..."
    });
  }

  return /*#__PURE__*/React__default.createElement(AddHostsContextProvider, {
    cluster: day2Cluster,
    ocpConsoleUrl: cluster === null || cluster === void 0 ? void 0 : (_cluster$console3 = cluster.console) === null || _cluster$console3 === void 0 ? void 0 : _cluster$console3.url
  }, /*#__PURE__*/React__default.createElement(AddHosts, null));
};

var HostsClusterDetailTab = function HostsClusterDetailTab(props) {
  return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(AssistedUILibVersion, null), /*#__PURE__*/React__default.createElement(AlertsContextProvider, null, /*#__PURE__*/React__default.createElement(HostsClusterDetailTabContent, props)));
};

var ClusterPage = function ClusterPage(_ref) {
  var match = _ref.match;
  var clusterId = match.params.clusterId;
  var fetchCluster = useFetchCluster(clusterId);

  var _useClusterPolling = useClusterPolling(clusterId),
      cluster = _useClusterPolling.cluster,
      uiState = _useClusterPolling.uiState,
      errorDetail = _useClusterPolling.errorDetail;

  var errorStateActions = [];

  if (!isSingleClusterMode()) {
    errorStateActions.push( /*#__PURE__*/React__default.createElement(Button, {
      key: "cancel",
      variant: ButtonVariant.secondary,
      component: function component(props) {
        return /*#__PURE__*/React__default.createElement(Link, _extends({
          to: routeBasePath + "/clusters"
        }, props));
      }
    }, "Back"));
  }

  var getContent = function getContent(cluster) {
    if (cluster.status === 'adding-hosts') {
      return /*#__PURE__*/React__default.createElement(AddHostsContextProvider, {
        cluster: cluster
      }, /*#__PURE__*/React__default.createElement(AddHosts, null));
    } else if (['preparing-for-installation', 'installing', 'installing-pending-user-action', 'finalizing', 'installed', 'error', 'cancelled'].includes(cluster.status)) {
      return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterBreadcrumbs, {
        clusterName: cluster.name
      }), /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light
      }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
        component: "h1"
      }, cluster.name))), /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light,
        isFilled: true
      }, /*#__PURE__*/React__default.createElement(ClusterDetail, {
        cluster: cluster
      })));
    } else {
      return /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement(ClusterBreadcrumbs, {
        clusterName: cluster.name
      }), /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light
      }, /*#__PURE__*/React__default.createElement(TextContent, null, /*#__PURE__*/React__default.createElement(Text, {
        component: "h1",
        className: "pf-u-display-inline"
      }, "Install OpenShift with the Assisted Installer"), /*#__PURE__*/React__default.createElement(TechnologyPreview, {
        className: "pf-u-ml-md",
        position: PreviewBadgePosition.inline
      }))), /*#__PURE__*/React__default.createElement(PageSection, {
        variant: PageSectionVariants.light
      }, /*#__PURE__*/React__default.createElement(ClusterWizard, {
        cluster: cluster
      })));
    }
  };

  var loadingUI = /*#__PURE__*/React__default.createElement(PageSection, {
    variant: PageSectionVariants.light,
    isFilled: true
  }, /*#__PURE__*/React__default.createElement(LoadingState, null));

  if (uiState === ResourceUIState.LOADING) {
    return loadingUI;
  }

  if (uiState === ResourceUIState.ERROR) {
    if (Number(errorDetail === null || errorDetail === void 0 ? void 0 : errorDetail.code) === 404) {
      return /*#__PURE__*/React__default.createElement(Redirect, {
        to: routeBasePath + "/clusters"
      });
    }

    return /*#__PURE__*/React__default.createElement(PageSection, {
      variant: PageSectionVariants.light,
      isFilled: true
    }, /*#__PURE__*/React__default.createElement(ErrorState, {
      title: "Failed to fetch the cluster",
      fetchData: Number(errorDetail === null || errorDetail === void 0 ? void 0 : errorDetail.code) === 401 ? function () {
        return window.location.reload();
      } : fetchCluster,
      actions: errorStateActions
    }));
  }

  var errorUI = /*#__PURE__*/React__default.createElement(PageSection, {
    variant: PageSectionVariants.light,
    isFilled: true
  }, /*#__PURE__*/React__default.createElement(ErrorState, {
    title: "Failed to retrieve the default configuration",
    actions: errorStateActions
  }));

  if (cluster) {
    return /*#__PURE__*/React__default.createElement(AlertsContextProvider, null, /*#__PURE__*/React__default.createElement(ModalDialogsContextProvider, null, /*#__PURE__*/React__default.createElement(ClusterDefaultConfigurationProvider, {
      loadingUI: loadingUI,
      errorUI: errorUI
    }, getContent(cluster), /*#__PURE__*/React__default.createElement(CancelInstallationModal, null), /*#__PURE__*/React__default.createElement(ResetClusterModal, null), /*#__PURE__*/React__default.createElement(DiscoveryImageModal, null))));
  }

  return /*#__PURE__*/React__default.createElement(Redirect, {
    to: "/clusters"
  });
};

var SingleCluster = function SingleCluster() {
  var _React$useState = React__default.useState(''),
      error = _React$useState[0],
      setError = _React$useState[1];

  var _React$useState2 = React__default.useState(),
      clusters = _React$useState2[0],
      setClusters = _React$useState2[1];

  var fetchClusters = React__default.useCallback(function () {
    try {
      return Promise.resolve(_catch(function () {
        return Promise.resolve(getClusters()).then(function (_ref) {
          var data = _ref.data;
          setClusters(data);
        });
      }, function (e) {
        return handleApiError(e, function () {
          return setError('Failed to fetch cluster.');
        });
      }));
    } catch (e) {
      return Promise.reject(e);
    }
  }, [setClusters]);
  React__default.useEffect(function () {
    fetchClusters();
  }, [fetchClusters]);

  if (error) {
    return /*#__PURE__*/React__default.createElement(PageSection, {
      variant: PageSectionVariants.light,
      isFilled: true
    }, /*#__PURE__*/React__default.createElement(ErrorState, {
      title: "Failed to fetch cluster.",
      fetchData: fetchClusters
    }));
  }

  if (!clusters) {
    return /*#__PURE__*/React__default.createElement(PageSection, {
      variant: PageSectionVariants.light,
      isFilled: true
    }, /*#__PURE__*/React__default.createElement(LoadingState, null));
  }

  if (clusters.length === 0) {
    return /*#__PURE__*/React__default.createElement(NewClusterPage, null);
  }

  if (clusters.length > 1) {
    console.warn('More than one cluster found!', clusters);
  }

  return /*#__PURE__*/React__default.createElement(Redirect, {
    to: routeBasePath + "/clusters/" + clusters[0].id
  });
};

var AssistedUiRouter = function AssistedUiRouter(_ref) {
  var allEnabledFeatures = _ref.allEnabledFeatures;
  return /*#__PURE__*/React__default.createElement(Provider, {
    store: store
  }, /*#__PURE__*/React__default.createElement(Router, {
    features: allEnabledFeatures
  }));
};
var Router = function Router(_ref2) {
  var features = _ref2.features,
      children = _ref2.children;
  return /*#__PURE__*/React__default.createElement(FeatureGateContextProvider, {
    features: features
  }, /*#__PURE__*/React__default.createElement(AssistedUILibVersion, null), isSingleClusterMode() ? /*#__PURE__*/React__default.createElement(Switch$1, null, /*#__PURE__*/React__default.createElement(Route, {
    path: routeBasePath + "/clusters/:clusterId",
    component: ClusterPage
  }), /*#__PURE__*/React__default.createElement(Route, {
    path: routeBasePath + "/clusters",
    component: SingleCluster
  }), children, /*#__PURE__*/React__default.createElement(Redirect, {
    to: routeBasePath + "/clusters"
  })) : /*#__PURE__*/React__default.createElement(Switch$1, null, /*#__PURE__*/React__default.createElement(Route, {
    path: routeBasePath + "/clusters/~new",
    component: NewClusterPage
  }), /*#__PURE__*/React__default.createElement(Route, {
    path: routeBasePath + "/clusters/:clusterId",
    component: ClusterPage
  }), /*#__PURE__*/React__default.createElement(Route, {
    path: routeBasePath + "/clusters",
    component: ClustersPage
  }), children, /*#__PURE__*/React__default.createElement(Redirect, {
    to: routeBasePath + "/clusters"
  })));
};



var index$8 = {
  __proto__: null,
  Api: index$3,
  Store: index$5,
  Selectors: index$6,
  Config: index$7,
  Features: index$1,
  Constants: index,
  Reducers: index$2,
  ClusterDetail: ClusterDetail,
  ClusterInstallationProgressCard: ClusterInstallationProgressCard,
  AssistedInstallerDetailCard: Wrapper,
  downloadClusterInstallationLogs: downloadClusterInstallationLogs,
  getMasterCount: getMasterCount,
  getWorkerCount: getWorkerCount,
  getClustervCPUCount: getClustervCPUCount,
  getClusterMemoryAmount: getClusterMemoryAmount,
  getClusterDetailId: getClusterDetailId,
  Clusters: ClustersPage,
  NewClusterPage: NewClusterPage,
  ClusterPage: ClusterPage,
  ClusterToolbar: ClusterToolbar,
  ClusterStatus: ClusterStatus,
  ClusterStatusIcon: ClusterStatusIcon,
  ClusterHostsTable: ClusterHostsTable,
  AssistedUILibVersion: AssistedUILibVersion,
  AssistedUiRouter: AssistedUiRouter,
  Router: Router,
  AddHosts: AddHosts,
  HostsClusterDetailTab: HostsClusterDetailTab,
  getOpenshiftClusterId: getOpenshiftClusterId,
  canAddHost: canAddHost,
  ClusterDetailsForm: ClusterDetailsForm,
  PopoverIcon: PopoverIcon,
  WizardNavItem: NavItem,
  Alerts: Alerts,
  ExternalLink: ExternalLink,
  PrismCode: PrismCode,
  GridGap: GridGap,
  EventsList: EventsList,
  ClusterEventsList: ClusterEventsList,
  ClusterEventsToolbar: ClusterEventsToolbar,
  InputField: InputField,
  CheckboxField: CheckboxField,
  TextAreaField: TextAreaField,
  SelectField: SelectField,
  MultiSelectField: MultiSelectField,
  TextAreaSecretField: TextAreaSecretField,
  UploadField: UploadField,
  SwitchField: SwitchField,
  HelperText: HelperText,
  FormikAutoSave: FormikAutoSave,
  PullSecretField: PullSecretField,
  RadioField: RadioField,
  SingleNodeCheckbox: SingleNodeCheckbox,
  NumberInputField: NumberInputField,
  CodeField: CodeField,
  getFieldId: getFieldId,
  trimSshPublicKey: trimSshPublicKey,
  trimCommaSeparatedList: trimCommaSeparatedList,
  getFormikErrorFields: getFormikErrorFields,
  getDefaultOpenShiftVersion: getDefaultOpenShiftVersion,
  labelsToArray: labelsToArray,
  parseStringLabels: parseStringLabels,
  uniqueLabels: uniqueLabels,
  selectedLabelsOnly: selectedLabelsOnly,
  PullSecretInfo: PullSecretInfo,
  nameValidationSchema: nameValidationSchema,
  sshPublicKeyValidationSchema: sshPublicKeyValidationSchema,
  pullSecretValidationSchema: pullSecretValidationSchema,
  ipValidationSchema: ipValidationSchema,
  macAddressValidationSchema: macAddressValidationSchema,
  vipRangeValidationSchema: vipRangeValidationSchema,
  vipValidationSchema: vipValidationSchema,
  ipBlockValidationSchema: ipBlockValidationSchema,
  dnsNameValidationSchema: dnsNameValidationSchema,
  hostPrefixValidationSchema: hostPrefixValidationSchema,
  hostnameValidationSchema: hostnameValidationSchema,
  uniqueHostnameValidationSchema: uniqueHostnameValidationSchema,
  httpProxyValidationSchema: httpProxyValidationSchema,
  noProxyValidationSchema: noProxyValidationSchema,
  ntpSourceValidationSchema: ntpSourceValidationSchema,
  LabelValue: LabelValue,
  LabelField: LabelField,
  EmptyState: EmptyState,
  ErrorState: ErrorState,
  LoadingState: LoadingState,
  ToolbarButton: ToolbarButton,
  ToolbarText: ToolbarText,
  ToolbarrProgress: ToolbarProgress,
  ToolbarSecondaryGroup: ToolbarSecondaryGroup,
  StaticField: StaticField,
  FormikStaticField: FormikStaticField,
  StaticTextField: StaticTextField,
  WizardFooter: WizardFooter,
  sortable: sortable,
  getColSpanRow: getColSpanRow,
  rowSorter: rowSorter,
  toSentence: toSentence,
  getDateTimeCell: getDateTimeCell,
  breakWord: breakWord,
  fitContent: fitContent,
  nowrap: nowrap,
  truncate: truncate,
  wrappable: wrappable,
  noPadding: noPadding,
  RenderIf: RenderIf,
  SimpleDropdown: SimpleDropdown,
  DetailList: DetailList,
  DetailItem: DetailItem,
  EventsModalButton: EventsModalButton,
  EventsModal: EventsModal,
  get PreviewBadgePosition () { return PreviewBadgePosition; },
  DeveloperPreview: DeveloperPreview,
  TechnologyPreview: TechnologyPreview,
  getHumanizedDateTime: getHumanizedDateTime,
  getHumanizedTime: getHumanizedTime,
  isSNOSupportedVersion: isSNOSupportedVersion,
  stringToJSON: stringToJSON,
  removeProtocolFromURL: removeProtocolFromURL
};

export { index$4 as CIM, index$8 as OCM };
//# sourceMappingURL=index.modern.js.map
