import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import { useState, useEffect } from 'react';
import { getRBAC, doesHavePermissions } from '../RBAC';
export function usePermissions(appName, permissionsList) {
  var _useState = useState({
    isLoading: true
  }),
      _useState2 = _slicedToArray(_useState, 2),
      permissions = _useState2[0],
      setPermissions = _useState2[1];

  useEffect(function () {
    setPermissions({
      isLoading: true
    });

    _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var _yield$getRBAC, isOrgAdmin, userPermissions;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getRBAC(appName);

            case 2:
              _yield$getRBAC = _context.sent;
              isOrgAdmin = _yield$getRBAC.isOrgAdmin;
              userPermissions = _yield$getRBAC.permissions;
              setPermissions({
                isLoading: false,
                isOrgAdmin: isOrgAdmin,
                permissions: userPermissions,
                hasAccess: doesHavePermissions(userPermissions, permissionsList)
              });

            case 6:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }, [appName]);
  return permissions;
}