import { Inventory } from '../../api';
import { HumanizedSortable } from '../ui/table/utils';
export declare type HostRowHardwareInfo = {
    serialNumber: string;
    cores: HumanizedSortable;
    cpuSpeed: string;
    memory: HumanizedSortable;
    disk: HumanizedSortable;
};
export declare type SimpleHardwareInfo = {
    cores: number;
    memory: number;
    disks: number;
};
export declare const getMemoryCapacity: (inventory: Inventory) => number;
export declare const getDiskCapacity: (inventory: Inventory) => number;
export declare const getHumanizedCpuClockSpeed: (inventory: Inventory) => string;
export declare const getSimpleHardwareInfo: (inventory: Inventory) => SimpleHardwareInfo;
export declare const getHostRowHardwareInfo: (inventory: Inventory) => HostRowHardwareInfo;
