"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartCursorContainer = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_cursor_container_1 = require("victory-cursor-container");
const ChartLabel_1 = require("../ChartLabel");
const ChartUtils_1 = require("../ChartUtils");
const ChartCursorContainer = (_a) => {
    var { className, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant), cursorLabelComponent = React.createElement(ChartLabel_1.ChartLabel, null) } = _a, // Note that Victory provides its own label component here
    rest = tslib_1.__rest(_a, ["className", "themeColor", "themeVariant", "theme", "cursorLabelComponent"]);
    const chartClassName = ChartUtils_1.getClassName({ className });
    const chartCursorLabelComponent = React.cloneElement(cursorLabelComponent, Object.assign({ theme }, cursorLabelComponent.props));
    // Note: theme is required by voronoiContainerMixin
    return (
    // Note: className is valid, but Victory is missing a type
    React.createElement(victory_cursor_container_1.VictoryCursorContainer, Object.assign({ className: chartClassName, cursorLabelComponent: chartCursorLabelComponent, theme: theme }, rest)));
};
exports.ChartCursorContainer = ChartCursorContainer;
exports.ChartCursorContainer.displayName = 'ChartCursorContainer';
exports.ChartCursorContainer.defaultProps = victory_cursor_container_1.VictoryCursorContainer.defaultProps;
// Note: VictoryCursorContainer.defaultEvents & VictoryContainer.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartCursorContainer, victory_cursor_container_1.VictoryCursorContainer);
//# sourceMappingURL=ChartCursorContainer.js.map