"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartLegendTooltip = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_core_1 = require("victory-core");
const victory_tooltip_1 = require("victory-tooltip");
const ChartCursorTooltip_1 = require("../ChartCursorTooltip");
const ChartLegendTooltipContent_1 = require("./ChartLegendTooltipContent");
const ChartTheme_1 = require("../ChartTheme");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
const ChartLegendTooltip = (_a) => {
    var { activePoints, datum, center = { x: 0, y: 0 }, flyoutHeight, flyoutWidth, height, isCursorTooltip = true, labelComponent = React.createElement(ChartLegendTooltipContent_1.ChartLegendTooltipContent, null), legendData, text, themeColor, themeVariant, title, width, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["activePoints", "datum", "center", "flyoutHeight", "flyoutWidth", "height", "isCursorTooltip", "labelComponent", "legendData", "text", "themeColor", "themeVariant", "title", "width", "theme"]);
    const pointerLength = theme && theme.tooltip ? victory_core_1.Helpers.evaluateProp(theme.tooltip.pointerLength) : 10;
    const legendTooltipProps = () => ({
        legendData: ChartUtils_1.getLegendTooltipVisibleData({ activePoints, legendData, text, theme }),
        legendProps: ChartUtils_1.getLegendTooltipDataProps(labelComponent.props.legendComponent),
        text: ChartUtils_1.getLegendTooltipVisibleText({ activePoints, legendData, text }),
        theme
    });
    // Returns flyout height based on legend size
    const getFlyoutHeight = ({ height }) => {
        const _flyoutHeight = height + ChartTheme_1.ChartLegendTooltipStyles.flyout.padding;
        return title ? _flyoutHeight : _flyoutHeight - 10;
    };
    // Returns flyout width based on legend size
    const getFlyoutWidth = ({ width }) => width + ChartTheme_1.ChartLegendTooltipStyles.flyout.padding;
    // Returns the tooltip content component
    const getTooltipContentComponent = (props) => React.cloneElement(labelComponent, Object.assign({ center, flyoutHeight: flyoutHeight || getFlyoutHeight(props), flyoutWidth: flyoutWidth || getFlyoutWidth(props), height,
        legendData,
        title,
        width }, labelComponent.props));
    // Returns the tooltip component
    const getTooltipComponent = () => {
        // There must be at least one active, visible item or else this will return zero for height & width.
        const legendSize = ChartUtils_1.getLegendTooltipSize(legendTooltipProps());
        if (legendSize.height === 0 && legendSize.width === 0) {
            return null;
        }
        const _flyoutWidth = getFlyoutWidth(legendSize);
        const tooltipComponent = isCursorTooltip ? React.createElement(ChartCursorTooltip_1.ChartCursorTooltip, null) : React.createElement(ChartTooltip_1.ChartTooltip, null);
        return React.cloneElement(tooltipComponent, Object.assign(Object.assign(Object.assign({ activePoints,
            center,
            datum, flyoutHeight: flyoutHeight || getFlyoutHeight(legendSize), flyoutWidth: flyoutWidth || getFlyoutWidth(legendSize), height, labelComponent: getTooltipContentComponent(legendSize) }, (flyoutWidth === undefined && {
            showPointer: width > _flyoutWidth + center.x + pointerLength || center.x > _flyoutWidth + pointerLength
        })), { text,
            theme,
            width }), rest));
    };
    return getTooltipComponent();
};
exports.ChartLegendTooltip = ChartLegendTooltip;
exports.ChartLegendTooltip.displayName = 'ChartLegendTooltip';
// Note: VictoryTooltip.defaultEvents must be hoisted
hoist_non_react_statics_1.default(exports.ChartLegendTooltip, victory_tooltip_1.VictoryTooltip);
//# sourceMappingURL=ChartLegendTooltip.js.map