var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React, { useEffect, useRef, useState } from 'react';
import { initialize } from '@scalprum/core';
import { ScalprumContext } from './scalprum-context';
export function ScalprumProvider(_a) {
    var config = _a.config, children = _a.children, api = _a.api;
    var mounted = useRef(false);
    var _b = useState({
        initialized: false,
        config: {},
        api: api,
    }), state = _b[0], setState = _b[1];
    useEffect(function () {
        if (typeof config === 'object') {
            initialize({ scalpLets: config, api: api });
            setState(function (prev) { return (__assign(__assign({}, prev), { initialized: true, config: config })); });
            mounted.current = true;
        }
        if (typeof config === 'function') {
            Promise.resolve(config()).then(function (config) {
                setState(function (prev) { return (__assign(__assign({}, prev), { initialized: true, config: config })); });
                initialize({ scalpLets: config, api: api });
                mounted.current = true;
            });
        }
    }, [config]);
    useEffect(function () {
        if (mounted.current) {
            setState(function (prev) { return (__assign(__assign({}, prev), { api: api })); });
        }
    }, [api]);
    return React.createElement(ScalprumContext.Provider, { value: state }, children);
}
//# sourceMappingURL=scalprum-provider.js.map