"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmProgressTracker = void 0;
var core_1 = require("@material-ui/core");
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importStar(require("react"));
var AcmChartGroup_1 = require("../AcmCharts/AcmChartGroup");
var AcmInlineStatus_1 = require("../AcmInlineStatus");
var AcmButton_1 = require("../AcmButton");
var react_icons_1 = require("@patternfly/react-icons");
var useStyles = core_1.makeStyles({
    /* istanbul ignore next */
    parentContainer: {
        display: 'flex',
        paddingTop: '10px',
    },
    popoverParentContainer: {
        display: 'inline-grid',
    },
    popoverBody: {
        display: 'flex',
    },
    stepContainer: {
        display: 'inline-flex',
        padding: '10px 0px 10px 0px',
    },
    text: { width: 'max-content' },
    divider: {
        padding: '0px 40px 0px 40px',
        maxWidth: '180px',
        maxHeight: '20px',
    },
    stepStatus: {
        paddingLeft: '25px',
    },
    container: {
        display: 'flex',
    },
    icon: {
        width: '18px', // Progress size md is 18px
    },
    iconMargin: {
        margin: '3px 2px 1px 2px',
    },
    button: {
        paddingLeft: '25px',
    },
});
var divider = function (classes) {
    return (react_1.default.createElement("svg", { className: classes.divider },
        react_1.default.createElement("line", { x1: "0", x2: "100", y1: "10", y2: "10", stroke: "#D2D2D2" // --pf-global--palette--black-300
            , strokeWidth: "2", strokeLinecap: "square", strokeDasharray: "1, 3" })));
};
function AcmProgressTracker(props) {
    var classes = useStyles();
    var viewWidth = AcmChartGroup_1.useViewport().viewWidth;
    var isStacked = props.isStacked || viewWidth < 700;
    return (react_1.default.createElement(react_1.Fragment, null,
        react_1.default.createElement(react_core_1.TextContent, null,
            react_1.default.createElement(react_core_1.Text, { component: "h3" }, props.Title),
            react_1.default.createElement(react_core_1.Text, { component: "small" }, props.Subtitle)),
        react_1.default.createElement(react_core_1.Gallery, { className: isStacked ? classes.popoverParentContainer : classes.parentContainer }, props.steps.map(function (step, index) { return (react_1.default.createElement(react_core_1.GalleryItem, { key: index, className: classes.stepContainer },
            react_1.default.createElement("div", null,
                react_1.default.createElement(AcmInlineStatus_1.AcmInlineStatus, { type: step.statusType, status: step.statusText }),
                react_1.default.createElement(react_core_1.TextContent, null,
                    react_1.default.createElement(react_core_1.Text, { className: classes.stepStatus, component: "small" }, step.statusSubtitle)),
                step.link && (react_1.default.createElement(AcmButton_1.AcmButton, { className: classes.button, variant: "link", isSmall: true, icon: react_1.default.createElement(react_icons_1.ExternalLinkAltIcon, null), iconPosition: "right", isDisabled: step.link.isDisabled, onClick: function () {
                        var _a, _b, _c, _d;
                        /* istanbul ignore next */
                        ((_a = step.link) === null || _a === void 0 ? void 0 : _a.linkUrl) && window.open((_b = step.link) === null || _b === void 0 ? void 0 : _b.linkUrl);
                        /* istanbul ignore next */
                        ((_c = step.link) === null || _c === void 0 ? void 0 : _c.linkCallback) && ((_d = step.link) === null || _d === void 0 ? void 0 : _d.linkCallback());
                    } }, step.link.linkName))),
            !isStacked && index < props.steps.length - 1 && divider(classes))); }))));
}
exports.AcmProgressTracker = AcmProgressTracker;
//# sourceMappingURL=AcmProgressTracker.js.map