import { IRowData } from '@patternfly/react-table';
import { ClusterTableRows } from '../../common/types/clusters';
import { Cluster, HumanizedSortable, ResourceUIState } from '../../common';
export declare const selectClustersUIState: import("reselect/*").OutputSelector<import("redux").CombinedState<{
    clusters: {
        data: Cluster[];
        uiState: ResourceUIState;
    };
    currentCluster: {
        data?: Cluster | undefined;
        uiState: ResourceUIState;
        isReloadScheduled: number;
        errorDetail?: import("../reducers/clusters").RetrievalErrorType | undefined;
    };
}>, ResourceUIState, (res1: Cluster[], res2: ResourceUIState) => ResourceUIState>;
export declare const getClusterTableStatusCell: (rowData: IRowData) => HumanizedSortable;
export declare const selectClusterTableRows: import("reselect/*").OutputSelector<import("redux").CombinedState<{
    clusters: {
        data: Cluster[];
        uiState: ResourceUIState;
    };
    currentCluster: {
        data?: Cluster | undefined;
        uiState: ResourceUIState;
        isReloadScheduled: number;
        errorDetail?: import("../reducers/clusters").RetrievalErrorType | undefined;
    };
}>, ClusterTableRows, (res: Cluster[]) => ClusterTableRows>;
export declare const selectClusterNames: import("reselect/*").OutputSelector<import("redux").CombinedState<{
    clusters: {
        data: Cluster[];
        uiState: ResourceUIState;
    };
    currentCluster: {
        data?: Cluster | undefined;
        uiState: ResourceUIState;
        isReloadScheduled: number;
        errorDetail?: import("../reducers/clusters").RetrievalErrorType | undefined;
    };
}>, (string | undefined)[], (res: Cluster[]) => (string | undefined)[]>;
export declare const selectClusterNamesButCurrent: import("reselect/*").OutputSelector<import("redux").CombinedState<{
    clusters: {
        data: Cluster[];
        uiState: ResourceUIState;
    };
    currentCluster: {
        data?: Cluster | undefined;
        uiState: ResourceUIState;
        isReloadScheduled: number;
        errorDetail?: import("../reducers/clusters").RetrievalErrorType | undefined;
    };
}>, (string | undefined)[], (res1: (string | undefined)[], res2: string | undefined) => (string | undefined)[]>;
