import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component, Fragment } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Dropdown } from "@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js";
import { DropdownItem } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js";
import { DropdownToggle } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js";
import { DropdownToggleCheckbox } from "@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggleCheckbox.js";
import { Checkbox } from "@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js";
import { getDefaultOUIAId } from '@patternfly/react-core/';
import "../../BulkSelect/./bulk-select.css";

var BulkSelect = /*#__PURE__*/function (_Component) {
  _inherits(BulkSelect, _Component);

  var _super = _createSuper(BulkSelect);

  function BulkSelect() {
    var _this;

    _classCallCheck(this, BulkSelect);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: false,
      hasError: false,
      ouiaStateId: getDefaultOUIAId('RHI/BulkSelect')
    });

    _defineProperty(_assertThisInitialized(_this), "componentDidCatch", function () {
      console.error('Above error is caused because you are using outdated PF react core library. Count will not be \
visible unless you update it.');

      _this.setState({
        hasError: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });

    return _this;
  }

  _createClass(BulkSelect, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          hasError = _this$state.hasError;

      var _this$props = this.props,
          id = _this$props.id,
          isDisabled = _this$props.isDisabled,
          items = _this$props.items,
          onSelect = _this$props.onSelect,
          checked = _this$props.checked,
          toggleProps = _this$props.toggleProps,
          count = _this$props.count,
          className = _this$props.className,
          ouiaId = _this$props.ouiaId,
          ouiaSafe = _this$props.ouiaSafe,
          props = _objectWithoutProperties(_this$props, ["id", "isDisabled", "items", "onSelect", "checked", "toggleProps", "count", "className", "ouiaId", "ouiaSafe"]);

      var ouiaFinalId = ouiaId !== undefined ? ouiaId : this.state.ouiaStateId;
      return /*#__PURE__*/React.createElement(Fragment, null, items && items.length > 0 ? /*#__PURE__*/React.createElement(Dropdown, _extends({
        onSelect: function onSelect() {
          return _this2.onToggle(false);
        }
      }, props, {
        className: classnames(className, 'ins-c-bulk-select'),
        ouiaId: ouiaFinalId,
        ouiaSafe: ouiaSafe,
        toggle: /*#__PURE__*/React.createElement(DropdownToggle, _extends({}, toggleProps, {
          isDisabled: isDisabled,
          ouiaId: "".concat(ouiaFinalId, "-toggle"),
          splitButtonItems: [/*#__PURE__*/React.createElement(Fragment, {
            key: "split-checkbox"
          }, hasError ? /*#__PURE__*/React.createElement(DropdownToggleCheckbox, {
            id: id ? "".concat(id, "-toggle-checkbox") : 'toggle-checkbox',
            "aria-label": "Select all",
            onChange: onSelect,
            checked: checked,
            ouiaId: "".concat(ouiaFinalId, "-toggle-checkbox")
          }) : /*#__PURE__*/React.createElement(DropdownToggleCheckbox, {
            id: id ? "".concat(id, "-toggle-checkbox") : 'toggle-checkbox',
            "aria-label": "Select all",
            onChange: onSelect,
            isChecked: checked,
            ouiaId: "".concat(ouiaFinalId, "-toggle-checkbox")
          }, count ? "".concat(count, " selected") : ''))],
          onToggle: this.onToggle
        })),
        isOpen: isOpen,
        dropdownItems: [].concat(_toConsumableArray(count !== undefined && count > 0 ? [/*#__PURE__*/React.createElement(DropdownItem, {
          key: "count",
          isDisabled: true,
          className: !hasError ? 'ins-c-bulk-select__selected' : ''
        }, count, " Selected")] : []), _toConsumableArray(items.map(function (oneItem, key) {
          return /*#__PURE__*/React.createElement(DropdownItem, _extends({
            component: "button",
            key: oneItem.key || key,
            ouiaId: "".concat(ouiaFinalId, "-").concat(oneItem.key || key),
            onClick: function onClick(event) {
              return oneItem.onClick && oneItem.onClick(event, oneItem, key);
            }
          }, oneItem === null || oneItem === void 0 ? void 0 : oneItem.props), oneItem.title);
        })))
      })) : /*#__PURE__*/React.createElement(Checkbox, _extends({}, props, {
        className: classnames(className, 'ins-c-bulk-select'),
        id: "".concat(id, "-checkbox"),
        isChecked: checked,
        onChange: onSelect
      })));
    }
  }]);

  return BulkSelect;
}(Component);

BulkSelect.propTypes = {
  count: PropTypes.number,
  className: PropTypes.string,
  items: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.string,
    onClick: PropTypes.func
  })),
  checked: PropTypes.bool,
  id: PropTypes.string,
  onSelect: PropTypes.func,
  toggleProps: PropTypes.any,
  isDisabled: PropTypes.bool,
  ouiaId: PropTypes.string,
  ouiaSafe: PropTypes.bool
};
BulkSelect.defaultProps = {
  className: '',
  isDisabled: false,
  items: [],
  checked: false,
  onSelect: function onSelect() {
    return undefined;
  },
  ouiaSafe: true
};
export default BulkSelect;