import React from 'react';
import PropTypes from 'prop-types';
import { SortByDirection } from '@patternfly/react-table';
import { Button } from '@patternfly/react-core';
import { SortAmountDownIcon, SortAmountUpIcon } from '@patternfly/react-icons';
export function flipDirection(direction) {
    return direction === SortByDirection.asc ? SortByDirection.desc : SortByDirection.asc;
}
var SortBy = function (_a) {
    var direction = _a.direction, onSortChange = _a.onSortChange;
    return (React.createElement(Button, { variant: "plain", onClick: function (e) { return onSortChange(e, flipDirection(direction)); } }, direction === SortByDirection.asc ? React.createElement(SortAmountUpIcon, { size: "sm" }) : React.createElement(SortAmountDownIcon, { size: "sm" })));
};
SortBy.propTypes = {
    direction: PropTypes.oneOf(Object.values(SortByDirection)),
    onSortChange: PropTypes.func,
};
SortBy.defaultProps = {
    direction: SortByDirection.asc,
    onSortChange: function () { return undefined; },
};
export default SortBy;
//# sourceMappingURL=SortBy.js.map